# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityPolicyResult',
    'AwaitableGetSecurityPolicyResult',
    'get_security_policy',
    'get_security_policy_output',
]

@pulumi.output_type
class GetSecurityPolicyResult:
    """
    A collection of values returned by getSecurityPolicy.
    """
    def __init__(__self__, adaptive_protection_configs=None, advanced_options_configs=None, description=None, effective_labels=None, fingerprint=None, id=None, label_fingerprint=None, labels=None, name=None, project=None, pulumi_labels=None, recaptcha_options_configs=None, rules=None, self_link=None, type=None):
        if adaptive_protection_configs and not isinstance(adaptive_protection_configs, list):
            raise TypeError("Expected argument 'adaptive_protection_configs' to be a list")
        pulumi.set(__self__, "adaptive_protection_configs", adaptive_protection_configs)
        if advanced_options_configs and not isinstance(advanced_options_configs, list):
            raise TypeError("Expected argument 'advanced_options_configs' to be a list")
        pulumi.set(__self__, "advanced_options_configs", advanced_options_configs)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label_fingerprint and not isinstance(label_fingerprint, str):
            raise TypeError("Expected argument 'label_fingerprint' to be a str")
        pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if recaptcha_options_configs and not isinstance(recaptcha_options_configs, list):
            raise TypeError("Expected argument 'recaptcha_options_configs' to be a list")
        pulumi.set(__self__, "recaptcha_options_configs", recaptcha_options_configs)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="adaptiveProtectionConfigs")
    def adaptive_protection_configs(self) -> Sequence['outputs.GetSecurityPolicyAdaptiveProtectionConfigResult']:
        return pulumi.get(self, "adaptive_protection_configs")

    @_builtins.property
    @pulumi.getter(name="advancedOptionsConfigs")
    def advanced_options_configs(self) -> Sequence['outputs.GetSecurityPolicyAdvancedOptionsConfigResult']:
        return pulumi.get(self, "advanced_options_configs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> _builtins.str:
        return pulumi.get(self, "label_fingerprint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="recaptchaOptionsConfigs")
    def recaptcha_options_configs(self) -> Sequence['outputs.GetSecurityPolicyRecaptchaOptionsConfigResult']:
        return pulumi.get(self, "recaptcha_options_configs")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetSecurityPolicyRuleResult']:
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetSecurityPolicyResult(GetSecurityPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyResult(
            adaptive_protection_configs=self.adaptive_protection_configs,
            advanced_options_configs=self.advanced_options_configs,
            description=self.description,
            effective_labels=self.effective_labels,
            fingerprint=self.fingerprint,
            id=self.id,
            label_fingerprint=self.label_fingerprint,
            labels=self.labels,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            recaptcha_options_configs=self.recaptcha_options_configs,
            rules=self.rules,
            self_link=self.self_link,
            type=self.type)


def get_security_policy(name: Optional[_builtins.str] = None,
                        project: Optional[_builtins.str] = None,
                        self_link: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyResult:
    """
    To get more information about Google Compute Security Policy, see:

    * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/securityPolicies)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/armor/docs/configure-security-policies)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    sp1 = gcp.compute.get_security_policy(name="my-policy",
        project="my-project")
    sp2 = gcp.compute.get_security_policy(self_link="https://www.googleapis.com/compute/v1/projects/my-project/global/securityPolicies/my-policy")
    ```


    :param _builtins.str name: The name of the security policy. Provide either this or a `self_link`.
    :param _builtins.str project: The project in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str self_link: The self_link of the security policy. Provide either this or a `name`
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['selfLink'] = self_link
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getSecurityPolicy:getSecurityPolicy', __args__, opts=opts, typ=GetSecurityPolicyResult).value

    return AwaitableGetSecurityPolicyResult(
        adaptive_protection_configs=pulumi.get(__ret__, 'adaptive_protection_configs'),
        advanced_options_configs=pulumi.get(__ret__, 'advanced_options_configs'),
        description=pulumi.get(__ret__, 'description'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        label_fingerprint=pulumi.get(__ret__, 'label_fingerprint'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        recaptcha_options_configs=pulumi.get(__ret__, 'recaptcha_options_configs'),
        rules=pulumi.get(__ret__, 'rules'),
        self_link=pulumi.get(__ret__, 'self_link'),
        type=pulumi.get(__ret__, 'type'))
def get_security_policy_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               self_link: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityPolicyResult]:
    """
    To get more information about Google Compute Security Policy, see:

    * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/securityPolicies)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/armor/docs/configure-security-policies)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    sp1 = gcp.compute.get_security_policy(name="my-policy",
        project="my-project")
    sp2 = gcp.compute.get_security_policy(self_link="https://www.googleapis.com/compute/v1/projects/my-project/global/securityPolicies/my-policy")
    ```


    :param _builtins.str name: The name of the security policy. Provide either this or a `self_link`.
    :param _builtins.str project: The project in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str self_link: The self_link of the security policy. Provide either this or a `name`
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['selfLink'] = self_link
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getSecurityPolicy:getSecurityPolicy', __args__, opts=opts, typ=GetSecurityPolicyResult)
    return __ret__.apply(lambda __response__: GetSecurityPolicyResult(
        adaptive_protection_configs=pulumi.get(__response__, 'adaptive_protection_configs'),
        advanced_options_configs=pulumi.get(__response__, 'advanced_options_configs'),
        description=pulumi.get(__response__, 'description'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        label_fingerprint=pulumi.get(__response__, 'label_fingerprint'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        recaptcha_options_configs=pulumi.get(__response__, 'recaptcha_options_configs'),
        rules=pulumi.get(__response__, 'rules'),
        self_link=pulumi.get(__response__, 'self_link'),
        type=pulumi.get(__response__, 'type')))
