# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSSLPolicyResult',
    'AwaitableGetSSLPolicyResult',
    'get_ssl_policy',
    'get_ssl_policy_output',
]

@pulumi.output_type
class GetSSLPolicyResult:
    """
    A collection of values returned by getSSLPolicy.
    """
    def __init__(__self__, creation_timestamp=None, custom_features=None, description=None, enabled_features=None, fingerprint=None, id=None, min_tls_version=None, name=None, profile=None, project=None, self_link=None):
        if creation_timestamp and not isinstance(creation_timestamp, str):
            raise TypeError("Expected argument 'creation_timestamp' to be a str")
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if custom_features and not isinstance(custom_features, list):
            raise TypeError("Expected argument 'custom_features' to be a list")
        pulumi.set(__self__, "custom_features", custom_features)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled_features and not isinstance(enabled_features, list):
            raise TypeError("Expected argument 'enabled_features' to be a list")
        pulumi.set(__self__, "enabled_features", enabled_features)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if min_tls_version and not isinstance(min_tls_version, str):
            raise TypeError("Expected argument 'min_tls_version' to be a str")
        pulumi.set(__self__, "min_tls_version", min_tls_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if profile and not isinstance(profile, str):
            raise TypeError("Expected argument 'profile' to be a str")
        pulumi.set(__self__, "profile", profile)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> _builtins.str:
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter(name="customFeatures")
    def custom_features(self) -> Sequence[_builtins.str]:
        """
        If the `profile` is `CUSTOM`, these are the custom encryption
        ciphers supported by the profile. If the `profile` is *not* `CUSTOM`, this
        attribute will be empty.
        """
        return pulumi.get(self, "custom_features")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of this SSL Policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enabledFeatures")
    def enabled_features(self) -> Sequence[_builtins.str]:
        """
        The set of enabled encryption ciphers as a result of the policy config
        """
        return pulumi.get(self, "enabled_features")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        """
        Fingerprint of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> _builtins.str:
        """
        The minimum supported TLS version of this policy.
        """
        return pulumi.get(self, "min_tls_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> _builtins.str:
        """
        The Google-curated or custom profile used by this policy.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")


class AwaitableGetSSLPolicyResult(GetSSLPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSSLPolicyResult(
            creation_timestamp=self.creation_timestamp,
            custom_features=self.custom_features,
            description=self.description,
            enabled_features=self.enabled_features,
            fingerprint=self.fingerprint,
            id=self.id,
            min_tls_version=self.min_tls_version,
            name=self.name,
            profile=self.profile,
            project=self.project,
            self_link=self.self_link)


def get_ssl_policy(name: Optional[_builtins.str] = None,
                   project: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSSLPolicyResult:
    """
    Gets an SSL Policy within GCE from its name, for use with Target HTTPS and Target SSL Proxies.
        For more information see [the official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_ssl_policy = gcp.compute.get_ssl_policy(name="production-ssl-policy")
    ```


    :param _builtins.str name: The name of the SSL Policy.
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getSSLPolicy:getSSLPolicy', __args__, opts=opts, typ=GetSSLPolicyResult).value

    return AwaitableGetSSLPolicyResult(
        creation_timestamp=pulumi.get(__ret__, 'creation_timestamp'),
        custom_features=pulumi.get(__ret__, 'custom_features'),
        description=pulumi.get(__ret__, 'description'),
        enabled_features=pulumi.get(__ret__, 'enabled_features'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        min_tls_version=pulumi.get(__ret__, 'min_tls_version'),
        name=pulumi.get(__ret__, 'name'),
        profile=pulumi.get(__ret__, 'profile'),
        project=pulumi.get(__ret__, 'project'),
        self_link=pulumi.get(__ret__, 'self_link'))
def get_ssl_policy_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                          project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSSLPolicyResult]:
    """
    Gets an SSL Policy within GCE from its name, for use with Target HTTPS and Target SSL Proxies.
        For more information see [the official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_ssl_policy = gcp.compute.get_ssl_policy(name="production-ssl-policy")
    ```


    :param _builtins.str name: The name of the SSL Policy.
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getSSLPolicy:getSSLPolicy', __args__, opts=opts, typ=GetSSLPolicyResult)
    return __ret__.apply(lambda __response__: GetSSLPolicyResult(
        creation_timestamp=pulumi.get(__response__, 'creation_timestamp'),
        custom_features=pulumi.get(__response__, 'custom_features'),
        description=pulumi.get(__response__, 'description'),
        enabled_features=pulumi.get(__response__, 'enabled_features'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        min_tls_version=pulumi.get(__response__, 'min_tls_version'),
        name=pulumi.get(__response__, 'name'),
        profile=pulumi.get(__response__, 'profile'),
        project=pulumi.get(__response__, 'project'),
        self_link=pulumi.get(__response__, 'self_link')))
