# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreviewFeatureArgs', 'PreviewFeature']

@pulumi.input_type
class PreviewFeatureArgs:
    def __init__(__self__, *,
                 activation_status: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_operation: Optional[pulumi.Input['PreviewFeatureRolloutOperationArgs']] = None):
        """
        The set of arguments for constructing a PreviewFeature resource.
        :param pulumi.Input[_builtins.str] activation_status: The activation status of the preview feature.
               Possible values are: `ENABLED`, `ACTIVATION_STATE_UNSPECIFIED`.
        :param pulumi.Input[_builtins.str] name: The name of the preview feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['PreviewFeatureRolloutOperationArgs'] rollout_operation: The rollout operation of the feature.
               Structure is documented below.
        """
        pulumi.set(__self__, "activation_status", activation_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rollout_operation is not None:
            pulumi.set(__self__, "rollout_operation", rollout_operation)

    @_builtins.property
    @pulumi.getter(name="activationStatus")
    def activation_status(self) -> pulumi.Input[_builtins.str]:
        """
        The activation status of the preview feature.
        Possible values are: `ENABLED`, `ACTIVATION_STATE_UNSPECIFIED`.
        """
        return pulumi.get(self, "activation_status")

    @activation_status.setter
    def activation_status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "activation_status", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the preview feature.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rolloutOperation")
    def rollout_operation(self) -> Optional[pulumi.Input['PreviewFeatureRolloutOperationArgs']]:
        """
        The rollout operation of the feature.
        Structure is documented below.
        """
        return pulumi.get(self, "rollout_operation")

    @rollout_operation.setter
    def rollout_operation(self, value: Optional[pulumi.Input['PreviewFeatureRolloutOperationArgs']]):
        pulumi.set(self, "rollout_operation", value)


@pulumi.input_type
class _PreviewFeatureState:
    def __init__(__self__, *,
                 activation_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_operation: Optional[pulumi.Input['PreviewFeatureRolloutOperationArgs']] = None):
        """
        Input properties used for looking up and filtering PreviewFeature resources.
        :param pulumi.Input[_builtins.str] activation_status: The activation status of the preview feature.
               Possible values are: `ENABLED`, `ACTIVATION_STATE_UNSPECIFIED`.
        :param pulumi.Input[_builtins.str] name: The name of the preview feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['PreviewFeatureRolloutOperationArgs'] rollout_operation: The rollout operation of the feature.
               Structure is documented below.
        """
        if activation_status is not None:
            pulumi.set(__self__, "activation_status", activation_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rollout_operation is not None:
            pulumi.set(__self__, "rollout_operation", rollout_operation)

    @_builtins.property
    @pulumi.getter(name="activationStatus")
    def activation_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The activation status of the preview feature.
        Possible values are: `ENABLED`, `ACTIVATION_STATE_UNSPECIFIED`.
        """
        return pulumi.get(self, "activation_status")

    @activation_status.setter
    def activation_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activation_status", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the preview feature.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rolloutOperation")
    def rollout_operation(self) -> Optional[pulumi.Input['PreviewFeatureRolloutOperationArgs']]:
        """
        The rollout operation of the feature.
        Structure is documented below.
        """
        return pulumi.get(self, "rollout_operation")

    @rollout_operation.setter
    def rollout_operation(self, value: Optional[pulumi.Input['PreviewFeatureRolloutOperationArgs']]):
        pulumi.set(self, "rollout_operation", value)


@pulumi.type_token("gcp:compute/previewFeature:PreviewFeature")
class PreviewFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_operation: Optional[pulumi.Input[Union['PreviewFeatureRolloutOperationArgs', 'PreviewFeatureRolloutOperationArgsDict']]] = None,
                 __props__=None):
        """
        Represents a single Google Compute Engine preview feature such as Alpha API access, which can be enabled or unspecified for a project.

        To get more information about PreviewFeature, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/previewFeatures)
        * How-to Guides
            * [Use the Compute Engine alpha API](https://cloud.google.com/compute/docs/reference/rest/alpha)

        ## Example Usage

        ### Preview Feature Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_preview_feature = gcp.compute.PreviewFeature("gce_preview_feature",
            name="alpha-api-access",
            activation_status="ACTIVATION_STATE_UNSPECIFIED",
            rollout_operation={
                "rollout_input": {
                    "predefined_rollout_plan": "ROLLOUT_PLAN_FAST_ROLLOUT",
                },
            })
        ```

        ## Import

        PreviewFeature can be imported using any of these accepted formats:

        * `projects/{{project}}/global/previewFeatures/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, PreviewFeature can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/previewFeature:PreviewFeature default projects/{{project}}/global/previewFeatures/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/previewFeature:PreviewFeature default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/previewFeature:PreviewFeature default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activation_status: The activation status of the preview feature.
               Possible values are: `ENABLED`, `ACTIVATION_STATE_UNSPECIFIED`.
        :param pulumi.Input[_builtins.str] name: The name of the preview feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['PreviewFeatureRolloutOperationArgs', 'PreviewFeatureRolloutOperationArgsDict']] rollout_operation: The rollout operation of the feature.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreviewFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a single Google Compute Engine preview feature such as Alpha API access, which can be enabled or unspecified for a project.

        To get more information about PreviewFeature, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/previewFeatures)
        * How-to Guides
            * [Use the Compute Engine alpha API](https://cloud.google.com/compute/docs/reference/rest/alpha)

        ## Example Usage

        ### Preview Feature Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_preview_feature = gcp.compute.PreviewFeature("gce_preview_feature",
            name="alpha-api-access",
            activation_status="ACTIVATION_STATE_UNSPECIFIED",
            rollout_operation={
                "rollout_input": {
                    "predefined_rollout_plan": "ROLLOUT_PLAN_FAST_ROLLOUT",
                },
            })
        ```

        ## Import

        PreviewFeature can be imported using any of these accepted formats:

        * `projects/{{project}}/global/previewFeatures/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, PreviewFeature can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/previewFeature:PreviewFeature default projects/{{project}}/global/previewFeatures/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/previewFeature:PreviewFeature default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/previewFeature:PreviewFeature default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PreviewFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreviewFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_operation: Optional[pulumi.Input[Union['PreviewFeatureRolloutOperationArgs', 'PreviewFeatureRolloutOperationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreviewFeatureArgs.__new__(PreviewFeatureArgs)

            if activation_status is None and not opts.urn:
                raise TypeError("Missing required property 'activation_status'")
            __props__.__dict__["activation_status"] = activation_status
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["rollout_operation"] = rollout_operation
        super(PreviewFeature, __self__).__init__(
            'gcp:compute/previewFeature:PreviewFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_status: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            rollout_operation: Optional[pulumi.Input[Union['PreviewFeatureRolloutOperationArgs', 'PreviewFeatureRolloutOperationArgsDict']]] = None) -> 'PreviewFeature':
        """
        Get an existing PreviewFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activation_status: The activation status of the preview feature.
               Possible values are: `ENABLED`, `ACTIVATION_STATE_UNSPECIFIED`.
        :param pulumi.Input[_builtins.str] name: The name of the preview feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['PreviewFeatureRolloutOperationArgs', 'PreviewFeatureRolloutOperationArgsDict']] rollout_operation: The rollout operation of the feature.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreviewFeatureState.__new__(_PreviewFeatureState)

        __props__.__dict__["activation_status"] = activation_status
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["rollout_operation"] = rollout_operation
        return PreviewFeature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activationStatus")
    def activation_status(self) -> pulumi.Output[_builtins.str]:
        """
        The activation status of the preview feature.
        Possible values are: `ENABLED`, `ACTIVATION_STATE_UNSPECIFIED`.
        """
        return pulumi.get(self, "activation_status")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the preview feature.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="rolloutOperation")
    def rollout_operation(self) -> pulumi.Output[Optional['outputs.PreviewFeatureRolloutOperation']]:
        """
        The rollout operation of the feature.
        Structure is documented below.
        """
        return pulumi.get(self, "rollout_operation")

