# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProjectMetadataArgs', 'ProjectMetadata']

@pulumi.input_type
class ProjectMetadataArgs:
    def __init__(__self__, *,
                 metadata: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProjectMetadata resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A series of key value pairs.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        """
        pulumi.set(__self__, "metadata", metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        A series of key value pairs.

        - - -
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ProjectMetadataState:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectMetadata resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A series of key value pairs.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A series of key value pairs.

        - - -
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:compute/projectMetadata:ProjectMetadata")
class ProjectMetadata(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Authoritatively manages metadata common to all instances for a project in GCE. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/storing-retrieving-metadata)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/projects/setCommonInstanceMetadata).

        > **Note:**  This resource manages all project-level metadata including project-level ssh keys.
        Keys unset in config but set on the server will be removed. If you want to manage only single
        key/value pairs within the project metadata rather than the entire set, then use
        google_compute_project_metadata_item.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.ProjectMetadata("default", metadata={
            "foo": "bar",
            "fizz": "buzz",
            "13": "42",
        })
        ```

        ### Adding An SSH Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        #A key set in project metadata is propagated to every instance in the project.
        #This resource configuration is prone to causing frequent diffs as Google adds SSH Keys when the SSH Button is pressed in the console.
        #It is better to use OS Login instead.
        my_ssh_key = gcp.compute.ProjectMetadata("my_ssh_key", metadata={
            "ssh-keys": \"\"\"      dev:ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAILg6UtHDNyMNAh0GjaytsJdrUxjtLy3APXqZfNZhvCeT dev
              foo:ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAILg6UtHDNyMNAh0GjaytsJdrUxjtLy3APXqZfNZhvCeT bar
        \"\"\",
        })
        ```

        ## Import

        Project metadata can be imported using the project ID:

        * `{{project_id}}`

        When using the `pulumi import` command, project metadata can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/projectMetadata:ProjectMetadata default {{project_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A series of key value pairs.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectMetadataArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Authoritatively manages metadata common to all instances for a project in GCE. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/storing-retrieving-metadata)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/projects/setCommonInstanceMetadata).

        > **Note:**  This resource manages all project-level metadata including project-level ssh keys.
        Keys unset in config but set on the server will be removed. If you want to manage only single
        key/value pairs within the project metadata rather than the entire set, then use
        google_compute_project_metadata_item.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.ProjectMetadata("default", metadata={
            "foo": "bar",
            "fizz": "buzz",
            "13": "42",
        })
        ```

        ### Adding An SSH Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        #A key set in project metadata is propagated to every instance in the project.
        #This resource configuration is prone to causing frequent diffs as Google adds SSH Keys when the SSH Button is pressed in the console.
        #It is better to use OS Login instead.
        my_ssh_key = gcp.compute.ProjectMetadata("my_ssh_key", metadata={
            "ssh-keys": \"\"\"      dev:ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAILg6UtHDNyMNAh0GjaytsJdrUxjtLy3APXqZfNZhvCeT dev
              foo:ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAILg6UtHDNyMNAh0GjaytsJdrUxjtLy3APXqZfNZhvCeT bar
        \"\"\",
        })
        ```

        ## Import

        Project metadata can be imported using the project ID:

        * `{{project_id}}`

        When using the `pulumi import` command, project metadata can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/projectMetadata:ProjectMetadata default {{project_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ProjectMetadataArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectMetadataArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectMetadataArgs.__new__(ProjectMetadataArgs)

            if metadata is None and not opts.urn:
                raise TypeError("Missing required property 'metadata'")
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["project"] = project
        super(ProjectMetadata, __self__).__init__(
            'gcp:compute/projectMetadata:ProjectMetadata',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProjectMetadata':
        """
        Get an existing ProjectMetadata resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A series of key value pairs.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectMetadataState.__new__(_ProjectMetadataState)

        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["project"] = project
        return ProjectMetadata(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A series of key value pairs.

        - - -
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

