# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegionHealthAggregationPolicyArgs', 'RegionHealthAggregationPolicy']

@pulumi.input_type
class RegionHealthAggregationPolicyArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_percent_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 min_healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegionHealthAggregationPolicy resource.
        :param pulumi.Input[_builtins.str] region: URL of the region where the health aggregation policy resides.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you
               create the resource.
        :param pulumi.Input[_builtins.int] healthy_percent_threshold: Can only be set if the `policyType` field is
               `BACKEND_SERVICE_POLICY`. Specifies the threshold (as a
               percentage) of healthy endpoints required in order to consider the
               aggregated health result HEALTHY. Defaults to `60`. Must be in
               range [0, 100]. Not applicable if the `policyType` field is
               `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
               and will be set to the default if unspecified. Note that both this
               threshold and `minHealthyThreshold` must be satisfied in order
               for HEALTHY to be the aggregated result. "Endpoints" refers to network
               endpoints within a Network Endpoint Group or instances within an Instance
               Group.
        :param pulumi.Input[_builtins.int] min_healthy_threshold: Can only be set if the `policyType` field is
               `BACKEND_SERVICE_POLICY`. Specifies the minimum number of
               healthy endpoints required in order to consider the aggregated health
               result HEALTHY. Defaults to `1`. Must be positive. Not
               applicable if the `policyType` field is
               `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
               and will be set to the default if unspecified. Note that both this
               threshold and `healthyPercentThreshold` must be satisfied in
               order for HEALTHY to be the aggregated result. "Endpoints" refers to
               network endpoints within a Network Endpoint Group or instances within an
               Instance Group.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with RFC1035.
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
        :param pulumi.Input[_builtins.str] policy_type: Specifies the type of the healthAggregationPolicy. The only allowed value
               for global resources is `DNS_PUBLIC_IP_POLICY`. The only allowed
               value for regional resources is `BACKEND_SERVICE_POLICY`. Must
               be specified when the healthAggregationPolicy is created, and cannot be
               mutated.
               Default value is `BACKEND_SERVICE_POLICY`.
               Possible values are: `DNS_PUBLIC_IP_POLICY`, `BACKEND_SERVICE_POLICY`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "region", region)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if healthy_percent_threshold is not None:
            pulumi.set(__self__, "healthy_percent_threshold", healthy_percent_threshold)
        if min_healthy_threshold is not None:
            pulumi.set(__self__, "min_healthy_threshold", min_healthy_threshold)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        URL of the region where the health aggregation policy resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you
        create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="healthyPercentThreshold")
    def healthy_percent_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Can only be set if the `policyType` field is
        `BACKEND_SERVICE_POLICY`. Specifies the threshold (as a
        percentage) of healthy endpoints required in order to consider the
        aggregated health result HEALTHY. Defaults to `60`. Must be in
        range [0, 100]. Not applicable if the `policyType` field is
        `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
        and will be set to the default if unspecified. Note that both this
        threshold and `minHealthyThreshold` must be satisfied in order
        for HEALTHY to be the aggregated result. "Endpoints" refers to network
        endpoints within a Network Endpoint Group or instances within an Instance
        Group.
        """
        return pulumi.get(self, "healthy_percent_threshold")

    @healthy_percent_threshold.setter
    def healthy_percent_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_percent_threshold", value)

    @_builtins.property
    @pulumi.getter(name="minHealthyThreshold")
    def min_healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Can only be set if the `policyType` field is
        `BACKEND_SERVICE_POLICY`. Specifies the minimum number of
        healthy endpoints required in order to consider the aggregated health
        result HEALTHY. Defaults to `1`. Must be positive. Not
        applicable if the `policyType` field is
        `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
        and will be set to the default if unspecified. Note that both this
        threshold and `healthyPercentThreshold` must be satisfied in
        order for HEALTHY to be the aggregated result. "Endpoints" refers to
        network endpoints within a Network Endpoint Group or instances within an
        Instance Group.
        """
        return pulumi.get(self, "min_healthy_threshold")

    @min_healthy_threshold.setter
    def min_healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_healthy_threshold", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with RFC1035.
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the healthAggregationPolicy. The only allowed value
        for global resources is `DNS_PUBLIC_IP_POLICY`. The only allowed
        value for regional resources is `BACKEND_SERVICE_POLICY`. Must
        be specified when the healthAggregationPolicy is created, and cannot be
        mutated.
        Default value is `BACKEND_SERVICE_POLICY`.
        Possible values are: `DNS_PUBLIC_IP_POLICY`, `BACKEND_SERVICE_POLICY`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RegionHealthAggregationPolicyState:
    def __init__(__self__, *,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_percent_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 min_healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link_with_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionHealthAggregationPolicy resources.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you
               create the resource.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object.
               This field is used in optimistic locking. This field will be ignored when
               inserting a `HealthAggregationPolicy`. An up-to-date fingerprint
               must be provided in order to patch the RegionHealthAggregationPolicy; Otherwise,
               the request will fail with error `412 conditionNotMet`. To see
               the latest fingerprint, make a `get()` request to retrieve the
               RegionHealthAggregationPolicy.
        :param pulumi.Input[_builtins.int] healthy_percent_threshold: Can only be set if the `policyType` field is
               `BACKEND_SERVICE_POLICY`. Specifies the threshold (as a
               percentage) of healthy endpoints required in order to consider the
               aggregated health result HEALTHY. Defaults to `60`. Must be in
               range [0, 100]. Not applicable if the `policyType` field is
               `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
               and will be set to the default if unspecified. Note that both this
               threshold and `minHealthyThreshold` must be satisfied in order
               for HEALTHY to be the aggregated result. "Endpoints" refers to network
               endpoints within a Network Endpoint Group or instances within an Instance
               Group.
        :param pulumi.Input[_builtins.int] min_healthy_threshold: Can only be set if the `policyType` field is
               `BACKEND_SERVICE_POLICY`. Specifies the minimum number of
               healthy endpoints required in order to consider the aggregated health
               result HEALTHY. Defaults to `1`. Must be positive. Not
               applicable if the `policyType` field is
               `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
               and will be set to the default if unspecified. Note that both this
               threshold and `healthyPercentThreshold` must be satisfied in
               order for HEALTHY to be the aggregated result. "Endpoints" refers to
               network endpoints within a Network Endpoint Group or instances within an
               Instance Group.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with RFC1035.
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
        :param pulumi.Input[_builtins.str] policy_type: Specifies the type of the healthAggregationPolicy. The only allowed value
               for global resources is `DNS_PUBLIC_IP_POLICY`. The only allowed
               value for regional resources is `BACKEND_SERVICE_POLICY`. Must
               be specified when the healthAggregationPolicy is created, and cannot be
               mutated.
               Default value is `BACKEND_SERVICE_POLICY`.
               Possible values are: `DNS_PUBLIC_IP_POLICY`, `BACKEND_SERVICE_POLICY`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: URL of the region where the health aggregation policy resides.
        :param pulumi.Input[_builtins.str] self_link_with_id: Server-defined URL with id for the resource.
        """
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if healthy_percent_threshold is not None:
            pulumi.set(__self__, "healthy_percent_threshold", healthy_percent_threshold)
        if min_healthy_threshold is not None:
            pulumi.set(__self__, "min_healthy_threshold", min_healthy_threshold)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link_with_id is not None:
            pulumi.set(__self__, "self_link_with_id", self_link_with_id)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you
        create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object.
        This field is used in optimistic locking. This field will be ignored when
        inserting a `HealthAggregationPolicy`. An up-to-date fingerprint
        must be provided in order to patch the RegionHealthAggregationPolicy; Otherwise,
        the request will fail with error `412 conditionNotMet`. To see
        the latest fingerprint, make a `get()` request to retrieve the
        RegionHealthAggregationPolicy.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="healthyPercentThreshold")
    def healthy_percent_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Can only be set if the `policyType` field is
        `BACKEND_SERVICE_POLICY`. Specifies the threshold (as a
        percentage) of healthy endpoints required in order to consider the
        aggregated health result HEALTHY. Defaults to `60`. Must be in
        range [0, 100]. Not applicable if the `policyType` field is
        `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
        and will be set to the default if unspecified. Note that both this
        threshold and `minHealthyThreshold` must be satisfied in order
        for HEALTHY to be the aggregated result. "Endpoints" refers to network
        endpoints within a Network Endpoint Group or instances within an Instance
        Group.
        """
        return pulumi.get(self, "healthy_percent_threshold")

    @healthy_percent_threshold.setter
    def healthy_percent_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_percent_threshold", value)

    @_builtins.property
    @pulumi.getter(name="minHealthyThreshold")
    def min_healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Can only be set if the `policyType` field is
        `BACKEND_SERVICE_POLICY`. Specifies the minimum number of
        healthy endpoints required in order to consider the aggregated health
        result HEALTHY. Defaults to `1`. Must be positive. Not
        applicable if the `policyType` field is
        `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
        and will be set to the default if unspecified. Note that both this
        threshold and `healthyPercentThreshold` must be satisfied in
        order for HEALTHY to be the aggregated result. "Endpoints" refers to
        network endpoints within a Network Endpoint Group or instances within an
        Instance Group.
        """
        return pulumi.get(self, "min_healthy_threshold")

    @min_healthy_threshold.setter
    def min_healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_healthy_threshold", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with RFC1035.
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the healthAggregationPolicy. The only allowed value
        for global resources is `DNS_PUBLIC_IP_POLICY`. The only allowed
        value for regional resources is `BACKEND_SERVICE_POLICY`. Must
        be specified when the healthAggregationPolicy is created, and cannot be
        mutated.
        Default value is `BACKEND_SERVICE_POLICY`.
        Possible values are: `DNS_PUBLIC_IP_POLICY`, `BACKEND_SERVICE_POLICY`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the region where the health aggregation policy resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-defined URL with id for the resource.
        """
        return pulumi.get(self, "self_link_with_id")

    @self_link_with_id.setter
    def self_link_with_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link_with_id", value)


@pulumi.type_token("gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy")
class RegionHealthAggregationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_percent_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 min_healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The Health Aggregation Policy specifies how to aggregate the service's constituent source health status to determine an aggregated health status result for the service.  For example, you can specify a criteria such as “Consider the Health Source as `Healthy` if there are at least 5 healthy backend endpoints”. Or, you can specify a criteria like “Consider the Health Source as `Healthy` if minimum 60% of endpoints in the Backend are healthy”. The Health Aggregation Policy is applied to each Health Source (e.g. Backend Service) individually.

        To get more information about RegionHealthAggregationPolicy, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/healthAggregationPolicies)
        * How-to Guides
            * [Health checks overview](https://cloud.google.com/load-balancing/docs/health-check-concepts)

        ## Example Usage

        ### Compute Region Health Aggregation Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_test_health_aggregation_policy = gcp.compute.RegionHealthAggregationPolicy("example_test_health_aggregation_policy",
            name="test-health-aggregation-policy",
            description="Example health aggregation policy basic",
            region="us-central1")
        ```

        ## Import

        RegionHealthAggregationPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/healthAggregationPolicies/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionHealthAggregationPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy default projects/{{project}}/regions/{{region}}/healthAggregationPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you
               create the resource.
        :param pulumi.Input[_builtins.int] healthy_percent_threshold: Can only be set if the `policyType` field is
               `BACKEND_SERVICE_POLICY`. Specifies the threshold (as a
               percentage) of healthy endpoints required in order to consider the
               aggregated health result HEALTHY. Defaults to `60`. Must be in
               range [0, 100]. Not applicable if the `policyType` field is
               `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
               and will be set to the default if unspecified. Note that both this
               threshold and `minHealthyThreshold` must be satisfied in order
               for HEALTHY to be the aggregated result. "Endpoints" refers to network
               endpoints within a Network Endpoint Group or instances within an Instance
               Group.
        :param pulumi.Input[_builtins.int] min_healthy_threshold: Can only be set if the `policyType` field is
               `BACKEND_SERVICE_POLICY`. Specifies the minimum number of
               healthy endpoints required in order to consider the aggregated health
               result HEALTHY. Defaults to `1`. Must be positive. Not
               applicable if the `policyType` field is
               `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
               and will be set to the default if unspecified. Note that both this
               threshold and `healthyPercentThreshold` must be satisfied in
               order for HEALTHY to be the aggregated result. "Endpoints" refers to
               network endpoints within a Network Endpoint Group or instances within an
               Instance Group.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with RFC1035.
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
        :param pulumi.Input[_builtins.str] policy_type: Specifies the type of the healthAggregationPolicy. The only allowed value
               for global resources is `DNS_PUBLIC_IP_POLICY`. The only allowed
               value for regional resources is `BACKEND_SERVICE_POLICY`. Must
               be specified when the healthAggregationPolicy is created, and cannot be
               mutated.
               Default value is `BACKEND_SERVICE_POLICY`.
               Possible values are: `DNS_PUBLIC_IP_POLICY`, `BACKEND_SERVICE_POLICY`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: URL of the region where the health aggregation policy resides.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionHealthAggregationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Health Aggregation Policy specifies how to aggregate the service's constituent source health status to determine an aggregated health status result for the service.  For example, you can specify a criteria such as “Consider the Health Source as `Healthy` if there are at least 5 healthy backend endpoints”. Or, you can specify a criteria like “Consider the Health Source as `Healthy` if minimum 60% of endpoints in the Backend are healthy”. The Health Aggregation Policy is applied to each Health Source (e.g. Backend Service) individually.

        To get more information about RegionHealthAggregationPolicy, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/healthAggregationPolicies)
        * How-to Guides
            * [Health checks overview](https://cloud.google.com/load-balancing/docs/health-check-concepts)

        ## Example Usage

        ### Compute Region Health Aggregation Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_test_health_aggregation_policy = gcp.compute.RegionHealthAggregationPolicy("example_test_health_aggregation_policy",
            name="test-health-aggregation-policy",
            description="Example health aggregation policy basic",
            region="us-central1")
        ```

        ## Import

        RegionHealthAggregationPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/healthAggregationPolicies/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionHealthAggregationPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy default projects/{{project}}/regions/{{region}}/healthAggregationPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionHealthAggregationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionHealthAggregationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_percent_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 min_healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionHealthAggregationPolicyArgs.__new__(RegionHealthAggregationPolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["healthy_percent_threshold"] = healthy_percent_threshold
            __props__.__dict__["min_healthy_threshold"] = min_healthy_threshold
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_type"] = policy_type
            __props__.__dict__["project"] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["self_link_with_id"] = None
        super(RegionHealthAggregationPolicy, __self__).__init__(
            'gcp:compute/regionHealthAggregationPolicy:RegionHealthAggregationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            healthy_percent_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            min_healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            self_link_with_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegionHealthAggregationPolicy':
        """
        Get an existing RegionHealthAggregationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you
               create the resource.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object.
               This field is used in optimistic locking. This field will be ignored when
               inserting a `HealthAggregationPolicy`. An up-to-date fingerprint
               must be provided in order to patch the RegionHealthAggregationPolicy; Otherwise,
               the request will fail with error `412 conditionNotMet`. To see
               the latest fingerprint, make a `get()` request to retrieve the
               RegionHealthAggregationPolicy.
        :param pulumi.Input[_builtins.int] healthy_percent_threshold: Can only be set if the `policyType` field is
               `BACKEND_SERVICE_POLICY`. Specifies the threshold (as a
               percentage) of healthy endpoints required in order to consider the
               aggregated health result HEALTHY. Defaults to `60`. Must be in
               range [0, 100]. Not applicable if the `policyType` field is
               `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
               and will be set to the default if unspecified. Note that both this
               threshold and `minHealthyThreshold` must be satisfied in order
               for HEALTHY to be the aggregated result. "Endpoints" refers to network
               endpoints within a Network Endpoint Group or instances within an Instance
               Group.
        :param pulumi.Input[_builtins.int] min_healthy_threshold: Can only be set if the `policyType` field is
               `BACKEND_SERVICE_POLICY`. Specifies the minimum number of
               healthy endpoints required in order to consider the aggregated health
               result HEALTHY. Defaults to `1`. Must be positive. Not
               applicable if the `policyType` field is
               `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
               and will be set to the default if unspecified. Note that both this
               threshold and `healthyPercentThreshold` must be satisfied in
               order for HEALTHY to be the aggregated result. "Endpoints" refers to
               network endpoints within a Network Endpoint Group or instances within an
               Instance Group.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with RFC1035.
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
        :param pulumi.Input[_builtins.str] policy_type: Specifies the type of the healthAggregationPolicy. The only allowed value
               for global resources is `DNS_PUBLIC_IP_POLICY`. The only allowed
               value for regional resources is `BACKEND_SERVICE_POLICY`. Must
               be specified when the healthAggregationPolicy is created, and cannot be
               mutated.
               Default value is `BACKEND_SERVICE_POLICY`.
               Possible values are: `DNS_PUBLIC_IP_POLICY`, `BACKEND_SERVICE_POLICY`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: URL of the region where the health aggregation policy resides.
        :param pulumi.Input[_builtins.str] self_link_with_id: Server-defined URL with id for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionHealthAggregationPolicyState.__new__(_RegionHealthAggregationPolicyState)

        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["healthy_percent_threshold"] = healthy_percent_threshold
        __props__.__dict__["min_healthy_threshold"] = min_healthy_threshold
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link_with_id"] = self_link_with_id
        return RegionHealthAggregationPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you
        create the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object.
        This field is used in optimistic locking. This field will be ignored when
        inserting a `HealthAggregationPolicy`. An up-to-date fingerprint
        must be provided in order to patch the RegionHealthAggregationPolicy; Otherwise,
        the request will fail with error `412 conditionNotMet`. To see
        the latest fingerprint, make a `get()` request to retrieve the
        RegionHealthAggregationPolicy.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="healthyPercentThreshold")
    def healthy_percent_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Can only be set if the `policyType` field is
        `BACKEND_SERVICE_POLICY`. Specifies the threshold (as a
        percentage) of healthy endpoints required in order to consider the
        aggregated health result HEALTHY. Defaults to `60`. Must be in
        range [0, 100]. Not applicable if the `policyType` field is
        `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
        and will be set to the default if unspecified. Note that both this
        threshold and `minHealthyThreshold` must be satisfied in order
        for HEALTHY to be the aggregated result. "Endpoints" refers to network
        endpoints within a Network Endpoint Group or instances within an Instance
        Group.
        """
        return pulumi.get(self, "healthy_percent_threshold")

    @_builtins.property
    @pulumi.getter(name="minHealthyThreshold")
    def min_healthy_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Can only be set if the `policyType` field is
        `BACKEND_SERVICE_POLICY`. Specifies the minimum number of
        healthy endpoints required in order to consider the aggregated health
        result HEALTHY. Defaults to `1`. Must be positive. Not
        applicable if the `policyType` field is
        `DNB_PUBLIC_IP_POLICY`. Can be mutated. This field is optional,
        and will be set to the default if unspecified. Note that both this
        threshold and `healthyPercentThreshold` must be satisfied in
        order for HEALTHY to be the aggregated result. "Endpoints" refers to
        network endpoints within a Network Endpoint Group or instances within an
        Instance Group.
        """
        return pulumi.get(self, "min_healthy_threshold")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with RFC1035.
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of the healthAggregationPolicy. The only allowed value
        for global resources is `DNS_PUBLIC_IP_POLICY`. The only allowed
        value for regional resources is `BACKEND_SERVICE_POLICY`. Must
        be specified when the healthAggregationPolicy is created, and cannot be
        mutated.
        Default value is `BACKEND_SERVICE_POLICY`.
        Possible values are: `DNS_PUBLIC_IP_POLICY`, `BACKEND_SERVICE_POLICY`.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the region where the health aggregation policy resides.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[_builtins.str]:
        """
        Server-defined URL with id for the resource.
        """
        return pulumi.get(self, "self_link_with_id")

