# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouterInterfaceArgs', 'RouterInterface']

@pulumi.input_type
class RouterInterfaceArgs:
    def __init__(__self__, *,
                 router: pulumi.Input[_builtins.str],
                 interconnect_attachment: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redundant_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_tunnel: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RouterInterface resource.
        :param pulumi.Input[_builtins.str] router: The name of the router this interface will be attached to.
               Changing this forces a new interface to be created.
               
               In addition to the above required fields, a router interface must have specified either `ip_range` or exactly one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork`, or both.
               
               - - -
        :param pulumi.Input[_builtins.str] interconnect_attachment: The name or resource link to the
               VLAN interconnect for this interface. Changing this forces a new interface to
               be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        :param pulumi.Input[_builtins.str] ip_range: IP address and range of the interface. The IP range must be
               in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] ip_version: IP version of this interface. Can be either IPV4 or IPV6.
        :param pulumi.Input[_builtins.str] name: A unique name for the interface, required by GCE. Changing
               this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The regional private internal IP address that is used
               to establish BGP sessions to a VM instance acting as a third-party Router Appliance. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which this interface's routerbelongs.
               If it is not provided, the provider project is used. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] redundant_interface: The name of the interface that is redundant to
               this interface. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] region: The region this interface's router sits in.
               If not specified, the project region will be used. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] subnetwork: The URI of the subnetwork resource that this interface
               belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here. Changing this forces a new interface to be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        :param pulumi.Input[_builtins.str] vpn_tunnel: The name or resource link to the VPN tunnel this
               interface will be linked to. Changing this forces a new interface to be created. Only
               one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        pulumi.set(__self__, "router", router)
        if interconnect_attachment is not None:
            pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if redundant_interface is not None:
            pulumi.set(__self__, "redundant_interface", redundant_interface)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if vpn_tunnel is not None:
            pulumi.set(__self__, "vpn_tunnel", vpn_tunnel)

    @_builtins.property
    @pulumi.getter
    def router(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the router this interface will be attached to.
        Changing this forces a new interface to be created.

        In addition to the above required fields, a router interface must have specified either `ip_range` or exactly one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork`, or both.

        - - -
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "router", value)

    @_builtins.property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or resource link to the
        VLAN interconnect for this interface. Changing this forces a new interface to
        be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "interconnect_attachment")

    @interconnect_attachment.setter
    def interconnect_attachment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interconnect_attachment", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address and range of the interface. The IP range must be
        in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP version of this interface. Can be either IPV4 or IPV6.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name for the interface, required by GCE. Changing
        this forces a new interface to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The regional private internal IP address that is used
        to establish BGP sessions to a VM instance acting as a third-party Router Appliance. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which this interface's routerbelongs.
        If it is not provided, the provider project is used. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="redundantInterface")
    def redundant_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the interface that is redundant to
        this interface. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "redundant_interface")

    @redundant_interface.setter
    def redundant_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundant_interface", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region this interface's router sits in.
        If not specified, the project region will be used. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the subnetwork resource that this interface
        belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here. Changing this forces a new interface to be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @_builtins.property
    @pulumi.getter(name="vpnTunnel")
    def vpn_tunnel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or resource link to the VPN tunnel this
        interface will be linked to. Changing this forces a new interface to be created. Only
        one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "vpn_tunnel")

    @vpn_tunnel.setter
    def vpn_tunnel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_tunnel", value)


@pulumi.input_type
class _RouterInterfaceState:
    def __init__(__self__, *,
                 interconnect_attachment: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redundant_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_tunnel: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouterInterface resources.
        :param pulumi.Input[_builtins.str] interconnect_attachment: The name or resource link to the
               VLAN interconnect for this interface. Changing this forces a new interface to
               be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        :param pulumi.Input[_builtins.str] ip_range: IP address and range of the interface. The IP range must be
               in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] ip_version: IP version of this interface. Can be either IPV4 or IPV6.
        :param pulumi.Input[_builtins.str] name: A unique name for the interface, required by GCE. Changing
               this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The regional private internal IP address that is used
               to establish BGP sessions to a VM instance acting as a third-party Router Appliance. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which this interface's routerbelongs.
               If it is not provided, the provider project is used. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] redundant_interface: The name of the interface that is redundant to
               this interface. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] region: The region this interface's router sits in.
               If not specified, the project region will be used. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] router: The name of the router this interface will be attached to.
               Changing this forces a new interface to be created.
               
               In addition to the above required fields, a router interface must have specified either `ip_range` or exactly one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork`, or both.
               
               - - -
        :param pulumi.Input[_builtins.str] subnetwork: The URI of the subnetwork resource that this interface
               belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here. Changing this forces a new interface to be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        :param pulumi.Input[_builtins.str] vpn_tunnel: The name or resource link to the VPN tunnel this
               interface will be linked to. Changing this forces a new interface to be created. Only
               one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        if interconnect_attachment is not None:
            pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if redundant_interface is not None:
            pulumi.set(__self__, "redundant_interface", redundant_interface)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if vpn_tunnel is not None:
            pulumi.set(__self__, "vpn_tunnel", vpn_tunnel)

    @_builtins.property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or resource link to the
        VLAN interconnect for this interface. Changing this forces a new interface to
        be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "interconnect_attachment")

    @interconnect_attachment.setter
    def interconnect_attachment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interconnect_attachment", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address and range of the interface. The IP range must be
        in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP version of this interface. Can be either IPV4 or IPV6.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name for the interface, required by GCE. Changing
        this forces a new interface to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The regional private internal IP address that is used
        to establish BGP sessions to a VM instance acting as a third-party Router Appliance. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which this interface's routerbelongs.
        If it is not provided, the provider project is used. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="redundantInterface")
    def redundant_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the interface that is redundant to
        this interface. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "redundant_interface")

    @redundant_interface.setter
    def redundant_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundant_interface", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region this interface's router sits in.
        If not specified, the project region will be used. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the router this interface will be attached to.
        Changing this forces a new interface to be created.

        In addition to the above required fields, a router interface must have specified either `ip_range` or exactly one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork`, or both.

        - - -
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router", value)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the subnetwork resource that this interface
        belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here. Changing this forces a new interface to be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @_builtins.property
    @pulumi.getter(name="vpnTunnel")
    def vpn_tunnel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or resource link to the VPN tunnel this
        interface will be linked to. Changing this forces a new interface to be created. Only
        one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "vpn_tunnel")

    @vpn_tunnel.setter
    def vpn_tunnel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_tunnel", value)


@pulumi.type_token("gcp:compute/routerInterface:RouterInterface")
class RouterInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interconnect_attachment: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redundant_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cloud Router interface. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/cloudrouter)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/routers).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar = gcp.compute.RouterInterface("foobar",
            name="interface-1",
            router="router-1",
            region="us-central1",
            ip_range="169.254.1.1/30",
            vpn_tunnel="tunnel-1")
        ```

        ## Import

        Router interfaces can be imported using the `project` (optional), `region`, `router`, and `name`, e.g.

        * `{{project_id}}/{{region}}/{{router}}/{{name}}`

        * `{{region}}/{{router}}/{{name}}`

        When using the `pulumi import` command, router interfaces can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerInterface:RouterInterface default {{project_id}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerInterface:RouterInterface default {{region}}/{{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] interconnect_attachment: The name or resource link to the
               VLAN interconnect for this interface. Changing this forces a new interface to
               be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        :param pulumi.Input[_builtins.str] ip_range: IP address and range of the interface. The IP range must be
               in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] ip_version: IP version of this interface. Can be either IPV4 or IPV6.
        :param pulumi.Input[_builtins.str] name: A unique name for the interface, required by GCE. Changing
               this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The regional private internal IP address that is used
               to establish BGP sessions to a VM instance acting as a third-party Router Appliance. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which this interface's routerbelongs.
               If it is not provided, the provider project is used. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] redundant_interface: The name of the interface that is redundant to
               this interface. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] region: The region this interface's router sits in.
               If not specified, the project region will be used. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] router: The name of the router this interface will be attached to.
               Changing this forces a new interface to be created.
               
               In addition to the above required fields, a router interface must have specified either `ip_range` or exactly one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork`, or both.
               
               - - -
        :param pulumi.Input[_builtins.str] subnetwork: The URI of the subnetwork resource that this interface
               belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here. Changing this forces a new interface to be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        :param pulumi.Input[_builtins.str] vpn_tunnel: The name or resource link to the VPN tunnel this
               interface will be linked to. Changing this forces a new interface to be created. Only
               one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cloud Router interface. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/cloudrouter)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/routers).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar = gcp.compute.RouterInterface("foobar",
            name="interface-1",
            router="router-1",
            region="us-central1",
            ip_range="169.254.1.1/30",
            vpn_tunnel="tunnel-1")
        ```

        ## Import

        Router interfaces can be imported using the `project` (optional), `region`, `router`, and `name`, e.g.

        * `{{project_id}}/{{region}}/{{router}}/{{name}}`

        * `{{region}}/{{router}}/{{name}}`

        When using the `pulumi import` command, router interfaces can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerInterface:RouterInterface default {{project_id}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerInterface:RouterInterface default {{region}}/{{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RouterInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interconnect_attachment: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redundant_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterInterfaceArgs.__new__(RouterInterfaceArgs)

            __props__.__dict__["interconnect_attachment"] = interconnect_attachment
            __props__.__dict__["ip_range"] = ip_range
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["name"] = name
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["project"] = project
            __props__.__dict__["redundant_interface"] = redundant_interface
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            __props__.__dict__["subnetwork"] = subnetwork
            __props__.__dict__["vpn_tunnel"] = vpn_tunnel
        super(RouterInterface, __self__).__init__(
            'gcp:compute/routerInterface:RouterInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            interconnect_attachment: Optional[pulumi.Input[_builtins.str]] = None,
            ip_range: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            redundant_interface: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            router: Optional[pulumi.Input[_builtins.str]] = None,
            subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_tunnel: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouterInterface':
        """
        Get an existing RouterInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] interconnect_attachment: The name or resource link to the
               VLAN interconnect for this interface. Changing this forces a new interface to
               be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        :param pulumi.Input[_builtins.str] ip_range: IP address and range of the interface. The IP range must be
               in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] ip_version: IP version of this interface. Can be either IPV4 or IPV6.
        :param pulumi.Input[_builtins.str] name: A unique name for the interface, required by GCE. Changing
               this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The regional private internal IP address that is used
               to establish BGP sessions to a VM instance acting as a third-party Router Appliance. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which this interface's routerbelongs.
               If it is not provided, the provider project is used. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] redundant_interface: The name of the interface that is redundant to
               this interface. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] region: The region this interface's router sits in.
               If not specified, the project region will be used. Changing this forces a new interface to be created.
        :param pulumi.Input[_builtins.str] router: The name of the router this interface will be attached to.
               Changing this forces a new interface to be created.
               
               In addition to the above required fields, a router interface must have specified either `ip_range` or exactly one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork`, or both.
               
               - - -
        :param pulumi.Input[_builtins.str] subnetwork: The URI of the subnetwork resource that this interface
               belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here. Changing this forces a new interface to be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        :param pulumi.Input[_builtins.str] vpn_tunnel: The name or resource link to the VPN tunnel this
               interface will be linked to. Changing this forces a new interface to be created. Only
               one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterInterfaceState.__new__(_RouterInterfaceState)

        __props__.__dict__["interconnect_attachment"] = interconnect_attachment
        __props__.__dict__["ip_range"] = ip_range
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["project"] = project
        __props__.__dict__["redundant_interface"] = redundant_interface
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["vpn_tunnel"] = vpn_tunnel
        return RouterInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name or resource link to the
        VLAN interconnect for this interface. Changing this forces a new interface to
        be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "interconnect_attachment")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Output[_builtins.str]:
        """
        IP address and range of the interface. The IP range must be
        in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        IP version of this interface. Can be either IPV4 or IPV6.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique name for the interface, required by GCE. Changing
        this forces a new interface to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The regional private internal IP address that is used
        to establish BGP sessions to a VM instance acting as a third-party Router Appliance. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which this interface's routerbelongs.
        If it is not provided, the provider project is used. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="redundantInterface")
    def redundant_interface(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the interface that is redundant to
        this interface. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "redundant_interface")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region this interface's router sits in.
        If not specified, the project region will be used. Changing this forces a new interface to be created.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def router(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the router this interface will be attached to.
        Changing this forces a new interface to be created.

        In addition to the above required fields, a router interface must have specified either `ip_range` or exactly one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork`, or both.

        - - -
        """
        return pulumi.get(self, "router")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URI of the subnetwork resource that this interface
        belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here. Changing this forces a new interface to be created. Only one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter(name="vpnTunnel")
    def vpn_tunnel(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name or resource link to the VPN tunnel this
        interface will be linked to. Changing this forces a new interface to be created. Only
        one of `vpn_tunnel`, `interconnect_attachment` or `subnetwork` can be specified.
        """
        return pulumi.get(self, "vpn_tunnel")

