# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouterNatArgs', 'RouterNat']

@pulumi.input_type
class RouterNatArgs:
    def __init__(__self__, *,
                 router: pulumi.Input[_builtins.str],
                 source_subnetwork_ip_ranges_to_nat: pulumi.Input[_builtins.str],
                 auto_network_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 initial_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input['RouterNatLogConfigArgs']] = None,
                 max_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat64_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatNat64SubnetworkArgs']]]] = None,
                 nat_ip_allocate_option: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]] = None,
                 source_subnetwork_ip_ranges_to_nat64: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a RouterNat resource.
        :param pulumi.Input[_builtins.str] router: The name of the Cloud Router in which this NAT will be configured.
        :param pulumi.Input[_builtins.str] source_subnetwork_ip_ranges_to_nat: How NAT should be configured per Subnetwork.
               If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
               IP ranges in every Subnetwork are allowed to Nat.
               If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
               ranges in every Subnetwork are allowed to Nat.
               `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
               (specified in the field subnetwork below). Note that if this field
               contains ALL_SUBNETWORKS_ALL_IP_RANGES or
               ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
               other RouterNat section in any Router for this network in this region.
               Possible values are: `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, `LIST_OF_SUBNETWORKS`.
        :param pulumi.Input[_builtins.str] auto_network_tier: The network tier to use when automatically reserving NAT IP addresses.
               Must be one of: PREMIUM, STANDARD. If not specified, then the current
               project-level default tier is used.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[_builtins.bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation.
               If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
               If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
               If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
               If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
               Mutually exclusive with enableEndpointIndependentMapping.
        :param pulumi.Input[_builtins.bool] enable_endpoint_independent_mapping: Enable endpoint independent mapping.
               For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_types: Specifies the endpoint Types supported by the NAT Gateway.
               Supported values include:
               `ENDPOINT_TYPE_VM`, `ENDPOINT_TYPE_SWG`,
               `ENDPOINT_TYPE_MANAGED_PROXY_LB`.
        :param pulumi.Input[_builtins.int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] initial_nat_ips: Self-links of NAT IPs to be used as initial value for creation alongside a RouterNatAddress resource.
               Conflicts with natIps and drainNatIps. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
        :param pulumi.Input['RouterNatLogConfigArgs'] log_config: Configuration for logging on NAT
               Structure is documented below.
        :param pulumi.Input[_builtins.int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT.
               This field can only be set when enableDynamicPortAllocation is enabled.
        :param pulumi.Input[_builtins.int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT. Defaults to 64 for static port allocation and 32 dynamic port allocation if not set.
        :param pulumi.Input[_builtins.str] name: Name of the NAT service. The name must be 1-63 characters long and
               comply with RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatNat64SubnetworkArgs']]] nat64_subnetworks: One or more subnetwork NAT configurations whose traffic should be translated by NAT64 Gateway.
               Only used if `source_subnetwork_ip_ranges_to_nat64` is set to `LIST_OF_IPV6_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[_builtins.str] nat_ip_allocate_option: How external IPs should be allocated for this NAT. Valid values are
               `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
               Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
               Possible values are: `MANUAL_ONLY`, `AUTO_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nat_ips: Self-links of NAT IPs. Only valid if natIpAllocateOption
               is set to MANUAL_ONLY.
               If this field is used alongside with a count created list of address resources `google_compute_address.foobar.*.self_link`,
               the access level resource for the address resource must have a `lifecycle` block with `create_before_destroy = true` so
               the number of resources can be increased/decreased without triggering the `resourceInUseByAnotherResource` error.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the router and NAT reside.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]] rules: A list of rules associated with this NAT.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] source_subnetwork_ip_ranges_to_nat64: Specify the Nat option for NAT64, which can take one of the following values:
               ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat.
               LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64Subnetwork below).
               Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network.
               Other Router.Nat sections can still be present to enable NAT44 only.
               Possible values are: `ALL_IPV6_SUBNETWORKS`, `LIST_OF_IPV6_SUBNETWORKS`.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]] subnetworks: One or more subnetwork NAT configurations. Only used if
               `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[_builtins.int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections.
               Defaults to 1200s if not set.
        :param pulumi.Input[_builtins.int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
               Defaults to 120s if not set.
        :param pulumi.Input[_builtins.int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections.
               Defaults to 30s if not set.
        :param pulumi.Input[_builtins.str] type: Indicates whether this NAT is used for public or private IP translation.
               If unspecified, it defaults to PUBLIC.
               If `PUBLIC` NAT used for public IP translation.
               If `PRIVATE` NAT used for private IP translation.
               Default value is `PUBLIC`.
               Possible values are: `PUBLIC`, `PRIVATE`.
        :param pulumi.Input[_builtins.int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        pulumi.set(__self__, "router", router)
        pulumi.set(__self__, "source_subnetwork_ip_ranges_to_nat", source_subnetwork_ip_ranges_to_nat)
        if auto_network_tier is not None:
            pulumi.set(__self__, "auto_network_tier", auto_network_tier)
        if drain_nat_ips is not None:
            pulumi.set(__self__, "drain_nat_ips", drain_nat_ips)
        if enable_dynamic_port_allocation is not None:
            pulumi.set(__self__, "enable_dynamic_port_allocation", enable_dynamic_port_allocation)
        if enable_endpoint_independent_mapping is not None:
            pulumi.set(__self__, "enable_endpoint_independent_mapping", enable_endpoint_independent_mapping)
        if endpoint_types is not None:
            pulumi.set(__self__, "endpoint_types", endpoint_types)
        if icmp_idle_timeout_sec is not None:
            pulumi.set(__self__, "icmp_idle_timeout_sec", icmp_idle_timeout_sec)
        if initial_nat_ips is not None:
            pulumi.set(__self__, "initial_nat_ips", initial_nat_ips)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if max_ports_per_vm is not None:
            pulumi.set(__self__, "max_ports_per_vm", max_ports_per_vm)
        if min_ports_per_vm is not None:
            pulumi.set(__self__, "min_ports_per_vm", min_ports_per_vm)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat64_subnetworks is not None:
            pulumi.set(__self__, "nat64_subnetworks", nat64_subnetworks)
        if nat_ip_allocate_option is not None:
            pulumi.set(__self__, "nat_ip_allocate_option", nat_ip_allocate_option)
        if nat_ips is not None:
            pulumi.set(__self__, "nat_ips", nat_ips)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if source_subnetwork_ip_ranges_to_nat64 is not None:
            pulumi.set(__self__, "source_subnetwork_ip_ranges_to_nat64", source_subnetwork_ip_ranges_to_nat64)
        if subnetworks is not None:
            pulumi.set(__self__, "subnetworks", subnetworks)
        if tcp_established_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_established_idle_timeout_sec", tcp_established_idle_timeout_sec)
        if tcp_time_wait_timeout_sec is not None:
            pulumi.set(__self__, "tcp_time_wait_timeout_sec", tcp_time_wait_timeout_sec)
        if tcp_transitory_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_transitory_idle_timeout_sec", tcp_transitory_idle_timeout_sec)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udp_idle_timeout_sec is not None:
            pulumi.set(__self__, "udp_idle_timeout_sec", udp_idle_timeout_sec)

    @_builtins.property
    @pulumi.getter
    def router(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cloud Router in which this NAT will be configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "router", value)

    @_builtins.property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat")
    def source_subnetwork_ip_ranges_to_nat(self) -> pulumi.Input[_builtins.str]:
        """
        How NAT should be configured per Subnetwork.
        If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
        IP ranges in every Subnetwork are allowed to Nat.
        If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
        ranges in every Subnetwork are allowed to Nat.
        `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
        (specified in the field subnetwork below). Note that if this field
        contains ALL_SUBNETWORKS_ALL_IP_RANGES or
        ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
        other RouterNat section in any Router for this network in this region.
        Possible values are: `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, `LIST_OF_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat")

    @source_subnetwork_ip_ranges_to_nat.setter
    def source_subnetwork_ip_ranges_to_nat(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_subnetwork_ip_ranges_to_nat", value)

    @_builtins.property
    @pulumi.getter(name="autoNetworkTier")
    def auto_network_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network tier to use when automatically reserving NAT IP addresses.
        Must be one of: PREMIUM, STANDARD. If not specified, then the current
        project-level default tier is used.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "auto_network_tier")

    @auto_network_tier.setter
    def auto_network_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_network_tier", value)

    @_builtins.property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @drain_nat_ips.setter
    def drain_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "drain_nat_ips", value)

    @_builtins.property
    @pulumi.getter(name="enableDynamicPortAllocation")
    def enable_dynamic_port_allocation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Dynamic Port Allocation.
        If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
        If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
        If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
        If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        Mutually exclusive with enableEndpointIndependentMapping.
        """
        return pulumi.get(self, "enable_dynamic_port_allocation")

    @enable_dynamic_port_allocation.setter
    def enable_dynamic_port_allocation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dynamic_port_allocation", value)

    @_builtins.property
    @pulumi.getter(name="enableEndpointIndependentMapping")
    def enable_endpoint_independent_mapping(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable endpoint independent mapping.
        For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        """
        return pulumi.get(self, "enable_endpoint_independent_mapping")

    @enable_endpoint_independent_mapping.setter
    def enable_endpoint_independent_mapping(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_endpoint_independent_mapping", value)

    @_builtins.property
    @pulumi.getter(name="endpointTypes")
    def endpoint_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the endpoint Types supported by the NAT Gateway.
        Supported values include:
        `ENDPOINT_TYPE_VM`, `ENDPOINT_TYPE_SWG`,
        `ENDPOINT_TYPE_MANAGED_PROXY_LB`.
        """
        return pulumi.get(self, "endpoint_types")

    @endpoint_types.setter
    def endpoint_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_types", value)

    @_builtins.property
    @pulumi.getter(name="icmpIdleTimeoutSec")
    def icmp_idle_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "icmp_idle_timeout_sec")

    @icmp_idle_timeout_sec.setter
    def icmp_idle_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "icmp_idle_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="initialNatIps")
    def initial_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Self-links of NAT IPs to be used as initial value for creation alongside a RouterNatAddress resource.
        Conflicts with natIps and drainNatIps. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "initial_nat_ips")

    @initial_nat_ips.setter
    def initial_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "initial_nat_ips", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RouterNatLogConfigArgs']]:
        """
        Configuration for logging on NAT
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RouterNatLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="maxPortsPerVm")
    def max_ports_per_vm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of ports allocated to a VM from this NAT.
        This field can only be set when enableDynamicPortAllocation is enabled.
        """
        return pulumi.get(self, "max_ports_per_vm")

    @max_ports_per_vm.setter
    def max_ports_per_vm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ports_per_vm", value)

    @_builtins.property
    @pulumi.getter(name="minPortsPerVm")
    def min_ports_per_vm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of ports allocated to a VM from this NAT. Defaults to 64 for static port allocation and 32 dynamic port allocation if not set.
        """
        return pulumi.get(self, "min_ports_per_vm")

    @min_ports_per_vm.setter
    def min_ports_per_vm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ports_per_vm", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the NAT service. The name must be 1-63 characters long and
        comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nat64Subnetworks")
    def nat64_subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatNat64SubnetworkArgs']]]]:
        """
        One or more subnetwork NAT configurations whose traffic should be translated by NAT64 Gateway.
        Only used if `source_subnetwork_ip_ranges_to_nat64` is set to `LIST_OF_IPV6_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "nat64_subnetworks")

    @nat64_subnetworks.setter
    def nat64_subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatNat64SubnetworkArgs']]]]):
        pulumi.set(self, "nat64_subnetworks", value)

    @_builtins.property
    @pulumi.getter(name="natIpAllocateOption")
    def nat_ip_allocate_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How external IPs should be allocated for this NAT. Valid values are
        `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
        Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
        Possible values are: `MANUAL_ONLY`, `AUTO_ONLY`.
        """
        return pulumi.get(self, "nat_ip_allocate_option")

    @nat_ip_allocate_option.setter
    def nat_ip_allocate_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_ip_allocate_option", value)

    @_builtins.property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Self-links of NAT IPs. Only valid if natIpAllocateOption
        is set to MANUAL_ONLY.
        If this field is used alongside with a count created list of address resources `google_compute_address.foobar.*.self_link`,
        the access level resource for the address resource must have a `lifecycle` block with `create_before_destroy = true` so
        the number of resources can be increased/decreased without triggering the `resourceInUseByAnotherResource` error.
        """
        return pulumi.get(self, "nat_ips")

    @nat_ips.setter
    def nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nat_ips", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]:
        """
        A list of rules associated with this NAT.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat64")
    def source_subnetwork_ip_ranges_to_nat64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the Nat option for NAT64, which can take one of the following values:
        ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat.
        LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64Subnetwork below).
        Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network.
        Other Router.Nat sections can still be present to enable NAT44 only.
        Possible values are: `ALL_IPV6_SUBNETWORKS`, `LIST_OF_IPV6_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat64")

    @source_subnetwork_ip_ranges_to_nat64.setter
    def source_subnetwork_ip_ranges_to_nat64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_subnetwork_ip_ranges_to_nat64", value)

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]]:
        """
        One or more subnetwork NAT configurations. Only used if
        `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "subnetworks")

    @subnetworks.setter
    def subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]]):
        pulumi.set(self, "subnetworks", value)

    @_builtins.property
    @pulumi.getter(name="tcpEstablishedIdleTimeoutSec")
    def tcp_established_idle_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for TCP established connections.
        Defaults to 1200s if not set.
        """
        return pulumi.get(self, "tcp_established_idle_timeout_sec")

    @tcp_established_idle_timeout_sec.setter
    def tcp_established_idle_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_established_idle_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimeWaitTimeoutSec")
    def tcp_time_wait_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
        Defaults to 120s if not set.
        """
        return pulumi.get(self, "tcp_time_wait_timeout_sec")

    @tcp_time_wait_timeout_sec.setter
    def tcp_time_wait_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_time_wait_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="tcpTransitoryIdleTimeoutSec")
    def tcp_transitory_idle_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for TCP transitory connections.
        Defaults to 30s if not set.
        """
        return pulumi.get(self, "tcp_transitory_idle_timeout_sec")

    @tcp_transitory_idle_timeout_sec.setter
    def tcp_transitory_idle_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_transitory_idle_timeout_sec", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether this NAT is used for public or private IP translation.
        If unspecified, it defaults to PUBLIC.
        If `PUBLIC` NAT used for public IP translation.
        If `PRIVATE` NAT used for private IP translation.
        Default value is `PUBLIC`.
        Possible values are: `PUBLIC`, `PRIVATE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="udpIdleTimeoutSec")
    def udp_idle_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "udp_idle_timeout_sec")

    @udp_idle_timeout_sec.setter
    def udp_idle_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_idle_timeout_sec", value)


@pulumi.input_type
class _RouterNatState:
    def __init__(__self__, *,
                 auto_network_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 initial_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input['RouterNatLogConfigArgs']] = None,
                 max_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat64_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatNat64SubnetworkArgs']]]] = None,
                 nat_ip_allocate_option: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]] = None,
                 source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input[_builtins.str]] = None,
                 source_subnetwork_ip_ranges_to_nat64: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RouterNat resources.
        :param pulumi.Input[_builtins.str] auto_network_tier: The network tier to use when automatically reserving NAT IP addresses.
               Must be one of: PREMIUM, STANDARD. If not specified, then the current
               project-level default tier is used.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[_builtins.bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation.
               If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
               If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
               If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
               If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
               Mutually exclusive with enableEndpointIndependentMapping.
        :param pulumi.Input[_builtins.bool] enable_endpoint_independent_mapping: Enable endpoint independent mapping.
               For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_types: Specifies the endpoint Types supported by the NAT Gateway.
               Supported values include:
               `ENDPOINT_TYPE_VM`, `ENDPOINT_TYPE_SWG`,
               `ENDPOINT_TYPE_MANAGED_PROXY_LB`.
        :param pulumi.Input[_builtins.int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] initial_nat_ips: Self-links of NAT IPs to be used as initial value for creation alongside a RouterNatAddress resource.
               Conflicts with natIps and drainNatIps. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
        :param pulumi.Input['RouterNatLogConfigArgs'] log_config: Configuration for logging on NAT
               Structure is documented below.
        :param pulumi.Input[_builtins.int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT.
               This field can only be set when enableDynamicPortAllocation is enabled.
        :param pulumi.Input[_builtins.int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT. Defaults to 64 for static port allocation and 32 dynamic port allocation if not set.
        :param pulumi.Input[_builtins.str] name: Name of the NAT service. The name must be 1-63 characters long and
               comply with RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatNat64SubnetworkArgs']]] nat64_subnetworks: One or more subnetwork NAT configurations whose traffic should be translated by NAT64 Gateway.
               Only used if `source_subnetwork_ip_ranges_to_nat64` is set to `LIST_OF_IPV6_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[_builtins.str] nat_ip_allocate_option: How external IPs should be allocated for this NAT. Valid values are
               `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
               Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
               Possible values are: `MANUAL_ONLY`, `AUTO_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nat_ips: Self-links of NAT IPs. Only valid if natIpAllocateOption
               is set to MANUAL_ONLY.
               If this field is used alongside with a count created list of address resources `google_compute_address.foobar.*.self_link`,
               the access level resource for the address resource must have a `lifecycle` block with `create_before_destroy = true` so
               the number of resources can be increased/decreased without triggering the `resourceInUseByAnotherResource` error.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the router and NAT reside.
        :param pulumi.Input[_builtins.str] router: The name of the Cloud Router in which this NAT will be configured.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]] rules: A list of rules associated with this NAT.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] source_subnetwork_ip_ranges_to_nat: How NAT should be configured per Subnetwork.
               If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
               IP ranges in every Subnetwork are allowed to Nat.
               If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
               ranges in every Subnetwork are allowed to Nat.
               `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
               (specified in the field subnetwork below). Note that if this field
               contains ALL_SUBNETWORKS_ALL_IP_RANGES or
               ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
               other RouterNat section in any Router for this network in this region.
               Possible values are: `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, `LIST_OF_SUBNETWORKS`.
        :param pulumi.Input[_builtins.str] source_subnetwork_ip_ranges_to_nat64: Specify the Nat option for NAT64, which can take one of the following values:
               ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat.
               LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64Subnetwork below).
               Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network.
               Other Router.Nat sections can still be present to enable NAT44 only.
               Possible values are: `ALL_IPV6_SUBNETWORKS`, `LIST_OF_IPV6_SUBNETWORKS`.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]] subnetworks: One or more subnetwork NAT configurations. Only used if
               `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[_builtins.int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections.
               Defaults to 1200s if not set.
        :param pulumi.Input[_builtins.int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
               Defaults to 120s if not set.
        :param pulumi.Input[_builtins.int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections.
               Defaults to 30s if not set.
        :param pulumi.Input[_builtins.str] type: Indicates whether this NAT is used for public or private IP translation.
               If unspecified, it defaults to PUBLIC.
               If `PUBLIC` NAT used for public IP translation.
               If `PRIVATE` NAT used for private IP translation.
               Default value is `PUBLIC`.
               Possible values are: `PUBLIC`, `PRIVATE`.
        :param pulumi.Input[_builtins.int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        if auto_network_tier is not None:
            pulumi.set(__self__, "auto_network_tier", auto_network_tier)
        if drain_nat_ips is not None:
            pulumi.set(__self__, "drain_nat_ips", drain_nat_ips)
        if enable_dynamic_port_allocation is not None:
            pulumi.set(__self__, "enable_dynamic_port_allocation", enable_dynamic_port_allocation)
        if enable_endpoint_independent_mapping is not None:
            pulumi.set(__self__, "enable_endpoint_independent_mapping", enable_endpoint_independent_mapping)
        if endpoint_types is not None:
            pulumi.set(__self__, "endpoint_types", endpoint_types)
        if icmp_idle_timeout_sec is not None:
            pulumi.set(__self__, "icmp_idle_timeout_sec", icmp_idle_timeout_sec)
        if initial_nat_ips is not None:
            pulumi.set(__self__, "initial_nat_ips", initial_nat_ips)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if max_ports_per_vm is not None:
            pulumi.set(__self__, "max_ports_per_vm", max_ports_per_vm)
        if min_ports_per_vm is not None:
            pulumi.set(__self__, "min_ports_per_vm", min_ports_per_vm)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat64_subnetworks is not None:
            pulumi.set(__self__, "nat64_subnetworks", nat64_subnetworks)
        if nat_ip_allocate_option is not None:
            pulumi.set(__self__, "nat_ip_allocate_option", nat_ip_allocate_option)
        if nat_ips is not None:
            pulumi.set(__self__, "nat_ips", nat_ips)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if source_subnetwork_ip_ranges_to_nat is not None:
            pulumi.set(__self__, "source_subnetwork_ip_ranges_to_nat", source_subnetwork_ip_ranges_to_nat)
        if source_subnetwork_ip_ranges_to_nat64 is not None:
            pulumi.set(__self__, "source_subnetwork_ip_ranges_to_nat64", source_subnetwork_ip_ranges_to_nat64)
        if subnetworks is not None:
            pulumi.set(__self__, "subnetworks", subnetworks)
        if tcp_established_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_established_idle_timeout_sec", tcp_established_idle_timeout_sec)
        if tcp_time_wait_timeout_sec is not None:
            pulumi.set(__self__, "tcp_time_wait_timeout_sec", tcp_time_wait_timeout_sec)
        if tcp_transitory_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_transitory_idle_timeout_sec", tcp_transitory_idle_timeout_sec)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udp_idle_timeout_sec is not None:
            pulumi.set(__self__, "udp_idle_timeout_sec", udp_idle_timeout_sec)

    @_builtins.property
    @pulumi.getter(name="autoNetworkTier")
    def auto_network_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network tier to use when automatically reserving NAT IP addresses.
        Must be one of: PREMIUM, STANDARD. If not specified, then the current
        project-level default tier is used.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "auto_network_tier")

    @auto_network_tier.setter
    def auto_network_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_network_tier", value)

    @_builtins.property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @drain_nat_ips.setter
    def drain_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "drain_nat_ips", value)

    @_builtins.property
    @pulumi.getter(name="enableDynamicPortAllocation")
    def enable_dynamic_port_allocation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Dynamic Port Allocation.
        If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
        If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
        If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
        If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        Mutually exclusive with enableEndpointIndependentMapping.
        """
        return pulumi.get(self, "enable_dynamic_port_allocation")

    @enable_dynamic_port_allocation.setter
    def enable_dynamic_port_allocation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dynamic_port_allocation", value)

    @_builtins.property
    @pulumi.getter(name="enableEndpointIndependentMapping")
    def enable_endpoint_independent_mapping(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable endpoint independent mapping.
        For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        """
        return pulumi.get(self, "enable_endpoint_independent_mapping")

    @enable_endpoint_independent_mapping.setter
    def enable_endpoint_independent_mapping(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_endpoint_independent_mapping", value)

    @_builtins.property
    @pulumi.getter(name="endpointTypes")
    def endpoint_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the endpoint Types supported by the NAT Gateway.
        Supported values include:
        `ENDPOINT_TYPE_VM`, `ENDPOINT_TYPE_SWG`,
        `ENDPOINT_TYPE_MANAGED_PROXY_LB`.
        """
        return pulumi.get(self, "endpoint_types")

    @endpoint_types.setter
    def endpoint_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_types", value)

    @_builtins.property
    @pulumi.getter(name="icmpIdleTimeoutSec")
    def icmp_idle_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "icmp_idle_timeout_sec")

    @icmp_idle_timeout_sec.setter
    def icmp_idle_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "icmp_idle_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="initialNatIps")
    def initial_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Self-links of NAT IPs to be used as initial value for creation alongside a RouterNatAddress resource.
        Conflicts with natIps and drainNatIps. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "initial_nat_ips")

    @initial_nat_ips.setter
    def initial_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "initial_nat_ips", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RouterNatLogConfigArgs']]:
        """
        Configuration for logging on NAT
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RouterNatLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="maxPortsPerVm")
    def max_ports_per_vm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of ports allocated to a VM from this NAT.
        This field can only be set when enableDynamicPortAllocation is enabled.
        """
        return pulumi.get(self, "max_ports_per_vm")

    @max_ports_per_vm.setter
    def max_ports_per_vm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ports_per_vm", value)

    @_builtins.property
    @pulumi.getter(name="minPortsPerVm")
    def min_ports_per_vm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of ports allocated to a VM from this NAT. Defaults to 64 for static port allocation and 32 dynamic port allocation if not set.
        """
        return pulumi.get(self, "min_ports_per_vm")

    @min_ports_per_vm.setter
    def min_ports_per_vm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ports_per_vm", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the NAT service. The name must be 1-63 characters long and
        comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nat64Subnetworks")
    def nat64_subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatNat64SubnetworkArgs']]]]:
        """
        One or more subnetwork NAT configurations whose traffic should be translated by NAT64 Gateway.
        Only used if `source_subnetwork_ip_ranges_to_nat64` is set to `LIST_OF_IPV6_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "nat64_subnetworks")

    @nat64_subnetworks.setter
    def nat64_subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatNat64SubnetworkArgs']]]]):
        pulumi.set(self, "nat64_subnetworks", value)

    @_builtins.property
    @pulumi.getter(name="natIpAllocateOption")
    def nat_ip_allocate_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How external IPs should be allocated for this NAT. Valid values are
        `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
        Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
        Possible values are: `MANUAL_ONLY`, `AUTO_ONLY`.
        """
        return pulumi.get(self, "nat_ip_allocate_option")

    @nat_ip_allocate_option.setter
    def nat_ip_allocate_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_ip_allocate_option", value)

    @_builtins.property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Self-links of NAT IPs. Only valid if natIpAllocateOption
        is set to MANUAL_ONLY.
        If this field is used alongside with a count created list of address resources `google_compute_address.foobar.*.self_link`,
        the access level resource for the address resource must have a `lifecycle` block with `create_before_destroy = true` so
        the number of resources can be increased/decreased without triggering the `resourceInUseByAnotherResource` error.
        """
        return pulumi.get(self, "nat_ips")

    @nat_ips.setter
    def nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nat_ips", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cloud Router in which this NAT will be configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]:
        """
        A list of rules associated with this NAT.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat")
    def source_subnetwork_ip_ranges_to_nat(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How NAT should be configured per Subnetwork.
        If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
        IP ranges in every Subnetwork are allowed to Nat.
        If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
        ranges in every Subnetwork are allowed to Nat.
        `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
        (specified in the field subnetwork below). Note that if this field
        contains ALL_SUBNETWORKS_ALL_IP_RANGES or
        ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
        other RouterNat section in any Router for this network in this region.
        Possible values are: `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, `LIST_OF_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat")

    @source_subnetwork_ip_ranges_to_nat.setter
    def source_subnetwork_ip_ranges_to_nat(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_subnetwork_ip_ranges_to_nat", value)

    @_builtins.property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat64")
    def source_subnetwork_ip_ranges_to_nat64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the Nat option for NAT64, which can take one of the following values:
        ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat.
        LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64Subnetwork below).
        Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network.
        Other Router.Nat sections can still be present to enable NAT44 only.
        Possible values are: `ALL_IPV6_SUBNETWORKS`, `LIST_OF_IPV6_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat64")

    @source_subnetwork_ip_ranges_to_nat64.setter
    def source_subnetwork_ip_ranges_to_nat64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_subnetwork_ip_ranges_to_nat64", value)

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]]:
        """
        One or more subnetwork NAT configurations. Only used if
        `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "subnetworks")

    @subnetworks.setter
    def subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]]):
        pulumi.set(self, "subnetworks", value)

    @_builtins.property
    @pulumi.getter(name="tcpEstablishedIdleTimeoutSec")
    def tcp_established_idle_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for TCP established connections.
        Defaults to 1200s if not set.
        """
        return pulumi.get(self, "tcp_established_idle_timeout_sec")

    @tcp_established_idle_timeout_sec.setter
    def tcp_established_idle_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_established_idle_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimeWaitTimeoutSec")
    def tcp_time_wait_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
        Defaults to 120s if not set.
        """
        return pulumi.get(self, "tcp_time_wait_timeout_sec")

    @tcp_time_wait_timeout_sec.setter
    def tcp_time_wait_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_time_wait_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="tcpTransitoryIdleTimeoutSec")
    def tcp_transitory_idle_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for TCP transitory connections.
        Defaults to 30s if not set.
        """
        return pulumi.get(self, "tcp_transitory_idle_timeout_sec")

    @tcp_transitory_idle_timeout_sec.setter
    def tcp_transitory_idle_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_transitory_idle_timeout_sec", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether this NAT is used for public or private IP translation.
        If unspecified, it defaults to PUBLIC.
        If `PUBLIC` NAT used for public IP translation.
        If `PRIVATE` NAT used for private IP translation.
        Default value is `PUBLIC`.
        Possible values are: `PUBLIC`, `PRIVATE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="udpIdleTimeoutSec")
    def udp_idle_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "udp_idle_timeout_sec")

    @udp_idle_timeout_sec.setter
    def udp_idle_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_idle_timeout_sec", value)


@pulumi.type_token("gcp:compute/routerNat:RouterNat")
class RouterNat(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_network_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 initial_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input[Union['RouterNatLogConfigArgs', 'RouterNatLogConfigArgsDict']]] = None,
                 max_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat64_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatNat64SubnetworkArgs', 'RouterNatNat64SubnetworkArgsDict']]]]] = None,
                 nat_ip_allocate_option: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatRuleArgs', 'RouterNatRuleArgsDict']]]]] = None,
                 source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input[_builtins.str]] = None,
                 source_subnetwork_ip_ranges_to_nat64: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatSubnetworkArgs', 'RouterNatSubnetworkArgsDict']]]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        A NAT service created in a router.

        > **Note:** Recreating a `compute.Address` that is being used by `compute.RouterNat` will give a `resourceInUseByAnotherResource` error.
        Use `lifecycle.create_before_destroy` on this address resource to avoid this type of error as shown in the Manual Ips example.

        To get more information about RouterNat, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage

        ### Router Nat Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net", name="my-network")
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id,
            bgp={
                "asn": 64514,
            })
        nat = gcp.compute.RouterNat("nat",
            name="my-router-nat",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="AUTO_ONLY",
            source_subnetwork_ip_ranges_to_nat="ALL_SUBNETWORKS_ALL_IP_RANGES",
            log_config={
                "enable": True,
                "filter": "ERRORS_ONLY",
            })
        ```
        ### Router Nat Rules

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id)
        addr1 = gcp.compute.Address("addr1",
            name="nat-address1",
            region=subnet.region)
        addr2 = gcp.compute.Address("addr2",
            name="nat-address2",
            region=subnet.region)
        addr3 = gcp.compute.Address("addr3",
            name="nat-address3",
            region=subnet.region)
        nat_rules = gcp.compute.RouterNat("nat_rules",
            name="my-router-nat",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="MANUAL_ONLY",
            nat_ips=[addr1.self_link],
            source_subnetwork_ip_ranges_to_nat="LIST_OF_SUBNETWORKS",
            subnetworks=[{
                "name": subnet.id,
                "source_ip_ranges_to_nats": ["ALL_IP_RANGES"],
            }],
            rules=[{
                "rule_number": 100,
                "description": "nat rules example",
                "match": "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')",
                "action": {
                    "source_nat_active_ips": [
                        addr2.self_link,
                        addr3.self_link,
                    ],
                },
            }],
            enable_endpoint_independent_mapping=False)
        ```
        ### Router Nat Private

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net", name="my-network")
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            purpose="PRIVATE_NAT")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id)
        hub = gcp.networkconnectivity.Hub("hub",
            name="my-hub",
            description="vpc hub for inter vpc nat")
        spoke = gcp.networkconnectivity.Spoke("spoke",
            name="my-spoke",
            location="global",
            description="vpc spoke for inter vpc nat",
            hub=hub.id,
            linked_vpc_network={
                "exclude_export_ranges": [
                    "198.51.100.0/24",
                    "10.10.0.0/16",
                ],
                "uri": net.self_link,
            })
        nat_type = gcp.compute.RouterNat("nat_type",
            name="my-router-nat",
            router=router.name,
            region=router.region,
            source_subnetwork_ip_ranges_to_nat="LIST_OF_SUBNETWORKS",
            enable_dynamic_port_allocation=False,
            enable_endpoint_independent_mapping=False,
            min_ports_per_vm=32,
            type="PRIVATE",
            subnetworks=[{
                "name": subnet.id,
                "source_ip_ranges_to_nats": ["ALL_IP_RANGES"],
            }],
            rules=[{
                "rule_number": 100,
                "description": "rule for private nat",
                "match": "nexthop.hub == \\"//networkconnectivity.googleapis.com/projects/acm-test-proj-123/locations/global/hubs/my-hub\\"",
                "action": {
                    "source_nat_active_ranges": [subnet.self_link],
                },
            }])
        ```

        ## Import

        RouterNat can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}`

        * `{{project}}/{{region}}/{{router}}/{{name}}`

        * `{{region}}/{{router}}/{{name}}`

        * `{{router}}/{{name}}`

        When using the `pulumi import` command, RouterNat can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerNat:RouterNat default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNat:RouterNat default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNat:RouterNat default {{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNat:RouterNat default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_network_tier: The network tier to use when automatically reserving NAT IP addresses.
               Must be one of: PREMIUM, STANDARD. If not specified, then the current
               project-level default tier is used.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[_builtins.bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation.
               If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
               If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
               If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
               If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
               Mutually exclusive with enableEndpointIndependentMapping.
        :param pulumi.Input[_builtins.bool] enable_endpoint_independent_mapping: Enable endpoint independent mapping.
               For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_types: Specifies the endpoint Types supported by the NAT Gateway.
               Supported values include:
               `ENDPOINT_TYPE_VM`, `ENDPOINT_TYPE_SWG`,
               `ENDPOINT_TYPE_MANAGED_PROXY_LB`.
        :param pulumi.Input[_builtins.int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] initial_nat_ips: Self-links of NAT IPs to be used as initial value for creation alongside a RouterNatAddress resource.
               Conflicts with natIps and drainNatIps. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
        :param pulumi.Input[Union['RouterNatLogConfigArgs', 'RouterNatLogConfigArgsDict']] log_config: Configuration for logging on NAT
               Structure is documented below.
        :param pulumi.Input[_builtins.int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT.
               This field can only be set when enableDynamicPortAllocation is enabled.
        :param pulumi.Input[_builtins.int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT. Defaults to 64 for static port allocation and 32 dynamic port allocation if not set.
        :param pulumi.Input[_builtins.str] name: Name of the NAT service. The name must be 1-63 characters long and
               comply with RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterNatNat64SubnetworkArgs', 'RouterNatNat64SubnetworkArgsDict']]]] nat64_subnetworks: One or more subnetwork NAT configurations whose traffic should be translated by NAT64 Gateway.
               Only used if `source_subnetwork_ip_ranges_to_nat64` is set to `LIST_OF_IPV6_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[_builtins.str] nat_ip_allocate_option: How external IPs should be allocated for this NAT. Valid values are
               `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
               Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
               Possible values are: `MANUAL_ONLY`, `AUTO_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nat_ips: Self-links of NAT IPs. Only valid if natIpAllocateOption
               is set to MANUAL_ONLY.
               If this field is used alongside with a count created list of address resources `google_compute_address.foobar.*.self_link`,
               the access level resource for the address resource must have a `lifecycle` block with `create_before_destroy = true` so
               the number of resources can be increased/decreased without triggering the `resourceInUseByAnotherResource` error.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the router and NAT reside.
        :param pulumi.Input[_builtins.str] router: The name of the Cloud Router in which this NAT will be configured.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterNatRuleArgs', 'RouterNatRuleArgsDict']]]] rules: A list of rules associated with this NAT.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] source_subnetwork_ip_ranges_to_nat: How NAT should be configured per Subnetwork.
               If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
               IP ranges in every Subnetwork are allowed to Nat.
               If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
               ranges in every Subnetwork are allowed to Nat.
               `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
               (specified in the field subnetwork below). Note that if this field
               contains ALL_SUBNETWORKS_ALL_IP_RANGES or
               ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
               other RouterNat section in any Router for this network in this region.
               Possible values are: `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, `LIST_OF_SUBNETWORKS`.
        :param pulumi.Input[_builtins.str] source_subnetwork_ip_ranges_to_nat64: Specify the Nat option for NAT64, which can take one of the following values:
               ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat.
               LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64Subnetwork below).
               Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network.
               Other Router.Nat sections can still be present to enable NAT44 only.
               Possible values are: `ALL_IPV6_SUBNETWORKS`, `LIST_OF_IPV6_SUBNETWORKS`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterNatSubnetworkArgs', 'RouterNatSubnetworkArgsDict']]]] subnetworks: One or more subnetwork NAT configurations. Only used if
               `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[_builtins.int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections.
               Defaults to 1200s if not set.
        :param pulumi.Input[_builtins.int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
               Defaults to 120s if not set.
        :param pulumi.Input[_builtins.int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections.
               Defaults to 30s if not set.
        :param pulumi.Input[_builtins.str] type: Indicates whether this NAT is used for public or private IP translation.
               If unspecified, it defaults to PUBLIC.
               If `PUBLIC` NAT used for public IP translation.
               If `PRIVATE` NAT used for private IP translation.
               Default value is `PUBLIC`.
               Possible values are: `PUBLIC`, `PRIVATE`.
        :param pulumi.Input[_builtins.int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterNatArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A NAT service created in a router.

        > **Note:** Recreating a `compute.Address` that is being used by `compute.RouterNat` will give a `resourceInUseByAnotherResource` error.
        Use `lifecycle.create_before_destroy` on this address resource to avoid this type of error as shown in the Manual Ips example.

        To get more information about RouterNat, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage

        ### Router Nat Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net", name="my-network")
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id,
            bgp={
                "asn": 64514,
            })
        nat = gcp.compute.RouterNat("nat",
            name="my-router-nat",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="AUTO_ONLY",
            source_subnetwork_ip_ranges_to_nat="ALL_SUBNETWORKS_ALL_IP_RANGES",
            log_config={
                "enable": True,
                "filter": "ERRORS_ONLY",
            })
        ```
        ### Router Nat Rules

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id)
        addr1 = gcp.compute.Address("addr1",
            name="nat-address1",
            region=subnet.region)
        addr2 = gcp.compute.Address("addr2",
            name="nat-address2",
            region=subnet.region)
        addr3 = gcp.compute.Address("addr3",
            name="nat-address3",
            region=subnet.region)
        nat_rules = gcp.compute.RouterNat("nat_rules",
            name="my-router-nat",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="MANUAL_ONLY",
            nat_ips=[addr1.self_link],
            source_subnetwork_ip_ranges_to_nat="LIST_OF_SUBNETWORKS",
            subnetworks=[{
                "name": subnet.id,
                "source_ip_ranges_to_nats": ["ALL_IP_RANGES"],
            }],
            rules=[{
                "rule_number": 100,
                "description": "nat rules example",
                "match": "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')",
                "action": {
                    "source_nat_active_ips": [
                        addr2.self_link,
                        addr3.self_link,
                    ],
                },
            }],
            enable_endpoint_independent_mapping=False)
        ```
        ### Router Nat Private

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net", name="my-network")
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            purpose="PRIVATE_NAT")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id)
        hub = gcp.networkconnectivity.Hub("hub",
            name="my-hub",
            description="vpc hub for inter vpc nat")
        spoke = gcp.networkconnectivity.Spoke("spoke",
            name="my-spoke",
            location="global",
            description="vpc spoke for inter vpc nat",
            hub=hub.id,
            linked_vpc_network={
                "exclude_export_ranges": [
                    "198.51.100.0/24",
                    "10.10.0.0/16",
                ],
                "uri": net.self_link,
            })
        nat_type = gcp.compute.RouterNat("nat_type",
            name="my-router-nat",
            router=router.name,
            region=router.region,
            source_subnetwork_ip_ranges_to_nat="LIST_OF_SUBNETWORKS",
            enable_dynamic_port_allocation=False,
            enable_endpoint_independent_mapping=False,
            min_ports_per_vm=32,
            type="PRIVATE",
            subnetworks=[{
                "name": subnet.id,
                "source_ip_ranges_to_nats": ["ALL_IP_RANGES"],
            }],
            rules=[{
                "rule_number": 100,
                "description": "rule for private nat",
                "match": "nexthop.hub == \\"//networkconnectivity.googleapis.com/projects/acm-test-proj-123/locations/global/hubs/my-hub\\"",
                "action": {
                    "source_nat_active_ranges": [subnet.self_link],
                },
            }])
        ```

        ## Import

        RouterNat can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}`

        * `{{project}}/{{region}}/{{router}}/{{name}}`

        * `{{region}}/{{router}}/{{name}}`

        * `{{router}}/{{name}}`

        When using the `pulumi import` command, RouterNat can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerNat:RouterNat default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNat:RouterNat default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNat:RouterNat default {{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNat:RouterNat default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RouterNatArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterNatArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_network_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 initial_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input[Union['RouterNatLogConfigArgs', 'RouterNatLogConfigArgsDict']]] = None,
                 max_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat64_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatNat64SubnetworkArgs', 'RouterNatNat64SubnetworkArgsDict']]]]] = None,
                 nat_ip_allocate_option: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatRuleArgs', 'RouterNatRuleArgsDict']]]]] = None,
                 source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input[_builtins.str]] = None,
                 source_subnetwork_ip_ranges_to_nat64: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatSubnetworkArgs', 'RouterNatSubnetworkArgsDict']]]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterNatArgs.__new__(RouterNatArgs)

            __props__.__dict__["auto_network_tier"] = auto_network_tier
            __props__.__dict__["drain_nat_ips"] = drain_nat_ips
            __props__.__dict__["enable_dynamic_port_allocation"] = enable_dynamic_port_allocation
            __props__.__dict__["enable_endpoint_independent_mapping"] = enable_endpoint_independent_mapping
            __props__.__dict__["endpoint_types"] = endpoint_types
            __props__.__dict__["icmp_idle_timeout_sec"] = icmp_idle_timeout_sec
            __props__.__dict__["initial_nat_ips"] = initial_nat_ips
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["max_ports_per_vm"] = max_ports_per_vm
            __props__.__dict__["min_ports_per_vm"] = min_ports_per_vm
            __props__.__dict__["name"] = name
            __props__.__dict__["nat64_subnetworks"] = nat64_subnetworks
            __props__.__dict__["nat_ip_allocate_option"] = nat_ip_allocate_option
            __props__.__dict__["nat_ips"] = nat_ips
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            __props__.__dict__["rules"] = rules
            if source_subnetwork_ip_ranges_to_nat is None and not opts.urn:
                raise TypeError("Missing required property 'source_subnetwork_ip_ranges_to_nat'")
            __props__.__dict__["source_subnetwork_ip_ranges_to_nat"] = source_subnetwork_ip_ranges_to_nat
            __props__.__dict__["source_subnetwork_ip_ranges_to_nat64"] = source_subnetwork_ip_ranges_to_nat64
            __props__.__dict__["subnetworks"] = subnetworks
            __props__.__dict__["tcp_established_idle_timeout_sec"] = tcp_established_idle_timeout_sec
            __props__.__dict__["tcp_time_wait_timeout_sec"] = tcp_time_wait_timeout_sec
            __props__.__dict__["tcp_transitory_idle_timeout_sec"] = tcp_transitory_idle_timeout_sec
            __props__.__dict__["type"] = type
            __props__.__dict__["udp_idle_timeout_sec"] = udp_idle_timeout_sec
        super(RouterNat, __self__).__init__(
            'gcp:compute/routerNat:RouterNat',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_network_tier: Optional[pulumi.Input[_builtins.str]] = None,
            drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enable_dynamic_port_allocation: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_endpoint_independent_mapping: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            icmp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
            initial_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            log_config: Optional[pulumi.Input[Union['RouterNatLogConfigArgs', 'RouterNatLogConfigArgsDict']]] = None,
            max_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
            min_ports_per_vm: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat64_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatNat64SubnetworkArgs', 'RouterNatNat64SubnetworkArgsDict']]]]] = None,
            nat_ip_allocate_option: Optional[pulumi.Input[_builtins.str]] = None,
            nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            router: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatRuleArgs', 'RouterNatRuleArgsDict']]]]] = None,
            source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input[_builtins.str]] = None,
            source_subnetwork_ip_ranges_to_nat64: Optional[pulumi.Input[_builtins.str]] = None,
            subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterNatSubnetworkArgs', 'RouterNatSubnetworkArgsDict']]]]] = None,
            tcp_established_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
            tcp_time_wait_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
            tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            udp_idle_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None) -> 'RouterNat':
        """
        Get an existing RouterNat resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_network_tier: The network tier to use when automatically reserving NAT IP addresses.
               Must be one of: PREMIUM, STANDARD. If not specified, then the current
               project-level default tier is used.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[_builtins.bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation.
               If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
               If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
               If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
               If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
               Mutually exclusive with enableEndpointIndependentMapping.
        :param pulumi.Input[_builtins.bool] enable_endpoint_independent_mapping: Enable endpoint independent mapping.
               For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_types: Specifies the endpoint Types supported by the NAT Gateway.
               Supported values include:
               `ENDPOINT_TYPE_VM`, `ENDPOINT_TYPE_SWG`,
               `ENDPOINT_TYPE_MANAGED_PROXY_LB`.
        :param pulumi.Input[_builtins.int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] initial_nat_ips: Self-links of NAT IPs to be used as initial value for creation alongside a RouterNatAddress resource.
               Conflicts with natIps and drainNatIps. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
        :param pulumi.Input[Union['RouterNatLogConfigArgs', 'RouterNatLogConfigArgsDict']] log_config: Configuration for logging on NAT
               Structure is documented below.
        :param pulumi.Input[_builtins.int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT.
               This field can only be set when enableDynamicPortAllocation is enabled.
        :param pulumi.Input[_builtins.int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT. Defaults to 64 for static port allocation and 32 dynamic port allocation if not set.
        :param pulumi.Input[_builtins.str] name: Name of the NAT service. The name must be 1-63 characters long and
               comply with RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterNatNat64SubnetworkArgs', 'RouterNatNat64SubnetworkArgsDict']]]] nat64_subnetworks: One or more subnetwork NAT configurations whose traffic should be translated by NAT64 Gateway.
               Only used if `source_subnetwork_ip_ranges_to_nat64` is set to `LIST_OF_IPV6_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[_builtins.str] nat_ip_allocate_option: How external IPs should be allocated for this NAT. Valid values are
               `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
               Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
               Possible values are: `MANUAL_ONLY`, `AUTO_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nat_ips: Self-links of NAT IPs. Only valid if natIpAllocateOption
               is set to MANUAL_ONLY.
               If this field is used alongside with a count created list of address resources `google_compute_address.foobar.*.self_link`,
               the access level resource for the address resource must have a `lifecycle` block with `create_before_destroy = true` so
               the number of resources can be increased/decreased without triggering the `resourceInUseByAnotherResource` error.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the router and NAT reside.
        :param pulumi.Input[_builtins.str] router: The name of the Cloud Router in which this NAT will be configured.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterNatRuleArgs', 'RouterNatRuleArgsDict']]]] rules: A list of rules associated with this NAT.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] source_subnetwork_ip_ranges_to_nat: How NAT should be configured per Subnetwork.
               If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
               IP ranges in every Subnetwork are allowed to Nat.
               If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
               ranges in every Subnetwork are allowed to Nat.
               `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
               (specified in the field subnetwork below). Note that if this field
               contains ALL_SUBNETWORKS_ALL_IP_RANGES or
               ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
               other RouterNat section in any Router for this network in this region.
               Possible values are: `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, `LIST_OF_SUBNETWORKS`.
        :param pulumi.Input[_builtins.str] source_subnetwork_ip_ranges_to_nat64: Specify the Nat option for NAT64, which can take one of the following values:
               ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat.
               LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64Subnetwork below).
               Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network.
               Other Router.Nat sections can still be present to enable NAT44 only.
               Possible values are: `ALL_IPV6_SUBNETWORKS`, `LIST_OF_IPV6_SUBNETWORKS`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterNatSubnetworkArgs', 'RouterNatSubnetworkArgsDict']]]] subnetworks: One or more subnetwork NAT configurations. Only used if
               `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[_builtins.int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections.
               Defaults to 1200s if not set.
        :param pulumi.Input[_builtins.int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
               Defaults to 120s if not set.
        :param pulumi.Input[_builtins.int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections.
               Defaults to 30s if not set.
        :param pulumi.Input[_builtins.str] type: Indicates whether this NAT is used for public or private IP translation.
               If unspecified, it defaults to PUBLIC.
               If `PUBLIC` NAT used for public IP translation.
               If `PRIVATE` NAT used for private IP translation.
               Default value is `PUBLIC`.
               Possible values are: `PUBLIC`, `PRIVATE`.
        :param pulumi.Input[_builtins.int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterNatState.__new__(_RouterNatState)

        __props__.__dict__["auto_network_tier"] = auto_network_tier
        __props__.__dict__["drain_nat_ips"] = drain_nat_ips
        __props__.__dict__["enable_dynamic_port_allocation"] = enable_dynamic_port_allocation
        __props__.__dict__["enable_endpoint_independent_mapping"] = enable_endpoint_independent_mapping
        __props__.__dict__["endpoint_types"] = endpoint_types
        __props__.__dict__["icmp_idle_timeout_sec"] = icmp_idle_timeout_sec
        __props__.__dict__["initial_nat_ips"] = initial_nat_ips
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["max_ports_per_vm"] = max_ports_per_vm
        __props__.__dict__["min_ports_per_vm"] = min_ports_per_vm
        __props__.__dict__["name"] = name
        __props__.__dict__["nat64_subnetworks"] = nat64_subnetworks
        __props__.__dict__["nat_ip_allocate_option"] = nat_ip_allocate_option
        __props__.__dict__["nat_ips"] = nat_ips
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["rules"] = rules
        __props__.__dict__["source_subnetwork_ip_ranges_to_nat"] = source_subnetwork_ip_ranges_to_nat
        __props__.__dict__["source_subnetwork_ip_ranges_to_nat64"] = source_subnetwork_ip_ranges_to_nat64
        __props__.__dict__["subnetworks"] = subnetworks
        __props__.__dict__["tcp_established_idle_timeout_sec"] = tcp_established_idle_timeout_sec
        __props__.__dict__["tcp_time_wait_timeout_sec"] = tcp_time_wait_timeout_sec
        __props__.__dict__["tcp_transitory_idle_timeout_sec"] = tcp_transitory_idle_timeout_sec
        __props__.__dict__["type"] = type
        __props__.__dict__["udp_idle_timeout_sec"] = udp_idle_timeout_sec
        return RouterNat(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoNetworkTier")
    def auto_network_tier(self) -> pulumi.Output[_builtins.str]:
        """
        The network tier to use when automatically reserving NAT IP addresses.
        Must be one of: PREMIUM, STANDARD. If not specified, then the current
        project-level default tier is used.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "auto_network_tier")

    @_builtins.property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @_builtins.property
    @pulumi.getter(name="enableDynamicPortAllocation")
    def enable_dynamic_port_allocation(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable Dynamic Port Allocation.
        If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
        If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
        If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
        If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        Mutually exclusive with enableEndpointIndependentMapping.
        """
        return pulumi.get(self, "enable_dynamic_port_allocation")

    @_builtins.property
    @pulumi.getter(name="enableEndpointIndependentMapping")
    def enable_endpoint_independent_mapping(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable endpoint independent mapping.
        For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        """
        return pulumi.get(self, "enable_endpoint_independent_mapping")

    @_builtins.property
    @pulumi.getter(name="endpointTypes")
    def endpoint_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the endpoint Types supported by the NAT Gateway.
        Supported values include:
        `ENDPOINT_TYPE_VM`, `ENDPOINT_TYPE_SWG`,
        `ENDPOINT_TYPE_MANAGED_PROXY_LB`.
        """
        return pulumi.get(self, "endpoint_types")

    @_builtins.property
    @pulumi.getter(name="icmpIdleTimeoutSec")
    def icmp_idle_timeout_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "icmp_idle_timeout_sec")

    @_builtins.property
    @pulumi.getter(name="initialNatIps")
    def initial_nat_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Self-links of NAT IPs to be used as initial value for creation alongside a RouterNatAddress resource.
        Conflicts with natIps and drainNatIps. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "initial_nat_ips")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.RouterNatLogConfig']]:
        """
        Configuration for logging on NAT
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter(name="maxPortsPerVm")
    def max_ports_per_vm(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum number of ports allocated to a VM from this NAT.
        This field can only be set when enableDynamicPortAllocation is enabled.
        """
        return pulumi.get(self, "max_ports_per_vm")

    @_builtins.property
    @pulumi.getter(name="minPortsPerVm")
    def min_ports_per_vm(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum number of ports allocated to a VM from this NAT. Defaults to 64 for static port allocation and 32 dynamic port allocation if not set.
        """
        return pulumi.get(self, "min_ports_per_vm")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the NAT service. The name must be 1-63 characters long and
        comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nat64Subnetworks")
    def nat64_subnetworks(self) -> pulumi.Output[Optional[Sequence['outputs.RouterNatNat64Subnetwork']]]:
        """
        One or more subnetwork NAT configurations whose traffic should be translated by NAT64 Gateway.
        Only used if `source_subnetwork_ip_ranges_to_nat64` is set to `LIST_OF_IPV6_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "nat64_subnetworks")

    @_builtins.property
    @pulumi.getter(name="natIpAllocateOption")
    def nat_ip_allocate_option(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How external IPs should be allocated for this NAT. Valid values are
        `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
        Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
        Possible values are: `MANUAL_ONLY`, `AUTO_ONLY`.
        """
        return pulumi.get(self, "nat_ip_allocate_option")

    @_builtins.property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Self-links of NAT IPs. Only valid if natIpAllocateOption
        is set to MANUAL_ONLY.
        If this field is used alongside with a count created list of address resources `google_compute_address.foobar.*.self_link`,
        the access level resource for the address resource must have a `lifecycle` block with `create_before_destroy = true` so
        the number of resources can be increased/decreased without triggering the `resourceInUseByAnotherResource` error.
        """
        return pulumi.get(self, "nat_ips")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def router(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cloud Router in which this NAT will be configured.
        """
        return pulumi.get(self, "router")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.RouterNatRule']]]:
        """
        A list of rules associated with this NAT.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat")
    def source_subnetwork_ip_ranges_to_nat(self) -> pulumi.Output[_builtins.str]:
        """
        How NAT should be configured per Subnetwork.
        If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
        IP ranges in every Subnetwork are allowed to Nat.
        If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
        ranges in every Subnetwork are allowed to Nat.
        `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
        (specified in the field subnetwork below). Note that if this field
        contains ALL_SUBNETWORKS_ALL_IP_RANGES or
        ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
        other RouterNat section in any Router for this network in this region.
        Possible values are: `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, `LIST_OF_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat")

    @_builtins.property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat64")
    def source_subnetwork_ip_ranges_to_nat64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the Nat option for NAT64, which can take one of the following values:
        ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat.
        LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64Subnetwork below).
        Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network.
        Other Router.Nat sections can still be present to enable NAT44 only.
        Possible values are: `ALL_IPV6_SUBNETWORKS`, `LIST_OF_IPV6_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat64")

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> pulumi.Output[Optional[Sequence['outputs.RouterNatSubnetwork']]]:
        """
        One or more subnetwork NAT configurations. Only used if
        `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "subnetworks")

    @_builtins.property
    @pulumi.getter(name="tcpEstablishedIdleTimeoutSec")
    def tcp_established_idle_timeout_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout (in seconds) for TCP established connections.
        Defaults to 1200s if not set.
        """
        return pulumi.get(self, "tcp_established_idle_timeout_sec")

    @_builtins.property
    @pulumi.getter(name="tcpTimeWaitTimeoutSec")
    def tcp_time_wait_timeout_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
        Defaults to 120s if not set.
        """
        return pulumi.get(self, "tcp_time_wait_timeout_sec")

    @_builtins.property
    @pulumi.getter(name="tcpTransitoryIdleTimeoutSec")
    def tcp_transitory_idle_timeout_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout (in seconds) for TCP transitory connections.
        Defaults to 30s if not set.
        """
        return pulumi.get(self, "tcp_transitory_idle_timeout_sec")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether this NAT is used for public or private IP translation.
        If unspecified, it defaults to PUBLIC.
        If `PUBLIC` NAT used for public IP translation.
        If `PRIVATE` NAT used for private IP translation.
        Default value is `PUBLIC`.
        Possible values are: `PUBLIC`, `PRIVATE`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="udpIdleTimeoutSec")
    def udp_idle_timeout_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "udp_idle_timeout_sec")

