# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityPolicyArgs', 'SecurityPolicy']

@pulumi.input_type
class SecurityPolicyArgs:
    def __init__(__self__, *,
                 adaptive_protection_config: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']] = None,
                 advanced_options_config: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 recaptcha_options_config: Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityPolicy resource.
        :param pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs'] adaptive_protection_config: Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        :param pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs'] advanced_options_config: [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this address. A list of key->value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the security policy.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs'] recaptcha_options_config: [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The type indicates the intended use of the security policy. This field can be set only at resource creation time.
               * `CLOUD_ARMOR` - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
               They filter requests before they hit the origin servers.
               * `CLOUD_ARMOR_EDGE` - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
               (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
               They filter requests before the request is served from Google's cache.
               * `CLOUD_ARMOR_INTERNAL_SERVICE` - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
               managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        if adaptive_protection_config is not None:
            pulumi.set(__self__, "adaptive_protection_config", adaptive_protection_config)
        if advanced_options_config is not None:
            pulumi.set(__self__, "advanced_options_config", advanced_options_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if recaptcha_options_config is not None:
            pulumi.set(__self__, "recaptcha_options_config", recaptcha_options_config)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="adaptiveProtectionConfig")
    def adaptive_protection_config(self) -> Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']]:
        """
        Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        """
        return pulumi.get(self, "adaptive_protection_config")

    @adaptive_protection_config.setter
    def adaptive_protection_config(self, value: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']]):
        pulumi.set(self, "adaptive_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="advancedOptionsConfig")
    def advanced_options_config(self) -> Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']]:
        """
        [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_options_config")

    @advanced_options_config.setter
    def advanced_options_config(self, value: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']]):
        pulumi.set(self, "advanced_options_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this security policy. Max size is 2048.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to this address. A list of key->value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security policy.

        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="recaptchaOptionsConfig")
    def recaptcha_options_config(self) -> Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']]:
        """
        [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        """
        return pulumi.get(self, "recaptcha_options_config")

    @recaptcha_options_config.setter
    def recaptcha_options_config(self, value: Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']]):
        pulumi.set(self, "recaptcha_options_config", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]]:
        """
        The set of rules that belong to this policy. There must always be a default
        rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
        security policy, a default rule with action "allow" will be added. Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type indicates the intended use of the security policy. This field can be set only at resource creation time.
        * `CLOUD_ARMOR` - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
        They filter requests before they hit the origin servers.
        * `CLOUD_ARMOR_EDGE` - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
        (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
        They filter requests before the request is served from Google's cache.
        * `CLOUD_ARMOR_INTERNAL_SERVICE` - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
        managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _SecurityPolicyState:
    def __init__(__self__, *,
                 adaptive_protection_config: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']] = None,
                 advanced_options_config: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 label_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 recaptcha_options_config: Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityPolicy resources.
        :param pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs'] adaptive_protection_config: Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        :param pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs'] advanced_options_config: [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource.
        :param pulumi.Input[_builtins.str] label_fingerprint: The unique fingerprint of the labels.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this address. A list of key->value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the security policy.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs'] recaptcha_options_config: [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] type: The type indicates the intended use of the security policy. This field can be set only at resource creation time.
               * `CLOUD_ARMOR` - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
               They filter requests before they hit the origin servers.
               * `CLOUD_ARMOR_EDGE` - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
               (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
               They filter requests before the request is served from Google's cache.
               * `CLOUD_ARMOR_INTERNAL_SERVICE` - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
               managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        if adaptive_protection_config is not None:
            pulumi.set(__self__, "adaptive_protection_config", adaptive_protection_config)
        if advanced_options_config is not None:
            pulumi.set(__self__, "advanced_options_config", advanced_options_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if recaptcha_options_config is not None:
            pulumi.set(__self__, "recaptcha_options_config", recaptcha_options_config)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="adaptiveProtectionConfig")
    def adaptive_protection_config(self) -> Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']]:
        """
        Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        """
        return pulumi.get(self, "adaptive_protection_config")

    @adaptive_protection_config.setter
    def adaptive_protection_config(self, value: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']]):
        pulumi.set(self, "adaptive_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="advancedOptionsConfig")
    def advanced_options_config(self) -> Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']]:
        """
        [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_options_config")

    @advanced_options_config.setter
    def advanced_options_config(self, value: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']]):
        pulumi.set(self, "advanced_options_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this security policy. Max size is 2048.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique fingerprint of the labels.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to this address. A list of key->value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security policy.

        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="recaptchaOptionsConfig")
    def recaptcha_options_config(self) -> Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']]:
        """
        [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        """
        return pulumi.get(self, "recaptcha_options_config")

    @recaptcha_options_config.setter
    def recaptcha_options_config(self, value: Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']]):
        pulumi.set(self, "recaptcha_options_config", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]]:
        """
        The set of rules that belong to this policy. There must always be a default
        rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
        security policy, a default rule with action "allow" will be added. Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type indicates the intended use of the security policy. This field can be set only at resource creation time.
        * `CLOUD_ARMOR` - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
        They filter requests before they hit the origin servers.
        * `CLOUD_ARMOR_EDGE` - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
        (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
        They filter requests before the request is served from Google's cache.
        * `CLOUD_ARMOR_INTERNAL_SERVICE` - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
        managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("gcp:compute/securityPolicy:SecurityPolicy")
class SecurityPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_protection_config: Optional[pulumi.Input[Union['SecurityPolicyAdaptiveProtectionConfigArgs', 'SecurityPolicyAdaptiveProtectionConfigArgsDict']]] = None,
                 advanced_options_config: Optional[pulumi.Input[Union['SecurityPolicyAdvancedOptionsConfigArgs', 'SecurityPolicyAdvancedOptionsConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 recaptcha_options_config: Optional[pulumi.Input[Union['SecurityPolicyRecaptchaOptionsConfigArgs', 'SecurityPolicyRecaptchaOptionsConfigArgsDict']]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyRuleArgs', 'SecurityPolicyRuleArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Security Policy defines an IP blacklist or whitelist that protects load balanced Google Cloud services by denying or permitting traffic from specified IP ranges. For more information
        see the [official documentation](https://cloud.google.com/armor/docs/configure-security-policies)
        and the [API](https://cloud.google.com/compute/docs/reference/rest/beta/securityPolicies).

        Security Policy is used by google_compute_backend_service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy",
            name="my-policy",
            rules=[
                {
                    "action": "deny(403)",
                    "priority": 1000,
                    "match": {
                        "versioned_expr": "SRC_IPS_V1",
                        "config": {
                            "src_ip_ranges": ["9.9.9.0/24"],
                        },
                    },
                    "description": "Deny access to IPs in 9.9.9.0/24",
                },
                {
                    "action": "allow",
                    "priority": 2147483647,
                    "match": {
                        "versioned_expr": "SRC_IPS_V1",
                        "config": {
                            "src_ip_ranges": ["*"],
                        },
                    },
                    "description": "default rule",
                },
            ])
        ```

        ### With ReCAPTCHA Configuration Options

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            web_settings={
                "integration_type": "INVISIBLE",
                "allow_all_domains": True,
                "allowed_domains": ["localhost"],
            })
        policy = gcp.compute.SecurityPolicy("policy",
            name="my-policy",
            description="basic security policy",
            type="CLOUD_ARMOR",
            recaptcha_options_config={
                "redirect_site_key": primary.name,
            })
        ```

        ### With Header Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy",
            name="my-policy",
            rules=[
                {
                    "action": "allow",
                    "priority": 2147483647,
                    "match": {
                        "versioned_expr": "SRC_IPS_V1",
                        "config": {
                            "src_ip_ranges": ["*"],
                        },
                    },
                    "description": "default rule",
                },
                {
                    "action": "allow",
                    "priority": 1000,
                    "match": {
                        "expr": {
                            "expression": "request.path.matches(\\"/login.html\\") && token.recaptcha_session.score < 0.2",
                        },
                    },
                    "header_action": {
                        "request_headers_to_adds": [
                            {
                                "header_name": "reCAPTCHA-Warning",
                                "header_value": "high",
                            },
                            {
                                "header_name": "X-Resource",
                                "header_value": "test",
                            },
                        ],
                    },
                },
            ])
        ```

        ### With EnforceOnKey Value As Empty String
        A scenario example that won't cause any conflict between `enforce_on_key` and `enforce_on_key_configs`, because `enforce_on_key` was specified as an empty string:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy",
            name="%s",
            description="throttle rule with enforce_on_key_configs",
            rules=[{
                "action": "throttle",
                "priority": 2147483647,
                "match": {
                    "versioned_expr": "SRC_IPS_V1",
                    "config": {
                        "src_ip_ranges": ["*"],
                    },
                },
                "description": "default rule",
                "rate_limit_options": {
                    "conform_action": "allow",
                    "exceed_action": "redirect",
                    "enforce_on_key": "",
                    "enforce_on_key_configs": [{
                        "enforce_on_key_type": "IP",
                    }],
                    "exceed_redirect_options": {
                        "type": "EXTERNAL_302",
                        "target": "<https://www.example.com>",
                    },
                    "rate_limit_threshold": {
                        "count": 10,
                        "interval_sec": 60,
                    },
                },
            }])
        ```

        ## Import

        Security policies can be imported using any of these accepted formats:

        * `projects/{{project}}/global/securityPolicies/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, security policies can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/securityPolicy:SecurityPolicy default projects/{{project}}/global/securityPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/securityPolicy:SecurityPolicy default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/securityPolicy:SecurityPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecurityPolicyAdaptiveProtectionConfigArgs', 'SecurityPolicyAdaptiveProtectionConfigArgsDict']] adaptive_protection_config: Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        :param pulumi.Input[Union['SecurityPolicyAdvancedOptionsConfigArgs', 'SecurityPolicyAdvancedOptionsConfigArgsDict']] advanced_options_config: [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this address. A list of key->value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the security policy.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['SecurityPolicyRecaptchaOptionsConfigArgs', 'SecurityPolicyRecaptchaOptionsConfigArgsDict']] recaptcha_options_config: [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyRuleArgs', 'SecurityPolicyRuleArgsDict']]]] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The type indicates the intended use of the security policy. This field can be set only at resource creation time.
               * `CLOUD_ARMOR` - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
               They filter requests before they hit the origin servers.
               * `CLOUD_ARMOR_EDGE` - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
               (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
               They filter requests before the request is served from Google's cache.
               * `CLOUD_ARMOR_INTERNAL_SERVICE` - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
               managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Security Policy defines an IP blacklist or whitelist that protects load balanced Google Cloud services by denying or permitting traffic from specified IP ranges. For more information
        see the [official documentation](https://cloud.google.com/armor/docs/configure-security-policies)
        and the [API](https://cloud.google.com/compute/docs/reference/rest/beta/securityPolicies).

        Security Policy is used by google_compute_backend_service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy",
            name="my-policy",
            rules=[
                {
                    "action": "deny(403)",
                    "priority": 1000,
                    "match": {
                        "versioned_expr": "SRC_IPS_V1",
                        "config": {
                            "src_ip_ranges": ["9.9.9.0/24"],
                        },
                    },
                    "description": "Deny access to IPs in 9.9.9.0/24",
                },
                {
                    "action": "allow",
                    "priority": 2147483647,
                    "match": {
                        "versioned_expr": "SRC_IPS_V1",
                        "config": {
                            "src_ip_ranges": ["*"],
                        },
                    },
                    "description": "default rule",
                },
            ])
        ```

        ### With ReCAPTCHA Configuration Options

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            web_settings={
                "integration_type": "INVISIBLE",
                "allow_all_domains": True,
                "allowed_domains": ["localhost"],
            })
        policy = gcp.compute.SecurityPolicy("policy",
            name="my-policy",
            description="basic security policy",
            type="CLOUD_ARMOR",
            recaptcha_options_config={
                "redirect_site_key": primary.name,
            })
        ```

        ### With Header Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy",
            name="my-policy",
            rules=[
                {
                    "action": "allow",
                    "priority": 2147483647,
                    "match": {
                        "versioned_expr": "SRC_IPS_V1",
                        "config": {
                            "src_ip_ranges": ["*"],
                        },
                    },
                    "description": "default rule",
                },
                {
                    "action": "allow",
                    "priority": 1000,
                    "match": {
                        "expr": {
                            "expression": "request.path.matches(\\"/login.html\\") && token.recaptcha_session.score < 0.2",
                        },
                    },
                    "header_action": {
                        "request_headers_to_adds": [
                            {
                                "header_name": "reCAPTCHA-Warning",
                                "header_value": "high",
                            },
                            {
                                "header_name": "X-Resource",
                                "header_value": "test",
                            },
                        ],
                    },
                },
            ])
        ```

        ### With EnforceOnKey Value As Empty String
        A scenario example that won't cause any conflict between `enforce_on_key` and `enforce_on_key_configs`, because `enforce_on_key` was specified as an empty string:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy",
            name="%s",
            description="throttle rule with enforce_on_key_configs",
            rules=[{
                "action": "throttle",
                "priority": 2147483647,
                "match": {
                    "versioned_expr": "SRC_IPS_V1",
                    "config": {
                        "src_ip_ranges": ["*"],
                    },
                },
                "description": "default rule",
                "rate_limit_options": {
                    "conform_action": "allow",
                    "exceed_action": "redirect",
                    "enforce_on_key": "",
                    "enforce_on_key_configs": [{
                        "enforce_on_key_type": "IP",
                    }],
                    "exceed_redirect_options": {
                        "type": "EXTERNAL_302",
                        "target": "<https://www.example.com>",
                    },
                    "rate_limit_threshold": {
                        "count": 10,
                        "interval_sec": 60,
                    },
                },
            }])
        ```

        ## Import

        Security policies can be imported using any of these accepted formats:

        * `projects/{{project}}/global/securityPolicies/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, security policies can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/securityPolicy:SecurityPolicy default projects/{{project}}/global/securityPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/securityPolicy:SecurityPolicy default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/securityPolicy:SecurityPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SecurityPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_protection_config: Optional[pulumi.Input[Union['SecurityPolicyAdaptiveProtectionConfigArgs', 'SecurityPolicyAdaptiveProtectionConfigArgsDict']]] = None,
                 advanced_options_config: Optional[pulumi.Input[Union['SecurityPolicyAdvancedOptionsConfigArgs', 'SecurityPolicyAdvancedOptionsConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 recaptcha_options_config: Optional[pulumi.Input[Union['SecurityPolicyRecaptchaOptionsConfigArgs', 'SecurityPolicyRecaptchaOptionsConfigArgsDict']]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyRuleArgs', 'SecurityPolicyRuleArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityPolicyArgs.__new__(SecurityPolicyArgs)

            __props__.__dict__["adaptive_protection_config"] = adaptive_protection_config
            __props__.__dict__["advanced_options_config"] = advanced_options_config
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["recaptcha_options_config"] = recaptcha_options_config
            __props__.__dict__["rules"] = rules
            __props__.__dict__["type"] = type
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecurityPolicy, __self__).__init__(
            'gcp:compute/securityPolicy:SecurityPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adaptive_protection_config: Optional[pulumi.Input[Union['SecurityPolicyAdaptiveProtectionConfigArgs', 'SecurityPolicyAdaptiveProtectionConfigArgsDict']]] = None,
            advanced_options_config: Optional[pulumi.Input[Union['SecurityPolicyAdvancedOptionsConfigArgs', 'SecurityPolicyAdvancedOptionsConfigArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            label_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            recaptcha_options_config: Optional[pulumi.Input[Union['SecurityPolicyRecaptchaOptionsConfigArgs', 'SecurityPolicyRecaptchaOptionsConfigArgsDict']]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyRuleArgs', 'SecurityPolicyRuleArgsDict']]]]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityPolicy':
        """
        Get an existing SecurityPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecurityPolicyAdaptiveProtectionConfigArgs', 'SecurityPolicyAdaptiveProtectionConfigArgsDict']] adaptive_protection_config: Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        :param pulumi.Input[Union['SecurityPolicyAdvancedOptionsConfigArgs', 'SecurityPolicyAdvancedOptionsConfigArgsDict']] advanced_options_config: [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource.
        :param pulumi.Input[_builtins.str] label_fingerprint: The unique fingerprint of the labels.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this address. A list of key->value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the security policy.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[Union['SecurityPolicyRecaptchaOptionsConfigArgs', 'SecurityPolicyRecaptchaOptionsConfigArgsDict']] recaptcha_options_config: [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyRuleArgs', 'SecurityPolicyRuleArgsDict']]]] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] type: The type indicates the intended use of the security policy. This field can be set only at resource creation time.
               * `CLOUD_ARMOR` - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
               They filter requests before they hit the origin servers.
               * `CLOUD_ARMOR_EDGE` - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
               (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
               They filter requests before the request is served from Google's cache.
               * `CLOUD_ARMOR_INTERNAL_SERVICE` - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
               managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityPolicyState.__new__(_SecurityPolicyState)

        __props__.__dict__["adaptive_protection_config"] = adaptive_protection_config
        __props__.__dict__["advanced_options_config"] = advanced_options_config
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["recaptcha_options_config"] = recaptcha_options_config
        __props__.__dict__["rules"] = rules
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["type"] = type
        return SecurityPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adaptiveProtectionConfig")
    def adaptive_protection_config(self) -> pulumi.Output[Optional['outputs.SecurityPolicyAdaptiveProtectionConfig']]:
        """
        Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        """
        return pulumi.get(self, "adaptive_protection_config")

    @_builtins.property
    @pulumi.getter(name="advancedOptionsConfig")
    def advanced_options_config(self) -> pulumi.Output['outputs.SecurityPolicyAdvancedOptionsConfig']:
        """
        [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_options_config")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this security policy. Max size is 2048.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The unique fingerprint of the labels.
        """
        return pulumi.get(self, "label_fingerprint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels to apply to this address. A list of key->value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the security policy.

        - - -
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="recaptchaOptionsConfig")
    def recaptcha_options_config(self) -> pulumi.Output[Optional['outputs.SecurityPolicyRecaptchaOptionsConfig']]:
        """
        [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        """
        return pulumi.get(self, "recaptcha_options_config")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.SecurityPolicyRule']]:
        """
        The set of rules that belong to this policy. There must always be a default
        rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
        security policy, a default rule with action "allow" will be added. Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type indicates the intended use of the security policy. This field can be set only at resource creation time.
        * `CLOUD_ARMOR` - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
        They filter requests before they hit the origin servers.
        * `CLOUD_ARMOR_EDGE` - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
        (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
        They filter requests before the request is served from Google's cache.
        * `CLOUD_ARMOR_INTERNAL_SERVICE` - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
        managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        return pulumi.get(self, "type")

