# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubnetworkArgs', 'Subnetwork']

@pulumi.input_type
class SubnetworkArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[_builtins.str],
                 allow_subnet_cidr_routes_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_collection: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['SubnetworkLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input['SubnetworkParamsArgs']] = None,
                 private_ip_google_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_internal_range: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]] = None,
                 send_secondary_ip_range_if_empty: Optional[pulumi.Input[_builtins.bool]] = None,
                 stack_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Subnetwork resource.
        :param pulumi.Input[_builtins.str] network: The network this subnet belongs to.
               Only networks that are in the distributed mode can have subnetworks.
        :param pulumi.Input[_builtins.bool] allow_subnet_cidr_routes_overlap: Typically packets destined to IPs within the subnetwork range that do not match
               existing resources are dropped and prevented from leaving the VPC.
               Setting this field to true will allow these packets to match dynamic routes injected
               via BGP even if their destinations match existing subnet ranges.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource. This field can be set only at resource
               creation time.
        :param pulumi.Input[_builtins.str] external_ipv6_prefix: The range of external IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[_builtins.str] internal_ipv6_prefix: The internal IPv6 address range that is assigned to this subnetwork.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The range of internal addresses that are owned by this subnetwork.
               Provide this property when you create the subnetwork. For example,
               10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
               non-overlapping within a network. Only IPv4 is supported.
               Field is optional when `reserved_internal_range` is defined, otherwise required.
        :param pulumi.Input[_builtins.str] ip_collection: Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
               in EXTERNAL_IPV6_SUBNETWORK_CREATION or INTERNAL_IPV6_SUBNETWORK_CREATION
               mode. Use one of the following formats to specify a sub-PDP when creating
               a dual stack or IPv6-only subnetwork using BYOIP:
               Full resource URL, as in:
               * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
               Partial URL, as in:
               * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
               * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        :param pulumi.Input[_builtins.str] ipv6_access_type: The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
               or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
               cannot enable direct path.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param pulumi.Input['SubnetworkLogConfigArgs'] log_config: This field denotes the VPC flow logging options for this subnetwork. If
               logging is enabled, logs are exported to Cloud Logging. Flow logging
               isn't supported if the subnet `purpose` field is set to subnetwork is
               `REGIONAL_MANAGED_PROXY` or `GLOBAL_MANAGED_PROXY`.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the resource, provided by the client when initially
               creating the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input['SubnetworkParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] private_ip_google_access: When enabled, VMs in this subnetwork without external IP addresses can
               access Google APIs and services by using Private Google Access.
        :param pulumi.Input[_builtins.str] private_ipv6_google_access: The private IPv6 google access type for the VMs in this subnet.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] purpose: The purpose of the resource. This field can be either `PRIVATE`, `REGIONAL_MANAGED_PROXY`, `GLOBAL_MANAGED_PROXY`, `PRIVATE_SERVICE_CONNECT`, `PEER_MIGRATION` or `PRIVATE_NAT`.
               A subnet with purpose set to `REGIONAL_MANAGED_PROXY` is a user-created subnetwork that is reserved for regional Envoy-based load balancers.
               A subnetwork in a given region with purpose set to `GLOBAL_MANAGED_PROXY` is a proxy-only subnet and is shared between all the cross-regional Envoy-based load balancers.
               A subnetwork with purpose set to `PRIVATE_SERVICE_CONNECT` reserves the subnet for hosting a Private Service Connect published service.
               A subnetwork with purpose set to `PEER_MIGRATION` is a user created subnetwork that is reserved for migrating resources from one peered network to another.
               A subnetwork with purpose set to `PRIVATE_NAT` is used as source range for Private NAT gateways.
               Note that `REGIONAL_MANAGED_PROXY` is the preferred setting for all regional Envoy load balancers.
               If unspecified, the purpose defaults to `PRIVATE`.
        :param pulumi.Input[_builtins.str] region: The GCP region for this subnetwork.
        :param pulumi.Input[_builtins.str] reserved_internal_range: The ID of the reserved internal range. Must be prefixed with `networkconnectivity.googleapis.com`
               E.g. `networkconnectivity.googleapis.com/projects/{project}/locations/global/internalRanges/{rangeId}`
        :param pulumi.Input[_builtins.str] role: The role of subnetwork.
               Currently, this field is only used when `purpose` is `REGIONAL_MANAGED_PROXY`.
               The value can be set to `ACTIVE` or `BACKUP`.
               An `ACTIVE` subnetwork is one that is currently being used for Envoy-based load balancers in a region.
               A `BACKUP` subnetwork is one that is ready to be promoted to `ACTIVE` or is currently draining.
               Possible values are: `ACTIVE`, `BACKUP`.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]] secondary_ip_ranges: An array of configurations for secondary IP ranges for VM instances
               contained in this subnetwork. The primary IP of such VM must belong
               to the primary ipCidrRange of the subnetwork. The alias IPs may belong
               to either primary or secondary ranges.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] send_secondary_ip_range_if_empty: Controls the removal behavior of secondary_ip_range.
               When false, removing secondary_ip_range from config will not produce a diff as
               the provider will default to the API's value.
               When true, the provider will treat removing secondary_ip_range as sending an
               empty list of secondary IP ranges to the API.
               Defaults to false.
        :param pulumi.Input[_builtins.str] stack_type: The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
               If not specified IPV4_ONLY will be used.
               Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        pulumi.set(__self__, "network", network)
        if allow_subnet_cidr_routes_overlap is not None:
            pulumi.set(__self__, "allow_subnet_cidr_routes_overlap", allow_subnet_cidr_routes_overlap)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_ipv6_prefix is not None:
            pulumi.set(__self__, "external_ipv6_prefix", external_ipv6_prefix)
        if internal_ipv6_prefix is not None:
            pulumi.set(__self__, "internal_ipv6_prefix", internal_ipv6_prefix)
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if ip_collection is not None:
            pulumi.set(__self__, "ip_collection", ip_collection)
        if ipv6_access_type is not None:
            pulumi.set(__self__, "ipv6_access_type", ipv6_access_type)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if private_ip_google_access is not None:
            pulumi.set(__self__, "private_ip_google_access", private_ip_google_access)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_internal_range is not None:
            pulumi.set(__self__, "reserved_internal_range", reserved_internal_range)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_ip_ranges is not None:
            pulumi.set(__self__, "secondary_ip_ranges", secondary_ip_ranges)
        if send_secondary_ip_range_if_empty is not None:
            pulumi.set(__self__, "send_secondary_ip_range_if_empty", send_secondary_ip_range_if_empty)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The network this subnet belongs to.
        Only networks that are in the distributed mode can have subnetworks.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="allowSubnetCidrRoutesOverlap")
    def allow_subnet_cidr_routes_overlap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Typically packets destined to IPs within the subnetwork range that do not match
        existing resources are dropped and prevented from leaving the VPC.
        Setting this field to true will allow these packets to match dynamic routes injected
        via BGP even if their destinations match existing subnet ranges.
        """
        return pulumi.get(self, "allow_subnet_cidr_routes_overlap")

    @allow_subnet_cidr_routes_overlap.setter
    def allow_subnet_cidr_routes_overlap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_subnet_cidr_routes_overlap", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource. This field can be set only at resource
        creation time.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalIpv6Prefix")
    def external_ipv6_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of external IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "external_ipv6_prefix")

    @external_ipv6_prefix.setter
    def external_ipv6_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_ipv6_prefix", value)

    @_builtins.property
    @pulumi.getter(name="internalIpv6Prefix")
    def internal_ipv6_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal IPv6 address range that is assigned to this subnetwork.
        """
        return pulumi.get(self, "internal_ipv6_prefix")

    @internal_ipv6_prefix.setter
    def internal_ipv6_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_ipv6_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of internal addresses that are owned by this subnetwork.
        Provide this property when you create the subnetwork. For example,
        10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
        non-overlapping within a network. Only IPv4 is supported.
        Field is optional when `reserved_internal_range` is defined, otherwise required.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="ipCollection")
    def ip_collection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
        in EXTERNAL_IPV6_SUBNETWORK_CREATION or INTERNAL_IPV6_SUBNETWORK_CREATION
        mode. Use one of the following formats to specify a sub-PDP when creating
        a dual stack or IPv6-only subnetwork using BYOIP:
        Full resource URL, as in:
        * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        Partial URL, as in:
        * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
        * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        """
        return pulumi.get(self, "ip_collection")

    @ip_collection.setter
    def ip_collection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_collection", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
        or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
        cannot enable direct path.
        Possible values are: `EXTERNAL`, `INTERNAL`.
        """
        return pulumi.get(self, "ipv6_access_type")

    @ipv6_access_type.setter
    def ipv6_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_access_type", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['SubnetworkLogConfigArgs']]:
        """
        This field denotes the VPC flow logging options for this subnetwork. If
        logging is enabled, logs are exported to Cloud Logging. Flow logging
        isn't supported if the subnet `purpose` field is set to subnetwork is
        `REGIONAL_MANAGED_PROXY` or `GLOBAL_MANAGED_PROXY`.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['SubnetworkLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource, provided by the client when initially
        creating the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['SubnetworkParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['SubnetworkParamsArgs']]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter(name="privateIpGoogleAccess")
    def private_ip_google_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, VMs in this subnetwork without external IP addresses can
        access Google APIs and services by using Private Google Access.
        """
        return pulumi.get(self, "private_ip_google_access")

    @private_ip_google_access.setter
    def private_ip_google_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_ip_google_access", value)

    @_builtins.property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IPv6 google access type for the VMs in this subnet.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @private_ipv6_google_access.setter
    def private_ipv6_google_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ipv6_google_access", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The purpose of the resource. This field can be either `PRIVATE`, `REGIONAL_MANAGED_PROXY`, `GLOBAL_MANAGED_PROXY`, `PRIVATE_SERVICE_CONNECT`, `PEER_MIGRATION` or `PRIVATE_NAT`.
        A subnet with purpose set to `REGIONAL_MANAGED_PROXY` is a user-created subnetwork that is reserved for regional Envoy-based load balancers.
        A subnetwork in a given region with purpose set to `GLOBAL_MANAGED_PROXY` is a proxy-only subnet and is shared between all the cross-regional Envoy-based load balancers.
        A subnetwork with purpose set to `PRIVATE_SERVICE_CONNECT` reserves the subnet for hosting a Private Service Connect published service.
        A subnetwork with purpose set to `PEER_MIGRATION` is a user created subnetwork that is reserved for migrating resources from one peered network to another.
        A subnetwork with purpose set to `PRIVATE_NAT` is used as source range for Private NAT gateways.
        Note that `REGIONAL_MANAGED_PROXY` is the preferred setting for all regional Envoy load balancers.
        If unspecified, the purpose defaults to `PRIVATE`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purpose", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCP region for this subnetwork.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedInternalRange")
    def reserved_internal_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the reserved internal range. Must be prefixed with `networkconnectivity.googleapis.com`
        E.g. `networkconnectivity.googleapis.com/projects/{project}/locations/global/internalRanges/{rangeId}`
        """
        return pulumi.get(self, "reserved_internal_range")

    @reserved_internal_range.setter
    def reserved_internal_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_internal_range", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of subnetwork.
        Currently, this field is only used when `purpose` is `REGIONAL_MANAGED_PROXY`.
        The value can be set to `ACTIVE` or `BACKUP`.
        An `ACTIVE` subnetwork is one that is currently being used for Envoy-based load balancers in a region.
        A `BACKUP` subnetwork is one that is ready to be promoted to `ACTIVE` or is currently draining.
        Possible values are: `ACTIVE`, `BACKUP`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpRanges")
    def secondary_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]]:
        """
        An array of configurations for secondary IP ranges for VM instances
        contained in this subnetwork. The primary IP of such VM must belong
        to the primary ipCidrRange of the subnetwork. The alias IPs may belong
        to either primary or secondary ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_ip_ranges")

    @secondary_ip_ranges.setter
    def secondary_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]]):
        pulumi.set(self, "secondary_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="sendSecondaryIpRangeIfEmpty")
    def send_secondary_ip_range_if_empty(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls the removal behavior of secondary_ip_range.
        When false, removing secondary_ip_range from config will not produce a diff as
        the provider will default to the API's value.
        When true, the provider will treat removing secondary_ip_range as sending an
        empty list of secondary IP ranges to the API.
        Defaults to false.
        """
        return pulumi.get(self, "send_secondary_ip_range_if_empty")

    @send_secondary_ip_range_if_empty.setter
    def send_secondary_ip_range_if_empty(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_secondary_ip_range_if_empty", value)

    @_builtins.property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
        If not specified IPV4_ONLY will be used.
        Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_type", value)


@pulumi.input_type
class _SubnetworkState:
    def __init__(__self__, *,
                 allow_subnet_cidr_routes_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_address: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_collection: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gce_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['SubnetworkLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input['SubnetworkParamsArgs']] = None,
                 private_ip_google_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_internal_range: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 send_secondary_ip_range_if_empty: Optional[pulumi.Input[_builtins.bool]] = None,
                 stack_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Subnetwork resources.
        :param pulumi.Input[_builtins.bool] allow_subnet_cidr_routes_overlap: Typically packets destined to IPs within the subnetwork range that do not match
               existing resources are dropped and prevented from leaving the VPC.
               Setting this field to true will allow these packets to match dynamic routes injected
               via BGP even if their destinations match existing subnet ranges.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource. This field can be set only at resource
               creation time.
        :param pulumi.Input[_builtins.str] external_ipv6_prefix: The range of external IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. This field is used internally during updates of this resource.
        :param pulumi.Input[_builtins.str] gateway_address: The gateway address for default routes to reach destination addresses
               outside this subnetwork.
        :param pulumi.Input[_builtins.str] internal_ipv6_prefix: The internal IPv6 address range that is assigned to this subnetwork.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The range of internal addresses that are owned by this subnetwork.
               Provide this property when you create the subnetwork. For example,
               10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
               non-overlapping within a network. Only IPv4 is supported.
               Field is optional when `reserved_internal_range` is defined, otherwise required.
        :param pulumi.Input[_builtins.str] ip_collection: Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
               in EXTERNAL_IPV6_SUBNETWORK_CREATION or INTERNAL_IPV6_SUBNETWORK_CREATION
               mode. Use one of the following formats to specify a sub-PDP when creating
               a dual stack or IPv6-only subnetwork using BYOIP:
               Full resource URL, as in:
               * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
               Partial URL, as in:
               * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
               * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        :param pulumi.Input[_builtins.str] ipv6_access_type: The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
               or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
               cannot enable direct path.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param pulumi.Input[_builtins.str] ipv6_cidr_range: The range of internal IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[_builtins.str] ipv6_gce_endpoint: Possible endpoints of this subnetwork. It can be one of the following:
               * VM_ONLY: The subnetwork can be used for creating instances and IPv6 addresses with VM endpoint type. Such a subnetwork
               gets external IPv6 ranges from a public delegated prefix and cannot be used to create NetLb.
               * VM_AND_FR: The subnetwork can be used for creating both VM instances and Forwarding Rules. It can also be used to reserve
               IPv6 addresses with both VM and FR endpoint types. Such a subnetwork gets its IPv6 range from Google IP Pool directly.
        :param pulumi.Input['SubnetworkLogConfigArgs'] log_config: This field denotes the VPC flow logging options for this subnetwork. If
               logging is enabled, logs are exported to Cloud Logging. Flow logging
               isn't supported if the subnet `purpose` field is set to subnetwork is
               `REGIONAL_MANAGED_PROXY` or `GLOBAL_MANAGED_PROXY`.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the resource, provided by the client when initially
               creating the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The network this subnet belongs to.
               Only networks that are in the distributed mode can have subnetworks.
        :param pulumi.Input['SubnetworkParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] private_ip_google_access: When enabled, VMs in this subnetwork without external IP addresses can
               access Google APIs and services by using Private Google Access.
        :param pulumi.Input[_builtins.str] private_ipv6_google_access: The private IPv6 google access type for the VMs in this subnet.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] purpose: The purpose of the resource. This field can be either `PRIVATE`, `REGIONAL_MANAGED_PROXY`, `GLOBAL_MANAGED_PROXY`, `PRIVATE_SERVICE_CONNECT`, `PEER_MIGRATION` or `PRIVATE_NAT`.
               A subnet with purpose set to `REGIONAL_MANAGED_PROXY` is a user-created subnetwork that is reserved for regional Envoy-based load balancers.
               A subnetwork in a given region with purpose set to `GLOBAL_MANAGED_PROXY` is a proxy-only subnet and is shared between all the cross-regional Envoy-based load balancers.
               A subnetwork with purpose set to `PRIVATE_SERVICE_CONNECT` reserves the subnet for hosting a Private Service Connect published service.
               A subnetwork with purpose set to `PEER_MIGRATION` is a user created subnetwork that is reserved for migrating resources from one peered network to another.
               A subnetwork with purpose set to `PRIVATE_NAT` is used as source range for Private NAT gateways.
               Note that `REGIONAL_MANAGED_PROXY` is the preferred setting for all regional Envoy load balancers.
               If unspecified, the purpose defaults to `PRIVATE`.
        :param pulumi.Input[_builtins.str] region: The GCP region for this subnetwork.
        :param pulumi.Input[_builtins.str] reserved_internal_range: The ID of the reserved internal range. Must be prefixed with `networkconnectivity.googleapis.com`
               E.g. `networkconnectivity.googleapis.com/projects/{project}/locations/global/internalRanges/{rangeId}`
        :param pulumi.Input[_builtins.str] role: The role of subnetwork.
               Currently, this field is only used when `purpose` is `REGIONAL_MANAGED_PROXY`.
               The value can be set to `ACTIVE` or `BACKUP`.
               An `ACTIVE` subnetwork is one that is currently being used for Envoy-based load balancers in a region.
               A `BACKUP` subnetwork is one that is ready to be promoted to `ACTIVE` or is currently draining.
               Possible values are: `ACTIVE`, `BACKUP`.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]] secondary_ip_ranges: An array of configurations for secondary IP ranges for VM instances
               contained in this subnetwork. The primary IP of such VM must belong
               to the primary ipCidrRange of the subnetwork. The alias IPs may belong
               to either primary or secondary ranges.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.bool] send_secondary_ip_range_if_empty: Controls the removal behavior of secondary_ip_range.
               When false, removing secondary_ip_range from config will not produce a diff as
               the provider will default to the API's value.
               When true, the provider will treat removing secondary_ip_range as sending an
               empty list of secondary IP ranges to the API.
               Defaults to false.
        :param pulumi.Input[_builtins.str] stack_type: The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
               If not specified IPV4_ONLY will be used.
               Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] state: 'The state of the subnetwork, which can be one of the following values:
               READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose
               set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained.
               A subnetwork that is draining cannot be used or modified until it reaches a status of READY'
        :param pulumi.Input[_builtins.int] subnetwork_id: The unique identifier number for the resource. This identifier is defined by the server.
        """
        if allow_subnet_cidr_routes_overlap is not None:
            pulumi.set(__self__, "allow_subnet_cidr_routes_overlap", allow_subnet_cidr_routes_overlap)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_ipv6_prefix is not None:
            pulumi.set(__self__, "external_ipv6_prefix", external_ipv6_prefix)
        if fingerprint is not None:
            warnings.warn("""This field is not useful for users, and has been removed as an output.""", DeprecationWarning)
            pulumi.log.warn("""fingerprint is deprecated: This field is not useful for users, and has been removed as an output.""")
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if gateway_address is not None:
            pulumi.set(__self__, "gateway_address", gateway_address)
        if internal_ipv6_prefix is not None:
            pulumi.set(__self__, "internal_ipv6_prefix", internal_ipv6_prefix)
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if ip_collection is not None:
            pulumi.set(__self__, "ip_collection", ip_collection)
        if ipv6_access_type is not None:
            pulumi.set(__self__, "ipv6_access_type", ipv6_access_type)
        if ipv6_cidr_range is not None:
            pulumi.set(__self__, "ipv6_cidr_range", ipv6_cidr_range)
        if ipv6_gce_endpoint is not None:
            pulumi.set(__self__, "ipv6_gce_endpoint", ipv6_gce_endpoint)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if private_ip_google_access is not None:
            pulumi.set(__self__, "private_ip_google_access", private_ip_google_access)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_internal_range is not None:
            pulumi.set(__self__, "reserved_internal_range", reserved_internal_range)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_ip_ranges is not None:
            pulumi.set(__self__, "secondary_ip_ranges", secondary_ip_ranges)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if send_secondary_ip_range_if_empty is not None:
            pulumi.set(__self__, "send_secondary_ip_range_if_empty", send_secondary_ip_range_if_empty)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnetwork_id is not None:
            pulumi.set(__self__, "subnetwork_id", subnetwork_id)

    @_builtins.property
    @pulumi.getter(name="allowSubnetCidrRoutesOverlap")
    def allow_subnet_cidr_routes_overlap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Typically packets destined to IPs within the subnetwork range that do not match
        existing resources are dropped and prevented from leaving the VPC.
        Setting this field to true will allow these packets to match dynamic routes injected
        via BGP even if their destinations match existing subnet ranges.
        """
        return pulumi.get(self, "allow_subnet_cidr_routes_overlap")

    @allow_subnet_cidr_routes_overlap.setter
    def allow_subnet_cidr_routes_overlap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_subnet_cidr_routes_overlap", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource. This field can be set only at resource
        creation time.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalIpv6Prefix")
    def external_ipv6_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of external IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "external_ipv6_prefix")

    @external_ipv6_prefix.setter
    def external_ipv6_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_ipv6_prefix", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This field is not useful for users, and has been removed as an output.""")
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint of this resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The gateway address for default routes to reach destination addresses
        outside this subnetwork.
        """
        return pulumi.get(self, "gateway_address")

    @gateway_address.setter
    def gateway_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_address", value)

    @_builtins.property
    @pulumi.getter(name="internalIpv6Prefix")
    def internal_ipv6_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal IPv6 address range that is assigned to this subnetwork.
        """
        return pulumi.get(self, "internal_ipv6_prefix")

    @internal_ipv6_prefix.setter
    def internal_ipv6_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_ipv6_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of internal addresses that are owned by this subnetwork.
        Provide this property when you create the subnetwork. For example,
        10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
        non-overlapping within a network. Only IPv4 is supported.
        Field is optional when `reserved_internal_range` is defined, otherwise required.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="ipCollection")
    def ip_collection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
        in EXTERNAL_IPV6_SUBNETWORK_CREATION or INTERNAL_IPV6_SUBNETWORK_CREATION
        mode. Use one of the following formats to specify a sub-PDP when creating
        a dual stack or IPv6-only subnetwork using BYOIP:
        Full resource URL, as in:
        * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        Partial URL, as in:
        * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
        * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        """
        return pulumi.get(self, "ip_collection")

    @ip_collection.setter
    def ip_collection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_collection", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
        or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
        cannot enable direct path.
        Possible values are: `EXTERNAL`, `INTERNAL`.
        """
        return pulumi.get(self, "ipv6_access_type")

    @ipv6_access_type.setter
    def ipv6_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_access_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6CidrRange")
    def ipv6_cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of internal IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "ipv6_cidr_range")

    @ipv6_cidr_range.setter
    def ipv6_cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="ipv6GceEndpoint")
    def ipv6_gce_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible endpoints of this subnetwork. It can be one of the following:
        * VM_ONLY: The subnetwork can be used for creating instances and IPv6 addresses with VM endpoint type. Such a subnetwork
        gets external IPv6 ranges from a public delegated prefix and cannot be used to create NetLb.
        * VM_AND_FR: The subnetwork can be used for creating both VM instances and Forwarding Rules. It can also be used to reserve
        IPv6 addresses with both VM and FR endpoint types. Such a subnetwork gets its IPv6 range from Google IP Pool directly.
        """
        return pulumi.get(self, "ipv6_gce_endpoint")

    @ipv6_gce_endpoint.setter
    def ipv6_gce_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_gce_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['SubnetworkLogConfigArgs']]:
        """
        This field denotes the VPC flow logging options for this subnetwork. If
        logging is enabled, logs are exported to Cloud Logging. Flow logging
        isn't supported if the subnet `purpose` field is set to subnetwork is
        `REGIONAL_MANAGED_PROXY` or `GLOBAL_MANAGED_PROXY`.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['SubnetworkLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource, provided by the client when initially
        creating the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network this subnet belongs to.
        Only networks that are in the distributed mode can have subnetworks.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['SubnetworkParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['SubnetworkParamsArgs']]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter(name="privateIpGoogleAccess")
    def private_ip_google_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, VMs in this subnetwork without external IP addresses can
        access Google APIs and services by using Private Google Access.
        """
        return pulumi.get(self, "private_ip_google_access")

    @private_ip_google_access.setter
    def private_ip_google_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_ip_google_access", value)

    @_builtins.property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IPv6 google access type for the VMs in this subnet.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @private_ipv6_google_access.setter
    def private_ipv6_google_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ipv6_google_access", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The purpose of the resource. This field can be either `PRIVATE`, `REGIONAL_MANAGED_PROXY`, `GLOBAL_MANAGED_PROXY`, `PRIVATE_SERVICE_CONNECT`, `PEER_MIGRATION` or `PRIVATE_NAT`.
        A subnet with purpose set to `REGIONAL_MANAGED_PROXY` is a user-created subnetwork that is reserved for regional Envoy-based load balancers.
        A subnetwork in a given region with purpose set to `GLOBAL_MANAGED_PROXY` is a proxy-only subnet and is shared between all the cross-regional Envoy-based load balancers.
        A subnetwork with purpose set to `PRIVATE_SERVICE_CONNECT` reserves the subnet for hosting a Private Service Connect published service.
        A subnetwork with purpose set to `PEER_MIGRATION` is a user created subnetwork that is reserved for migrating resources from one peered network to another.
        A subnetwork with purpose set to `PRIVATE_NAT` is used as source range for Private NAT gateways.
        Note that `REGIONAL_MANAGED_PROXY` is the preferred setting for all regional Envoy load balancers.
        If unspecified, the purpose defaults to `PRIVATE`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purpose", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCP region for this subnetwork.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedInternalRange")
    def reserved_internal_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the reserved internal range. Must be prefixed with `networkconnectivity.googleapis.com`
        E.g. `networkconnectivity.googleapis.com/projects/{project}/locations/global/internalRanges/{rangeId}`
        """
        return pulumi.get(self, "reserved_internal_range")

    @reserved_internal_range.setter
    def reserved_internal_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_internal_range", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of subnetwork.
        Currently, this field is only used when `purpose` is `REGIONAL_MANAGED_PROXY`.
        The value can be set to `ACTIVE` or `BACKUP`.
        An `ACTIVE` subnetwork is one that is currently being used for Envoy-based load balancers in a region.
        A `BACKUP` subnetwork is one that is ready to be promoted to `ACTIVE` or is currently draining.
        Possible values are: `ACTIVE`, `BACKUP`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpRanges")
    def secondary_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]]:
        """
        An array of configurations for secondary IP ranges for VM instances
        contained in this subnetwork. The primary IP of such VM must belong
        to the primary ipCidrRange of the subnetwork. The alias IPs may belong
        to either primary or secondary ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_ip_ranges")

    @secondary_ip_ranges.setter
    def secondary_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]]):
        pulumi.set(self, "secondary_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="sendSecondaryIpRangeIfEmpty")
    def send_secondary_ip_range_if_empty(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls the removal behavior of secondary_ip_range.
        When false, removing secondary_ip_range from config will not produce a diff as
        the provider will default to the API's value.
        When true, the provider will treat removing secondary_ip_range as sending an
        empty list of secondary IP ranges to the API.
        Defaults to false.
        """
        return pulumi.get(self, "send_secondary_ip_range_if_empty")

    @send_secondary_ip_range_if_empty.setter
    def send_secondary_ip_range_if_empty(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_secondary_ip_range_if_empty", value)

    @_builtins.property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
        If not specified IPV4_ONLY will be used.
        Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        'The state of the subnetwork, which can be one of the following values:
        READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose
        set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained.
        A subnetwork that is draining cannot be used or modified until it reaches a status of READY'
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subnetworkId")
    def subnetwork_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "subnetwork_id")

    @subnetwork_id.setter
    def subnetwork_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "subnetwork_id", value)


@pulumi.type_token("gcp:compute/subnetwork:Subnetwork")
class Subnetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_subnet_cidr_routes_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_collection: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['SubnetworkLogConfigArgs', 'SubnetworkLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Union['SubnetworkParamsArgs', 'SubnetworkParamsArgsDict']]] = None,
                 private_ip_google_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_internal_range: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubnetworkSecondaryIpRangeArgs', 'SubnetworkSecondaryIpRangeArgsDict']]]]] = None,
                 send_secondary_ip_range_if_empty: Optional[pulumi.Input[_builtins.bool]] = None,
                 stack_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A VPC network is a virtual version of the traditional physical networks
        that exist within and between physical data centers. A VPC network
        provides connectivity for your Compute Engine virtual machine (VM)
        instances, Container Engine containers, App Engine Flex services, and
        other network-related resources.

        Each GCP project contains one or more VPC networks. Each VPC network is a
        global entity spanning all GCP regions. This global VPC network allows VM
        instances and other resources to communicate with each other via internal,
        private IP addresses.

        Each VPC network is subdivided into subnets, and each subnet is contained
        within a single region. You can have more than one subnet in a region for
        a given VPC network. Each subnet has a contiguous private RFC1918 IP
        space. You create instances, containers, and the like in these subnets.
        When you create an instance, you must create it in a subnet, and the
        instance draws its internal IP address from that subnet.

        Virtual machine (VM) instances in a VPC network can communicate with
        instances in all other subnets of the same VPC network, regardless of
        region, using their RFC1918 private IP addresses. You can isolate portions
        of the network, even entire subnets, using firewall rules.

        To get more information about Subnetwork, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/subnetworks)
        * How-to Guides
            * [Cloud Networking](https://cloud.google.com/vpc/docs/using-vpc)
            * [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)

        ## Example Usage

        ### Subnetwork Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="test-network",
            auto_create_subnetworks=False)
        network_with_private_secondary_ip_ranges = gcp.compute.Subnetwork("network-with-private-secondary-ip-ranges",
            name="test-subnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=custom_test.id,
            secondary_ip_ranges=[{
                "range_name": "tf-test-secondary-range-update1",
                "ip_cidr_range": "192.168.10.0/24",
            }])
        ```
        ### Subnetwork Logging Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="log-test-network",
            auto_create_subnetworks=False)
        subnet_with_logging = gcp.compute.Subnetwork("subnet-with-logging",
            name="log-test-subnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=custom_test.id,
            log_config={
                "aggregation_interval": "INTERVAL_10_MIN",
                "flow_sampling": 0.5,
                "metadata": "INCLUDE_ALL_METADATA",
            })
        ```
        ### Subnetwork Internal L7lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="l7lb-test-network",
            auto_create_subnetworks=False)
        network_for_l7lb = gcp.compute.Subnetwork("network-for-l7lb",
            name="l7lb-test-subnetwork",
            ip_cidr_range="10.0.0.0/22",
            region="us-central1",
            purpose="REGIONAL_MANAGED_PROXY",
            role="ACTIVE",
            network=custom_test.id)
        ```
        ### Subnetwork Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="ipv6-test-network",
            auto_create_subnetworks=False)
        subnetwork_ipv6 = gcp.compute.Subnetwork("subnetwork-ipv6",
            name="ipv6-test-subnetwork",
            ip_cidr_range="10.0.0.0/22",
            region="us-west2",
            stack_type="IPV4_IPV6",
            ipv6_access_type="EXTERNAL",
            network=custom_test.id)
        ```
        ### Subnetwork Internal Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="internal-ipv6-test-network",
            auto_create_subnetworks=False,
            enable_ula_internal_ipv6=True)
        subnetwork_internal_ipv6 = gcp.compute.Subnetwork("subnetwork-internal-ipv6",
            name="internal-ipv6-test-subnetwork",
            ip_cidr_range="10.0.0.0/22",
            region="us-west2",
            stack_type="IPV4_IPV6",
            ipv6_access_type="INTERNAL",
            network=custom_test.id)
        ```
        ### Subnetwork Purpose Private Nat

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="subnet-purpose-test-network",
            auto_create_subnetworks=False)
        subnetwork_purpose_private_nat = gcp.compute.Subnetwork("subnetwork-purpose-private-nat",
            name="subnet-purpose-test-subnetwork",
            region="us-west2",
            ip_cidr_range="192.168.1.0/24",
            purpose="PRIVATE_NAT",
            network=custom_test.id)
        ```
        ### Subnetwork Cidr Overlap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net_cidr_overlap = gcp.compute.Network("net-cidr-overlap",
            name="net-cidr-overlap",
            auto_create_subnetworks=False)
        subnetwork_cidr_overlap = gcp.compute.Subnetwork("subnetwork-cidr-overlap",
            name="subnet-cidr-overlap",
            region="us-west2",
            ip_cidr_range="192.168.1.0/24",
            allow_subnet_cidr_routes_overlap=True,
            network=net_cidr_overlap.id)
        ```
        ### Subnetwork Reserved Internal Range

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network-reserved-internal-range",
            auto_create_subnetworks=False)
        reserved = gcp.networkconnectivity.InternalRange("reserved",
            name="reserved",
            network=default.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            prefix_length=24,
            target_cidr_ranges=["10.0.0.0/8"])
        subnetwork_reserved_internal_range = gcp.compute.Subnetwork("subnetwork-reserved-internal-range",
            name="subnetwork-reserved-internal-range",
            region="us-central1",
            network=default.id,
            reserved_internal_range=reserved.id.apply(lambda id: f"networkconnectivity.googleapis.com/{id}"))
        ```
        ### Subnetwork Reserved Secondary Range

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network-reserved-secondary-range",
            auto_create_subnetworks=False)
        reserved = gcp.networkconnectivity.InternalRange("reserved",
            name="reserved-primary",
            network=default.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            prefix_length=24,
            target_cidr_ranges=["10.0.0.0/8"])
        reserved_secondary = gcp.networkconnectivity.InternalRange("reserved_secondary",
            name="reserved-secondary",
            network=default.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            prefix_length=16,
            target_cidr_ranges=["10.0.0.0/8"])
        subnetwork_reserved_secondary_range = gcp.compute.Subnetwork("subnetwork-reserved-secondary-range",
            name="subnetwork-reserved-secondary-range",
            region="us-central1",
            network=default.id,
            reserved_internal_range=reserved.id.apply(lambda id: f"networkconnectivity.googleapis.com/{id}"),
            secondary_ip_ranges=[{
                "range_name": "secondary",
                "reserved_internal_range": reserved_secondary.id.apply(lambda id: f"networkconnectivity.googleapis.com/{id}"),
            }])
        ```

        ## Import

        Subnetwork can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/subnetworks/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Subnetwork can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/subnetwork:Subnetwork default projects/{{project}}/regions/{{region}}/subnetworks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/subnetwork:Subnetwork default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/subnetwork:Subnetwork default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/subnetwork:Subnetwork default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_subnet_cidr_routes_overlap: Typically packets destined to IPs within the subnetwork range that do not match
               existing resources are dropped and prevented from leaving the VPC.
               Setting this field to true will allow these packets to match dynamic routes injected
               via BGP even if their destinations match existing subnet ranges.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource. This field can be set only at resource
               creation time.
        :param pulumi.Input[_builtins.str] external_ipv6_prefix: The range of external IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[_builtins.str] internal_ipv6_prefix: The internal IPv6 address range that is assigned to this subnetwork.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The range of internal addresses that are owned by this subnetwork.
               Provide this property when you create the subnetwork. For example,
               10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
               non-overlapping within a network. Only IPv4 is supported.
               Field is optional when `reserved_internal_range` is defined, otherwise required.
        :param pulumi.Input[_builtins.str] ip_collection: Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
               in EXTERNAL_IPV6_SUBNETWORK_CREATION or INTERNAL_IPV6_SUBNETWORK_CREATION
               mode. Use one of the following formats to specify a sub-PDP when creating
               a dual stack or IPv6-only subnetwork using BYOIP:
               Full resource URL, as in:
               * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
               Partial URL, as in:
               * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
               * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        :param pulumi.Input[_builtins.str] ipv6_access_type: The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
               or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
               cannot enable direct path.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param pulumi.Input[Union['SubnetworkLogConfigArgs', 'SubnetworkLogConfigArgsDict']] log_config: This field denotes the VPC flow logging options for this subnetwork. If
               logging is enabled, logs are exported to Cloud Logging. Flow logging
               isn't supported if the subnet `purpose` field is set to subnetwork is
               `REGIONAL_MANAGED_PROXY` or `GLOBAL_MANAGED_PROXY`.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the resource, provided by the client when initially
               creating the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The network this subnet belongs to.
               Only networks that are in the distributed mode can have subnetworks.
        :param pulumi.Input[Union['SubnetworkParamsArgs', 'SubnetworkParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] private_ip_google_access: When enabled, VMs in this subnetwork without external IP addresses can
               access Google APIs and services by using Private Google Access.
        :param pulumi.Input[_builtins.str] private_ipv6_google_access: The private IPv6 google access type for the VMs in this subnet.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] purpose: The purpose of the resource. This field can be either `PRIVATE`, `REGIONAL_MANAGED_PROXY`, `GLOBAL_MANAGED_PROXY`, `PRIVATE_SERVICE_CONNECT`, `PEER_MIGRATION` or `PRIVATE_NAT`.
               A subnet with purpose set to `REGIONAL_MANAGED_PROXY` is a user-created subnetwork that is reserved for regional Envoy-based load balancers.
               A subnetwork in a given region with purpose set to `GLOBAL_MANAGED_PROXY` is a proxy-only subnet and is shared between all the cross-regional Envoy-based load balancers.
               A subnetwork with purpose set to `PRIVATE_SERVICE_CONNECT` reserves the subnet for hosting a Private Service Connect published service.
               A subnetwork with purpose set to `PEER_MIGRATION` is a user created subnetwork that is reserved for migrating resources from one peered network to another.
               A subnetwork with purpose set to `PRIVATE_NAT` is used as source range for Private NAT gateways.
               Note that `REGIONAL_MANAGED_PROXY` is the preferred setting for all regional Envoy load balancers.
               If unspecified, the purpose defaults to `PRIVATE`.
        :param pulumi.Input[_builtins.str] region: The GCP region for this subnetwork.
        :param pulumi.Input[_builtins.str] reserved_internal_range: The ID of the reserved internal range. Must be prefixed with `networkconnectivity.googleapis.com`
               E.g. `networkconnectivity.googleapis.com/projects/{project}/locations/global/internalRanges/{rangeId}`
        :param pulumi.Input[_builtins.str] role: The role of subnetwork.
               Currently, this field is only used when `purpose` is `REGIONAL_MANAGED_PROXY`.
               The value can be set to `ACTIVE` or `BACKUP`.
               An `ACTIVE` subnetwork is one that is currently being used for Envoy-based load balancers in a region.
               A `BACKUP` subnetwork is one that is ready to be promoted to `ACTIVE` or is currently draining.
               Possible values are: `ACTIVE`, `BACKUP`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubnetworkSecondaryIpRangeArgs', 'SubnetworkSecondaryIpRangeArgsDict']]]] secondary_ip_ranges: An array of configurations for secondary IP ranges for VM instances
               contained in this subnetwork. The primary IP of such VM must belong
               to the primary ipCidrRange of the subnetwork. The alias IPs may belong
               to either primary or secondary ranges.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] send_secondary_ip_range_if_empty: Controls the removal behavior of secondary_ip_range.
               When false, removing secondary_ip_range from config will not produce a diff as
               the provider will default to the API's value.
               When true, the provider will treat removing secondary_ip_range as sending an
               empty list of secondary IP ranges to the API.
               Defaults to false.
        :param pulumi.Input[_builtins.str] stack_type: The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
               If not specified IPV4_ONLY will be used.
               Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A VPC network is a virtual version of the traditional physical networks
        that exist within and between physical data centers. A VPC network
        provides connectivity for your Compute Engine virtual machine (VM)
        instances, Container Engine containers, App Engine Flex services, and
        other network-related resources.

        Each GCP project contains one or more VPC networks. Each VPC network is a
        global entity spanning all GCP regions. This global VPC network allows VM
        instances and other resources to communicate with each other via internal,
        private IP addresses.

        Each VPC network is subdivided into subnets, and each subnet is contained
        within a single region. You can have more than one subnet in a region for
        a given VPC network. Each subnet has a contiguous private RFC1918 IP
        space. You create instances, containers, and the like in these subnets.
        When you create an instance, you must create it in a subnet, and the
        instance draws its internal IP address from that subnet.

        Virtual machine (VM) instances in a VPC network can communicate with
        instances in all other subnets of the same VPC network, regardless of
        region, using their RFC1918 private IP addresses. You can isolate portions
        of the network, even entire subnets, using firewall rules.

        To get more information about Subnetwork, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/subnetworks)
        * How-to Guides
            * [Cloud Networking](https://cloud.google.com/vpc/docs/using-vpc)
            * [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)

        ## Example Usage

        ### Subnetwork Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="test-network",
            auto_create_subnetworks=False)
        network_with_private_secondary_ip_ranges = gcp.compute.Subnetwork("network-with-private-secondary-ip-ranges",
            name="test-subnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=custom_test.id,
            secondary_ip_ranges=[{
                "range_name": "tf-test-secondary-range-update1",
                "ip_cidr_range": "192.168.10.0/24",
            }])
        ```
        ### Subnetwork Logging Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="log-test-network",
            auto_create_subnetworks=False)
        subnet_with_logging = gcp.compute.Subnetwork("subnet-with-logging",
            name="log-test-subnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=custom_test.id,
            log_config={
                "aggregation_interval": "INTERVAL_10_MIN",
                "flow_sampling": 0.5,
                "metadata": "INCLUDE_ALL_METADATA",
            })
        ```
        ### Subnetwork Internal L7lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="l7lb-test-network",
            auto_create_subnetworks=False)
        network_for_l7lb = gcp.compute.Subnetwork("network-for-l7lb",
            name="l7lb-test-subnetwork",
            ip_cidr_range="10.0.0.0/22",
            region="us-central1",
            purpose="REGIONAL_MANAGED_PROXY",
            role="ACTIVE",
            network=custom_test.id)
        ```
        ### Subnetwork Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="ipv6-test-network",
            auto_create_subnetworks=False)
        subnetwork_ipv6 = gcp.compute.Subnetwork("subnetwork-ipv6",
            name="ipv6-test-subnetwork",
            ip_cidr_range="10.0.0.0/22",
            region="us-west2",
            stack_type="IPV4_IPV6",
            ipv6_access_type="EXTERNAL",
            network=custom_test.id)
        ```
        ### Subnetwork Internal Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="internal-ipv6-test-network",
            auto_create_subnetworks=False,
            enable_ula_internal_ipv6=True)
        subnetwork_internal_ipv6 = gcp.compute.Subnetwork("subnetwork-internal-ipv6",
            name="internal-ipv6-test-subnetwork",
            ip_cidr_range="10.0.0.0/22",
            region="us-west2",
            stack_type="IPV4_IPV6",
            ipv6_access_type="INTERNAL",
            network=custom_test.id)
        ```
        ### Subnetwork Purpose Private Nat

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            name="subnet-purpose-test-network",
            auto_create_subnetworks=False)
        subnetwork_purpose_private_nat = gcp.compute.Subnetwork("subnetwork-purpose-private-nat",
            name="subnet-purpose-test-subnetwork",
            region="us-west2",
            ip_cidr_range="192.168.1.0/24",
            purpose="PRIVATE_NAT",
            network=custom_test.id)
        ```
        ### Subnetwork Cidr Overlap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net_cidr_overlap = gcp.compute.Network("net-cidr-overlap",
            name="net-cidr-overlap",
            auto_create_subnetworks=False)
        subnetwork_cidr_overlap = gcp.compute.Subnetwork("subnetwork-cidr-overlap",
            name="subnet-cidr-overlap",
            region="us-west2",
            ip_cidr_range="192.168.1.0/24",
            allow_subnet_cidr_routes_overlap=True,
            network=net_cidr_overlap.id)
        ```
        ### Subnetwork Reserved Internal Range

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network-reserved-internal-range",
            auto_create_subnetworks=False)
        reserved = gcp.networkconnectivity.InternalRange("reserved",
            name="reserved",
            network=default.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            prefix_length=24,
            target_cidr_ranges=["10.0.0.0/8"])
        subnetwork_reserved_internal_range = gcp.compute.Subnetwork("subnetwork-reserved-internal-range",
            name="subnetwork-reserved-internal-range",
            region="us-central1",
            network=default.id,
            reserved_internal_range=reserved.id.apply(lambda id: f"networkconnectivity.googleapis.com/{id}"))
        ```
        ### Subnetwork Reserved Secondary Range

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network-reserved-secondary-range",
            auto_create_subnetworks=False)
        reserved = gcp.networkconnectivity.InternalRange("reserved",
            name="reserved-primary",
            network=default.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            prefix_length=24,
            target_cidr_ranges=["10.0.0.0/8"])
        reserved_secondary = gcp.networkconnectivity.InternalRange("reserved_secondary",
            name="reserved-secondary",
            network=default.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            prefix_length=16,
            target_cidr_ranges=["10.0.0.0/8"])
        subnetwork_reserved_secondary_range = gcp.compute.Subnetwork("subnetwork-reserved-secondary-range",
            name="subnetwork-reserved-secondary-range",
            region="us-central1",
            network=default.id,
            reserved_internal_range=reserved.id.apply(lambda id: f"networkconnectivity.googleapis.com/{id}"),
            secondary_ip_ranges=[{
                "range_name": "secondary",
                "reserved_internal_range": reserved_secondary.id.apply(lambda id: f"networkconnectivity.googleapis.com/{id}"),
            }])
        ```

        ## Import

        Subnetwork can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/subnetworks/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Subnetwork can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/subnetwork:Subnetwork default projects/{{project}}/regions/{{region}}/subnetworks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/subnetwork:Subnetwork default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/subnetwork:Subnetwork default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/subnetwork:Subnetwork default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SubnetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_subnet_cidr_routes_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_collection: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['SubnetworkLogConfigArgs', 'SubnetworkLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Union['SubnetworkParamsArgs', 'SubnetworkParamsArgsDict']]] = None,
                 private_ip_google_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_internal_range: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubnetworkSecondaryIpRangeArgs', 'SubnetworkSecondaryIpRangeArgsDict']]]]] = None,
                 send_secondary_ip_range_if_empty: Optional[pulumi.Input[_builtins.bool]] = None,
                 stack_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetworkArgs.__new__(SubnetworkArgs)

            __props__.__dict__["allow_subnet_cidr_routes_overlap"] = allow_subnet_cidr_routes_overlap
            __props__.__dict__["description"] = description
            __props__.__dict__["external_ipv6_prefix"] = external_ipv6_prefix
            __props__.__dict__["internal_ipv6_prefix"] = internal_ipv6_prefix
            __props__.__dict__["ip_cidr_range"] = ip_cidr_range
            __props__.__dict__["ip_collection"] = ip_collection
            __props__.__dict__["ipv6_access_type"] = ipv6_access_type
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["params"] = params
            __props__.__dict__["private_ip_google_access"] = private_ip_google_access
            __props__.__dict__["private_ipv6_google_access"] = private_ipv6_google_access
            __props__.__dict__["project"] = project
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_internal_range"] = reserved_internal_range
            __props__.__dict__["role"] = role
            __props__.__dict__["secondary_ip_ranges"] = secondary_ip_ranges
            __props__.__dict__["send_secondary_ip_range_if_empty"] = send_secondary_ip_range_if_empty
            __props__.__dict__["stack_type"] = stack_type
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["gateway_address"] = None
            __props__.__dict__["ipv6_cidr_range"] = None
            __props__.__dict__["ipv6_gce_endpoint"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subnetwork_id"] = None
        super(Subnetwork, __self__).__init__(
            'gcp:compute/subnetwork:Subnetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_subnet_cidr_routes_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            external_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_address: Optional[pulumi.Input[_builtins.str]] = None,
            internal_ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
            ip_collection: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_access_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_gce_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            log_config: Optional[pulumi.Input[Union['SubnetworkLogConfigArgs', 'SubnetworkLogConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            params: Optional[pulumi.Input[Union['SubnetworkParamsArgs', 'SubnetworkParamsArgsDict']]] = None,
            private_ip_google_access: Optional[pulumi.Input[_builtins.bool]] = None,
            private_ipv6_google_access: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            purpose: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_internal_range: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubnetworkSecondaryIpRangeArgs', 'SubnetworkSecondaryIpRangeArgsDict']]]]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            send_secondary_ip_range_if_empty: Optional[pulumi.Input[_builtins.bool]] = None,
            stack_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnetwork_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'Subnetwork':
        """
        Get an existing Subnetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_subnet_cidr_routes_overlap: Typically packets destined to IPs within the subnetwork range that do not match
               existing resources are dropped and prevented from leaving the VPC.
               Setting this field to true will allow these packets to match dynamic routes injected
               via BGP even if their destinations match existing subnet ranges.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource. This field can be set only at resource
               creation time.
        :param pulumi.Input[_builtins.str] external_ipv6_prefix: The range of external IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. This field is used internally during updates of this resource.
        :param pulumi.Input[_builtins.str] gateway_address: The gateway address for default routes to reach destination addresses
               outside this subnetwork.
        :param pulumi.Input[_builtins.str] internal_ipv6_prefix: The internal IPv6 address range that is assigned to this subnetwork.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The range of internal addresses that are owned by this subnetwork.
               Provide this property when you create the subnetwork. For example,
               10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
               non-overlapping within a network. Only IPv4 is supported.
               Field is optional when `reserved_internal_range` is defined, otherwise required.
        :param pulumi.Input[_builtins.str] ip_collection: Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
               in EXTERNAL_IPV6_SUBNETWORK_CREATION or INTERNAL_IPV6_SUBNETWORK_CREATION
               mode. Use one of the following formats to specify a sub-PDP when creating
               a dual stack or IPv6-only subnetwork using BYOIP:
               Full resource URL, as in:
               * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
               Partial URL, as in:
               * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
               * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        :param pulumi.Input[_builtins.str] ipv6_access_type: The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
               or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
               cannot enable direct path.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param pulumi.Input[_builtins.str] ipv6_cidr_range: The range of internal IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[_builtins.str] ipv6_gce_endpoint: Possible endpoints of this subnetwork. It can be one of the following:
               * VM_ONLY: The subnetwork can be used for creating instances and IPv6 addresses with VM endpoint type. Such a subnetwork
               gets external IPv6 ranges from a public delegated prefix and cannot be used to create NetLb.
               * VM_AND_FR: The subnetwork can be used for creating both VM instances and Forwarding Rules. It can also be used to reserve
               IPv6 addresses with both VM and FR endpoint types. Such a subnetwork gets its IPv6 range from Google IP Pool directly.
        :param pulumi.Input[Union['SubnetworkLogConfigArgs', 'SubnetworkLogConfigArgsDict']] log_config: This field denotes the VPC flow logging options for this subnetwork. If
               logging is enabled, logs are exported to Cloud Logging. Flow logging
               isn't supported if the subnet `purpose` field is set to subnetwork is
               `REGIONAL_MANAGED_PROXY` or `GLOBAL_MANAGED_PROXY`.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the resource, provided by the client when initially
               creating the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The network this subnet belongs to.
               Only networks that are in the distributed mode can have subnetworks.
        :param pulumi.Input[Union['SubnetworkParamsArgs', 'SubnetworkParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] private_ip_google_access: When enabled, VMs in this subnetwork without external IP addresses can
               access Google APIs and services by using Private Google Access.
        :param pulumi.Input[_builtins.str] private_ipv6_google_access: The private IPv6 google access type for the VMs in this subnet.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] purpose: The purpose of the resource. This field can be either `PRIVATE`, `REGIONAL_MANAGED_PROXY`, `GLOBAL_MANAGED_PROXY`, `PRIVATE_SERVICE_CONNECT`, `PEER_MIGRATION` or `PRIVATE_NAT`.
               A subnet with purpose set to `REGIONAL_MANAGED_PROXY` is a user-created subnetwork that is reserved for regional Envoy-based load balancers.
               A subnetwork in a given region with purpose set to `GLOBAL_MANAGED_PROXY` is a proxy-only subnet and is shared between all the cross-regional Envoy-based load balancers.
               A subnetwork with purpose set to `PRIVATE_SERVICE_CONNECT` reserves the subnet for hosting a Private Service Connect published service.
               A subnetwork with purpose set to `PEER_MIGRATION` is a user created subnetwork that is reserved for migrating resources from one peered network to another.
               A subnetwork with purpose set to `PRIVATE_NAT` is used as source range for Private NAT gateways.
               Note that `REGIONAL_MANAGED_PROXY` is the preferred setting for all regional Envoy load balancers.
               If unspecified, the purpose defaults to `PRIVATE`.
        :param pulumi.Input[_builtins.str] region: The GCP region for this subnetwork.
        :param pulumi.Input[_builtins.str] reserved_internal_range: The ID of the reserved internal range. Must be prefixed with `networkconnectivity.googleapis.com`
               E.g. `networkconnectivity.googleapis.com/projects/{project}/locations/global/internalRanges/{rangeId}`
        :param pulumi.Input[_builtins.str] role: The role of subnetwork.
               Currently, this field is only used when `purpose` is `REGIONAL_MANAGED_PROXY`.
               The value can be set to `ACTIVE` or `BACKUP`.
               An `ACTIVE` subnetwork is one that is currently being used for Envoy-based load balancers in a region.
               A `BACKUP` subnetwork is one that is ready to be promoted to `ACTIVE` or is currently draining.
               Possible values are: `ACTIVE`, `BACKUP`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubnetworkSecondaryIpRangeArgs', 'SubnetworkSecondaryIpRangeArgsDict']]]] secondary_ip_ranges: An array of configurations for secondary IP ranges for VM instances
               contained in this subnetwork. The primary IP of such VM must belong
               to the primary ipCidrRange of the subnetwork. The alias IPs may belong
               to either primary or secondary ranges.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.bool] send_secondary_ip_range_if_empty: Controls the removal behavior of secondary_ip_range.
               When false, removing secondary_ip_range from config will not produce a diff as
               the provider will default to the API's value.
               When true, the provider will treat removing secondary_ip_range as sending an
               empty list of secondary IP ranges to the API.
               Defaults to false.
        :param pulumi.Input[_builtins.str] stack_type: The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
               If not specified IPV4_ONLY will be used.
               Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] state: 'The state of the subnetwork, which can be one of the following values:
               READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose
               set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained.
               A subnetwork that is draining cannot be used or modified until it reaches a status of READY'
        :param pulumi.Input[_builtins.int] subnetwork_id: The unique identifier number for the resource. This identifier is defined by the server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetworkState.__new__(_SubnetworkState)

        __props__.__dict__["allow_subnet_cidr_routes_overlap"] = allow_subnet_cidr_routes_overlap
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["external_ipv6_prefix"] = external_ipv6_prefix
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["gateway_address"] = gateway_address
        __props__.__dict__["internal_ipv6_prefix"] = internal_ipv6_prefix
        __props__.__dict__["ip_cidr_range"] = ip_cidr_range
        __props__.__dict__["ip_collection"] = ip_collection
        __props__.__dict__["ipv6_access_type"] = ipv6_access_type
        __props__.__dict__["ipv6_cidr_range"] = ipv6_cidr_range
        __props__.__dict__["ipv6_gce_endpoint"] = ipv6_gce_endpoint
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["params"] = params
        __props__.__dict__["private_ip_google_access"] = private_ip_google_access
        __props__.__dict__["private_ipv6_google_access"] = private_ipv6_google_access
        __props__.__dict__["project"] = project
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_internal_range"] = reserved_internal_range
        __props__.__dict__["role"] = role
        __props__.__dict__["secondary_ip_ranges"] = secondary_ip_ranges
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["send_secondary_ip_range_if_empty"] = send_secondary_ip_range_if_empty
        __props__.__dict__["stack_type"] = stack_type
        __props__.__dict__["state"] = state
        __props__.__dict__["subnetwork_id"] = subnetwork_id
        return Subnetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowSubnetCidrRoutesOverlap")
    def allow_subnet_cidr_routes_overlap(self) -> pulumi.Output[_builtins.bool]:
        """
        Typically packets destined to IPs within the subnetwork range that do not match
        existing resources are dropped and prevented from leaving the VPC.
        Setting this field to true will allow these packets to match dynamic routes injected
        via BGP even if their destinations match existing subnet ranges.
        """
        return pulumi.get(self, "allow_subnet_cidr_routes_overlap")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource. This field can be set only at resource
        creation time.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalIpv6Prefix")
    def external_ipv6_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The range of external IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "external_ipv6_prefix")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This field is not useful for users, and has been removed as an output.""")
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint of this resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> pulumi.Output[_builtins.str]:
        """
        The gateway address for default routes to reach destination addresses
        outside this subnetwork.
        """
        return pulumi.get(self, "gateway_address")

    @_builtins.property
    @pulumi.getter(name="internalIpv6Prefix")
    def internal_ipv6_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The internal IPv6 address range that is assigned to this subnetwork.
        """
        return pulumi.get(self, "internal_ipv6_prefix")

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> pulumi.Output[_builtins.str]:
        """
        The range of internal addresses that are owned by this subnetwork.
        Provide this property when you create the subnetwork. For example,
        10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
        non-overlapping within a network. Only IPv4 is supported.
        Field is optional when `reserved_internal_range` is defined, otherwise required.
        """
        return pulumi.get(self, "ip_cidr_range")

    @_builtins.property
    @pulumi.getter(name="ipCollection")
    def ip_collection(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
        in EXTERNAL_IPV6_SUBNETWORK_CREATION or INTERNAL_IPV6_SUBNETWORK_CREATION
        mode. Use one of the following formats to specify a sub-PDP when creating
        a dual stack or IPv6-only subnetwork using BYOIP:
        Full resource URL, as in:
        * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        Partial URL, as in:
        * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
        * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        """
        return pulumi.get(self, "ip_collection")

    @_builtins.property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
        or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
        cannot enable direct path.
        Possible values are: `EXTERNAL`, `INTERNAL`.
        """
        return pulumi.get(self, "ipv6_access_type")

    @_builtins.property
    @pulumi.getter(name="ipv6CidrRange")
    def ipv6_cidr_range(self) -> pulumi.Output[_builtins.str]:
        """
        The range of internal IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "ipv6_cidr_range")

    @_builtins.property
    @pulumi.getter(name="ipv6GceEndpoint")
    def ipv6_gce_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Possible endpoints of this subnetwork. It can be one of the following:
        * VM_ONLY: The subnetwork can be used for creating instances and IPv6 addresses with VM endpoint type. Such a subnetwork
        gets external IPv6 ranges from a public delegated prefix and cannot be used to create NetLb.
        * VM_AND_FR: The subnetwork can be used for creating both VM instances and Forwarding Rules. It can also be used to reserve
        IPv6 addresses with both VM and FR endpoint types. Such a subnetwork gets its IPv6 range from Google IP Pool directly.
        """
        return pulumi.get(self, "ipv6_gce_endpoint")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.SubnetworkLogConfig']]:
        """
        This field denotes the VPC flow logging options for this subnetwork. If
        logging is enabled, logs are exported to Cloud Logging. Flow logging
        isn't supported if the subnet `purpose` field is set to subnetwork is
        `REGIONAL_MANAGED_PROXY` or `GLOBAL_MANAGED_PROXY`.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource, provided by the client when initially
        creating the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network this subnet belongs to.
        Only networks that are in the distributed mode can have subnetworks.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional['outputs.SubnetworkParams']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter(name="privateIpGoogleAccess")
    def private_ip_google_access(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, VMs in this subnetwork without external IP addresses can
        access Google APIs and services by using Private Google Access.
        """
        return pulumi.get(self, "private_ip_google_access")

    @_builtins.property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> pulumi.Output[_builtins.str]:
        """
        The private IPv6 google access type for the VMs in this subnet.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[_builtins.str]:
        """
        The purpose of the resource. This field can be either `PRIVATE`, `REGIONAL_MANAGED_PROXY`, `GLOBAL_MANAGED_PROXY`, `PRIVATE_SERVICE_CONNECT`, `PEER_MIGRATION` or `PRIVATE_NAT`.
        A subnet with purpose set to `REGIONAL_MANAGED_PROXY` is a user-created subnetwork that is reserved for regional Envoy-based load balancers.
        A subnetwork in a given region with purpose set to `GLOBAL_MANAGED_PROXY` is a proxy-only subnet and is shared between all the cross-regional Envoy-based load balancers.
        A subnetwork with purpose set to `PRIVATE_SERVICE_CONNECT` reserves the subnet for hosting a Private Service Connect published service.
        A subnetwork with purpose set to `PEER_MIGRATION` is a user created subnetwork that is reserved for migrating resources from one peered network to another.
        A subnetwork with purpose set to `PRIVATE_NAT` is used as source range for Private NAT gateways.
        Note that `REGIONAL_MANAGED_PROXY` is the preferred setting for all regional Envoy load balancers.
        If unspecified, the purpose defaults to `PRIVATE`.
        """
        return pulumi.get(self, "purpose")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The GCP region for this subnetwork.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reservedInternalRange")
    def reserved_internal_range(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the reserved internal range. Must be prefixed with `networkconnectivity.googleapis.com`
        E.g. `networkconnectivity.googleapis.com/projects/{project}/locations/global/internalRanges/{rangeId}`
        """
        return pulumi.get(self, "reserved_internal_range")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role of subnetwork.
        Currently, this field is only used when `purpose` is `REGIONAL_MANAGED_PROXY`.
        The value can be set to `ACTIVE` or `BACKUP`.
        An `ACTIVE` subnetwork is one that is currently being used for Envoy-based load balancers in a region.
        A `BACKUP` subnetwork is one that is ready to be promoted to `ACTIVE` or is currently draining.
        Possible values are: `ACTIVE`, `BACKUP`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="secondaryIpRanges")
    def secondary_ip_ranges(self) -> pulumi.Output[Sequence['outputs.SubnetworkSecondaryIpRange']]:
        """
        An array of configurations for secondary IP ranges for VM instances
        contained in this subnetwork. The primary IP of such VM must belong
        to the primary ipCidrRange of the subnetwork. The alias IPs may belong
        to either primary or secondary ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="sendSecondaryIpRangeIfEmpty")
    def send_secondary_ip_range_if_empty(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Controls the removal behavior of secondary_ip_range.
        When false, removing secondary_ip_range from config will not produce a diff as
        the provider will default to the API's value.
        When true, the provider will treat removing secondary_ip_range as sending an
        empty list of secondary IP ranges to the API.
        Defaults to false.
        """
        return pulumi.get(self, "send_secondary_ip_range_if_empty")

    @_builtins.property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> pulumi.Output[_builtins.str]:
        """
        The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
        If not specified IPV4_ONLY will be used.
        Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        'The state of the subnetwork, which can be one of the following values:
        READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose
        set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained.
        A subnetwork that is draining cannot be used or modified until it reaches a status of READY'
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetworkId")
    def subnetwork_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "subnetwork_id")

