# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EntryLinkArgs', 'EntryLink']

@pulumi.input_type
class EntryLinkArgs:
    def __init__(__self__, *,
                 entry_group_id: pulumi.Input[_builtins.str],
                 entry_link_id: pulumi.Input[_builtins.str],
                 entry_link_type: pulumi.Input[_builtins.str],
                 entry_references: pulumi.Input[Sequence[pulumi.Input['EntryLinkEntryReferenceArgs']]],
                 location: pulumi.Input[_builtins.str],
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EntryLink resource.
        :param pulumi.Input[_builtins.str] entry_group_id: The id of the entry group this entry link is in.
        :param pulumi.Input[_builtins.str] entry_link_id: The id of the entry link to create.
        :param pulumi.Input[_builtins.str] entry_link_type: Relative resource name of the Entry Link Type used to create this Entry Link. For example:
               projects/dataplex-types/locations/global/entryLinkTypes/definition
        :param pulumi.Input[Sequence[pulumi.Input['EntryLinkEntryReferenceArgs']]] entry_references: Specifies the Entries referenced in the Entry Link. There should be exactly two entry references.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location for the entry.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "entry_group_id", entry_group_id)
        pulumi.set(__self__, "entry_link_id", entry_link_id)
        pulumi.set(__self__, "entry_link_type", entry_link_type)
        pulumi.set(__self__, "entry_references", entry_references)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="entryGroupId")
    def entry_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the entry group this entry link is in.
        """
        return pulumi.get(self, "entry_group_id")

    @entry_group_id.setter
    def entry_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entry_group_id", value)

    @_builtins.property
    @pulumi.getter(name="entryLinkId")
    def entry_link_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the entry link to create.
        """
        return pulumi.get(self, "entry_link_id")

    @entry_link_id.setter
    def entry_link_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entry_link_id", value)

    @_builtins.property
    @pulumi.getter(name="entryLinkType")
    def entry_link_type(self) -> pulumi.Input[_builtins.str]:
        """
        Relative resource name of the Entry Link Type used to create this Entry Link. For example:
        projects/dataplex-types/locations/global/entryLinkTypes/definition
        """
        return pulumi.get(self, "entry_link_type")

    @entry_link_type.setter
    def entry_link_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entry_link_type", value)

    @_builtins.property
    @pulumi.getter(name="entryReferences")
    def entry_references(self) -> pulumi.Input[Sequence[pulumi.Input['EntryLinkEntryReferenceArgs']]]:
        """
        Specifies the Entries referenced in the Entry Link. There should be exactly two entry references.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_references")

    @entry_references.setter
    def entry_references(self, value: pulumi.Input[Sequence[pulumi.Input['EntryLinkEntryReferenceArgs']]]):
        pulumi.set(self, "entry_references", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the entry.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _EntryLinkState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_references: Optional[pulumi.Input[Sequence[pulumi.Input['EntryLinkEntryReferenceArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EntryLink resources.
        :param pulumi.Input[_builtins.str] create_time: The time when the Entry Link was created.
        :param pulumi.Input[_builtins.str] entry_group_id: The id of the entry group this entry link is in.
        :param pulumi.Input[_builtins.str] entry_link_id: The id of the entry link to create.
        :param pulumi.Input[_builtins.str] entry_link_type: Relative resource name of the Entry Link Type used to create this Entry Link. For example:
               projects/dataplex-types/locations/global/entryLinkTypes/definition
        :param pulumi.Input[Sequence[pulumi.Input['EntryLinkEntryReferenceArgs']]] entry_references: Specifies the Entries referenced in the Entry Link. There should be exactly two entry references.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location for the entry.
        :param pulumi.Input[_builtins.str] name: The relative resource name of the Entry Link, of the form:
               projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: The time when the Entry Link was last updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if entry_group_id is not None:
            pulumi.set(__self__, "entry_group_id", entry_group_id)
        if entry_link_id is not None:
            pulumi.set(__self__, "entry_link_id", entry_link_id)
        if entry_link_type is not None:
            pulumi.set(__self__, "entry_link_type", entry_link_type)
        if entry_references is not None:
            pulumi.set(__self__, "entry_references", entry_references)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the Entry Link was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="entryGroupId")
    def entry_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the entry group this entry link is in.
        """
        return pulumi.get(self, "entry_group_id")

    @entry_group_id.setter
    def entry_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_group_id", value)

    @_builtins.property
    @pulumi.getter(name="entryLinkId")
    def entry_link_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the entry link to create.
        """
        return pulumi.get(self, "entry_link_id")

    @entry_link_id.setter
    def entry_link_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_link_id", value)

    @_builtins.property
    @pulumi.getter(name="entryLinkType")
    def entry_link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative resource name of the Entry Link Type used to create this Entry Link. For example:
        projects/dataplex-types/locations/global/entryLinkTypes/definition
        """
        return pulumi.get(self, "entry_link_type")

    @entry_link_type.setter
    def entry_link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_link_type", value)

    @_builtins.property
    @pulumi.getter(name="entryReferences")
    def entry_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntryLinkEntryReferenceArgs']]]]:
        """
        Specifies the Entries referenced in the Entry Link. There should be exactly two entry references.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_references")

    @entry_references.setter
    def entry_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntryLinkEntryReferenceArgs']]]]):
        pulumi.set(self, "entry_references", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the entry.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative resource name of the Entry Link, of the form:
        projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the Entry Link was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataplex/entryLink:EntryLink")
class EntryLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entry_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryLinkEntryReferenceArgs', 'EntryLinkEntryReferenceArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        EntryLink represents a link between two Entries.

        To get more information about EntryLink, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest/v1/projects.locations.entryGroups.entryLinks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataplex/docs)

        ## Example Usage

        ### Dataplex Entry Link Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group_basic = gcp.dataplex.EntryGroup("entry-group-basic",
            location="us-central1",
            entry_group_id="tf-test-entry-group_74000",
            project="1111111111111")
        entry_type_basic = gcp.dataplex.EntryType("entry-type-basic",
            entry_type_id="tf-test-entry-type_88722",
            location="us-central1",
            project="1111111111111")
        source = gcp.dataplex.Entry("source",
            location="us-central1",
            entry_group_id=entry_group_basic.entry_group_id,
            entry_id="tf-test-source-entry_75125",
            entry_type=entry_type_basic.name,
            project="1111111111111")
        target = gcp.dataplex.Entry("target",
            location="us-central1",
            entry_group_id=entry_group_basic.entry_group_id,
            entry_id="tf-test-target-entry_39249",
            entry_type=entry_type_basic.name,
            project="1111111111111")
        basic_entry_link = gcp.dataplex.EntryLink("basic_entry_link",
            project="1111111111111",
            location="us-central1",
            entry_group_id=entry_group_basic.entry_group_id,
            entry_link_id="tf-test-entry-link_74391",
            entry_link_type="projects/655216118709/locations/global/entryLinkTypes/related",
            entry_references=[
                {
                    "name": source.name,
                },
                {
                    "name": target.name,
                },
            ])
        ```
        ### Dataplex Entry Link Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group_full = gcp.dataplex.EntryGroup("entry-group-full",
            location="us-central1",
            entry_group_id="tf-test-entry-group_16511",
            project="1111111111111")
        entry_type_full = gcp.dataplex.EntryType("entry-type-full",
            entry_type_id="tf-test-entry-type_9106",
            location="us-central1",
            project="1111111111111")
        source = gcp.dataplex.Entry("source",
            location="us-central1",
            entry_group_id=entry_group_full.entry_group_id,
            entry_id="tf-test-source-entry_8493",
            entry_type=entry_type_full.name,
            project="1111111111111")
        term_test_id_full = gcp.dataplex.Glossary("term_test_id_full",
            glossary_id="tf-test-glossary_27169",
            location="us-central1")
        term_test_id_full_glossary_term = gcp.dataplex.GlossaryTerm("term_test_id_full",
            parent=pulumi.Output.all(
                project=term_test_id_full.project,
                glossary_id=term_test_id_full.glossary_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/us-central1/glossaries/{resolved_outputs['glossary_id']}")
        ,
            glossary_id=term_test_id_full.glossary_id,
            location="us-central1",
            term_id="tf-test-term-full_75223",
            labels={
                "tag": "test-tf",
            },
            display_name="terraform term",
            description="term created by Terraform")
        full_entry_link = gcp.dataplex.EntryLink("full_entry_link",
            project="1111111111111",
            location="us-central1",
            entry_group_id=entry_group_full.entry_group_id,
            entry_link_id="tf-test-entry-link_41819",
            entry_link_type="projects/655216118709/locations/global/entryLinkTypes/definition",
            entry_references=[
                {
                    "name": source.name,
                    "type": "SOURCE",
                    "path": "",
                },
                {
                    "name": pulumi.Output.all(
                        entry-group-fullProject=entry_group_full.project,
                        entry-group-fullProject1=entry_group_full.project,
                        glossary_id=term_test_id_full.glossary_id,
                        term_id=term_test_id_full_glossary_term.term_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['entry-group-fullProject']}/locations/us-central1/entryGroups/@dataplex/entries/projects/{resolved_outputs['entry-group-fullProject1']}/locations/us-central1/glossaries/{resolved_outputs['glossary_id']}/terms/{resolved_outputs['term_id']}")
        ,
                    "type": "TARGET",
                },
            ])
        ```

        ## Import

        EntryLink can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/entryGroups/{{entry_group_id}}/entryLinks/{{entry_link_id}}`

        * `{{project}}/{{location}}/{{entry_group_id}}/{{entry_link_id}}`

        * `{{location}}/{{entry_group_id}}/{{entry_link_id}}`

        When using the `pulumi import` command, EntryLink can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/entryLink:EntryLink default projects/{{project}}/locations/{{location}}/entryGroups/{{entry_group_id}}/entryLinks/{{entry_link_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entryLink:EntryLink default {{project}}/{{location}}/{{entry_group_id}}/{{entry_link_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entryLink:EntryLink default {{location}}/{{entry_group_id}}/{{entry_link_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entry_group_id: The id of the entry group this entry link is in.
        :param pulumi.Input[_builtins.str] entry_link_id: The id of the entry link to create.
        :param pulumi.Input[_builtins.str] entry_link_type: Relative resource name of the Entry Link Type used to create this Entry Link. For example:
               projects/dataplex-types/locations/global/entryLinkTypes/definition
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntryLinkEntryReferenceArgs', 'EntryLinkEntryReferenceArgsDict']]]] entry_references: Specifies the Entries referenced in the Entry Link. There should be exactly two entry references.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location for the entry.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntryLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        EntryLink represents a link between two Entries.

        To get more information about EntryLink, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest/v1/projects.locations.entryGroups.entryLinks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataplex/docs)

        ## Example Usage

        ### Dataplex Entry Link Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group_basic = gcp.dataplex.EntryGroup("entry-group-basic",
            location="us-central1",
            entry_group_id="tf-test-entry-group_74000",
            project="1111111111111")
        entry_type_basic = gcp.dataplex.EntryType("entry-type-basic",
            entry_type_id="tf-test-entry-type_88722",
            location="us-central1",
            project="1111111111111")
        source = gcp.dataplex.Entry("source",
            location="us-central1",
            entry_group_id=entry_group_basic.entry_group_id,
            entry_id="tf-test-source-entry_75125",
            entry_type=entry_type_basic.name,
            project="1111111111111")
        target = gcp.dataplex.Entry("target",
            location="us-central1",
            entry_group_id=entry_group_basic.entry_group_id,
            entry_id="tf-test-target-entry_39249",
            entry_type=entry_type_basic.name,
            project="1111111111111")
        basic_entry_link = gcp.dataplex.EntryLink("basic_entry_link",
            project="1111111111111",
            location="us-central1",
            entry_group_id=entry_group_basic.entry_group_id,
            entry_link_id="tf-test-entry-link_74391",
            entry_link_type="projects/655216118709/locations/global/entryLinkTypes/related",
            entry_references=[
                {
                    "name": source.name,
                },
                {
                    "name": target.name,
                },
            ])
        ```
        ### Dataplex Entry Link Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group_full = gcp.dataplex.EntryGroup("entry-group-full",
            location="us-central1",
            entry_group_id="tf-test-entry-group_16511",
            project="1111111111111")
        entry_type_full = gcp.dataplex.EntryType("entry-type-full",
            entry_type_id="tf-test-entry-type_9106",
            location="us-central1",
            project="1111111111111")
        source = gcp.dataplex.Entry("source",
            location="us-central1",
            entry_group_id=entry_group_full.entry_group_id,
            entry_id="tf-test-source-entry_8493",
            entry_type=entry_type_full.name,
            project="1111111111111")
        term_test_id_full = gcp.dataplex.Glossary("term_test_id_full",
            glossary_id="tf-test-glossary_27169",
            location="us-central1")
        term_test_id_full_glossary_term = gcp.dataplex.GlossaryTerm("term_test_id_full",
            parent=pulumi.Output.all(
                project=term_test_id_full.project,
                glossary_id=term_test_id_full.glossary_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/us-central1/glossaries/{resolved_outputs['glossary_id']}")
        ,
            glossary_id=term_test_id_full.glossary_id,
            location="us-central1",
            term_id="tf-test-term-full_75223",
            labels={
                "tag": "test-tf",
            },
            display_name="terraform term",
            description="term created by Terraform")
        full_entry_link = gcp.dataplex.EntryLink("full_entry_link",
            project="1111111111111",
            location="us-central1",
            entry_group_id=entry_group_full.entry_group_id,
            entry_link_id="tf-test-entry-link_41819",
            entry_link_type="projects/655216118709/locations/global/entryLinkTypes/definition",
            entry_references=[
                {
                    "name": source.name,
                    "type": "SOURCE",
                    "path": "",
                },
                {
                    "name": pulumi.Output.all(
                        entry-group-fullProject=entry_group_full.project,
                        entry-group-fullProject1=entry_group_full.project,
                        glossary_id=term_test_id_full.glossary_id,
                        term_id=term_test_id_full_glossary_term.term_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['entry-group-fullProject']}/locations/us-central1/entryGroups/@dataplex/entries/projects/{resolved_outputs['entry-group-fullProject1']}/locations/us-central1/glossaries/{resolved_outputs['glossary_id']}/terms/{resolved_outputs['term_id']}")
        ,
                    "type": "TARGET",
                },
            ])
        ```

        ## Import

        EntryLink can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/entryGroups/{{entry_group_id}}/entryLinks/{{entry_link_id}}`

        * `{{project}}/{{location}}/{{entry_group_id}}/{{entry_link_id}}`

        * `{{location}}/{{entry_group_id}}/{{entry_link_id}}`

        When using the `pulumi import` command, EntryLink can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/entryLink:EntryLink default projects/{{project}}/locations/{{location}}/entryGroups/{{entry_group_id}}/entryLinks/{{entry_link_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entryLink:EntryLink default {{project}}/{{location}}/{{entry_group_id}}/{{entry_link_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entryLink:EntryLink default {{location}}/{{entry_group_id}}/{{entry_link_id}}
        ```

        :param str resource_name: The name of the resource.
        :param EntryLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntryLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entry_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryLinkEntryReferenceArgs', 'EntryLinkEntryReferenceArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntryLinkArgs.__new__(EntryLinkArgs)

            if entry_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'entry_group_id'")
            __props__.__dict__["entry_group_id"] = entry_group_id
            if entry_link_id is None and not opts.urn:
                raise TypeError("Missing required property 'entry_link_id'")
            __props__.__dict__["entry_link_id"] = entry_link_id
            if entry_link_type is None and not opts.urn:
                raise TypeError("Missing required property 'entry_link_type'")
            __props__.__dict__["entry_link_type"] = entry_link_type
            if entry_references is None and not opts.urn:
                raise TypeError("Missing required property 'entry_references'")
            __props__.__dict__["entry_references"] = entry_references
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(EntryLink, __self__).__init__(
            'gcp:dataplex/entryLink:EntryLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            entry_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            entry_link_id: Optional[pulumi.Input[_builtins.str]] = None,
            entry_link_type: Optional[pulumi.Input[_builtins.str]] = None,
            entry_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryLinkEntryReferenceArgs', 'EntryLinkEntryReferenceArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'EntryLink':
        """
        Get an existing EntryLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the Entry Link was created.
        :param pulumi.Input[_builtins.str] entry_group_id: The id of the entry group this entry link is in.
        :param pulumi.Input[_builtins.str] entry_link_id: The id of the entry link to create.
        :param pulumi.Input[_builtins.str] entry_link_type: Relative resource name of the Entry Link Type used to create this Entry Link. For example:
               projects/dataplex-types/locations/global/entryLinkTypes/definition
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntryLinkEntryReferenceArgs', 'EntryLinkEntryReferenceArgsDict']]]] entry_references: Specifies the Entries referenced in the Entry Link. There should be exactly two entry references.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location for the entry.
        :param pulumi.Input[_builtins.str] name: The relative resource name of the Entry Link, of the form:
               projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: The time when the Entry Link was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntryLinkState.__new__(_EntryLinkState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["entry_group_id"] = entry_group_id
        __props__.__dict__["entry_link_id"] = entry_link_id
        __props__.__dict__["entry_link_type"] = entry_link_type
        __props__.__dict__["entry_references"] = entry_references
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return EntryLink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the Entry Link was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="entryGroupId")
    def entry_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the entry group this entry link is in.
        """
        return pulumi.get(self, "entry_group_id")

    @_builtins.property
    @pulumi.getter(name="entryLinkId")
    def entry_link_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the entry link to create.
        """
        return pulumi.get(self, "entry_link_id")

    @_builtins.property
    @pulumi.getter(name="entryLinkType")
    def entry_link_type(self) -> pulumi.Output[_builtins.str]:
        """
        Relative resource name of the Entry Link Type used to create this Entry Link. For example:
        projects/dataplex-types/locations/global/entryLinkTypes/definition
        """
        return pulumi.get(self, "entry_link_type")

    @_builtins.property
    @pulumi.getter(name="entryReferences")
    def entry_references(self) -> pulumi.Output[Sequence['outputs.EntryLinkEntryReference']]:
        """
        Specifies the Entries referenced in the Entry Link. There should be exactly two entry references.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_references")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the entry.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The relative resource name of the Entry Link, of the form:
        projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the Entry Link was last updated.
        """
        return pulumi.get(self, "update_time")

