# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionProfileArgs', 'ConnectionProfile']

@pulumi.input_type
class ConnectionProfileArgs:
    def __init__(__self__, *,
                 connection_profile_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 bigquery_profile: Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']] = None,
                 create_without_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_ssh_connectivity: Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']] = None,
                 gcs_profile: Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mongodb_profile: Optional[pulumi.Input['ConnectionProfileMongodbProfileArgs']] = None,
                 mysql_profile: Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']] = None,
                 oracle_profile: Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']] = None,
                 postgresql_profile: Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']] = None,
                 private_connectivity: Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 salesforce_profile: Optional[pulumi.Input['ConnectionProfileSalesforceProfileArgs']] = None,
                 sql_server_profile: Optional[pulumi.Input['ConnectionProfileSqlServerProfileArgs']] = None):
        """
        The set of arguments for constructing a ConnectionProfile resource.
        :param pulumi.Input[_builtins.str] connection_profile_id: The connection profile identifier.
        :param pulumi.Input[_builtins.str] display_name: Display name.
        :param pulumi.Input[_builtins.str] location: The name of the location this connection profile is located in.
        :param pulumi.Input['ConnectionProfileBigqueryProfileArgs'] bigquery_profile: BigQuery warehouse profile.
        :param pulumi.Input[_builtins.bool] create_without_validation: Create the connection profile without validating it.
        :param pulumi.Input['ConnectionProfileForwardSshConnectivityArgs'] forward_ssh_connectivity: Forward SSH tunnel connectivity.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileGcsProfileArgs'] gcs_profile: Cloud Storage bucket profile.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['ConnectionProfileMongodbProfileArgs'] mongodb_profile: Configuration for connecting to a MongoDB database.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileMysqlProfileArgs'] mysql_profile: MySQL database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileOracleProfileArgs'] oracle_profile: Oracle database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePostgresqlProfileArgs'] postgresql_profile: PostgreSQL database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePrivateConnectivityArgs'] private_connectivity: Private connectivity.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ConnectionProfileSalesforceProfileArgs'] salesforce_profile: Salesforce profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileSqlServerProfileArgs'] sql_server_profile: SQL Server database profile.
               Structure is documented below.
        """
        pulumi.set(__self__, "connection_profile_id", connection_profile_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if bigquery_profile is not None:
            pulumi.set(__self__, "bigquery_profile", bigquery_profile)
        if create_without_validation is not None:
            pulumi.set(__self__, "create_without_validation", create_without_validation)
        if forward_ssh_connectivity is not None:
            pulumi.set(__self__, "forward_ssh_connectivity", forward_ssh_connectivity)
        if gcs_profile is not None:
            pulumi.set(__self__, "gcs_profile", gcs_profile)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mongodb_profile is not None:
            pulumi.set(__self__, "mongodb_profile", mongodb_profile)
        if mysql_profile is not None:
            pulumi.set(__self__, "mysql_profile", mysql_profile)
        if oracle_profile is not None:
            pulumi.set(__self__, "oracle_profile", oracle_profile)
        if postgresql_profile is not None:
            pulumi.set(__self__, "postgresql_profile", postgresql_profile)
        if private_connectivity is not None:
            pulumi.set(__self__, "private_connectivity", private_connectivity)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if salesforce_profile is not None:
            pulumi.set(__self__, "salesforce_profile", salesforce_profile)
        if sql_server_profile is not None:
            pulumi.set(__self__, "sql_server_profile", sql_server_profile)

    @_builtins.property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        The connection profile identifier.
        """
        return pulumi.get(self, "connection_profile_id")

    @connection_profile_id.setter
    def connection_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the location this connection profile is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="bigqueryProfile")
    def bigquery_profile(self) -> Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']]:
        """
        BigQuery warehouse profile.
        """
        return pulumi.get(self, "bigquery_profile")

    @bigquery_profile.setter
    def bigquery_profile(self, value: Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']]):
        pulumi.set(self, "bigquery_profile", value)

    @_builtins.property
    @pulumi.getter(name="createWithoutValidation")
    def create_without_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Create the connection profile without validating it.
        """
        return pulumi.get(self, "create_without_validation")

    @create_without_validation.setter
    def create_without_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_without_validation", value)

    @_builtins.property
    @pulumi.getter(name="forwardSshConnectivity")
    def forward_ssh_connectivity(self) -> Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']]:
        """
        Forward SSH tunnel connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_ssh_connectivity")

    @forward_ssh_connectivity.setter
    def forward_ssh_connectivity(self, value: Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']]):
        pulumi.set(self, "forward_ssh_connectivity", value)

    @_builtins.property
    @pulumi.getter(name="gcsProfile")
    def gcs_profile(self) -> Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']]:
        """
        Cloud Storage bucket profile.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_profile")

    @gcs_profile.setter
    def gcs_profile(self, value: Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']]):
        pulumi.set(self, "gcs_profile", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="mongodbProfile")
    def mongodb_profile(self) -> Optional[pulumi.Input['ConnectionProfileMongodbProfileArgs']]:
        """
        Configuration for connecting to a MongoDB database.
        Structure is documented below.
        """
        return pulumi.get(self, "mongodb_profile")

    @mongodb_profile.setter
    def mongodb_profile(self, value: Optional[pulumi.Input['ConnectionProfileMongodbProfileArgs']]):
        pulumi.set(self, "mongodb_profile", value)

    @_builtins.property
    @pulumi.getter(name="mysqlProfile")
    def mysql_profile(self) -> Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']]:
        """
        MySQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_profile")

    @mysql_profile.setter
    def mysql_profile(self, value: Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']]):
        pulumi.set(self, "mysql_profile", value)

    @_builtins.property
    @pulumi.getter(name="oracleProfile")
    def oracle_profile(self) -> Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']]:
        """
        Oracle database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_profile")

    @oracle_profile.setter
    def oracle_profile(self, value: Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']]):
        pulumi.set(self, "oracle_profile", value)

    @_builtins.property
    @pulumi.getter(name="postgresqlProfile")
    def postgresql_profile(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']]:
        """
        PostgreSQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_profile")

    @postgresql_profile.setter
    def postgresql_profile(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']]):
        pulumi.set(self, "postgresql_profile", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectivity")
    def private_connectivity(self) -> Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']]:
        """
        Private connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "private_connectivity")

    @private_connectivity.setter
    def private_connectivity(self, value: Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']]):
        pulumi.set(self, "private_connectivity", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="salesforceProfile")
    def salesforce_profile(self) -> Optional[pulumi.Input['ConnectionProfileSalesforceProfileArgs']]:
        """
        Salesforce profile.
        Structure is documented below.
        """
        return pulumi.get(self, "salesforce_profile")

    @salesforce_profile.setter
    def salesforce_profile(self, value: Optional[pulumi.Input['ConnectionProfileSalesforceProfileArgs']]):
        pulumi.set(self, "salesforce_profile", value)

    @_builtins.property
    @pulumi.getter(name="sqlServerProfile")
    def sql_server_profile(self) -> Optional[pulumi.Input['ConnectionProfileSqlServerProfileArgs']]:
        """
        SQL Server database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "sql_server_profile")

    @sql_server_profile.setter
    def sql_server_profile(self, value: Optional[pulumi.Input['ConnectionProfileSqlServerProfileArgs']]):
        pulumi.set(self, "sql_server_profile", value)


@pulumi.input_type
class _ConnectionProfileState:
    def __init__(__self__, *,
                 bigquery_profile: Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']] = None,
                 connection_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_without_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 forward_ssh_connectivity: Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']] = None,
                 gcs_profile: Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodb_profile: Optional[pulumi.Input['ConnectionProfileMongodbProfileArgs']] = None,
                 mysql_profile: Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_profile: Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']] = None,
                 postgresql_profile: Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']] = None,
                 private_connectivity: Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 salesforce_profile: Optional[pulumi.Input['ConnectionProfileSalesforceProfileArgs']] = None,
                 sql_server_profile: Optional[pulumi.Input['ConnectionProfileSqlServerProfileArgs']] = None):
        """
        Input properties used for looking up and filtering ConnectionProfile resources.
        :param pulumi.Input['ConnectionProfileBigqueryProfileArgs'] bigquery_profile: BigQuery warehouse profile.
        :param pulumi.Input[_builtins.str] connection_profile_id: The connection profile identifier.
        :param pulumi.Input[_builtins.bool] create_without_validation: Create the connection profile without validating it.
        :param pulumi.Input[_builtins.str] display_name: Display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['ConnectionProfileForwardSshConnectivityArgs'] forward_ssh_connectivity: Forward SSH tunnel connectivity.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileGcsProfileArgs'] gcs_profile: Cloud Storage bucket profile.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The name of the location this connection profile is located in.
        :param pulumi.Input['ConnectionProfileMongodbProfileArgs'] mongodb_profile: Configuration for connecting to a MongoDB database.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileMysqlProfileArgs'] mysql_profile: MySQL database profile.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The resource's name.
        :param pulumi.Input['ConnectionProfileOracleProfileArgs'] oracle_profile: Oracle database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePostgresqlProfileArgs'] postgresql_profile: PostgreSQL database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePrivateConnectivityArgs'] private_connectivity: Private connectivity.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['ConnectionProfileSalesforceProfileArgs'] salesforce_profile: Salesforce profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileSqlServerProfileArgs'] sql_server_profile: SQL Server database profile.
               Structure is documented below.
        """
        if bigquery_profile is not None:
            pulumi.set(__self__, "bigquery_profile", bigquery_profile)
        if connection_profile_id is not None:
            pulumi.set(__self__, "connection_profile_id", connection_profile_id)
        if create_without_validation is not None:
            pulumi.set(__self__, "create_without_validation", create_without_validation)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if forward_ssh_connectivity is not None:
            pulumi.set(__self__, "forward_ssh_connectivity", forward_ssh_connectivity)
        if gcs_profile is not None:
            pulumi.set(__self__, "gcs_profile", gcs_profile)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mongodb_profile is not None:
            pulumi.set(__self__, "mongodb_profile", mongodb_profile)
        if mysql_profile is not None:
            pulumi.set(__self__, "mysql_profile", mysql_profile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oracle_profile is not None:
            pulumi.set(__self__, "oracle_profile", oracle_profile)
        if postgresql_profile is not None:
            pulumi.set(__self__, "postgresql_profile", postgresql_profile)
        if private_connectivity is not None:
            pulumi.set(__self__, "private_connectivity", private_connectivity)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if salesforce_profile is not None:
            pulumi.set(__self__, "salesforce_profile", salesforce_profile)
        if sql_server_profile is not None:
            pulumi.set(__self__, "sql_server_profile", sql_server_profile)

    @_builtins.property
    @pulumi.getter(name="bigqueryProfile")
    def bigquery_profile(self) -> Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']]:
        """
        BigQuery warehouse profile.
        """
        return pulumi.get(self, "bigquery_profile")

    @bigquery_profile.setter
    def bigquery_profile(self, value: Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']]):
        pulumi.set(self, "bigquery_profile", value)

    @_builtins.property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection profile identifier.
        """
        return pulumi.get(self, "connection_profile_id")

    @connection_profile_id.setter
    def connection_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="createWithoutValidation")
    def create_without_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Create the connection profile without validating it.
        """
        return pulumi.get(self, "create_without_validation")

    @create_without_validation.setter
    def create_without_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_without_validation", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="forwardSshConnectivity")
    def forward_ssh_connectivity(self) -> Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']]:
        """
        Forward SSH tunnel connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_ssh_connectivity")

    @forward_ssh_connectivity.setter
    def forward_ssh_connectivity(self, value: Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']]):
        pulumi.set(self, "forward_ssh_connectivity", value)

    @_builtins.property
    @pulumi.getter(name="gcsProfile")
    def gcs_profile(self) -> Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']]:
        """
        Cloud Storage bucket profile.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_profile")

    @gcs_profile.setter
    def gcs_profile(self, value: Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']]):
        pulumi.set(self, "gcs_profile", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the location this connection profile is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mongodbProfile")
    def mongodb_profile(self) -> Optional[pulumi.Input['ConnectionProfileMongodbProfileArgs']]:
        """
        Configuration for connecting to a MongoDB database.
        Structure is documented below.
        """
        return pulumi.get(self, "mongodb_profile")

    @mongodb_profile.setter
    def mongodb_profile(self, value: Optional[pulumi.Input['ConnectionProfileMongodbProfileArgs']]):
        pulumi.set(self, "mongodb_profile", value)

    @_builtins.property
    @pulumi.getter(name="mysqlProfile")
    def mysql_profile(self) -> Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']]:
        """
        MySQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_profile")

    @mysql_profile.setter
    def mysql_profile(self, value: Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']]):
        pulumi.set(self, "mysql_profile", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oracleProfile")
    def oracle_profile(self) -> Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']]:
        """
        Oracle database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_profile")

    @oracle_profile.setter
    def oracle_profile(self, value: Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']]):
        pulumi.set(self, "oracle_profile", value)

    @_builtins.property
    @pulumi.getter(name="postgresqlProfile")
    def postgresql_profile(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']]:
        """
        PostgreSQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_profile")

    @postgresql_profile.setter
    def postgresql_profile(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']]):
        pulumi.set(self, "postgresql_profile", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectivity")
    def private_connectivity(self) -> Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']]:
        """
        Private connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "private_connectivity")

    @private_connectivity.setter
    def private_connectivity(self, value: Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']]):
        pulumi.set(self, "private_connectivity", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="salesforceProfile")
    def salesforce_profile(self) -> Optional[pulumi.Input['ConnectionProfileSalesforceProfileArgs']]:
        """
        Salesforce profile.
        Structure is documented below.
        """
        return pulumi.get(self, "salesforce_profile")

    @salesforce_profile.setter
    def salesforce_profile(self, value: Optional[pulumi.Input['ConnectionProfileSalesforceProfileArgs']]):
        pulumi.set(self, "salesforce_profile", value)

    @_builtins.property
    @pulumi.getter(name="sqlServerProfile")
    def sql_server_profile(self) -> Optional[pulumi.Input['ConnectionProfileSqlServerProfileArgs']]:
        """
        SQL Server database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "sql_server_profile")

    @sql_server_profile.setter
    def sql_server_profile(self, value: Optional[pulumi.Input['ConnectionProfileSqlServerProfileArgs']]):
        pulumi.set(self, "sql_server_profile", value)


@pulumi.type_token("gcp:datastream/connectionProfile:ConnectionProfile")
class ConnectionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_profile: Optional[pulumi.Input[Union['ConnectionProfileBigqueryProfileArgs', 'ConnectionProfileBigqueryProfileArgsDict']]] = None,
                 connection_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_without_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_ssh_connectivity: Optional[pulumi.Input[Union['ConnectionProfileForwardSshConnectivityArgs', 'ConnectionProfileForwardSshConnectivityArgsDict']]] = None,
                 gcs_profile: Optional[pulumi.Input[Union['ConnectionProfileGcsProfileArgs', 'ConnectionProfileGcsProfileArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodb_profile: Optional[pulumi.Input[Union['ConnectionProfileMongodbProfileArgs', 'ConnectionProfileMongodbProfileArgsDict']]] = None,
                 mysql_profile: Optional[pulumi.Input[Union['ConnectionProfileMysqlProfileArgs', 'ConnectionProfileMysqlProfileArgsDict']]] = None,
                 oracle_profile: Optional[pulumi.Input[Union['ConnectionProfileOracleProfileArgs', 'ConnectionProfileOracleProfileArgsDict']]] = None,
                 postgresql_profile: Optional[pulumi.Input[Union['ConnectionProfilePostgresqlProfileArgs', 'ConnectionProfilePostgresqlProfileArgsDict']]] = None,
                 private_connectivity: Optional[pulumi.Input[Union['ConnectionProfilePrivateConnectivityArgs', 'ConnectionProfilePrivateConnectivityArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 salesforce_profile: Optional[pulumi.Input[Union['ConnectionProfileSalesforceProfileArgs', 'ConnectionProfileSalesforceProfileArgsDict']]] = None,
                 sql_server_profile: Optional[pulumi.Input[Union['ConnectionProfileSqlServerProfileArgs', 'ConnectionProfileSqlServerProfileArgsDict']]] = None,
                 __props__=None):
        """
        A set of reusable connection configurations to be used as a source or destination for a stream.

        To get more information about ConnectionProfile, see:

        * [API documentation](https://cloud.google.com/datastream/docs/reference/rest/v1/projects.locations.connectionProfiles)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/datastream/docs/create-connection-profiles)

        ## Example Usage

        ### Datastream Connection Profile Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            gcs_profile={
                "bucket": "my-bucket",
                "root_path": "/path",
            })
        ```
        ### Datastream Connection Profile Postgresql Private Connection

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        default = gcp.compute.Network("default",
            name="my-network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="my-subnetwork",
            ip_cidr_range="10.1.0.0/16",
            region="us-central1",
            network=default.id)
        private_connection = gcp.datastream.PrivateConnection("private_connection",
            display_name="Private connection",
            location="us-central1",
            private_connection_id="my-connection",
            vpc_peering_config={
                "vpc": default.id,
                "subnet": "10.0.0.0/29",
            })
        nat_vm_ip = gcp.compute.Address("nat_vm_ip", name="nat-vm-ip")
        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="POSTGRES_14",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "authorized_networks": [{
                        "value": nat_vm_ip.address,
                    }],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password=pwd.result)
        nat_vm = gcp.compute.Instance("nat_vm",
            name="nat-vm",
            machine_type="e2-medium",
            zone="us-central1-a",
            desired_status="RUNNING",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-12",
                },
            },
            network_interfaces=[{
                "network": private_connection.vpc_peering_config.vpc,
                "subnetwork": default_subnetwork.self_link,
                "access_configs": [{
                    "nat_ip": nat_vm_ip.address,
                }],
            }],
            metadata_startup_script=instance.public_ip_address.apply(lambda public_ip_address: f\"\"\"#! /bin/bash
        # See https://cloud.google.com/datastream/docs/private-connectivity#set-up-reverse-proxy
        export DB_ADDR={public_ip_address}
        export DB_PORT=5432
        echo 1 > /proc/sys/net/ipv4/ip_forward
        md_url_prefix=\\"http://169.254.169.254/computeMetadata/v1/instance\\"
        vm_nic_ip=\\"$(curl -H \\"Metadata-Flavor: Google\\" ${{md_url_prefix}}/network-interfaces/0/ip)\\"
        iptables -t nat -F
        iptables -t nat -A PREROUTING \\\\
             -p tcp --dport $DB_PORT \\\\
             -j DNAT \\\\
             --to-destination $DB_ADDR
        iptables -t nat -A POSTROUTING \\\\
             -p tcp --dport $DB_PORT \\\\
             -j SNAT \\\\
             --to-source $vm_nic_ip
        iptables-save
        \"\"\"))
        rules = gcp.compute.Firewall("rules",
            name="ingress-rule",
            network=private_connection.vpc_peering_config.vpc,
            description="Allow traffic into NAT VM",
            direction="INGRESS",
            allows=[{
                "protocol": "tcp",
                "ports": ["5432"],
            }],
            source_ranges=[private_connection.vpc_peering_config.subnet])
        default_connection_profile = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            postgresql_profile={
                "hostname": nat_vm.network_interfaces[0].network_ip,
                "username": user.name,
                "password": user.password,
                "database": db.name,
                "port": 5432,
            },
            private_connectivity={
                "private_connection": private_connection.id,
            })
        ```
        ### Datastream Connection Profile Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            gcs_profile={
                "bucket": "my-bucket",
                "root_path": "/path",
            },
            forward_ssh_connectivity={
                "hostname": "google.com",
                "username": "my-user",
                "port": 8022,
                "password": "swordfish",
            },
            labels={
                "key": "value",
            })
        ```
        ### Datastream Connection Profile Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="POSTGRES_14",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password=pwd.result)
        default = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            postgresql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
                "database": db.name,
            })
        ```
        ### Datastream Connection Profile Sql Server

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="sql-server",
            database_version="SQLSERVER_2019_STANDARD",
            region="us-central1",
            root_password="root-password",
            deletion_protection=True,
            settings={
                "tier": "db-custom-2-4096",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            })
        db = gcp.sql.Database("db",
            name="db",
            instance=instance.name)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password="password")
        default = gcp.datastream.ConnectionProfile("default",
            display_name="SQL Server Source",
            location="us-central1",
            connection_profile_id="source-profile",
            sql_server_profile={
                "hostname": instance.public_ip_address,
                "port": 1433,
                "username": user.name,
                "password": user.password,
                "database": db.name,
            })
        ```
        ### Datastream Connection Profile Salesforce

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Salesforce Source",
            location="us-central1",
            connection_profile_id="source-profile",
            create_without_validation=True,
            salesforce_profile={
                "domain": "fake-domain.my.salesforce.com",
                "user_credentials": {
                    "username": "fake-username",
                    "secret_manager_stored_password": "fake-password",
                    "secret_manager_stored_security_token": "fake-token",
                },
            })
        ```
        ### Datastream Connection Profile Postgres Secret Manager

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Postgres Source With Secret Manager",
            location="us-central1",
            connection_profile_id="source-profile",
            create_without_validation=True,
            postgresql_profile={
                "hostname": "fake-hostname",
                "port": 3306,
                "username": "fake-username",
                "secret_manager_stored_password": "projects/fake-project/secrets/fake-secret/versions/1",
                "database": "fake-database",
            })
        ```
        ### Datastream Connection Profile Mongodb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Mongodb Source",
            location="us-central1",
            connection_profile_id="source-profile",
            mongodb_profile={
                "host_addresses": [{
                    "hostname": "mongodb-primary.example.com",
                    "port": 27017,
                }],
                "replica_set": "myReplicaSet",
                "username": "mongoUser",
                "password": "mongoPassword",
                "database": "myDatabase",
                "standard_connection_format": {}[0],
            })
        ```

        ## Import

        ConnectionProfile can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}`

        * `{{project}}/{{location}}/{{connection_profile_id}}`

        * `{{location}}/{{connection_profile_id}}`

        When using the `pulumi import` command, ConnectionProfile can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}
        ```

        ```sh
        $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default {{project}}/{{location}}/{{connection_profile_id}}
        ```

        ```sh
        $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default {{location}}/{{connection_profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionProfileBigqueryProfileArgs', 'ConnectionProfileBigqueryProfileArgsDict']] bigquery_profile: BigQuery warehouse profile.
        :param pulumi.Input[_builtins.str] connection_profile_id: The connection profile identifier.
        :param pulumi.Input[_builtins.bool] create_without_validation: Create the connection profile without validating it.
        :param pulumi.Input[_builtins.str] display_name: Display name.
        :param pulumi.Input[Union['ConnectionProfileForwardSshConnectivityArgs', 'ConnectionProfileForwardSshConnectivityArgsDict']] forward_ssh_connectivity: Forward SSH tunnel connectivity.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileGcsProfileArgs', 'ConnectionProfileGcsProfileArgsDict']] gcs_profile: Cloud Storage bucket profile.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The name of the location this connection profile is located in.
        :param pulumi.Input[Union['ConnectionProfileMongodbProfileArgs', 'ConnectionProfileMongodbProfileArgsDict']] mongodb_profile: Configuration for connecting to a MongoDB database.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileMysqlProfileArgs', 'ConnectionProfileMysqlProfileArgsDict']] mysql_profile: MySQL database profile.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileOracleProfileArgs', 'ConnectionProfileOracleProfileArgsDict']] oracle_profile: Oracle database profile.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfilePostgresqlProfileArgs', 'ConnectionProfilePostgresqlProfileArgsDict']] postgresql_profile: PostgreSQL database profile.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfilePrivateConnectivityArgs', 'ConnectionProfilePrivateConnectivityArgsDict']] private_connectivity: Private connectivity.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ConnectionProfileSalesforceProfileArgs', 'ConnectionProfileSalesforceProfileArgsDict']] salesforce_profile: Salesforce profile.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileSqlServerProfileArgs', 'ConnectionProfileSqlServerProfileArgsDict']] sql_server_profile: SQL Server database profile.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A set of reusable connection configurations to be used as a source or destination for a stream.

        To get more information about ConnectionProfile, see:

        * [API documentation](https://cloud.google.com/datastream/docs/reference/rest/v1/projects.locations.connectionProfiles)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/datastream/docs/create-connection-profiles)

        ## Example Usage

        ### Datastream Connection Profile Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            gcs_profile={
                "bucket": "my-bucket",
                "root_path": "/path",
            })
        ```
        ### Datastream Connection Profile Postgresql Private Connection

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        default = gcp.compute.Network("default",
            name="my-network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="my-subnetwork",
            ip_cidr_range="10.1.0.0/16",
            region="us-central1",
            network=default.id)
        private_connection = gcp.datastream.PrivateConnection("private_connection",
            display_name="Private connection",
            location="us-central1",
            private_connection_id="my-connection",
            vpc_peering_config={
                "vpc": default.id,
                "subnet": "10.0.0.0/29",
            })
        nat_vm_ip = gcp.compute.Address("nat_vm_ip", name="nat-vm-ip")
        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="POSTGRES_14",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "authorized_networks": [{
                        "value": nat_vm_ip.address,
                    }],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password=pwd.result)
        nat_vm = gcp.compute.Instance("nat_vm",
            name="nat-vm",
            machine_type="e2-medium",
            zone="us-central1-a",
            desired_status="RUNNING",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-12",
                },
            },
            network_interfaces=[{
                "network": private_connection.vpc_peering_config.vpc,
                "subnetwork": default_subnetwork.self_link,
                "access_configs": [{
                    "nat_ip": nat_vm_ip.address,
                }],
            }],
            metadata_startup_script=instance.public_ip_address.apply(lambda public_ip_address: f\"\"\"#! /bin/bash
        # See https://cloud.google.com/datastream/docs/private-connectivity#set-up-reverse-proxy
        export DB_ADDR={public_ip_address}
        export DB_PORT=5432
        echo 1 > /proc/sys/net/ipv4/ip_forward
        md_url_prefix=\\"http://169.254.169.254/computeMetadata/v1/instance\\"
        vm_nic_ip=\\"$(curl -H \\"Metadata-Flavor: Google\\" ${{md_url_prefix}}/network-interfaces/0/ip)\\"
        iptables -t nat -F
        iptables -t nat -A PREROUTING \\\\
             -p tcp --dport $DB_PORT \\\\
             -j DNAT \\\\
             --to-destination $DB_ADDR
        iptables -t nat -A POSTROUTING \\\\
             -p tcp --dport $DB_PORT \\\\
             -j SNAT \\\\
             --to-source $vm_nic_ip
        iptables-save
        \"\"\"))
        rules = gcp.compute.Firewall("rules",
            name="ingress-rule",
            network=private_connection.vpc_peering_config.vpc,
            description="Allow traffic into NAT VM",
            direction="INGRESS",
            allows=[{
                "protocol": "tcp",
                "ports": ["5432"],
            }],
            source_ranges=[private_connection.vpc_peering_config.subnet])
        default_connection_profile = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            postgresql_profile={
                "hostname": nat_vm.network_interfaces[0].network_ip,
                "username": user.name,
                "password": user.password,
                "database": db.name,
                "port": 5432,
            },
            private_connectivity={
                "private_connection": private_connection.id,
            })
        ```
        ### Datastream Connection Profile Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            gcs_profile={
                "bucket": "my-bucket",
                "root_path": "/path",
            },
            forward_ssh_connectivity={
                "hostname": "google.com",
                "username": "my-user",
                "port": 8022,
                "password": "swordfish",
            },
            labels={
                "key": "value",
            })
        ```
        ### Datastream Connection Profile Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="POSTGRES_14",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password=pwd.result)
        default = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            postgresql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
                "database": db.name,
            })
        ```
        ### Datastream Connection Profile Sql Server

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="sql-server",
            database_version="SQLSERVER_2019_STANDARD",
            region="us-central1",
            root_password="root-password",
            deletion_protection=True,
            settings={
                "tier": "db-custom-2-4096",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            })
        db = gcp.sql.Database("db",
            name="db",
            instance=instance.name)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password="password")
        default = gcp.datastream.ConnectionProfile("default",
            display_name="SQL Server Source",
            location="us-central1",
            connection_profile_id="source-profile",
            sql_server_profile={
                "hostname": instance.public_ip_address,
                "port": 1433,
                "username": user.name,
                "password": user.password,
                "database": db.name,
            })
        ```
        ### Datastream Connection Profile Salesforce

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Salesforce Source",
            location="us-central1",
            connection_profile_id="source-profile",
            create_without_validation=True,
            salesforce_profile={
                "domain": "fake-domain.my.salesforce.com",
                "user_credentials": {
                    "username": "fake-username",
                    "secret_manager_stored_password": "fake-password",
                    "secret_manager_stored_security_token": "fake-token",
                },
            })
        ```
        ### Datastream Connection Profile Postgres Secret Manager

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Postgres Source With Secret Manager",
            location="us-central1",
            connection_profile_id="source-profile",
            create_without_validation=True,
            postgresql_profile={
                "hostname": "fake-hostname",
                "port": 3306,
                "username": "fake-username",
                "secret_manager_stored_password": "projects/fake-project/secrets/fake-secret/versions/1",
                "database": "fake-database",
            })
        ```
        ### Datastream Connection Profile Mongodb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            display_name="Mongodb Source",
            location="us-central1",
            connection_profile_id="source-profile",
            mongodb_profile={
                "host_addresses": [{
                    "hostname": "mongodb-primary.example.com",
                    "port": 27017,
                }],
                "replica_set": "myReplicaSet",
                "username": "mongoUser",
                "password": "mongoPassword",
                "database": "myDatabase",
                "standard_connection_format": {}[0],
            })
        ```

        ## Import

        ConnectionProfile can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}`

        * `{{project}}/{{location}}/{{connection_profile_id}}`

        * `{{location}}/{{connection_profile_id}}`

        When using the `pulumi import` command, ConnectionProfile can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}
        ```

        ```sh
        $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default {{project}}/{{location}}/{{connection_profile_id}}
        ```

        ```sh
        $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default {{location}}/{{connection_profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_profile: Optional[pulumi.Input[Union['ConnectionProfileBigqueryProfileArgs', 'ConnectionProfileBigqueryProfileArgsDict']]] = None,
                 connection_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_without_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_ssh_connectivity: Optional[pulumi.Input[Union['ConnectionProfileForwardSshConnectivityArgs', 'ConnectionProfileForwardSshConnectivityArgsDict']]] = None,
                 gcs_profile: Optional[pulumi.Input[Union['ConnectionProfileGcsProfileArgs', 'ConnectionProfileGcsProfileArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodb_profile: Optional[pulumi.Input[Union['ConnectionProfileMongodbProfileArgs', 'ConnectionProfileMongodbProfileArgsDict']]] = None,
                 mysql_profile: Optional[pulumi.Input[Union['ConnectionProfileMysqlProfileArgs', 'ConnectionProfileMysqlProfileArgsDict']]] = None,
                 oracle_profile: Optional[pulumi.Input[Union['ConnectionProfileOracleProfileArgs', 'ConnectionProfileOracleProfileArgsDict']]] = None,
                 postgresql_profile: Optional[pulumi.Input[Union['ConnectionProfilePostgresqlProfileArgs', 'ConnectionProfilePostgresqlProfileArgsDict']]] = None,
                 private_connectivity: Optional[pulumi.Input[Union['ConnectionProfilePrivateConnectivityArgs', 'ConnectionProfilePrivateConnectivityArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 salesforce_profile: Optional[pulumi.Input[Union['ConnectionProfileSalesforceProfileArgs', 'ConnectionProfileSalesforceProfileArgsDict']]] = None,
                 sql_server_profile: Optional[pulumi.Input[Union['ConnectionProfileSqlServerProfileArgs', 'ConnectionProfileSqlServerProfileArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionProfileArgs.__new__(ConnectionProfileArgs)

            __props__.__dict__["bigquery_profile"] = bigquery_profile
            if connection_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_profile_id'")
            __props__.__dict__["connection_profile_id"] = connection_profile_id
            __props__.__dict__["create_without_validation"] = create_without_validation
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["forward_ssh_connectivity"] = forward_ssh_connectivity
            __props__.__dict__["gcs_profile"] = gcs_profile
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["mongodb_profile"] = mongodb_profile
            __props__.__dict__["mysql_profile"] = mysql_profile
            __props__.__dict__["oracle_profile"] = oracle_profile
            __props__.__dict__["postgresql_profile"] = postgresql_profile
            __props__.__dict__["private_connectivity"] = private_connectivity
            __props__.__dict__["project"] = project
            __props__.__dict__["salesforce_profile"] = salesforce_profile
            __props__.__dict__["sql_server_profile"] = sql_server_profile
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ConnectionProfile, __self__).__init__(
            'gcp:datastream/connectionProfile:ConnectionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bigquery_profile: Optional[pulumi.Input[Union['ConnectionProfileBigqueryProfileArgs', 'ConnectionProfileBigqueryProfileArgsDict']]] = None,
            connection_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_without_validation: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            forward_ssh_connectivity: Optional[pulumi.Input[Union['ConnectionProfileForwardSshConnectivityArgs', 'ConnectionProfileForwardSshConnectivityArgsDict']]] = None,
            gcs_profile: Optional[pulumi.Input[Union['ConnectionProfileGcsProfileArgs', 'ConnectionProfileGcsProfileArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            mongodb_profile: Optional[pulumi.Input[Union['ConnectionProfileMongodbProfileArgs', 'ConnectionProfileMongodbProfileArgsDict']]] = None,
            mysql_profile: Optional[pulumi.Input[Union['ConnectionProfileMysqlProfileArgs', 'ConnectionProfileMysqlProfileArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oracle_profile: Optional[pulumi.Input[Union['ConnectionProfileOracleProfileArgs', 'ConnectionProfileOracleProfileArgsDict']]] = None,
            postgresql_profile: Optional[pulumi.Input[Union['ConnectionProfilePostgresqlProfileArgs', 'ConnectionProfilePostgresqlProfileArgsDict']]] = None,
            private_connectivity: Optional[pulumi.Input[Union['ConnectionProfilePrivateConnectivityArgs', 'ConnectionProfilePrivateConnectivityArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            salesforce_profile: Optional[pulumi.Input[Union['ConnectionProfileSalesforceProfileArgs', 'ConnectionProfileSalesforceProfileArgsDict']]] = None,
            sql_server_profile: Optional[pulumi.Input[Union['ConnectionProfileSqlServerProfileArgs', 'ConnectionProfileSqlServerProfileArgsDict']]] = None) -> 'ConnectionProfile':
        """
        Get an existing ConnectionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionProfileBigqueryProfileArgs', 'ConnectionProfileBigqueryProfileArgsDict']] bigquery_profile: BigQuery warehouse profile.
        :param pulumi.Input[_builtins.str] connection_profile_id: The connection profile identifier.
        :param pulumi.Input[_builtins.bool] create_without_validation: Create the connection profile without validating it.
        :param pulumi.Input[_builtins.str] display_name: Display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['ConnectionProfileForwardSshConnectivityArgs', 'ConnectionProfileForwardSshConnectivityArgsDict']] forward_ssh_connectivity: Forward SSH tunnel connectivity.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileGcsProfileArgs', 'ConnectionProfileGcsProfileArgsDict']] gcs_profile: Cloud Storage bucket profile.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The name of the location this connection profile is located in.
        :param pulumi.Input[Union['ConnectionProfileMongodbProfileArgs', 'ConnectionProfileMongodbProfileArgsDict']] mongodb_profile: Configuration for connecting to a MongoDB database.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileMysqlProfileArgs', 'ConnectionProfileMysqlProfileArgsDict']] mysql_profile: MySQL database profile.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The resource's name.
        :param pulumi.Input[Union['ConnectionProfileOracleProfileArgs', 'ConnectionProfileOracleProfileArgsDict']] oracle_profile: Oracle database profile.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfilePostgresqlProfileArgs', 'ConnectionProfilePostgresqlProfileArgsDict']] postgresql_profile: PostgreSQL database profile.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfilePrivateConnectivityArgs', 'ConnectionProfilePrivateConnectivityArgsDict']] private_connectivity: Private connectivity.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['ConnectionProfileSalesforceProfileArgs', 'ConnectionProfileSalesforceProfileArgsDict']] salesforce_profile: Salesforce profile.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileSqlServerProfileArgs', 'ConnectionProfileSqlServerProfileArgsDict']] sql_server_profile: SQL Server database profile.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionProfileState.__new__(_ConnectionProfileState)

        __props__.__dict__["bigquery_profile"] = bigquery_profile
        __props__.__dict__["connection_profile_id"] = connection_profile_id
        __props__.__dict__["create_without_validation"] = create_without_validation
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["forward_ssh_connectivity"] = forward_ssh_connectivity
        __props__.__dict__["gcs_profile"] = gcs_profile
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["mongodb_profile"] = mongodb_profile
        __props__.__dict__["mysql_profile"] = mysql_profile
        __props__.__dict__["name"] = name
        __props__.__dict__["oracle_profile"] = oracle_profile
        __props__.__dict__["postgresql_profile"] = postgresql_profile
        __props__.__dict__["private_connectivity"] = private_connectivity
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["salesforce_profile"] = salesforce_profile
        __props__.__dict__["sql_server_profile"] = sql_server_profile
        return ConnectionProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bigqueryProfile")
    def bigquery_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileBigqueryProfile']]:
        """
        BigQuery warehouse profile.
        """
        return pulumi.get(self, "bigquery_profile")

    @_builtins.property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        The connection profile identifier.
        """
        return pulumi.get(self, "connection_profile_id")

    @_builtins.property
    @pulumi.getter(name="createWithoutValidation")
    def create_without_validation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Create the connection profile without validating it.
        """
        return pulumi.get(self, "create_without_validation")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="forwardSshConnectivity")
    def forward_ssh_connectivity(self) -> pulumi.Output[Optional['outputs.ConnectionProfileForwardSshConnectivity']]:
        """
        Forward SSH tunnel connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_ssh_connectivity")

    @_builtins.property
    @pulumi.getter(name="gcsProfile")
    def gcs_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileGcsProfile']]:
        """
        Cloud Storage bucket profile.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_profile")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the location this connection profile is located in.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mongodbProfile")
    def mongodb_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileMongodbProfile']]:
        """
        Configuration for connecting to a MongoDB database.
        Structure is documented below.
        """
        return pulumi.get(self, "mongodb_profile")

    @_builtins.property
    @pulumi.getter(name="mysqlProfile")
    def mysql_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileMysqlProfile']]:
        """
        MySQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_profile")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oracleProfile")
    def oracle_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileOracleProfile']]:
        """
        Oracle database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_profile")

    @_builtins.property
    @pulumi.getter(name="postgresqlProfile")
    def postgresql_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfilePostgresqlProfile']]:
        """
        PostgreSQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_profile")

    @_builtins.property
    @pulumi.getter(name="privateConnectivity")
    def private_connectivity(self) -> pulumi.Output[Optional['outputs.ConnectionProfilePrivateConnectivity']]:
        """
        Private connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "private_connectivity")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="salesforceProfile")
    def salesforce_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileSalesforceProfile']]:
        """
        Salesforce profile.
        Structure is documented below.
        """
        return pulumi.get(self, "salesforce_profile")

    @_builtins.property
    @pulumi.getter(name="sqlServerProfile")
    def sql_server_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileSqlServerProfile']]:
        """
        SQL Server database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "sql_server_profile")

