# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GitRepositoryLinkArgs', 'GitRepositoryLink']

@pulumi.input_type
class GitRepositoryLinkArgs:
    def __init__(__self__, *,
                 clone_uri: pulumi.Input[_builtins.str],
                 git_repository_link_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 parent_connection: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GitRepositoryLink resource.
        :param pulumi.Input[_builtins.str] clone_uri: Required. Git Clone URI.
        :param pulumi.Input[_builtins.str] git_repository_link_id: Required. The ID to use for the repository, which will become the final component of
               the repository's resource name. This ID should be unique in the connection.
               Allows alphanumeric characters and any of -._~%!$&'()*+,;=@.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        :param pulumi.Input[_builtins.str] parent_connection: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. Allows clients to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] etag: Optional. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "clone_uri", clone_uri)
        pulumi.set(__self__, "git_repository_link_id", git_repository_link_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "parent_connection", parent_connection)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="cloneUri")
    def clone_uri(self) -> pulumi.Input[_builtins.str]:
        """
        Required. Git Clone URI.
        """
        return pulumi.get(self, "clone_uri")

    @clone_uri.setter
    def clone_uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "clone_uri", value)

    @_builtins.property
    @pulumi.getter(name="gitRepositoryLinkId")
    def git_repository_link_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The ID to use for the repository, which will become the final component of
        the repository's resource name. This ID should be unique in the connection.
        Allows alphanumeric characters and any of -._~%!$&'()*+,;=@.
        """
        return pulumi.get(self, "git_repository_link_id")

    @git_repository_link_id.setter
    def git_repository_link_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "git_repository_link_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="parentConnection")
    def parent_connection(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        """
        return pulumi.get(self, "parent_connection")

    @parent_connection.setter
    def parent_connection(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent_connection", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Allows clients to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _GitRepositoryLinkState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 clone_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 git_repository_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitRepositoryLink resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. Allows clients to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] clone_uri: Required. Git Clone URI.
        :param pulumi.Input[_builtins.str] create_time: Output only. [Output only] Create timestamp
        :param pulumi.Input[_builtins.str] delete_time: Output only. [Output only] Delete timestamp
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Optional. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[_builtins.str] git_repository_link_id: Required. The ID to use for the repository, which will become the final component of
               the repository's resource name. This ID should be unique in the connection.
               Allows alphanumeric characters and any of -._~%!$&'()*+,;=@.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        :param pulumi.Input[_builtins.str] name: Identifier. Resource name of the repository, in the format
               `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
        :param pulumi.Input[_builtins.str] parent_connection: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Output only. Set to true when the connection is being set up or updated in the
               background.
        :param pulumi.Input[_builtins.str] uid: Output only. A system-assigned unique identifier for a the GitRepositoryLink.
        :param pulumi.Input[_builtins.str] update_time: Output only. [Output only] Update timestamp
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if clone_uri is not None:
            pulumi.set(__self__, "clone_uri", clone_uri)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if git_repository_link_id is not None:
            pulumi.set(__self__, "git_repository_link_id", git_repository_link_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_connection is not None:
            pulumi.set(__self__, "parent_connection", parent_connection)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Allows clients to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="cloneUri")
    def clone_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Git Clone URI.
        """
        return pulumi.get(self, "clone_uri")

    @clone_uri.setter
    def clone_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clone_uri", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. [Output only] Create timestamp
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. [Output only] Delete timestamp
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="gitRepositoryLinkId")
    def git_repository_link_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The ID to use for the repository, which will become the final component of
        the repository's resource name. This ID should be unique in the connection.
        Allows alphanumeric characters and any of -._~%!$&'()*+,;=@.
        """
        return pulumi.get(self, "git_repository_link_id")

    @git_repository_link_id.setter
    def git_repository_link_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_repository_link_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Resource name of the repository, in the format
        `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentConnection")
    def parent_connection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        """
        return pulumi.get(self, "parent_connection")

    @parent_connection.setter
    def parent_connection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_connection", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Output only. Set to true when the connection is being set up or updated in the
        background.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. A system-assigned unique identifier for a the GitRepositoryLink.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. [Output only] Update timestamp
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:developerconnect/gitRepositoryLink:GitRepositoryLink")
class GitRepositoryLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 clone_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 git_repository_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A git repository link to a parent connection.

        To get more information about GitRepositoryLink, see:

        * [API documentation](https://cloud.google.com/developer-connect/docs/api/reference/rest/v1/projects.locations.connections.gitRepositoryLinks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/developer-connect/docs/overview)

        ## Example Usage

        ### Developer Connect Git Repository Link Github Doc

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        github_token_secret = gcp.secretmanager.Secret("github-token-secret",
            secret_id="github-token-secret",
            replication={
                "auto": {},
            })
        github_token_secret_version = gcp.secretmanager.SecretVersion("github-token-secret-version",
            secret=github_token_secret.id,
            secret_data=std.file(input="my-github-token.txt").result)
        p4sa_secret_accessor = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": ["serviceAccount:service-123456789@gcp-sa-devconnect.iam.gserviceaccount.com"],
        }])
        policy = gcp.secretmanager.SecretIamPolicy("policy",
            secret_id=github_token_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="my-connection",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "app_installation_id": "123123",
                "authorizer_credential": {
                    "oauth_token_secret_version": github_token_secret_version.id,
                },
            })
        my_repository = gcp.developerconnect.GitRepositoryLink("my-repository",
            location="us-central1",
            git_repository_link_id="my-repo",
            parent_connection=my_connection.connection_id,
            remote_uri="https://github.com/myuser/myrepo.git")
        ```

        ## Import

        GitRepositoryLink can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connections/{{parent_connection}}/gitRepositoryLinks/{{git_repository_link_id}}`

        * `{{project}}/{{location}}/{{parent_connection}}/{{git_repository_link_id}}`

        * `{{location}}/{{parent_connection}}/{{git_repository_link_id}}`

        When using the `pulumi import` command, GitRepositoryLink can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:developerconnect/gitRepositoryLink:GitRepositoryLink default projects/{{project}}/locations/{{location}}/connections/{{parent_connection}}/gitRepositoryLinks/{{git_repository_link_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/gitRepositoryLink:GitRepositoryLink default {{project}}/{{location}}/{{parent_connection}}/{{git_repository_link_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/gitRepositoryLink:GitRepositoryLink default {{location}}/{{parent_connection}}/{{git_repository_link_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. Allows clients to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] clone_uri: Required. Git Clone URI.
        :param pulumi.Input[_builtins.str] etag: Optional. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[_builtins.str] git_repository_link_id: Required. The ID to use for the repository, which will become the final component of
               the repository's resource name. This ID should be unique in the connection.
               Allows alphanumeric characters and any of -._~%!$&'()*+,;=@.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        :param pulumi.Input[_builtins.str] parent_connection: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitRepositoryLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A git repository link to a parent connection.

        To get more information about GitRepositoryLink, see:

        * [API documentation](https://cloud.google.com/developer-connect/docs/api/reference/rest/v1/projects.locations.connections.gitRepositoryLinks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/developer-connect/docs/overview)

        ## Example Usage

        ### Developer Connect Git Repository Link Github Doc

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        github_token_secret = gcp.secretmanager.Secret("github-token-secret",
            secret_id="github-token-secret",
            replication={
                "auto": {},
            })
        github_token_secret_version = gcp.secretmanager.SecretVersion("github-token-secret-version",
            secret=github_token_secret.id,
            secret_data=std.file(input="my-github-token.txt").result)
        p4sa_secret_accessor = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": ["serviceAccount:service-123456789@gcp-sa-devconnect.iam.gserviceaccount.com"],
        }])
        policy = gcp.secretmanager.SecretIamPolicy("policy",
            secret_id=github_token_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="my-connection",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "app_installation_id": "123123",
                "authorizer_credential": {
                    "oauth_token_secret_version": github_token_secret_version.id,
                },
            })
        my_repository = gcp.developerconnect.GitRepositoryLink("my-repository",
            location="us-central1",
            git_repository_link_id="my-repo",
            parent_connection=my_connection.connection_id,
            remote_uri="https://github.com/myuser/myrepo.git")
        ```

        ## Import

        GitRepositoryLink can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connections/{{parent_connection}}/gitRepositoryLinks/{{git_repository_link_id}}`

        * `{{project}}/{{location}}/{{parent_connection}}/{{git_repository_link_id}}`

        * `{{location}}/{{parent_connection}}/{{git_repository_link_id}}`

        When using the `pulumi import` command, GitRepositoryLink can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:developerconnect/gitRepositoryLink:GitRepositoryLink default projects/{{project}}/locations/{{location}}/connections/{{parent_connection}}/gitRepositoryLinks/{{git_repository_link_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/gitRepositoryLink:GitRepositoryLink default {{project}}/{{location}}/{{parent_connection}}/{{git_repository_link_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/gitRepositoryLink:GitRepositoryLink default {{location}}/{{parent_connection}}/{{git_repository_link_id}}
        ```

        :param str resource_name: The name of the resource.
        :param GitRepositoryLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitRepositoryLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 clone_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 git_repository_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitRepositoryLinkArgs.__new__(GitRepositoryLinkArgs)

            __props__.__dict__["annotations"] = annotations
            if clone_uri is None and not opts.urn:
                raise TypeError("Missing required property 'clone_uri'")
            __props__.__dict__["clone_uri"] = clone_uri
            __props__.__dict__["etag"] = etag
            if git_repository_link_id is None and not opts.urn:
                raise TypeError("Missing required property 'git_repository_link_id'")
            __props__.__dict__["git_repository_link_id"] = git_repository_link_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if parent_connection is None and not opts.urn:
                raise TypeError("Missing required property 'parent_connection'")
            __props__.__dict__["parent_connection"] = parent_connection
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GitRepositoryLink, __self__).__init__(
            'gcp:developerconnect/gitRepositoryLink:GitRepositoryLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            clone_uri: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            git_repository_link_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_connection: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'GitRepositoryLink':
        """
        Get an existing GitRepositoryLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. Allows clients to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] clone_uri: Required. Git Clone URI.
        :param pulumi.Input[_builtins.str] create_time: Output only. [Output only] Create timestamp
        :param pulumi.Input[_builtins.str] delete_time: Output only. [Output only] Delete timestamp
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Optional. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[_builtins.str] git_repository_link_id: Required. The ID to use for the repository, which will become the final component of
               the repository's resource name. This ID should be unique in the connection.
               Allows alphanumeric characters and any of -._~%!$&'()*+,;=@.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        :param pulumi.Input[_builtins.str] name: Identifier. Resource name of the repository, in the format
               `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
        :param pulumi.Input[_builtins.str] parent_connection: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Output only. Set to true when the connection is being set up or updated in the
               background.
        :param pulumi.Input[_builtins.str] uid: Output only. A system-assigned unique identifier for a the GitRepositoryLink.
        :param pulumi.Input[_builtins.str] update_time: Output only. [Output only] Update timestamp
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitRepositoryLinkState.__new__(_GitRepositoryLinkState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["clone_uri"] = clone_uri
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["git_repository_link_id"] = git_repository_link_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_connection"] = parent_connection
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return GitRepositoryLink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Allows clients to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="cloneUri")
    def clone_uri(self) -> pulumi.Output[_builtins.str]:
        """
        Required. Git Clone URI.
        """
        return pulumi.get(self, "clone_uri")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. [Output only] Create timestamp
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. [Output only] Delete timestamp
        """
        return pulumi.get(self, "delete_time")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="gitRepositoryLinkId")
    def git_repository_link_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The ID to use for the repository, which will become the final component of
        the repository's resource name. This ID should be unique in the connection.
        Allows alphanumeric characters and any of -._~%!$&'()*+,;=@.
        """
        return pulumi.get(self, "git_repository_link_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Resource name of the repository, in the format
        `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentConnection")
    def parent_connection(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `developerconnect.googleapis.com/GitRepositoryLink`.
        """
        return pulumi.get(self, "parent_connection")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Output only. Set to true when the connection is being set up or updated in the
        background.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. A system-assigned unique identifier for a the GitRepositoryLink.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. [Output only] Update timestamp
        """
        return pulumi.get(self, "update_time")

