# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConversationProfileArgs', 'ConversationProfile']

@pulumi.input_type
class ConversationProfileArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 automated_agent_config: Optional[pulumi.Input['ConversationProfileAutomatedAgentConfigArgs']] = None,
                 human_agent_assistant_config: Optional[pulumi.Input['ConversationProfileHumanAgentAssistantConfigArgs']] = None,
                 human_agent_handoff_config: Optional[pulumi.Input['ConversationProfileHumanAgentHandoffConfigArgs']] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['ConversationProfileLoggingConfigArgs']] = None,
                 new_message_event_notification_config: Optional[pulumi.Input['ConversationProfileNewMessageEventNotificationConfigArgs']] = None,
                 new_recognition_result_notification_config: Optional[pulumi.Input['ConversationProfileNewRecognitionResultNotificationConfigArgs']] = None,
                 notification_config: Optional[pulumi.Input['ConversationProfileNotificationConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 stt_config: Optional[pulumi.Input['ConversationProfileSttConfigArgs']] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 tts_config: Optional[pulumi.Input['ConversationProfileTtsConfigArgs']] = None):
        """
        The set of arguments for constructing a ConversationProfile resource.
        :param pulumi.Input[_builtins.str] display_name: Required. Human readable name for this profile. Max length 1024 bytes.
        :param pulumi.Input[_builtins.str] location: desc
        :param pulumi.Input['ConversationProfileAutomatedAgentConfigArgs'] automated_agent_config: Configuration for an automated agent to use with this profile
               Structure is documented below.
        :param pulumi.Input['ConversationProfileHumanAgentAssistantConfigArgs'] human_agent_assistant_config: Configuration for connecting to a live agent
               Structure is documented below.
        :param pulumi.Input['ConversationProfileHumanAgentHandoffConfigArgs'] human_agent_handoff_config: Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: Language code for the conversation profile. This should be a BCP-47 language tag.
        :param pulumi.Input['ConversationProfileLoggingConfigArgs'] logging_config: Defines logging behavior for conversation lifecycle events.
               Structure is documented below.
        :param pulumi.Input['ConversationProfileNewMessageEventNotificationConfigArgs'] new_message_event_notification_config: Pub/Sub topic on which to publish new agent assistant events.
               Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
               Structure is documented below.
        :param pulumi.Input['ConversationProfileNewRecognitionResultNotificationConfigArgs'] new_recognition_result_notification_config: Optional. Configuration for publishing transcription intermediate results. Event will be sent in format of ConversationEvent. If configured, the following information will be populated as ConversationEvent Pub/Sub message attributes: - "participant_id" - "participantRole" - "message_id"
               Structure is documented below.
        :param pulumi.Input['ConversationProfileNotificationConfigArgs'] notification_config: Pub/Sub topic on which to publish new agent assistant events.
               Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] security_settings: Name of the CX SecuritySettings reference for the agent.
        :param pulumi.Input['ConversationProfileSttConfigArgs'] stt_config: Settings for speech transcription.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of this conversational profile.
        :param pulumi.Input['ConversationProfileTtsConfigArgs'] tts_config: Configuration for Text-to-Speech synthesization. If agent defines synthesization options as well, agent settings overrides the option here.
               Structure is documented below.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if automated_agent_config is not None:
            pulumi.set(__self__, "automated_agent_config", automated_agent_config)
        if human_agent_assistant_config is not None:
            pulumi.set(__self__, "human_agent_assistant_config", human_agent_assistant_config)
        if human_agent_handoff_config is not None:
            pulumi.set(__self__, "human_agent_handoff_config", human_agent_handoff_config)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if new_message_event_notification_config is not None:
            pulumi.set(__self__, "new_message_event_notification_config", new_message_event_notification_config)
        if new_recognition_result_notification_config is not None:
            pulumi.set(__self__, "new_recognition_result_notification_config", new_recognition_result_notification_config)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if stt_config is not None:
            pulumi.set(__self__, "stt_config", stt_config)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if tts_config is not None:
            pulumi.set(__self__, "tts_config", tts_config)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Required. Human readable name for this profile. Max length 1024 bytes.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        desc
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="automatedAgentConfig")
    def automated_agent_config(self) -> Optional[pulumi.Input['ConversationProfileAutomatedAgentConfigArgs']]:
        """
        Configuration for an automated agent to use with this profile
        Structure is documented below.
        """
        return pulumi.get(self, "automated_agent_config")

    @automated_agent_config.setter
    def automated_agent_config(self, value: Optional[pulumi.Input['ConversationProfileAutomatedAgentConfigArgs']]):
        pulumi.set(self, "automated_agent_config", value)

    @_builtins.property
    @pulumi.getter(name="humanAgentAssistantConfig")
    def human_agent_assistant_config(self) -> Optional[pulumi.Input['ConversationProfileHumanAgentAssistantConfigArgs']]:
        """
        Configuration for connecting to a live agent
        Structure is documented below.
        """
        return pulumi.get(self, "human_agent_assistant_config")

    @human_agent_assistant_config.setter
    def human_agent_assistant_config(self, value: Optional[pulumi.Input['ConversationProfileHumanAgentAssistantConfigArgs']]):
        pulumi.set(self, "human_agent_assistant_config", value)

    @_builtins.property
    @pulumi.getter(name="humanAgentHandoffConfig")
    def human_agent_handoff_config(self) -> Optional[pulumi.Input['ConversationProfileHumanAgentHandoffConfigArgs']]:
        """
        Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation.
        Structure is documented below.
        """
        return pulumi.get(self, "human_agent_handoff_config")

    @human_agent_handoff_config.setter
    def human_agent_handoff_config(self, value: Optional[pulumi.Input['ConversationProfileHumanAgentHandoffConfigArgs']]):
        pulumi.set(self, "human_agent_handoff_config", value)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language code for the conversation profile. This should be a BCP-47 language tag.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_code", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['ConversationProfileLoggingConfigArgs']]:
        """
        Defines logging behavior for conversation lifecycle events.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['ConversationProfileLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter(name="newMessageEventNotificationConfig")
    def new_message_event_notification_config(self) -> Optional[pulumi.Input['ConversationProfileNewMessageEventNotificationConfigArgs']]:
        """
        Pub/Sub topic on which to publish new agent assistant events.
        Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
        Structure is documented below.
        """
        return pulumi.get(self, "new_message_event_notification_config")

    @new_message_event_notification_config.setter
    def new_message_event_notification_config(self, value: Optional[pulumi.Input['ConversationProfileNewMessageEventNotificationConfigArgs']]):
        pulumi.set(self, "new_message_event_notification_config", value)

    @_builtins.property
    @pulumi.getter(name="newRecognitionResultNotificationConfig")
    def new_recognition_result_notification_config(self) -> Optional[pulumi.Input['ConversationProfileNewRecognitionResultNotificationConfigArgs']]:
        """
        Optional. Configuration for publishing transcription intermediate results. Event will be sent in format of ConversationEvent. If configured, the following information will be populated as ConversationEvent Pub/Sub message attributes: - "participant_id" - "participantRole" - "message_id"
        Structure is documented below.
        """
        return pulumi.get(self, "new_recognition_result_notification_config")

    @new_recognition_result_notification_config.setter
    def new_recognition_result_notification_config(self, value: Optional[pulumi.Input['ConversationProfileNewRecognitionResultNotificationConfigArgs']]):
        pulumi.set(self, "new_recognition_result_notification_config", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional[pulumi.Input['ConversationProfileNotificationConfigArgs']]:
        """
        Pub/Sub topic on which to publish new agent assistant events.
        Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
        Structure is documented below.
        """
        return pulumi.get(self, "notification_config")

    @notification_config.setter
    def notification_config(self, value: Optional[pulumi.Input['ConversationProfileNotificationConfigArgs']]):
        pulumi.set(self, "notification_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the CX SecuritySettings reference for the agent.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_settings", value)

    @_builtins.property
    @pulumi.getter(name="sttConfig")
    def stt_config(self) -> Optional[pulumi.Input['ConversationProfileSttConfigArgs']]:
        """
        Settings for speech transcription.
        Structure is documented below.
        """
        return pulumi.get(self, "stt_config")

    @stt_config.setter
    def stt_config(self, value: Optional[pulumi.Input['ConversationProfileSttConfigArgs']]):
        pulumi.set(self, "stt_config", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of this conversational profile.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="ttsConfig")
    def tts_config(self) -> Optional[pulumi.Input['ConversationProfileTtsConfigArgs']]:
        """
        Configuration for Text-to-Speech synthesization. If agent defines synthesization options as well, agent settings overrides the option here.
        Structure is documented below.
        """
        return pulumi.get(self, "tts_config")

    @tts_config.setter
    def tts_config(self, value: Optional[pulumi.Input['ConversationProfileTtsConfigArgs']]):
        pulumi.set(self, "tts_config", value)


@pulumi.input_type
class _ConversationProfileState:
    def __init__(__self__, *,
                 automated_agent_config: Optional[pulumi.Input['ConversationProfileAutomatedAgentConfigArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 human_agent_assistant_config: Optional[pulumi.Input['ConversationProfileHumanAgentAssistantConfigArgs']] = None,
                 human_agent_handoff_config: Optional[pulumi.Input['ConversationProfileHumanAgentHandoffConfigArgs']] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['ConversationProfileLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_message_event_notification_config: Optional[pulumi.Input['ConversationProfileNewMessageEventNotificationConfigArgs']] = None,
                 new_recognition_result_notification_config: Optional[pulumi.Input['ConversationProfileNewRecognitionResultNotificationConfigArgs']] = None,
                 notification_config: Optional[pulumi.Input['ConversationProfileNotificationConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 stt_config: Optional[pulumi.Input['ConversationProfileSttConfigArgs']] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 tts_config: Optional[pulumi.Input['ConversationProfileTtsConfigArgs']] = None):
        """
        Input properties used for looking up and filtering ConversationProfile resources.
        :param pulumi.Input['ConversationProfileAutomatedAgentConfigArgs'] automated_agent_config: Configuration for an automated agent to use with this profile
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Required. Human readable name for this profile. Max length 1024 bytes.
        :param pulumi.Input['ConversationProfileHumanAgentAssistantConfigArgs'] human_agent_assistant_config: Configuration for connecting to a live agent
               Structure is documented below.
        :param pulumi.Input['ConversationProfileHumanAgentHandoffConfigArgs'] human_agent_handoff_config: Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: Language code for the conversation profile. This should be a BCP-47 language tag.
        :param pulumi.Input[_builtins.str] location: desc
        :param pulumi.Input['ConversationProfileLoggingConfigArgs'] logging_config: Defines logging behavior for conversation lifecycle events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: name
        :param pulumi.Input['ConversationProfileNewMessageEventNotificationConfigArgs'] new_message_event_notification_config: Pub/Sub topic on which to publish new agent assistant events.
               Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
               Structure is documented below.
        :param pulumi.Input['ConversationProfileNewRecognitionResultNotificationConfigArgs'] new_recognition_result_notification_config: Optional. Configuration for publishing transcription intermediate results. Event will be sent in format of ConversationEvent. If configured, the following information will be populated as ConversationEvent Pub/Sub message attributes: - "participant_id" - "participantRole" - "message_id"
               Structure is documented below.
        :param pulumi.Input['ConversationProfileNotificationConfigArgs'] notification_config: Pub/Sub topic on which to publish new agent assistant events.
               Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] security_settings: Name of the CX SecuritySettings reference for the agent.
        :param pulumi.Input['ConversationProfileSttConfigArgs'] stt_config: Settings for speech transcription.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of this conversational profile.
        :param pulumi.Input['ConversationProfileTtsConfigArgs'] tts_config: Configuration for Text-to-Speech synthesization. If agent defines synthesization options as well, agent settings overrides the option here.
               Structure is documented below.
        """
        if automated_agent_config is not None:
            pulumi.set(__self__, "automated_agent_config", automated_agent_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if human_agent_assistant_config is not None:
            pulumi.set(__self__, "human_agent_assistant_config", human_agent_assistant_config)
        if human_agent_handoff_config is not None:
            pulumi.set(__self__, "human_agent_handoff_config", human_agent_handoff_config)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_message_event_notification_config is not None:
            pulumi.set(__self__, "new_message_event_notification_config", new_message_event_notification_config)
        if new_recognition_result_notification_config is not None:
            pulumi.set(__self__, "new_recognition_result_notification_config", new_recognition_result_notification_config)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if stt_config is not None:
            pulumi.set(__self__, "stt_config", stt_config)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if tts_config is not None:
            pulumi.set(__self__, "tts_config", tts_config)

    @_builtins.property
    @pulumi.getter(name="automatedAgentConfig")
    def automated_agent_config(self) -> Optional[pulumi.Input['ConversationProfileAutomatedAgentConfigArgs']]:
        """
        Configuration for an automated agent to use with this profile
        Structure is documented below.
        """
        return pulumi.get(self, "automated_agent_config")

    @automated_agent_config.setter
    def automated_agent_config(self, value: Optional[pulumi.Input['ConversationProfileAutomatedAgentConfigArgs']]):
        pulumi.set(self, "automated_agent_config", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Human readable name for this profile. Max length 1024 bytes.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="humanAgentAssistantConfig")
    def human_agent_assistant_config(self) -> Optional[pulumi.Input['ConversationProfileHumanAgentAssistantConfigArgs']]:
        """
        Configuration for connecting to a live agent
        Structure is documented below.
        """
        return pulumi.get(self, "human_agent_assistant_config")

    @human_agent_assistant_config.setter
    def human_agent_assistant_config(self, value: Optional[pulumi.Input['ConversationProfileHumanAgentAssistantConfigArgs']]):
        pulumi.set(self, "human_agent_assistant_config", value)

    @_builtins.property
    @pulumi.getter(name="humanAgentHandoffConfig")
    def human_agent_handoff_config(self) -> Optional[pulumi.Input['ConversationProfileHumanAgentHandoffConfigArgs']]:
        """
        Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation.
        Structure is documented below.
        """
        return pulumi.get(self, "human_agent_handoff_config")

    @human_agent_handoff_config.setter
    def human_agent_handoff_config(self, value: Optional[pulumi.Input['ConversationProfileHumanAgentHandoffConfigArgs']]):
        pulumi.set(self, "human_agent_handoff_config", value)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language code for the conversation profile. This should be a BCP-47 language tag.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_code", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        desc
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['ConversationProfileLoggingConfigArgs']]:
        """
        Defines logging behavior for conversation lifecycle events.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['ConversationProfileLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newMessageEventNotificationConfig")
    def new_message_event_notification_config(self) -> Optional[pulumi.Input['ConversationProfileNewMessageEventNotificationConfigArgs']]:
        """
        Pub/Sub topic on which to publish new agent assistant events.
        Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
        Structure is documented below.
        """
        return pulumi.get(self, "new_message_event_notification_config")

    @new_message_event_notification_config.setter
    def new_message_event_notification_config(self, value: Optional[pulumi.Input['ConversationProfileNewMessageEventNotificationConfigArgs']]):
        pulumi.set(self, "new_message_event_notification_config", value)

    @_builtins.property
    @pulumi.getter(name="newRecognitionResultNotificationConfig")
    def new_recognition_result_notification_config(self) -> Optional[pulumi.Input['ConversationProfileNewRecognitionResultNotificationConfigArgs']]:
        """
        Optional. Configuration for publishing transcription intermediate results. Event will be sent in format of ConversationEvent. If configured, the following information will be populated as ConversationEvent Pub/Sub message attributes: - "participant_id" - "participantRole" - "message_id"
        Structure is documented below.
        """
        return pulumi.get(self, "new_recognition_result_notification_config")

    @new_recognition_result_notification_config.setter
    def new_recognition_result_notification_config(self, value: Optional[pulumi.Input['ConversationProfileNewRecognitionResultNotificationConfigArgs']]):
        pulumi.set(self, "new_recognition_result_notification_config", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional[pulumi.Input['ConversationProfileNotificationConfigArgs']]:
        """
        Pub/Sub topic on which to publish new agent assistant events.
        Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
        Structure is documented below.
        """
        return pulumi.get(self, "notification_config")

    @notification_config.setter
    def notification_config(self, value: Optional[pulumi.Input['ConversationProfileNotificationConfigArgs']]):
        pulumi.set(self, "notification_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the CX SecuritySettings reference for the agent.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_settings", value)

    @_builtins.property
    @pulumi.getter(name="sttConfig")
    def stt_config(self) -> Optional[pulumi.Input['ConversationProfileSttConfigArgs']]:
        """
        Settings for speech transcription.
        Structure is documented below.
        """
        return pulumi.get(self, "stt_config")

    @stt_config.setter
    def stt_config(self, value: Optional[pulumi.Input['ConversationProfileSttConfigArgs']]):
        pulumi.set(self, "stt_config", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of this conversational profile.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="ttsConfig")
    def tts_config(self) -> Optional[pulumi.Input['ConversationProfileTtsConfigArgs']]:
        """
        Configuration for Text-to-Speech synthesization. If agent defines synthesization options as well, agent settings overrides the option here.
        Structure is documented below.
        """
        return pulumi.get(self, "tts_config")

    @tts_config.setter
    def tts_config(self, value: Optional[pulumi.Input['ConversationProfileTtsConfigArgs']]):
        pulumi.set(self, "tts_config", value)


@pulumi.type_token("gcp:diagflow/conversationProfile:ConversationProfile")
class ConversationProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automated_agent_config: Optional[pulumi.Input[Union['ConversationProfileAutomatedAgentConfigArgs', 'ConversationProfileAutomatedAgentConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 human_agent_assistant_config: Optional[pulumi.Input[Union['ConversationProfileHumanAgentAssistantConfigArgs', 'ConversationProfileHumanAgentAssistantConfigArgsDict']]] = None,
                 human_agent_handoff_config: Optional[pulumi.Input[Union['ConversationProfileHumanAgentHandoffConfigArgs', 'ConversationProfileHumanAgentHandoffConfigArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['ConversationProfileLoggingConfigArgs', 'ConversationProfileLoggingConfigArgsDict']]] = None,
                 new_message_event_notification_config: Optional[pulumi.Input[Union['ConversationProfileNewMessageEventNotificationConfigArgs', 'ConversationProfileNewMessageEventNotificationConfigArgsDict']]] = None,
                 new_recognition_result_notification_config: Optional[pulumi.Input[Union['ConversationProfileNewRecognitionResultNotificationConfigArgs', 'ConversationProfileNewRecognitionResultNotificationConfigArgsDict']]] = None,
                 notification_config: Optional[pulumi.Input[Union['ConversationProfileNotificationConfigArgs', 'ConversationProfileNotificationConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 stt_config: Optional[pulumi.Input[Union['ConversationProfileSttConfigArgs', 'ConversationProfileSttConfigArgsDict']]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 tts_config: Optional[pulumi.Input[Union['ConversationProfileTtsConfigArgs', 'ConversationProfileTtsConfigArgsDict']]] = None,
                 __props__=None):
        """
        A conversation profile configures a set of parameters that control the suggestions made to an agent. These parameters control the suggestions that are surfaced during runtime. Each profile configures either a Dialogflow virtual agent or a human agent for a conversation.

        To get more information about ConversationProfile, see:

        * [API documentation](https://cloud.google.com/dialogflow/docs/reference/rest/v2beta1/projects/conversationProfiles)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/docs/)

        ## Example Usage

        ### Dialogflow Conversation Profile Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_agent = gcp.diagflow.Agent("basic_agent",
            display_name="example_agent",
            default_language_code="en-us",
            time_zone="America/New_York")
        basic_profile = gcp.diagflow.ConversationProfile("basic_profile",
            display_name="dialogflow-profile",
            location="global",
            automated_agent_config={
                "agent": basic_agent.id.apply(lambda id: f"projects/{id}/locations/global/agent/environments/draft"),
            },
            human_agent_assistant_config={
                "message_analysis_config": {
                    "enable_entity_extraction": True,
                    "enable_sentiment_analysis": True,
                },
            })
        ```
        ### Dialogflow Conversation Profile Recognition Result Notification

        ```python
        import pulumi
        import pulumi_gcp as gcp

        recognition_result_notification_profile_topic = gcp.pubsub.Topic("recognition_result_notification_profile", name="recognition-result-notification")
        recognition_result_notification_profile = gcp.diagflow.ConversationProfile("recognition_result_notification_profile",
            display_name="dialogflow-profile",
            location="global",
            new_recognition_result_notification_config={
                "topic": recognition_result_notification_profile_topic.id,
                "message_format": "JSON",
            })
        ```

        ## Import

        ConversationProfile can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, ConversationProfile can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/conversationProfile:ConversationProfile default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConversationProfileAutomatedAgentConfigArgs', 'ConversationProfileAutomatedAgentConfigArgsDict']] automated_agent_config: Configuration for an automated agent to use with this profile
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Required. Human readable name for this profile. Max length 1024 bytes.
        :param pulumi.Input[Union['ConversationProfileHumanAgentAssistantConfigArgs', 'ConversationProfileHumanAgentAssistantConfigArgsDict']] human_agent_assistant_config: Configuration for connecting to a live agent
               Structure is documented below.
        :param pulumi.Input[Union['ConversationProfileHumanAgentHandoffConfigArgs', 'ConversationProfileHumanAgentHandoffConfigArgsDict']] human_agent_handoff_config: Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: Language code for the conversation profile. This should be a BCP-47 language tag.
        :param pulumi.Input[_builtins.str] location: desc
        :param pulumi.Input[Union['ConversationProfileLoggingConfigArgs', 'ConversationProfileLoggingConfigArgsDict']] logging_config: Defines logging behavior for conversation lifecycle events.
               Structure is documented below.
        :param pulumi.Input[Union['ConversationProfileNewMessageEventNotificationConfigArgs', 'ConversationProfileNewMessageEventNotificationConfigArgsDict']] new_message_event_notification_config: Pub/Sub topic on which to publish new agent assistant events.
               Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
               Structure is documented below.
        :param pulumi.Input[Union['ConversationProfileNewRecognitionResultNotificationConfigArgs', 'ConversationProfileNewRecognitionResultNotificationConfigArgsDict']] new_recognition_result_notification_config: Optional. Configuration for publishing transcription intermediate results. Event will be sent in format of ConversationEvent. If configured, the following information will be populated as ConversationEvent Pub/Sub message attributes: - "participant_id" - "participantRole" - "message_id"
               Structure is documented below.
        :param pulumi.Input[Union['ConversationProfileNotificationConfigArgs', 'ConversationProfileNotificationConfigArgsDict']] notification_config: Pub/Sub topic on which to publish new agent assistant events.
               Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] security_settings: Name of the CX SecuritySettings reference for the agent.
        :param pulumi.Input[Union['ConversationProfileSttConfigArgs', 'ConversationProfileSttConfigArgsDict']] stt_config: Settings for speech transcription.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of this conversational profile.
        :param pulumi.Input[Union['ConversationProfileTtsConfigArgs', 'ConversationProfileTtsConfigArgsDict']] tts_config: Configuration for Text-to-Speech synthesization. If agent defines synthesization options as well, agent settings overrides the option here.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConversationProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A conversation profile configures a set of parameters that control the suggestions made to an agent. These parameters control the suggestions that are surfaced during runtime. Each profile configures either a Dialogflow virtual agent or a human agent for a conversation.

        To get more information about ConversationProfile, see:

        * [API documentation](https://cloud.google.com/dialogflow/docs/reference/rest/v2beta1/projects/conversationProfiles)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/docs/)

        ## Example Usage

        ### Dialogflow Conversation Profile Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_agent = gcp.diagflow.Agent("basic_agent",
            display_name="example_agent",
            default_language_code="en-us",
            time_zone="America/New_York")
        basic_profile = gcp.diagflow.ConversationProfile("basic_profile",
            display_name="dialogflow-profile",
            location="global",
            automated_agent_config={
                "agent": basic_agent.id.apply(lambda id: f"projects/{id}/locations/global/agent/environments/draft"),
            },
            human_agent_assistant_config={
                "message_analysis_config": {
                    "enable_entity_extraction": True,
                    "enable_sentiment_analysis": True,
                },
            })
        ```
        ### Dialogflow Conversation Profile Recognition Result Notification

        ```python
        import pulumi
        import pulumi_gcp as gcp

        recognition_result_notification_profile_topic = gcp.pubsub.Topic("recognition_result_notification_profile", name="recognition-result-notification")
        recognition_result_notification_profile = gcp.diagflow.ConversationProfile("recognition_result_notification_profile",
            display_name="dialogflow-profile",
            location="global",
            new_recognition_result_notification_config={
                "topic": recognition_result_notification_profile_topic.id,
                "message_format": "JSON",
            })
        ```

        ## Import

        ConversationProfile can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, ConversationProfile can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/conversationProfile:ConversationProfile default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ConversationProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConversationProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automated_agent_config: Optional[pulumi.Input[Union['ConversationProfileAutomatedAgentConfigArgs', 'ConversationProfileAutomatedAgentConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 human_agent_assistant_config: Optional[pulumi.Input[Union['ConversationProfileHumanAgentAssistantConfigArgs', 'ConversationProfileHumanAgentAssistantConfigArgsDict']]] = None,
                 human_agent_handoff_config: Optional[pulumi.Input[Union['ConversationProfileHumanAgentHandoffConfigArgs', 'ConversationProfileHumanAgentHandoffConfigArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['ConversationProfileLoggingConfigArgs', 'ConversationProfileLoggingConfigArgsDict']]] = None,
                 new_message_event_notification_config: Optional[pulumi.Input[Union['ConversationProfileNewMessageEventNotificationConfigArgs', 'ConversationProfileNewMessageEventNotificationConfigArgsDict']]] = None,
                 new_recognition_result_notification_config: Optional[pulumi.Input[Union['ConversationProfileNewRecognitionResultNotificationConfigArgs', 'ConversationProfileNewRecognitionResultNotificationConfigArgsDict']]] = None,
                 notification_config: Optional[pulumi.Input[Union['ConversationProfileNotificationConfigArgs', 'ConversationProfileNotificationConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 stt_config: Optional[pulumi.Input[Union['ConversationProfileSttConfigArgs', 'ConversationProfileSttConfigArgsDict']]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 tts_config: Optional[pulumi.Input[Union['ConversationProfileTtsConfigArgs', 'ConversationProfileTtsConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConversationProfileArgs.__new__(ConversationProfileArgs)

            __props__.__dict__["automated_agent_config"] = automated_agent_config
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["human_agent_assistant_config"] = human_agent_assistant_config
            __props__.__dict__["human_agent_handoff_config"] = human_agent_handoff_config
            __props__.__dict__["language_code"] = language_code
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["new_message_event_notification_config"] = new_message_event_notification_config
            __props__.__dict__["new_recognition_result_notification_config"] = new_recognition_result_notification_config
            __props__.__dict__["notification_config"] = notification_config
            __props__.__dict__["project"] = project
            __props__.__dict__["security_settings"] = security_settings
            __props__.__dict__["stt_config"] = stt_config
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["tts_config"] = tts_config
            __props__.__dict__["name"] = None
        super(ConversationProfile, __self__).__init__(
            'gcp:diagflow/conversationProfile:ConversationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automated_agent_config: Optional[pulumi.Input[Union['ConversationProfileAutomatedAgentConfigArgs', 'ConversationProfileAutomatedAgentConfigArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            human_agent_assistant_config: Optional[pulumi.Input[Union['ConversationProfileHumanAgentAssistantConfigArgs', 'ConversationProfileHumanAgentAssistantConfigArgsDict']]] = None,
            human_agent_handoff_config: Optional[pulumi.Input[Union['ConversationProfileHumanAgentHandoffConfigArgs', 'ConversationProfileHumanAgentHandoffConfigArgsDict']]] = None,
            language_code: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logging_config: Optional[pulumi.Input[Union['ConversationProfileLoggingConfigArgs', 'ConversationProfileLoggingConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            new_message_event_notification_config: Optional[pulumi.Input[Union['ConversationProfileNewMessageEventNotificationConfigArgs', 'ConversationProfileNewMessageEventNotificationConfigArgsDict']]] = None,
            new_recognition_result_notification_config: Optional[pulumi.Input[Union['ConversationProfileNewRecognitionResultNotificationConfigArgs', 'ConversationProfileNewRecognitionResultNotificationConfigArgsDict']]] = None,
            notification_config: Optional[pulumi.Input[Union['ConversationProfileNotificationConfigArgs', 'ConversationProfileNotificationConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            security_settings: Optional[pulumi.Input[_builtins.str]] = None,
            stt_config: Optional[pulumi.Input[Union['ConversationProfileSttConfigArgs', 'ConversationProfileSttConfigArgsDict']]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            tts_config: Optional[pulumi.Input[Union['ConversationProfileTtsConfigArgs', 'ConversationProfileTtsConfigArgsDict']]] = None) -> 'ConversationProfile':
        """
        Get an existing ConversationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConversationProfileAutomatedAgentConfigArgs', 'ConversationProfileAutomatedAgentConfigArgsDict']] automated_agent_config: Configuration for an automated agent to use with this profile
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Required. Human readable name for this profile. Max length 1024 bytes.
        :param pulumi.Input[Union['ConversationProfileHumanAgentAssistantConfigArgs', 'ConversationProfileHumanAgentAssistantConfigArgsDict']] human_agent_assistant_config: Configuration for connecting to a live agent
               Structure is documented below.
        :param pulumi.Input[Union['ConversationProfileHumanAgentHandoffConfigArgs', 'ConversationProfileHumanAgentHandoffConfigArgsDict']] human_agent_handoff_config: Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: Language code for the conversation profile. This should be a BCP-47 language tag.
        :param pulumi.Input[_builtins.str] location: desc
        :param pulumi.Input[Union['ConversationProfileLoggingConfigArgs', 'ConversationProfileLoggingConfigArgsDict']] logging_config: Defines logging behavior for conversation lifecycle events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: name
        :param pulumi.Input[Union['ConversationProfileNewMessageEventNotificationConfigArgs', 'ConversationProfileNewMessageEventNotificationConfigArgsDict']] new_message_event_notification_config: Pub/Sub topic on which to publish new agent assistant events.
               Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
               Structure is documented below.
        :param pulumi.Input[Union['ConversationProfileNewRecognitionResultNotificationConfigArgs', 'ConversationProfileNewRecognitionResultNotificationConfigArgsDict']] new_recognition_result_notification_config: Optional. Configuration for publishing transcription intermediate results. Event will be sent in format of ConversationEvent. If configured, the following information will be populated as ConversationEvent Pub/Sub message attributes: - "participant_id" - "participantRole" - "message_id"
               Structure is documented below.
        :param pulumi.Input[Union['ConversationProfileNotificationConfigArgs', 'ConversationProfileNotificationConfigArgsDict']] notification_config: Pub/Sub topic on which to publish new agent assistant events.
               Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] security_settings: Name of the CX SecuritySettings reference for the agent.
        :param pulumi.Input[Union['ConversationProfileSttConfigArgs', 'ConversationProfileSttConfigArgsDict']] stt_config: Settings for speech transcription.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of this conversational profile.
        :param pulumi.Input[Union['ConversationProfileTtsConfigArgs', 'ConversationProfileTtsConfigArgsDict']] tts_config: Configuration for Text-to-Speech synthesization. If agent defines synthesization options as well, agent settings overrides the option here.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConversationProfileState.__new__(_ConversationProfileState)

        __props__.__dict__["automated_agent_config"] = automated_agent_config
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["human_agent_assistant_config"] = human_agent_assistant_config
        __props__.__dict__["human_agent_handoff_config"] = human_agent_handoff_config
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["location"] = location
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["name"] = name
        __props__.__dict__["new_message_event_notification_config"] = new_message_event_notification_config
        __props__.__dict__["new_recognition_result_notification_config"] = new_recognition_result_notification_config
        __props__.__dict__["notification_config"] = notification_config
        __props__.__dict__["project"] = project
        __props__.__dict__["security_settings"] = security_settings
        __props__.__dict__["stt_config"] = stt_config
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["tts_config"] = tts_config
        return ConversationProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automatedAgentConfig")
    def automated_agent_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileAutomatedAgentConfig']]:
        """
        Configuration for an automated agent to use with this profile
        Structure is documented below.
        """
        return pulumi.get(self, "automated_agent_config")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Required. Human readable name for this profile. Max length 1024 bytes.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="humanAgentAssistantConfig")
    def human_agent_assistant_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileHumanAgentAssistantConfig']]:
        """
        Configuration for connecting to a live agent
        Structure is documented below.
        """
        return pulumi.get(self, "human_agent_assistant_config")

    @_builtins.property
    @pulumi.getter(name="humanAgentHandoffConfig")
    def human_agent_handoff_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileHumanAgentHandoffConfig']]:
        """
        Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation.
        Structure is documented below.
        """
        return pulumi.get(self, "human_agent_handoff_config")

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[_builtins.str]:
        """
        Language code for the conversation profile. This should be a BCP-47 language tag.
        """
        return pulumi.get(self, "language_code")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        desc
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileLoggingConfig']]:
        """
        Defines logging behavior for conversation lifecycle events.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newMessageEventNotificationConfig")
    def new_message_event_notification_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileNewMessageEventNotificationConfig']]:
        """
        Pub/Sub topic on which to publish new agent assistant events.
        Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
        Structure is documented below.
        """
        return pulumi.get(self, "new_message_event_notification_config")

    @_builtins.property
    @pulumi.getter(name="newRecognitionResultNotificationConfig")
    def new_recognition_result_notification_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileNewRecognitionResultNotificationConfig']]:
        """
        Optional. Configuration for publishing transcription intermediate results. Event will be sent in format of ConversationEvent. If configured, the following information will be populated as ConversationEvent Pub/Sub message attributes: - "participant_id" - "participantRole" - "message_id"
        Structure is documented below.
        """
        return pulumi.get(self, "new_recognition_result_notification_config")

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileNotificationConfig']]:
        """
        Pub/Sub topic on which to publish new agent assistant events.
        Expects the format "projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>"
        Structure is documented below.
        """
        return pulumi.get(self, "notification_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the CX SecuritySettings reference for the agent.
        """
        return pulumi.get(self, "security_settings")

    @_builtins.property
    @pulumi.getter(name="sttConfig")
    def stt_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileSttConfig']]:
        """
        Settings for speech transcription.
        Structure is documented below.
        """
        return pulumi.get(self, "stt_config")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time zone of this conversational profile.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="ttsConfig")
    def tts_config(self) -> pulumi.Output[Optional['outputs.ConversationProfileTtsConfig']]:
        """
        Configuration for Text-to-Speech synthesization. If agent defines synthesization options as well, agent settings overrides the option here.
        Structure is documented below.
        """
        return pulumi.get(self, "tts_config")

