# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxPageArgs', 'CxPage']

@pulumi.input_type
class CxPageArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 advanced_settings: Optional[pulumi.Input['CxPageAdvancedSettingsArgs']] = None,
                 entry_fulfillment: Optional[pulumi.Input['CxPageEntryFulfillmentArgs']] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input['CxPageEventHandlerArgs']]]] = None,
                 form: Optional[pulumi.Input['CxPageFormArgs']] = None,
                 knowledge_connector_settings: Optional[pulumi.Input['CxPageKnowledgeConnectorSettingsArgs']] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CxPageTransitionRouteArgs']]]] = None):
        """
        The set of arguments for constructing a CxPage resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the page, unique within the agent.
        :param pulumi.Input['CxPageAdvancedSettingsArgs'] advanced_settings: Hierarchical advanced settings for this page. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input['CxPageEntryFulfillmentArgs'] entry_fulfillment: The fulfillment to call when the session is entering the page.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['CxPageEventHandlerArgs']]] event_handlers: Handlers associated with the page to handle events such as webhook errors, no match or no input.
               Structure is documented below.
        :param pulumi.Input['CxPageFormArgs'] form: The form associated with the page, used for collecting parameters relevant to the page.
               Structure is documented below.
        :param pulumi.Input['CxPageKnowledgeConnectorSettingsArgs'] knowledge_connector_settings: Knowledge connector configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: The language of the following fields in page:
               Page.entry_fulfillment.messages
               Page.entry_fulfillment.conditional_cases
               Page.event_handlers.trigger_fulfillment.messages
               Page.event_handlers.trigger_fulfillment.conditional_cases
               Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
               Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
               Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
               Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
               Page.transition_routes.trigger_fulfillment.messages
               Page.transition_routes.trigger_fulfillment.conditional_cases
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[_builtins.str] parent: The flow to create a page for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] transition_route_groups: Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
               If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route > page's transition route group > flow's transition routes.
               If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
               Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        :param pulumi.Input[Sequence[pulumi.Input['CxPageTransitionRouteArgs']]] transition_routes: A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow.
               When we are in a certain page, the TransitionRoutes are evalauted in the following order:
               TransitionRoutes defined in the page with intent specified.
               TransitionRoutes defined in the transition route groups with intent specified.
               TransitionRoutes defined in flow with intent specified.
               TransitionRoutes defined in the transition route groups with intent specified.
               TransitionRoutes defined in the page with only condition specified.
               TransitionRoutes defined in the transition route groups with only condition specified.
               Structure is documented below.
        """
        pulumi.set(__self__, "display_name", display_name)
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if entry_fulfillment is not None:
            pulumi.set(__self__, "entry_fulfillment", entry_fulfillment)
        if event_handlers is not None:
            pulumi.set(__self__, "event_handlers", event_handlers)
        if form is not None:
            pulumi.set(__self__, "form", form)
        if knowledge_connector_settings is not None:
            pulumi.set(__self__, "knowledge_connector_settings", knowledge_connector_settings)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if transition_route_groups is not None:
            pulumi.set(__self__, "transition_route_groups", transition_route_groups)
        if transition_routes is not None:
            pulumi.set(__self__, "transition_routes", transition_routes)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The human-readable name of the page, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input['CxPageAdvancedSettingsArgs']]:
        """
        Hierarchical advanced settings for this page. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input['CxPageAdvancedSettingsArgs']]):
        pulumi.set(self, "advanced_settings", value)

    @_builtins.property
    @pulumi.getter(name="entryFulfillment")
    def entry_fulfillment(self) -> Optional[pulumi.Input['CxPageEntryFulfillmentArgs']]:
        """
        The fulfillment to call when the session is entering the page.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_fulfillment")

    @entry_fulfillment.setter
    def entry_fulfillment(self, value: Optional[pulumi.Input['CxPageEntryFulfillmentArgs']]):
        pulumi.set(self, "entry_fulfillment", value)

    @_builtins.property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxPageEventHandlerArgs']]]]:
        """
        Handlers associated with the page to handle events such as webhook errors, no match or no input.
        Structure is documented below.
        """
        return pulumi.get(self, "event_handlers")

    @event_handlers.setter
    def event_handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxPageEventHandlerArgs']]]]):
        pulumi.set(self, "event_handlers", value)

    @_builtins.property
    @pulumi.getter
    def form(self) -> Optional[pulumi.Input['CxPageFormArgs']]:
        """
        The form associated with the page, used for collecting parameters relevant to the page.
        Structure is documented below.
        """
        return pulumi.get(self, "form")

    @form.setter
    def form(self, value: Optional[pulumi.Input['CxPageFormArgs']]):
        pulumi.set(self, "form", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeConnectorSettings")
    def knowledge_connector_settings(self) -> Optional[pulumi.Input['CxPageKnowledgeConnectorSettingsArgs']]:
        """
        Knowledge connector configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "knowledge_connector_settings")

    @knowledge_connector_settings.setter
    def knowledge_connector_settings(self, value: Optional[pulumi.Input['CxPageKnowledgeConnectorSettingsArgs']]):
        pulumi.set(self, "knowledge_connector_settings", value)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the following fields in page:
        Page.entry_fulfillment.messages
        Page.entry_fulfillment.conditional_cases
        Page.event_handlers.trigger_fulfillment.messages
        Page.event_handlers.trigger_fulfillment.conditional_cases
        Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
        Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
        Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
        Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
        Page.transition_routes.trigger_fulfillment.messages
        Page.transition_routes.trigger_fulfillment.conditional_cases
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_code", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flow to create a page for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
        If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route > page's transition route group > flow's transition routes.
        If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
        Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        """
        return pulumi.get(self, "transition_route_groups")

    @transition_route_groups.setter
    def transition_route_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "transition_route_groups", value)

    @_builtins.property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxPageTransitionRouteArgs']]]]:
        """
        A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow.
        When we are in a certain page, the TransitionRoutes are evalauted in the following order:
        TransitionRoutes defined in the page with intent specified.
        TransitionRoutes defined in the transition route groups with intent specified.
        TransitionRoutes defined in flow with intent specified.
        TransitionRoutes defined in the transition route groups with intent specified.
        TransitionRoutes defined in the page with only condition specified.
        TransitionRoutes defined in the transition route groups with only condition specified.
        Structure is documented below.
        """
        return pulumi.get(self, "transition_routes")

    @transition_routes.setter
    def transition_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxPageTransitionRouteArgs']]]]):
        pulumi.set(self, "transition_routes", value)


@pulumi.input_type
class _CxPageState:
    def __init__(__self__, *,
                 advanced_settings: Optional[pulumi.Input['CxPageAdvancedSettingsArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_fulfillment: Optional[pulumi.Input['CxPageEntryFulfillmentArgs']] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input['CxPageEventHandlerArgs']]]] = None,
                 form: Optional[pulumi.Input['CxPageFormArgs']] = None,
                 knowledge_connector_settings: Optional[pulumi.Input['CxPageKnowledgeConnectorSettingsArgs']] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CxPageTransitionRouteArgs']]]] = None):
        """
        Input properties used for looking up and filtering CxPage resources.
        :param pulumi.Input['CxPageAdvancedSettingsArgs'] advanced_settings: Hierarchical advanced settings for this page. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the page, unique within the agent.
        :param pulumi.Input['CxPageEntryFulfillmentArgs'] entry_fulfillment: The fulfillment to call when the session is entering the page.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['CxPageEventHandlerArgs']]] event_handlers: Handlers associated with the page to handle events such as webhook errors, no match or no input.
               Structure is documented below.
        :param pulumi.Input['CxPageFormArgs'] form: The form associated with the page, used for collecting parameters relevant to the page.
               Structure is documented below.
        :param pulumi.Input['CxPageKnowledgeConnectorSettingsArgs'] knowledge_connector_settings: Knowledge connector configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: The language of the following fields in page:
               Page.entry_fulfillment.messages
               Page.entry_fulfillment.conditional_cases
               Page.event_handlers.trigger_fulfillment.messages
               Page.event_handlers.trigger_fulfillment.conditional_cases
               Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
               Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
               Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
               Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
               Page.transition_routes.trigger_fulfillment.messages
               Page.transition_routes.trigger_fulfillment.conditional_cases
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the page.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
        :param pulumi.Input[_builtins.str] parent: The flow to create a page for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] transition_route_groups: Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
               If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route > page's transition route group > flow's transition routes.
               If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
               Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        :param pulumi.Input[Sequence[pulumi.Input['CxPageTransitionRouteArgs']]] transition_routes: A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow.
               When we are in a certain page, the TransitionRoutes are evalauted in the following order:
               TransitionRoutes defined in the page with intent specified.
               TransitionRoutes defined in the transition route groups with intent specified.
               TransitionRoutes defined in flow with intent specified.
               TransitionRoutes defined in the transition route groups with intent specified.
               TransitionRoutes defined in the page with only condition specified.
               TransitionRoutes defined in the transition route groups with only condition specified.
               Structure is documented below.
        """
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if entry_fulfillment is not None:
            pulumi.set(__self__, "entry_fulfillment", entry_fulfillment)
        if event_handlers is not None:
            pulumi.set(__self__, "event_handlers", event_handlers)
        if form is not None:
            pulumi.set(__self__, "form", form)
        if knowledge_connector_settings is not None:
            pulumi.set(__self__, "knowledge_connector_settings", knowledge_connector_settings)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if transition_route_groups is not None:
            pulumi.set(__self__, "transition_route_groups", transition_route_groups)
        if transition_routes is not None:
            pulumi.set(__self__, "transition_routes", transition_routes)

    @_builtins.property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input['CxPageAdvancedSettingsArgs']]:
        """
        Hierarchical advanced settings for this page. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input['CxPageAdvancedSettingsArgs']]):
        pulumi.set(self, "advanced_settings", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of the page, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="entryFulfillment")
    def entry_fulfillment(self) -> Optional[pulumi.Input['CxPageEntryFulfillmentArgs']]:
        """
        The fulfillment to call when the session is entering the page.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_fulfillment")

    @entry_fulfillment.setter
    def entry_fulfillment(self, value: Optional[pulumi.Input['CxPageEntryFulfillmentArgs']]):
        pulumi.set(self, "entry_fulfillment", value)

    @_builtins.property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxPageEventHandlerArgs']]]]:
        """
        Handlers associated with the page to handle events such as webhook errors, no match or no input.
        Structure is documented below.
        """
        return pulumi.get(self, "event_handlers")

    @event_handlers.setter
    def event_handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxPageEventHandlerArgs']]]]):
        pulumi.set(self, "event_handlers", value)

    @_builtins.property
    @pulumi.getter
    def form(self) -> Optional[pulumi.Input['CxPageFormArgs']]:
        """
        The form associated with the page, used for collecting parameters relevant to the page.
        Structure is documented below.
        """
        return pulumi.get(self, "form")

    @form.setter
    def form(self, value: Optional[pulumi.Input['CxPageFormArgs']]):
        pulumi.set(self, "form", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeConnectorSettings")
    def knowledge_connector_settings(self) -> Optional[pulumi.Input['CxPageKnowledgeConnectorSettingsArgs']]:
        """
        Knowledge connector configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "knowledge_connector_settings")

    @knowledge_connector_settings.setter
    def knowledge_connector_settings(self, value: Optional[pulumi.Input['CxPageKnowledgeConnectorSettingsArgs']]):
        pulumi.set(self, "knowledge_connector_settings", value)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the following fields in page:
        Page.entry_fulfillment.messages
        Page.entry_fulfillment.conditional_cases
        Page.event_handlers.trigger_fulfillment.messages
        Page.event_handlers.trigger_fulfillment.conditional_cases
        Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
        Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
        Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
        Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
        Page.transition_routes.trigger_fulfillment.messages
        Page.transition_routes.trigger_fulfillment.conditional_cases
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_code", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the page.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flow to create a page for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
        If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route > page's transition route group > flow's transition routes.
        If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
        Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        """
        return pulumi.get(self, "transition_route_groups")

    @transition_route_groups.setter
    def transition_route_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "transition_route_groups", value)

    @_builtins.property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxPageTransitionRouteArgs']]]]:
        """
        A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow.
        When we are in a certain page, the TransitionRoutes are evalauted in the following order:
        TransitionRoutes defined in the page with intent specified.
        TransitionRoutes defined in the transition route groups with intent specified.
        TransitionRoutes defined in flow with intent specified.
        TransitionRoutes defined in the transition route groups with intent specified.
        TransitionRoutes defined in the page with only condition specified.
        TransitionRoutes defined in the transition route groups with only condition specified.
        Structure is documented below.
        """
        return pulumi.get(self, "transition_routes")

    @transition_routes.setter
    def transition_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxPageTransitionRouteArgs']]]]):
        pulumi.set(self, "transition_routes", value)


@pulumi.type_token("gcp:diagflow/cxPage:CxPage")
class CxPage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_settings: Optional[pulumi.Input[Union['CxPageAdvancedSettingsArgs', 'CxPageAdvancedSettingsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_fulfillment: Optional[pulumi.Input[Union['CxPageEntryFulfillmentArgs', 'CxPageEntryFulfillmentArgsDict']]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxPageEventHandlerArgs', 'CxPageEventHandlerArgsDict']]]]] = None,
                 form: Optional[pulumi.Input[Union['CxPageFormArgs', 'CxPageFormArgsDict']]] = None,
                 knowledge_connector_settings: Optional[pulumi.Input[Union['CxPageKnowledgeConnectorSettingsArgs', 'CxPageKnowledgeConnectorSettingsArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxPageTransitionRouteArgs', 'CxPageTransitionRouteArgsDict']]]]] = None,
                 __props__=None):
        """
        A Dialogflow CX conversation (session) can be described and visualized as a state machine. The states of a CX session are represented by pages.

        To get more information about Page, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.flows.pages)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Page Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        my_page2 = gcp.diagflow.CxPage("my_page2",
            parent=agent.start_flow,
            display_name="MyPage2")
        my_webhook = gcp.diagflow.CxWebhook("my_webhook",
            parent=agent.id,
            display_name="MyWebhook",
            generic_web_service={
                "uri": "https://example.com",
            })
        project = gcp.organizations.get_project()
        basic_page = gcp.diagflow.CxPage("basic_page",
            parent=agent.start_flow,
            display_name="MyPage",
            entry_fulfillment={
                "messages": [
                    {
                        "channel": "some-channel",
                        "text": {
                            "texts": ["Welcome to page"],
                        },
                    },
                    {
                        "payload": "        {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                    },
                    {
                        "conversation_success": {
                            "metadata": "          {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                        },
                    },
                    {
                        "output_audio_text": {
                            "text": "some output text",
                        },
                    },
                    {
                        "output_audio_text": {
                            "ssml": "          <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                        },
                    },
                    {
                        "live_agent_handoff": {
                            "metadata": "          {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                        },
                    },
                    {
                        "play_audio": {
                            "audio_uri": "http://example.com/some-audio-file.mp3",
                        },
                    },
                    {
                        "telephony_transfer_call": {
                            "phone_number": "1-234-567-8901",
                        },
                    },
                ],
                "set_parameter_actions": [
                    {
                        "parameter": "some-param",
                        "value": "123.45",
                    },
                    {
                        "parameter": "another-param",
                        "value": json.dumps("abc"),
                    },
                    {
                        "parameter": "other-param",
                        "value": json.dumps(["foo"]),
                    },
                ],
                "conditional_cases": [{
                    "cases": json.dumps([
                        {
                            "condition": "$sys.func.RAND() < 0.5",
                            "caseContent": [
                                {
                                    "message": {
                                        "text": {
                                            "text": ["First case"],
                                        },
                                    },
                                },
                                {
                                    "additionalCases": {
                                        "cases": [{
                                            "condition": "$sys.func.RAND() < 0.2",
                                            "caseContent": [{
                                                "message": {
                                                    "text": {
                                                        "text": ["Nested case"],
                                                    },
                                                },
                                            }],
                                        }],
                                    },
                                },
                            ],
                        },
                        {
                            "caseContent": [{
                                "message": {
                                    "text": {
                                        "text": ["Final case"],
                                    },
                                },
                            }],
                        },
                    ]),
                }],
            },
            event_handlers=[{
                "event": "some-event",
                "trigger_fulfillment": {
                    "return_partial_responses": True,
                    "messages": [
                        {
                            "channel": "some-channel",
                            "text": {
                                "texts": ["Some text"],
                            },
                        },
                        {
                            "payload": "          {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                        },
                        {
                            "conversation_success": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "output_audio_text": {
                                "text": "some output text",
                            },
                        },
                        {
                            "output_audio_text": {
                                "ssml": "            <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                            },
                        },
                        {
                            "live_agent_handoff": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "play_audio": {
                                "audio_uri": "http://example.com/some-audio-file.mp3",
                            },
                        },
                        {
                            "telephony_transfer_call": {
                                "phone_number": "1-234-567-8901",
                            },
                        },
                    ],
                    "set_parameter_actions": [
                        {
                            "parameter": "some-param",
                            "value": "123.45",
                        },
                        {
                            "parameter": "another-param",
                            "value": json.dumps("abc"),
                        },
                        {
                            "parameter": "other-param",
                            "value": json.dumps(["foo"]),
                        },
                    ],
                    "conditional_cases": [{
                        "cases": json.dumps([
                            {
                                "condition": "$sys.func.RAND() < 0.5",
                                "caseContent": [
                                    {
                                        "message": {
                                            "text": {
                                                "text": ["First case"],
                                            },
                                        },
                                    },
                                    {
                                        "additionalCases": {
                                            "cases": [{
                                                "condition": "$sys.func.RAND() < 0.2",
                                                "caseContent": [{
                                                    "message": {
                                                        "text": {
                                                            "text": ["Nested case"],
                                                        },
                                                    },
                                                }],
                                            }],
                                        },
                                    },
                                ],
                            },
                            {
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["Final case"],
                                        },
                                    },
                                }],
                            },
                        ]),
                    }],
                },
            }],
            form={
                "parameters": [{
                    "display_name": "param1",
                    "entity_type": "projects/-/locations/-/agents/-/entityTypes/sys.date",
                    "default_value": json.dumps("2000-01-01"),
                    "fill_behavior": {
                        "initial_prompt_fulfillment": {
                            "messages": [
                                {
                                    "channel": "some-channel",
                                    "text": {
                                        "texts": ["Please provide param1"],
                                    },
                                },
                                {
                                    "payload": "              {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                                },
                                {
                                    "conversation_success": {
                                        "metadata": "                {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                                    },
                                },
                                {
                                    "output_audio_text": {
                                        "text": "some output text",
                                    },
                                },
                                {
                                    "output_audio_text": {
                                        "ssml": "                <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                                    },
                                },
                                {
                                    "live_agent_handoff": {
                                        "metadata": "                {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                                    },
                                },
                                {
                                    "play_audio": {
                                        "audio_uri": "http://example.com/some-audio-file.mp3",
                                    },
                                },
                                {
                                    "telephony_transfer_call": {
                                        "phone_number": "1-234-567-8901",
                                    },
                                },
                            ],
                            "set_parameter_actions": [
                                {
                                    "parameter": "some-param",
                                    "value": "123.45",
                                },
                                {
                                    "parameter": "another-param",
                                    "value": json.dumps("abc"),
                                },
                                {
                                    "parameter": "other-param",
                                    "value": json.dumps(["foo"]),
                                },
                            ],
                            "conditional_cases": [{
                                "cases": json.dumps([
                                    {
                                        "condition": "$sys.func.RAND() < 0.5",
                                        "caseContent": [
                                            {
                                                "message": {
                                                    "text": {
                                                        "text": ["First case"],
                                                    },
                                                },
                                            },
                                            {
                                                "additionalCases": {
                                                    "cases": [{
                                                        "condition": "$sys.func.RAND() < 0.2",
                                                        "caseContent": [{
                                                            "message": {
                                                                "text": {
                                                                    "text": ["Nested case"],
                                                                },
                                                            },
                                                        }],
                                                    }],
                                                },
                                            },
                                        ],
                                    },
                                    {
                                        "caseContent": [{
                                            "message": {
                                                "text": {
                                                    "text": ["Final case"],
                                                },
                                            },
                                        }],
                                    },
                                ]),
                            }],
                        },
                        "reprompt_event_handlers": [
                            {
                                "event": "sys.no-match-1",
                                "trigger_fulfillment": {
                                    "return_partial_responses": True,
                                    "webhook": my_webhook.id,
                                    "tag": "some-tag",
                                    "messages": [
                                        {
                                            "channel": "some-channel",
                                            "text": {
                                                "texts": ["Please provide param1"],
                                            },
                                        },
                                        {
                                            "payload": "                {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                                        },
                                        {
                                            "conversation_success": {
                                                "metadata": "                  {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                                            },
                                        },
                                        {
                                            "output_audio_text": {
                                                "text": "some output text",
                                            },
                                        },
                                        {
                                            "output_audio_text": {
                                                "ssml": "                  <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                                            },
                                        },
                                        {
                                            "live_agent_handoff": {
                                                "metadata": "                  {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                                            },
                                        },
                                        {
                                            "play_audio": {
                                                "audio_uri": "http://example.com/some-audio-file.mp3",
                                            },
                                        },
                                        {
                                            "telephony_transfer_call": {
                                                "phone_number": "1-234-567-8901",
                                            },
                                        },
                                    ],
                                    "set_parameter_actions": [
                                        {
                                            "parameter": "some-param",
                                            "value": "123.45",
                                        },
                                        {
                                            "parameter": "another-param",
                                            "value": json.dumps("abc"),
                                        },
                                        {
                                            "parameter": "other-param",
                                            "value": json.dumps(["foo"]),
                                        },
                                    ],
                                    "conditional_cases": [{
                                        "cases": json.dumps([
                                            {
                                                "condition": "$sys.func.RAND() < 0.5",
                                                "caseContent": [
                                                    {
                                                        "message": {
                                                            "text": {
                                                                "text": ["First case"],
                                                            },
                                                        },
                                                    },
                                                    {
                                                        "additionalCases": {
                                                            "cases": [{
                                                                "condition": "$sys.func.RAND() < 0.2",
                                                                "caseContent": [{
                                                                    "message": {
                                                                        "text": {
                                                                            "text": ["Nested case"],
                                                                        },
                                                                    },
                                                                }],
                                                            }],
                                                        },
                                                    },
                                                ],
                                            },
                                            {
                                                "caseContent": [{
                                                    "message": {
                                                        "text": {
                                                            "text": ["Final case"],
                                                        },
                                                    },
                                                }],
                                            },
                                        ]),
                                    }],
                                },
                            },
                            {
                                "event": "sys.no-match-2",
                                "target_flow": agent.start_flow,
                            },
                            {
                                "event": "sys.no-match-3",
                                "target_page": my_page2.id,
                            },
                        ],
                    },
                    "required": True,
                    "redact": True,
                    "advanced_settings": {
                        "dtmf_settings": {
                            "enabled": True,
                            "max_digits": 1,
                            "finish_digit": "#",
                        },
                    },
                }],
            },
            transition_routes=[{
                "condition": "$page.params.status = 'FINAL'",
                "trigger_fulfillment": {
                    "messages": [
                        {
                            "channel": "some-channel",
                            "text": {
                                "texts": ["information completed, navigating to page 2"],
                            },
                        },
                        {
                            "payload": "          {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                        },
                        {
                            "conversation_success": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "output_audio_text": {
                                "text": "some output text",
                            },
                        },
                        {
                            "output_audio_text": {
                                "ssml": "            <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                            },
                        },
                        {
                            "live_agent_handoff": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "play_audio": {
                                "audio_uri": "http://example.com/some-audio-file.mp3",
                            },
                        },
                        {
                            "telephony_transfer_call": {
                                "phone_number": "1-234-567-8901",
                            },
                        },
                    ],
                    "set_parameter_actions": [
                        {
                            "parameter": "some-param",
                            "value": "123.45",
                        },
                        {
                            "parameter": "another-param",
                            "value": json.dumps("abc"),
                        },
                        {
                            "parameter": "other-param",
                            "value": json.dumps(["foo"]),
                        },
                    ],
                    "conditional_cases": [{
                        "cases": json.dumps([
                            {
                                "condition": "$sys.func.RAND() < 0.5",
                                "caseContent": [
                                    {
                                        "message": {
                                            "text": {
                                                "text": ["First case"],
                                            },
                                        },
                                    },
                                    {
                                        "additionalCases": {
                                            "cases": [{
                                                "condition": "$sys.func.RAND() < 0.2",
                                                "caseContent": [{
                                                    "message": {
                                                        "text": {
                                                            "text": ["Nested case"],
                                                        },
                                                    },
                                                }],
                                            }],
                                        },
                                    },
                                ],
                            },
                            {
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["Final case"],
                                        },
                                    },
                                }],
                            },
                        ]),
                    }],
                },
                "target_page": my_page2.id,
            }],
            advanced_settings={
                "dtmf_settings": {
                    "enabled": True,
                    "max_digits": 1,
                    "finish_digit": "#",
                },
            },
            knowledge_connector_settings={
                "enabled": True,
                "trigger_fulfillment": {
                    "messages": [
                        {
                            "channel": "some-channel",
                            "knowledge_info_card": {},
                        },
                        {
                            "channel": "some-channel",
                            "text": {
                                "texts": ["information completed, navigating to page 2"],
                            },
                        },
                        {
                            "payload": "          {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                        },
                        {
                            "conversation_success": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "output_audio_text": {
                                "text": "some output text",
                            },
                        },
                        {
                            "output_audio_text": {
                                "ssml": "            <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                            },
                        },
                        {
                            "live_agent_handoff": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "play_audio": {
                                "audio_uri": "http://example.com/some-audio-file.mp3",
                            },
                        },
                        {
                            "telephony_transfer_call": {
                                "phone_number": "1-234-567-8902",
                            },
                        },
                    ],
                    "webhook": my_webhook.id,
                    "return_partial_responses": True,
                    "tag": "some-tag",
                    "set_parameter_actions": [{
                        "parameter": "some-param",
                        "value": "123.45",
                    }],
                    "conditional_cases": [{
                        "cases": json.dumps([
                            {
                                "condition": "$sys.func.RAND() < 0.5",
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["First case"],
                                        },
                                    },
                                }],
                            },
                            {
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["Final case"],
                                        },
                                    },
                                }],
                            },
                        ]),
                    }],
                    "advanced_settings": {
                        "speech_settings": {
                            "endpointer_sensitivity": 30,
                            "no_speech_timeout": "3.500s",
                            "use_timeout_based_endpointing": True,
                            "models": {
                                "name": "wrench",
                                "mass": "1.3kg",
                                "count": "3",
                            },
                        },
                        "dtmf_settings": {
                            "enabled": True,
                            "max_digits": 1,
                            "finish_digit": "#",
                            "interdigit_timeout_duration": "3.500s",
                            "endpointing_timeout_duration": "3.500s",
                        },
                        "logging_settings": {
                            "enable_stackdriver_logging": True,
                            "enable_interaction_logging": True,
                            "enable_consent_based_redaction": True,
                        },
                    },
                    "enable_generative_fallback": True,
                },
                "data_store_connections": [{
                    "data_store_type": "PUBLIC_WEB",
                    "data_store": agent.location.apply(lambda location: f"projects/{project.number}/locations/{location}/collections/default_collection/dataStores/datastore-page-full"),
                    "document_processing_mode": "CHUNKS",
                }],
                "target_page": my_page2.id,
            })
        my_datastore = gcp.discoveryengine.DataStore("my_datastore",
            location="global",
            data_store_id="datastore-page-full",
            display_name="datastore-page-full",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT")
        ```

        ## Import

        Page can be imported using any of these accepted formats:

        * `{{parent}}/pages/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Page can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxPage:CxPage default {{parent}}/pages/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxPage:CxPage default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxPageAdvancedSettingsArgs', 'CxPageAdvancedSettingsArgsDict']] advanced_settings: Hierarchical advanced settings for this page. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the page, unique within the agent.
        :param pulumi.Input[Union['CxPageEntryFulfillmentArgs', 'CxPageEntryFulfillmentArgsDict']] entry_fulfillment: The fulfillment to call when the session is entering the page.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxPageEventHandlerArgs', 'CxPageEventHandlerArgsDict']]]] event_handlers: Handlers associated with the page to handle events such as webhook errors, no match or no input.
               Structure is documented below.
        :param pulumi.Input[Union['CxPageFormArgs', 'CxPageFormArgsDict']] form: The form associated with the page, used for collecting parameters relevant to the page.
               Structure is documented below.
        :param pulumi.Input[Union['CxPageKnowledgeConnectorSettingsArgs', 'CxPageKnowledgeConnectorSettingsArgsDict']] knowledge_connector_settings: Knowledge connector configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: The language of the following fields in page:
               Page.entry_fulfillment.messages
               Page.entry_fulfillment.conditional_cases
               Page.event_handlers.trigger_fulfillment.messages
               Page.event_handlers.trigger_fulfillment.conditional_cases
               Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
               Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
               Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
               Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
               Page.transition_routes.trigger_fulfillment.messages
               Page.transition_routes.trigger_fulfillment.conditional_cases
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[_builtins.str] parent: The flow to create a page for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] transition_route_groups: Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
               If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route > page's transition route group > flow's transition routes.
               If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
               Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxPageTransitionRouteArgs', 'CxPageTransitionRouteArgsDict']]]] transition_routes: A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow.
               When we are in a certain page, the TransitionRoutes are evalauted in the following order:
               TransitionRoutes defined in the page with intent specified.
               TransitionRoutes defined in the transition route groups with intent specified.
               TransitionRoutes defined in flow with intent specified.
               TransitionRoutes defined in the transition route groups with intent specified.
               TransitionRoutes defined in the page with only condition specified.
               TransitionRoutes defined in the transition route groups with only condition specified.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxPageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Dialogflow CX conversation (session) can be described and visualized as a state machine. The states of a CX session are represented by pages.

        To get more information about Page, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.flows.pages)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Page Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        my_page2 = gcp.diagflow.CxPage("my_page2",
            parent=agent.start_flow,
            display_name="MyPage2")
        my_webhook = gcp.diagflow.CxWebhook("my_webhook",
            parent=agent.id,
            display_name="MyWebhook",
            generic_web_service={
                "uri": "https://example.com",
            })
        project = gcp.organizations.get_project()
        basic_page = gcp.diagflow.CxPage("basic_page",
            parent=agent.start_flow,
            display_name="MyPage",
            entry_fulfillment={
                "messages": [
                    {
                        "channel": "some-channel",
                        "text": {
                            "texts": ["Welcome to page"],
                        },
                    },
                    {
                        "payload": "        {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                    },
                    {
                        "conversation_success": {
                            "metadata": "          {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                        },
                    },
                    {
                        "output_audio_text": {
                            "text": "some output text",
                        },
                    },
                    {
                        "output_audio_text": {
                            "ssml": "          <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                        },
                    },
                    {
                        "live_agent_handoff": {
                            "metadata": "          {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                        },
                    },
                    {
                        "play_audio": {
                            "audio_uri": "http://example.com/some-audio-file.mp3",
                        },
                    },
                    {
                        "telephony_transfer_call": {
                            "phone_number": "1-234-567-8901",
                        },
                    },
                ],
                "set_parameter_actions": [
                    {
                        "parameter": "some-param",
                        "value": "123.45",
                    },
                    {
                        "parameter": "another-param",
                        "value": json.dumps("abc"),
                    },
                    {
                        "parameter": "other-param",
                        "value": json.dumps(["foo"]),
                    },
                ],
                "conditional_cases": [{
                    "cases": json.dumps([
                        {
                            "condition": "$sys.func.RAND() < 0.5",
                            "caseContent": [
                                {
                                    "message": {
                                        "text": {
                                            "text": ["First case"],
                                        },
                                    },
                                },
                                {
                                    "additionalCases": {
                                        "cases": [{
                                            "condition": "$sys.func.RAND() < 0.2",
                                            "caseContent": [{
                                                "message": {
                                                    "text": {
                                                        "text": ["Nested case"],
                                                    },
                                                },
                                            }],
                                        }],
                                    },
                                },
                            ],
                        },
                        {
                            "caseContent": [{
                                "message": {
                                    "text": {
                                        "text": ["Final case"],
                                    },
                                },
                            }],
                        },
                    ]),
                }],
            },
            event_handlers=[{
                "event": "some-event",
                "trigger_fulfillment": {
                    "return_partial_responses": True,
                    "messages": [
                        {
                            "channel": "some-channel",
                            "text": {
                                "texts": ["Some text"],
                            },
                        },
                        {
                            "payload": "          {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                        },
                        {
                            "conversation_success": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "output_audio_text": {
                                "text": "some output text",
                            },
                        },
                        {
                            "output_audio_text": {
                                "ssml": "            <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                            },
                        },
                        {
                            "live_agent_handoff": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "play_audio": {
                                "audio_uri": "http://example.com/some-audio-file.mp3",
                            },
                        },
                        {
                            "telephony_transfer_call": {
                                "phone_number": "1-234-567-8901",
                            },
                        },
                    ],
                    "set_parameter_actions": [
                        {
                            "parameter": "some-param",
                            "value": "123.45",
                        },
                        {
                            "parameter": "another-param",
                            "value": json.dumps("abc"),
                        },
                        {
                            "parameter": "other-param",
                            "value": json.dumps(["foo"]),
                        },
                    ],
                    "conditional_cases": [{
                        "cases": json.dumps([
                            {
                                "condition": "$sys.func.RAND() < 0.5",
                                "caseContent": [
                                    {
                                        "message": {
                                            "text": {
                                                "text": ["First case"],
                                            },
                                        },
                                    },
                                    {
                                        "additionalCases": {
                                            "cases": [{
                                                "condition": "$sys.func.RAND() < 0.2",
                                                "caseContent": [{
                                                    "message": {
                                                        "text": {
                                                            "text": ["Nested case"],
                                                        },
                                                    },
                                                }],
                                            }],
                                        },
                                    },
                                ],
                            },
                            {
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["Final case"],
                                        },
                                    },
                                }],
                            },
                        ]),
                    }],
                },
            }],
            form={
                "parameters": [{
                    "display_name": "param1",
                    "entity_type": "projects/-/locations/-/agents/-/entityTypes/sys.date",
                    "default_value": json.dumps("2000-01-01"),
                    "fill_behavior": {
                        "initial_prompt_fulfillment": {
                            "messages": [
                                {
                                    "channel": "some-channel",
                                    "text": {
                                        "texts": ["Please provide param1"],
                                    },
                                },
                                {
                                    "payload": "              {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                                },
                                {
                                    "conversation_success": {
                                        "metadata": "                {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                                    },
                                },
                                {
                                    "output_audio_text": {
                                        "text": "some output text",
                                    },
                                },
                                {
                                    "output_audio_text": {
                                        "ssml": "                <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                                    },
                                },
                                {
                                    "live_agent_handoff": {
                                        "metadata": "                {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                                    },
                                },
                                {
                                    "play_audio": {
                                        "audio_uri": "http://example.com/some-audio-file.mp3",
                                    },
                                },
                                {
                                    "telephony_transfer_call": {
                                        "phone_number": "1-234-567-8901",
                                    },
                                },
                            ],
                            "set_parameter_actions": [
                                {
                                    "parameter": "some-param",
                                    "value": "123.45",
                                },
                                {
                                    "parameter": "another-param",
                                    "value": json.dumps("abc"),
                                },
                                {
                                    "parameter": "other-param",
                                    "value": json.dumps(["foo"]),
                                },
                            ],
                            "conditional_cases": [{
                                "cases": json.dumps([
                                    {
                                        "condition": "$sys.func.RAND() < 0.5",
                                        "caseContent": [
                                            {
                                                "message": {
                                                    "text": {
                                                        "text": ["First case"],
                                                    },
                                                },
                                            },
                                            {
                                                "additionalCases": {
                                                    "cases": [{
                                                        "condition": "$sys.func.RAND() < 0.2",
                                                        "caseContent": [{
                                                            "message": {
                                                                "text": {
                                                                    "text": ["Nested case"],
                                                                },
                                                            },
                                                        }],
                                                    }],
                                                },
                                            },
                                        ],
                                    },
                                    {
                                        "caseContent": [{
                                            "message": {
                                                "text": {
                                                    "text": ["Final case"],
                                                },
                                            },
                                        }],
                                    },
                                ]),
                            }],
                        },
                        "reprompt_event_handlers": [
                            {
                                "event": "sys.no-match-1",
                                "trigger_fulfillment": {
                                    "return_partial_responses": True,
                                    "webhook": my_webhook.id,
                                    "tag": "some-tag",
                                    "messages": [
                                        {
                                            "channel": "some-channel",
                                            "text": {
                                                "texts": ["Please provide param1"],
                                            },
                                        },
                                        {
                                            "payload": "                {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                                        },
                                        {
                                            "conversation_success": {
                                                "metadata": "                  {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                                            },
                                        },
                                        {
                                            "output_audio_text": {
                                                "text": "some output text",
                                            },
                                        },
                                        {
                                            "output_audio_text": {
                                                "ssml": "                  <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                                            },
                                        },
                                        {
                                            "live_agent_handoff": {
                                                "metadata": "                  {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                                            },
                                        },
                                        {
                                            "play_audio": {
                                                "audio_uri": "http://example.com/some-audio-file.mp3",
                                            },
                                        },
                                        {
                                            "telephony_transfer_call": {
                                                "phone_number": "1-234-567-8901",
                                            },
                                        },
                                    ],
                                    "set_parameter_actions": [
                                        {
                                            "parameter": "some-param",
                                            "value": "123.45",
                                        },
                                        {
                                            "parameter": "another-param",
                                            "value": json.dumps("abc"),
                                        },
                                        {
                                            "parameter": "other-param",
                                            "value": json.dumps(["foo"]),
                                        },
                                    ],
                                    "conditional_cases": [{
                                        "cases": json.dumps([
                                            {
                                                "condition": "$sys.func.RAND() < 0.5",
                                                "caseContent": [
                                                    {
                                                        "message": {
                                                            "text": {
                                                                "text": ["First case"],
                                                            },
                                                        },
                                                    },
                                                    {
                                                        "additionalCases": {
                                                            "cases": [{
                                                                "condition": "$sys.func.RAND() < 0.2",
                                                                "caseContent": [{
                                                                    "message": {
                                                                        "text": {
                                                                            "text": ["Nested case"],
                                                                        },
                                                                    },
                                                                }],
                                                            }],
                                                        },
                                                    },
                                                ],
                                            },
                                            {
                                                "caseContent": [{
                                                    "message": {
                                                        "text": {
                                                            "text": ["Final case"],
                                                        },
                                                    },
                                                }],
                                            },
                                        ]),
                                    }],
                                },
                            },
                            {
                                "event": "sys.no-match-2",
                                "target_flow": agent.start_flow,
                            },
                            {
                                "event": "sys.no-match-3",
                                "target_page": my_page2.id,
                            },
                        ],
                    },
                    "required": True,
                    "redact": True,
                    "advanced_settings": {
                        "dtmf_settings": {
                            "enabled": True,
                            "max_digits": 1,
                            "finish_digit": "#",
                        },
                    },
                }],
            },
            transition_routes=[{
                "condition": "$page.params.status = 'FINAL'",
                "trigger_fulfillment": {
                    "messages": [
                        {
                            "channel": "some-channel",
                            "text": {
                                "texts": ["information completed, navigating to page 2"],
                            },
                        },
                        {
                            "payload": "          {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                        },
                        {
                            "conversation_success": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "output_audio_text": {
                                "text": "some output text",
                            },
                        },
                        {
                            "output_audio_text": {
                                "ssml": "            <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                            },
                        },
                        {
                            "live_agent_handoff": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "play_audio": {
                                "audio_uri": "http://example.com/some-audio-file.mp3",
                            },
                        },
                        {
                            "telephony_transfer_call": {
                                "phone_number": "1-234-567-8901",
                            },
                        },
                    ],
                    "set_parameter_actions": [
                        {
                            "parameter": "some-param",
                            "value": "123.45",
                        },
                        {
                            "parameter": "another-param",
                            "value": json.dumps("abc"),
                        },
                        {
                            "parameter": "other-param",
                            "value": json.dumps(["foo"]),
                        },
                    ],
                    "conditional_cases": [{
                        "cases": json.dumps([
                            {
                                "condition": "$sys.func.RAND() < 0.5",
                                "caseContent": [
                                    {
                                        "message": {
                                            "text": {
                                                "text": ["First case"],
                                            },
                                        },
                                    },
                                    {
                                        "additionalCases": {
                                            "cases": [{
                                                "condition": "$sys.func.RAND() < 0.2",
                                                "caseContent": [{
                                                    "message": {
                                                        "text": {
                                                            "text": ["Nested case"],
                                                        },
                                                    },
                                                }],
                                            }],
                                        },
                                    },
                                ],
                            },
                            {
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["Final case"],
                                        },
                                    },
                                }],
                            },
                        ]),
                    }],
                },
                "target_page": my_page2.id,
            }],
            advanced_settings={
                "dtmf_settings": {
                    "enabled": True,
                    "max_digits": 1,
                    "finish_digit": "#",
                },
            },
            knowledge_connector_settings={
                "enabled": True,
                "trigger_fulfillment": {
                    "messages": [
                        {
                            "channel": "some-channel",
                            "knowledge_info_card": {},
                        },
                        {
                            "channel": "some-channel",
                            "text": {
                                "texts": ["information completed, navigating to page 2"],
                            },
                        },
                        {
                            "payload": "          {\\\\\\"some-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-key\\\\\\": [\\\\\\"other-value\\\\\\"]}\\n",
                        },
                        {
                            "conversation_success": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "output_audio_text": {
                                "text": "some output text",
                            },
                        },
                        {
                            "output_audio_text": {
                                "ssml": "            <speak>Some example <say-as interpret-as=\\\\\\"characters\\\\\\">SSML XML</say-as></speak>\\n",
                            },
                        },
                        {
                            "live_agent_handoff": {
                                "metadata": "            {\\\\\\"some-metadata-key\\\\\\": \\\\\\"some-value\\\\\\", \\\\\\"other-metadata-key\\\\\\": 1234}\\n",
                            },
                        },
                        {
                            "play_audio": {
                                "audio_uri": "http://example.com/some-audio-file.mp3",
                            },
                        },
                        {
                            "telephony_transfer_call": {
                                "phone_number": "1-234-567-8902",
                            },
                        },
                    ],
                    "webhook": my_webhook.id,
                    "return_partial_responses": True,
                    "tag": "some-tag",
                    "set_parameter_actions": [{
                        "parameter": "some-param",
                        "value": "123.45",
                    }],
                    "conditional_cases": [{
                        "cases": json.dumps([
                            {
                                "condition": "$sys.func.RAND() < 0.5",
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["First case"],
                                        },
                                    },
                                }],
                            },
                            {
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["Final case"],
                                        },
                                    },
                                }],
                            },
                        ]),
                    }],
                    "advanced_settings": {
                        "speech_settings": {
                            "endpointer_sensitivity": 30,
                            "no_speech_timeout": "3.500s",
                            "use_timeout_based_endpointing": True,
                            "models": {
                                "name": "wrench",
                                "mass": "1.3kg",
                                "count": "3",
                            },
                        },
                        "dtmf_settings": {
                            "enabled": True,
                            "max_digits": 1,
                            "finish_digit": "#",
                            "interdigit_timeout_duration": "3.500s",
                            "endpointing_timeout_duration": "3.500s",
                        },
                        "logging_settings": {
                            "enable_stackdriver_logging": True,
                            "enable_interaction_logging": True,
                            "enable_consent_based_redaction": True,
                        },
                    },
                    "enable_generative_fallback": True,
                },
                "data_store_connections": [{
                    "data_store_type": "PUBLIC_WEB",
                    "data_store": agent.location.apply(lambda location: f"projects/{project.number}/locations/{location}/collections/default_collection/dataStores/datastore-page-full"),
                    "document_processing_mode": "CHUNKS",
                }],
                "target_page": my_page2.id,
            })
        my_datastore = gcp.discoveryengine.DataStore("my_datastore",
            location="global",
            data_store_id="datastore-page-full",
            display_name="datastore-page-full",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT")
        ```

        ## Import

        Page can be imported using any of these accepted formats:

        * `{{parent}}/pages/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Page can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxPage:CxPage default {{parent}}/pages/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxPage:CxPage default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxPageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxPageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_settings: Optional[pulumi.Input[Union['CxPageAdvancedSettingsArgs', 'CxPageAdvancedSettingsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_fulfillment: Optional[pulumi.Input[Union['CxPageEntryFulfillmentArgs', 'CxPageEntryFulfillmentArgsDict']]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxPageEventHandlerArgs', 'CxPageEventHandlerArgsDict']]]]] = None,
                 form: Optional[pulumi.Input[Union['CxPageFormArgs', 'CxPageFormArgsDict']]] = None,
                 knowledge_connector_settings: Optional[pulumi.Input[Union['CxPageKnowledgeConnectorSettingsArgs', 'CxPageKnowledgeConnectorSettingsArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxPageTransitionRouteArgs', 'CxPageTransitionRouteArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxPageArgs.__new__(CxPageArgs)

            __props__.__dict__["advanced_settings"] = advanced_settings
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["entry_fulfillment"] = entry_fulfillment
            __props__.__dict__["event_handlers"] = event_handlers
            __props__.__dict__["form"] = form
            __props__.__dict__["knowledge_connector_settings"] = knowledge_connector_settings
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["parent"] = parent
            __props__.__dict__["transition_route_groups"] = transition_route_groups
            __props__.__dict__["transition_routes"] = transition_routes
            __props__.__dict__["name"] = None
        super(CxPage, __self__).__init__(
            'gcp:diagflow/cxPage:CxPage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_settings: Optional[pulumi.Input[Union['CxPageAdvancedSettingsArgs', 'CxPageAdvancedSettingsArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            entry_fulfillment: Optional[pulumi.Input[Union['CxPageEntryFulfillmentArgs', 'CxPageEntryFulfillmentArgsDict']]] = None,
            event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxPageEventHandlerArgs', 'CxPageEventHandlerArgsDict']]]]] = None,
            form: Optional[pulumi.Input[Union['CxPageFormArgs', 'CxPageFormArgsDict']]] = None,
            knowledge_connector_settings: Optional[pulumi.Input[Union['CxPageKnowledgeConnectorSettingsArgs', 'CxPageKnowledgeConnectorSettingsArgsDict']]] = None,
            language_code: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxPageTransitionRouteArgs', 'CxPageTransitionRouteArgsDict']]]]] = None) -> 'CxPage':
        """
        Get an existing CxPage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxPageAdvancedSettingsArgs', 'CxPageAdvancedSettingsArgsDict']] advanced_settings: Hierarchical advanced settings for this page. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the page, unique within the agent.
        :param pulumi.Input[Union['CxPageEntryFulfillmentArgs', 'CxPageEntryFulfillmentArgsDict']] entry_fulfillment: The fulfillment to call when the session is entering the page.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxPageEventHandlerArgs', 'CxPageEventHandlerArgsDict']]]] event_handlers: Handlers associated with the page to handle events such as webhook errors, no match or no input.
               Structure is documented below.
        :param pulumi.Input[Union['CxPageFormArgs', 'CxPageFormArgsDict']] form: The form associated with the page, used for collecting parameters relevant to the page.
               Structure is documented below.
        :param pulumi.Input[Union['CxPageKnowledgeConnectorSettingsArgs', 'CxPageKnowledgeConnectorSettingsArgsDict']] knowledge_connector_settings: Knowledge connector configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: The language of the following fields in page:
               Page.entry_fulfillment.messages
               Page.entry_fulfillment.conditional_cases
               Page.event_handlers.trigger_fulfillment.messages
               Page.event_handlers.trigger_fulfillment.conditional_cases
               Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
               Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
               Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
               Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
               Page.transition_routes.trigger_fulfillment.messages
               Page.transition_routes.trigger_fulfillment.conditional_cases
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the page.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
        :param pulumi.Input[_builtins.str] parent: The flow to create a page for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] transition_route_groups: Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
               If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route > page's transition route group > flow's transition routes.
               If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
               Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxPageTransitionRouteArgs', 'CxPageTransitionRouteArgsDict']]]] transition_routes: A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow.
               When we are in a certain page, the TransitionRoutes are evalauted in the following order:
               TransitionRoutes defined in the page with intent specified.
               TransitionRoutes defined in the transition route groups with intent specified.
               TransitionRoutes defined in flow with intent specified.
               TransitionRoutes defined in the transition route groups with intent specified.
               TransitionRoutes defined in the page with only condition specified.
               TransitionRoutes defined in the transition route groups with only condition specified.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxPageState.__new__(_CxPageState)

        __props__.__dict__["advanced_settings"] = advanced_settings
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["entry_fulfillment"] = entry_fulfillment
        __props__.__dict__["event_handlers"] = event_handlers
        __props__.__dict__["form"] = form
        __props__.__dict__["knowledge_connector_settings"] = knowledge_connector_settings
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["transition_route_groups"] = transition_route_groups
        __props__.__dict__["transition_routes"] = transition_routes
        return CxPage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> pulumi.Output[Optional['outputs.CxPageAdvancedSettings']]:
        """
        Hierarchical advanced settings for this page. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of the page, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="entryFulfillment")
    def entry_fulfillment(self) -> pulumi.Output[Optional['outputs.CxPageEntryFulfillment']]:
        """
        The fulfillment to call when the session is entering the page.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_fulfillment")

    @_builtins.property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> pulumi.Output[Optional[Sequence['outputs.CxPageEventHandler']]]:
        """
        Handlers associated with the page to handle events such as webhook errors, no match or no input.
        Structure is documented below.
        """
        return pulumi.get(self, "event_handlers")

    @_builtins.property
    @pulumi.getter
    def form(self) -> pulumi.Output[Optional['outputs.CxPageForm']]:
        """
        The form associated with the page, used for collecting parameters relevant to the page.
        Structure is documented below.
        """
        return pulumi.get(self, "form")

    @_builtins.property
    @pulumi.getter(name="knowledgeConnectorSettings")
    def knowledge_connector_settings(self) -> pulumi.Output[Optional['outputs.CxPageKnowledgeConnectorSettings']]:
        """
        Knowledge connector configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "knowledge_connector_settings")

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language of the following fields in page:
        Page.entry_fulfillment.messages
        Page.entry_fulfillment.conditional_cases
        Page.event_handlers.trigger_fulfillment.messages
        Page.event_handlers.trigger_fulfillment.conditional_cases
        Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
        Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
        Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
        Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
        Page.transition_routes.trigger_fulfillment.messages
        Page.transition_routes.trigger_fulfillment.conditional_cases
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the page.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The flow to create a page for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
        If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route > page's transition route group > flow's transition routes.
        If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
        Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        """
        return pulumi.get(self, "transition_route_groups")

    @_builtins.property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CxPageTransitionRoute']]]:
        """
        A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow.
        When we are in a certain page, the TransitionRoutes are evalauted in the following order:
        TransitionRoutes defined in the page with intent specified.
        TransitionRoutes defined in the transition route groups with intent specified.
        TransitionRoutes defined in flow with intent specified.
        TransitionRoutes defined in the transition route groups with intent specified.
        TransitionRoutes defined in the page with only condition specified.
        TransitionRoutes defined in the transition route groups with only condition specified.
        Structure is documented below.
        """
        return pulumi.get(self, "transition_routes")

