# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclConfigArgs', 'AclConfig']

@pulumi.input_type
class AclConfigArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 idp_config: Optional[pulumi.Input['AclConfigIdpConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AclConfig resource.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input['AclConfigIdpConfigArgs'] idp_config: Identity provider config.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        if idp_config is not None:
            pulumi.set(__self__, "idp_config", idp_config)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> Optional[pulumi.Input['AclConfigIdpConfigArgs']]:
        """
        Identity provider config.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_config")

    @idp_config.setter
    def idp_config(self, value: Optional[pulumi.Input['AclConfigIdpConfigArgs']]):
        pulumi.set(self, "idp_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AclConfigState:
    def __init__(__self__, *,
                 idp_config: Optional[pulumi.Input['AclConfigIdpConfigArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AclConfig resources.
        :param pulumi.Input['AclConfigIdpConfigArgs'] idp_config: Identity provider config.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the aclConfig. Values are of the format
               `projects/{project}/locations/{location}/aclConfig`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if idp_config is not None:
            pulumi.set(__self__, "idp_config", idp_config)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> Optional[pulumi.Input['AclConfigIdpConfigArgs']]:
        """
        Identity provider config.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_config")

    @idp_config.setter
    def idp_config(self, value: Optional[pulumi.Input['AclConfigIdpConfigArgs']]):
        pulumi.set(self, "idp_config", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique full resource name of the aclConfig. Values are of the format
        `projects/{project}/locations/{location}/aclConfig`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:discoveryengine/aclConfig:AclConfig")
class AclConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 idp_config: Optional[pulumi.Input[Union['AclConfigIdpConfigArgs', 'AclConfigIdpConfigArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Access Control Configuration.

        To get more information about AclConfig, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1alpha#aclconfigservice)

        ## Example Usage

        ### Discoveryengine Aclconfig Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.AclConfig("basic",
            location="global",
            idp_config={
                "idp_type": "THIRD_PARTY",
                "external_idp_config": {
                    "workforce_pool_name": "locations/global/workforcePools/cloud-console-pool-manual",
                },
            })
        ```

        ## Import

        AclConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/aclConfig`

        * `{{project}}/{{location}}`

        * `{{location}}`

        When using the `pulumi import` command, AclConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/aclConfig:AclConfig default projects/{{project}}/locations/{{location}}/aclConfig
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/aclConfig:AclConfig default {{project}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/aclConfig:AclConfig default {{location}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AclConfigIdpConfigArgs', 'AclConfigIdpConfigArgsDict']] idp_config: Identity provider config.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Access Control Configuration.

        To get more information about AclConfig, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1alpha#aclconfigservice)

        ## Example Usage

        ### Discoveryengine Aclconfig Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.AclConfig("basic",
            location="global",
            idp_config={
                "idp_type": "THIRD_PARTY",
                "external_idp_config": {
                    "workforce_pool_name": "locations/global/workforcePools/cloud-console-pool-manual",
                },
            })
        ```

        ## Import

        AclConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/aclConfig`

        * `{{project}}/{{location}}`

        * `{{location}}`

        When using the `pulumi import` command, AclConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/aclConfig:AclConfig default projects/{{project}}/locations/{{location}}/aclConfig
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/aclConfig:AclConfig default {{project}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/aclConfig:AclConfig default {{location}}
        ```

        :param str resource_name: The name of the resource.
        :param AclConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 idp_config: Optional[pulumi.Input[Union['AclConfigIdpConfigArgs', 'AclConfigIdpConfigArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclConfigArgs.__new__(AclConfigArgs)

            __props__.__dict__["idp_config"] = idp_config
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["name"] = None
        super(AclConfig, __self__).__init__(
            'gcp:discoveryengine/aclConfig:AclConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            idp_config: Optional[pulumi.Input[Union['AclConfigIdpConfigArgs', 'AclConfigIdpConfigArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None) -> 'AclConfig':
        """
        Get an existing AclConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AclConfigIdpConfigArgs', 'AclConfigIdpConfigArgsDict']] idp_config: Identity provider config.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the aclConfig. Values are of the format
               `projects/{project}/locations/{location}/aclConfig`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclConfigState.__new__(_AclConfigState)

        __props__.__dict__["idp_config"] = idp_config
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return AclConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> pulumi.Output[Optional['outputs.AclConfigIdpConfig']]:
        """
        Identity provider config.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_config")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique full resource name of the aclConfig. Values are of the format
        `projects/{project}/locations/{location}/aclConfig`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

