# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssistantArgs', 'Assistant']

@pulumi.input_type
class AssistantArgs:
    def __init__(__self__, *,
                 assistant_id: pulumi.Input[_builtins.str],
                 collection_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 engine_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 customer_policy: Optional[pulumi.Input['AssistantCustomerPolicyArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 generation_config: Optional[pulumi.Input['AssistantGenerationConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 web_grounding_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Assistant resource.
        :param pulumi.Input[_builtins.str] assistant_id: The unique id of the assistant.
        :param pulumi.Input[_builtins.str] collection_id: The unique id of the collection.
        :param pulumi.Input[_builtins.str] display_name: The assistant display name.
               It must be a UTF-8 encoded string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] engine_id: The unique id of the engine.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input['AssistantCustomerPolicyArgs'] customer_policy: Customer policy for the assistant.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Description for additional information. Expected to be shown on the
               configuration UI, not to the users of the assistant.
        :param pulumi.Input['AssistantGenerationConfigArgs'] generation_config: Configuration for the generation of the assistant response.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] web_grounding_type: The type of web grounding to use.
               The supported values: 'WEB_GROUNDING_TYPE_DISABLED', 'WEB_GROUNDING_TYPE_GOOGLE_SEARCH', 'WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH'.
        """
        pulumi.set(__self__, "assistant_id", assistant_id)
        pulumi.set(__self__, "collection_id", collection_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "engine_id", engine_id)
        pulumi.set(__self__, "location", location)
        if customer_policy is not None:
            pulumi.set(__self__, "customer_policy", customer_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if generation_config is not None:
            pulumi.set(__self__, "generation_config", generation_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if web_grounding_type is not None:
            pulumi.set(__self__, "web_grounding_type", web_grounding_type)

    @_builtins.property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique id of the assistant.
        """
        return pulumi.get(self, "assistant_id")

    @assistant_id.setter
    def assistant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "assistant_id", value)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique id of the collection.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "collection_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The assistant display name.
        It must be a UTF-8 encoded string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique id of the engine.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="customerPolicy")
    def customer_policy(self) -> Optional[pulumi.Input['AssistantCustomerPolicyArgs']]:
        """
        Customer policy for the assistant.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_policy")

    @customer_policy.setter
    def customer_policy(self, value: Optional[pulumi.Input['AssistantCustomerPolicyArgs']]):
        pulumi.set(self, "customer_policy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for additional information. Expected to be shown on the
        configuration UI, not to the users of the assistant.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="generationConfig")
    def generation_config(self) -> Optional[pulumi.Input['AssistantGenerationConfigArgs']]:
        """
        Configuration for the generation of the assistant response.
        Structure is documented below.
        """
        return pulumi.get(self, "generation_config")

    @generation_config.setter
    def generation_config(self, value: Optional[pulumi.Input['AssistantGenerationConfigArgs']]):
        pulumi.set(self, "generation_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="webGroundingType")
    def web_grounding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of web grounding to use.
        The supported values: 'WEB_GROUNDING_TYPE_DISABLED', 'WEB_GROUNDING_TYPE_GOOGLE_SEARCH', 'WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH'.
        """
        return pulumi.get(self, "web_grounding_type")

    @web_grounding_type.setter
    def web_grounding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_grounding_type", value)


@pulumi.input_type
class _AssistantState:
    def __init__(__self__, *,
                 assistant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_policy: Optional[pulumi.Input['AssistantCustomerPolicyArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 generation_config: Optional[pulumi.Input['AssistantGenerationConfigArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 web_grounding_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Assistant resources.
        :param pulumi.Input[_builtins.str] assistant_id: The unique id of the assistant.
        :param pulumi.Input[_builtins.str] collection_id: The unique id of the collection.
        :param pulumi.Input['AssistantCustomerPolicyArgs'] customer_policy: Customer policy for the assistant.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Description for additional information. Expected to be shown on the
               configuration UI, not to the users of the assistant.
        :param pulumi.Input[_builtins.str] display_name: The assistant display name.
               It must be a UTF-8 encoded string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] engine_id: The unique id of the engine.
        :param pulumi.Input['AssistantGenerationConfigArgs'] generation_config: Configuration for the generation of the assistant response.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: Resource name of the assistant.
               Format:
               `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/assistants/{assistant}`
               It must be a UTF-8 encoded string with a length limit of 1024 characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] web_grounding_type: The type of web grounding to use.
               The supported values: 'WEB_GROUNDING_TYPE_DISABLED', 'WEB_GROUNDING_TYPE_GOOGLE_SEARCH', 'WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH'.
        """
        if assistant_id is not None:
            pulumi.set(__self__, "assistant_id", assistant_id)
        if collection_id is not None:
            pulumi.set(__self__, "collection_id", collection_id)
        if customer_policy is not None:
            pulumi.set(__self__, "customer_policy", customer_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if engine_id is not None:
            pulumi.set(__self__, "engine_id", engine_id)
        if generation_config is not None:
            pulumi.set(__self__, "generation_config", generation_config)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if web_grounding_type is not None:
            pulumi.set(__self__, "web_grounding_type", web_grounding_type)

    @_builtins.property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the assistant.
        """
        return pulumi.get(self, "assistant_id")

    @assistant_id.setter
    def assistant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assistant_id", value)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the collection.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collection_id", value)

    @_builtins.property
    @pulumi.getter(name="customerPolicy")
    def customer_policy(self) -> Optional[pulumi.Input['AssistantCustomerPolicyArgs']]:
        """
        Customer policy for the assistant.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_policy")

    @customer_policy.setter
    def customer_policy(self, value: Optional[pulumi.Input['AssistantCustomerPolicyArgs']]):
        pulumi.set(self, "customer_policy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for additional information. Expected to be shown on the
        configuration UI, not to the users of the assistant.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The assistant display name.
        It must be a UTF-8 encoded string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the engine.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter(name="generationConfig")
    def generation_config(self) -> Optional[pulumi.Input['AssistantGenerationConfigArgs']]:
        """
        Configuration for the generation of the assistant response.
        Structure is documented below.
        """
        return pulumi.get(self, "generation_config")

    @generation_config.setter
    def generation_config(self, value: Optional[pulumi.Input['AssistantGenerationConfigArgs']]):
        pulumi.set(self, "generation_config", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name of the assistant.
        Format:
        `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/assistants/{assistant}`
        It must be a UTF-8 encoded string with a length limit of 1024 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="webGroundingType")
    def web_grounding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of web grounding to use.
        The supported values: 'WEB_GROUNDING_TYPE_DISABLED', 'WEB_GROUNDING_TYPE_GOOGLE_SEARCH', 'WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH'.
        """
        return pulumi.get(self, "web_grounding_type")

    @web_grounding_type.setter
    def web_grounding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_grounding_type", value)


@pulumi.type_token("gcp:discoveryengine/assistant:Assistant")
class Assistant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assistant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_policy: Optional[pulumi.Input[Union['AssistantCustomerPolicyArgs', 'AssistantCustomerPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 generation_config: Optional[pulumi.Input[Union['AssistantGenerationConfigArgs', 'AssistantGenerationConfigArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 web_grounding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Assistant

        To get more information about Assistant, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1#assistantservice)

        ## Example Usage

        ### Discoveryengine Assistant Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="example-data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False)
        basic_search_engine = gcp.discoveryengine.SearchEngine("basic",
            location="global",
            collection_id="default_collection",
            engine_id="example-engine-id",
            display_name="Example Display Name",
            data_store_ids=[basic.data_store_id],
            search_engine_config={})
        basic_assistant = gcp.discoveryengine.Assistant("basic",
            location="global",
            collection_id="default_collection",
            engine_id=basic_search_engine.engine_id,
            assistant_id="example-assistant-id",
            display_name="updated-tf-test-Assistant",
            description="Assistant Description",
            generation_config={
                "system_instruction": {
                    "additional_system_instruction": "foobar",
                },
                "default_language": "en",
            },
            customer_policy={
                "banned_phrases": [{
                    "phrase": "foo",
                    "match_type": "SIMPLE_STRING_MATCH",
                    "ignore_diacritics": False,
                }],
            },
            web_grounding_type="WEB_GROUNDING_TYPE_GOOGLE_SEARCH")
        ```

        ## Import

        Assistant can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}/assistants/{{assistant_id}}`

        * `{{project}}/{{location}}/{{collection_id}}/{{engine_id}}/{{assistant_id}}`

        * `{{location}}/{{collection_id}}/{{engine_id}}/{{assistant_id}}`

        When using the `pulumi import` command, Assistant can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/assistant:Assistant default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}/assistants/{{assistant_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/assistant:Assistant default {{project}}/{{location}}/{{collection_id}}/{{engine_id}}/{{assistant_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/assistant:Assistant default {{location}}/{{collection_id}}/{{engine_id}}/{{assistant_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assistant_id: The unique id of the assistant.
        :param pulumi.Input[_builtins.str] collection_id: The unique id of the collection.
        :param pulumi.Input[Union['AssistantCustomerPolicyArgs', 'AssistantCustomerPolicyArgsDict']] customer_policy: Customer policy for the assistant.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Description for additional information. Expected to be shown on the
               configuration UI, not to the users of the assistant.
        :param pulumi.Input[_builtins.str] display_name: The assistant display name.
               It must be a UTF-8 encoded string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] engine_id: The unique id of the engine.
        :param pulumi.Input[Union['AssistantGenerationConfigArgs', 'AssistantGenerationConfigArgsDict']] generation_config: Configuration for the generation of the assistant response.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] web_grounding_type: The type of web grounding to use.
               The supported values: 'WEB_GROUNDING_TYPE_DISABLED', 'WEB_GROUNDING_TYPE_GOOGLE_SEARCH', 'WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssistantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Assistant

        To get more information about Assistant, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1#assistantservice)

        ## Example Usage

        ### Discoveryengine Assistant Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="example-data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False)
        basic_search_engine = gcp.discoveryengine.SearchEngine("basic",
            location="global",
            collection_id="default_collection",
            engine_id="example-engine-id",
            display_name="Example Display Name",
            data_store_ids=[basic.data_store_id],
            search_engine_config={})
        basic_assistant = gcp.discoveryengine.Assistant("basic",
            location="global",
            collection_id="default_collection",
            engine_id=basic_search_engine.engine_id,
            assistant_id="example-assistant-id",
            display_name="updated-tf-test-Assistant",
            description="Assistant Description",
            generation_config={
                "system_instruction": {
                    "additional_system_instruction": "foobar",
                },
                "default_language": "en",
            },
            customer_policy={
                "banned_phrases": [{
                    "phrase": "foo",
                    "match_type": "SIMPLE_STRING_MATCH",
                    "ignore_diacritics": False,
                }],
            },
            web_grounding_type="WEB_GROUNDING_TYPE_GOOGLE_SEARCH")
        ```

        ## Import

        Assistant can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}/assistants/{{assistant_id}}`

        * `{{project}}/{{location}}/{{collection_id}}/{{engine_id}}/{{assistant_id}}`

        * `{{location}}/{{collection_id}}/{{engine_id}}/{{assistant_id}}`

        When using the `pulumi import` command, Assistant can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/assistant:Assistant default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}/assistants/{{assistant_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/assistant:Assistant default {{project}}/{{location}}/{{collection_id}}/{{engine_id}}/{{assistant_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/assistant:Assistant default {{location}}/{{collection_id}}/{{engine_id}}/{{assistant_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AssistantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssistantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assistant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_policy: Optional[pulumi.Input[Union['AssistantCustomerPolicyArgs', 'AssistantCustomerPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 generation_config: Optional[pulumi.Input[Union['AssistantGenerationConfigArgs', 'AssistantGenerationConfigArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 web_grounding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssistantArgs.__new__(AssistantArgs)

            if assistant_id is None and not opts.urn:
                raise TypeError("Missing required property 'assistant_id'")
            __props__.__dict__["assistant_id"] = assistant_id
            if collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'collection_id'")
            __props__.__dict__["collection_id"] = collection_id
            __props__.__dict__["customer_policy"] = customer_policy
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if engine_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_id'")
            __props__.__dict__["engine_id"] = engine_id
            __props__.__dict__["generation_config"] = generation_config
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["web_grounding_type"] = web_grounding_type
            __props__.__dict__["name"] = None
        super(Assistant, __self__).__init__(
            'gcp:discoveryengine/assistant:Assistant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assistant_id: Optional[pulumi.Input[_builtins.str]] = None,
            collection_id: Optional[pulumi.Input[_builtins.str]] = None,
            customer_policy: Optional[pulumi.Input[Union['AssistantCustomerPolicyArgs', 'AssistantCustomerPolicyArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            engine_id: Optional[pulumi.Input[_builtins.str]] = None,
            generation_config: Optional[pulumi.Input[Union['AssistantGenerationConfigArgs', 'AssistantGenerationConfigArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            web_grounding_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Assistant':
        """
        Get an existing Assistant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assistant_id: The unique id of the assistant.
        :param pulumi.Input[_builtins.str] collection_id: The unique id of the collection.
        :param pulumi.Input[Union['AssistantCustomerPolicyArgs', 'AssistantCustomerPolicyArgsDict']] customer_policy: Customer policy for the assistant.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Description for additional information. Expected to be shown on the
               configuration UI, not to the users of the assistant.
        :param pulumi.Input[_builtins.str] display_name: The assistant display name.
               It must be a UTF-8 encoded string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] engine_id: The unique id of the engine.
        :param pulumi.Input[Union['AssistantGenerationConfigArgs', 'AssistantGenerationConfigArgsDict']] generation_config: Configuration for the generation of the assistant response.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: Resource name of the assistant.
               Format:
               `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/assistants/{assistant}`
               It must be a UTF-8 encoded string with a length limit of 1024 characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] web_grounding_type: The type of web grounding to use.
               The supported values: 'WEB_GROUNDING_TYPE_DISABLED', 'WEB_GROUNDING_TYPE_GOOGLE_SEARCH', 'WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH'.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssistantState.__new__(_AssistantState)

        __props__.__dict__["assistant_id"] = assistant_id
        __props__.__dict__["collection_id"] = collection_id
        __props__.__dict__["customer_policy"] = customer_policy
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["engine_id"] = engine_id
        __props__.__dict__["generation_config"] = generation_config
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["web_grounding_type"] = web_grounding_type
        return Assistant(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique id of the assistant.
        """
        return pulumi.get(self, "assistant_id")

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique id of the collection.
        """
        return pulumi.get(self, "collection_id")

    @_builtins.property
    @pulumi.getter(name="customerPolicy")
    def customer_policy(self) -> pulumi.Output[Optional['outputs.AssistantCustomerPolicy']]:
        """
        Customer policy for the assistant.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_policy")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for additional information. Expected to be shown on the
        configuration UI, not to the users of the assistant.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The assistant display name.
        It must be a UTF-8 encoded string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique id of the engine.
        """
        return pulumi.get(self, "engine_id")

    @_builtins.property
    @pulumi.getter(name="generationConfig")
    def generation_config(self) -> pulumi.Output[Optional['outputs.AssistantGenerationConfig']]:
        """
        Configuration for the generation of the assistant response.
        Structure is documented below.
        """
        return pulumi.get(self, "generation_config")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Resource name of the assistant.
        Format:
        `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/assistants/{assistant}`
        It must be a UTF-8 encoded string with a length limit of 1024 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="webGroundingType")
    def web_grounding_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of web grounding to use.
        The supported values: 'WEB_GROUNDING_TYPE_DISABLED', 'WEB_GROUNDING_TYPE_GOOGLE_SEARCH', 'WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH'.
        """
        return pulumi.get(self, "web_grounding_type")

