# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ControlArgs', 'Control']

@pulumi.input_type
class ControlArgs:
    def __init__(__self__, *,
                 control_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 engine_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 solution_type: pulumi.Input[_builtins.str],
                 boost_action: Optional[pulumi.Input['ControlBoostActionArgs']] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ControlConditionArgs']]]] = None,
                 filter_action: Optional[pulumi.Input['ControlFilterActionArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 promote_action: Optional[pulumi.Input['ControlPromoteActionArgs']] = None,
                 redirect_action: Optional[pulumi.Input['ControlRedirectActionArgs']] = None,
                 synonyms_action: Optional[pulumi.Input['ControlSynonymsActionArgs']] = None,
                 use_cases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Control resource.
        :param pulumi.Input[_builtins.str] control_id: The unique id of the control.
        :param pulumi.Input[_builtins.str] display_name: The display name of the control. This field must be a UTF-8 encoded
               string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] engine_id: The engine to add the control to.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] solution_type: The solution type that the control belongs to.
               Possible values are: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        :param pulumi.Input['ControlBoostActionArgs'] boost_action: Changes the returned order of results.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] collection_id: The collection ID. Currently only accepts "default_collection".
        :param pulumi.Input[Sequence[pulumi.Input['ControlConditionArgs']]] conditions: The conditions under which the control is active.
               Structure is documented below.
        :param pulumi.Input['ControlFilterActionArgs'] filter_action: Removes entries from returned results.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ControlPromoteActionArgs'] promote_action: Promotes a specified link for a query.
               Structure is documented below.
        :param pulumi.Input['ControlRedirectActionArgs'] redirect_action: Redirects to a specified URI.
               Structure is documented below.
        :param pulumi.Input['ControlSynonymsActionArgs'] synonyms_action: Associates queries with each other.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] use_cases: The use cases that the control is used for.
               Each value may be one of: `SEARCH_USE_CASE_SEARCH`, `SEARCH_USE_CASE_BROWSE`.
        """
        pulumi.set(__self__, "control_id", control_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "engine_id", engine_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "solution_type", solution_type)
        if boost_action is not None:
            pulumi.set(__self__, "boost_action", boost_action)
        if collection_id is not None:
            pulumi.set(__self__, "collection_id", collection_id)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if filter_action is not None:
            pulumi.set(__self__, "filter_action", filter_action)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if promote_action is not None:
            pulumi.set(__self__, "promote_action", promote_action)
        if redirect_action is not None:
            pulumi.set(__self__, "redirect_action", redirect_action)
        if synonyms_action is not None:
            pulumi.set(__self__, "synonyms_action", synonyms_action)
        if use_cases is not None:
            pulumi.set(__self__, "use_cases", use_cases)

    @_builtins.property
    @pulumi.getter(name="controlId")
    def control_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique id of the control.
        """
        return pulumi.get(self, "control_id")

    @control_id.setter
    def control_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "control_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the control. This field must be a UTF-8 encoded
        string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The engine to add the control to.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="solutionType")
    def solution_type(self) -> pulumi.Input[_builtins.str]:
        """
        The solution type that the control belongs to.
        Possible values are: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        return pulumi.get(self, "solution_type")

    @solution_type.setter
    def solution_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "solution_type", value)

    @_builtins.property
    @pulumi.getter(name="boostAction")
    def boost_action(self) -> Optional[pulumi.Input['ControlBoostActionArgs']]:
        """
        Changes the returned order of results.
        Structure is documented below.
        """
        return pulumi.get(self, "boost_action")

    @boost_action.setter
    def boost_action(self, value: Optional[pulumi.Input['ControlBoostActionArgs']]):
        pulumi.set(self, "boost_action", value)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The collection ID. Currently only accepts "default_collection".
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collection_id", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ControlConditionArgs']]]]:
        """
        The conditions under which the control is active.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ControlConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="filterAction")
    def filter_action(self) -> Optional[pulumi.Input['ControlFilterActionArgs']]:
        """
        Removes entries from returned results.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_action")

    @filter_action.setter
    def filter_action(self, value: Optional[pulumi.Input['ControlFilterActionArgs']]):
        pulumi.set(self, "filter_action", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="promoteAction")
    def promote_action(self) -> Optional[pulumi.Input['ControlPromoteActionArgs']]:
        """
        Promotes a specified link for a query.
        Structure is documented below.
        """
        return pulumi.get(self, "promote_action")

    @promote_action.setter
    def promote_action(self, value: Optional[pulumi.Input['ControlPromoteActionArgs']]):
        pulumi.set(self, "promote_action", value)

    @_builtins.property
    @pulumi.getter(name="redirectAction")
    def redirect_action(self) -> Optional[pulumi.Input['ControlRedirectActionArgs']]:
        """
        Redirects to a specified URI.
        Structure is documented below.
        """
        return pulumi.get(self, "redirect_action")

    @redirect_action.setter
    def redirect_action(self, value: Optional[pulumi.Input['ControlRedirectActionArgs']]):
        pulumi.set(self, "redirect_action", value)

    @_builtins.property
    @pulumi.getter(name="synonymsAction")
    def synonyms_action(self) -> Optional[pulumi.Input['ControlSynonymsActionArgs']]:
        """
        Associates queries with each other.
        Structure is documented below.
        """
        return pulumi.get(self, "synonyms_action")

    @synonyms_action.setter
    def synonyms_action(self, value: Optional[pulumi.Input['ControlSynonymsActionArgs']]):
        pulumi.set(self, "synonyms_action", value)

    @_builtins.property
    @pulumi.getter(name="useCases")
    def use_cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The use cases that the control is used for.
        Each value may be one of: `SEARCH_USE_CASE_SEARCH`, `SEARCH_USE_CASE_BROWSE`.
        """
        return pulumi.get(self, "use_cases")

    @use_cases.setter
    def use_cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "use_cases", value)


@pulumi.input_type
class _ControlState:
    def __init__(__self__, *,
                 boost_action: Optional[pulumi.Input['ControlBoostActionArgs']] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ControlConditionArgs']]]] = None,
                 control_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_action: Optional[pulumi.Input['ControlFilterActionArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 promote_action: Optional[pulumi.Input['ControlPromoteActionArgs']] = None,
                 redirect_action: Optional[pulumi.Input['ControlRedirectActionArgs']] = None,
                 solution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 synonyms_action: Optional[pulumi.Input['ControlSynonymsActionArgs']] = None,
                 use_cases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Control resources.
        :param pulumi.Input['ControlBoostActionArgs'] boost_action: Changes the returned order of results.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] collection_id: The collection ID. Currently only accepts "default_collection".
        :param pulumi.Input[Sequence[pulumi.Input['ControlConditionArgs']]] conditions: The conditions under which the control is active.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] control_id: The unique id of the control.
        :param pulumi.Input[_builtins.str] display_name: The display name of the control. This field must be a UTF-8 encoded
               string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] engine_id: The engine to add the control to.
        :param pulumi.Input['ControlFilterActionArgs'] filter_action: Removes entries from returned results.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the control. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/controls/{control_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ControlPromoteActionArgs'] promote_action: Promotes a specified link for a query.
               Structure is documented below.
        :param pulumi.Input['ControlRedirectActionArgs'] redirect_action: Redirects to a specified URI.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] solution_type: The solution type that the control belongs to.
               Possible values are: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        :param pulumi.Input['ControlSynonymsActionArgs'] synonyms_action: Associates queries with each other.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] use_cases: The use cases that the control is used for.
               Each value may be one of: `SEARCH_USE_CASE_SEARCH`, `SEARCH_USE_CASE_BROWSE`.
        """
        if boost_action is not None:
            pulumi.set(__self__, "boost_action", boost_action)
        if collection_id is not None:
            pulumi.set(__self__, "collection_id", collection_id)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if control_id is not None:
            pulumi.set(__self__, "control_id", control_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if engine_id is not None:
            pulumi.set(__self__, "engine_id", engine_id)
        if filter_action is not None:
            pulumi.set(__self__, "filter_action", filter_action)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if promote_action is not None:
            pulumi.set(__self__, "promote_action", promote_action)
        if redirect_action is not None:
            pulumi.set(__self__, "redirect_action", redirect_action)
        if solution_type is not None:
            pulumi.set(__self__, "solution_type", solution_type)
        if synonyms_action is not None:
            pulumi.set(__self__, "synonyms_action", synonyms_action)
        if use_cases is not None:
            pulumi.set(__self__, "use_cases", use_cases)

    @_builtins.property
    @pulumi.getter(name="boostAction")
    def boost_action(self) -> Optional[pulumi.Input['ControlBoostActionArgs']]:
        """
        Changes the returned order of results.
        Structure is documented below.
        """
        return pulumi.get(self, "boost_action")

    @boost_action.setter
    def boost_action(self, value: Optional[pulumi.Input['ControlBoostActionArgs']]):
        pulumi.set(self, "boost_action", value)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The collection ID. Currently only accepts "default_collection".
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collection_id", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ControlConditionArgs']]]]:
        """
        The conditions under which the control is active.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ControlConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="controlId")
    def control_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the control.
        """
        return pulumi.get(self, "control_id")

    @control_id.setter
    def control_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the control. This field must be a UTF-8 encoded
        string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine to add the control to.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter(name="filterAction")
    def filter_action(self) -> Optional[pulumi.Input['ControlFilterActionArgs']]:
        """
        Removes entries from returned results.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_action")

    @filter_action.setter
    def filter_action(self, value: Optional[pulumi.Input['ControlFilterActionArgs']]):
        pulumi.set(self, "filter_action", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique full resource name of the control. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/controls/{control_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="promoteAction")
    def promote_action(self) -> Optional[pulumi.Input['ControlPromoteActionArgs']]:
        """
        Promotes a specified link for a query.
        Structure is documented below.
        """
        return pulumi.get(self, "promote_action")

    @promote_action.setter
    def promote_action(self, value: Optional[pulumi.Input['ControlPromoteActionArgs']]):
        pulumi.set(self, "promote_action", value)

    @_builtins.property
    @pulumi.getter(name="redirectAction")
    def redirect_action(self) -> Optional[pulumi.Input['ControlRedirectActionArgs']]:
        """
        Redirects to a specified URI.
        Structure is documented below.
        """
        return pulumi.get(self, "redirect_action")

    @redirect_action.setter
    def redirect_action(self, value: Optional[pulumi.Input['ControlRedirectActionArgs']]):
        pulumi.set(self, "redirect_action", value)

    @_builtins.property
    @pulumi.getter(name="solutionType")
    def solution_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The solution type that the control belongs to.
        Possible values are: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        return pulumi.get(self, "solution_type")

    @solution_type.setter
    def solution_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "solution_type", value)

    @_builtins.property
    @pulumi.getter(name="synonymsAction")
    def synonyms_action(self) -> Optional[pulumi.Input['ControlSynonymsActionArgs']]:
        """
        Associates queries with each other.
        Structure is documented below.
        """
        return pulumi.get(self, "synonyms_action")

    @synonyms_action.setter
    def synonyms_action(self, value: Optional[pulumi.Input['ControlSynonymsActionArgs']]):
        pulumi.set(self, "synonyms_action", value)

    @_builtins.property
    @pulumi.getter(name="useCases")
    def use_cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The use cases that the control is used for.
        Each value may be one of: `SEARCH_USE_CASE_SEARCH`, `SEARCH_USE_CASE_BROWSE`.
        """
        return pulumi.get(self, "use_cases")

    @use_cases.setter
    def use_cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "use_cases", value)


@pulumi.type_token("gcp:discoveryengine/control:Control")
class Control(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boost_action: Optional[pulumi.Input[Union['ControlBoostActionArgs', 'ControlBoostActionArgsDict']]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ControlConditionArgs', 'ControlConditionArgsDict']]]]] = None,
                 control_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_action: Optional[pulumi.Input[Union['ControlFilterActionArgs', 'ControlFilterActionArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 promote_action: Optional[pulumi.Input[Union['ControlPromoteActionArgs', 'ControlPromoteActionArgsDict']]] = None,
                 redirect_action: Optional[pulumi.Input[Union['ControlRedirectActionArgs', 'ControlRedirectActionArgsDict']]] = None,
                 solution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 synonyms_action: Optional[pulumi.Input[Union['ControlSynonymsActionArgs', 'ControlSynonymsActionArgsDict']]] = None,
                 use_cases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Controls are rules that influence search results.

        To get more information about Control, see:

        * [API documentation](https://cloud.google.com/gemini/enterprise/docs/reference/rest/v1/projects.locations.collections.engines.controls)
        * How-to Guides
            * [Configure serving controls](https://cloud.google.com/gemini/enterprise/docs/configure-serving-controls)

        ## Example Usage

        ### Discoveryengine Control Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False)
        basic_search_engine = gcp.discoveryengine.SearchEngine("basic",
            engine_id="engine-id",
            collection_id="default_collection",
            location=basic.location,
            display_name="tf-test-engine",
            data_store_ids=[basic.data_store_id],
            industry_vertical="GENERIC",
            app_type="APP_TYPE_INTRANET",
            search_engine_config={})
        basic_control = gcp.discoveryengine.Control("basic",
            location=basic_search_engine.location,
            engine_id=basic_search_engine.engine_id,
            control_id="control-id",
            display_name="tf-test-control",
            solution_type="SOLUTION_TYPE_SEARCH",
            use_cases=["SEARCH_USE_CASE_SEARCH"],
            synonyms_action={
                "synonyms": [
                    "test",
                    "experiment",
                ],
            })
        ```

        ## Import

        Control can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}/controls/{{control_id}}`

        * `{{project}}/{{location}}/{{collection_id}}/{{engine_id}}/{{control_id}}`

        * `{{location}}/{{collection_id}}/{{engine_id}}/{{control_id}}`

        When using the `pulumi import` command, Control can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/control:Control default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}/controls/{{control_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/control:Control default {{project}}/{{location}}/{{collection_id}}/{{engine_id}}/{{control_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/control:Control default {{location}}/{{collection_id}}/{{engine_id}}/{{control_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ControlBoostActionArgs', 'ControlBoostActionArgsDict']] boost_action: Changes the returned order of results.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] collection_id: The collection ID. Currently only accepts "default_collection".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ControlConditionArgs', 'ControlConditionArgsDict']]]] conditions: The conditions under which the control is active.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] control_id: The unique id of the control.
        :param pulumi.Input[_builtins.str] display_name: The display name of the control. This field must be a UTF-8 encoded
               string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] engine_id: The engine to add the control to.
        :param pulumi.Input[Union['ControlFilterActionArgs', 'ControlFilterActionArgsDict']] filter_action: Removes entries from returned results.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ControlPromoteActionArgs', 'ControlPromoteActionArgsDict']] promote_action: Promotes a specified link for a query.
               Structure is documented below.
        :param pulumi.Input[Union['ControlRedirectActionArgs', 'ControlRedirectActionArgsDict']] redirect_action: Redirects to a specified URI.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] solution_type: The solution type that the control belongs to.
               Possible values are: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        :param pulumi.Input[Union['ControlSynonymsActionArgs', 'ControlSynonymsActionArgsDict']] synonyms_action: Associates queries with each other.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] use_cases: The use cases that the control is used for.
               Each value may be one of: `SEARCH_USE_CASE_SEARCH`, `SEARCH_USE_CASE_BROWSE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Controls are rules that influence search results.

        To get more information about Control, see:

        * [API documentation](https://cloud.google.com/gemini/enterprise/docs/reference/rest/v1/projects.locations.collections.engines.controls)
        * How-to Guides
            * [Configure serving controls](https://cloud.google.com/gemini/enterprise/docs/configure-serving-controls)

        ## Example Usage

        ### Discoveryengine Control Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False)
        basic_search_engine = gcp.discoveryengine.SearchEngine("basic",
            engine_id="engine-id",
            collection_id="default_collection",
            location=basic.location,
            display_name="tf-test-engine",
            data_store_ids=[basic.data_store_id],
            industry_vertical="GENERIC",
            app_type="APP_TYPE_INTRANET",
            search_engine_config={})
        basic_control = gcp.discoveryengine.Control("basic",
            location=basic_search_engine.location,
            engine_id=basic_search_engine.engine_id,
            control_id="control-id",
            display_name="tf-test-control",
            solution_type="SOLUTION_TYPE_SEARCH",
            use_cases=["SEARCH_USE_CASE_SEARCH"],
            synonyms_action={
                "synonyms": [
                    "test",
                    "experiment",
                ],
            })
        ```

        ## Import

        Control can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}/controls/{{control_id}}`

        * `{{project}}/{{location}}/{{collection_id}}/{{engine_id}}/{{control_id}}`

        * `{{location}}/{{collection_id}}/{{engine_id}}/{{control_id}}`

        When using the `pulumi import` command, Control can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/control:Control default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}/controls/{{control_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/control:Control default {{project}}/{{location}}/{{collection_id}}/{{engine_id}}/{{control_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/control:Control default {{location}}/{{collection_id}}/{{engine_id}}/{{control_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boost_action: Optional[pulumi.Input[Union['ControlBoostActionArgs', 'ControlBoostActionArgsDict']]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ControlConditionArgs', 'ControlConditionArgsDict']]]]] = None,
                 control_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_action: Optional[pulumi.Input[Union['ControlFilterActionArgs', 'ControlFilterActionArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 promote_action: Optional[pulumi.Input[Union['ControlPromoteActionArgs', 'ControlPromoteActionArgsDict']]] = None,
                 redirect_action: Optional[pulumi.Input[Union['ControlRedirectActionArgs', 'ControlRedirectActionArgsDict']]] = None,
                 solution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 synonyms_action: Optional[pulumi.Input[Union['ControlSynonymsActionArgs', 'ControlSynonymsActionArgsDict']]] = None,
                 use_cases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ControlArgs.__new__(ControlArgs)

            __props__.__dict__["boost_action"] = boost_action
            __props__.__dict__["collection_id"] = collection_id
            __props__.__dict__["conditions"] = conditions
            if control_id is None and not opts.urn:
                raise TypeError("Missing required property 'control_id'")
            __props__.__dict__["control_id"] = control_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if engine_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_id'")
            __props__.__dict__["engine_id"] = engine_id
            __props__.__dict__["filter_action"] = filter_action
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["promote_action"] = promote_action
            __props__.__dict__["redirect_action"] = redirect_action
            if solution_type is None and not opts.urn:
                raise TypeError("Missing required property 'solution_type'")
            __props__.__dict__["solution_type"] = solution_type
            __props__.__dict__["synonyms_action"] = synonyms_action
            __props__.__dict__["use_cases"] = use_cases
            __props__.__dict__["name"] = None
        super(Control, __self__).__init__(
            'gcp:discoveryengine/control:Control',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            boost_action: Optional[pulumi.Input[Union['ControlBoostActionArgs', 'ControlBoostActionArgsDict']]] = None,
            collection_id: Optional[pulumi.Input[_builtins.str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ControlConditionArgs', 'ControlConditionArgsDict']]]]] = None,
            control_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            engine_id: Optional[pulumi.Input[_builtins.str]] = None,
            filter_action: Optional[pulumi.Input[Union['ControlFilterActionArgs', 'ControlFilterActionArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            promote_action: Optional[pulumi.Input[Union['ControlPromoteActionArgs', 'ControlPromoteActionArgsDict']]] = None,
            redirect_action: Optional[pulumi.Input[Union['ControlRedirectActionArgs', 'ControlRedirectActionArgsDict']]] = None,
            solution_type: Optional[pulumi.Input[_builtins.str]] = None,
            synonyms_action: Optional[pulumi.Input[Union['ControlSynonymsActionArgs', 'ControlSynonymsActionArgsDict']]] = None,
            use_cases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Control':
        """
        Get an existing Control resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ControlBoostActionArgs', 'ControlBoostActionArgsDict']] boost_action: Changes the returned order of results.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] collection_id: The collection ID. Currently only accepts "default_collection".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ControlConditionArgs', 'ControlConditionArgsDict']]]] conditions: The conditions under which the control is active.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] control_id: The unique id of the control.
        :param pulumi.Input[_builtins.str] display_name: The display name of the control. This field must be a UTF-8 encoded
               string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] engine_id: The engine to add the control to.
        :param pulumi.Input[Union['ControlFilterActionArgs', 'ControlFilterActionArgsDict']] filter_action: Removes entries from returned results.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the control. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/controls/{control_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ControlPromoteActionArgs', 'ControlPromoteActionArgsDict']] promote_action: Promotes a specified link for a query.
               Structure is documented below.
        :param pulumi.Input[Union['ControlRedirectActionArgs', 'ControlRedirectActionArgsDict']] redirect_action: Redirects to a specified URI.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] solution_type: The solution type that the control belongs to.
               Possible values are: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        :param pulumi.Input[Union['ControlSynonymsActionArgs', 'ControlSynonymsActionArgsDict']] synonyms_action: Associates queries with each other.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] use_cases: The use cases that the control is used for.
               Each value may be one of: `SEARCH_USE_CASE_SEARCH`, `SEARCH_USE_CASE_BROWSE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ControlState.__new__(_ControlState)

        __props__.__dict__["boost_action"] = boost_action
        __props__.__dict__["collection_id"] = collection_id
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["control_id"] = control_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["engine_id"] = engine_id
        __props__.__dict__["filter_action"] = filter_action
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["promote_action"] = promote_action
        __props__.__dict__["redirect_action"] = redirect_action
        __props__.__dict__["solution_type"] = solution_type
        __props__.__dict__["synonyms_action"] = synonyms_action
        __props__.__dict__["use_cases"] = use_cases
        return Control(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="boostAction")
    def boost_action(self) -> pulumi.Output[Optional['outputs.ControlBoostAction']]:
        """
        Changes the returned order of results.
        Structure is documented below.
        """
        return pulumi.get(self, "boost_action")

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The collection ID. Currently only accepts "default_collection".
        """
        return pulumi.get(self, "collection_id")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.ControlCondition']]]:
        """
        The conditions under which the control is active.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="controlId")
    def control_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique id of the control.
        """
        return pulumi.get(self, "control_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the control. This field must be a UTF-8 encoded
        string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The engine to add the control to.
        """
        return pulumi.get(self, "engine_id")

    @_builtins.property
    @pulumi.getter(name="filterAction")
    def filter_action(self) -> pulumi.Output[Optional['outputs.ControlFilterAction']]:
        """
        Removes entries from returned results.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_action")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique full resource name of the control. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/controls/{control_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="promoteAction")
    def promote_action(self) -> pulumi.Output[Optional['outputs.ControlPromoteAction']]:
        """
        Promotes a specified link for a query.
        Structure is documented below.
        """
        return pulumi.get(self, "promote_action")

    @_builtins.property
    @pulumi.getter(name="redirectAction")
    def redirect_action(self) -> pulumi.Output[Optional['outputs.ControlRedirectAction']]:
        """
        Redirects to a specified URI.
        Structure is documented below.
        """
        return pulumi.get(self, "redirect_action")

    @_builtins.property
    @pulumi.getter(name="solutionType")
    def solution_type(self) -> pulumi.Output[_builtins.str]:
        """
        The solution type that the control belongs to.
        Possible values are: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        return pulumi.get(self, "solution_type")

    @_builtins.property
    @pulumi.getter(name="synonymsAction")
    def synonyms_action(self) -> pulumi.Output[Optional['outputs.ControlSynonymsAction']]:
        """
        Associates queries with each other.
        Structure is documented below.
        """
        return pulumi.get(self, "synonyms_action")

    @_builtins.property
    @pulumi.getter(name="useCases")
    def use_cases(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The use cases that the control is used for.
        Each value may be one of: `SEARCH_USE_CASE_SEARCH`, `SEARCH_USE_CASE_BROWSE`.
        """
        return pulumi.get(self, "use_cases")

