# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataConnectorArgs', 'DataConnector']

@pulumi.input_type
class DataConnectorArgs:
    def __init__(__self__, *,
                 collection_display_name: pulumi.Input[_builtins.str],
                 collection_id: pulumi.Input[_builtins.str],
                 data_source: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 refresh_interval: pulumi.Input[_builtins.str],
                 auto_run_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connector_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorEntityArgs']]]] = None,
                 incremental_refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental_sync_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_params: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 static_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DataConnector resource.
        :param pulumi.Input[_builtins.str] collection_display_name: The display name of the Collection.
               Should be human readable, used to display collections in the Console
               Dashboard. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[_builtins.str] collection_id: The ID to use for the Collection, which will become the final component
               of the Collection's resource name. A new Collection is created as
               part of the DataConnector setup. DataConnector is a singleton
               resource under Collection, managing all DataStores of the Collection.
               This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
               standard with a length limit of 63 characters. Otherwise, an
               INVALID_ARGUMENT error is returned.
        :param pulumi.Input[_builtins.str] data_source: The name of the data source.
               Supported values: `salesforce`, `jira`, `confluence`, `bigquery`.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] refresh_interval: The refresh interval for data sync. If duration is set to 0, the data will
               be synced in real time. The streaming feature is not supported yet. The
               minimum is 30 minutes and maximum is 7 days. When the refresh interval is
               set to the same value as the incremental refresh interval, incremental
               sync will be disabled.
        :param pulumi.Input[_builtins.bool] auto_run_disabled: Indicates whether full syncs are paused for this connector
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connector_modes: The modes enabled for this connector. The possible value can be:
               'DATA_INGESTION', 'ACTIONS', 'FEDERATED'
               'EUA', 'FEDERATED_AND_EUA'.
        :param pulumi.Input[Sequence[pulumi.Input['DataConnectorEntityArgs']]] entities: List of entities from the connected data source to ingest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] incremental_refresh_interval: The refresh interval specifically for incremental data syncs. If unset,
               incremental syncs will use the default from env, set to 3hrs.
               The minimum is 30 minutes and maximum is 7 days. Applicable to only 3P
               connectors. When the refresh interval is
               set to the same value as the incremental refresh interval, incremental
               sync will be disabled.
        :param pulumi.Input[_builtins.bool] incremental_sync_disabled: Indicates whether incremental syncs are paused for this connector.
        :param pulumi.Input[_builtins.str] json_params: Params needed to access the source in the format of json string.
        :param pulumi.Input[_builtins.str] kms_key_name: The KMS key to be used to protect the DataStores managed by this connector.
               Must be set for requests that need to comply with CMEK Org Policy
               protections.
               If this field is set and processed successfully, the DataStores created by
               this connector will be protected by the KMS key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] params: Params needed to access the source in the format of String-to-String (Key, Value) pairs.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] static_ip_enabled: Whether customer has enabled static IP addresses for this connector.
        :param pulumi.Input[_builtins.str] sync_mode: The data synchronization mode supported by the data connector. The possible value can be:
               'PERIODIC', 'STREAMING'.
        """
        pulumi.set(__self__, "collection_display_name", collection_display_name)
        pulumi.set(__self__, "collection_id", collection_id)
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "refresh_interval", refresh_interval)
        if auto_run_disabled is not None:
            pulumi.set(__self__, "auto_run_disabled", auto_run_disabled)
        if connector_modes is not None:
            pulumi.set(__self__, "connector_modes", connector_modes)
        if entities is not None:
            pulumi.set(__self__, "entities", entities)
        if incremental_refresh_interval is not None:
            pulumi.set(__self__, "incremental_refresh_interval", incremental_refresh_interval)
        if incremental_sync_disabled is not None:
            pulumi.set(__self__, "incremental_sync_disabled", incremental_sync_disabled)
        if json_params is not None:
            pulumi.set(__self__, "json_params", json_params)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if static_ip_enabled is not None:
            pulumi.set(__self__, "static_ip_enabled", static_ip_enabled)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @_builtins.property
    @pulumi.getter(name="collectionDisplayName")
    def collection_display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the Collection.
        Should be human readable, used to display collections in the Console
        Dashboard. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "collection_display_name")

    @collection_display_name.setter
    def collection_display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "collection_display_name", value)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the Collection, which will become the final component
        of the Collection's resource name. A new Collection is created as
        part of the DataConnector setup. DataConnector is a singleton
        resource under Collection, managing all DataStores of the Collection.
        This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        standard with a length limit of 63 characters. Otherwise, an
        INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "collection_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the data source.
        Supported values: `salesforce`, `jira`, `confluence`, `bigquery`.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Input[_builtins.str]:
        """
        The refresh interval for data sync. If duration is set to 0, the data will
        be synced in real time. The streaming feature is not supported yet. The
        minimum is 30 minutes and maximum is 7 days. When the refresh interval is
        set to the same value as the incremental refresh interval, incremental
        sync will be disabled.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="autoRunDisabled")
    def auto_run_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether full syncs are paused for this connector
        """
        return pulumi.get(self, "auto_run_disabled")

    @auto_run_disabled.setter
    def auto_run_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_run_disabled", value)

    @_builtins.property
    @pulumi.getter(name="connectorModes")
    def connector_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The modes enabled for this connector. The possible value can be:
        'DATA_INGESTION', 'ACTIONS', 'FEDERATED'
        'EUA', 'FEDERATED_AND_EUA'.
        """
        return pulumi.get(self, "connector_modes")

    @connector_modes.setter
    def connector_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connector_modes", value)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorEntityArgs']]]]:
        """
        List of entities from the connected data source to ingest.
        Structure is documented below.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorEntityArgs']]]]):
        pulumi.set(self, "entities", value)

    @_builtins.property
    @pulumi.getter(name="incrementalRefreshInterval")
    def incremental_refresh_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The refresh interval specifically for incremental data syncs. If unset,
        incremental syncs will use the default from env, set to 3hrs.
        The minimum is 30 minutes and maximum is 7 days. Applicable to only 3P
        connectors. When the refresh interval is
        set to the same value as the incremental refresh interval, incremental
        sync will be disabled.
        """
        return pulumi.get(self, "incremental_refresh_interval")

    @incremental_refresh_interval.setter
    def incremental_refresh_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "incremental_refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="incrementalSyncDisabled")
    def incremental_sync_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether incremental syncs are paused for this connector.
        """
        return pulumi.get(self, "incremental_sync_disabled")

    @incremental_sync_disabled.setter
    def incremental_sync_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "incremental_sync_disabled", value)

    @_builtins.property
    @pulumi.getter(name="jsonParams")
    def json_params(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Params needed to access the source in the format of json string.
        """
        return pulumi.get(self, "json_params")

    @json_params.setter
    def json_params(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "json_params", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key to be used to protect the DataStores managed by this connector.
        Must be set for requests that need to comply with CMEK Org Policy
        protections.
        If this field is set and processed successfully, the DataStores created by
        this connector will be protected by the KMS key.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Params needed to access the source in the format of String-to-String (Key, Value) pairs.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="staticIpEnabled")
    def static_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether customer has enabled static IP addresses for this connector.
        """
        return pulumi.get(self, "static_ip_enabled")

    @static_ip_enabled.setter
    def static_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "static_ip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data synchronization mode supported by the data connector. The possible value can be:
        'PERIODIC', 'STREAMING'.
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class _DataConnectorState:
    def __init__(__self__, *,
                 action_state: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_run_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 blocking_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 collection_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connector_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source: Optional[pulumi.Input[_builtins.str]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorEntityArgs']]]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorErrorArgs']]]] = None,
                 incremental_refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental_sync_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_params: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_sync_time: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_pause_time: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 private_connectivity_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 realtime_state: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 static_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 static_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataConnector resources.
        :param pulumi.Input[_builtins.str] action_state: State of the action connector. This reflects whether the action connector
               is initializing, active or has encountered errors. The possible value can be:
               'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
               'INITIALIZATION_FAILED', 'UPDATING'.
        :param pulumi.Input[_builtins.bool] auto_run_disabled: Indicates whether full syncs are paused for this connector
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocking_reasons: User actions that must be completed before the connector can start syncing data.
               The possible values can be: 'ALLOWLIST_STATIC_IP', 'ALLOWLIST_IN_SERVICE_ATTACHMENT'.
        :param pulumi.Input[_builtins.str] collection_display_name: The display name of the Collection.
               Should be human readable, used to display collections in the Console
               Dashboard. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[_builtins.str] collection_id: The ID to use for the Collection, which will become the final component
               of the Collection's resource name. A new Collection is created as
               part of the DataConnector setup. DataConnector is a singleton
               resource under Collection, managing all DataStores of the Collection.
               This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
               standard with a length limit of 63 characters. Otherwise, an
               INVALID_ARGUMENT error is returned.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connector_modes: The modes enabled for this connector. The possible value can be:
               'DATA_INGESTION', 'ACTIONS', 'FEDERATED'
               'EUA', 'FEDERATED_AND_EUA'.
        :param pulumi.Input[_builtins.str] connector_type: The type of connector. Each source can only map to one type.
               For example, salesforce, confluence and jira have THIRD_PARTY connector
               type. It is not mutable once set by system. The possible value can be:
               'CONNECTOR_TYPE_UNSPECIFIED', 'THIRD_PARTY', 'GCP_FHIR', 'BIG_QUERY',
               'GCS', 'GOOGLE_MAIL', 'GOOGLE_CALENDAR', 'GOOGLE_DRIVE',
               'NATIVE_CLOUD_IDENTITY', 'THIRD_PARTY_FEDERATED', 'THIRD_PARTY_EUA', 'GCNV'.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the DataConnector was created.
        :param pulumi.Input[_builtins.str] data_source: The name of the data source.
               Supported values: `salesforce`, `jira`, `confluence`, `bigquery`.
        :param pulumi.Input[Sequence[pulumi.Input['DataConnectorEntityArgs']]] entities: List of entities from the connected data source to ingest.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DataConnectorErrorArgs']]] errors: The errors from initialization or from the latest connector run.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] incremental_refresh_interval: The refresh interval specifically for incremental data syncs. If unset,
               incremental syncs will use the default from env, set to 3hrs.
               The minimum is 30 minutes and maximum is 7 days. Applicable to only 3P
               connectors. When the refresh interval is
               set to the same value as the incremental refresh interval, incremental
               sync will be disabled.
        :param pulumi.Input[_builtins.bool] incremental_sync_disabled: Indicates whether incremental syncs are paused for this connector.
        :param pulumi.Input[_builtins.str] json_params: Params needed to access the source in the format of json string.
        :param pulumi.Input[_builtins.str] kms_key_name: The KMS key to be used to protect the DataStores managed by this connector.
               Must be set for requests that need to comply with CMEK Org Policy
               protections.
               If this field is set and processed successfully, the DataStores created by
               this connector will be protected by the KMS key.
        :param pulumi.Input[_builtins.str] last_sync_time: For periodic connectors only, the last time a data sync was completed.
        :param pulumi.Input[_builtins.str] latest_pause_time: The most recent timestamp when this [DataConnector][] was paused,
               affecting all functionalities such as data synchronization.
               Pausing a connector has the following effects:
               - All functionalities, including data synchronization, are halted.
               - Any ongoing data synchronization job will be canceled.
               - No future data synchronization runs will be scheduled nor can be
               triggered.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The full resource name of the Data Connector.
               Format: `projects/*/locations/*/collections/*/dataConnector`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] params: Params needed to access the source in the format of String-to-String (Key, Value) pairs.
        :param pulumi.Input[_builtins.str] private_connectivity_project_id: The tenant project ID associated with private connectivity connectors.
               This project must be allowlisted by in order for the connector to function.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] realtime_state: The real-time sync state. The possible values can be:
               'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
               'INITIALIZATION_FAILED', 'UPDATING'.
        :param pulumi.Input[_builtins.str] refresh_interval: The refresh interval for data sync. If duration is set to 0, the data will
               be synced in real time. The streaming feature is not supported yet. The
               minimum is 30 minutes and maximum is 7 days. When the refresh interval is
               set to the same value as the incremental refresh interval, incremental
               sync will be disabled.
        :param pulumi.Input[_builtins.str] state: The state of connector. The possible value can be:
               'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
               'INITIALIZATION_FAILED', 'UPDATING'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] static_ip_addresses: The static IP addresses used by this connector.
        :param pulumi.Input[_builtins.bool] static_ip_enabled: Whether customer has enabled static IP addresses for this connector.
        :param pulumi.Input[_builtins.str] sync_mode: The data synchronization mode supported by the data connector. The possible value can be:
               'PERIODIC', 'STREAMING'.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when the DataConnector was updated.
        """
        if action_state is not None:
            pulumi.set(__self__, "action_state", action_state)
        if auto_run_disabled is not None:
            pulumi.set(__self__, "auto_run_disabled", auto_run_disabled)
        if blocking_reasons is not None:
            pulumi.set(__self__, "blocking_reasons", blocking_reasons)
        if collection_display_name is not None:
            pulumi.set(__self__, "collection_display_name", collection_display_name)
        if collection_id is not None:
            pulumi.set(__self__, "collection_id", collection_id)
        if connector_modes is not None:
            pulumi.set(__self__, "connector_modes", connector_modes)
        if connector_type is not None:
            pulumi.set(__self__, "connector_type", connector_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if entities is not None:
            pulumi.set(__self__, "entities", entities)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if incremental_refresh_interval is not None:
            pulumi.set(__self__, "incremental_refresh_interval", incremental_refresh_interval)
        if incremental_sync_disabled is not None:
            pulumi.set(__self__, "incremental_sync_disabled", incremental_sync_disabled)
        if json_params is not None:
            pulumi.set(__self__, "json_params", json_params)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if last_sync_time is not None:
            pulumi.set(__self__, "last_sync_time", last_sync_time)
        if latest_pause_time is not None:
            pulumi.set(__self__, "latest_pause_time", latest_pause_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if private_connectivity_project_id is not None:
            pulumi.set(__self__, "private_connectivity_project_id", private_connectivity_project_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if realtime_state is not None:
            pulumi.set(__self__, "realtime_state", realtime_state)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if static_ip_addresses is not None:
            pulumi.set(__self__, "static_ip_addresses", static_ip_addresses)
        if static_ip_enabled is not None:
            pulumi.set(__self__, "static_ip_enabled", static_ip_enabled)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="actionState")
    def action_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the action connector. This reflects whether the action connector
        is initializing, active or has encountered errors. The possible value can be:
        'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
        'INITIALIZATION_FAILED', 'UPDATING'.
        """
        return pulumi.get(self, "action_state")

    @action_state.setter
    def action_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action_state", value)

    @_builtins.property
    @pulumi.getter(name="autoRunDisabled")
    def auto_run_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether full syncs are paused for this connector
        """
        return pulumi.get(self, "auto_run_disabled")

    @auto_run_disabled.setter
    def auto_run_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_run_disabled", value)

    @_builtins.property
    @pulumi.getter(name="blockingReasons")
    def blocking_reasons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        User actions that must be completed before the connector can start syncing data.
        The possible values can be: 'ALLOWLIST_STATIC_IP', 'ALLOWLIST_IN_SERVICE_ATTACHMENT'.
        """
        return pulumi.get(self, "blocking_reasons")

    @blocking_reasons.setter
    def blocking_reasons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocking_reasons", value)

    @_builtins.property
    @pulumi.getter(name="collectionDisplayName")
    def collection_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Collection.
        Should be human readable, used to display collections in the Console
        Dashboard. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "collection_display_name")

    @collection_display_name.setter
    def collection_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collection_display_name", value)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the Collection, which will become the final component
        of the Collection's resource name. A new Collection is created as
        part of the DataConnector setup. DataConnector is a singleton
        resource under Collection, managing all DataStores of the Collection.
        This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        standard with a length limit of 63 characters. Otherwise, an
        INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collection_id", value)

    @_builtins.property
    @pulumi.getter(name="connectorModes")
    def connector_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The modes enabled for this connector. The possible value can be:
        'DATA_INGESTION', 'ACTIONS', 'FEDERATED'
        'EUA', 'FEDERATED_AND_EUA'.
        """
        return pulumi.get(self, "connector_modes")

    @connector_modes.setter
    def connector_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connector_modes", value)

    @_builtins.property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of connector. Each source can only map to one type.
        For example, salesforce, confluence and jira have THIRD_PARTY connector
        type. It is not mutable once set by system. The possible value can be:
        'CONNECTOR_TYPE_UNSPECIFIED', 'THIRD_PARTY', 'GCP_FHIR', 'BIG_QUERY',
        'GCS', 'GOOGLE_MAIL', 'GOOGLE_CALENDAR', 'GOOGLE_DRIVE',
        'NATIVE_CLOUD_IDENTITY', 'THIRD_PARTY_FEDERATED', 'THIRD_PARTY_EUA', 'GCNV'.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the DataConnector was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the data source.
        Supported values: `salesforce`, `jira`, `confluence`, `bigquery`.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source", value)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorEntityArgs']]]]:
        """
        List of entities from the connected data source to ingest.
        Structure is documented below.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorEntityArgs']]]]):
        pulumi.set(self, "entities", value)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorErrorArgs']]]]:
        """
        The errors from initialization or from the latest connector run.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataConnectorErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @_builtins.property
    @pulumi.getter(name="incrementalRefreshInterval")
    def incremental_refresh_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The refresh interval specifically for incremental data syncs. If unset,
        incremental syncs will use the default from env, set to 3hrs.
        The minimum is 30 minutes and maximum is 7 days. Applicable to only 3P
        connectors. When the refresh interval is
        set to the same value as the incremental refresh interval, incremental
        sync will be disabled.
        """
        return pulumi.get(self, "incremental_refresh_interval")

    @incremental_refresh_interval.setter
    def incremental_refresh_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "incremental_refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="incrementalSyncDisabled")
    def incremental_sync_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether incremental syncs are paused for this connector.
        """
        return pulumi.get(self, "incremental_sync_disabled")

    @incremental_sync_disabled.setter
    def incremental_sync_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "incremental_sync_disabled", value)

    @_builtins.property
    @pulumi.getter(name="jsonParams")
    def json_params(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Params needed to access the source in the format of json string.
        """
        return pulumi.get(self, "json_params")

    @json_params.setter
    def json_params(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "json_params", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key to be used to protect the DataStores managed by this connector.
        Must be set for requests that need to comply with CMEK Org Policy
        protections.
        If this field is set and processed successfully, the DataStores created by
        this connector will be protected by the KMS key.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For periodic connectors only, the last time a data sync was completed.
        """
        return pulumi.get(self, "last_sync_time")

    @last_sync_time.setter
    def last_sync_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_sync_time", value)

    @_builtins.property
    @pulumi.getter(name="latestPauseTime")
    def latest_pause_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The most recent timestamp when this [DataConnector][] was paused,
        affecting all functionalities such as data synchronization.
        Pausing a connector has the following effects:
        - All functionalities, including data synchronization, are halted.
        - Any ongoing data synchronization job will be canceled.
        - No future data synchronization runs will be scheduled nor can be
        triggered.
        """
        return pulumi.get(self, "latest_pause_time")

    @latest_pause_time.setter
    def latest_pause_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_pause_time", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full resource name of the Data Connector.
        Format: `projects/*/locations/*/collections/*/dataConnector`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Params needed to access the source in the format of String-to-String (Key, Value) pairs.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectivityProjectId")
    def private_connectivity_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant project ID associated with private connectivity connectors.
        This project must be allowlisted by in order for the connector to function.
        """
        return pulumi.get(self, "private_connectivity_project_id")

    @private_connectivity_project_id.setter
    def private_connectivity_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_connectivity_project_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="realtimeState")
    def realtime_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The real-time sync state. The possible values can be:
        'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
        'INITIALIZATION_FAILED', 'UPDATING'.
        """
        return pulumi.get(self, "realtime_state")

    @realtime_state.setter
    def realtime_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "realtime_state", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The refresh interval for data sync. If duration is set to 0, the data will
        be synced in real time. The streaming feature is not supported yet. The
        minimum is 30 minutes and maximum is 7 days. When the refresh interval is
        set to the same value as the incremental refresh interval, incremental
        sync will be disabled.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of connector. The possible value can be:
        'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
        'INITIALIZATION_FAILED', 'UPDATING'.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="staticIpAddresses")
    def static_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The static IP addresses used by this connector.
        """
        return pulumi.get(self, "static_ip_addresses")

    @static_ip_addresses.setter
    def static_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "static_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="staticIpEnabled")
    def static_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether customer has enabled static IP addresses for this connector.
        """
        return pulumi.get(self, "static_ip_enabled")

    @static_ip_enabled.setter
    def static_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "static_ip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data synchronization mode supported by the data connector. The possible value can be:
        'PERIODIC', 'STREAMING'.
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_mode", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the DataConnector was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:discoveryengine/dataConnector:DataConnector")
class DataConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_run_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 collection_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_source: Optional[pulumi.Input[_builtins.str]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataConnectorEntityArgs', 'DataConnectorEntityArgsDict']]]]] = None,
                 incremental_refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental_sync_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_params: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 static_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        DataConnector manages the connection to external data sources for all data stores grouped
        under a Collection. It's a singleton resource of Collection. The initialization is only
        supported through DataConnectorService.SetUpDataConnector method, which will create a new
        Collection and initialize its DataConnector.

        To get more information about DataConnector, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1alpha#dataconnectorservice)
        * How-to Guides
            * [Introduction](https://cloud.google.com/agentspace/docs/introduction-to-connectors-and-data-stores)

        ## Example Usage

        ### Discoveryengine Dataconnector Servicenow Basic

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        servicenow_basic = gcp.discoveryengine.DataConnector("servicenow-basic",
            location="global",
            collection_id="collection-id",
            collection_display_name="tf-test-dataconnector-servicenow",
            data_source="servicenow",
            params={
                "auth_type": "OAUTH_PASSWORD_GRANT",
                "instance_uri": "https://gcpconnector1.service-now.com/",
                "client_id": "SECRET_MANAGER_RESOURCE_NAME",
                "client_secret": "SECRET_MANAGER_RESOURCE_NAME",
                "static_ip_enabled": "false",
                "user_account": "connectorsuserqa@google.com",
                "password": "SECRET_MANAGER_RESOURCE_NAME",
            },
            refresh_interval="86400s",
            incremental_refresh_interval="21600s",
            entities=[
                {
                    "entity_name": "catalog",
                    "params": json.dumps({
                        "inclusion_filters": {
                            "knowledgeBaseSysId": ["123"],
                        },
                    }),
                },
                {
                    "entity_name": "incident",
                    "params": json.dumps({
                        "inclusion_filters": {
                            "knowledgeBaseSysId": ["123"],
                        },
                    }),
                },
                {
                    "entity_name": "knowledge_base",
                    "params": json.dumps({
                        "inclusion_filters": {
                            "knowledgeBaseSysId": ["123"],
                        },
                    }),
                },
            ],
            static_ip_enabled=False,
            connector_modes=["DATA_INGESTION"],
            sync_mode="PERIODIC")
        ```

        ## Import

        DataConnector can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/dataConnector`

        * `{{project}}/{{location}}/{{collection_id}}`

        * `{{location}}/{{collection_id}}`

        When using the `pulumi import` command, DataConnector can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/dataConnector:DataConnector default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/dataConnector
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/dataConnector:DataConnector default {{project}}/{{location}}/{{collection_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/dataConnector:DataConnector default {{location}}/{{collection_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_run_disabled: Indicates whether full syncs are paused for this connector
        :param pulumi.Input[_builtins.str] collection_display_name: The display name of the Collection.
               Should be human readable, used to display collections in the Console
               Dashboard. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[_builtins.str] collection_id: The ID to use for the Collection, which will become the final component
               of the Collection's resource name. A new Collection is created as
               part of the DataConnector setup. DataConnector is a singleton
               resource under Collection, managing all DataStores of the Collection.
               This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
               standard with a length limit of 63 characters. Otherwise, an
               INVALID_ARGUMENT error is returned.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connector_modes: The modes enabled for this connector. The possible value can be:
               'DATA_INGESTION', 'ACTIONS', 'FEDERATED'
               'EUA', 'FEDERATED_AND_EUA'.
        :param pulumi.Input[_builtins.str] data_source: The name of the data source.
               Supported values: `salesforce`, `jira`, `confluence`, `bigquery`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataConnectorEntityArgs', 'DataConnectorEntityArgsDict']]]] entities: List of entities from the connected data source to ingest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] incremental_refresh_interval: The refresh interval specifically for incremental data syncs. If unset,
               incremental syncs will use the default from env, set to 3hrs.
               The minimum is 30 minutes and maximum is 7 days. Applicable to only 3P
               connectors. When the refresh interval is
               set to the same value as the incremental refresh interval, incremental
               sync will be disabled.
        :param pulumi.Input[_builtins.bool] incremental_sync_disabled: Indicates whether incremental syncs are paused for this connector.
        :param pulumi.Input[_builtins.str] json_params: Params needed to access the source in the format of json string.
        :param pulumi.Input[_builtins.str] kms_key_name: The KMS key to be used to protect the DataStores managed by this connector.
               Must be set for requests that need to comply with CMEK Org Policy
               protections.
               If this field is set and processed successfully, the DataStores created by
               this connector will be protected by the KMS key.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] params: Params needed to access the source in the format of String-to-String (Key, Value) pairs.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] refresh_interval: The refresh interval for data sync. If duration is set to 0, the data will
               be synced in real time. The streaming feature is not supported yet. The
               minimum is 30 minutes and maximum is 7 days. When the refresh interval is
               set to the same value as the incremental refresh interval, incremental
               sync will be disabled.
        :param pulumi.Input[_builtins.bool] static_ip_enabled: Whether customer has enabled static IP addresses for this connector.
        :param pulumi.Input[_builtins.str] sync_mode: The data synchronization mode supported by the data connector. The possible value can be:
               'PERIODIC', 'STREAMING'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        DataConnector manages the connection to external data sources for all data stores grouped
        under a Collection. It's a singleton resource of Collection. The initialization is only
        supported through DataConnectorService.SetUpDataConnector method, which will create a new
        Collection and initialize its DataConnector.

        To get more information about DataConnector, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1alpha#dataconnectorservice)
        * How-to Guides
            * [Introduction](https://cloud.google.com/agentspace/docs/introduction-to-connectors-and-data-stores)

        ## Example Usage

        ### Discoveryengine Dataconnector Servicenow Basic

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        servicenow_basic = gcp.discoveryengine.DataConnector("servicenow-basic",
            location="global",
            collection_id="collection-id",
            collection_display_name="tf-test-dataconnector-servicenow",
            data_source="servicenow",
            params={
                "auth_type": "OAUTH_PASSWORD_GRANT",
                "instance_uri": "https://gcpconnector1.service-now.com/",
                "client_id": "SECRET_MANAGER_RESOURCE_NAME",
                "client_secret": "SECRET_MANAGER_RESOURCE_NAME",
                "static_ip_enabled": "false",
                "user_account": "connectorsuserqa@google.com",
                "password": "SECRET_MANAGER_RESOURCE_NAME",
            },
            refresh_interval="86400s",
            incremental_refresh_interval="21600s",
            entities=[
                {
                    "entity_name": "catalog",
                    "params": json.dumps({
                        "inclusion_filters": {
                            "knowledgeBaseSysId": ["123"],
                        },
                    }),
                },
                {
                    "entity_name": "incident",
                    "params": json.dumps({
                        "inclusion_filters": {
                            "knowledgeBaseSysId": ["123"],
                        },
                    }),
                },
                {
                    "entity_name": "knowledge_base",
                    "params": json.dumps({
                        "inclusion_filters": {
                            "knowledgeBaseSysId": ["123"],
                        },
                    }),
                },
            ],
            static_ip_enabled=False,
            connector_modes=["DATA_INGESTION"],
            sync_mode="PERIODIC")
        ```

        ## Import

        DataConnector can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/dataConnector`

        * `{{project}}/{{location}}/{{collection_id}}`

        * `{{location}}/{{collection_id}}`

        When using the `pulumi import` command, DataConnector can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/dataConnector:DataConnector default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/dataConnector
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/dataConnector:DataConnector default {{project}}/{{location}}/{{collection_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/dataConnector:DataConnector default {{location}}/{{collection_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DataConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_run_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 collection_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_source: Optional[pulumi.Input[_builtins.str]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataConnectorEntityArgs', 'DataConnectorEntityArgsDict']]]]] = None,
                 incremental_refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental_sync_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_params: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 static_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataConnectorArgs.__new__(DataConnectorArgs)

            __props__.__dict__["auto_run_disabled"] = auto_run_disabled
            if collection_display_name is None and not opts.urn:
                raise TypeError("Missing required property 'collection_display_name'")
            __props__.__dict__["collection_display_name"] = collection_display_name
            if collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'collection_id'")
            __props__.__dict__["collection_id"] = collection_id
            __props__.__dict__["connector_modes"] = connector_modes
            if data_source is None and not opts.urn:
                raise TypeError("Missing required property 'data_source'")
            __props__.__dict__["data_source"] = data_source
            __props__.__dict__["entities"] = entities
            __props__.__dict__["incremental_refresh_interval"] = incremental_refresh_interval
            __props__.__dict__["incremental_sync_disabled"] = incremental_sync_disabled
            __props__.__dict__["json_params"] = json_params
            __props__.__dict__["kms_key_name"] = kms_key_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["params"] = params
            __props__.__dict__["project"] = project
            if refresh_interval is None and not opts.urn:
                raise TypeError("Missing required property 'refresh_interval'")
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["static_ip_enabled"] = static_ip_enabled
            __props__.__dict__["sync_mode"] = sync_mode
            __props__.__dict__["action_state"] = None
            __props__.__dict__["blocking_reasons"] = None
            __props__.__dict__["connector_type"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["last_sync_time"] = None
            __props__.__dict__["latest_pause_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["private_connectivity_project_id"] = None
            __props__.__dict__["realtime_state"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["static_ip_addresses"] = None
            __props__.__dict__["update_time"] = None
        super(DataConnector, __self__).__init__(
            'gcp:discoveryengine/dataConnector:DataConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_state: Optional[pulumi.Input[_builtins.str]] = None,
            auto_run_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            blocking_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            collection_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            collection_id: Optional[pulumi.Input[_builtins.str]] = None,
            connector_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            connector_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_source: Optional[pulumi.Input[_builtins.str]] = None,
            entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataConnectorEntityArgs', 'DataConnectorEntityArgsDict']]]]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataConnectorErrorArgs', 'DataConnectorErrorArgsDict']]]]] = None,
            incremental_refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
            incremental_sync_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            json_params: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_sync_time: Optional[pulumi.Input[_builtins.str]] = None,
            latest_pause_time: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            private_connectivity_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            realtime_state: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            static_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            static_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataConnector':
        """
        Get an existing DataConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action_state: State of the action connector. This reflects whether the action connector
               is initializing, active or has encountered errors. The possible value can be:
               'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
               'INITIALIZATION_FAILED', 'UPDATING'.
        :param pulumi.Input[_builtins.bool] auto_run_disabled: Indicates whether full syncs are paused for this connector
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocking_reasons: User actions that must be completed before the connector can start syncing data.
               The possible values can be: 'ALLOWLIST_STATIC_IP', 'ALLOWLIST_IN_SERVICE_ATTACHMENT'.
        :param pulumi.Input[_builtins.str] collection_display_name: The display name of the Collection.
               Should be human readable, used to display collections in the Console
               Dashboard. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[_builtins.str] collection_id: The ID to use for the Collection, which will become the final component
               of the Collection's resource name. A new Collection is created as
               part of the DataConnector setup. DataConnector is a singleton
               resource under Collection, managing all DataStores of the Collection.
               This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
               standard with a length limit of 63 characters. Otherwise, an
               INVALID_ARGUMENT error is returned.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connector_modes: The modes enabled for this connector. The possible value can be:
               'DATA_INGESTION', 'ACTIONS', 'FEDERATED'
               'EUA', 'FEDERATED_AND_EUA'.
        :param pulumi.Input[_builtins.str] connector_type: The type of connector. Each source can only map to one type.
               For example, salesforce, confluence and jira have THIRD_PARTY connector
               type. It is not mutable once set by system. The possible value can be:
               'CONNECTOR_TYPE_UNSPECIFIED', 'THIRD_PARTY', 'GCP_FHIR', 'BIG_QUERY',
               'GCS', 'GOOGLE_MAIL', 'GOOGLE_CALENDAR', 'GOOGLE_DRIVE',
               'NATIVE_CLOUD_IDENTITY', 'THIRD_PARTY_FEDERATED', 'THIRD_PARTY_EUA', 'GCNV'.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the DataConnector was created.
        :param pulumi.Input[_builtins.str] data_source: The name of the data source.
               Supported values: `salesforce`, `jira`, `confluence`, `bigquery`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataConnectorEntityArgs', 'DataConnectorEntityArgsDict']]]] entities: List of entities from the connected data source to ingest.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataConnectorErrorArgs', 'DataConnectorErrorArgsDict']]]] errors: The errors from initialization or from the latest connector run.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] incremental_refresh_interval: The refresh interval specifically for incremental data syncs. If unset,
               incremental syncs will use the default from env, set to 3hrs.
               The minimum is 30 minutes and maximum is 7 days. Applicable to only 3P
               connectors. When the refresh interval is
               set to the same value as the incremental refresh interval, incremental
               sync will be disabled.
        :param pulumi.Input[_builtins.bool] incremental_sync_disabled: Indicates whether incremental syncs are paused for this connector.
        :param pulumi.Input[_builtins.str] json_params: Params needed to access the source in the format of json string.
        :param pulumi.Input[_builtins.str] kms_key_name: The KMS key to be used to protect the DataStores managed by this connector.
               Must be set for requests that need to comply with CMEK Org Policy
               protections.
               If this field is set and processed successfully, the DataStores created by
               this connector will be protected by the KMS key.
        :param pulumi.Input[_builtins.str] last_sync_time: For periodic connectors only, the last time a data sync was completed.
        :param pulumi.Input[_builtins.str] latest_pause_time: The most recent timestamp when this [DataConnector][] was paused,
               affecting all functionalities such as data synchronization.
               Pausing a connector has the following effects:
               - All functionalities, including data synchronization, are halted.
               - Any ongoing data synchronization job will be canceled.
               - No future data synchronization runs will be scheduled nor can be
               triggered.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The full resource name of the Data Connector.
               Format: `projects/*/locations/*/collections/*/dataConnector`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] params: Params needed to access the source in the format of String-to-String (Key, Value) pairs.
        :param pulumi.Input[_builtins.str] private_connectivity_project_id: The tenant project ID associated with private connectivity connectors.
               This project must be allowlisted by in order for the connector to function.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] realtime_state: The real-time sync state. The possible values can be:
               'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
               'INITIALIZATION_FAILED', 'UPDATING'.
        :param pulumi.Input[_builtins.str] refresh_interval: The refresh interval for data sync. If duration is set to 0, the data will
               be synced in real time. The streaming feature is not supported yet. The
               minimum is 30 minutes and maximum is 7 days. When the refresh interval is
               set to the same value as the incremental refresh interval, incremental
               sync will be disabled.
        :param pulumi.Input[_builtins.str] state: The state of connector. The possible value can be:
               'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
               'INITIALIZATION_FAILED', 'UPDATING'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] static_ip_addresses: The static IP addresses used by this connector.
        :param pulumi.Input[_builtins.bool] static_ip_enabled: Whether customer has enabled static IP addresses for this connector.
        :param pulumi.Input[_builtins.str] sync_mode: The data synchronization mode supported by the data connector. The possible value can be:
               'PERIODIC', 'STREAMING'.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when the DataConnector was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataConnectorState.__new__(_DataConnectorState)

        __props__.__dict__["action_state"] = action_state
        __props__.__dict__["auto_run_disabled"] = auto_run_disabled
        __props__.__dict__["blocking_reasons"] = blocking_reasons
        __props__.__dict__["collection_display_name"] = collection_display_name
        __props__.__dict__["collection_id"] = collection_id
        __props__.__dict__["connector_modes"] = connector_modes
        __props__.__dict__["connector_type"] = connector_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_source"] = data_source
        __props__.__dict__["entities"] = entities
        __props__.__dict__["errors"] = errors
        __props__.__dict__["incremental_refresh_interval"] = incremental_refresh_interval
        __props__.__dict__["incremental_sync_disabled"] = incremental_sync_disabled
        __props__.__dict__["json_params"] = json_params
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["last_sync_time"] = last_sync_time
        __props__.__dict__["latest_pause_time"] = latest_pause_time
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["params"] = params
        __props__.__dict__["private_connectivity_project_id"] = private_connectivity_project_id
        __props__.__dict__["project"] = project
        __props__.__dict__["realtime_state"] = realtime_state
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["state"] = state
        __props__.__dict__["static_ip_addresses"] = static_ip_addresses
        __props__.__dict__["static_ip_enabled"] = static_ip_enabled
        __props__.__dict__["sync_mode"] = sync_mode
        __props__.__dict__["update_time"] = update_time
        return DataConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="actionState")
    def action_state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the action connector. This reflects whether the action connector
        is initializing, active or has encountered errors. The possible value can be:
        'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
        'INITIALIZATION_FAILED', 'UPDATING'.
        """
        return pulumi.get(self, "action_state")

    @_builtins.property
    @pulumi.getter(name="autoRunDisabled")
    def auto_run_disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether full syncs are paused for this connector
        """
        return pulumi.get(self, "auto_run_disabled")

    @_builtins.property
    @pulumi.getter(name="blockingReasons")
    def blocking_reasons(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        User actions that must be completed before the connector can start syncing data.
        The possible values can be: 'ALLOWLIST_STATIC_IP', 'ALLOWLIST_IN_SERVICE_ATTACHMENT'.
        """
        return pulumi.get(self, "blocking_reasons")

    @_builtins.property
    @pulumi.getter(name="collectionDisplayName")
    def collection_display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the Collection.
        Should be human readable, used to display collections in the Console
        Dashboard. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "collection_display_name")

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the Collection, which will become the final component
        of the Collection's resource name. A new Collection is created as
        part of the DataConnector setup. DataConnector is a singleton
        resource under Collection, managing all DataStores of the Collection.
        This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        standard with a length limit of 63 characters. Otherwise, an
        INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "collection_id")

    @_builtins.property
    @pulumi.getter(name="connectorModes")
    def connector_modes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The modes enabled for this connector. The possible value can be:
        'DATA_INGESTION', 'ACTIONS', 'FEDERATED'
        'EUA', 'FEDERATED_AND_EUA'.
        """
        return pulumi.get(self, "connector_modes")

    @_builtins.property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of connector. Each source can only map to one type.
        For example, salesforce, confluence and jira have THIRD_PARTY connector
        type. It is not mutable once set by system. The possible value can be:
        'CONNECTOR_TYPE_UNSPECIFIED', 'THIRD_PARTY', 'GCP_FHIR', 'BIG_QUERY',
        'GCS', 'GOOGLE_MAIL', 'GOOGLE_CALENDAR', 'GOOGLE_DRIVE',
        'NATIVE_CLOUD_IDENTITY', 'THIRD_PARTY_FEDERATED', 'THIRD_PARTY_EUA', 'GCNV'.
        """
        return pulumi.get(self, "connector_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the DataConnector was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the data source.
        Supported values: `salesforce`, `jira`, `confluence`, `bigquery`.
        """
        return pulumi.get(self, "data_source")

    @_builtins.property
    @pulumi.getter
    def entities(self) -> pulumi.Output[Optional[Sequence['outputs.DataConnectorEntity']]]:
        """
        List of entities from the connected data source to ingest.
        Structure is documented below.
        """
        return pulumi.get(self, "entities")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.DataConnectorError']]:
        """
        The errors from initialization or from the latest connector run.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter(name="incrementalRefreshInterval")
    def incremental_refresh_interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The refresh interval specifically for incremental data syncs. If unset,
        incremental syncs will use the default from env, set to 3hrs.
        The minimum is 30 minutes and maximum is 7 days. Applicable to only 3P
        connectors. When the refresh interval is
        set to the same value as the incremental refresh interval, incremental
        sync will be disabled.
        """
        return pulumi.get(self, "incremental_refresh_interval")

    @_builtins.property
    @pulumi.getter(name="incrementalSyncDisabled")
    def incremental_sync_disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether incremental syncs are paused for this connector.
        """
        return pulumi.get(self, "incremental_sync_disabled")

    @_builtins.property
    @pulumi.getter(name="jsonParams")
    def json_params(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Params needed to access the source in the format of json string.
        """
        return pulumi.get(self, "json_params")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The KMS key to be used to protect the DataStores managed by this connector.
        Must be set for requests that need to comply with CMEK Org Policy
        protections.
        If this field is set and processed successfully, the DataStores created by
        this connector will be protected by the KMS key.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> pulumi.Output[_builtins.str]:
        """
        For periodic connectors only, the last time a data sync was completed.
        """
        return pulumi.get(self, "last_sync_time")

    @_builtins.property
    @pulumi.getter(name="latestPauseTime")
    def latest_pause_time(self) -> pulumi.Output[_builtins.str]:
        """
        The most recent timestamp when this [DataConnector][] was paused,
        affecting all functionalities such as data synchronization.
        Pausing a connector has the following effects:
        - All functionalities, including data synchronization, are halted.
        - Any ongoing data synchronization job will be canceled.
        - No future data synchronization runs will be scheduled nor can be
        triggered.
        """
        return pulumi.get(self, "latest_pause_time")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The full resource name of the Data Connector.
        Format: `projects/*/locations/*/collections/*/dataConnector`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Params needed to access the source in the format of String-to-String (Key, Value) pairs.
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter(name="privateConnectivityProjectId")
    def private_connectivity_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenant project ID associated with private connectivity connectors.
        This project must be allowlisted by in order for the connector to function.
        """
        return pulumi.get(self, "private_connectivity_project_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="realtimeState")
    def realtime_state(self) -> pulumi.Output[_builtins.str]:
        """
        The real-time sync state. The possible values can be:
        'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
        'INITIALIZATION_FAILED', 'UPDATING'.
        """
        return pulumi.get(self, "realtime_state")

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[_builtins.str]:
        """
        The refresh interval for data sync. If duration is set to 0, the data will
        be synced in real time. The streaming feature is not supported yet. The
        minimum is 30 minutes and maximum is 7 days. When the refresh interval is
        set to the same value as the incremental refresh interval, incremental
        sync will be disabled.
        """
        return pulumi.get(self, "refresh_interval")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of connector. The possible value can be:
        'STATE_UNSPECIFIED', 'CREATING', 'ACTIVE', 'FAILED', 'RUNNING', 'WARNING',
        'INITIALIZATION_FAILED', 'UPDATING'.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="staticIpAddresses")
    def static_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The static IP addresses used by this connector.
        """
        return pulumi.get(self, "static_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="staticIpEnabled")
    def static_ip_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether customer has enabled static IP addresses for this connector.
        """
        return pulumi.get(self, "static_ip_enabled")

    @_builtins.property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The data synchronization mode supported by the data connector. The possible value can be:
        'PERIODIC', 'STREAMING'.
        """
        return pulumi.get(self, "sync_mode")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the DataConnector was updated.
        """
        return pulumi.get(self, "update_time")

