# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LicenseConfigArgs', 'LicenseConfig']

@pulumi.input_type
class LicenseConfigArgs:
    def __init__(__self__, *,
                 license_config_id: pulumi.Input[_builtins.str],
                 license_count: pulumi.Input[_builtins.int],
                 location: pulumi.Input[_builtins.str],
                 start_date: pulumi.Input['LicenseConfigStartDateArgs'],
                 subscription_term: pulumi.Input[_builtins.str],
                 subscription_tier: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_date: Optional[pulumi.Input['LicenseConfigEndDateArgs']] = None,
                 free_trial: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LicenseConfig resource.
        :param pulumi.Input[_builtins.str] license_config_id: The unique id of the license config.
        :param pulumi.Input[_builtins.int] license_count: Number of licenses purchased.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input['LicenseConfigStartDateArgs'] start_date: The start date.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] subscription_term: Subscription term.
               Possible values are: `SUBSCRIPTION_TERM_UNSPECIFIED`, `SUBSCRIPTION_TERM_ONE_MONTH`, `SUBSCRIPTION_TERM_ONE_YEAR`, `SUBSCRIPTION_TERM_THREE_YEARS`, `SUBSCRIPTION_TERM_THREE_MONTHS`, `SUBSCRIPTION_TERM_FOURTEEN_DAYS`, `SUBSCRIPTION_TERM_CUSTOM`.
        :param pulumi.Input[_builtins.str] subscription_tier: Subscription tier information for the license config.
               Possible values are: `SUBSCRIPTION_TIER_UNSPECIFIED`, `SUBSCRIPTION_TIER_SEARCH`, `SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT`, `SUBSCRIPTION_TIER_NOTEBOOK_LM`, `SUBSCRIPTION_TIER_FRONTLINE_WORKER`, `SUBSCRIPTION_TIER_AGENTSPACE_STARTER`, `SUBSCRIPTION_TIER_AGENTSPACE_BUSINESS`, `SUBSCRIPTION_TIER_ENTERPRISE`, `SUBSCRIPTION_TIER_EDU`, `SUBSCRIPTION_TIER_EDU_PRO`.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether the license config should be auto renewed when it reaches the end date.
        :param pulumi.Input['LicenseConfigEndDateArgs'] end_date: The planned end date.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] free_trial: Whether the license config is for free trial.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "license_config_id", license_config_id)
        pulumi.set(__self__, "license_count", license_count)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "subscription_term", subscription_term)
        pulumi.set(__self__, "subscription_tier", subscription_tier)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if free_trial is not None:
            pulumi.set(__self__, "free_trial", free_trial)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="licenseConfigId")
    def license_config_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique id of the license config.
        """
        return pulumi.get(self, "license_config_id")

    @license_config_id.setter
    def license_config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_config_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseCount")
    def license_count(self) -> pulumi.Input[_builtins.int]:
        """
        Number of licenses purchased.
        """
        return pulumi.get(self, "license_count")

    @license_count.setter
    def license_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "license_count", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Input['LicenseConfigStartDateArgs']:
        """
        The start date.
        Structure is documented below.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: pulumi.Input['LicenseConfigStartDateArgs']):
        pulumi.set(self, "start_date", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionTerm")
    def subscription_term(self) -> pulumi.Input[_builtins.str]:
        """
        Subscription term.
        Possible values are: `SUBSCRIPTION_TERM_UNSPECIFIED`, `SUBSCRIPTION_TERM_ONE_MONTH`, `SUBSCRIPTION_TERM_ONE_YEAR`, `SUBSCRIPTION_TERM_THREE_YEARS`, `SUBSCRIPTION_TERM_THREE_MONTHS`, `SUBSCRIPTION_TERM_FOURTEEN_DAYS`, `SUBSCRIPTION_TERM_CUSTOM`.
        """
        return pulumi.get(self, "subscription_term")

    @subscription_term.setter
    def subscription_term(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_term", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionTier")
    def subscription_tier(self) -> pulumi.Input[_builtins.str]:
        """
        Subscription tier information for the license config.
        Possible values are: `SUBSCRIPTION_TIER_UNSPECIFIED`, `SUBSCRIPTION_TIER_SEARCH`, `SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT`, `SUBSCRIPTION_TIER_NOTEBOOK_LM`, `SUBSCRIPTION_TIER_FRONTLINE_WORKER`, `SUBSCRIPTION_TIER_AGENTSPACE_STARTER`, `SUBSCRIPTION_TIER_AGENTSPACE_BUSINESS`, `SUBSCRIPTION_TIER_ENTERPRISE`, `SUBSCRIPTION_TIER_EDU`, `SUBSCRIPTION_TIER_EDU_PRO`.
        """
        return pulumi.get(self, "subscription_tier")

    @subscription_tier.setter
    def subscription_tier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_tier", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the license config should be auto renewed when it reaches the end date.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[pulumi.Input['LicenseConfigEndDateArgs']]:
        """
        The planned end date.
        Structure is documented below.
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: Optional[pulumi.Input['LicenseConfigEndDateArgs']]):
        pulumi.set(self, "end_date", value)

    @_builtins.property
    @pulumi.getter(name="freeTrial")
    def free_trial(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the license config is for free trial.
        """
        return pulumi.get(self, "free_trial")

    @free_trial.setter
    def free_trial(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "free_trial", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _LicenseConfigState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_date: Optional[pulumi.Input['LicenseConfigEndDateArgs']] = None,
                 free_trial: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_count: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 start_date: Optional[pulumi.Input['LicenseConfigStartDateArgs']] = None,
                 subscription_term: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_tier: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LicenseConfig resources.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether the license config should be auto renewed when it reaches the end date.
        :param pulumi.Input['LicenseConfigEndDateArgs'] end_date: The planned end date.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] free_trial: Whether the license config is for free trial.
        :param pulumi.Input[_builtins.str] license_config_id: The unique id of the license config.
        :param pulumi.Input[_builtins.int] license_count: Number of licenses purchased.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the license config. Values are of the format
               `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['LicenseConfigStartDateArgs'] start_date: The start date.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] subscription_term: Subscription term.
               Possible values are: `SUBSCRIPTION_TERM_UNSPECIFIED`, `SUBSCRIPTION_TERM_ONE_MONTH`, `SUBSCRIPTION_TERM_ONE_YEAR`, `SUBSCRIPTION_TERM_THREE_YEARS`, `SUBSCRIPTION_TERM_THREE_MONTHS`, `SUBSCRIPTION_TERM_FOURTEEN_DAYS`, `SUBSCRIPTION_TERM_CUSTOM`.
        :param pulumi.Input[_builtins.str] subscription_tier: Subscription tier information for the license config.
               Possible values are: `SUBSCRIPTION_TIER_UNSPECIFIED`, `SUBSCRIPTION_TIER_SEARCH`, `SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT`, `SUBSCRIPTION_TIER_NOTEBOOK_LM`, `SUBSCRIPTION_TIER_FRONTLINE_WORKER`, `SUBSCRIPTION_TIER_AGENTSPACE_STARTER`, `SUBSCRIPTION_TIER_AGENTSPACE_BUSINESS`, `SUBSCRIPTION_TIER_ENTERPRISE`, `SUBSCRIPTION_TIER_EDU`, `SUBSCRIPTION_TIER_EDU_PRO`.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if free_trial is not None:
            pulumi.set(__self__, "free_trial", free_trial)
        if license_config_id is not None:
            pulumi.set(__self__, "license_config_id", license_config_id)
        if license_count is not None:
            pulumi.set(__self__, "license_count", license_count)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if subscription_term is not None:
            pulumi.set(__self__, "subscription_term", subscription_term)
        if subscription_tier is not None:
            pulumi.set(__self__, "subscription_tier", subscription_tier)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the license config should be auto renewed when it reaches the end date.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[pulumi.Input['LicenseConfigEndDateArgs']]:
        """
        The planned end date.
        Structure is documented below.
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: Optional[pulumi.Input['LicenseConfigEndDateArgs']]):
        pulumi.set(self, "end_date", value)

    @_builtins.property
    @pulumi.getter(name="freeTrial")
    def free_trial(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the license config is for free trial.
        """
        return pulumi.get(self, "free_trial")

    @free_trial.setter
    def free_trial(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "free_trial", value)

    @_builtins.property
    @pulumi.getter(name="licenseConfigId")
    def license_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the license config.
        """
        return pulumi.get(self, "license_config_id")

    @license_config_id.setter
    def license_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_config_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseCount")
    def license_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of licenses purchased.
        """
        return pulumi.get(self, "license_count")

    @license_count.setter
    def license_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "license_count", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique full resource name of the license config. Values are of the format
        `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input['LicenseConfigStartDateArgs']]:
        """
        The start date.
        Structure is documented below.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input['LicenseConfigStartDateArgs']]):
        pulumi.set(self, "start_date", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionTerm")
    def subscription_term(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription term.
        Possible values are: `SUBSCRIPTION_TERM_UNSPECIFIED`, `SUBSCRIPTION_TERM_ONE_MONTH`, `SUBSCRIPTION_TERM_ONE_YEAR`, `SUBSCRIPTION_TERM_THREE_YEARS`, `SUBSCRIPTION_TERM_THREE_MONTHS`, `SUBSCRIPTION_TERM_FOURTEEN_DAYS`, `SUBSCRIPTION_TERM_CUSTOM`.
        """
        return pulumi.get(self, "subscription_term")

    @subscription_term.setter
    def subscription_term(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_term", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionTier")
    def subscription_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription tier information for the license config.
        Possible values are: `SUBSCRIPTION_TIER_UNSPECIFIED`, `SUBSCRIPTION_TIER_SEARCH`, `SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT`, `SUBSCRIPTION_TIER_NOTEBOOK_LM`, `SUBSCRIPTION_TIER_FRONTLINE_WORKER`, `SUBSCRIPTION_TIER_AGENTSPACE_STARTER`, `SUBSCRIPTION_TIER_AGENTSPACE_BUSINESS`, `SUBSCRIPTION_TIER_ENTERPRISE`, `SUBSCRIPTION_TIER_EDU`, `SUBSCRIPTION_TIER_EDU_PRO`.
        """
        return pulumi.get(self, "subscription_tier")

    @subscription_tier.setter
    def subscription_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_tier", value)


@pulumi.type_token("gcp:discoveryengine/licenseConfig:LicenseConfig")
class LicenseConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_date: Optional[pulumi.Input[Union['LicenseConfigEndDateArgs', 'LicenseConfigEndDateArgsDict']]] = None,
                 free_trial: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_count: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 start_date: Optional[pulumi.Input[Union['LicenseConfigStartDateArgs', 'LicenseConfigStartDateArgsDict']]] = None,
                 subscription_term: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        License Configuration.

        To get more information about LicenseConfig, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.licenseConfigs)

        ## Example Usage

        ### Discoveryengine Licenseconfig Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.LicenseConfig("basic",
            location="global",
            license_config_id="license-config-id",
            license_count=50,
            subscription_tier="SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT",
            start_date={
                "year": 2099,
                "month": 1,
                "day": 1,
            },
            end_date={
                "year": 2100,
                "month": 1,
                "day": 1,
            },
            subscription_term="SUBSCRIPTION_TERM_ONE_YEAR")
        ```

        ## Import

        LicenseConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/licenseConfigs/{{license_config_id}}`

        * `{{project}}/{{location}}/{{license_config_id}}`

        * `{{location}}/{{license_config_id}}`

        When using the `pulumi import` command, LicenseConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/licenseConfig:LicenseConfig default projects/{{project}}/locations/{{location}}/licenseConfigs/{{license_config_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/licenseConfig:LicenseConfig default {{project}}/{{location}}/{{license_config_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/licenseConfig:LicenseConfig default {{location}}/{{license_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether the license config should be auto renewed when it reaches the end date.
        :param pulumi.Input[Union['LicenseConfigEndDateArgs', 'LicenseConfigEndDateArgsDict']] end_date: The planned end date.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] free_trial: Whether the license config is for free trial.
        :param pulumi.Input[_builtins.str] license_config_id: The unique id of the license config.
        :param pulumi.Input[_builtins.int] license_count: Number of licenses purchased.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['LicenseConfigStartDateArgs', 'LicenseConfigStartDateArgsDict']] start_date: The start date.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] subscription_term: Subscription term.
               Possible values are: `SUBSCRIPTION_TERM_UNSPECIFIED`, `SUBSCRIPTION_TERM_ONE_MONTH`, `SUBSCRIPTION_TERM_ONE_YEAR`, `SUBSCRIPTION_TERM_THREE_YEARS`, `SUBSCRIPTION_TERM_THREE_MONTHS`, `SUBSCRIPTION_TERM_FOURTEEN_DAYS`, `SUBSCRIPTION_TERM_CUSTOM`.
        :param pulumi.Input[_builtins.str] subscription_tier: Subscription tier information for the license config.
               Possible values are: `SUBSCRIPTION_TIER_UNSPECIFIED`, `SUBSCRIPTION_TIER_SEARCH`, `SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT`, `SUBSCRIPTION_TIER_NOTEBOOK_LM`, `SUBSCRIPTION_TIER_FRONTLINE_WORKER`, `SUBSCRIPTION_TIER_AGENTSPACE_STARTER`, `SUBSCRIPTION_TIER_AGENTSPACE_BUSINESS`, `SUBSCRIPTION_TIER_ENTERPRISE`, `SUBSCRIPTION_TIER_EDU`, `SUBSCRIPTION_TIER_EDU_PRO`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LicenseConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        License Configuration.

        To get more information about LicenseConfig, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.licenseConfigs)

        ## Example Usage

        ### Discoveryengine Licenseconfig Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.LicenseConfig("basic",
            location="global",
            license_config_id="license-config-id",
            license_count=50,
            subscription_tier="SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT",
            start_date={
                "year": 2099,
                "month": 1,
                "day": 1,
            },
            end_date={
                "year": 2100,
                "month": 1,
                "day": 1,
            },
            subscription_term="SUBSCRIPTION_TERM_ONE_YEAR")
        ```

        ## Import

        LicenseConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/licenseConfigs/{{license_config_id}}`

        * `{{project}}/{{location}}/{{license_config_id}}`

        * `{{location}}/{{license_config_id}}`

        When using the `pulumi import` command, LicenseConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/licenseConfig:LicenseConfig default projects/{{project}}/locations/{{location}}/licenseConfigs/{{license_config_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/licenseConfig:LicenseConfig default {{project}}/{{location}}/{{license_config_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/licenseConfig:LicenseConfig default {{location}}/{{license_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param LicenseConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LicenseConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_date: Optional[pulumi.Input[Union['LicenseConfigEndDateArgs', 'LicenseConfigEndDateArgsDict']]] = None,
                 free_trial: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_count: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 start_date: Optional[pulumi.Input[Union['LicenseConfigStartDateArgs', 'LicenseConfigStartDateArgsDict']]] = None,
                 subscription_term: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LicenseConfigArgs.__new__(LicenseConfigArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["end_date"] = end_date
            __props__.__dict__["free_trial"] = free_trial
            if license_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'license_config_id'")
            __props__.__dict__["license_config_id"] = license_config_id
            if license_count is None and not opts.urn:
                raise TypeError("Missing required property 'license_count'")
            __props__.__dict__["license_count"] = license_count
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if start_date is None and not opts.urn:
                raise TypeError("Missing required property 'start_date'")
            __props__.__dict__["start_date"] = start_date
            if subscription_term is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_term'")
            __props__.__dict__["subscription_term"] = subscription_term
            if subscription_tier is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_tier'")
            __props__.__dict__["subscription_tier"] = subscription_tier
            __props__.__dict__["name"] = None
        super(LicenseConfig, __self__).__init__(
            'gcp:discoveryengine/licenseConfig:LicenseConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            end_date: Optional[pulumi.Input[Union['LicenseConfigEndDateArgs', 'LicenseConfigEndDateArgsDict']]] = None,
            free_trial: Optional[pulumi.Input[_builtins.bool]] = None,
            license_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            license_count: Optional[pulumi.Input[_builtins.int]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            start_date: Optional[pulumi.Input[Union['LicenseConfigStartDateArgs', 'LicenseConfigStartDateArgsDict']]] = None,
            subscription_term: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_tier: Optional[pulumi.Input[_builtins.str]] = None) -> 'LicenseConfig':
        """
        Get an existing LicenseConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether the license config should be auto renewed when it reaches the end date.
        :param pulumi.Input[Union['LicenseConfigEndDateArgs', 'LicenseConfigEndDateArgsDict']] end_date: The planned end date.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] free_trial: Whether the license config is for free trial.
        :param pulumi.Input[_builtins.str] license_config_id: The unique id of the license config.
        :param pulumi.Input[_builtins.int] license_count: Number of licenses purchased.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the license config. Values are of the format
               `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['LicenseConfigStartDateArgs', 'LicenseConfigStartDateArgsDict']] start_date: The start date.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] subscription_term: Subscription term.
               Possible values are: `SUBSCRIPTION_TERM_UNSPECIFIED`, `SUBSCRIPTION_TERM_ONE_MONTH`, `SUBSCRIPTION_TERM_ONE_YEAR`, `SUBSCRIPTION_TERM_THREE_YEARS`, `SUBSCRIPTION_TERM_THREE_MONTHS`, `SUBSCRIPTION_TERM_FOURTEEN_DAYS`, `SUBSCRIPTION_TERM_CUSTOM`.
        :param pulumi.Input[_builtins.str] subscription_tier: Subscription tier information for the license config.
               Possible values are: `SUBSCRIPTION_TIER_UNSPECIFIED`, `SUBSCRIPTION_TIER_SEARCH`, `SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT`, `SUBSCRIPTION_TIER_NOTEBOOK_LM`, `SUBSCRIPTION_TIER_FRONTLINE_WORKER`, `SUBSCRIPTION_TIER_AGENTSPACE_STARTER`, `SUBSCRIPTION_TIER_AGENTSPACE_BUSINESS`, `SUBSCRIPTION_TIER_ENTERPRISE`, `SUBSCRIPTION_TIER_EDU`, `SUBSCRIPTION_TIER_EDU_PRO`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LicenseConfigState.__new__(_LicenseConfigState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["end_date"] = end_date
        __props__.__dict__["free_trial"] = free_trial
        __props__.__dict__["license_config_id"] = license_config_id
        __props__.__dict__["license_count"] = license_count
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["start_date"] = start_date
        __props__.__dict__["subscription_term"] = subscription_term
        __props__.__dict__["subscription_tier"] = subscription_tier
        return LicenseConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the license config should be auto renewed when it reaches the end date.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Output[Optional['outputs.LicenseConfigEndDate']]:
        """
        The planned end date.
        Structure is documented below.
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="freeTrial")
    def free_trial(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the license config is for free trial.
        """
        return pulumi.get(self, "free_trial")

    @_builtins.property
    @pulumi.getter(name="licenseConfigId")
    def license_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique id of the license config.
        """
        return pulumi.get(self, "license_config_id")

    @_builtins.property
    @pulumi.getter(name="licenseCount")
    def license_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of licenses purchased.
        """
        return pulumi.get(self, "license_count")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique full resource name of the license config. Values are of the format
        `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output['outputs.LicenseConfigStartDate']:
        """
        The start date.
        Structure is documented below.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter(name="subscriptionTerm")
    def subscription_term(self) -> pulumi.Output[_builtins.str]:
        """
        Subscription term.
        Possible values are: `SUBSCRIPTION_TERM_UNSPECIFIED`, `SUBSCRIPTION_TERM_ONE_MONTH`, `SUBSCRIPTION_TERM_ONE_YEAR`, `SUBSCRIPTION_TERM_THREE_YEARS`, `SUBSCRIPTION_TERM_THREE_MONTHS`, `SUBSCRIPTION_TERM_FOURTEEN_DAYS`, `SUBSCRIPTION_TERM_CUSTOM`.
        """
        return pulumi.get(self, "subscription_term")

    @_builtins.property
    @pulumi.getter(name="subscriptionTier")
    def subscription_tier(self) -> pulumi.Output[_builtins.str]:
        """
        Subscription tier information for the license config.
        Possible values are: `SUBSCRIPTION_TIER_UNSPECIFIED`, `SUBSCRIPTION_TIER_SEARCH`, `SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT`, `SUBSCRIPTION_TIER_NOTEBOOK_LM`, `SUBSCRIPTION_TIER_FRONTLINE_WORKER`, `SUBSCRIPTION_TIER_AGENTSPACE_STARTER`, `SUBSCRIPTION_TIER_AGENTSPACE_BUSINESS`, `SUBSCRIPTION_TIER_ENTERPRISE`, `SUBSCRIPTION_TIER_EDU`, `SUBSCRIPTION_TIER_EDU_PRO`.
        """
        return pulumi.get(self, "subscription_tier")

