# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserStoreArgs', 'UserStore']

@pulumi.input_type
class UserStoreArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 default_license_config: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_expired_license_auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_license_auto_register: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 user_store_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserStore resource.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] default_license_config: The resource name of the default license config assigned to users created in
               this user store. Format:
               `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
               If `enableLicenseAutoRegister` is true, new users will automatically
               register under the default subscription.
               If the default license config doesn't have remaining license seats left,
               new users will not be assigned with license.
        :param pulumi.Input[_builtins.bool] enable_expired_license_auto_update: Whether to enable automatic license update for users with expired licenses
               in this user store. If enabled, users with expired licenses will
               automatically be updated to the default subscription if there are
               remaining license seats.
        :param pulumi.Input[_builtins.bool] enable_license_auto_register: Whether to enable automatic license registration for new users created in
               this user store. If enabled, new users will automatically register under
               the default subscription.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] user_store_id: The ID of the user store. Currently only accepts "default_user_store".
        """
        pulumi.set(__self__, "location", location)
        if default_license_config is not None:
            pulumi.set(__self__, "default_license_config", default_license_config)
        if enable_expired_license_auto_update is not None:
            pulumi.set(__self__, "enable_expired_license_auto_update", enable_expired_license_auto_update)
        if enable_license_auto_register is not None:
            pulumi.set(__self__, "enable_license_auto_register", enable_license_auto_register)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if user_store_id is not None:
            pulumi.set(__self__, "user_store_id", user_store_id)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="defaultLicenseConfig")
    def default_license_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the default license config assigned to users created in
        this user store. Format:
        `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
        If `enableLicenseAutoRegister` is true, new users will automatically
        register under the default subscription.
        If the default license config doesn't have remaining license seats left,
        new users will not be assigned with license.
        """
        return pulumi.get(self, "default_license_config")

    @default_license_config.setter
    def default_license_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_license_config", value)

    @_builtins.property
    @pulumi.getter(name="enableExpiredLicenseAutoUpdate")
    def enable_expired_license_auto_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic license update for users with expired licenses
        in this user store. If enabled, users with expired licenses will
        automatically be updated to the default subscription if there are
        remaining license seats.
        """
        return pulumi.get(self, "enable_expired_license_auto_update")

    @enable_expired_license_auto_update.setter
    def enable_expired_license_auto_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_expired_license_auto_update", value)

    @_builtins.property
    @pulumi.getter(name="enableLicenseAutoRegister")
    def enable_license_auto_register(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic license registration for new users created in
        this user store. If enabled, new users will automatically register under
        the default subscription.
        """
        return pulumi.get(self, "enable_license_auto_register")

    @enable_license_auto_register.setter
    def enable_license_auto_register(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_license_auto_register", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="userStoreId")
    def user_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the user store. Currently only accepts "default_user_store".
        """
        return pulumi.get(self, "user_store_id")

    @user_store_id.setter
    def user_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_store_id", value)


@pulumi.input_type
class _UserStoreState:
    def __init__(__self__, *,
                 default_license_config: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_expired_license_auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_license_auto_register: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 user_store_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserStore resources.
        :param pulumi.Input[_builtins.str] default_license_config: The resource name of the default license config assigned to users created in
               this user store. Format:
               `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
               If `enableLicenseAutoRegister` is true, new users will automatically
               register under the default subscription.
               If the default license config doesn't have remaining license seats left,
               new users will not be assigned with license.
        :param pulumi.Input[_builtins.bool] enable_expired_license_auto_update: Whether to enable automatic license update for users with expired licenses
               in this user store. If enabled, users with expired licenses will
               automatically be updated to the default subscription if there are
               remaining license seats.
        :param pulumi.Input[_builtins.bool] enable_license_auto_register: Whether to enable automatic license registration for new users created in
               this user store. If enabled, new users will automatically register under
               the default subscription.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the user store. Values are of the format
               `projects/{project}/locations/{location}/userStores/{user_store_id}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] user_store_id: The ID of the user store. Currently only accepts "default_user_store".
        """
        if default_license_config is not None:
            pulumi.set(__self__, "default_license_config", default_license_config)
        if enable_expired_license_auto_update is not None:
            pulumi.set(__self__, "enable_expired_license_auto_update", enable_expired_license_auto_update)
        if enable_license_auto_register is not None:
            pulumi.set(__self__, "enable_license_auto_register", enable_license_auto_register)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if user_store_id is not None:
            pulumi.set(__self__, "user_store_id", user_store_id)

    @_builtins.property
    @pulumi.getter(name="defaultLicenseConfig")
    def default_license_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the default license config assigned to users created in
        this user store. Format:
        `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
        If `enableLicenseAutoRegister` is true, new users will automatically
        register under the default subscription.
        If the default license config doesn't have remaining license seats left,
        new users will not be assigned with license.
        """
        return pulumi.get(self, "default_license_config")

    @default_license_config.setter
    def default_license_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_license_config", value)

    @_builtins.property
    @pulumi.getter(name="enableExpiredLicenseAutoUpdate")
    def enable_expired_license_auto_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic license update for users with expired licenses
        in this user store. If enabled, users with expired licenses will
        automatically be updated to the default subscription if there are
        remaining license seats.
        """
        return pulumi.get(self, "enable_expired_license_auto_update")

    @enable_expired_license_auto_update.setter
    def enable_expired_license_auto_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_expired_license_auto_update", value)

    @_builtins.property
    @pulumi.getter(name="enableLicenseAutoRegister")
    def enable_license_auto_register(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic license registration for new users created in
        this user store. If enabled, new users will automatically register under
        the default subscription.
        """
        return pulumi.get(self, "enable_license_auto_register")

    @enable_license_auto_register.setter
    def enable_license_auto_register(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_license_auto_register", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique full resource name of the user store. Values are of the format
        `projects/{project}/locations/{location}/userStores/{user_store_id}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="userStoreId")
    def user_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the user store. Currently only accepts "default_user_store".
        """
        return pulumi.get(self, "user_store_id")

    @user_store_id.setter
    def user_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_store_id", value)


@pulumi.type_token("gcp:discoveryengine/userStore:UserStore")
class UserStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_license_config: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_expired_license_auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_license_auto_register: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 user_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a user store.

        To get more information about UserStore, see:

        * [API documentation](https://cloud.google.com/gemini/enterprise/docs/reference/rest/v1/projects.locations.userStores)

        ## Example Usage

        ### Discoveryengine Userstore Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.LicenseConfig("basic",
            location="us",
            license_config_id="license-config-id",
            license_count=50,
            subscription_tier="SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT",
            start_date={
                "year": 2099,
                "month": 1,
                "day": 1,
            },
            end_date={
                "year": 2100,
                "month": 1,
                "day": 1,
            },
            subscription_term="SUBSCRIPTION_TERM_ONE_YEAR")
        project = gcp.organizations.get_project()
        basic_user_store = gcp.discoveryengine.UserStore("basic",
            location=basic.location,
            default_license_config=pulumi.Output.all(
                location=basic.location,
                license_config_id=basic.license_config_id
        ).apply(lambda resolved_outputs: f"projects/{project.number}/locations/{resolved_outputs['location']}/licenseConfigs/{resolved_outputs['license_config_id']}")
        ,
            enable_license_auto_register=True)
        ```

        ## Import

        UserStore can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/userStores/{{user_store_id}}`

        * `{{project}}/{{location}}/{{user_store_id}}`

        * `{{location}}/{{user_store_id}}`

        When using the `pulumi import` command, UserStore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/userStore:UserStore default projects/{{project}}/locations/{{location}}/userStores/{{user_store_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/userStore:UserStore default {{project}}/{{location}}/{{user_store_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/userStore:UserStore default {{location}}/{{user_store_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_license_config: The resource name of the default license config assigned to users created in
               this user store. Format:
               `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
               If `enableLicenseAutoRegister` is true, new users will automatically
               register under the default subscription.
               If the default license config doesn't have remaining license seats left,
               new users will not be assigned with license.
        :param pulumi.Input[_builtins.bool] enable_expired_license_auto_update: Whether to enable automatic license update for users with expired licenses
               in this user store. If enabled, users with expired licenses will
               automatically be updated to the default subscription if there are
               remaining license seats.
        :param pulumi.Input[_builtins.bool] enable_license_auto_register: Whether to enable automatic license registration for new users created in
               this user store. If enabled, new users will automatically register under
               the default subscription.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] user_store_id: The ID of the user store. Currently only accepts "default_user_store".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a user store.

        To get more information about UserStore, see:

        * [API documentation](https://cloud.google.com/gemini/enterprise/docs/reference/rest/v1/projects.locations.userStores)

        ## Example Usage

        ### Discoveryengine Userstore Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.LicenseConfig("basic",
            location="us",
            license_config_id="license-config-id",
            license_count=50,
            subscription_tier="SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT",
            start_date={
                "year": 2099,
                "month": 1,
                "day": 1,
            },
            end_date={
                "year": 2100,
                "month": 1,
                "day": 1,
            },
            subscription_term="SUBSCRIPTION_TERM_ONE_YEAR")
        project = gcp.organizations.get_project()
        basic_user_store = gcp.discoveryengine.UserStore("basic",
            location=basic.location,
            default_license_config=pulumi.Output.all(
                location=basic.location,
                license_config_id=basic.license_config_id
        ).apply(lambda resolved_outputs: f"projects/{project.number}/locations/{resolved_outputs['location']}/licenseConfigs/{resolved_outputs['license_config_id']}")
        ,
            enable_license_auto_register=True)
        ```

        ## Import

        UserStore can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/userStores/{{user_store_id}}`

        * `{{project}}/{{location}}/{{user_store_id}}`

        * `{{location}}/{{user_store_id}}`

        When using the `pulumi import` command, UserStore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/userStore:UserStore default projects/{{project}}/locations/{{location}}/userStores/{{user_store_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/userStore:UserStore default {{project}}/{{location}}/{{user_store_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/userStore:UserStore default {{location}}/{{user_store_id}}
        ```

        :param str resource_name: The name of the resource.
        :param UserStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_license_config: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_expired_license_auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_license_auto_register: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 user_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserStoreArgs.__new__(UserStoreArgs)

            __props__.__dict__["default_license_config"] = default_license_config
            __props__.__dict__["enable_expired_license_auto_update"] = enable_expired_license_auto_update
            __props__.__dict__["enable_license_auto_register"] = enable_license_auto_register
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["user_store_id"] = user_store_id
            __props__.__dict__["name"] = None
        super(UserStore, __self__).__init__(
            'gcp:discoveryengine/userStore:UserStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_license_config: Optional[pulumi.Input[_builtins.str]] = None,
            enable_expired_license_auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_license_auto_register: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            user_store_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserStore':
        """
        Get an existing UserStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_license_config: The resource name of the default license config assigned to users created in
               this user store. Format:
               `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
               If `enableLicenseAutoRegister` is true, new users will automatically
               register under the default subscription.
               If the default license config doesn't have remaining license seats left,
               new users will not be assigned with license.
        :param pulumi.Input[_builtins.bool] enable_expired_license_auto_update: Whether to enable automatic license update for users with expired licenses
               in this user store. If enabled, users with expired licenses will
               automatically be updated to the default subscription if there are
               remaining license seats.
        :param pulumi.Input[_builtins.bool] enable_license_auto_register: Whether to enable automatic license registration for new users created in
               this user store. If enabled, new users will automatically register under
               the default subscription.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the user store. Values are of the format
               `projects/{project}/locations/{location}/userStores/{user_store_id}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] user_store_id: The ID of the user store. Currently only accepts "default_user_store".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserStoreState.__new__(_UserStoreState)

        __props__.__dict__["default_license_config"] = default_license_config
        __props__.__dict__["enable_expired_license_auto_update"] = enable_expired_license_auto_update
        __props__.__dict__["enable_license_auto_register"] = enable_license_auto_register
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["user_store_id"] = user_store_id
        return UserStore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultLicenseConfig")
    def default_license_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource name of the default license config assigned to users created in
        this user store. Format:
        `projects/{project}/locations/{location}/licenseConfigs/{license_config}`.
        If `enableLicenseAutoRegister` is true, new users will automatically
        register under the default subscription.
        If the default license config doesn't have remaining license seats left,
        new users will not be assigned with license.
        """
        return pulumi.get(self, "default_license_config")

    @_builtins.property
    @pulumi.getter(name="enableExpiredLicenseAutoUpdate")
    def enable_expired_license_auto_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable automatic license update for users with expired licenses
        in this user store. If enabled, users with expired licenses will
        automatically be updated to the default subscription if there are
        remaining license seats.
        """
        return pulumi.get(self, "enable_expired_license_auto_update")

    @_builtins.property
    @pulumi.getter(name="enableLicenseAutoRegister")
    def enable_license_auto_register(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable automatic license registration for new users created in
        this user store. If enabled, new users will automatically register under
        the default subscription.
        """
        return pulumi.get(self, "enable_license_auto_register")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique full resource name of the user store. Values are of the format
        `projects/{project}/locations/{location}/userStores/{user_store_id}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="userStoreId")
    def user_store_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the user store. Currently only accepts "default_user_store".
        """
        return pulumi.get(self, "user_store_id")

