# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MessageBusArgs', 'MessageBus']

@pulumi.input_type
class MessageBusArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 message_bus_id: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging_config: Optional[pulumi.Input['MessageBusLoggingConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MessageBus resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] message_bus_id: Required. The user-provided ID to be assigned to the MessageBus. It should match the
               format `^a-z?$`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. Resource annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to
               encrypt/decrypt their event data.
               It must match the pattern
               `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[_builtins.str] display_name: Optional. Resource display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['MessageBusLoggingConfigArgs'] logging_config: The configuration for Platform Telemetry logging for Eventarc Advanced
               resources.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "message_bus_id", message_bus_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="messageBusId")
    def message_bus_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The user-provided ID to be assigned to the MessageBus. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "message_bus_id")

    @message_bus_id.setter
    def message_bus_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "message_bus_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Resource annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to
        encrypt/decrypt their event data.
        It must match the pattern
        `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_key_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['MessageBusLoggingConfigArgs']]:
        """
        The configuration for Platform Telemetry logging for Eventarc Advanced
        resources.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['MessageBusLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _MessageBusState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['MessageBusLoggingConfigArgs']] = None,
                 message_bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MessageBus resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. Resource annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: Output only. The creation time.
        :param pulumi.Input[_builtins.str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to
               encrypt/decrypt their event data.
               It must match the pattern
               `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[_builtins.str] display_name: Optional. Resource display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Output only. This checksum is computed by the server based on the value of other
               fields, and might be sent only on update and delete requests to ensure that
               the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['MessageBusLoggingConfigArgs'] logging_config: The configuration for Platform Telemetry logging for Eventarc Advanced
               resources.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] message_bus_id: Required. The user-provided ID to be assigned to the MessageBus. It should match the
               format `^a-z?$`.
        :param pulumi.Input[_builtins.str] name: Identifier. Resource name of the form
               projects/{project}/locations/{location}/messageBuses/{message_bus}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] uid: Output only. Server assigned unique identifier for the channel. The value is a UUID4
               string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: Output only. The last-modified time.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if message_bus_id is not None:
            pulumi.set(__self__, "message_bus_id", message_bus_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Resource annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to
        encrypt/decrypt their event data.
        It must match the pattern
        `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_key_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. This checksum is computed by the server based on the value of other
        fields, and might be sent only on update and delete requests to ensure that
        the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['MessageBusLoggingConfigArgs']]:
        """
        The configuration for Platform Telemetry logging for Eventarc Advanced
        resources.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['MessageBusLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter(name="messageBusId")
    def message_bus_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The user-provided ID to be assigned to the MessageBus. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "message_bus_id")

    @message_bus_id.setter
    def message_bus_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_bus_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Resource name of the form
        projects/{project}/locations/{location}/messageBuses/{message_bus}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Server assigned unique identifier for the channel. The value is a UUID4
        string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:eventarc/messageBus:MessageBus")
class MessageBus(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['MessageBusLoggingConfigArgs', 'MessageBusLoggingConfigArgsDict']]] = None,
                 message_bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The Eventarc MessageBus resource

        To get more information about MessageBus, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.messageBuses)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/advanced/docs/publish-events/create-bus)

        ## Example Usage

        ### Eventarc Message Bus With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project(project_id="my-project-name")
        test_key_ring = gcp.kms.get_kms_key_ring(name="keyring",
            location="us-central1")
        key = gcp.kms.get_kms_crypto_key(name="key",
            key_ring=test_key_ring.id)
        key_member = gcp.kms.CryptoKeyIAMMember("key_member",
            crypto_key_id=key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{test_project.number}@gcp-sa-eventarc.iam.gserviceaccount.com")
        primary = gcp.eventarc.MessageBus("primary",
            location="us-central1",
            message_bus_id="some-message-bus",
            crypto_key_name=key.id,
            opts = pulumi.ResourceOptions(depends_on=[key_member]))
        ```

        ## Import

        MessageBus can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/messageBuses/{{message_bus_id}}`

        * `{{project}}/{{location}}/{{message_bus_id}}`

        * `{{location}}/{{message_bus_id}}`

        When using the `pulumi import` command, MessageBus can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/messageBus:MessageBus default projects/{{project}}/locations/{{location}}/messageBuses/{{message_bus_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/messageBus:MessageBus default {{project}}/{{location}}/{{message_bus_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/messageBus:MessageBus default {{location}}/{{message_bus_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. Resource annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to
               encrypt/decrypt their event data.
               It must match the pattern
               `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[_builtins.str] display_name: Optional. Resource display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['MessageBusLoggingConfigArgs', 'MessageBusLoggingConfigArgsDict']] logging_config: The configuration for Platform Telemetry logging for Eventarc Advanced
               resources.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] message_bus_id: Required. The user-provided ID to be assigned to the MessageBus. It should match the
               format `^a-z?$`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MessageBusArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Eventarc MessageBus resource

        To get more information about MessageBus, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.messageBuses)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/advanced/docs/publish-events/create-bus)

        ## Example Usage

        ### Eventarc Message Bus With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project(project_id="my-project-name")
        test_key_ring = gcp.kms.get_kms_key_ring(name="keyring",
            location="us-central1")
        key = gcp.kms.get_kms_crypto_key(name="key",
            key_ring=test_key_ring.id)
        key_member = gcp.kms.CryptoKeyIAMMember("key_member",
            crypto_key_id=key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{test_project.number}@gcp-sa-eventarc.iam.gserviceaccount.com")
        primary = gcp.eventarc.MessageBus("primary",
            location="us-central1",
            message_bus_id="some-message-bus",
            crypto_key_name=key.id,
            opts = pulumi.ResourceOptions(depends_on=[key_member]))
        ```

        ## Import

        MessageBus can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/messageBuses/{{message_bus_id}}`

        * `{{project}}/{{location}}/{{message_bus_id}}`

        * `{{location}}/{{message_bus_id}}`

        When using the `pulumi import` command, MessageBus can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/messageBus:MessageBus default projects/{{project}}/locations/{{location}}/messageBuses/{{message_bus_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/messageBus:MessageBus default {{project}}/{{location}}/{{message_bus_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/messageBus:MessageBus default {{location}}/{{message_bus_id}}
        ```

        :param str resource_name: The name of the resource.
        :param MessageBusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MessageBusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['MessageBusLoggingConfigArgs', 'MessageBusLoggingConfigArgsDict']]] = None,
                 message_bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MessageBusArgs.__new__(MessageBusArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["crypto_key_name"] = crypto_key_name
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["logging_config"] = logging_config
            if message_bus_id is None and not opts.urn:
                raise TypeError("Missing required property 'message_bus_id'")
            __props__.__dict__["message_bus_id"] = message_bus_id
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MessageBus, __self__).__init__(
            'gcp:eventarc/messageBus:MessageBus',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logging_config: Optional[pulumi.Input[Union['MessageBusLoggingConfigArgs', 'MessageBusLoggingConfigArgsDict']]] = None,
            message_bus_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'MessageBus':
        """
        Get an existing MessageBus resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. Resource annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: Output only. The creation time.
        :param pulumi.Input[_builtins.str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to
               encrypt/decrypt their event data.
               It must match the pattern
               `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[_builtins.str] display_name: Optional. Resource display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Output only. This checksum is computed by the server based on the value of other
               fields, and might be sent only on update and delete requests to ensure that
               the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['MessageBusLoggingConfigArgs', 'MessageBusLoggingConfigArgsDict']] logging_config: The configuration for Platform Telemetry logging for Eventarc Advanced
               resources.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] message_bus_id: Required. The user-provided ID to be assigned to the MessageBus. It should match the
               format `^a-z?$`.
        :param pulumi.Input[_builtins.str] name: Identifier. Resource name of the form
               projects/{project}/locations/{location}/messageBuses/{message_bus}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] uid: Output only. Server assigned unique identifier for the channel. The value is a UUID4
               string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: Output only. The last-modified time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MessageBusState.__new__(_MessageBusState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["crypto_key_name"] = crypto_key_name
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["message_bus_id"] = message_bus_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return MessageBus(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Resource annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to
        encrypt/decrypt their event data.
        It must match the pattern
        `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Resource display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. This checksum is computed by the server based on the value of other
        fields, and might be sent only on update and delete requests to ensure that
        the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output['outputs.MessageBusLoggingConfig']:
        """
        The configuration for Platform Telemetry logging for Eventarc Advanced
        resources.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter(name="messageBusId")
    def message_bus_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The user-provided ID to be assigned to the MessageBus. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "message_bus_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Resource name of the form
        projects/{project}/locations/{location}/messageBuses/{message_bus}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Server assigned unique identifier for the channel. The value is a UUID4
        string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The last-modified time.
        """
        return pulumi.get(self, "update_time")

