# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceDirectoryServices',
    'InstanceDirectoryServicesLdap',
    'InstanceEffectiveReplication',
    'InstanceEffectiveReplicationReplica',
    'InstanceFileShares',
    'InstanceFileSharesNfsExportOption',
    'InstanceInitialReplication',
    'InstanceInitialReplicationReplica',
    'InstanceNetwork',
    'InstanceNetworkPscConfig',
    'InstancePerformanceConfig',
    'InstancePerformanceConfigFixedIops',
    'InstancePerformanceConfigIopsPerTb',
    'GetInstanceDirectoryServiceResult',
    'GetInstanceDirectoryServiceLdapResult',
    'GetInstanceEffectiveReplicationResult',
    'GetInstanceEffectiveReplicationReplicaResult',
    'GetInstanceFileShareResult',
    'GetInstanceFileShareNfsExportOptionResult',
    'GetInstanceInitialReplicationResult',
    'GetInstanceInitialReplicationReplicaResult',
    'GetInstanceNetworkResult',
    'GetInstanceNetworkPscConfigResult',
    'GetInstancePerformanceConfigResult',
    'GetInstancePerformanceConfigFixedIopResult',
    'GetInstancePerformanceConfigIopsPerTbResult',
]

@pulumi.output_type
class InstanceDirectoryServices(dict):
    def __init__(__self__, *,
                 ldap: Optional['outputs.InstanceDirectoryServicesLdap'] = None):
        """
        :param 'InstanceDirectoryServicesLdapArgs' ldap: Configuration for LDAP servers.
               Structure is documented below.
        """
        if ldap is not None:
            pulumi.set(__self__, "ldap", ldap)

    @_builtins.property
    @pulumi.getter
    def ldap(self) -> Optional['outputs.InstanceDirectoryServicesLdap']:
        """
        Configuration for LDAP servers.
        Structure is documented below.
        """
        return pulumi.get(self, "ldap")


@pulumi.output_type
class InstanceDirectoryServicesLdap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupsOu":
            suggest = "groups_ou"
        elif key == "usersOu":
            suggest = "users_ou"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDirectoryServicesLdap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDirectoryServicesLdap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDirectoryServicesLdap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: _builtins.str,
                 servers: Sequence[_builtins.str],
                 groups_ou: Optional[_builtins.str] = None,
                 users_ou: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain: The LDAP domain name in the format of `my-domain.com`.
        :param Sequence[_builtins.str] servers: The servers names are used for specifying the LDAP servers names.
               The LDAP servers names can come with two formats:
               1. DNS name, for example: `ldap.example1.com`, `ldap.example2.com`.
               2. IP address, for example: `10.0.0.1`, `10.0.0.2`, `10.0.0.3`.
               All servers names must be in the same format: either all DNS names or all
               IP addresses.
        :param _builtins.str groups_ou: The groups Organizational Unit (OU) is optional. This parameter is a hint
               to allow faster lookup in the LDAP namespace. In case that this parameter
               is not provided, Filestore instance will query the whole LDAP namespace.
        :param _builtins.str users_ou: The users Organizational Unit (OU) is optional. This parameter is a hint
               to allow faster lookup in the LDAP namespace. In case that this parameter
               is not provided, Filestore instance will query the whole LDAP namespace.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "servers", servers)
        if groups_ou is not None:
            pulumi.set(__self__, "groups_ou", groups_ou)
        if users_ou is not None:
            pulumi.set(__self__, "users_ou", users_ou)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The LDAP domain name in the format of `my-domain.com`.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence[_builtins.str]:
        """
        The servers names are used for specifying the LDAP servers names.
        The LDAP servers names can come with two formats:
        1. DNS name, for example: `ldap.example1.com`, `ldap.example2.com`.
        2. IP address, for example: `10.0.0.1`, `10.0.0.2`, `10.0.0.3`.
        All servers names must be in the same format: either all DNS names or all
        IP addresses.
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter(name="groupsOu")
    def groups_ou(self) -> Optional[_builtins.str]:
        """
        The groups Organizational Unit (OU) is optional. This parameter is a hint
        to allow faster lookup in the LDAP namespace. In case that this parameter
        is not provided, Filestore instance will query the whole LDAP namespace.
        """
        return pulumi.get(self, "groups_ou")

    @_builtins.property
    @pulumi.getter(name="usersOu")
    def users_ou(self) -> Optional[_builtins.str]:
        """
        The users Organizational Unit (OU) is optional. This parameter is a hint
        to allow faster lookup in the LDAP namespace. In case that this parameter
        is not provided, Filestore instance will query the whole LDAP namespace.
        """
        return pulumi.get(self, "users_ou")


@pulumi.output_type
class InstanceEffectiveReplication(dict):
    def __init__(__self__, *,
                 replicas: Optional[Sequence['outputs.InstanceEffectiveReplicationReplica']] = None,
                 role: Optional[_builtins.str] = None):
        """
        :param Sequence['InstanceEffectiveReplicationReplicaArgs'] replicas: The replication role.
               Structure is documented below.
        :param _builtins.str role: (Output)
               The replication role.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[Sequence['outputs.InstanceEffectiveReplicationReplica']]:
        """
        The replication role.
        Structure is documented below.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        (Output)
        The replication role.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class InstanceEffectiveReplicationReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastActiveSyncTime":
            suggest = "last_active_sync_time"
        elif key == "peerInstance":
            suggest = "peer_instance"
        elif key == "stateReasons":
            suggest = "state_reasons"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEffectiveReplicationReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEffectiveReplicationReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEffectiveReplicationReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_active_sync_time: Optional[_builtins.str] = None,
                 peer_instance: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 state_reasons: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str last_active_sync_time: (Output)
               Output only. The timestamp of the latest replication snapshot taken on the active instance and is already replicated safely.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param _builtins.str peer_instance: The peer instance.
        :param _builtins.str state: (Output)
               Output only. The replica state
        :param Sequence[_builtins.str] state_reasons: (Output)
               Output only. Additional information about the replication state, if available.
        """
        if last_active_sync_time is not None:
            pulumi.set(__self__, "last_active_sync_time", last_active_sync_time)
        if peer_instance is not None:
            pulumi.set(__self__, "peer_instance", peer_instance)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_reasons is not None:
            pulumi.set(__self__, "state_reasons", state_reasons)

    @_builtins.property
    @pulumi.getter(name="lastActiveSyncTime")
    def last_active_sync_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The timestamp of the latest replication snapshot taken on the active instance and is already replicated safely.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "last_active_sync_time")

    @_builtins.property
    @pulumi.getter(name="peerInstance")
    def peer_instance(self) -> Optional[_builtins.str]:
        """
        The peer instance.
        """
        return pulumi.get(self, "peer_instance")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The replica state
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateReasons")
    def state_reasons(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Output only. Additional information about the replication state, if available.
        """
        return pulumi.get(self, "state_reasons")


@pulumi.output_type
class InstanceFileShares(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityGb":
            suggest = "capacity_gb"
        elif key == "nfsExportOptions":
            suggest = "nfs_export_options"
        elif key == "sourceBackup":
            suggest = "source_backup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFileShares. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFileShares.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFileShares.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_gb: _builtins.int,
                 name: _builtins.str,
                 nfs_export_options: Optional[Sequence['outputs.InstanceFileSharesNfsExportOption']] = None,
                 source_backup: Optional[_builtins.str] = None):
        """
        :param _builtins.int capacity_gb: File share capacity in GiB. This must be at least 1024 GiB
               for the standard tier, or 2560 GiB for the premium tier.
        :param _builtins.str name: The name of the fileshare (16 characters or less)
        :param Sequence['InstanceFileSharesNfsExportOptionArgs'] nfs_export_options: Nfs Export Options. There is a limit of 10 export options per file share.
               Structure is documented below.
        :param _builtins.str source_backup: The resource name of the backup, in the format
               projects/{projectId}/locations/{locationId}/backups/{backupId},
               that this file share has been restored from.
        """
        pulumi.set(__self__, "capacity_gb", capacity_gb)
        pulumi.set(__self__, "name", name)
        if nfs_export_options is not None:
            pulumi.set(__self__, "nfs_export_options", nfs_export_options)
        if source_backup is not None:
            pulumi.set(__self__, "source_backup", source_backup)

    @_builtins.property
    @pulumi.getter(name="capacityGb")
    def capacity_gb(self) -> _builtins.int:
        """
        File share capacity in GiB. This must be at least 1024 GiB
        for the standard tier, or 2560 GiB for the premium tier.
        """
        return pulumi.get(self, "capacity_gb")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the fileshare (16 characters or less)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsExportOptions")
    def nfs_export_options(self) -> Optional[Sequence['outputs.InstanceFileSharesNfsExportOption']]:
        """
        Nfs Export Options. There is a limit of 10 export options per file share.
        Structure is documented below.
        """
        return pulumi.get(self, "nfs_export_options")

    @_builtins.property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> Optional[_builtins.str]:
        """
        The resource name of the backup, in the format
        projects/{projectId}/locations/{locationId}/backups/{backupId},
        that this file share has been restored from.
        """
        return pulumi.get(self, "source_backup")


@pulumi.output_type
class InstanceFileSharesNfsExportOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "anonGid":
            suggest = "anon_gid"
        elif key == "anonUid":
            suggest = "anon_uid"
        elif key == "ipRanges":
            suggest = "ip_ranges"
        elif key == "squashMode":
            suggest = "squash_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFileSharesNfsExportOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFileSharesNfsExportOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFileSharesNfsExportOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: Optional[_builtins.str] = None,
                 anon_gid: Optional[_builtins.int] = None,
                 anon_uid: Optional[_builtins.int] = None,
                 ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 network: Optional[_builtins.str] = None,
                 squash_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_mode: Either READ_ONLY, for allowing only read requests on the exported directory,
               or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE.
               Default value is `READ_WRITE`.
               Possible values are: `READ_ONLY`, `READ_WRITE`.
        :param _builtins.int anon_gid: An integer representing the anonymous group id with a default value of 65534.
               Anon_gid may only be set with squashMode of ROOT_SQUASH. An error will be returned
               if this field is specified for other squashMode settings.
        :param _builtins.int anon_uid: An integer representing the anonymous user id with a default value of 65534.
               Anon_uid may only be set with squashMode of ROOT_SQUASH. An error will be returned
               if this field is specified for other squashMode settings.
        :param Sequence[_builtins.str] ip_ranges: List of either IPv4 addresses, or ranges in CIDR notation which may mount the file share.
               Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned.
               The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        :param _builtins.str network: The source VPC network for `ip_ranges`.
               Required for instances using Private Service Connect, optional otherwise.
        :param _builtins.str squash_mode: Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH,
               for not allowing root access. The default is NO_ROOT_SQUASH.
               Default value is `NO_ROOT_SQUASH`.
               Possible values are: `NO_ROOT_SQUASH`, `ROOT_SQUASH`.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if anon_gid is not None:
            pulumi.set(__self__, "anon_gid", anon_gid)
        if anon_uid is not None:
            pulumi.set(__self__, "anon_uid", anon_uid)
        if ip_ranges is not None:
            pulumi.set(__self__, "ip_ranges", ip_ranges)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if squash_mode is not None:
            pulumi.set(__self__, "squash_mode", squash_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[_builtins.str]:
        """
        Either READ_ONLY, for allowing only read requests on the exported directory,
        or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE.
        Default value is `READ_WRITE`.
        Possible values are: `READ_ONLY`, `READ_WRITE`.
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="anonGid")
    def anon_gid(self) -> Optional[_builtins.int]:
        """
        An integer representing the anonymous group id with a default value of 65534.
        Anon_gid may only be set with squashMode of ROOT_SQUASH. An error will be returned
        if this field is specified for other squashMode settings.
        """
        return pulumi.get(self, "anon_gid")

    @_builtins.property
    @pulumi.getter(name="anonUid")
    def anon_uid(self) -> Optional[_builtins.int]:
        """
        An integer representing the anonymous user id with a default value of 65534.
        Anon_uid may only be set with squashMode of ROOT_SQUASH. An error will be returned
        if this field is specified for other squashMode settings.
        """
        return pulumi.get(self, "anon_uid")

    @_builtins.property
    @pulumi.getter(name="ipRanges")
    def ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of either IPv4 addresses, or ranges in CIDR notation which may mount the file share.
        Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned.
        The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        """
        return pulumi.get(self, "ip_ranges")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The source VPC network for `ip_ranges`.
        Required for instances using Private Service Connect, optional otherwise.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="squashMode")
    def squash_mode(self) -> Optional[_builtins.str]:
        """
        Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH,
        for not allowing root access. The default is NO_ROOT_SQUASH.
        Default value is `NO_ROOT_SQUASH`.
        Possible values are: `NO_ROOT_SQUASH`, `ROOT_SQUASH`.
        """
        return pulumi.get(self, "squash_mode")


@pulumi.output_type
class InstanceInitialReplication(dict):
    def __init__(__self__, *,
                 replicas: Optional[Sequence['outputs.InstanceInitialReplicationReplica']] = None,
                 role: Optional[_builtins.str] = None):
        """
        :param Sequence['InstanceInitialReplicationReplicaArgs'] replicas: The replication role.
               Structure is documented below.
        :param _builtins.str role: The replication role.
               Default value is `STANDBY`.
               Possible values are: `ROLE_UNSPECIFIED`, `ACTIVE`, `STANDBY`.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[Sequence['outputs.InstanceInitialReplicationReplica']]:
        """
        The replication role.
        Structure is documented below.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The replication role.
        Default value is `STANDBY`.
        Possible values are: `ROLE_UNSPECIFIED`, `ACTIVE`, `STANDBY`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class InstanceInitialReplicationReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peerInstance":
            suggest = "peer_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceInitialReplicationReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceInitialReplicationReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceInitialReplicationReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peer_instance: _builtins.str):
        """
        :param _builtins.str peer_instance: The peer instance.
        """
        pulumi.set(__self__, "peer_instance", peer_instance)

    @_builtins.property
    @pulumi.getter(name="peerInstance")
    def peer_instance(self) -> _builtins.str:
        """
        The peer instance.
        """
        return pulumi.get(self, "peer_instance")


@pulumi.output_type
class InstanceNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectMode":
            suggest = "connect_mode"
        elif key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "pscConfig":
            suggest = "psc_config"
        elif key == "reservedIpRange":
            suggest = "reserved_ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 modes: Sequence[_builtins.str],
                 network: _builtins.str,
                 connect_mode: Optional[_builtins.str] = None,
                 ip_addresses: Optional[Sequence[_builtins.str]] = None,
                 psc_config: Optional['outputs.InstanceNetworkPscConfig'] = None,
                 reserved_ip_range: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] modes: IP versions for which the instance has
               IP addresses assigned.
               Each value may be one of: `ADDRESS_MODE_UNSPECIFIED`, `MODE_IPV4`, `MODE_IPV6`.
        :param _builtins.str network: The name of the GCE VPC network to which the
               instance is connected.
        :param _builtins.str connect_mode: The network connect mode of the Filestore instance.
               If not provided, the connect mode defaults to
               DIRECT_PEERING.
               Default value is `DIRECT_PEERING`.
               Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`, `PRIVATE_SERVICE_CONNECT`.
        :param Sequence[_builtins.str] ip_addresses: (Output)
               A list of IPv4 or IPv6 addresses.
        :param 'InstanceNetworkPscConfigArgs' psc_config: Private Service Connect configuration.
               Should only be set when connect_mode is PRIVATE_SERVICE_CONNECT.
               Structure is documented below.
        :param _builtins.str reserved_ip_range: A /29 CIDR block that identifies the range of IP
               addresses reserved for this instance.
        """
        pulumi.set(__self__, "modes", modes)
        pulumi.set(__self__, "network", network)
        if connect_mode is not None:
            pulumi.set(__self__, "connect_mode", connect_mode)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if psc_config is not None:
            pulumi.set(__self__, "psc_config", psc_config)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)

    @_builtins.property
    @pulumi.getter
    def modes(self) -> Sequence[_builtins.str]:
        """
        IP versions for which the instance has
        IP addresses assigned.
        Each value may be one of: `ADDRESS_MODE_UNSPECIFIED`, `MODE_IPV4`, `MODE_IPV6`.
        """
        return pulumi.get(self, "modes")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The name of the GCE VPC network to which the
        instance is connected.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> Optional[_builtins.str]:
        """
        The network connect mode of the Filestore instance.
        If not provided, the connect mode defaults to
        DIRECT_PEERING.
        Default value is `DIRECT_PEERING`.
        Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`, `PRIVATE_SERVICE_CONNECT`.
        """
        return pulumi.get(self, "connect_mode")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        A list of IPv4 or IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> Optional['outputs.InstanceNetworkPscConfig']:
        """
        Private Service Connect configuration.
        Should only be set when connect_mode is PRIVATE_SERVICE_CONNECT.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @_builtins.property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[_builtins.str]:
        """
        A /29 CIDR block that identifies the range of IP
        addresses reserved for this instance.
        """
        return pulumi.get(self, "reserved_ip_range")


@pulumi.output_type
class InstanceNetworkPscConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointProject":
            suggest = "endpoint_project"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkPscConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkPscConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkPscConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_project: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint_project: Consumer service project in which the Private Service Connect endpoint
               would be set up. This is optional, and only relevant in case the network
               is a shared VPC. If this is not specified, the endpoint would be set up
               in the VPC host project.
        """
        if endpoint_project is not None:
            pulumi.set(__self__, "endpoint_project", endpoint_project)

    @_builtins.property
    @pulumi.getter(name="endpointProject")
    def endpoint_project(self) -> Optional[_builtins.str]:
        """
        Consumer service project in which the Private Service Connect endpoint
        would be set up. This is optional, and only relevant in case the network
        is a shared VPC. If this is not specified, the endpoint would be set up
        in the VPC host project.
        """
        return pulumi.get(self, "endpoint_project")


@pulumi.output_type
class InstancePerformanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedIops":
            suggest = "fixed_iops"
        elif key == "iopsPerTb":
            suggest = "iops_per_tb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePerformanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePerformanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePerformanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_iops: Optional['outputs.InstancePerformanceConfigFixedIops'] = None,
                 iops_per_tb: Optional['outputs.InstancePerformanceConfigIopsPerTb'] = None):
        """
        :param 'InstancePerformanceConfigFixedIopsArgs' fixed_iops: The instance will have a fixed provisioned IOPS value,
               which will remain constant regardless of instance
               capacity.
               Structure is documented below.
        :param 'InstancePerformanceConfigIopsPerTbArgs' iops_per_tb: The instance provisioned IOPS will change dynamically
               based on the capacity of the instance.
               Structure is documented below.
        """
        if fixed_iops is not None:
            pulumi.set(__self__, "fixed_iops", fixed_iops)
        if iops_per_tb is not None:
            pulumi.set(__self__, "iops_per_tb", iops_per_tb)

    @_builtins.property
    @pulumi.getter(name="fixedIops")
    def fixed_iops(self) -> Optional['outputs.InstancePerformanceConfigFixedIops']:
        """
        The instance will have a fixed provisioned IOPS value,
        which will remain constant regardless of instance
        capacity.
        Structure is documented below.
        """
        return pulumi.get(self, "fixed_iops")

    @_builtins.property
    @pulumi.getter(name="iopsPerTb")
    def iops_per_tb(self) -> Optional['outputs.InstancePerformanceConfigIopsPerTb']:
        """
        The instance provisioned IOPS will change dynamically
        based on the capacity of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "iops_per_tb")


@pulumi.output_type
class InstancePerformanceConfigFixedIops(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxIops":
            suggest = "max_iops"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePerformanceConfigFixedIops. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePerformanceConfigFixedIops.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePerformanceConfigFixedIops.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_iops: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_iops: The number of IOPS to provision for the instance.
               max_iops must be in multiple of 1000.
        """
        if max_iops is not None:
            pulumi.set(__self__, "max_iops", max_iops)

    @_builtins.property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> Optional[_builtins.int]:
        """
        The number of IOPS to provision for the instance.
        max_iops must be in multiple of 1000.
        """
        return pulumi.get(self, "max_iops")


@pulumi.output_type
class InstancePerformanceConfigIopsPerTb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxIopsPerTb":
            suggest = "max_iops_per_tb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePerformanceConfigIopsPerTb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePerformanceConfigIopsPerTb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePerformanceConfigIopsPerTb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_iops_per_tb: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_iops_per_tb: The instance max IOPS will be calculated by multiplying
               the capacity of the instance (TB) by max_iops_per_tb,
               and rounding to the nearest 1000. The instance max IOPS
               will be changed dynamically based on the instance
               capacity.
        """
        if max_iops_per_tb is not None:
            pulumi.set(__self__, "max_iops_per_tb", max_iops_per_tb)

    @_builtins.property
    @pulumi.getter(name="maxIopsPerTb")
    def max_iops_per_tb(self) -> Optional[_builtins.int]:
        """
        The instance max IOPS will be calculated by multiplying
        the capacity of the instance (TB) by max_iops_per_tb,
        and rounding to the nearest 1000. The instance max IOPS
        will be changed dynamically based on the instance
        capacity.
        """
        return pulumi.get(self, "max_iops_per_tb")


@pulumi.output_type
class GetInstanceDirectoryServiceResult(dict):
    def __init__(__self__, *,
                 ldaps: Sequence['outputs.GetInstanceDirectoryServiceLdapResult']):
        """
        :param Sequence['GetInstanceDirectoryServiceLdapArgs'] ldaps: Configuration for LDAP servers.
        """
        pulumi.set(__self__, "ldaps", ldaps)

    @_builtins.property
    @pulumi.getter
    def ldaps(self) -> Sequence['outputs.GetInstanceDirectoryServiceLdapResult']:
        """
        Configuration for LDAP servers.
        """
        return pulumi.get(self, "ldaps")


@pulumi.output_type
class GetInstanceDirectoryServiceLdapResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 groups_ou: _builtins.str,
                 servers: Sequence[_builtins.str],
                 users_ou: _builtins.str):
        """
        :param _builtins.str domain: The LDAP domain name in the format of 'my-domain.com'.
        :param _builtins.str groups_ou: The groups Organizational Unit (OU) is optional. This parameter is a hint
               to allow faster lookup in the LDAP namespace. In case that this parameter
               is not provided, Filestore instance will query the whole LDAP namespace.
        :param Sequence[_builtins.str] servers: The servers names are used for specifying the LDAP servers names.
               The LDAP servers names can come with two formats:
               1. DNS name, for example: 'ldap.example1.com', 'ldap.example2.com'.
               2. IP address, for example: '10.0.0.1', '10.0.0.2', '10.0.0.3'.
               All servers names must be in the same format: either all DNS names or all
               IP addresses.
        :param _builtins.str users_ou: The users Organizational Unit (OU) is optional. This parameter is a hint
               to allow faster lookup in the LDAP namespace. In case that this parameter
               is not provided, Filestore instance will query the whole LDAP namespace.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "groups_ou", groups_ou)
        pulumi.set(__self__, "servers", servers)
        pulumi.set(__self__, "users_ou", users_ou)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The LDAP domain name in the format of 'my-domain.com'.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="groupsOu")
    def groups_ou(self) -> _builtins.str:
        """
        The groups Organizational Unit (OU) is optional. This parameter is a hint
        to allow faster lookup in the LDAP namespace. In case that this parameter
        is not provided, Filestore instance will query the whole LDAP namespace.
        """
        return pulumi.get(self, "groups_ou")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence[_builtins.str]:
        """
        The servers names are used for specifying the LDAP servers names.
        The LDAP servers names can come with two formats:
        1. DNS name, for example: 'ldap.example1.com', 'ldap.example2.com'.
        2. IP address, for example: '10.0.0.1', '10.0.0.2', '10.0.0.3'.
        All servers names must be in the same format: either all DNS names or all
        IP addresses.
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter(name="usersOu")
    def users_ou(self) -> _builtins.str:
        """
        The users Organizational Unit (OU) is optional. This parameter is a hint
        to allow faster lookup in the LDAP namespace. In case that this parameter
        is not provided, Filestore instance will query the whole LDAP namespace.
        """
        return pulumi.get(self, "users_ou")


@pulumi.output_type
class GetInstanceEffectiveReplicationResult(dict):
    def __init__(__self__, *,
                 replicas: Sequence['outputs.GetInstanceEffectiveReplicationReplicaResult'],
                 role: _builtins.str):
        """
        :param Sequence['GetInstanceEffectiveReplicationReplicaArgs'] replicas: The replication role.
        :param _builtins.str role: The replication role.
        """
        pulumi.set(__self__, "replicas", replicas)
        pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetInstanceEffectiveReplicationReplicaResult']:
        """
        The replication role.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The replication role.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetInstanceEffectiveReplicationReplicaResult(dict):
    def __init__(__self__, *,
                 last_active_sync_time: _builtins.str,
                 peer_instance: _builtins.str,
                 state: _builtins.str,
                 state_reasons: Sequence[_builtins.str]):
        """
        :param _builtins.str last_active_sync_time: Output only. The timestamp of the latest replication snapshot taken on the active instance and is already replicated safely.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param _builtins.str peer_instance: The peer instance.
        :param _builtins.str state: Output only. The replica state
        :param Sequence[_builtins.str] state_reasons: Output only. Additional information about the replication state, if available.
        """
        pulumi.set(__self__, "last_active_sync_time", last_active_sync_time)
        pulumi.set(__self__, "peer_instance", peer_instance)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_reasons", state_reasons)

    @_builtins.property
    @pulumi.getter(name="lastActiveSyncTime")
    def last_active_sync_time(self) -> _builtins.str:
        """
        Output only. The timestamp of the latest replication snapshot taken on the active instance and is already replicated safely.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "last_active_sync_time")

    @_builtins.property
    @pulumi.getter(name="peerInstance")
    def peer_instance(self) -> _builtins.str:
        """
        The peer instance.
        """
        return pulumi.get(self, "peer_instance")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Output only. The replica state
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateReasons")
    def state_reasons(self) -> Sequence[_builtins.str]:
        """
        Output only. Additional information about the replication state, if available.
        """
        return pulumi.get(self, "state_reasons")


@pulumi.output_type
class GetInstanceFileShareResult(dict):
    def __init__(__self__, *,
                 capacity_gb: _builtins.int,
                 name: _builtins.str,
                 nfs_export_options: Sequence['outputs.GetInstanceFileShareNfsExportOptionResult'],
                 source_backup: _builtins.str):
        """
        :param _builtins.int capacity_gb: File share capacity in GiB. This must be at least 1024 GiB
               for the standard tier, or 2560 GiB for the premium tier.
        :param _builtins.str name: The name of a Filestore instance.
               
               - - -
        :param Sequence['GetInstanceFileShareNfsExportOptionArgs'] nfs_export_options: Nfs Export Options. There is a limit of 10 export options per file share.
        :param _builtins.str source_backup: The resource name of the backup, in the format
               projects/{projectId}/locations/{locationId}/backups/{backupId},
               that this file share has been restored from.
        """
        pulumi.set(__self__, "capacity_gb", capacity_gb)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs_export_options", nfs_export_options)
        pulumi.set(__self__, "source_backup", source_backup)

    @_builtins.property
    @pulumi.getter(name="capacityGb")
    def capacity_gb(self) -> _builtins.int:
        """
        File share capacity in GiB. This must be at least 1024 GiB
        for the standard tier, or 2560 GiB for the premium tier.
        """
        return pulumi.get(self, "capacity_gb")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of a Filestore instance.

        - - -
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsExportOptions")
    def nfs_export_options(self) -> Sequence['outputs.GetInstanceFileShareNfsExportOptionResult']:
        """
        Nfs Export Options. There is a limit of 10 export options per file share.
        """
        return pulumi.get(self, "nfs_export_options")

    @_builtins.property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> _builtins.str:
        """
        The resource name of the backup, in the format
        projects/{projectId}/locations/{locationId}/backups/{backupId},
        that this file share has been restored from.
        """
        return pulumi.get(self, "source_backup")


@pulumi.output_type
class GetInstanceFileShareNfsExportOptionResult(dict):
    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 anon_gid: _builtins.int,
                 anon_uid: _builtins.int,
                 ip_ranges: Sequence[_builtins.str],
                 network: _builtins.str,
                 squash_mode: _builtins.str):
        """
        :param _builtins.str access_mode: Either READ_ONLY, for allowing only read requests on the exported directory,
               or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"]
        :param _builtins.int anon_gid: An integer representing the anonymous group id with a default value of 65534.
               Anon_gid may only be set with squashMode of ROOT_SQUASH. An error will be returned
               if this field is specified for other squashMode settings.
        :param _builtins.int anon_uid: An integer representing the anonymous user id with a default value of 65534.
               Anon_uid may only be set with squashMode of ROOT_SQUASH. An error will be returned
               if this field is specified for other squashMode settings.
        :param Sequence[_builtins.str] ip_ranges: List of either IPv4 addresses, or ranges in CIDR notation which may mount the file share.
               Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned.
               The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        :param _builtins.str network: The source VPC network for 'ip_ranges'.
               Required for instances using Private Service Connect, optional otherwise.
        :param _builtins.str squash_mode: Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH,
               for not allowing root access. The default is NO_ROOT_SQUASH. Default value: "NO_ROOT_SQUASH" Possible values: ["NO_ROOT_SQUASH", "ROOT_SQUASH"]
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "anon_gid", anon_gid)
        pulumi.set(__self__, "anon_uid", anon_uid)
        pulumi.set(__self__, "ip_ranges", ip_ranges)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "squash_mode", squash_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        Either READ_ONLY, for allowing only read requests on the exported directory,
        or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"]
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="anonGid")
    def anon_gid(self) -> _builtins.int:
        """
        An integer representing the anonymous group id with a default value of 65534.
        Anon_gid may only be set with squashMode of ROOT_SQUASH. An error will be returned
        if this field is specified for other squashMode settings.
        """
        return pulumi.get(self, "anon_gid")

    @_builtins.property
    @pulumi.getter(name="anonUid")
    def anon_uid(self) -> _builtins.int:
        """
        An integer representing the anonymous user id with a default value of 65534.
        Anon_uid may only be set with squashMode of ROOT_SQUASH. An error will be returned
        if this field is specified for other squashMode settings.
        """
        return pulumi.get(self, "anon_uid")

    @_builtins.property
    @pulumi.getter(name="ipRanges")
    def ip_ranges(self) -> Sequence[_builtins.str]:
        """
        List of either IPv4 addresses, or ranges in CIDR notation which may mount the file share.
        Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned.
        The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        """
        return pulumi.get(self, "ip_ranges")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The source VPC network for 'ip_ranges'.
        Required for instances using Private Service Connect, optional otherwise.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="squashMode")
    def squash_mode(self) -> _builtins.str:
        """
        Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH,
        for not allowing root access. The default is NO_ROOT_SQUASH. Default value: "NO_ROOT_SQUASH" Possible values: ["NO_ROOT_SQUASH", "ROOT_SQUASH"]
        """
        return pulumi.get(self, "squash_mode")


@pulumi.output_type
class GetInstanceInitialReplicationResult(dict):
    def __init__(__self__, *,
                 replicas: Sequence['outputs.GetInstanceInitialReplicationReplicaResult'],
                 role: _builtins.str):
        """
        :param Sequence['GetInstanceInitialReplicationReplicaArgs'] replicas: The replication role.
        :param _builtins.str role: The replication role. Default value: "STANDBY" Possible values: ["ROLE_UNSPECIFIED", "ACTIVE", "STANDBY"]
        """
        pulumi.set(__self__, "replicas", replicas)
        pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetInstanceInitialReplicationReplicaResult']:
        """
        The replication role.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The replication role. Default value: "STANDBY" Possible values: ["ROLE_UNSPECIFIED", "ACTIVE", "STANDBY"]
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetInstanceInitialReplicationReplicaResult(dict):
    def __init__(__self__, *,
                 peer_instance: _builtins.str):
        """
        :param _builtins.str peer_instance: The peer instance.
        """
        pulumi.set(__self__, "peer_instance", peer_instance)

    @_builtins.property
    @pulumi.getter(name="peerInstance")
    def peer_instance(self) -> _builtins.str:
        """
        The peer instance.
        """
        return pulumi.get(self, "peer_instance")


@pulumi.output_type
class GetInstanceNetworkResult(dict):
    def __init__(__self__, *,
                 connect_mode: _builtins.str,
                 ip_addresses: Sequence[_builtins.str],
                 modes: Sequence[_builtins.str],
                 network: _builtins.str,
                 psc_configs: Sequence['outputs.GetInstanceNetworkPscConfigResult'],
                 reserved_ip_range: _builtins.str):
        """
        :param _builtins.str connect_mode: The network connect mode of the Filestore instance.
               If not provided, the connect mode defaults to
               DIRECT_PEERING. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS", "PRIVATE_SERVICE_CONNECT"]
        :param Sequence[_builtins.str] ip_addresses: A list of IPv4 or IPv6 addresses.
        :param Sequence[_builtins.str] modes: IP versions for which the instance has
               IP addresses assigned. Possible values: ["ADDRESS_MODE_UNSPECIFIED", "MODE_IPV4", "MODE_IPV6"]
        :param _builtins.str network: The name of the GCE VPC network to which the
               instance is connected.
        :param Sequence['GetInstanceNetworkPscConfigArgs'] psc_configs: Private Service Connect configuration.
               Should only be set when connect_mode is PRIVATE_SERVICE_CONNECT.
        :param _builtins.str reserved_ip_range: A /29 CIDR block that identifies the range of IP
               addresses reserved for this instance.
        """
        pulumi.set(__self__, "connect_mode", connect_mode)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "modes", modes)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "psc_configs", psc_configs)
        pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)

    @_builtins.property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> _builtins.str:
        """
        The network connect mode of the Filestore instance.
        If not provided, the connect mode defaults to
        DIRECT_PEERING. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS", "PRIVATE_SERVICE_CONNECT"]
        """
        return pulumi.get(self, "connect_mode")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        A list of IPv4 or IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def modes(self) -> Sequence[_builtins.str]:
        """
        IP versions for which the instance has
        IP addresses assigned. Possible values: ["ADDRESS_MODE_UNSPECIFIED", "MODE_IPV4", "MODE_IPV6"]
        """
        return pulumi.get(self, "modes")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The name of the GCE VPC network to which the
        instance is connected.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Sequence['outputs.GetInstanceNetworkPscConfigResult']:
        """
        Private Service Connect configuration.
        Should only be set when connect_mode is PRIVATE_SERVICE_CONNECT.
        """
        return pulumi.get(self, "psc_configs")

    @_builtins.property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> _builtins.str:
        """
        A /29 CIDR block that identifies the range of IP
        addresses reserved for this instance.
        """
        return pulumi.get(self, "reserved_ip_range")


@pulumi.output_type
class GetInstanceNetworkPscConfigResult(dict):
    def __init__(__self__, *,
                 endpoint_project: _builtins.str):
        """
        :param _builtins.str endpoint_project: Consumer service project in which the Private Service Connect endpoint
               would be set up. This is optional, and only relevant in case the network
               is a shared VPC. If this is not specified, the endpoint would be set up
               in the VPC host project.
        """
        pulumi.set(__self__, "endpoint_project", endpoint_project)

    @_builtins.property
    @pulumi.getter(name="endpointProject")
    def endpoint_project(self) -> _builtins.str:
        """
        Consumer service project in which the Private Service Connect endpoint
        would be set up. This is optional, and only relevant in case the network
        is a shared VPC. If this is not specified, the endpoint would be set up
        in the VPC host project.
        """
        return pulumi.get(self, "endpoint_project")


@pulumi.output_type
class GetInstancePerformanceConfigResult(dict):
    def __init__(__self__, *,
                 fixed_iops: Sequence['outputs.GetInstancePerformanceConfigFixedIopResult'],
                 iops_per_tbs: Sequence['outputs.GetInstancePerformanceConfigIopsPerTbResult']):
        """
        :param Sequence['GetInstancePerformanceConfigFixedIopArgs'] fixed_iops: The instance will have a fixed provisioned IOPS value,
               which will remain constant regardless of instance
               capacity.
        :param Sequence['GetInstancePerformanceConfigIopsPerTbArgs'] iops_per_tbs: The instance provisioned IOPS will change dynamically
               based on the capacity of the instance.
        """
        pulumi.set(__self__, "fixed_iops", fixed_iops)
        pulumi.set(__self__, "iops_per_tbs", iops_per_tbs)

    @_builtins.property
    @pulumi.getter(name="fixedIops")
    def fixed_iops(self) -> Sequence['outputs.GetInstancePerformanceConfigFixedIopResult']:
        """
        The instance will have a fixed provisioned IOPS value,
        which will remain constant regardless of instance
        capacity.
        """
        return pulumi.get(self, "fixed_iops")

    @_builtins.property
    @pulumi.getter(name="iopsPerTbs")
    def iops_per_tbs(self) -> Sequence['outputs.GetInstancePerformanceConfigIopsPerTbResult']:
        """
        The instance provisioned IOPS will change dynamically
        based on the capacity of the instance.
        """
        return pulumi.get(self, "iops_per_tbs")


@pulumi.output_type
class GetInstancePerformanceConfigFixedIopResult(dict):
    def __init__(__self__, *,
                 max_iops: _builtins.int):
        """
        :param _builtins.int max_iops: The number of IOPS to provision for the instance.
               max_iops must be in multiple of 1000.
        """
        pulumi.set(__self__, "max_iops", max_iops)

    @_builtins.property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> _builtins.int:
        """
        The number of IOPS to provision for the instance.
        max_iops must be in multiple of 1000.
        """
        return pulumi.get(self, "max_iops")


@pulumi.output_type
class GetInstancePerformanceConfigIopsPerTbResult(dict):
    def __init__(__self__, *,
                 max_iops_per_tb: _builtins.int):
        """
        :param _builtins.int max_iops_per_tb: The instance max IOPS will be calculated by multiplying
               the capacity of the instance (TB) by max_iops_per_tb,
               and rounding to the nearest 1000. The instance max IOPS
               will be changed dynamically based on the instance
               capacity.
        """
        pulumi.set(__self__, "max_iops_per_tb", max_iops_per_tb)

    @_builtins.property
    @pulumi.getter(name="maxIopsPerTb")
    def max_iops_per_tb(self) -> _builtins.int:
        """
        The instance max IOPS will be calculated by multiplying
        the capacity of the instance (TB) by max_iops_per_tb,
        and rounding to the nearest 1000. The instance max IOPS
        will be changed dynamically based on the instance
        capacity.
        """
        return pulumi.get(self, "max_iops_per_tb")


