# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DatabaseInstanceArgs', 'DatabaseInstance']

@pulumi.input_type
class DatabaseInstanceArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseInstance resource.
        :param pulumi.Input[_builtins.str] instance_id: The globally unique identifier of the Firebase Realtime Database instance.
               Instance IDs cannot be reused after deletion.
        :param pulumi.Input[_builtins.str] region: A reference to the region where the Firebase Realtime database resides.
               Check all [available regions](https://firebase.google.com/docs/projects/locations#rtdb-locations)
        :param pulumi.Input[_builtins.str] desired_state: The intended database state. Possible values: ACTIVE, DISABLED.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] type: The database type.
               Each project can create one default Firebase Realtime Database, which cannot be deleted once created.
               Creating user Databases is only available for projects on the Blaze plan.
               Projects can be upgraded using the Cloud Billing API https://cloud.google.com/billing/reference/rest/v1/projects/updateBillingInfo.
               Default value is `USER_DATABASE`.
               Possible values are: `DEFAULT_DATABASE`, `USER_DATABASE`.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "region", region)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The globally unique identifier of the Firebase Realtime Database instance.
        Instance IDs cannot be reused after deletion.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        A reference to the region where the Firebase Realtime database resides.
        Check all [available regions](https://firebase.google.com/docs/projects/locations#rtdb-locations)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intended database state. Possible values: ACTIVE, DISABLED.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database type.
        Each project can create one default Firebase Realtime Database, which cannot be deleted once created.
        Creating user Databases is only available for projects on the Blaze plan.
        Projects can be upgraded using the Cloud Billing API https://cloud.google.com/billing/reference/rest/v1/projects/updateBillingInfo.
        Default value is `USER_DATABASE`.
        Possible values are: `DEFAULT_DATABASE`, `USER_DATABASE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DatabaseInstanceState:
    def __init__(__self__, *,
                 database_url: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseInstance resources.
        :param pulumi.Input[_builtins.str] database_url: The database URL in the form of https://{instance-id}.firebaseio.com for us-central1 instances
               or https://{instance-id}.{region}.firebasedatabase.app in other regions.
        :param pulumi.Input[_builtins.str] desired_state: The intended database state. Possible values: ACTIVE, DISABLED.
        :param pulumi.Input[_builtins.str] instance_id: The globally unique identifier of the Firebase Realtime Database instance.
               Instance IDs cannot be reused after deletion.
        :param pulumi.Input[_builtins.str] name: The fully-qualified resource name of the Firebase Realtime Database, in
               the format: projects/PROJECT_NUMBER/locations/REGION_IDENTIFIER/instances/INSTANCE_ID
               PROJECT_NUMBER: The Firebase project's [`ProjectNumber`](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects#FirebaseProject.FIELDS.project_number)
               Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: A reference to the region where the Firebase Realtime database resides.
               Check all [available regions](https://firebase.google.com/docs/projects/locations#rtdb-locations)
        :param pulumi.Input[_builtins.str] state: The current database state. Set desired_state to :DISABLED to disable the database and :ACTIVE to reenable the database
        :param pulumi.Input[_builtins.str] type: The database type.
               Each project can create one default Firebase Realtime Database, which cannot be deleted once created.
               Creating user Databases is only available for projects on the Blaze plan.
               Projects can be upgraded using the Cloud Billing API https://cloud.google.com/billing/reference/rest/v1/projects/updateBillingInfo.
               Default value is `USER_DATABASE`.
               Possible values are: `DEFAULT_DATABASE`, `USER_DATABASE`.
        """
        if database_url is not None:
            pulumi.set(__self__, "database_url", database_url)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="databaseUrl")
    def database_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database URL in the form of https://{instance-id}.firebaseio.com for us-central1 instances
        or https://{instance-id}.{region}.firebasedatabase.app in other regions.
        """
        return pulumi.get(self, "database_url")

    @database_url.setter
    def database_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_url", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intended database state. Possible values: ACTIVE, DISABLED.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique identifier of the Firebase Realtime Database instance.
        Instance IDs cannot be reused after deletion.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully-qualified resource name of the Firebase Realtime Database, in
        the format: projects/PROJECT_NUMBER/locations/REGION_IDENTIFIER/instances/INSTANCE_ID
        PROJECT_NUMBER: The Firebase project's [`ProjectNumber`](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects#FirebaseProject.FIELDS.project_number)
        Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the region where the Firebase Realtime database resides.
        Check all [available regions](https://firebase.google.com/docs/projects/locations#rtdb-locations)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current database state. Set desired_state to :DISABLED to disable the database and :ACTIVE to reenable the database
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database type.
        Each project can create one default Firebase Realtime Database, which cannot be deleted once created.
        Creating user Databases is only available for projects on the Blaze plan.
        Projects can be upgraded using the Cloud Billing API https://cloud.google.com/billing/reference/rest/v1/projects/updateBillingInfo.
        Default value is `USER_DATABASE`.
        Possible values are: `DEFAULT_DATABASE`, `USER_DATABASE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("gcp:firebase/databaseInstance:DatabaseInstance")
class DatabaseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Firebase Realtime Database instance.

        To get more information about Instance, see:

        * [API documentation](https://firebase.google.com/docs/reference/rest/database/database-management/rest)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/products/realtime-database)

        ## Example Usage

        ### Firebase Database Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.firebase.DatabaseInstance("basic",
            project="my-project-name",
            region="us-central1",
            instance_id="active-db")
        ```
        ### Firebase Database Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full = gcp.firebase.DatabaseInstance("full",
            project="my-project-name",
            region="europe-west1",
            instance_id="disabled-db",
            type="USER_DATABASE",
            desired_state="DISABLED")
        ```
        ### Firebase Database Instance Default Database

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumiverse_time as time

        default = gcp.organizations.Project("default",
            project_id="rtdb-project",
            name="rtdb-project",
            org_id="123456789",
            deletion_policy="DELETE",
            labels={
                "firebase": "enabled",
            })
        firebase = gcp.projects.Service("firebase",
            project=default.project_id,
            service="firebase.googleapis.com")
        default_project = gcp.firebase.Project("default", project=default.project_id,
        opts = pulumi.ResourceOptions(depends_on=[firebase]))
        firebase_database = gcp.projects.Service("firebase_database",
            project=default_project.project,
            service="firebasedatabase.googleapis.com")
        wait60_seconds = time.Sleep("wait_60_seconds", create_duration="60s",
        opts = pulumi.ResourceOptions(depends_on=[firebase_database]))
        default_database_instance = gcp.firebase.DatabaseInstance("default",
            project=default_project.project,
            region="us-central1",
            instance_id="rtdb-project-default-rtdb",
            type="DEFAULT_DATABASE",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{instance_id}}`

        * `{{project}}/{{region}}/{{instance_id}}`

        * `{{region}}/{{instance_id}}`

        * `{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/databaseInstance:DatabaseInstance default projects/{{project}}/locations/{{region}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/databaseInstance:DatabaseInstance default {{project}}/{{region}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/databaseInstance:DatabaseInstance default {{region}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/databaseInstance:DatabaseInstance default {{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] desired_state: The intended database state. Possible values: ACTIVE, DISABLED.
        :param pulumi.Input[_builtins.str] instance_id: The globally unique identifier of the Firebase Realtime Database instance.
               Instance IDs cannot be reused after deletion.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: A reference to the region where the Firebase Realtime database resides.
               Check all [available regions](https://firebase.google.com/docs/projects/locations#rtdb-locations)
        :param pulumi.Input[_builtins.str] type: The database type.
               Each project can create one default Firebase Realtime Database, which cannot be deleted once created.
               Creating user Databases is only available for projects on the Blaze plan.
               Projects can be upgraded using the Cloud Billing API https://cloud.google.com/billing/reference/rest/v1/projects/updateBillingInfo.
               Default value is `USER_DATABASE`.
               Possible values are: `DEFAULT_DATABASE`, `USER_DATABASE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Firebase Realtime Database instance.

        To get more information about Instance, see:

        * [API documentation](https://firebase.google.com/docs/reference/rest/database/database-management/rest)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/products/realtime-database)

        ## Example Usage

        ### Firebase Database Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.firebase.DatabaseInstance("basic",
            project="my-project-name",
            region="us-central1",
            instance_id="active-db")
        ```
        ### Firebase Database Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full = gcp.firebase.DatabaseInstance("full",
            project="my-project-name",
            region="europe-west1",
            instance_id="disabled-db",
            type="USER_DATABASE",
            desired_state="DISABLED")
        ```
        ### Firebase Database Instance Default Database

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumiverse_time as time

        default = gcp.organizations.Project("default",
            project_id="rtdb-project",
            name="rtdb-project",
            org_id="123456789",
            deletion_policy="DELETE",
            labels={
                "firebase": "enabled",
            })
        firebase = gcp.projects.Service("firebase",
            project=default.project_id,
            service="firebase.googleapis.com")
        default_project = gcp.firebase.Project("default", project=default.project_id,
        opts = pulumi.ResourceOptions(depends_on=[firebase]))
        firebase_database = gcp.projects.Service("firebase_database",
            project=default_project.project,
            service="firebasedatabase.googleapis.com")
        wait60_seconds = time.Sleep("wait_60_seconds", create_duration="60s",
        opts = pulumi.ResourceOptions(depends_on=[firebase_database]))
        default_database_instance = gcp.firebase.DatabaseInstance("default",
            project=default_project.project,
            region="us-central1",
            instance_id="rtdb-project-default-rtdb",
            type="DEFAULT_DATABASE",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{instance_id}}`

        * `{{project}}/{{region}}/{{instance_id}}`

        * `{{region}}/{{instance_id}}`

        * `{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/databaseInstance:DatabaseInstance default projects/{{project}}/locations/{{region}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/databaseInstance:DatabaseInstance default {{project}}/{{region}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/databaseInstance:DatabaseInstance default {{region}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/databaseInstance:DatabaseInstance default {{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseInstanceArgs.__new__(DatabaseInstanceArgs)

            __props__.__dict__["desired_state"] = desired_state
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["project"] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["type"] = type
            __props__.__dict__["database_url"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(DatabaseInstance, __self__).__init__(
            'gcp:firebase/databaseInstance:DatabaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_url: Optional[pulumi.Input[_builtins.str]] = None,
            desired_state: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseInstance':
        """
        Get an existing DatabaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_url: The database URL in the form of https://{instance-id}.firebaseio.com for us-central1 instances
               or https://{instance-id}.{region}.firebasedatabase.app in other regions.
        :param pulumi.Input[_builtins.str] desired_state: The intended database state. Possible values: ACTIVE, DISABLED.
        :param pulumi.Input[_builtins.str] instance_id: The globally unique identifier of the Firebase Realtime Database instance.
               Instance IDs cannot be reused after deletion.
        :param pulumi.Input[_builtins.str] name: The fully-qualified resource name of the Firebase Realtime Database, in
               the format: projects/PROJECT_NUMBER/locations/REGION_IDENTIFIER/instances/INSTANCE_ID
               PROJECT_NUMBER: The Firebase project's [`ProjectNumber`](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects#FirebaseProject.FIELDS.project_number)
               Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: A reference to the region where the Firebase Realtime database resides.
               Check all [available regions](https://firebase.google.com/docs/projects/locations#rtdb-locations)
        :param pulumi.Input[_builtins.str] state: The current database state. Set desired_state to :DISABLED to disable the database and :ACTIVE to reenable the database
        :param pulumi.Input[_builtins.str] type: The database type.
               Each project can create one default Firebase Realtime Database, which cannot be deleted once created.
               Creating user Databases is only available for projects on the Blaze plan.
               Projects can be upgraded using the Cloud Billing API https://cloud.google.com/billing/reference/rest/v1/projects/updateBillingInfo.
               Default value is `USER_DATABASE`.
               Possible values are: `DEFAULT_DATABASE`, `USER_DATABASE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseInstanceState.__new__(_DatabaseInstanceState)

        __props__.__dict__["database_url"] = database_url
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        return DatabaseInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="databaseUrl")
    def database_url(self) -> pulumi.Output[_builtins.str]:
        """
        The database URL in the form of https://{instance-id}.firebaseio.com for us-central1 instances
        or https://{instance-id}.{region}.firebasedatabase.app in other regions.
        """
        return pulumi.get(self, "database_url")

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The intended database state. Possible values: ACTIVE, DISABLED.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The globally unique identifier of the Firebase Realtime Database instance.
        Instance IDs cannot be reused after deletion.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully-qualified resource name of the Firebase Realtime Database, in
        the format: projects/PROJECT_NUMBER/locations/REGION_IDENTIFIER/instances/INSTANCE_ID
        PROJECT_NUMBER: The Firebase project's [`ProjectNumber`](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects#FirebaseProject.FIELDS.project_number)
        Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        A reference to the region where the Firebase Realtime database resides.
        Check all [available regions](https://firebase.google.com/docs/projects/locations#rtdb-locations)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current database state. Set desired_state to :DISABLED to disable the database and :ACTIVE to reenable the database
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The database type.
        Each project can create one default Firebase Realtime Database, which cannot be deleted once created.
        Creating user Databases is only available for projects on the Blaze plan.
        Projects can be upgraded using the Cloud Billing API https://cloud.google.com/billing/reference/rest/v1/projects/updateBillingInfo.
        Default value is `USER_DATABASE`.
        Possible values are: `DEFAULT_DATABASE`, `USER_DATABASE`.
        """
        return pulumi.get(self, "type")

