# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAppleAppConfigResult',
    'AwaitableGetAppleAppConfigResult',
    'get_apple_app_config',
    'get_apple_app_config_output',
]

@pulumi.output_type
class GetAppleAppConfigResult:
    """
    A collection of values returned by getAppleAppConfig.
    """
    def __init__(__self__, app_id=None, config_file_contents=None, config_filename=None, id=None, project=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if config_file_contents and not isinstance(config_file_contents, str):
            raise TypeError("Expected argument 'config_file_contents' to be a str")
        pulumi.set(__self__, "config_file_contents", config_file_contents)
        if config_filename and not isinstance(config_filename, str):
            raise TypeError("Expected argument 'config_filename' to be a str")
        pulumi.set(__self__, "config_filename", config_filename)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="configFileContents")
    def config_file_contents(self) -> _builtins.str:
        """
        The content of the XML configuration file as a base64-encoded string.
        """
        return pulumi.get(self, "config_file_contents")

    @_builtins.property
    @pulumi.getter(name="configFilename")
    def config_filename(self) -> _builtins.str:
        """
        The filename that the configuration artifact for the IosApp is typically saved as.
        """
        return pulumi.get(self, "config_filename")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")


class AwaitableGetAppleAppConfigResult(GetAppleAppConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppleAppConfigResult(
            app_id=self.app_id,
            config_file_contents=self.config_file_contents,
            config_filename=self.config_filename,
            id=self.id,
            project=self.project)


def get_apple_app_config(app_id: Optional[_builtins.str] = None,
                         project: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppleAppConfigResult:
    """
    A Google Cloud Firebase Apple application configuration

    To get more information about iosApp, see:

    * [API documentation](https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.iosApps)
    * How-to Guides
        * [Official Documentation](https://firebase.google.com/)


    :param _builtins.str app_id: The id of the Firebase iOS App.
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:firebase/getAppleAppConfig:getAppleAppConfig', __args__, opts=opts, typ=GetAppleAppConfigResult).value

    return AwaitableGetAppleAppConfigResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        config_file_contents=pulumi.get(__ret__, 'config_file_contents'),
        config_filename=pulumi.get(__ret__, 'config_filename'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'))
def get_apple_app_config_output(app_id: Optional[pulumi.Input[_builtins.str]] = None,
                                project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppleAppConfigResult]:
    """
    A Google Cloud Firebase Apple application configuration

    To get more information about iosApp, see:

    * [API documentation](https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.iosApps)
    * How-to Guides
        * [Official Documentation](https://firebase.google.com/)


    :param _builtins.str app_id: The id of the Firebase iOS App.
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:firebase/getAppleAppConfig:getAppleAppConfig', __args__, opts=opts, typ=GetAppleAppConfigResult)
    return __ret__.apply(lambda __response__: GetAppleAppConfigResult(
        app_id=pulumi.get(__response__, 'app_id'),
        config_file_contents=pulumi.get(__response__, 'config_file_contents'),
        config_filename=pulumi.get(__response__, 'config_filename'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project')))
