# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserCredsArgs', 'UserCreds']

@pulumi.input_type
class UserCredsArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserCreds resource.
        :param pulumi.Input[_builtins.str] database: The Firestore database ID.
        :param pulumi.Input[_builtins.str] name: The ID to use for the user creds, which will become the final component
               of the user cred's resource name.
               This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
               with first character a letter and the last a letter or a number. Must not
               be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "database", database)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The Firestore database ID.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the user creds, which will become the final component
        of the user cred's resource name.
        This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
        with first character a letter and the last a letter or a number. Must not
        be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _UserCredsState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_identities: Optional[pulumi.Input[Sequence[pulumi.Input['UserCredsResourceIdentityArgs']]]] = None,
                 secure_password: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserCreds resources.
        :param pulumi.Input[_builtins.str] create_time: The timestamp at which these user creds were created.
        :param pulumi.Input[_builtins.str] database: The Firestore database ID.
        :param pulumi.Input[_builtins.str] name: The ID to use for the user creds, which will become the final component
               of the user cred's resource name.
               This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
               with first character a letter and the last a letter or a number. Must not
               be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['UserCredsResourceIdentityArgs']]] resource_identities: Describes the Resource Identity principal.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] secure_password: The plaintext server-generated password for the user creds.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] state: The state of the user creds.
        :param pulumi.Input[_builtins.str] update_time: The timestamp at which these user creds were updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_identities is not None:
            pulumi.set(__self__, "resource_identities", resource_identities)
        if secure_password is not None:
            pulumi.set(__self__, "secure_password", secure_password)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp at which these user creds were created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Firestore database ID.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the user creds, which will become the final component
        of the user cred's resource name.
        This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
        with first character a letter and the last a letter or a number. Must not
        be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="resourceIdentities")
    def resource_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserCredsResourceIdentityArgs']]]]:
        """
        Describes the Resource Identity principal.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_identities")

    @resource_identities.setter
    def resource_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserCredsResourceIdentityArgs']]]]):
        pulumi.set(self, "resource_identities", value)

    @_builtins.property
    @pulumi.getter(name="securePassword")
    def secure_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plaintext server-generated password for the user creds.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secure_password")

    @secure_password.setter
    def secure_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_password", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the user creds.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp at which these user creds were updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:firestore/userCreds:UserCreds")
class UserCreds(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        User credentials for a Cloud Firestore with MongoDB compatibility database.
        The resource is owned by the database and is deleted along with the database.

        To get more information about UserCreds, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.userCreds)
        * How-to Guides
            * [Authenticate and connect to a database](https://cloud.google.com/firestore/mongodb-compatibility/docs/connect)

        ## Example Usage

        ### Firestore User Creds Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-mongodb-compatible",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_user_creds = gcp.firestore.UserCreds("my-user-creds",
            project="my-project-name",
            database=database.name,
            name="my-username")
        ```
        ### Firestore User Creds With Secret Manager

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-mongodb-compatible",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_user_creds = gcp.firestore.UserCreds("my-user-creds",
            project="my-project-name",
            database=database.name,
            name="my-username")
        my_fs_user_creds_secret = gcp.secretmanager.Secret("my-fs-user-creds-secret",
            project="my-project-name",
            secret_id="my-fs-user-creds-secret",
            replication={
                "auto": {},
            })
        my_fs_user_creds_secret_version = gcp.secretmanager.SecretVersion("my-fs-user-creds-secret-version",
            secret=my_fs_user_creds_secret.id,
            secret_data=my_user_creds.secure_password)
        ```

        ## Import

        UserCreds can be imported using any of these accepted formats:

        * `projects/{{project}}/databases/{{database}}/userCreds/{{name}}`

        * `{{project}}/{{database}}/{{name}}`

        * `{{database}}/{{name}}`

        When using the `pulumi import` command, UserCreds can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firestore/userCreds:UserCreds default projects/{{project}}/databases/{{database}}/userCreds/{{name}}
        ```

        ```sh
        $ pulumi import gcp:firestore/userCreds:UserCreds default {{project}}/{{database}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:firestore/userCreds:UserCreds default {{database}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database: The Firestore database ID.
        :param pulumi.Input[_builtins.str] name: The ID to use for the user creds, which will become the final component
               of the user cred's resource name.
               This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
               with first character a letter and the last a letter or a number. Must not
               be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserCredsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        User credentials for a Cloud Firestore with MongoDB compatibility database.
        The resource is owned by the database and is deleted along with the database.

        To get more information about UserCreds, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.userCreds)
        * How-to Guides
            * [Authenticate and connect to a database](https://cloud.google.com/firestore/mongodb-compatibility/docs/connect)

        ## Example Usage

        ### Firestore User Creds Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-mongodb-compatible",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_user_creds = gcp.firestore.UserCreds("my-user-creds",
            project="my-project-name",
            database=database.name,
            name="my-username")
        ```
        ### Firestore User Creds With Secret Manager

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-mongodb-compatible",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_user_creds = gcp.firestore.UserCreds("my-user-creds",
            project="my-project-name",
            database=database.name,
            name="my-username")
        my_fs_user_creds_secret = gcp.secretmanager.Secret("my-fs-user-creds-secret",
            project="my-project-name",
            secret_id="my-fs-user-creds-secret",
            replication={
                "auto": {},
            })
        my_fs_user_creds_secret_version = gcp.secretmanager.SecretVersion("my-fs-user-creds-secret-version",
            secret=my_fs_user_creds_secret.id,
            secret_data=my_user_creds.secure_password)
        ```

        ## Import

        UserCreds can be imported using any of these accepted formats:

        * `projects/{{project}}/databases/{{database}}/userCreds/{{name}}`

        * `{{project}}/{{database}}/{{name}}`

        * `{{database}}/{{name}}`

        When using the `pulumi import` command, UserCreds can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firestore/userCreds:UserCreds default projects/{{project}}/databases/{{database}}/userCreds/{{name}}
        ```

        ```sh
        $ pulumi import gcp:firestore/userCreds:UserCreds default {{project}}/{{database}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:firestore/userCreds:UserCreds default {{database}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param UserCredsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserCredsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserCredsArgs.__new__(UserCredsArgs)

            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["resource_identities"] = None
            __props__.__dict__["secure_password"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["securePassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UserCreds, __self__).__init__(
            'gcp:firestore/userCreds:UserCreds',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            resource_identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserCredsResourceIdentityArgs', 'UserCredsResourceIdentityArgsDict']]]]] = None,
            secure_password: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserCreds':
        """
        Get an existing UserCreds resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp at which these user creds were created.
        :param pulumi.Input[_builtins.str] database: The Firestore database ID.
        :param pulumi.Input[_builtins.str] name: The ID to use for the user creds, which will become the final component
               of the user cred's resource name.
               This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
               with first character a letter and the last a letter or a number. Must not
               be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserCredsResourceIdentityArgs', 'UserCredsResourceIdentityArgsDict']]]] resource_identities: Describes the Resource Identity principal.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] secure_password: The plaintext server-generated password for the user creds.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] state: The state of the user creds.
        :param pulumi.Input[_builtins.str] update_time: The timestamp at which these user creds were updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserCredsState.__new__(_UserCredsState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["database"] = database
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_identities"] = resource_identities
        __props__.__dict__["secure_password"] = secure_password
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return UserCreds(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp at which these user creds were created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The Firestore database ID.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the user creds, which will become the final component
        of the user cred's resource name.
        This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
        with first character a letter and the last a letter or a number. Must not
        be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="resourceIdentities")
    def resource_identities(self) -> pulumi.Output[Sequence['outputs.UserCredsResourceIdentity']]:
        """
        Describes the Resource Identity principal.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_identities")

    @_builtins.property
    @pulumi.getter(name="securePassword")
    def secure_password(self) -> pulumi.Output[_builtins.str]:
        """
        The plaintext server-generated password for the user creds.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secure_password")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the user creds.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp at which these user creds were updated.
        """
        return pulumi.get(self, "update_time")

