# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryGroupIamMemberArgs', 'RepositoryGroupIamMember']

@pulumi.input_type
class RepositoryGroupIamMemberArgs:
    def __init__(__self__, *,
                 code_repository_index: pulumi.Input[_builtins.str],
                 member: pulumi.Input[_builtins.str],
                 repository_group_id: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 condition: Optional[pulumi.Input['RepositoryGroupIamMemberConditionArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RepositoryGroupIamMember resource.
        :param pulumi.Input[_builtins.str] code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] member: Identities that will be granted the privilege in `role`.
               Each entry can have one of the following values:
               * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account.
               * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account.
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
               * **projectOwner:projectid**: Owners of the given project. For example, "projectOwner:my-example-project"
               * **projectEditor:projectid**: Editors of the given project. For example, "projectEditor:my-example-project"
               * **projectViewer:projectid**: Viewers of the given project. For example, "projectViewer:my-example-project"
               * **Federated identities**: One or more federated identities in a workload or workforce identity pool, workload running on GKE, etc. Refer to the [Principal identifiers documentation](https://cloud.google.com/iam/docs/principal-identifiers#allow) for examples of targets and valid configuration. For example, "principal://iam.googleapis.com/locations/global/workforcePools/example-contractors/subject/joe@example.com"
        :param pulumi.Input[_builtins.str] repository_group_id: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] role: The role that should be applied. Only one
               `gemini.RepositoryGroupIamBinding` can be used per role. Note that custom roles must be of the format
               `[projects|organizations]/{parent-name}/roles/{role-name}`.
        :param pulumi.Input[_builtins.str] location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        pulumi.set(__self__, "code_repository_index", code_repository_index)
        pulumi.set(__self__, "member", member)
        pulumi.set(__self__, "repository_group_id", repository_group_id)
        pulumi.set(__self__, "role", role)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="codeRepositoryIndex")
    def code_repository_index(self) -> pulumi.Input[_builtins.str]:
        """
        Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "code_repository_index")

    @code_repository_index.setter
    def code_repository_index(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "code_repository_index", value)

    @_builtins.property
    @pulumi.getter
    def member(self) -> pulumi.Input[_builtins.str]:
        """
        Identities that will be granted the privilege in `role`.
        Each entry can have one of the following values:
        * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account.
        * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account.
        * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
        * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
        * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
        * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        * **projectOwner:projectid**: Owners of the given project. For example, "projectOwner:my-example-project"
        * **projectEditor:projectid**: Editors of the given project. For example, "projectEditor:my-example-project"
        * **projectViewer:projectid**: Viewers of the given project. For example, "projectViewer:my-example-project"
        * **Federated identities**: One or more federated identities in a workload or workforce identity pool, workload running on GKE, etc. Refer to the [Principal identifiers documentation](https://cloud.google.com/iam/docs/principal-identifiers#allow) for examples of targets and valid configuration. For example, "principal://iam.googleapis.com/locations/global/workforcePools/example-contractors/subject/joe@example.com"
        """
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "member", value)

    @_builtins.property
    @pulumi.getter(name="repositoryGroupId")
    def repository_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "repository_group_id")

    @repository_group_id.setter
    def repository_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_group_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The role that should be applied. Only one
        `gemini.RepositoryGroupIamBinding` can be used per role. Note that custom roles must be of the format
        `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['RepositoryGroupIamMemberConditionArgs']]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['RepositoryGroupIamMemberConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RepositoryGroupIamMemberState:
    def __init__(__self__, *,
                 code_repository_index: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input['RepositoryGroupIamMemberConditionArgs']] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 member: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RepositoryGroupIamMember resources.
        :param pulumi.Input[_builtins.str] code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[_builtins.str] location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[_builtins.str] member: Identities that will be granted the privilege in `role`.
               Each entry can have one of the following values:
               * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account.
               * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account.
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
               * **projectOwner:projectid**: Owners of the given project. For example, "projectOwner:my-example-project"
               * **projectEditor:projectid**: Editors of the given project. For example, "projectEditor:my-example-project"
               * **projectViewer:projectid**: Viewers of the given project. For example, "projectViewer:my-example-project"
               * **Federated identities**: One or more federated identities in a workload or workforce identity pool, workload running on GKE, etc. Refer to the [Principal identifiers documentation](https://cloud.google.com/iam/docs/principal-identifiers#allow) for examples of targets and valid configuration. For example, "principal://iam.googleapis.com/locations/global/workforcePools/example-contractors/subject/joe@example.com"
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        :param pulumi.Input[_builtins.str] repository_group_id: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] role: The role that should be applied. Only one
               `gemini.RepositoryGroupIamBinding` can be used per role. Note that custom roles must be of the format
               `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        if code_repository_index is not None:
            pulumi.set(__self__, "code_repository_index", code_repository_index)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if member is not None:
            pulumi.set(__self__, "member", member)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repository_group_id is not None:
            pulumi.set(__self__, "repository_group_id", repository_group_id)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="codeRepositoryIndex")
    def code_repository_index(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "code_repository_index")

    @code_repository_index.setter
    def code_repository_index(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_repository_index", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['RepositoryGroupIamMemberConditionArgs']]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['RepositoryGroupIamMemberConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def member(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identities that will be granted the privilege in `role`.
        Each entry can have one of the following values:
        * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account.
        * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account.
        * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
        * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
        * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
        * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        * **projectOwner:projectid**: Owners of the given project. For example, "projectOwner:my-example-project"
        * **projectEditor:projectid**: Editors of the given project. For example, "projectEditor:my-example-project"
        * **projectViewer:projectid**: Viewers of the given project. For example, "projectViewer:my-example-project"
        * **Federated identities**: One or more federated identities in a workload or workforce identity pool, workload running on GKE, etc. Refer to the [Principal identifiers documentation](https://cloud.google.com/iam/docs/principal-identifiers#allow) for examples of targets and valid configuration. For example, "principal://iam.googleapis.com/locations/global/workforcePools/example-contractors/subject/joe@example.com"
        """
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="repositoryGroupId")
    def repository_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "repository_group_id")

    @repository_group_id.setter
    def repository_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_group_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role that should be applied. Only one
        `gemini.RepositoryGroupIamBinding` can be used per role. Note that custom roles must be of the format
        `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.type_token("gcp:gemini/repositoryGroupIamMember:RepositoryGroupIamMember")
class RepositoryGroupIamMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_repository_index: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['RepositoryGroupIamMemberConditionArgs', 'RepositoryGroupIamMemberConditionArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 member: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Three different resources help you manage your IAM policy for Gemini for Google Cloud RepositoryGroup. Each of these resources serves a different use case:

        * `gemini.RepositoryGroupIamPolicy`: Authoritative. Sets the IAM policy for the repositorygroup and replaces any existing policy already attached.
        * `gemini.RepositoryGroupIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the repositorygroup are preserved.
        * `gemini.RepositoryGroupIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the repositorygroup are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `gemini.RepositoryGroupIamPolicy`: Retrieves the IAM policy for the repositorygroup

        > **Note:** `gemini.RepositoryGroupIamPolicy` **cannot** be used in conjunction with `gemini.RepositoryGroupIamBinding` and `gemini.RepositoryGroupIamMember` or they will fight over what your policy should be.

        > **Note:** `gemini.RepositoryGroupIamBinding` resources **can be** used in conjunction with `gemini.RepositoryGroupIamMember` resources **only if** they do not grant privilege to the same role.

        ## gemini.RepositoryGroupIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/cloudaicompanion.repositoryGroupsUser",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.gemini.RepositoryGroupIamPolicy("policy",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            policy_data=admin.policy_data)
        ```

        ## gemini.RepositoryGroupIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.gemini.RepositoryGroupIamBinding("binding",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            members=["user:jane@example.com"])
        ```

        ## gemini.RepositoryGroupIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.gemini.RepositoryGroupIamMember("member",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            member="user:jane@example.com")
        ```

        ## This resource supports User Project Overrides.

        - 

        # IAM policy for Gemini for Google Cloud RepositoryGroup

        Three different resources help you manage your IAM policy for Gemini for Google Cloud RepositoryGroup. Each of these resources serves a different use case:

        * `gemini.RepositoryGroupIamPolicy`: Authoritative. Sets the IAM policy for the repositorygroup and replaces any existing policy already attached.
        * `gemini.RepositoryGroupIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the repositorygroup are preserved.
        * `gemini.RepositoryGroupIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the repositorygroup are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `gemini.RepositoryGroupIamPolicy`: Retrieves the IAM policy for the repositorygroup

        > **Note:** `gemini.RepositoryGroupIamPolicy` **cannot** be used in conjunction with `gemini.RepositoryGroupIamBinding` and `gemini.RepositoryGroupIamMember` or they will fight over what your policy should be.

        > **Note:** `gemini.RepositoryGroupIamBinding` resources **can be** used in conjunction with `gemini.RepositoryGroupIamMember` resources **only if** they do not grant privilege to the same role.

        ## gemini.RepositoryGroupIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/cloudaicompanion.repositoryGroupsUser",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.gemini.RepositoryGroupIamPolicy("policy",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            policy_data=admin.policy_data)
        ```

        ## gemini.RepositoryGroupIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.gemini.RepositoryGroupIamBinding("binding",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            members=["user:jane@example.com"])
        ```

        ## gemini.RepositoryGroupIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.gemini.RepositoryGroupIamMember("member",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}}

        * {{project}}/{{location}}/{{code_repository_index}}/{{repository_group_id}}

        * {{location}}/{{code_repository_index}}/{{repository_group_id}}

        * {{repository_group_id}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Gemini for Google Cloud repositorygroup IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamMember:RepositoryGroupIamMember editor "projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}} roles/cloudaicompanion.repositoryGroupsUser user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamMember:RepositoryGroupIamMember editor "projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}} roles/cloudaicompanion.repositoryGroupsUser"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamMember:RepositoryGroupIamMember editor projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[_builtins.str] member: Identities that will be granted the privilege in `role`.
               Each entry can have one of the following values:
               * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account.
               * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account.
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
               * **projectOwner:projectid**: Owners of the given project. For example, "projectOwner:my-example-project"
               * **projectEditor:projectid**: Editors of the given project. For example, "projectEditor:my-example-project"
               * **projectViewer:projectid**: Viewers of the given project. For example, "projectViewer:my-example-project"
               * **Federated identities**: One or more federated identities in a workload or workforce identity pool, workload running on GKE, etc. Refer to the [Principal identifiers documentation](https://cloud.google.com/iam/docs/principal-identifiers#allow) for examples of targets and valid configuration. For example, "principal://iam.googleapis.com/locations/global/workforcePools/example-contractors/subject/joe@example.com"
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        :param pulumi.Input[_builtins.str] repository_group_id: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] role: The role that should be applied. Only one
               `gemini.RepositoryGroupIamBinding` can be used per role. Note that custom roles must be of the format
               `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryGroupIamMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Three different resources help you manage your IAM policy for Gemini for Google Cloud RepositoryGroup. Each of these resources serves a different use case:

        * `gemini.RepositoryGroupIamPolicy`: Authoritative. Sets the IAM policy for the repositorygroup and replaces any existing policy already attached.
        * `gemini.RepositoryGroupIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the repositorygroup are preserved.
        * `gemini.RepositoryGroupIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the repositorygroup are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `gemini.RepositoryGroupIamPolicy`: Retrieves the IAM policy for the repositorygroup

        > **Note:** `gemini.RepositoryGroupIamPolicy` **cannot** be used in conjunction with `gemini.RepositoryGroupIamBinding` and `gemini.RepositoryGroupIamMember` or they will fight over what your policy should be.

        > **Note:** `gemini.RepositoryGroupIamBinding` resources **can be** used in conjunction with `gemini.RepositoryGroupIamMember` resources **only if** they do not grant privilege to the same role.

        ## gemini.RepositoryGroupIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/cloudaicompanion.repositoryGroupsUser",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.gemini.RepositoryGroupIamPolicy("policy",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            policy_data=admin.policy_data)
        ```

        ## gemini.RepositoryGroupIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.gemini.RepositoryGroupIamBinding("binding",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            members=["user:jane@example.com"])
        ```

        ## gemini.RepositoryGroupIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.gemini.RepositoryGroupIamMember("member",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            member="user:jane@example.com")
        ```

        ## This resource supports User Project Overrides.

        - 

        # IAM policy for Gemini for Google Cloud RepositoryGroup

        Three different resources help you manage your IAM policy for Gemini for Google Cloud RepositoryGroup. Each of these resources serves a different use case:

        * `gemini.RepositoryGroupIamPolicy`: Authoritative. Sets the IAM policy for the repositorygroup and replaces any existing policy already attached.
        * `gemini.RepositoryGroupIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the repositorygroup are preserved.
        * `gemini.RepositoryGroupIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the repositorygroup are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `gemini.RepositoryGroupIamPolicy`: Retrieves the IAM policy for the repositorygroup

        > **Note:** `gemini.RepositoryGroupIamPolicy` **cannot** be used in conjunction with `gemini.RepositoryGroupIamBinding` and `gemini.RepositoryGroupIamMember` or they will fight over what your policy should be.

        > **Note:** `gemini.RepositoryGroupIamBinding` resources **can be** used in conjunction with `gemini.RepositoryGroupIamMember` resources **only if** they do not grant privilege to the same role.

        ## gemini.RepositoryGroupIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/cloudaicompanion.repositoryGroupsUser",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.gemini.RepositoryGroupIamPolicy("policy",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            policy_data=admin.policy_data)
        ```

        ## gemini.RepositoryGroupIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.gemini.RepositoryGroupIamBinding("binding",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            members=["user:jane@example.com"])
        ```

        ## gemini.RepositoryGroupIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.gemini.RepositoryGroupIamMember("member",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}}

        * {{project}}/{{location}}/{{code_repository_index}}/{{repository_group_id}}

        * {{location}}/{{code_repository_index}}/{{repository_group_id}}

        * {{repository_group_id}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Gemini for Google Cloud repositorygroup IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamMember:RepositoryGroupIamMember editor "projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}} roles/cloudaicompanion.repositoryGroupsUser user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamMember:RepositoryGroupIamMember editor "projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}} roles/cloudaicompanion.repositoryGroupsUser"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamMember:RepositoryGroupIamMember editor projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param RepositoryGroupIamMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryGroupIamMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_repository_index: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['RepositoryGroupIamMemberConditionArgs', 'RepositoryGroupIamMemberConditionArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 member: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryGroupIamMemberArgs.__new__(RepositoryGroupIamMemberArgs)

            if code_repository_index is None and not opts.urn:
                raise TypeError("Missing required property 'code_repository_index'")
            __props__.__dict__["code_repository_index"] = code_repository_index
            __props__.__dict__["condition"] = condition
            __props__.__dict__["location"] = location
            if member is None and not opts.urn:
                raise TypeError("Missing required property 'member'")
            __props__.__dict__["member"] = member
            __props__.__dict__["project"] = project
            if repository_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_group_id'")
            __props__.__dict__["repository_group_id"] = repository_group_id
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["etag"] = None
        super(RepositoryGroupIamMember, __self__).__init__(
            'gcp:gemini/repositoryGroupIamMember:RepositoryGroupIamMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            code_repository_index: Optional[pulumi.Input[_builtins.str]] = None,
            condition: Optional[pulumi.Input[Union['RepositoryGroupIamMemberConditionArgs', 'RepositoryGroupIamMemberConditionArgsDict']]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            member: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            repository_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None) -> 'RepositoryGroupIamMember':
        """
        Get an existing RepositoryGroupIamMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[_builtins.str] location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[_builtins.str] member: Identities that will be granted the privilege in `role`.
               Each entry can have one of the following values:
               * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account.
               * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account.
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
               * **projectOwner:projectid**: Owners of the given project. For example, "projectOwner:my-example-project"
               * **projectEditor:projectid**: Editors of the given project. For example, "projectEditor:my-example-project"
               * **projectViewer:projectid**: Viewers of the given project. For example, "projectViewer:my-example-project"
               * **Federated identities**: One or more federated identities in a workload or workforce identity pool, workload running on GKE, etc. Refer to the [Principal identifiers documentation](https://cloud.google.com/iam/docs/principal-identifiers#allow) for examples of targets and valid configuration. For example, "principal://iam.googleapis.com/locations/global/workforcePools/example-contractors/subject/joe@example.com"
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        :param pulumi.Input[_builtins.str] repository_group_id: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] role: The role that should be applied. Only one
               `gemini.RepositoryGroupIamBinding` can be used per role. Note that custom roles must be of the format
               `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryGroupIamMemberState.__new__(_RepositoryGroupIamMemberState)

        __props__.__dict__["code_repository_index"] = code_repository_index
        __props__.__dict__["condition"] = condition
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["member"] = member
        __props__.__dict__["project"] = project
        __props__.__dict__["repository_group_id"] = repository_group_id
        __props__.__dict__["role"] = role
        return RepositoryGroupIamMember(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="codeRepositoryIndex")
    def code_repository_index(self) -> pulumi.Output[_builtins.str]:
        """
        Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "code_repository_index")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['outputs.RepositoryGroupIamMemberCondition']]:
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def member(self) -> pulumi.Output[_builtins.str]:
        """
        Identities that will be granted the privilege in `role`.
        Each entry can have one of the following values:
        * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account.
        * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account.
        * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
        * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
        * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
        * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        * **projectOwner:projectid**: Owners of the given project. For example, "projectOwner:my-example-project"
        * **projectEditor:projectid**: Editors of the given project. For example, "projectEditor:my-example-project"
        * **projectViewer:projectid**: Viewers of the given project. For example, "projectViewer:my-example-project"
        * **Federated identities**: One or more federated identities in a workload or workforce identity pool, workload running on GKE, etc. Refer to the [Principal identifiers documentation](https://cloud.google.com/iam/docs/principal-identifiers#allow) for examples of targets and valid configuration. For example, "principal://iam.googleapis.com/locations/global/workforcePools/example-contractors/subject/joe@example.com"
        """
        return pulumi.get(self, "member")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryGroupId")
    def repository_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "repository_group_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The role that should be applied. Only one
        `gemini.RepositoryGroupIamBinding` can be used per role. Note that custom roles must be of the format
        `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        return pulumi.get(self, "role")

