# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupPlanBackupConfig',
    'BackupPlanBackupConfigEncryptionKey',
    'BackupPlanBackupConfigSelectedApplications',
    'BackupPlanBackupConfigSelectedApplicationsNamespacedName',
    'BackupPlanBackupConfigSelectedNamespaceLabels',
    'BackupPlanBackupConfigSelectedNamespaceLabelsResourceLabel',
    'BackupPlanBackupConfigSelectedNamespaces',
    'BackupPlanBackupSchedule',
    'BackupPlanBackupScheduleRpoConfig',
    'BackupPlanBackupScheduleRpoConfigExclusionWindow',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeek',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDate',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowStartTime',
    'BackupPlanIamBindingCondition',
    'BackupPlanIamMemberCondition',
    'BackupPlanRetentionPolicy',
    'RestorePlanIamBindingCondition',
    'RestorePlanIamMemberCondition',
    'RestorePlanRestoreConfig',
    'RestorePlanRestoreConfigClusterResourceRestoreScope',
    'RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKind',
    'RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKind',
    'RestorePlanRestoreConfigExcludedNamespaces',
    'RestorePlanRestoreConfigRestoreOrder',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependency',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiring',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfying',
    'RestorePlanRestoreConfigSelectedApplications',
    'RestorePlanRestoreConfigSelectedApplicationsNamespacedName',
    'RestorePlanRestoreConfigSelectedNamespaces',
    'RestorePlanRestoreConfigTransformationRule',
    'RestorePlanRestoreConfigTransformationRuleFieldAction',
    'RestorePlanRestoreConfigTransformationRuleResourceFilter',
    'RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKind',
    'RestorePlanRestoreConfigVolumeDataRestorePolicyBinding',
]

@pulumi.output_type
class BackupPlanBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNamespaces":
            suggest = "all_namespaces"
        elif key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "includeSecrets":
            suggest = "include_secrets"
        elif key == "includeVolumeData":
            suggest = "include_volume_data"
        elif key == "permissiveMode":
            suggest = "permissive_mode"
        elif key == "selectedApplications":
            suggest = "selected_applications"
        elif key == "selectedNamespaceLabels":
            suggest = "selected_namespace_labels"
        elif key == "selectedNamespaces":
            suggest = "selected_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_namespaces: Optional[_builtins.bool] = None,
                 encryption_key: Optional['outputs.BackupPlanBackupConfigEncryptionKey'] = None,
                 include_secrets: Optional[_builtins.bool] = None,
                 include_volume_data: Optional[_builtins.bool] = None,
                 permissive_mode: Optional[_builtins.bool] = None,
                 selected_applications: Optional['outputs.BackupPlanBackupConfigSelectedApplications'] = None,
                 selected_namespace_labels: Optional['outputs.BackupPlanBackupConfigSelectedNamespaceLabels'] = None,
                 selected_namespaces: Optional['outputs.BackupPlanBackupConfigSelectedNamespaces'] = None):
        """
        :param _builtins.bool all_namespaces: If True, include all namespaced resources.
        :param 'BackupPlanBackupConfigEncryptionKeyArgs' encryption_key: This defines a customer managed encryption key that will be used to encrypt the "config"
               portion (the Kubernetes resources) of Backups created via this plan.
               Structure is documented below.
        :param _builtins.bool include_secrets: This flag specifies whether Kubernetes Secret resources should be included
               when they fall into the scope of Backups.
        :param _builtins.bool include_volume_data: This flag specifies whether volume data should be backed up when PVCs are
               included in the scope of a Backup.
        :param _builtins.bool permissive_mode: This flag specifies whether Backups will not fail when
               Backup for GKE detects Kubernetes configuration that is
               non-standard or requires additional setup to restore.
        :param 'BackupPlanBackupConfigSelectedApplicationsArgs' selected_applications: A list of namespaced Kubernetes Resources.
               Structure is documented below.
        :param 'BackupPlanBackupConfigSelectedNamespaceLabelsArgs' selected_namespace_labels: If set, include just the resources in the listed namespace Labels.
               Structure is documented below.
        :param 'BackupPlanBackupConfigSelectedNamespacesArgs' selected_namespaces: If set, include just the resources in the listed namespaces.
               Structure is documented below.
        """
        if all_namespaces is not None:
            pulumi.set(__self__, "all_namespaces", all_namespaces)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if include_secrets is not None:
            pulumi.set(__self__, "include_secrets", include_secrets)
        if include_volume_data is not None:
            pulumi.set(__self__, "include_volume_data", include_volume_data)
        if permissive_mode is not None:
            pulumi.set(__self__, "permissive_mode", permissive_mode)
        if selected_applications is not None:
            pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespace_labels is not None:
            pulumi.set(__self__, "selected_namespace_labels", selected_namespace_labels)
        if selected_namespaces is not None:
            pulumi.set(__self__, "selected_namespaces", selected_namespaces)

    @_builtins.property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> Optional[_builtins.bool]:
        """
        If True, include all namespaced resources.
        """
        return pulumi.get(self, "all_namespaces")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional['outputs.BackupPlanBackupConfigEncryptionKey']:
        """
        This defines a customer managed encryption key that will be used to encrypt the "config"
        portion (the Kubernetes resources) of Backups created via this plan.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="includeSecrets")
    def include_secrets(self) -> Optional[_builtins.bool]:
        """
        This flag specifies whether Kubernetes Secret resources should be included
        when they fall into the scope of Backups.
        """
        return pulumi.get(self, "include_secrets")

    @_builtins.property
    @pulumi.getter(name="includeVolumeData")
    def include_volume_data(self) -> Optional[_builtins.bool]:
        """
        This flag specifies whether volume data should be backed up when PVCs are
        included in the scope of a Backup.
        """
        return pulumi.get(self, "include_volume_data")

    @_builtins.property
    @pulumi.getter(name="permissiveMode")
    def permissive_mode(self) -> Optional[_builtins.bool]:
        """
        This flag specifies whether Backups will not fail when
        Backup for GKE detects Kubernetes configuration that is
        non-standard or requires additional setup to restore.
        """
        return pulumi.get(self, "permissive_mode")

    @_builtins.property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> Optional['outputs.BackupPlanBackupConfigSelectedApplications']:
        """
        A list of namespaced Kubernetes Resources.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_applications")

    @_builtins.property
    @pulumi.getter(name="selectedNamespaceLabels")
    def selected_namespace_labels(self) -> Optional['outputs.BackupPlanBackupConfigSelectedNamespaceLabels']:
        """
        If set, include just the resources in the listed namespace Labels.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_namespace_labels")

    @_builtins.property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> Optional['outputs.BackupPlanBackupConfigSelectedNamespaces']:
        """
        If set, include just the resources in the listed namespaces.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_namespaces")


@pulumi.output_type
class BackupPlanBackupConfigEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcpKmsEncryptionKey":
            suggest = "gcp_kms_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupConfigEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupConfigEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupConfigEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcp_kms_encryption_key: _builtins.str):
        """
        :param _builtins.str gcp_kms_encryption_key: Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        pulumi.set(__self__, "gcp_kms_encryption_key", gcp_kms_encryption_key)

    @_builtins.property
    @pulumi.getter(name="gcpKmsEncryptionKey")
    def gcp_kms_encryption_key(self) -> _builtins.str:
        """
        Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        return pulumi.get(self, "gcp_kms_encryption_key")


@pulumi.output_type
class BackupPlanBackupConfigSelectedApplications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespacedNames":
            suggest = "namespaced_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupConfigSelectedApplications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupConfigSelectedApplications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupConfigSelectedApplications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespaced_names: Sequence['outputs.BackupPlanBackupConfigSelectedApplicationsNamespacedName']):
        """
        :param Sequence['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs'] namespaced_names: A list of namespaced Kubernetes resources.
               Structure is documented below.
        """
        pulumi.set(__self__, "namespaced_names", namespaced_names)

    @_builtins.property
    @pulumi.getter(name="namespacedNames")
    def namespaced_names(self) -> Sequence['outputs.BackupPlanBackupConfigSelectedApplicationsNamespacedName']:
        """
        A list of namespaced Kubernetes resources.
        Structure is documented below.
        """
        return pulumi.get(self, "namespaced_names")


@pulumi.output_type
class BackupPlanBackupConfigSelectedApplicationsNamespacedName(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str):
        """
        :param _builtins.str name: The name of a Kubernetes Resource.
        :param _builtins.str namespace: The namespace of a Kubernetes Resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of a Kubernetes Resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace of a Kubernetes Resource.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class BackupPlanBackupConfigSelectedNamespaceLabels(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceLabels":
            suggest = "resource_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupConfigSelectedNamespaceLabels. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupConfigSelectedNamespaceLabels.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupConfigSelectedNamespaceLabels.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_labels: Sequence['outputs.BackupPlanBackupConfigSelectedNamespaceLabelsResourceLabel']):
        """
        :param Sequence['BackupPlanBackupConfigSelectedNamespaceLabelsResourceLabelArgs'] resource_labels: A list of Kubernetes Namespace labels.
               Structure is documented below.
        """
        pulumi.set(__self__, "resource_labels", resource_labels)

    @_builtins.property
    @pulumi.getter(name="resourceLabels")
    def resource_labels(self) -> Sequence['outputs.BackupPlanBackupConfigSelectedNamespaceLabelsResourceLabel']:
        """
        A list of Kubernetes Namespace labels.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_labels")


@pulumi.output_type
class BackupPlanBackupConfigSelectedNamespaceLabelsResourceLabel(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of the kubernetes label.
        :param _builtins.str value: The value of the Label.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the kubernetes label.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the Label.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BackupPlanBackupConfigSelectedNamespaces(dict):
    def __init__(__self__, *,
                 namespaces: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] namespaces: A list of Kubernetes Namespaces.
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Sequence[_builtins.str]:
        """
        A list of Kubernetes Namespaces.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class BackupPlanBackupSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronSchedule":
            suggest = "cron_schedule"
        elif key == "rpoConfig":
            suggest = "rpo_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_schedule: Optional[_builtins.str] = None,
                 paused: Optional[_builtins.bool] = None,
                 rpo_config: Optional['outputs.BackupPlanBackupScheduleRpoConfig'] = None):
        """
        :param _builtins.str cron_schedule: A standard cron string that defines a repeating schedule for
               creating Backups via this BackupPlan.
               This is mutually exclusive with the rpoConfig field since at most one
               schedule can be defined for a BackupPlan.
               If this is defined, then backupRetainDays must also be defined.
        :param _builtins.bool paused: This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        :param 'BackupPlanBackupScheduleRpoConfigArgs' rpo_config: Defines the RPO schedule configuration for this BackupPlan. This is mutually
               exclusive with the cronSchedule field since at most one schedule can be defined
               for a BackupPLan. If this is defined, then backupRetainDays must also be defined.
               Structure is documented below.
        """
        if cron_schedule is not None:
            pulumi.set(__self__, "cron_schedule", cron_schedule)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if rpo_config is not None:
            pulumi.set(__self__, "rpo_config", rpo_config)

    @_builtins.property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> Optional[_builtins.str]:
        """
        A standard cron string that defines a repeating schedule for
        creating Backups via this BackupPlan.
        This is mutually exclusive with the rpoConfig field since at most one
        schedule can be defined for a BackupPlan.
        If this is defined, then backupRetainDays must also be defined.
        """
        return pulumi.get(self, "cron_schedule")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[_builtins.bool]:
        """
        This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter(name="rpoConfig")
    def rpo_config(self) -> Optional['outputs.BackupPlanBackupScheduleRpoConfig']:
        """
        Defines the RPO schedule configuration for this BackupPlan. This is mutually
        exclusive with the cronSchedule field since at most one schedule can be defined
        for a BackupPLan. If this is defined, then backupRetainDays must also be defined.
        Structure is documented below.
        """
        return pulumi.get(self, "rpo_config")


@pulumi.output_type
class BackupPlanBackupScheduleRpoConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetRpoMinutes":
            suggest = "target_rpo_minutes"
        elif key == "exclusionWindows":
            suggest = "exclusion_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupScheduleRpoConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupScheduleRpoConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupScheduleRpoConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_rpo_minutes: _builtins.int,
                 exclusion_windows: Optional[Sequence['outputs.BackupPlanBackupScheduleRpoConfigExclusionWindow']] = None):
        """
        :param _builtins.int target_rpo_minutes: Defines the target RPO for the BackupPlan in minutes, which means the target
               maximum data loss in time that is acceptable for this BackupPlan. This must be
               at least 60, i.e., 1 hour, and at most 86400, i.e., 60 days.
        :param Sequence['BackupPlanBackupScheduleRpoConfigExclusionWindowArgs'] exclusion_windows: User specified time windows during which backup can NOT happen for this BackupPlan.
               Backups should start and finish outside of any given exclusion window. Note: backup
               jobs will be scheduled to start and finish outside the duration of the window as
               much as possible, but running jobs will not get canceled when it runs into the window.
               All the time and date values in exclusionWindows entry in the API are in UTC. We
               only allow <=1 recurrence (daily or weekly) exclusion window for a BackupPlan while no
               restriction on number of single occurrence windows.
               Structure is documented below.
        """
        pulumi.set(__self__, "target_rpo_minutes", target_rpo_minutes)
        if exclusion_windows is not None:
            pulumi.set(__self__, "exclusion_windows", exclusion_windows)

    @_builtins.property
    @pulumi.getter(name="targetRpoMinutes")
    def target_rpo_minutes(self) -> _builtins.int:
        """
        Defines the target RPO for the BackupPlan in minutes, which means the target
        maximum data loss in time that is acceptable for this BackupPlan. This must be
        at least 60, i.e., 1 hour, and at most 86400, i.e., 60 days.
        """
        return pulumi.get(self, "target_rpo_minutes")

    @_builtins.property
    @pulumi.getter(name="exclusionWindows")
    def exclusion_windows(self) -> Optional[Sequence['outputs.BackupPlanBackupScheduleRpoConfigExclusionWindow']]:
        """
        User specified time windows during which backup can NOT happen for this BackupPlan.
        Backups should start and finish outside of any given exclusion window. Note: backup
        jobs will be scheduled to start and finish outside the duration of the window as
        much as possible, but running jobs will not get canceled when it runs into the window.
        All the time and date values in exclusionWindows entry in the API are in UTC. We
        only allow <=1 recurrence (daily or weekly) exclusion window for a BackupPlan while no
        restriction on number of single occurrence windows.
        Structure is documented below.
        """
        return pulumi.get(self, "exclusion_windows")


@pulumi.output_type
class BackupPlanBackupScheduleRpoConfigExclusionWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "daysOfWeek":
            suggest = "days_of_week"
        elif key == "singleOccurrenceDate":
            suggest = "single_occurrence_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupScheduleRpoConfigExclusionWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupScheduleRpoConfigExclusionWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupScheduleRpoConfigExclusionWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 start_time: 'outputs.BackupPlanBackupScheduleRpoConfigExclusionWindowStartTime',
                 daily: Optional[_builtins.bool] = None,
                 days_of_week: Optional['outputs.BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeek'] = None,
                 single_occurrence_date: Optional['outputs.BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDate'] = None):
        """
        :param _builtins.str duration: Specifies duration of the window in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s". Restrictions for duration based on the
               recurrence type to allow some time for backup to happen:
               - single_occurrence_date:  no restriction
               - daily window: duration < 24 hours
               - weekly window:
               - days of week includes all seven days of a week: duration < 24 hours
               - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
        :param 'BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgs' start_time: Specifies the start time of the window using time of the day in UTC.
               Structure is documented below.
        :param _builtins.bool daily: The exclusion window occurs every day if set to "True".
               Specifying this field to "False" is an error.
               Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        :param 'BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgs' days_of_week: The exclusion window occurs on these days of each week in UTC.
               Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
               Structure is documented below.
        :param 'BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgs' single_occurrence_date: No recurrence. The exclusion window occurs only once and on this date in UTC.
               Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
               Structure is documented below.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)
        if daily is not None:
            pulumi.set(__self__, "daily", daily)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)
        if single_occurrence_date is not None:
            pulumi.set(__self__, "single_occurrence_date", single_occurrence_date)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Specifies duration of the window in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s". Restrictions for duration based on the
        recurrence type to allow some time for backup to happen:
        - single_occurrence_date:  no restriction
        - daily window: duration < 24 hours
        - weekly window:
        - days of week includes all seven days of a week: duration < 24 hours
        - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.BackupPlanBackupScheduleRpoConfigExclusionWindowStartTime':
        """
        Specifies the start time of the window using time of the day in UTC.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def daily(self) -> Optional[_builtins.bool]:
        """
        The exclusion window occurs every day if set to "True".
        Specifying this field to "False" is an error.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        """
        return pulumi.get(self, "daily")

    @_builtins.property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional['outputs.BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeek']:
        """
        The exclusion window occurs on these days of each week in UTC.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "days_of_week")

    @_builtins.property
    @pulumi.getter(name="singleOccurrenceDate")
    def single_occurrence_date(self) -> Optional['outputs.BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDate']:
        """
        No recurrence. The exclusion window occurs only once and on this date in UTC.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "single_occurrence_date")


@pulumi.output_type
class BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeek(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfWeeks":
            suggest = "days_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeek. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeek.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeek.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_weeks: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] days_of_weeks: A list of days of week.
               Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of days of week.
        Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "days_of_weeks")


@pulumi.output_type
class BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDate(dict):
    def __init__(__self__, *,
                 day: Optional[_builtins.int] = None,
                 month: Optional[_builtins.int] = None,
                 year: Optional[_builtins.int] = None):
        """
        :param _builtins.int day: Day of a month.
        :param _builtins.int month: Month of a year.
        :param _builtins.int year: Year of the date.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if month is not None:
            pulumi.set(__self__, "month", month)
        if year is not None:
            pulumi.set(__self__, "year", year)

    @_builtins.property
    @pulumi.getter
    def day(self) -> Optional[_builtins.int]:
        """
        Day of a month.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def month(self) -> Optional[_builtins.int]:
        """
        Month of a year.
        """
        return pulumi.get(self, "month")

    @_builtins.property
    @pulumi.getter
    def year(self) -> Optional[_builtins.int]:
        """
        Year of the date.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class BackupPlanBackupScheduleRpoConfigExclusionWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[_builtins.int] = None,
                 minutes: Optional[_builtins.int] = None,
                 nanos: Optional[_builtins.int] = None,
                 seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int hours: Hours of day in 24 hour format.
        :param _builtins.int minutes: Minutes of hour of day.
        :param _builtins.int nanos: Fractions of seconds in nanoseconds.
        :param _builtins.int seconds: Seconds of minutes of the time.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> Optional[_builtins.int]:
        """
        Hours of day in 24 hour format.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional[_builtins.int]:
        """
        Minutes of hour of day.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> Optional[_builtins.int]:
        """
        Fractions of seconds in nanoseconds.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> Optional[_builtins.int]:
        """
        Seconds of minutes of the time.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class BackupPlanIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class BackupPlanIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class BackupPlanRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupDeleteLockDays":
            suggest = "backup_delete_lock_days"
        elif key == "backupRetainDays":
            suggest = "backup_retain_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_delete_lock_days: Optional[_builtins.int] = None,
                 backup_retain_days: Optional[_builtins.int] = None,
                 locked: Optional[_builtins.bool] = None):
        """
        :param _builtins.int backup_delete_lock_days: Minimum age for a Backup created via this BackupPlan (in days).
               Must be an integer value between 0-90 (inclusive).
               A Backup created under this BackupPlan will not be deletable
               until it reaches Backup's (create time + backup_delete_lock_days).
               Updating this field of a BackupPlan does not affect existing Backups.
               Backups created after a successful update will inherit this new value.
        :param _builtins.int backup_retain_days: The default maximum age of a Backup created via this BackupPlan.
               This field MUST be an integer value >= 0 and <= 365. If specified,
               a Backup created under this BackupPlan will be automatically deleted
               after its age reaches (createTime + backupRetainDays).
               If not specified, Backups created under this BackupPlan will NOT be
               subject to automatic deletion. Updating this field does NOT affect
               existing Backups under it. Backups created AFTER a successful update
               will automatically pick up the new value.
               NOTE: backupRetainDays must be >= backupDeleteLockDays.
               If cronSchedule is defined, then this must be <= 360 * the creation interval.
               If rpo_config is defined, then this must be
               <= 360 * targetRpoMinutes/(1440minutes/day)
        :param _builtins.bool locked: This flag denotes whether the retention policy of this BackupPlan is locked.
               If set to True, no further update is allowed on this policy, including
               the locked field itself.
        """
        if backup_delete_lock_days is not None:
            pulumi.set(__self__, "backup_delete_lock_days", backup_delete_lock_days)
        if backup_retain_days is not None:
            pulumi.set(__self__, "backup_retain_days", backup_retain_days)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)

    @_builtins.property
    @pulumi.getter(name="backupDeleteLockDays")
    def backup_delete_lock_days(self) -> Optional[_builtins.int]:
        """
        Minimum age for a Backup created via this BackupPlan (in days).
        Must be an integer value between 0-90 (inclusive).
        A Backup created under this BackupPlan will not be deletable
        until it reaches Backup's (create time + backup_delete_lock_days).
        Updating this field of a BackupPlan does not affect existing Backups.
        Backups created after a successful update will inherit this new value.
        """
        return pulumi.get(self, "backup_delete_lock_days")

    @_builtins.property
    @pulumi.getter(name="backupRetainDays")
    def backup_retain_days(self) -> Optional[_builtins.int]:
        """
        The default maximum age of a Backup created via this BackupPlan.
        This field MUST be an integer value >= 0 and <= 365. If specified,
        a Backup created under this BackupPlan will be automatically deleted
        after its age reaches (createTime + backupRetainDays).
        If not specified, Backups created under this BackupPlan will NOT be
        subject to automatic deletion. Updating this field does NOT affect
        existing Backups under it. Backups created AFTER a successful update
        will automatically pick up the new value.
        NOTE: backupRetainDays must be >= backupDeleteLockDays.
        If cronSchedule is defined, then this must be <= 360 * the creation interval.
        If rpo_config is defined, then this must be
        <= 360 * targetRpoMinutes/(1440minutes/day)
        """
        return pulumi.get(self, "backup_retain_days")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[_builtins.bool]:
        """
        This flag denotes whether the retention policy of this BackupPlan is locked.
        If set to True, no further update is allowed on this policy, including
        the locked field itself.
        """
        return pulumi.get(self, "locked")


@pulumi.output_type
class RestorePlanIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RestorePlanIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RestorePlanRestoreConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNamespaces":
            suggest = "all_namespaces"
        elif key == "clusterResourceConflictPolicy":
            suggest = "cluster_resource_conflict_policy"
        elif key == "clusterResourceRestoreScope":
            suggest = "cluster_resource_restore_scope"
        elif key == "excludedNamespaces":
            suggest = "excluded_namespaces"
        elif key == "namespacedResourceRestoreMode":
            suggest = "namespaced_resource_restore_mode"
        elif key == "noNamespaces":
            suggest = "no_namespaces"
        elif key == "restoreOrder":
            suggest = "restore_order"
        elif key == "selectedApplications":
            suggest = "selected_applications"
        elif key == "selectedNamespaces":
            suggest = "selected_namespaces"
        elif key == "transformationRules":
            suggest = "transformation_rules"
        elif key == "volumeDataRestorePolicy":
            suggest = "volume_data_restore_policy"
        elif key == "volumeDataRestorePolicyBindings":
            suggest = "volume_data_restore_policy_bindings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_namespaces: Optional[_builtins.bool] = None,
                 cluster_resource_conflict_policy: Optional[_builtins.str] = None,
                 cluster_resource_restore_scope: Optional['outputs.RestorePlanRestoreConfigClusterResourceRestoreScope'] = None,
                 excluded_namespaces: Optional['outputs.RestorePlanRestoreConfigExcludedNamespaces'] = None,
                 namespaced_resource_restore_mode: Optional[_builtins.str] = None,
                 no_namespaces: Optional[_builtins.bool] = None,
                 restore_order: Optional['outputs.RestorePlanRestoreConfigRestoreOrder'] = None,
                 selected_applications: Optional['outputs.RestorePlanRestoreConfigSelectedApplications'] = None,
                 selected_namespaces: Optional['outputs.RestorePlanRestoreConfigSelectedNamespaces'] = None,
                 transformation_rules: Optional[Sequence['outputs.RestorePlanRestoreConfigTransformationRule']] = None,
                 volume_data_restore_policy: Optional[_builtins.str] = None,
                 volume_data_restore_policy_bindings: Optional[Sequence['outputs.RestorePlanRestoreConfigVolumeDataRestorePolicyBinding']] = None):
        """
        :param _builtins.bool all_namespaces: If True, restore all namespaced resources in the Backup.
               Setting this field to False will result in an error.
        :param _builtins.str cluster_resource_conflict_policy: Defines the behavior for handling the situation where cluster-scoped resources
               being restored already exist in the target cluster.
               This MUST be set to a value other than `CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED`
               if `clusterResourceRestoreScope` is anyting other than `noGroupKinds`.
               See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#clusterresourceconflictpolicy
               for more information on each policy option.
               Possible values are: `USE_EXISTING_VERSION`, `USE_BACKUP_VERSION`.
        :param 'RestorePlanRestoreConfigClusterResourceRestoreScopeArgs' cluster_resource_restore_scope: Identifies the cluster-scoped resources to restore from the Backup.
               Structure is documented below.
        :param 'RestorePlanRestoreConfigExcludedNamespacesArgs' excluded_namespaces: A list of selected namespaces excluded from restoration.
               All namespaces except those in this list will be restored.
               Structure is documented below.
        :param _builtins.str namespaced_resource_restore_mode: Defines the behavior for handling the situation where sets of namespaced resources
               being restored already exist in the target cluster.
               This MUST be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
               if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
               See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#namespacedresourcerestoremode
               for more information on each mode.
               Possible values are: `DELETE_AND_RESTORE`, `FAIL_ON_CONFLICT`, `MERGE_SKIP_ON_CONFLICT`, `MERGE_REPLACE_VOLUME_ON_CONFLICT`, `MERGE_REPLACE_ON_CONFLICT`.
        :param _builtins.bool no_namespaces: Do not restore any namespaced resources if set to "True".
               Specifying this field to "False" is not allowed.
        :param 'RestorePlanRestoreConfigRestoreOrderArgs' restore_order: It contains custom ordering to use on a Restore.
               Structure is documented below.
        :param 'RestorePlanRestoreConfigSelectedApplicationsArgs' selected_applications: A list of selected ProtectedApplications to restore.
               The listed ProtectedApplications and all the resources
               to which they refer will be restored.
               Structure is documented below.
        :param 'RestorePlanRestoreConfigSelectedNamespacesArgs' selected_namespaces: A list of selected namespaces to restore from the Backup.
               The listed Namespaces and all resources contained in them will be restored.
               Structure is documented below.
        :param Sequence['RestorePlanRestoreConfigTransformationRuleArgs'] transformation_rules: A list of transformation rules to be applied against Kubernetes
               resources as they are selected for restoration from a Backup.
               Rules are executed in order defined - this order matters,
               as changes made by a rule may impact the filtering logic of subsequent
               rules. An empty list means no transformation will occur.
               Structure is documented below.
        :param _builtins.str volume_data_restore_policy: Specifies the mechanism to be used to restore volume data.
               This should be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
               if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
               If not specified, it will be treated as `NO_VOLUME_DATA_RESTORATION`.
               See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
               for more information on each policy option.
               Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        :param Sequence['RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgs'] volume_data_restore_policy_bindings: A table that binds volumes by their scope to a restore policy. Bindings
               must have a unique scope. Any volumes not scoped in the bindings are
               subject to the policy defined in volume_data_restore_policy.
               Structure is documented below.
        """
        if all_namespaces is not None:
            pulumi.set(__self__, "all_namespaces", all_namespaces)
        if cluster_resource_conflict_policy is not None:
            pulumi.set(__self__, "cluster_resource_conflict_policy", cluster_resource_conflict_policy)
        if cluster_resource_restore_scope is not None:
            pulumi.set(__self__, "cluster_resource_restore_scope", cluster_resource_restore_scope)
        if excluded_namespaces is not None:
            pulumi.set(__self__, "excluded_namespaces", excluded_namespaces)
        if namespaced_resource_restore_mode is not None:
            pulumi.set(__self__, "namespaced_resource_restore_mode", namespaced_resource_restore_mode)
        if no_namespaces is not None:
            pulumi.set(__self__, "no_namespaces", no_namespaces)
        if restore_order is not None:
            pulumi.set(__self__, "restore_order", restore_order)
        if selected_applications is not None:
            pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespaces is not None:
            pulumi.set(__self__, "selected_namespaces", selected_namespaces)
        if transformation_rules is not None:
            pulumi.set(__self__, "transformation_rules", transformation_rules)
        if volume_data_restore_policy is not None:
            pulumi.set(__self__, "volume_data_restore_policy", volume_data_restore_policy)
        if volume_data_restore_policy_bindings is not None:
            pulumi.set(__self__, "volume_data_restore_policy_bindings", volume_data_restore_policy_bindings)

    @_builtins.property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> Optional[_builtins.bool]:
        """
        If True, restore all namespaced resources in the Backup.
        Setting this field to False will result in an error.
        """
        return pulumi.get(self, "all_namespaces")

    @_builtins.property
    @pulumi.getter(name="clusterResourceConflictPolicy")
    def cluster_resource_conflict_policy(self) -> Optional[_builtins.str]:
        """
        Defines the behavior for handling the situation where cluster-scoped resources
        being restored already exist in the target cluster.
        This MUST be set to a value other than `CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED`
        if `clusterResourceRestoreScope` is anyting other than `noGroupKinds`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#clusterresourceconflictpolicy
        for more information on each policy option.
        Possible values are: `USE_EXISTING_VERSION`, `USE_BACKUP_VERSION`.
        """
        return pulumi.get(self, "cluster_resource_conflict_policy")

    @_builtins.property
    @pulumi.getter(name="clusterResourceRestoreScope")
    def cluster_resource_restore_scope(self) -> Optional['outputs.RestorePlanRestoreConfigClusterResourceRestoreScope']:
        """
        Identifies the cluster-scoped resources to restore from the Backup.
        Structure is documented below.
        """
        return pulumi.get(self, "cluster_resource_restore_scope")

    @_builtins.property
    @pulumi.getter(name="excludedNamespaces")
    def excluded_namespaces(self) -> Optional['outputs.RestorePlanRestoreConfigExcludedNamespaces']:
        """
        A list of selected namespaces excluded from restoration.
        All namespaces except those in this list will be restored.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_namespaces")

    @_builtins.property
    @pulumi.getter(name="namespacedResourceRestoreMode")
    def namespaced_resource_restore_mode(self) -> Optional[_builtins.str]:
        """
        Defines the behavior for handling the situation where sets of namespaced resources
        being restored already exist in the target cluster.
        This MUST be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
        if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#namespacedresourcerestoremode
        for more information on each mode.
        Possible values are: `DELETE_AND_RESTORE`, `FAIL_ON_CONFLICT`, `MERGE_SKIP_ON_CONFLICT`, `MERGE_REPLACE_VOLUME_ON_CONFLICT`, `MERGE_REPLACE_ON_CONFLICT`.
        """
        return pulumi.get(self, "namespaced_resource_restore_mode")

    @_builtins.property
    @pulumi.getter(name="noNamespaces")
    def no_namespaces(self) -> Optional[_builtins.bool]:
        """
        Do not restore any namespaced resources if set to "True".
        Specifying this field to "False" is not allowed.
        """
        return pulumi.get(self, "no_namespaces")

    @_builtins.property
    @pulumi.getter(name="restoreOrder")
    def restore_order(self) -> Optional['outputs.RestorePlanRestoreConfigRestoreOrder']:
        """
        It contains custom ordering to use on a Restore.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_order")

    @_builtins.property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> Optional['outputs.RestorePlanRestoreConfigSelectedApplications']:
        """
        A list of selected ProtectedApplications to restore.
        The listed ProtectedApplications and all the resources
        to which they refer will be restored.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_applications")

    @_builtins.property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> Optional['outputs.RestorePlanRestoreConfigSelectedNamespaces']:
        """
        A list of selected namespaces to restore from the Backup.
        The listed Namespaces and all resources contained in them will be restored.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_namespaces")

    @_builtins.property
    @pulumi.getter(name="transformationRules")
    def transformation_rules(self) -> Optional[Sequence['outputs.RestorePlanRestoreConfigTransformationRule']]:
        """
        A list of transformation rules to be applied against Kubernetes
        resources as they are selected for restoration from a Backup.
        Rules are executed in order defined - this order matters,
        as changes made by a rule may impact the filtering logic of subsequent
        rules. An empty list means no transformation will occur.
        Structure is documented below.
        """
        return pulumi.get(self, "transformation_rules")

    @_builtins.property
    @pulumi.getter(name="volumeDataRestorePolicy")
    def volume_data_restore_policy(self) -> Optional[_builtins.str]:
        """
        Specifies the mechanism to be used to restore volume data.
        This should be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
        if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
        If not specified, it will be treated as `NO_VOLUME_DATA_RESTORATION`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
        for more information on each policy option.
        Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        """
        return pulumi.get(self, "volume_data_restore_policy")

    @_builtins.property
    @pulumi.getter(name="volumeDataRestorePolicyBindings")
    def volume_data_restore_policy_bindings(self) -> Optional[Sequence['outputs.RestorePlanRestoreConfigVolumeDataRestorePolicyBinding']]:
        """
        A table that binds volumes by their scope to a restore policy. Bindings
        must have a unique scope. Any volumes not scoped in the bindings are
        subject to the policy defined in volume_data_restore_policy.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_data_restore_policy_bindings")


@pulumi.output_type
class RestorePlanRestoreConfigClusterResourceRestoreScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allGroupKinds":
            suggest = "all_group_kinds"
        elif key == "excludedGroupKinds":
            suggest = "excluded_group_kinds"
        elif key == "noGroupKinds":
            suggest = "no_group_kinds"
        elif key == "selectedGroupKinds":
            suggest = "selected_group_kinds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigClusterResourceRestoreScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigClusterResourceRestoreScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigClusterResourceRestoreScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_group_kinds: Optional[_builtins.bool] = None,
                 excluded_group_kinds: Optional[Sequence['outputs.RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKind']] = None,
                 no_group_kinds: Optional[_builtins.bool] = None,
                 selected_group_kinds: Optional[Sequence['outputs.RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKind']] = None):
        """
        :param _builtins.bool all_group_kinds: If True, all valid cluster-scoped resources will be restored.
               Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        :param Sequence['RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgs'] excluded_group_kinds: A list of cluster-scoped resource group kinds to NOT restore from the backup.
               If specified, all valid cluster-scoped resources will be restored except
               for those specified in the list.
               Mutually exclusive to any other field in `clusterResourceRestoreScope`.
               Structure is documented below.
        :param _builtins.bool no_group_kinds: If True, no cluster-scoped resources will be restored.
               Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        :param Sequence['RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgs'] selected_group_kinds: A list of cluster-scoped resource group kinds to restore from the backup.
               If specified, only the selected resources will be restored.
               Mutually exclusive to any other field in the `clusterResourceRestoreScope`.
               Structure is documented below.
        """
        if all_group_kinds is not None:
            pulumi.set(__self__, "all_group_kinds", all_group_kinds)
        if excluded_group_kinds is not None:
            pulumi.set(__self__, "excluded_group_kinds", excluded_group_kinds)
        if no_group_kinds is not None:
            pulumi.set(__self__, "no_group_kinds", no_group_kinds)
        if selected_group_kinds is not None:
            pulumi.set(__self__, "selected_group_kinds", selected_group_kinds)

    @_builtins.property
    @pulumi.getter(name="allGroupKinds")
    def all_group_kinds(self) -> Optional[_builtins.bool]:
        """
        If True, all valid cluster-scoped resources will be restored.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        """
        return pulumi.get(self, "all_group_kinds")

    @_builtins.property
    @pulumi.getter(name="excludedGroupKinds")
    def excluded_group_kinds(self) -> Optional[Sequence['outputs.RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKind']]:
        """
        A list of cluster-scoped resource group kinds to NOT restore from the backup.
        If specified, all valid cluster-scoped resources will be restored except
        for those specified in the list.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_group_kinds")

    @_builtins.property
    @pulumi.getter(name="noGroupKinds")
    def no_group_kinds(self) -> Optional[_builtins.bool]:
        """
        If True, no cluster-scoped resources will be restored.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        """
        return pulumi.get(self, "no_group_kinds")

    @_builtins.property
    @pulumi.getter(name="selectedGroupKinds")
    def selected_group_kinds(self) -> Optional[Sequence['outputs.RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKind']]:
        """
        A list of cluster-scoped resource group kinds to restore from the backup.
        If specified, only the selected resources will be restored.
        Mutually exclusive to any other field in the `clusterResourceRestoreScope`.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_group_kinds")


@pulumi.output_type
class RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKind(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceKind":
            suggest = "resource_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKind. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKind.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKind.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_group: Optional[_builtins.str] = None,
                 resource_kind: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_group: API Group string of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param _builtins.str resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[_builtins.str]:
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[_builtins.str]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")


@pulumi.output_type
class RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKind(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceKind":
            suggest = "resource_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKind. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKind.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKind.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_group: Optional[_builtins.str] = None,
                 resource_kind: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_group: API Group string of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param _builtins.str resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[_builtins.str]:
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[_builtins.str]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")


@pulumi.output_type
class RestorePlanRestoreConfigExcludedNamespaces(dict):
    def __init__(__self__, *,
                 namespaces: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] namespaces: A list of Kubernetes Namespaces.
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Sequence[_builtins.str]:
        """
        A list of Kubernetes Namespaces.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class RestorePlanRestoreConfigRestoreOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupKindDependencies":
            suggest = "group_kind_dependencies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigRestoreOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigRestoreOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigRestoreOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_kind_dependencies: Sequence['outputs.RestorePlanRestoreConfigRestoreOrderGroupKindDependency']):
        """
        :param Sequence['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgs'] group_kind_dependencies: A list of group kind dependency pairs
               that is used by Backup for GKE to
               generate a group kind restore order.
               Structure is documented below.
        """
        pulumi.set(__self__, "group_kind_dependencies", group_kind_dependencies)

    @_builtins.property
    @pulumi.getter(name="groupKindDependencies")
    def group_kind_dependencies(self) -> Sequence['outputs.RestorePlanRestoreConfigRestoreOrderGroupKindDependency']:
        """
        A list of group kind dependency pairs
        that is used by Backup for GKE to
        generate a group kind restore order.
        Structure is documented below.
        """
        return pulumi.get(self, "group_kind_dependencies")


@pulumi.output_type
class RestorePlanRestoreConfigRestoreOrderGroupKindDependency(dict):
    def __init__(__self__, *,
                 requiring: 'outputs.RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiring',
                 satisfying: 'outputs.RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfying'):
        """
        :param 'RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgs' requiring: The requiring group kind requires that the satisfying
               group kind be restored first.
               Structure is documented below.
        :param 'RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgs' satisfying: The satisfying group kind must be restored first
               in order to satisfy the dependency.
               Structure is documented below.
        """
        pulumi.set(__self__, "requiring", requiring)
        pulumi.set(__self__, "satisfying", satisfying)

    @_builtins.property
    @pulumi.getter
    def requiring(self) -> 'outputs.RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiring':
        """
        The requiring group kind requires that the satisfying
        group kind be restored first.
        Structure is documented below.
        """
        return pulumi.get(self, "requiring")

    @_builtins.property
    @pulumi.getter
    def satisfying(self) -> 'outputs.RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfying':
        """
        The satisfying group kind must be restored first
        in order to satisfy the dependency.
        Structure is documented below.
        """
        return pulumi.get(self, "satisfying")


@pulumi.output_type
class RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiring(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceKind":
            suggest = "resource_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiring. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiring.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiring.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_group: Optional[_builtins.str] = None,
                 resource_kind: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_group: API Group of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param _builtins.str resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[_builtins.str]:
        """
        API Group of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[_builtins.str]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")


@pulumi.output_type
class RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfying(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceKind":
            suggest = "resource_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfying. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfying.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfying.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_group: Optional[_builtins.str] = None,
                 resource_kind: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_group: API Group of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param _builtins.str resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[_builtins.str]:
        """
        API Group of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[_builtins.str]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")


@pulumi.output_type
class RestorePlanRestoreConfigSelectedApplications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespacedNames":
            suggest = "namespaced_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigSelectedApplications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigSelectedApplications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigSelectedApplications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespaced_names: Sequence['outputs.RestorePlanRestoreConfigSelectedApplicationsNamespacedName']):
        """
        :param Sequence['RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgs'] namespaced_names: A list of namespaced Kubernetes resources.
               Structure is documented below.
        """
        pulumi.set(__self__, "namespaced_names", namespaced_names)

    @_builtins.property
    @pulumi.getter(name="namespacedNames")
    def namespaced_names(self) -> Sequence['outputs.RestorePlanRestoreConfigSelectedApplicationsNamespacedName']:
        """
        A list of namespaced Kubernetes resources.
        Structure is documented below.
        """
        return pulumi.get(self, "namespaced_names")


@pulumi.output_type
class RestorePlanRestoreConfigSelectedApplicationsNamespacedName(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str):
        """
        :param _builtins.str name: The name of a Kubernetes Resource.
        :param _builtins.str namespace: The namespace of a Kubernetes Resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of a Kubernetes Resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace of a Kubernetes Resource.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class RestorePlanRestoreConfigSelectedNamespaces(dict):
    def __init__(__self__, *,
                 namespaces: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] namespaces: A list of Kubernetes Namespaces.
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Sequence[_builtins.str]:
        """
        A list of Kubernetes Namespaces.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class RestorePlanRestoreConfigTransformationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldActions":
            suggest = "field_actions"
        elif key == "resourceFilter":
            suggest = "resource_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigTransformationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigTransformationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigTransformationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_actions: Sequence['outputs.RestorePlanRestoreConfigTransformationRuleFieldAction'],
                 description: Optional[_builtins.str] = None,
                 resource_filter: Optional['outputs.RestorePlanRestoreConfigTransformationRuleResourceFilter'] = None):
        """
        :param Sequence['RestorePlanRestoreConfigTransformationRuleFieldActionArgs'] field_actions: A list of transformation rule actions to take against candidate
               resources. Actions are executed in order defined - this order
               matters, as they could potentially interfere with each other and
               the first operation could affect the outcome of the second operation.
               Structure is documented below.
        :param _builtins.str description: The description is a user specified string description
               of the transformation rule.
        :param 'RestorePlanRestoreConfigTransformationRuleResourceFilterArgs' resource_filter: This field is used to specify a set of fields that should be used to
               determine which resources in backup should be acted upon by the
               supplied transformation rule actions, and this will ensure that only
               specific resources are affected by transformation rule actions.
               Structure is documented below.
        """
        pulumi.set(__self__, "field_actions", field_actions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_filter is not None:
            pulumi.set(__self__, "resource_filter", resource_filter)

    @_builtins.property
    @pulumi.getter(name="fieldActions")
    def field_actions(self) -> Sequence['outputs.RestorePlanRestoreConfigTransformationRuleFieldAction']:
        """
        A list of transformation rule actions to take against candidate
        resources. Actions are executed in order defined - this order
        matters, as they could potentially interfere with each other and
        the first operation could affect the outcome of the second operation.
        Structure is documented below.
        """
        return pulumi.get(self, "field_actions")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description is a user specified string description
        of the transformation rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="resourceFilter")
    def resource_filter(self) -> Optional['outputs.RestorePlanRestoreConfigTransformationRuleResourceFilter']:
        """
        This field is used to specify a set of fields that should be used to
        determine which resources in backup should be acted upon by the
        supplied transformation rule actions, and this will ensure that only
        specific resources are affected by transformation rule actions.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_filter")


@pulumi.output_type
class RestorePlanRestoreConfigTransformationRuleFieldAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPath":
            suggest = "from_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigTransformationRuleFieldAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigTransformationRuleFieldAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigTransformationRuleFieldAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 op: _builtins.str,
                 from_path: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str op: Specifies the operation to perform.
               Possible values are: `REMOVE`, `MOVE`, `COPY`, `ADD`, `TEST`, `REPLACE`.
        :param _builtins.str from_path: A string containing a JSON Pointer value that references the
               location in the target document to move the value from.
        :param _builtins.str path: A string containing a JSON-Pointer value that references a
               location within the target document where the operation is performed.
        :param _builtins.str value: A string that specifies the desired value in string format
               to use for transformation.
        """
        pulumi.set(__self__, "op", op)
        if from_path is not None:
            pulumi.set(__self__, "from_path", from_path)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def op(self) -> _builtins.str:
        """
        Specifies the operation to perform.
        Possible values are: `REMOVE`, `MOVE`, `COPY`, `ADD`, `TEST`, `REPLACE`.
        """
        return pulumi.get(self, "op")

    @_builtins.property
    @pulumi.getter(name="fromPath")
    def from_path(self) -> Optional[_builtins.str]:
        """
        A string containing a JSON Pointer value that references the
        location in the target document to move the value from.
        """
        return pulumi.get(self, "from_path")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        A string containing a JSON-Pointer value that references a
        location within the target document where the operation is performed.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        A string that specifies the desired value in string format
        to use for transformation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RestorePlanRestoreConfigTransformationRuleResourceFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupKinds":
            suggest = "group_kinds"
        elif key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigTransformationRuleResourceFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigTransformationRuleResourceFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigTransformationRuleResourceFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_kinds: Optional[Sequence['outputs.RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKind']] = None,
                 json_path: Optional[_builtins.str] = None,
                 namespaces: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgs'] group_kinds: (Filtering parameter) Any resource subject to transformation must
               belong to one of the listed "types". If this field is not provided,
               no type filtering will be performed
               (all resources of all types matching previous filtering parameters
               will be candidates for transformation).
               Structure is documented below.
        :param _builtins.str json_path: This is a JSONPath expression that matches specific fields of
               candidate resources and it operates as a filtering parameter
               (resources that are not matched with this expression will not
               be candidates for transformation).
        :param Sequence[_builtins.str] namespaces: (Filtering parameter) Any resource subject to transformation must
               be contained within one of the listed Kubernetes Namespace in the
               Backup. If this field is not provided, no namespace filtering will
               be performed (all resources in all Namespaces, including all
               cluster-scoped resources, will be candidates for transformation).
               To mix cluster-scoped and namespaced resources in the same rule,
               use an empty string ("") as one of the target namespaces.
        """
        if group_kinds is not None:
            pulumi.set(__self__, "group_kinds", group_kinds)
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter(name="groupKinds")
    def group_kinds(self) -> Optional[Sequence['outputs.RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKind']]:
        """
        (Filtering parameter) Any resource subject to transformation must
        belong to one of the listed "types". If this field is not provided,
        no type filtering will be performed
        (all resources of all types matching previous filtering parameters
        will be candidates for transformation).
        Structure is documented below.
        """
        return pulumi.get(self, "group_kinds")

    @_builtins.property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> Optional[_builtins.str]:
        """
        This is a JSONPath expression that matches specific fields of
        candidate resources and it operates as a filtering parameter
        (resources that are not matched with this expression will not
        be candidates for transformation).
        """
        return pulumi.get(self, "json_path")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Filtering parameter) Any resource subject to transformation must
        be contained within one of the listed Kubernetes Namespace in the
        Backup. If this field is not provided, no namespace filtering will
        be performed (all resources in all Namespaces, including all
        cluster-scoped resources, will be candidates for transformation).
        To mix cluster-scoped and namespaced resources in the same rule,
        use an empty string ("") as one of the target namespaces.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKind(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceKind":
            suggest = "resource_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKind. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKind.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKind.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_group: Optional[_builtins.str] = None,
                 resource_kind: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_group: API Group string of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param _builtins.str resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[_builtins.str]:
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[_builtins.str]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")


@pulumi.output_type
class RestorePlanRestoreConfigVolumeDataRestorePolicyBinding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePlanRestoreConfigVolumeDataRestorePolicyBinding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePlanRestoreConfigVolumeDataRestorePolicyBinding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePlanRestoreConfigVolumeDataRestorePolicyBinding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy: _builtins.str,
                 volume_type: _builtins.str):
        """
        :param _builtins.str policy: Specifies the mechanism to be used to restore this volume data.
               See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
               for more information on each policy option.
               Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        :param _builtins.str volume_type: The volume type, as determined by the PVC's
               bound PV, to apply the policy to.
               Possible values are: `GCE_PERSISTENT_DISK`.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Specifies the mechanism to be used to restore this volume data.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
        for more information on each policy option.
        Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> _builtins.str:
        """
        The volume type, as determined by the PVC's
        bound PV, to apply the policy to.
        Possible values are: `GCE_PERSISTENT_DISK`.
        """
        return pulumi.get(self, "volume_type")


