# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BareMetalNodePoolArgs', 'BareMetalNodePool']

@pulumi.input_type
class BareMetalNodePoolArgs:
    def __init__(__self__, *,
                 bare_metal_cluster: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 node_pool_config: pulumi.Input['BareMetalNodePoolNodePoolConfigArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BareMetalNodePool resource.
        :param pulumi.Input[_builtins.str] bare_metal_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input['BareMetalNodePoolNodePoolConfigArgs'] node_pool_config: Node pool configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations on the Bare Metal Node Pool.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Bare Metal Node Pool.
        :param pulumi.Input[_builtins.str] name: The bare metal node pool name.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "bare_metal_cluster", bare_metal_cluster)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "node_pool_config", node_pool_config)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="bareMetalCluster")
    def bare_metal_cluster(self) -> pulumi.Input[_builtins.str]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "bare_metal_cluster")

    @bare_metal_cluster.setter
    def bare_metal_cluster(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bare_metal_cluster", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']:
        """
        Node pool configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "node_pool_config")

    @node_pool_config.setter
    def node_pool_config(self, value: pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']):
        pulumi.set(self, "node_pool_config", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations on the Bare Metal Node Pool.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the Bare Metal Node Pool.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bare metal node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _BareMetalNodePoolState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bare_metal_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_config: Optional[pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalNodePoolStatusArgs']]]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BareMetalNodePool resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations on the Bare Metal Node Pool.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] bare_metal_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[_builtins.str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[_builtins.str] delete_time: The time the cluster was deleted, in RFC3339 text format.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Bare Metal Node Pool.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: The bare metal node pool name.
        :param pulumi.Input['BareMetalNodePoolNodePoolConfigArgs'] node_pool_config: Node pool configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] reconciling: If set, there are currently changes in flight to the Bare Metal User Cluster.
        :param pulumi.Input[_builtins.str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input['BareMetalNodePoolStatusArgs']]] statuses: Specifies detailed node pool status.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the Bare Metal Node Pool.
        :param pulumi.Input[_builtins.str] update_time: The time the cluster was last updated, in RFC3339 text format.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if bare_metal_cluster is not None:
            pulumi.set(__self__, "bare_metal_cluster", bare_metal_cluster)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_config is not None:
            pulumi.set(__self__, "node_pool_config", node_pool_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations on the Bare Metal Node Pool.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="bareMetalCluster")
    def bare_metal_cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "bare_metal_cluster")

    @bare_metal_cluster.setter
    def bare_metal_cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bare_metal_cluster", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the cluster was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the Bare Metal Node Pool.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bare metal node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> Optional[pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']]:
        """
        Node pool configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "node_pool_config")

    @node_pool_config.setter
    def node_pool_config(self, value: Optional[pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']]):
        pulumi.set(self, "node_pool_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, there are currently changes in flight to the Bare Metal User Cluster.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalNodePoolStatusArgs']]]]:
        """
        Specifies detailed node pool status.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalNodePoolStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Bare Metal Node Pool.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool")
class BareMetalNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bare_metal_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_config: Optional[pulumi.Input[Union['BareMetalNodePoolNodePoolConfigArgs', 'BareMetalNodePoolNodePoolConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Google Bare Metal Node Pool.

        To get more information about BareMetalNodePool, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/distributed-cloud/reference/on-prem-api/rest/v1/projects.locations.bareMetalClusters.bareMetalNodePools)

        ## Example Usage

        ### Gkeonprem Bare Metal Node Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_basic = gcp.gkeonprem.BareMetalCluster("default-basic",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                    },
                },
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "metal_lb_config": {
                    "address_pools": [{
                        "pool": "pool1",
                        "addresses": [
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    }],
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            })
        nodepool_basic = gcp.gkeonprem.BareMetalNodePool("nodepool-basic",
            name="my-nodepool",
            bare_metal_cluster=default_basic.name,
            location="us-west1",
            node_pool_config={
                "operating_system": "LINUX",
                "node_configs": [{
                    "node_ip": "10.200.0.11",
                }],
            })
        ```
        ### Gkeonprem Bare Metal Node Pool Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_full = gcp.gkeonprem.BareMetalCluster("default-full",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                    },
                },
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "metal_lb_config": {
                    "address_pools": [{
                        "pool": "pool1",
                        "addresses": [
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    }],
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            })
        nodepool_full = gcp.gkeonprem.BareMetalNodePool("nodepool-full",
            name="my-nodepool",
            display_name="test-name",
            bare_metal_cluster=default_full.name,
            location="us-west1",
            annotations={},
            node_pool_config={
                "operating_system": "LINUX",
                "labels": {},
                "node_configs": [{
                    "node_ip": "10.200.0.11",
                    "labels": {},
                }],
                "taints": [{
                    "key": "test-key",
                    "value": "test-value",
                    "effect": "NO_EXECUTE",
                }],
            })
        ```

        ## Import

        BareMetalNodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/bareMetalClusters/{{bare_metal_cluster}}/bareMetalNodePools/{{name}}`

        * `{{project}}/{{location}}/{{bare_metal_cluster}}/{{name}}`

        * `{{location}}/{{bare_metal_cluster}}/{{name}}`

        When using the `pulumi import` command, BareMetalNodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default projects/{{project}}/locations/{{location}}/bareMetalClusters/{{bare_metal_cluster}}/bareMetalNodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default {{project}}/{{location}}/{{bare_metal_cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default {{location}}/{{bare_metal_cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations on the Bare Metal Node Pool.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] bare_metal_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Bare Metal Node Pool.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: The bare metal node pool name.
        :param pulumi.Input[Union['BareMetalNodePoolNodePoolConfigArgs', 'BareMetalNodePoolNodePoolConfigArgsDict']] node_pool_config: Node pool configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BareMetalNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Bare Metal Node Pool.

        To get more information about BareMetalNodePool, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/distributed-cloud/reference/on-prem-api/rest/v1/projects.locations.bareMetalClusters.bareMetalNodePools)

        ## Example Usage

        ### Gkeonprem Bare Metal Node Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_basic = gcp.gkeonprem.BareMetalCluster("default-basic",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                    },
                },
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "metal_lb_config": {
                    "address_pools": [{
                        "pool": "pool1",
                        "addresses": [
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    }],
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            })
        nodepool_basic = gcp.gkeonprem.BareMetalNodePool("nodepool-basic",
            name="my-nodepool",
            bare_metal_cluster=default_basic.name,
            location="us-west1",
            node_pool_config={
                "operating_system": "LINUX",
                "node_configs": [{
                    "node_ip": "10.200.0.11",
                }],
            })
        ```
        ### Gkeonprem Bare Metal Node Pool Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_full = gcp.gkeonprem.BareMetalCluster("default-full",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                    },
                },
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "metal_lb_config": {
                    "address_pools": [{
                        "pool": "pool1",
                        "addresses": [
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    }],
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            })
        nodepool_full = gcp.gkeonprem.BareMetalNodePool("nodepool-full",
            name="my-nodepool",
            display_name="test-name",
            bare_metal_cluster=default_full.name,
            location="us-west1",
            annotations={},
            node_pool_config={
                "operating_system": "LINUX",
                "labels": {},
                "node_configs": [{
                    "node_ip": "10.200.0.11",
                    "labels": {},
                }],
                "taints": [{
                    "key": "test-key",
                    "value": "test-value",
                    "effect": "NO_EXECUTE",
                }],
            })
        ```

        ## Import

        BareMetalNodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/bareMetalClusters/{{bare_metal_cluster}}/bareMetalNodePools/{{name}}`

        * `{{project}}/{{location}}/{{bare_metal_cluster}}/{{name}}`

        * `{{location}}/{{bare_metal_cluster}}/{{name}}`

        When using the `pulumi import` command, BareMetalNodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default projects/{{project}}/locations/{{location}}/bareMetalClusters/{{bare_metal_cluster}}/bareMetalNodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default {{project}}/{{location}}/{{bare_metal_cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default {{location}}/{{bare_metal_cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BareMetalNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BareMetalNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bare_metal_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_config: Optional[pulumi.Input[Union['BareMetalNodePoolNodePoolConfigArgs', 'BareMetalNodePoolNodePoolConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BareMetalNodePoolArgs.__new__(BareMetalNodePoolArgs)

            __props__.__dict__["annotations"] = annotations
            if bare_metal_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'bare_metal_cluster'")
            __props__.__dict__["bare_metal_cluster"] = bare_metal_cluster
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if node_pool_config is None and not opts.urn:
                raise TypeError("Missing required property 'node_pool_config'")
            __props__.__dict__["node_pool_config"] = node_pool_config
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(BareMetalNodePool, __self__).__init__(
            'gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            bare_metal_cluster: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_time: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_pool_config: Optional[pulumi.Input[Union['BareMetalNodePoolNodePoolConfigArgs', 'BareMetalNodePoolNodePoolConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BareMetalNodePoolStatusArgs', 'BareMetalNodePoolStatusArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'BareMetalNodePool':
        """
        Get an existing BareMetalNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations on the Bare Metal Node Pool.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] bare_metal_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[_builtins.str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[_builtins.str] delete_time: The time the cluster was deleted, in RFC3339 text format.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Bare Metal Node Pool.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: The bare metal node pool name.
        :param pulumi.Input[Union['BareMetalNodePoolNodePoolConfigArgs', 'BareMetalNodePoolNodePoolConfigArgsDict']] node_pool_config: Node pool configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] reconciling: If set, there are currently changes in flight to the Bare Metal User Cluster.
        :param pulumi.Input[_builtins.str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BareMetalNodePoolStatusArgs', 'BareMetalNodePoolStatusArgsDict']]]] statuses: Specifies detailed node pool status.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the Bare Metal Node Pool.
        :param pulumi.Input[_builtins.str] update_time: The time the cluster was last updated, in RFC3339 text format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BareMetalNodePoolState.__new__(_BareMetalNodePoolState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["bare_metal_cluster"] = bare_metal_cluster
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["node_pool_config"] = node_pool_config
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return BareMetalNodePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Annotations on the Bare Metal Node Pool.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="bareMetalCluster")
    def bare_metal_cluster(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "bare_metal_cluster")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time the cluster was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name for the Bare Metal Node Pool.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The bare metal node pool name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> pulumi.Output['outputs.BareMetalNodePoolNodePoolConfig']:
        """
        Node pool configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "node_pool_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        If set, there are currently changes in flight to the Bare Metal User Cluster.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.BareMetalNodePoolStatus']]:
        """
        Specifies detailed node pool status.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the Bare Metal Node Pool.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

