# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VmwareAdminClusterArgs', 'VmwareAdminCluster']

@pulumi.input_type
class VmwareAdminClusterArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 network_config: pulumi.Input['VmwareAdminClusterNetworkConfigArgs'],
                 addon_node: Optional[pulumi.Input['VmwareAdminClusterAddonNodeArgs']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 anti_affinity_groups: Optional[pulumi.Input['VmwareAdminClusterAntiAffinityGroupsArgs']] = None,
                 authorization: Optional[pulumi.Input['VmwareAdminClusterAuthorizationArgs']] = None,
                 auto_repair_config: Optional[pulumi.Input['VmwareAdminClusterAutoRepairConfigArgs']] = None,
                 bootstrap_cluster_membership: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_node: Optional[pulumi.Input['VmwareAdminClusterControlPlaneNodeArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_advanced_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer: Optional[pulumi.Input['VmwareAdminClusterLoadBalancerArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_prem_version: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_config: Optional[pulumi.Input['VmwareAdminClusterPlatformConfigArgs']] = None,
                 private_registry_config: Optional[pulumi.Input['VmwareAdminClusterPrivateRegistryConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy: Optional[pulumi.Input['VmwareAdminClusterProxyArgs']] = None,
                 vcenter: Optional[pulumi.Input['VmwareAdminClusterVcenterArgs']] = None):
        """
        The set of arguments for constructing a VmwareAdminCluster resource.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input['VmwareAdminClusterNetworkConfigArgs'] network_config: The VMware admin cluster network configuration.
               Structure is documented below.
        :param pulumi.Input['VmwareAdminClusterAddonNodeArgs'] addon_node: The VMware admin cluster addon node configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations on the VMware Admin Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['VmwareAdminClusterAntiAffinityGroupsArgs'] anti_affinity_groups: AAGConfig specifies whether to spread VMware Admin Cluster nodes across at
               least three physical hosts in the datacenter.
               Structure is documented below.
        :param pulumi.Input['VmwareAdminClusterAuthorizationArgs'] authorization: The VMware admin cluster authorization configuration.
               Structure is documented below.
        :param pulumi.Input['VmwareAdminClusterAutoRepairConfigArgs'] auto_repair_config: Configuration for auto repairing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] bootstrap_cluster_membership: The bootstrap cluster this VMware admin cluster belongs to.
        :param pulumi.Input['VmwareAdminClusterControlPlaneNodeArgs'] control_plane_node: The VMware admin cluster control plane node configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A human readable description of this VMware admin cluster.
        :param pulumi.Input[_builtins.bool] enable_advanced_cluster: If set, the advanced cluster feature is enabled.
        :param pulumi.Input[_builtins.str] image_type: The OS image type for the VMware admin cluster.
        :param pulumi.Input['VmwareAdminClusterLoadBalancerArgs'] load_balancer: Specifies the load balancer configuration for VMware admin cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The VMware admin cluster resource name.
        :param pulumi.Input[_builtins.str] on_prem_version: The Anthos clusters on the VMware version for the admin cluster.
        :param pulumi.Input['VmwareAdminClusterPlatformConfigArgs'] platform_config: The VMware platform configuration.
               Structure is documented below.
        :param pulumi.Input['VmwareAdminClusterPrivateRegistryConfigArgs'] private_registry_config: Configuration for private registry.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['VmwareAdminClusterProxyArgs'] proxy: Configuration for proxy.
               Structure is documented below.
        :param pulumi.Input['VmwareAdminClusterVcenterArgs'] vcenter: Specifies vCenter config for the admin cluster.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network_config", network_config)
        if addon_node is not None:
            pulumi.set(__self__, "addon_node", addon_node)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anti_affinity_groups is not None:
            pulumi.set(__self__, "anti_affinity_groups", anti_affinity_groups)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if auto_repair_config is not None:
            pulumi.set(__self__, "auto_repair_config", auto_repair_config)
        if bootstrap_cluster_membership is not None:
            pulumi.set(__self__, "bootstrap_cluster_membership", bootstrap_cluster_membership)
        if control_plane_node is not None:
            pulumi.set(__self__, "control_plane_node", control_plane_node)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_advanced_cluster is not None:
            pulumi.set(__self__, "enable_advanced_cluster", enable_advanced_cluster)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_prem_version is not None:
            pulumi.set(__self__, "on_prem_version", on_prem_version)
        if platform_config is not None:
            pulumi.set(__self__, "platform_config", platform_config)
        if private_registry_config is not None:
            pulumi.set(__self__, "private_registry_config", private_registry_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if vcenter is not None:
            pulumi.set(__self__, "vcenter", vcenter)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Input['VmwareAdminClusterNetworkConfigArgs']:
        """
        The VMware admin cluster network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: pulumi.Input['VmwareAdminClusterNetworkConfigArgs']):
        pulumi.set(self, "network_config", value)

    @_builtins.property
    @pulumi.getter(name="addonNode")
    def addon_node(self) -> Optional[pulumi.Input['VmwareAdminClusterAddonNodeArgs']]:
        """
        The VMware admin cluster addon node configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "addon_node")

    @addon_node.setter
    def addon_node(self, value: Optional[pulumi.Input['VmwareAdminClusterAddonNodeArgs']]):
        pulumi.set(self, "addon_node", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations on the VMware Admin Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="antiAffinityGroups")
    def anti_affinity_groups(self) -> Optional[pulumi.Input['VmwareAdminClusterAntiAffinityGroupsArgs']]:
        """
        AAGConfig specifies whether to spread VMware Admin Cluster nodes across at
        least three physical hosts in the datacenter.
        Structure is documented below.
        """
        return pulumi.get(self, "anti_affinity_groups")

    @anti_affinity_groups.setter
    def anti_affinity_groups(self, value: Optional[pulumi.Input['VmwareAdminClusterAntiAffinityGroupsArgs']]):
        pulumi.set(self, "anti_affinity_groups", value)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['VmwareAdminClusterAuthorizationArgs']]:
        """
        The VMware admin cluster authorization configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['VmwareAdminClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter(name="autoRepairConfig")
    def auto_repair_config(self) -> Optional[pulumi.Input['VmwareAdminClusterAutoRepairConfigArgs']]:
        """
        Configuration for auto repairing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_repair_config")

    @auto_repair_config.setter
    def auto_repair_config(self, value: Optional[pulumi.Input['VmwareAdminClusterAutoRepairConfigArgs']]):
        pulumi.set(self, "auto_repair_config", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapClusterMembership")
    def bootstrap_cluster_membership(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bootstrap cluster this VMware admin cluster belongs to.
        """
        return pulumi.get(self, "bootstrap_cluster_membership")

    @bootstrap_cluster_membership.setter
    def bootstrap_cluster_membership(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bootstrap_cluster_membership", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneNode")
    def control_plane_node(self) -> Optional[pulumi.Input['VmwareAdminClusterControlPlaneNodeArgs']]:
        """
        The VMware admin cluster control plane node configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_node")

    @control_plane_node.setter
    def control_plane_node(self, value: Optional[pulumi.Input['VmwareAdminClusterControlPlaneNodeArgs']]):
        pulumi.set(self, "control_plane_node", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human readable description of this VMware admin cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAdvancedCluster")
    def enable_advanced_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, the advanced cluster feature is enabled.
        """
        return pulumi.get(self, "enable_advanced_cluster")

    @enable_advanced_cluster.setter
    def enable_advanced_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_advanced_cluster", value)

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OS image type for the VMware admin cluster.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['VmwareAdminClusterLoadBalancerArgs']]:
        """
        Specifies the load balancer configuration for VMware admin cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['VmwareAdminClusterLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VMware admin cluster resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onPremVersion")
    def on_prem_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Anthos clusters on the VMware version for the admin cluster.
        """
        return pulumi.get(self, "on_prem_version")

    @on_prem_version.setter
    def on_prem_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_prem_version", value)

    @_builtins.property
    @pulumi.getter(name="platformConfig")
    def platform_config(self) -> Optional[pulumi.Input['VmwareAdminClusterPlatformConfigArgs']]:
        """
        The VMware platform configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "platform_config")

    @platform_config.setter
    def platform_config(self, value: Optional[pulumi.Input['VmwareAdminClusterPlatformConfigArgs']]):
        pulumi.set(self, "platform_config", value)

    @_builtins.property
    @pulumi.getter(name="privateRegistryConfig")
    def private_registry_config(self) -> Optional[pulumi.Input['VmwareAdminClusterPrivateRegistryConfigArgs']]:
        """
        Configuration for private registry.
        Structure is documented below.
        """
        return pulumi.get(self, "private_registry_config")

    @private_registry_config.setter
    def private_registry_config(self, value: Optional[pulumi.Input['VmwareAdminClusterPrivateRegistryConfigArgs']]):
        pulumi.set(self, "private_registry_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['VmwareAdminClusterProxyArgs']]:
        """
        Configuration for proxy.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['VmwareAdminClusterProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @_builtins.property
    @pulumi.getter
    def vcenter(self) -> Optional[pulumi.Input['VmwareAdminClusterVcenterArgs']]:
        """
        Specifies vCenter config for the admin cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "vcenter")

    @vcenter.setter
    def vcenter(self, value: Optional[pulumi.Input['VmwareAdminClusterVcenterArgs']]):
        pulumi.set(self, "vcenter", value)


@pulumi.input_type
class _VmwareAdminClusterState:
    def __init__(__self__, *,
                 addon_node: Optional[pulumi.Input['VmwareAdminClusterAddonNodeArgs']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 anti_affinity_groups: Optional[pulumi.Input['VmwareAdminClusterAntiAffinityGroupsArgs']] = None,
                 authorization: Optional[pulumi.Input['VmwareAdminClusterAuthorizationArgs']] = None,
                 auto_repair_config: Optional[pulumi.Input['VmwareAdminClusterAutoRepairConfigArgs']] = None,
                 bootstrap_cluster_membership: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_node: Optional[pulumi.Input['VmwareAdminClusterControlPlaneNodeArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_advanced_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 fleets: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareAdminClusterFleetArgs']]]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer: Optional[pulumi.Input['VmwareAdminClusterLoadBalancerArgs']] = None,
                 local_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_config: Optional[pulumi.Input['VmwareAdminClusterNetworkConfigArgs']] = None,
                 on_prem_version: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_config: Optional[pulumi.Input['VmwareAdminClusterPlatformConfigArgs']] = None,
                 private_registry_config: Optional[pulumi.Input['VmwareAdminClusterPrivateRegistryConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy: Optional[pulumi.Input['VmwareAdminClusterProxyArgs']] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareAdminClusterStatusArgs']]]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vcenter: Optional[pulumi.Input['VmwareAdminClusterVcenterArgs']] = None):
        """
        Input properties used for looking up and filtering VmwareAdminCluster resources.
        :param pulumi.Input['VmwareAdminClusterAddonNodeArgs'] addon_node: The VMware admin cluster addon node configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations on the VMware Admin Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['VmwareAdminClusterAntiAffinityGroupsArgs'] anti_affinity_groups: AAGConfig specifies whether to spread VMware Admin Cluster nodes across at
               least three physical hosts in the datacenter.
               Structure is documented below.
        :param pulumi.Input['VmwareAdminClusterAuthorizationArgs'] authorization: The VMware admin cluster authorization configuration.
               Structure is documented below.
        :param pulumi.Input['VmwareAdminClusterAutoRepairConfigArgs'] auto_repair_config: Configuration for auto repairing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] bootstrap_cluster_membership: The bootstrap cluster this VMware admin cluster belongs to.
        :param pulumi.Input['VmwareAdminClusterControlPlaneNodeArgs'] control_plane_node: The VMware admin cluster control plane node configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: A human readable description of this VMware admin cluster.
        :param pulumi.Input[_builtins.bool] enable_advanced_cluster: If set, the advanced cluster feature is enabled.
        :param pulumi.Input[_builtins.str] endpoint: The DNS name of VMware admin cluster's API server.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[Sequence[pulumi.Input['VmwareAdminClusterFleetArgs']]] fleets: Fleet configuration for the cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] image_type: The OS image type for the VMware admin cluster.
        :param pulumi.Input['VmwareAdminClusterLoadBalancerArgs'] load_balancer: Specifies the load balancer configuration for VMware admin cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] local_name: The object name of the VMwareAdminCluster custom resource on the
               associated admin cluster. This field is used to support conflicting
               names when enrolling existing clusters to the API. When used as a part of
               cluster enrollment, this field will differ from the ID in the resource
               name. For new clusters, this field will match the user provided cluster ID
               and be visible in the last component of the resource name. It is not
               modifiable.
               All users should use this name to access their cluster using gkectl or
               kubectl and should expect to see the local name when viewing admin
               cluster controller logs.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: The VMware admin cluster resource name.
        :param pulumi.Input['VmwareAdminClusterNetworkConfigArgs'] network_config: The VMware admin cluster network configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] on_prem_version: The Anthos clusters on the VMware version for the admin cluster.
        :param pulumi.Input['VmwareAdminClusterPlatformConfigArgs'] platform_config: The VMware platform configuration.
               Structure is documented below.
        :param pulumi.Input['VmwareAdminClusterPrivateRegistryConfigArgs'] private_registry_config: Configuration for private registry.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['VmwareAdminClusterProxyArgs'] proxy: Configuration for proxy.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] reconciling: If set, there are currently changes in flight to the VMware admin cluster.
        :param pulumi.Input[_builtins.str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input['VmwareAdminClusterStatusArgs']]] statuses: ResourceStatus representing detailed cluster state.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the VMware Admin Cluster.
        :param pulumi.Input[_builtins.str] update_time: The time the cluster was last updated, in RFC3339 text format.
        :param pulumi.Input['VmwareAdminClusterVcenterArgs'] vcenter: Specifies vCenter config for the admin cluster.
               Structure is documented below.
        """
        if addon_node is not None:
            pulumi.set(__self__, "addon_node", addon_node)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anti_affinity_groups is not None:
            pulumi.set(__self__, "anti_affinity_groups", anti_affinity_groups)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if auto_repair_config is not None:
            pulumi.set(__self__, "auto_repair_config", auto_repair_config)
        if bootstrap_cluster_membership is not None:
            pulumi.set(__self__, "bootstrap_cluster_membership", bootstrap_cluster_membership)
        if control_plane_node is not None:
            pulumi.set(__self__, "control_plane_node", control_plane_node)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if enable_advanced_cluster is not None:
            pulumi.set(__self__, "enable_advanced_cluster", enable_advanced_cluster)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if fleets is not None:
            pulumi.set(__self__, "fleets", fleets)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if local_name is not None:
            pulumi.set(__self__, "local_name", local_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if on_prem_version is not None:
            pulumi.set(__self__, "on_prem_version", on_prem_version)
        if platform_config is not None:
            pulumi.set(__self__, "platform_config", platform_config)
        if private_registry_config is not None:
            pulumi.set(__self__, "private_registry_config", private_registry_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vcenter is not None:
            pulumi.set(__self__, "vcenter", vcenter)

    @_builtins.property
    @pulumi.getter(name="addonNode")
    def addon_node(self) -> Optional[pulumi.Input['VmwareAdminClusterAddonNodeArgs']]:
        """
        The VMware admin cluster addon node configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "addon_node")

    @addon_node.setter
    def addon_node(self, value: Optional[pulumi.Input['VmwareAdminClusterAddonNodeArgs']]):
        pulumi.set(self, "addon_node", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations on the VMware Admin Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="antiAffinityGroups")
    def anti_affinity_groups(self) -> Optional[pulumi.Input['VmwareAdminClusterAntiAffinityGroupsArgs']]:
        """
        AAGConfig specifies whether to spread VMware Admin Cluster nodes across at
        least three physical hosts in the datacenter.
        Structure is documented below.
        """
        return pulumi.get(self, "anti_affinity_groups")

    @anti_affinity_groups.setter
    def anti_affinity_groups(self, value: Optional[pulumi.Input['VmwareAdminClusterAntiAffinityGroupsArgs']]):
        pulumi.set(self, "anti_affinity_groups", value)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['VmwareAdminClusterAuthorizationArgs']]:
        """
        The VMware admin cluster authorization configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['VmwareAdminClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter(name="autoRepairConfig")
    def auto_repair_config(self) -> Optional[pulumi.Input['VmwareAdminClusterAutoRepairConfigArgs']]:
        """
        Configuration for auto repairing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_repair_config")

    @auto_repair_config.setter
    def auto_repair_config(self, value: Optional[pulumi.Input['VmwareAdminClusterAutoRepairConfigArgs']]):
        pulumi.set(self, "auto_repair_config", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapClusterMembership")
    def bootstrap_cluster_membership(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bootstrap cluster this VMware admin cluster belongs to.
        """
        return pulumi.get(self, "bootstrap_cluster_membership")

    @bootstrap_cluster_membership.setter
    def bootstrap_cluster_membership(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bootstrap_cluster_membership", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneNode")
    def control_plane_node(self) -> Optional[pulumi.Input['VmwareAdminClusterControlPlaneNodeArgs']]:
        """
        The VMware admin cluster control plane node configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_node")

    @control_plane_node.setter
    def control_plane_node(self, value: Optional[pulumi.Input['VmwareAdminClusterControlPlaneNodeArgs']]):
        pulumi.set(self, "control_plane_node", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human readable description of this VMware admin cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="enableAdvancedCluster")
    def enable_advanced_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, the advanced cluster feature is enabled.
        """
        return pulumi.get(self, "enable_advanced_cluster")

    @enable_advanced_cluster.setter
    def enable_advanced_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_advanced_cluster", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS name of VMware admin cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def fleets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmwareAdminClusterFleetArgs']]]]:
        """
        Fleet configuration for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "fleets")

    @fleets.setter
    def fleets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareAdminClusterFleetArgs']]]]):
        pulumi.set(self, "fleets", value)

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OS image type for the VMware admin cluster.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['VmwareAdminClusterLoadBalancerArgs']]:
        """
        Specifies the load balancer configuration for VMware admin cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['VmwareAdminClusterLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @_builtins.property
    @pulumi.getter(name="localName")
    def local_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object name of the VMwareAdminCluster custom resource on the
        associated admin cluster. This field is used to support conflicting
        names when enrolling existing clusters to the API. When used as a part of
        cluster enrollment, this field will differ from the ID in the resource
        name. For new clusters, this field will match the user provided cluster ID
        and be visible in the last component of the resource name. It is not
        modifiable.
        All users should use this name to access their cluster using gkectl or
        kubectl and should expect to see the local name when viewing admin
        cluster controller logs.
        """
        return pulumi.get(self, "local_name")

    @local_name.setter
    def local_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VMware admin cluster resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['VmwareAdminClusterNetworkConfigArgs']]:
        """
        The VMware admin cluster network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['VmwareAdminClusterNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @_builtins.property
    @pulumi.getter(name="onPremVersion")
    def on_prem_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Anthos clusters on the VMware version for the admin cluster.
        """
        return pulumi.get(self, "on_prem_version")

    @on_prem_version.setter
    def on_prem_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_prem_version", value)

    @_builtins.property
    @pulumi.getter(name="platformConfig")
    def platform_config(self) -> Optional[pulumi.Input['VmwareAdminClusterPlatformConfigArgs']]:
        """
        The VMware platform configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "platform_config")

    @platform_config.setter
    def platform_config(self, value: Optional[pulumi.Input['VmwareAdminClusterPlatformConfigArgs']]):
        pulumi.set(self, "platform_config", value)

    @_builtins.property
    @pulumi.getter(name="privateRegistryConfig")
    def private_registry_config(self) -> Optional[pulumi.Input['VmwareAdminClusterPrivateRegistryConfigArgs']]:
        """
        Configuration for private registry.
        Structure is documented below.
        """
        return pulumi.get(self, "private_registry_config")

    @private_registry_config.setter
    def private_registry_config(self, value: Optional[pulumi.Input['VmwareAdminClusterPrivateRegistryConfigArgs']]):
        pulumi.set(self, "private_registry_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['VmwareAdminClusterProxyArgs']]:
        """
        Configuration for proxy.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['VmwareAdminClusterProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, there are currently changes in flight to the VMware admin cluster.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmwareAdminClusterStatusArgs']]]]:
        """
        ResourceStatus representing detailed cluster state.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareAdminClusterStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the VMware Admin Cluster.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter
    def vcenter(self) -> Optional[pulumi.Input['VmwareAdminClusterVcenterArgs']]:
        """
        Specifies vCenter config for the admin cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "vcenter")

    @vcenter.setter
    def vcenter(self, value: Optional[pulumi.Input['VmwareAdminClusterVcenterArgs']]):
        pulumi.set(self, "vcenter", value)


@pulumi.type_token("gcp:gkeonprem/vmwareAdminCluster:VmwareAdminCluster")
class VmwareAdminCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_node: Optional[pulumi.Input[Union['VmwareAdminClusterAddonNodeArgs', 'VmwareAdminClusterAddonNodeArgsDict']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 anti_affinity_groups: Optional[pulumi.Input[Union['VmwareAdminClusterAntiAffinityGroupsArgs', 'VmwareAdminClusterAntiAffinityGroupsArgsDict']]] = None,
                 authorization: Optional[pulumi.Input[Union['VmwareAdminClusterAuthorizationArgs', 'VmwareAdminClusterAuthorizationArgsDict']]] = None,
                 auto_repair_config: Optional[pulumi.Input[Union['VmwareAdminClusterAutoRepairConfigArgs', 'VmwareAdminClusterAutoRepairConfigArgsDict']]] = None,
                 bootstrap_cluster_membership: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_node: Optional[pulumi.Input[Union['VmwareAdminClusterControlPlaneNodeArgs', 'VmwareAdminClusterControlPlaneNodeArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_advanced_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer: Optional[pulumi.Input[Union['VmwareAdminClusterLoadBalancerArgs', 'VmwareAdminClusterLoadBalancerArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['VmwareAdminClusterNetworkConfigArgs', 'VmwareAdminClusterNetworkConfigArgsDict']]] = None,
                 on_prem_version: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_config: Optional[pulumi.Input[Union['VmwareAdminClusterPlatformConfigArgs', 'VmwareAdminClusterPlatformConfigArgsDict']]] = None,
                 private_registry_config: Optional[pulumi.Input[Union['VmwareAdminClusterPrivateRegistryConfigArgs', 'VmwareAdminClusterPrivateRegistryConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy: Optional[pulumi.Input[Union['VmwareAdminClusterProxyArgs', 'VmwareAdminClusterProxyArgsDict']]] = None,
                 vcenter: Optional[pulumi.Input[Union['VmwareAdminClusterVcenterArgs', 'VmwareAdminClusterVcenterArgsDict']]] = None,
                 __props__=None):
        """
        A Google VMware Admin Cluster.

        To get more information about VmwareAdminCluster, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/distributed-cloud/reference/on-prem-api/rest/v1/projects.locations.vmwareAdminClusters)

        ## Example Usage

        ### Gkeonprem Vmware Admin Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin_cluster_basic = gcp.gkeonprem.VmwareAdminCluster("admin-cluster-basic",
            name="basic",
            location="us-west1",
            description="test admin cluster",
            bootstrap_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            on_prem_version="1.31.0-gke.35",
            image_type="ubuntu_containerd",
            vcenter={
                "resource_pool": "test resource pool",
                "datastore": "test data store",
                "datacenter": "test data center",
                "cluster": "test cluster",
                "folder": "test folder",
                "ca_cert_data": "test ca cert data",
                "address": "10.0.0.1",
                "data_disk": "test data disk",
            },
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "dhcp_ip_config": {
                    "enabled": True,
                },
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "addons_vip": "10.251.135.19",
                },
                "f5_config": {
                    "address": "10.251.135.22",
                    "partition": "test-parition",
                    "snat_pool": "test-snat-pool",
                },
            },
            private_registry_config={
                "address": "test-address",
                "ca_cert": "test-ca-cert",
            })
        ```
        ### Gkeonprem Vmware Admin Cluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin_cluster_full = gcp.gkeonprem.VmwareAdminCluster("admin-cluster-full",
            name="full",
            location="us-west1",
            description="test admin cluster",
            bootstrap_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            on_prem_version="1.31.0-gke.35",
            image_type="ubuntu_containerd",
            annotations={},
            vcenter={
                "resource_pool": "test resource pool",
                "datastore": "test data store",
                "datacenter": "test data center",
                "cluster": "test cluster",
                "folder": "test folder",
                "ca_cert_data": "test ca cert data",
                "address": "10.0.0.1",
                "data_disk": "test data disk",
                "storage_policy_name": "storage_policy_name",
            },
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "ha_control_plane_config": {
                    "control_plane_ip_block": {
                        "gateway": "10.0.0.3",
                        "ips": [{
                            "hostname": "hostname",
                            "ip": "10.0.0.4",
                        }],
                        "netmask": "10.0.0.3/32",
                    },
                },
                "host_config": {
                    "dns_servers": ["10.254.41.1"],
                    "ntp_servers": ["216.239.35.8"],
                    "dns_search_domains": ["test-domain"],
                },
                "static_ip_config": {
                    "ip_blocks": [{
                        "gateway": "10.0.0.1",
                        "ips": [{
                            "hostname": "hostname",
                            "ip": "10.0.0.2",
                        }],
                        "netmask": "10.0.0.3/32",
                    }],
                },
                "vcenter_network": "test-vcenter-network",
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
                "replicas": 3,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "addons_vip": "10.251.135.19",
                },
                "manual_lb_config": {
                    "addons_node_port": 30005,
                    "control_plane_node_port": 30006,
                    "ingress_http_node_port": 30007,
                    "ingress_https_node_port": 30008,
                    "konnectivity_server_node_port": 30009,
                },
            },
            addon_node={
                "auto_resize_config": {
                    "enabled": True,
                },
            },
            anti_affinity_groups={
                "aag_config_disabled": True,
            },
            authorization={
                "viewer_users": [{
                    "username": "user1@gmail.com",
                }],
            },
            auto_repair_config={
                "enabled": True,
            },
            platform_config={
                "required_platform_version": "1.31.0",
            },
            private_registry_config={
                "address": "test-address",
                "ca_cert": "test-ca-cert",
            },
            proxy={
                "url": "http://my-proxy.example.local:80",
                "no_proxy": "10.151.222.0/24,my-host.example.local,10.151.2.1",
            })
        ```
        ### Gkeonprem Vmware Admin Cluster Metallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin_cluster_metallb = gcp.gkeonprem.VmwareAdminCluster("admin-cluster-metallb",
            name="metallb",
            location="us-west1",
            description="test admin cluster",
            bootstrap_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            on_prem_version="1.33.0-gke.35",
            image_type="ubuntu_containerd",
            enable_advanced_cluster=True,
            vcenter={
                "resource_pool": "test resource pool",
                "datastore": "test data store",
                "datacenter": "test data center",
                "cluster": "test cluster",
                "folder": "test folder",
                "ca_cert_data": "test ca cert data",
                "address": "10.0.0.1",
                "data_disk": "test data disk",
            },
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "dhcp_ip_config": {
                    "enabled": True,
                },
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "addons_vip": "10.251.135.19",
                },
                "metal_lb_config": {
                    "enabled": True,
                },
            },
            private_registry_config={
                "address": "test-address",
                "ca_cert": "test-ca-cert",
            },
            proxy={
                "url": "http://my-proxy.example.local:80",
                "no_proxy": "10.151.222.0/24,my-host.example.local,10.151.2.1",
            })
        ```

        ## Import

        VmwareAdminCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vmwareAdminClusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, VmwareAdminCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkeonprem/vmwareAdminCluster:VmwareAdminCluster default projects/{{project}}/locations/{{location}}/vmwareAdminClusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/vmwareAdminCluster:VmwareAdminCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/vmwareAdminCluster:VmwareAdminCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VmwareAdminClusterAddonNodeArgs', 'VmwareAdminClusterAddonNodeArgsDict']] addon_node: The VMware admin cluster addon node configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations on the VMware Admin Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['VmwareAdminClusterAntiAffinityGroupsArgs', 'VmwareAdminClusterAntiAffinityGroupsArgsDict']] anti_affinity_groups: AAGConfig specifies whether to spread VMware Admin Cluster nodes across at
               least three physical hosts in the datacenter.
               Structure is documented below.
        :param pulumi.Input[Union['VmwareAdminClusterAuthorizationArgs', 'VmwareAdminClusterAuthorizationArgsDict']] authorization: The VMware admin cluster authorization configuration.
               Structure is documented below.
        :param pulumi.Input[Union['VmwareAdminClusterAutoRepairConfigArgs', 'VmwareAdminClusterAutoRepairConfigArgsDict']] auto_repair_config: Configuration for auto repairing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] bootstrap_cluster_membership: The bootstrap cluster this VMware admin cluster belongs to.
        :param pulumi.Input[Union['VmwareAdminClusterControlPlaneNodeArgs', 'VmwareAdminClusterControlPlaneNodeArgsDict']] control_plane_node: The VMware admin cluster control plane node configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A human readable description of this VMware admin cluster.
        :param pulumi.Input[_builtins.bool] enable_advanced_cluster: If set, the advanced cluster feature is enabled.
        :param pulumi.Input[_builtins.str] image_type: The OS image type for the VMware admin cluster.
        :param pulumi.Input[Union['VmwareAdminClusterLoadBalancerArgs', 'VmwareAdminClusterLoadBalancerArgsDict']] load_balancer: Specifies the load balancer configuration for VMware admin cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: The VMware admin cluster resource name.
        :param pulumi.Input[Union['VmwareAdminClusterNetworkConfigArgs', 'VmwareAdminClusterNetworkConfigArgsDict']] network_config: The VMware admin cluster network configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] on_prem_version: The Anthos clusters on the VMware version for the admin cluster.
        :param pulumi.Input[Union['VmwareAdminClusterPlatformConfigArgs', 'VmwareAdminClusterPlatformConfigArgsDict']] platform_config: The VMware platform configuration.
               Structure is documented below.
        :param pulumi.Input[Union['VmwareAdminClusterPrivateRegistryConfigArgs', 'VmwareAdminClusterPrivateRegistryConfigArgsDict']] private_registry_config: Configuration for private registry.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['VmwareAdminClusterProxyArgs', 'VmwareAdminClusterProxyArgsDict']] proxy: Configuration for proxy.
               Structure is documented below.
        :param pulumi.Input[Union['VmwareAdminClusterVcenterArgs', 'VmwareAdminClusterVcenterArgsDict']] vcenter: Specifies vCenter config for the admin cluster.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmwareAdminClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google VMware Admin Cluster.

        To get more information about VmwareAdminCluster, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/distributed-cloud/reference/on-prem-api/rest/v1/projects.locations.vmwareAdminClusters)

        ## Example Usage

        ### Gkeonprem Vmware Admin Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin_cluster_basic = gcp.gkeonprem.VmwareAdminCluster("admin-cluster-basic",
            name="basic",
            location="us-west1",
            description="test admin cluster",
            bootstrap_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            on_prem_version="1.31.0-gke.35",
            image_type="ubuntu_containerd",
            vcenter={
                "resource_pool": "test resource pool",
                "datastore": "test data store",
                "datacenter": "test data center",
                "cluster": "test cluster",
                "folder": "test folder",
                "ca_cert_data": "test ca cert data",
                "address": "10.0.0.1",
                "data_disk": "test data disk",
            },
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "dhcp_ip_config": {
                    "enabled": True,
                },
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "addons_vip": "10.251.135.19",
                },
                "f5_config": {
                    "address": "10.251.135.22",
                    "partition": "test-parition",
                    "snat_pool": "test-snat-pool",
                },
            },
            private_registry_config={
                "address": "test-address",
                "ca_cert": "test-ca-cert",
            })
        ```
        ### Gkeonprem Vmware Admin Cluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin_cluster_full = gcp.gkeonprem.VmwareAdminCluster("admin-cluster-full",
            name="full",
            location="us-west1",
            description="test admin cluster",
            bootstrap_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            on_prem_version="1.31.0-gke.35",
            image_type="ubuntu_containerd",
            annotations={},
            vcenter={
                "resource_pool": "test resource pool",
                "datastore": "test data store",
                "datacenter": "test data center",
                "cluster": "test cluster",
                "folder": "test folder",
                "ca_cert_data": "test ca cert data",
                "address": "10.0.0.1",
                "data_disk": "test data disk",
                "storage_policy_name": "storage_policy_name",
            },
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "ha_control_plane_config": {
                    "control_plane_ip_block": {
                        "gateway": "10.0.0.3",
                        "ips": [{
                            "hostname": "hostname",
                            "ip": "10.0.0.4",
                        }],
                        "netmask": "10.0.0.3/32",
                    },
                },
                "host_config": {
                    "dns_servers": ["10.254.41.1"],
                    "ntp_servers": ["216.239.35.8"],
                    "dns_search_domains": ["test-domain"],
                },
                "static_ip_config": {
                    "ip_blocks": [{
                        "gateway": "10.0.0.1",
                        "ips": [{
                            "hostname": "hostname",
                            "ip": "10.0.0.2",
                        }],
                        "netmask": "10.0.0.3/32",
                    }],
                },
                "vcenter_network": "test-vcenter-network",
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
                "replicas": 3,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "addons_vip": "10.251.135.19",
                },
                "manual_lb_config": {
                    "addons_node_port": 30005,
                    "control_plane_node_port": 30006,
                    "ingress_http_node_port": 30007,
                    "ingress_https_node_port": 30008,
                    "konnectivity_server_node_port": 30009,
                },
            },
            addon_node={
                "auto_resize_config": {
                    "enabled": True,
                },
            },
            anti_affinity_groups={
                "aag_config_disabled": True,
            },
            authorization={
                "viewer_users": [{
                    "username": "user1@gmail.com",
                }],
            },
            auto_repair_config={
                "enabled": True,
            },
            platform_config={
                "required_platform_version": "1.31.0",
            },
            private_registry_config={
                "address": "test-address",
                "ca_cert": "test-ca-cert",
            },
            proxy={
                "url": "http://my-proxy.example.local:80",
                "no_proxy": "10.151.222.0/24,my-host.example.local,10.151.2.1",
            })
        ```
        ### Gkeonprem Vmware Admin Cluster Metallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin_cluster_metallb = gcp.gkeonprem.VmwareAdminCluster("admin-cluster-metallb",
            name="metallb",
            location="us-west1",
            description="test admin cluster",
            bootstrap_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            on_prem_version="1.33.0-gke.35",
            image_type="ubuntu_containerd",
            enable_advanced_cluster=True,
            vcenter={
                "resource_pool": "test resource pool",
                "datastore": "test data store",
                "datacenter": "test data center",
                "cluster": "test cluster",
                "folder": "test folder",
                "ca_cert_data": "test ca cert data",
                "address": "10.0.0.1",
                "data_disk": "test data disk",
            },
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "dhcp_ip_config": {
                    "enabled": True,
                },
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "addons_vip": "10.251.135.19",
                },
                "metal_lb_config": {
                    "enabled": True,
                },
            },
            private_registry_config={
                "address": "test-address",
                "ca_cert": "test-ca-cert",
            },
            proxy={
                "url": "http://my-proxy.example.local:80",
                "no_proxy": "10.151.222.0/24,my-host.example.local,10.151.2.1",
            })
        ```

        ## Import

        VmwareAdminCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vmwareAdminClusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, VmwareAdminCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkeonprem/vmwareAdminCluster:VmwareAdminCluster default projects/{{project}}/locations/{{location}}/vmwareAdminClusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/vmwareAdminCluster:VmwareAdminCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/vmwareAdminCluster:VmwareAdminCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param VmwareAdminClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmwareAdminClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_node: Optional[pulumi.Input[Union['VmwareAdminClusterAddonNodeArgs', 'VmwareAdminClusterAddonNodeArgsDict']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 anti_affinity_groups: Optional[pulumi.Input[Union['VmwareAdminClusterAntiAffinityGroupsArgs', 'VmwareAdminClusterAntiAffinityGroupsArgsDict']]] = None,
                 authorization: Optional[pulumi.Input[Union['VmwareAdminClusterAuthorizationArgs', 'VmwareAdminClusterAuthorizationArgsDict']]] = None,
                 auto_repair_config: Optional[pulumi.Input[Union['VmwareAdminClusterAutoRepairConfigArgs', 'VmwareAdminClusterAutoRepairConfigArgsDict']]] = None,
                 bootstrap_cluster_membership: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_node: Optional[pulumi.Input[Union['VmwareAdminClusterControlPlaneNodeArgs', 'VmwareAdminClusterControlPlaneNodeArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_advanced_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer: Optional[pulumi.Input[Union['VmwareAdminClusterLoadBalancerArgs', 'VmwareAdminClusterLoadBalancerArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['VmwareAdminClusterNetworkConfigArgs', 'VmwareAdminClusterNetworkConfigArgsDict']]] = None,
                 on_prem_version: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_config: Optional[pulumi.Input[Union['VmwareAdminClusterPlatformConfigArgs', 'VmwareAdminClusterPlatformConfigArgsDict']]] = None,
                 private_registry_config: Optional[pulumi.Input[Union['VmwareAdminClusterPrivateRegistryConfigArgs', 'VmwareAdminClusterPrivateRegistryConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy: Optional[pulumi.Input[Union['VmwareAdminClusterProxyArgs', 'VmwareAdminClusterProxyArgsDict']]] = None,
                 vcenter: Optional[pulumi.Input[Union['VmwareAdminClusterVcenterArgs', 'VmwareAdminClusterVcenterArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmwareAdminClusterArgs.__new__(VmwareAdminClusterArgs)

            __props__.__dict__["addon_node"] = addon_node
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["anti_affinity_groups"] = anti_affinity_groups
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["auto_repair_config"] = auto_repair_config
            __props__.__dict__["bootstrap_cluster_membership"] = bootstrap_cluster_membership
            __props__.__dict__["control_plane_node"] = control_plane_node
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_advanced_cluster"] = enable_advanced_cluster
            __props__.__dict__["image_type"] = image_type
            __props__.__dict__["load_balancer"] = load_balancer
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if network_config is None and not opts.urn:
                raise TypeError("Missing required property 'network_config'")
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["on_prem_version"] = on_prem_version
            __props__.__dict__["platform_config"] = platform_config
            __props__.__dict__["private_registry_config"] = private_registry_config
            __props__.__dict__["project"] = project
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["vcenter"] = vcenter
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["fleets"] = None
            __props__.__dict__["local_name"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(VmwareAdminCluster, __self__).__init__(
            'gcp:gkeonprem/vmwareAdminCluster:VmwareAdminCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addon_node: Optional[pulumi.Input[Union['VmwareAdminClusterAddonNodeArgs', 'VmwareAdminClusterAddonNodeArgsDict']]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            anti_affinity_groups: Optional[pulumi.Input[Union['VmwareAdminClusterAntiAffinityGroupsArgs', 'VmwareAdminClusterAntiAffinityGroupsArgsDict']]] = None,
            authorization: Optional[pulumi.Input[Union['VmwareAdminClusterAuthorizationArgs', 'VmwareAdminClusterAuthorizationArgsDict']]] = None,
            auto_repair_config: Optional[pulumi.Input[Union['VmwareAdminClusterAutoRepairConfigArgs', 'VmwareAdminClusterAutoRepairConfigArgsDict']]] = None,
            bootstrap_cluster_membership: Optional[pulumi.Input[_builtins.str]] = None,
            control_plane_node: Optional[pulumi.Input[Union['VmwareAdminClusterControlPlaneNodeArgs', 'VmwareAdminClusterControlPlaneNodeArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            enable_advanced_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            fleets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmwareAdminClusterFleetArgs', 'VmwareAdminClusterFleetArgsDict']]]]] = None,
            image_type: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer: Optional[pulumi.Input[Union['VmwareAdminClusterLoadBalancerArgs', 'VmwareAdminClusterLoadBalancerArgsDict']]] = None,
            local_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_config: Optional[pulumi.Input[Union['VmwareAdminClusterNetworkConfigArgs', 'VmwareAdminClusterNetworkConfigArgsDict']]] = None,
            on_prem_version: Optional[pulumi.Input[_builtins.str]] = None,
            platform_config: Optional[pulumi.Input[Union['VmwareAdminClusterPlatformConfigArgs', 'VmwareAdminClusterPlatformConfigArgsDict']]] = None,
            private_registry_config: Optional[pulumi.Input[Union['VmwareAdminClusterPrivateRegistryConfigArgs', 'VmwareAdminClusterPrivateRegistryConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            proxy: Optional[pulumi.Input[Union['VmwareAdminClusterProxyArgs', 'VmwareAdminClusterProxyArgsDict']]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmwareAdminClusterStatusArgs', 'VmwareAdminClusterStatusArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            vcenter: Optional[pulumi.Input[Union['VmwareAdminClusterVcenterArgs', 'VmwareAdminClusterVcenterArgsDict']]] = None) -> 'VmwareAdminCluster':
        """
        Get an existing VmwareAdminCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VmwareAdminClusterAddonNodeArgs', 'VmwareAdminClusterAddonNodeArgsDict']] addon_node: The VMware admin cluster addon node configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations on the VMware Admin Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['VmwareAdminClusterAntiAffinityGroupsArgs', 'VmwareAdminClusterAntiAffinityGroupsArgsDict']] anti_affinity_groups: AAGConfig specifies whether to spread VMware Admin Cluster nodes across at
               least three physical hosts in the datacenter.
               Structure is documented below.
        :param pulumi.Input[Union['VmwareAdminClusterAuthorizationArgs', 'VmwareAdminClusterAuthorizationArgsDict']] authorization: The VMware admin cluster authorization configuration.
               Structure is documented below.
        :param pulumi.Input[Union['VmwareAdminClusterAutoRepairConfigArgs', 'VmwareAdminClusterAutoRepairConfigArgsDict']] auto_repair_config: Configuration for auto repairing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] bootstrap_cluster_membership: The bootstrap cluster this VMware admin cluster belongs to.
        :param pulumi.Input[Union['VmwareAdminClusterControlPlaneNodeArgs', 'VmwareAdminClusterControlPlaneNodeArgsDict']] control_plane_node: The VMware admin cluster control plane node configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: A human readable description of this VMware admin cluster.
        :param pulumi.Input[_builtins.bool] enable_advanced_cluster: If set, the advanced cluster feature is enabled.
        :param pulumi.Input[_builtins.str] endpoint: The DNS name of VMware admin cluster's API server.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmwareAdminClusterFleetArgs', 'VmwareAdminClusterFleetArgsDict']]]] fleets: Fleet configuration for the cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] image_type: The OS image type for the VMware admin cluster.
        :param pulumi.Input[Union['VmwareAdminClusterLoadBalancerArgs', 'VmwareAdminClusterLoadBalancerArgsDict']] load_balancer: Specifies the load balancer configuration for VMware admin cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] local_name: The object name of the VMwareAdminCluster custom resource on the
               associated admin cluster. This field is used to support conflicting
               names when enrolling existing clusters to the API. When used as a part of
               cluster enrollment, this field will differ from the ID in the resource
               name. For new clusters, this field will match the user provided cluster ID
               and be visible in the last component of the resource name. It is not
               modifiable.
               All users should use this name to access their cluster using gkectl or
               kubectl and should expect to see the local name when viewing admin
               cluster controller logs.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: The VMware admin cluster resource name.
        :param pulumi.Input[Union['VmwareAdminClusterNetworkConfigArgs', 'VmwareAdminClusterNetworkConfigArgsDict']] network_config: The VMware admin cluster network configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] on_prem_version: The Anthos clusters on the VMware version for the admin cluster.
        :param pulumi.Input[Union['VmwareAdminClusterPlatformConfigArgs', 'VmwareAdminClusterPlatformConfigArgsDict']] platform_config: The VMware platform configuration.
               Structure is documented below.
        :param pulumi.Input[Union['VmwareAdminClusterPrivateRegistryConfigArgs', 'VmwareAdminClusterPrivateRegistryConfigArgsDict']] private_registry_config: Configuration for private registry.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['VmwareAdminClusterProxyArgs', 'VmwareAdminClusterProxyArgsDict']] proxy: Configuration for proxy.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] reconciling: If set, there are currently changes in flight to the VMware admin cluster.
        :param pulumi.Input[_builtins.str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmwareAdminClusterStatusArgs', 'VmwareAdminClusterStatusArgsDict']]]] statuses: ResourceStatus representing detailed cluster state.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the VMware Admin Cluster.
        :param pulumi.Input[_builtins.str] update_time: The time the cluster was last updated, in RFC3339 text format.
        :param pulumi.Input[Union['VmwareAdminClusterVcenterArgs', 'VmwareAdminClusterVcenterArgsDict']] vcenter: Specifies vCenter config for the admin cluster.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmwareAdminClusterState.__new__(_VmwareAdminClusterState)

        __props__.__dict__["addon_node"] = addon_node
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["anti_affinity_groups"] = anti_affinity_groups
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["auto_repair_config"] = auto_repair_config
        __props__.__dict__["bootstrap_cluster_membership"] = bootstrap_cluster_membership
        __props__.__dict__["control_plane_node"] = control_plane_node
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["enable_advanced_cluster"] = enable_advanced_cluster
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["etag"] = etag
        __props__.__dict__["fleets"] = fleets
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["load_balancer"] = load_balancer
        __props__.__dict__["local_name"] = local_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["on_prem_version"] = on_prem_version
        __props__.__dict__["platform_config"] = platform_config
        __props__.__dict__["private_registry_config"] = private_registry_config
        __props__.__dict__["project"] = project
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vcenter"] = vcenter
        return VmwareAdminCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addonNode")
    def addon_node(self) -> pulumi.Output['outputs.VmwareAdminClusterAddonNode']:
        """
        The VMware admin cluster addon node configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "addon_node")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations on the VMware Admin Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="antiAffinityGroups")
    def anti_affinity_groups(self) -> pulumi.Output['outputs.VmwareAdminClusterAntiAffinityGroups']:
        """
        AAGConfig specifies whether to spread VMware Admin Cluster nodes across at
        least three physical hosts in the datacenter.
        Structure is documented below.
        """
        return pulumi.get(self, "anti_affinity_groups")

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional['outputs.VmwareAdminClusterAuthorization']]:
        """
        The VMware admin cluster authorization configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @_builtins.property
    @pulumi.getter(name="autoRepairConfig")
    def auto_repair_config(self) -> pulumi.Output['outputs.VmwareAdminClusterAutoRepairConfig']:
        """
        Configuration for auto repairing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_repair_config")

    @_builtins.property
    @pulumi.getter(name="bootstrapClusterMembership")
    def bootstrap_cluster_membership(self) -> pulumi.Output[_builtins.str]:
        """
        The bootstrap cluster this VMware admin cluster belongs to.
        """
        return pulumi.get(self, "bootstrap_cluster_membership")

    @_builtins.property
    @pulumi.getter(name="controlPlaneNode")
    def control_plane_node(self) -> pulumi.Output[Optional['outputs.VmwareAdminClusterControlPlaneNode']]:
        """
        The VMware admin cluster control plane node configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_node")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A human readable description of this VMware admin cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="enableAdvancedCluster")
    def enable_advanced_cluster(self) -> pulumi.Output[_builtins.bool]:
        """
        If set, the advanced cluster feature is enabled.
        """
        return pulumi.get(self, "enable_advanced_cluster")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS name of VMware admin cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def fleets(self) -> pulumi.Output[Sequence['outputs.VmwareAdminClusterFleet']]:
        """
        Fleet configuration for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "fleets")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[_builtins.str]:
        """
        The OS image type for the VMware admin cluster.
        """
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output[Optional['outputs.VmwareAdminClusterLoadBalancer']]:
        """
        Specifies the load balancer configuration for VMware admin cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @_builtins.property
    @pulumi.getter(name="localName")
    def local_name(self) -> pulumi.Output[_builtins.str]:
        """
        The object name of the VMwareAdminCluster custom resource on the
        associated admin cluster. This field is used to support conflicting
        names when enrolling existing clusters to the API. When used as a part of
        cluster enrollment, this field will differ from the ID in the resource
        name. For new clusters, this field will match the user provided cluster ID
        and be visible in the last component of the resource name. It is not
        modifiable.
        All users should use this name to access their cluster using gkectl or
        kubectl and should expect to see the local name when viewing admin
        cluster controller logs.
        """
        return pulumi.get(self, "local_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The VMware admin cluster resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output['outputs.VmwareAdminClusterNetworkConfig']:
        """
        The VMware admin cluster network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @_builtins.property
    @pulumi.getter(name="onPremVersion")
    def on_prem_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Anthos clusters on the VMware version for the admin cluster.
        """
        return pulumi.get(self, "on_prem_version")

    @_builtins.property
    @pulumi.getter(name="platformConfig")
    def platform_config(self) -> pulumi.Output[Optional['outputs.VmwareAdminClusterPlatformConfig']]:
        """
        The VMware platform configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "platform_config")

    @_builtins.property
    @pulumi.getter(name="privateRegistryConfig")
    def private_registry_config(self) -> pulumi.Output[Optional['outputs.VmwareAdminClusterPrivateRegistryConfig']]:
        """
        Configuration for private registry.
        Structure is documented below.
        """
        return pulumi.get(self, "private_registry_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> pulumi.Output[Optional['outputs.VmwareAdminClusterProxy']]:
        """
        Configuration for proxy.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        If set, there are currently changes in flight to the VMware admin cluster.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.VmwareAdminClusterStatus']]:
        """
        ResourceStatus representing detailed cluster state.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the VMware Admin Cluster.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter
    def vcenter(self) -> pulumi.Output[Optional['outputs.VmwareAdminClusterVcenter']]:
        """
        Specifies vCenter config for the admin cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "vcenter")

