# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FhirStoreArgs', 'FhirStore']

@pulumi.input_type
class FhirStoreArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[_builtins.str],
                 complex_data_type_reference_parsing: Optional[pulumi.Input[_builtins.str]] = None,
                 consent_config: Optional[pulumi.Input['FhirStoreConsentConfigArgs']] = None,
                 default_search_handling_strict: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_referential_integrity: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_resource_versioning: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_history_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_history_modifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_update_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_config: Optional[pulumi.Input['FhirStoreNotificationConfigArgs']] = None,
                 notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreNotificationConfigArgs']]]] = None,
                 stream_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreStreamConfigArgs']]]] = None,
                 validation_config: Optional[pulumi.Input['FhirStoreValidationConfigArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FhirStore resource.
        :param pulumi.Input[_builtins.str] dataset: Identifies the dataset addressed by this request. Must be in the format
               'projects/{project}/locations/{location}/datasets/{dataset}'
        :param pulumi.Input[_builtins.str] complex_data_type_reference_parsing: Enable parsing of references within complex FHIR data types such as Extensions. If this value is set to ENABLED, then features like referential integrity and Bundle reference rewriting apply to all references. If this flag has not been specified the behavior of the FHIR store will not change, references in complex data types will not be parsed. New stores will have this value set to ENABLED by default after a notification period. Warning: turning on this flag causes processing existing resources to fail if they contain references to non-existent resources.
               Possible values are: `COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED`, `DISABLED`, `ENABLED`.
        :param pulumi.Input['FhirStoreConsentConfigArgs'] consent_config: Specifies whether this store has consent enforcement. Not available for DSTU2 FHIR version due to absence of Consent resources. Not supported for R5 FHIR version.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] default_search_handling_strict: If true, overrides the default search behavior for this FHIR store to handling=strict which returns an error for unrecognized search parameters.
               If false, uses the FHIR specification default handling=lenient which ignores unrecognized search parameters.
               The handling can always be changed from the default on an individual API call by setting the HTTP header Prefer: handling=strict or Prefer: handling=lenient.
        :param pulumi.Input[_builtins.bool] disable_referential_integrity: Whether to disable referential integrity in this FHIR store. This field is immutable after FHIR store
               creation. The default value is false, meaning that the API will enforce referential integrity and fail the
               requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
               will skip referential integrity check. Consequently, operations that rely on references, such as
               Patient.get$everything, will not return all the results if broken references exist.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[_builtins.bool] disable_resource_versioning: Whether to disable resource versioning for this FHIR store. This field can not be changed after the creation
               of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
               versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
               cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
               attempts to read the historical versions.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[_builtins.bool] enable_history_import: Whether to allow the bulk import API to accept history bundles and directly insert historical resource
               versions into the FHIR store. Importing resource histories creates resource interactions that appear to have
               occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
               will fail with an error.
               ** Changing this property may recreate the FHIR store (removing all data) **
               ** This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
        :param pulumi.Input[_builtins.bool] enable_history_modifications: Whether to allow the ExecuteBundle API to accept history bundles, and directly insert and overwrite historical
               resource versions into the FHIR store. If set to false, using history bundles fails with an error.
        :param pulumi.Input[_builtins.bool] enable_update_create: Whether this FHIR store has the updateCreate capability. This determines if the client can use an Update
               operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
               the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
               logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
               identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
               notifications.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-supplied key-value pairs used to organize FHIR stores.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
               conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
               bytes, and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given store.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name for the FhirStore.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input['FhirStoreNotificationConfigArgs'] notification_config: (Optional, Deprecated)
               A nested object resource.
               Structure is documented below.
               
               > **Warning:** `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.
        :param pulumi.Input[Sequence[pulumi.Input['FhirStoreNotificationConfigArgs']]] notification_configs: A list of notifcation configs that configure the notification for every resource mutation in this FHIR store.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['FhirStoreStreamConfigArgs']]] stream_configs: A list of streaming configs that configure the destinations of streaming export for every resource mutation in
               this FHIR store. Each store is allowed to have up to 10 streaming configs. After a new config is added, the next
               resource mutation is streamed to the new location in addition to the existing ones. When a location is removed
               from the list, the server stops streaming to that location. Before adding a new config, you must add the required
               bigquery.dataEditor role to your project's Cloud Healthcare Service Agent service account. Some lag (typically on
               the order of dozens of seconds) is expected before the results show up in the streaming destination.
               Structure is documented below.
        :param pulumi.Input['FhirStoreValidationConfigArgs'] validation_config: Configuration for how to validate incoming FHIR resources against configured profiles.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] version: The FHIR specification version.
               Default value is `STU3`.
               Possible values are: `DSTU2`, `STU3`, `R4`.
        """
        pulumi.set(__self__, "dataset", dataset)
        if complex_data_type_reference_parsing is not None:
            pulumi.set(__self__, "complex_data_type_reference_parsing", complex_data_type_reference_parsing)
        if consent_config is not None:
            pulumi.set(__self__, "consent_config", consent_config)
        if default_search_handling_strict is not None:
            pulumi.set(__self__, "default_search_handling_strict", default_search_handling_strict)
        if disable_referential_integrity is not None:
            pulumi.set(__self__, "disable_referential_integrity", disable_referential_integrity)
        if disable_resource_versioning is not None:
            pulumi.set(__self__, "disable_resource_versioning", disable_resource_versioning)
        if enable_history_import is not None:
            pulumi.set(__self__, "enable_history_import", enable_history_import)
        if enable_history_modifications is not None:
            pulumi.set(__self__, "enable_history_modifications", enable_history_modifications)
        if enable_update_create is not None:
            pulumi.set(__self__, "enable_update_create", enable_update_create)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_config is not None:
            warnings.warn("""`notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.""", DeprecationWarning)
            pulumi.log.warn("""notification_config is deprecated: `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.""")
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)
        if notification_configs is not None:
            pulumi.set(__self__, "notification_configs", notification_configs)
        if stream_configs is not None:
            pulumi.set(__self__, "stream_configs", stream_configs)
        if validation_config is not None:
            pulumi.set(__self__, "validation_config", validation_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the dataset addressed by this request. Must be in the format
        'projects/{project}/locations/{location}/datasets/{dataset}'
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="complexDataTypeReferenceParsing")
    def complex_data_type_reference_parsing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable parsing of references within complex FHIR data types such as Extensions. If this value is set to ENABLED, then features like referential integrity and Bundle reference rewriting apply to all references. If this flag has not been specified the behavior of the FHIR store will not change, references in complex data types will not be parsed. New stores will have this value set to ENABLED by default after a notification period. Warning: turning on this flag causes processing existing resources to fail if they contain references to non-existent resources.
        Possible values are: `COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED`, `DISABLED`, `ENABLED`.
        """
        return pulumi.get(self, "complex_data_type_reference_parsing")

    @complex_data_type_reference_parsing.setter
    def complex_data_type_reference_parsing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "complex_data_type_reference_parsing", value)

    @_builtins.property
    @pulumi.getter(name="consentConfig")
    def consent_config(self) -> Optional[pulumi.Input['FhirStoreConsentConfigArgs']]:
        """
        Specifies whether this store has consent enforcement. Not available for DSTU2 FHIR version due to absence of Consent resources. Not supported for R5 FHIR version.
        Structure is documented below.
        """
        return pulumi.get(self, "consent_config")

    @consent_config.setter
    def consent_config(self, value: Optional[pulumi.Input['FhirStoreConsentConfigArgs']]):
        pulumi.set(self, "consent_config", value)

    @_builtins.property
    @pulumi.getter(name="defaultSearchHandlingStrict")
    def default_search_handling_strict(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, overrides the default search behavior for this FHIR store to handling=strict which returns an error for unrecognized search parameters.
        If false, uses the FHIR specification default handling=lenient which ignores unrecognized search parameters.
        The handling can always be changed from the default on an individual API call by setting the HTTP header Prefer: handling=strict or Prefer: handling=lenient.
        """
        return pulumi.get(self, "default_search_handling_strict")

    @default_search_handling_strict.setter
    def default_search_handling_strict(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_search_handling_strict", value)

    @_builtins.property
    @pulumi.getter(name="disableReferentialIntegrity")
    def disable_referential_integrity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable referential integrity in this FHIR store. This field is immutable after FHIR store
        creation. The default value is false, meaning that the API will enforce referential integrity and fail the
        requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
        will skip referential integrity check. Consequently, operations that rely on references, such as
        Patient.get$everything, will not return all the results if broken references exist.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "disable_referential_integrity")

    @disable_referential_integrity.setter
    def disable_referential_integrity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_referential_integrity", value)

    @_builtins.property
    @pulumi.getter(name="disableResourceVersioning")
    def disable_resource_versioning(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable resource versioning for this FHIR store. This field can not be changed after the creation
        of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
        versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
        cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
        attempts to read the historical versions.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "disable_resource_versioning")

    @disable_resource_versioning.setter
    def disable_resource_versioning(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_resource_versioning", value)

    @_builtins.property
    @pulumi.getter(name="enableHistoryImport")
    def enable_history_import(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow the bulk import API to accept history bundles and directly insert historical resource
        versions into the FHIR store. Importing resource histories creates resource interactions that appear to have
        occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
        will fail with an error.
        ** Changing this property may recreate the FHIR store (removing all data) **
        ** This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
        """
        return pulumi.get(self, "enable_history_import")

    @enable_history_import.setter
    def enable_history_import(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_history_import", value)

    @_builtins.property
    @pulumi.getter(name="enableHistoryModifications")
    def enable_history_modifications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow the ExecuteBundle API to accept history bundles, and directly insert and overwrite historical
        resource versions into the FHIR store. If set to false, using history bundles fails with an error.
        """
        return pulumi.get(self, "enable_history_modifications")

    @enable_history_modifications.setter
    def enable_history_modifications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_history_modifications", value)

    @_builtins.property
    @pulumi.getter(name="enableUpdateCreate")
    def enable_update_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this FHIR store has the updateCreate capability. This determines if the client can use an Update
        operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
        the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
        logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
        identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
        notifications.
        """
        return pulumi.get(self, "enable_update_create")

    @enable_update_create.setter
    def enable_update_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_update_create", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-supplied key-value pairs used to organize FHIR stores.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
        conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
        bytes, and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be associated with a given store.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for the FhirStore.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    @_utilities.deprecated("""`notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.""")
    def notification_config(self) -> Optional[pulumi.Input['FhirStoreNotificationConfigArgs']]:
        """
        (Optional, Deprecated)
        A nested object resource.
        Structure is documented below.

        > **Warning:** `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.
        """
        return pulumi.get(self, "notification_config")

    @notification_config.setter
    def notification_config(self, value: Optional[pulumi.Input['FhirStoreNotificationConfigArgs']]):
        pulumi.set(self, "notification_config", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfigs")
    def notification_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreNotificationConfigArgs']]]]:
        """
        A list of notifcation configs that configure the notification for every resource mutation in this FHIR store.
        Structure is documented below.
        """
        return pulumi.get(self, "notification_configs")

    @notification_configs.setter
    def notification_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreNotificationConfigArgs']]]]):
        pulumi.set(self, "notification_configs", value)

    @_builtins.property
    @pulumi.getter(name="streamConfigs")
    def stream_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreStreamConfigArgs']]]]:
        """
        A list of streaming configs that configure the destinations of streaming export for every resource mutation in
        this FHIR store. Each store is allowed to have up to 10 streaming configs. After a new config is added, the next
        resource mutation is streamed to the new location in addition to the existing ones. When a location is removed
        from the list, the server stops streaming to that location. Before adding a new config, you must add the required
        bigquery.dataEditor role to your project's Cloud Healthcare Service Agent service account. Some lag (typically on
        the order of dozens of seconds) is expected before the results show up in the streaming destination.
        Structure is documented below.
        """
        return pulumi.get(self, "stream_configs")

    @stream_configs.setter
    def stream_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreStreamConfigArgs']]]]):
        pulumi.set(self, "stream_configs", value)

    @_builtins.property
    @pulumi.getter(name="validationConfig")
    def validation_config(self) -> Optional[pulumi.Input['FhirStoreValidationConfigArgs']]:
        """
        Configuration for how to validate incoming FHIR resources against configured profiles.
        Structure is documented below.
        """
        return pulumi.get(self, "validation_config")

    @validation_config.setter
    def validation_config(self, value: Optional[pulumi.Input['FhirStoreValidationConfigArgs']]):
        pulumi.set(self, "validation_config", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FHIR specification version.
        Default value is `STU3`.
        Possible values are: `DSTU2`, `STU3`, `R4`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _FhirStoreState:
    def __init__(__self__, *,
                 complex_data_type_reference_parsing: Optional[pulumi.Input[_builtins.str]] = None,
                 consent_config: Optional[pulumi.Input['FhirStoreConsentConfigArgs']] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 default_search_handling_strict: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_referential_integrity: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_resource_versioning: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_history_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_history_modifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_update_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_config: Optional[pulumi.Input['FhirStoreNotificationConfigArgs']] = None,
                 notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreNotificationConfigArgs']]]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreStreamConfigArgs']]]] = None,
                 validation_config: Optional[pulumi.Input['FhirStoreValidationConfigArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FhirStore resources.
        :param pulumi.Input[_builtins.str] complex_data_type_reference_parsing: Enable parsing of references within complex FHIR data types such as Extensions. If this value is set to ENABLED, then features like referential integrity and Bundle reference rewriting apply to all references. If this flag has not been specified the behavior of the FHIR store will not change, references in complex data types will not be parsed. New stores will have this value set to ENABLED by default after a notification period. Warning: turning on this flag causes processing existing resources to fail if they contain references to non-existent resources.
               Possible values are: `COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED`, `DISABLED`, `ENABLED`.
        :param pulumi.Input['FhirStoreConsentConfigArgs'] consent_config: Specifies whether this store has consent enforcement. Not available for DSTU2 FHIR version due to absence of Consent resources. Not supported for R5 FHIR version.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset: Identifies the dataset addressed by this request. Must be in the format
               'projects/{project}/locations/{location}/datasets/{dataset}'
        :param pulumi.Input[_builtins.bool] default_search_handling_strict: If true, overrides the default search behavior for this FHIR store to handling=strict which returns an error for unrecognized search parameters.
               If false, uses the FHIR specification default handling=lenient which ignores unrecognized search parameters.
               The handling can always be changed from the default on an individual API call by setting the HTTP header Prefer: handling=strict or Prefer: handling=lenient.
        :param pulumi.Input[_builtins.bool] disable_referential_integrity: Whether to disable referential integrity in this FHIR store. This field is immutable after FHIR store
               creation. The default value is false, meaning that the API will enforce referential integrity and fail the
               requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
               will skip referential integrity check. Consequently, operations that rely on references, such as
               Patient.get$everything, will not return all the results if broken references exist.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[_builtins.bool] disable_resource_versioning: Whether to disable resource versioning for this FHIR store. This field can not be changed after the creation
               of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
               versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
               cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
               attempts to read the historical versions.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] enable_history_import: Whether to allow the bulk import API to accept history bundles and directly insert historical resource
               versions into the FHIR store. Importing resource histories creates resource interactions that appear to have
               occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
               will fail with an error.
               ** Changing this property may recreate the FHIR store (removing all data) **
               ** This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
        :param pulumi.Input[_builtins.bool] enable_history_modifications: Whether to allow the ExecuteBundle API to accept history bundles, and directly insert and overwrite historical
               resource versions into the FHIR store. If set to false, using history bundles fails with an error.
        :param pulumi.Input[_builtins.bool] enable_update_create: Whether this FHIR store has the updateCreate capability. This determines if the client can use an Update
               operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
               the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
               logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
               identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
               notifications.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-supplied key-value pairs used to organize FHIR stores.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
               conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
               bytes, and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given store.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name for the FhirStore.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input['FhirStoreNotificationConfigArgs'] notification_config: (Optional, Deprecated)
               A nested object resource.
               Structure is documented below.
               
               > **Warning:** `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.
        :param pulumi.Input[Sequence[pulumi.Input['FhirStoreNotificationConfigArgs']]] notification_configs: A list of notifcation configs that configure the notification for every resource mutation in this FHIR store.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] self_link: The fully qualified name of this dataset
        :param pulumi.Input[Sequence[pulumi.Input['FhirStoreStreamConfigArgs']]] stream_configs: A list of streaming configs that configure the destinations of streaming export for every resource mutation in
               this FHIR store. Each store is allowed to have up to 10 streaming configs. After a new config is added, the next
               resource mutation is streamed to the new location in addition to the existing ones. When a location is removed
               from the list, the server stops streaming to that location. Before adding a new config, you must add the required
               bigquery.dataEditor role to your project's Cloud Healthcare Service Agent service account. Some lag (typically on
               the order of dozens of seconds) is expected before the results show up in the streaming destination.
               Structure is documented below.
        :param pulumi.Input['FhirStoreValidationConfigArgs'] validation_config: Configuration for how to validate incoming FHIR resources against configured profiles.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] version: The FHIR specification version.
               Default value is `STU3`.
               Possible values are: `DSTU2`, `STU3`, `R4`.
        """
        if complex_data_type_reference_parsing is not None:
            pulumi.set(__self__, "complex_data_type_reference_parsing", complex_data_type_reference_parsing)
        if consent_config is not None:
            pulumi.set(__self__, "consent_config", consent_config)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if default_search_handling_strict is not None:
            pulumi.set(__self__, "default_search_handling_strict", default_search_handling_strict)
        if disable_referential_integrity is not None:
            pulumi.set(__self__, "disable_referential_integrity", disable_referential_integrity)
        if disable_resource_versioning is not None:
            pulumi.set(__self__, "disable_resource_versioning", disable_resource_versioning)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_history_import is not None:
            pulumi.set(__self__, "enable_history_import", enable_history_import)
        if enable_history_modifications is not None:
            pulumi.set(__self__, "enable_history_modifications", enable_history_modifications)
        if enable_update_create is not None:
            pulumi.set(__self__, "enable_update_create", enable_update_create)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_config is not None:
            warnings.warn("""`notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.""", DeprecationWarning)
            pulumi.log.warn("""notification_config is deprecated: `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.""")
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)
        if notification_configs is not None:
            pulumi.set(__self__, "notification_configs", notification_configs)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if stream_configs is not None:
            pulumi.set(__self__, "stream_configs", stream_configs)
        if validation_config is not None:
            pulumi.set(__self__, "validation_config", validation_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="complexDataTypeReferenceParsing")
    def complex_data_type_reference_parsing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable parsing of references within complex FHIR data types such as Extensions. If this value is set to ENABLED, then features like referential integrity and Bundle reference rewriting apply to all references. If this flag has not been specified the behavior of the FHIR store will not change, references in complex data types will not be parsed. New stores will have this value set to ENABLED by default after a notification period. Warning: turning on this flag causes processing existing resources to fail if they contain references to non-existent resources.
        Possible values are: `COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED`, `DISABLED`, `ENABLED`.
        """
        return pulumi.get(self, "complex_data_type_reference_parsing")

    @complex_data_type_reference_parsing.setter
    def complex_data_type_reference_parsing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "complex_data_type_reference_parsing", value)

    @_builtins.property
    @pulumi.getter(name="consentConfig")
    def consent_config(self) -> Optional[pulumi.Input['FhirStoreConsentConfigArgs']]:
        """
        Specifies whether this store has consent enforcement. Not available for DSTU2 FHIR version due to absence of Consent resources. Not supported for R5 FHIR version.
        Structure is documented below.
        """
        return pulumi.get(self, "consent_config")

    @consent_config.setter
    def consent_config(self, value: Optional[pulumi.Input['FhirStoreConsentConfigArgs']]):
        pulumi.set(self, "consent_config", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the dataset addressed by this request. Must be in the format
        'projects/{project}/locations/{location}/datasets/{dataset}'
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="defaultSearchHandlingStrict")
    def default_search_handling_strict(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, overrides the default search behavior for this FHIR store to handling=strict which returns an error for unrecognized search parameters.
        If false, uses the FHIR specification default handling=lenient which ignores unrecognized search parameters.
        The handling can always be changed from the default on an individual API call by setting the HTTP header Prefer: handling=strict or Prefer: handling=lenient.
        """
        return pulumi.get(self, "default_search_handling_strict")

    @default_search_handling_strict.setter
    def default_search_handling_strict(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_search_handling_strict", value)

    @_builtins.property
    @pulumi.getter(name="disableReferentialIntegrity")
    def disable_referential_integrity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable referential integrity in this FHIR store. This field is immutable after FHIR store
        creation. The default value is false, meaning that the API will enforce referential integrity and fail the
        requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
        will skip referential integrity check. Consequently, operations that rely on references, such as
        Patient.get$everything, will not return all the results if broken references exist.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "disable_referential_integrity")

    @disable_referential_integrity.setter
    def disable_referential_integrity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_referential_integrity", value)

    @_builtins.property
    @pulumi.getter(name="disableResourceVersioning")
    def disable_resource_versioning(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable resource versioning for this FHIR store. This field can not be changed after the creation
        of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
        versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
        cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
        attempts to read the historical versions.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "disable_resource_versioning")

    @disable_resource_versioning.setter
    def disable_resource_versioning(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_resource_versioning", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="enableHistoryImport")
    def enable_history_import(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow the bulk import API to accept history bundles and directly insert historical resource
        versions into the FHIR store. Importing resource histories creates resource interactions that appear to have
        occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
        will fail with an error.
        ** Changing this property may recreate the FHIR store (removing all data) **
        ** This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
        """
        return pulumi.get(self, "enable_history_import")

    @enable_history_import.setter
    def enable_history_import(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_history_import", value)

    @_builtins.property
    @pulumi.getter(name="enableHistoryModifications")
    def enable_history_modifications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow the ExecuteBundle API to accept history bundles, and directly insert and overwrite historical
        resource versions into the FHIR store. If set to false, using history bundles fails with an error.
        """
        return pulumi.get(self, "enable_history_modifications")

    @enable_history_modifications.setter
    def enable_history_modifications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_history_modifications", value)

    @_builtins.property
    @pulumi.getter(name="enableUpdateCreate")
    def enable_update_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this FHIR store has the updateCreate capability. This determines if the client can use an Update
        operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
        the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
        logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
        identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
        notifications.
        """
        return pulumi.get(self, "enable_update_create")

    @enable_update_create.setter
    def enable_update_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_update_create", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-supplied key-value pairs used to organize FHIR stores.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
        conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
        bytes, and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be associated with a given store.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for the FhirStore.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    @_utilities.deprecated("""`notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.""")
    def notification_config(self) -> Optional[pulumi.Input['FhirStoreNotificationConfigArgs']]:
        """
        (Optional, Deprecated)
        A nested object resource.
        Structure is documented below.

        > **Warning:** `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.
        """
        return pulumi.get(self, "notification_config")

    @notification_config.setter
    def notification_config(self, value: Optional[pulumi.Input['FhirStoreNotificationConfigArgs']]):
        pulumi.set(self, "notification_config", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfigs")
    def notification_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreNotificationConfigArgs']]]]:
        """
        A list of notifcation configs that configure the notification for every resource mutation in this FHIR store.
        Structure is documented below.
        """
        return pulumi.get(self, "notification_configs")

    @notification_configs.setter
    def notification_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreNotificationConfigArgs']]]]):
        pulumi.set(self, "notification_configs", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of this dataset
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="streamConfigs")
    def stream_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreStreamConfigArgs']]]]:
        """
        A list of streaming configs that configure the destinations of streaming export for every resource mutation in
        this FHIR store. Each store is allowed to have up to 10 streaming configs. After a new config is added, the next
        resource mutation is streamed to the new location in addition to the existing ones. When a location is removed
        from the list, the server stops streaming to that location. Before adding a new config, you must add the required
        bigquery.dataEditor role to your project's Cloud Healthcare Service Agent service account. Some lag (typically on
        the order of dozens of seconds) is expected before the results show up in the streaming destination.
        Structure is documented below.
        """
        return pulumi.get(self, "stream_configs")

    @stream_configs.setter
    def stream_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FhirStoreStreamConfigArgs']]]]):
        pulumi.set(self, "stream_configs", value)

    @_builtins.property
    @pulumi.getter(name="validationConfig")
    def validation_config(self) -> Optional[pulumi.Input['FhirStoreValidationConfigArgs']]:
        """
        Configuration for how to validate incoming FHIR resources against configured profiles.
        Structure is documented below.
        """
        return pulumi.get(self, "validation_config")

    @validation_config.setter
    def validation_config(self, value: Optional[pulumi.Input['FhirStoreValidationConfigArgs']]):
        pulumi.set(self, "validation_config", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FHIR specification version.
        Default value is `STU3`.
        Possible values are: `DSTU2`, `STU3`, `R4`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("gcp:healthcare/fhirStore:FhirStore")
class FhirStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 complex_data_type_reference_parsing: Optional[pulumi.Input[_builtins.str]] = None,
                 consent_config: Optional[pulumi.Input[Union['FhirStoreConsentConfigArgs', 'FhirStoreConsentConfigArgsDict']]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 default_search_handling_strict: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_referential_integrity: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_resource_versioning: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_history_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_history_modifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_update_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_config: Optional[pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']]] = None,
                 notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']]]]] = None,
                 stream_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreStreamConfigArgs', 'FhirStoreStreamConfigArgsDict']]]]] = None,
                 validation_config: Optional[pulumi.Input[Union['FhirStoreValidationConfigArgs', 'FhirStoreValidationConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A FhirStore is a datastore inside a Healthcare dataset that conforms to the FHIR (https://www.hl7.org/fhir/STU3/)
        standard for Healthcare information exchange

        To get more information about FhirStore, see:

        * [API documentation](https://cloud.google.com/healthcare/docs/reference/rest/v1/projects.locations.datasets.fhirStores)
        * How-to Guides
            * [Creating a FHIR store](https://cloud.google.com/healthcare/docs/how-tos/fhir)

        ## Example Usage

        ### Healthcare Fhir Store Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            complex_data_type_reference_parsing="DISABLED",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            default_search_handling_strict=False,
            notification_configs=[{
                "pubsub_topic": topic.id,
            }],
            labels={
                "label1": "labelvalue1",
            })
        ```
        ### Healthcare Fhir Store Streaming Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        bq_dataset = gcp.bigquery.Dataset("bq_dataset",
            dataset_id="bq_example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            delete_contents_on_destroy=True)
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            labels={
                "label1": "labelvalue1",
            },
            stream_configs=[{
                "resource_types": ["Observation"],
                "bigquery_destination": {
                    "dataset_uri": pulumi.Output.all(
                        project=bq_dataset.project,
                        dataset_id=bq_dataset.dataset_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}")
        ,
                    "schema_config": {
                        "recursive_structure_depth": 3,
                        "last_updated_partition_config": {
                            "type": "HOUR",
                            "expiration_ms": "1000000",
                        },
                    },
                },
            }])
        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        ```
        ### Healthcare Fhir Store Notification Configs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            labels={
                "label1": "labelvalue1",
            },
            notification_configs=[{
                "pubsub_topic": topic.id,
                "send_full_resource": True,
                "send_previous_resource_on_delete": True,
            }])
        ```
        ### Healthcare Fhir Store Consent Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            complex_data_type_reference_parsing="DISABLED",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            default_search_handling_strict=False,
            notification_configs=[{
                "pubsub_topic": topic.id,
            }],
            labels={
                "label1": "labelvalue1",
            },
            consent_config={
                "version": "V1",
                "access_enforced": True,
                "consent_header_handling": {
                    "profile": "REQUIRED_ON_READ",
                },
                "access_determination_log_config": {
                    "log_level": "VERBOSE",
                },
            })
        ```
        ### Healthcare Fhir Store Validation Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            complex_data_type_reference_parsing="DISABLED",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            default_search_handling_strict=False,
            notification_configs=[{
                "pubsub_topic": topic.id,
            }],
            labels={
                "label1": "labelvalue1",
            },
            validation_config={
                "disable_profile_validation": True,
                "enabled_implementation_guides": [],
                "disable_required_field_validation": True,
                "disable_reference_type_validation": True,
                "disable_fhirpath_validation": True,
            })
        ```

        ## Import

        FhirStore can be imported using any of these accepted formats:

        * `{{dataset}}/fhirStores/{{name}}`

        * `{{dataset}}/{{name}}`

        When using the `pulumi import` command, FhirStore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:healthcare/fhirStore:FhirStore default {{dataset}}/fhirStores/{{name}}
        ```

        ```sh
        $ pulumi import gcp:healthcare/fhirStore:FhirStore default {{dataset}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] complex_data_type_reference_parsing: Enable parsing of references within complex FHIR data types such as Extensions. If this value is set to ENABLED, then features like referential integrity and Bundle reference rewriting apply to all references. If this flag has not been specified the behavior of the FHIR store will not change, references in complex data types will not be parsed. New stores will have this value set to ENABLED by default after a notification period. Warning: turning on this flag causes processing existing resources to fail if they contain references to non-existent resources.
               Possible values are: `COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED`, `DISABLED`, `ENABLED`.
        :param pulumi.Input[Union['FhirStoreConsentConfigArgs', 'FhirStoreConsentConfigArgsDict']] consent_config: Specifies whether this store has consent enforcement. Not available for DSTU2 FHIR version due to absence of Consent resources. Not supported for R5 FHIR version.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset: Identifies the dataset addressed by this request. Must be in the format
               'projects/{project}/locations/{location}/datasets/{dataset}'
        :param pulumi.Input[_builtins.bool] default_search_handling_strict: If true, overrides the default search behavior for this FHIR store to handling=strict which returns an error for unrecognized search parameters.
               If false, uses the FHIR specification default handling=lenient which ignores unrecognized search parameters.
               The handling can always be changed from the default on an individual API call by setting the HTTP header Prefer: handling=strict or Prefer: handling=lenient.
        :param pulumi.Input[_builtins.bool] disable_referential_integrity: Whether to disable referential integrity in this FHIR store. This field is immutable after FHIR store
               creation. The default value is false, meaning that the API will enforce referential integrity and fail the
               requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
               will skip referential integrity check. Consequently, operations that rely on references, such as
               Patient.get$everything, will not return all the results if broken references exist.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[_builtins.bool] disable_resource_versioning: Whether to disable resource versioning for this FHIR store. This field can not be changed after the creation
               of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
               versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
               cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
               attempts to read the historical versions.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[_builtins.bool] enable_history_import: Whether to allow the bulk import API to accept history bundles and directly insert historical resource
               versions into the FHIR store. Importing resource histories creates resource interactions that appear to have
               occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
               will fail with an error.
               ** Changing this property may recreate the FHIR store (removing all data) **
               ** This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
        :param pulumi.Input[_builtins.bool] enable_history_modifications: Whether to allow the ExecuteBundle API to accept history bundles, and directly insert and overwrite historical
               resource versions into the FHIR store. If set to false, using history bundles fails with an error.
        :param pulumi.Input[_builtins.bool] enable_update_create: Whether this FHIR store has the updateCreate capability. This determines if the client can use an Update
               operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
               the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
               logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
               identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
               notifications.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-supplied key-value pairs used to organize FHIR stores.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
               conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
               bytes, and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given store.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name for the FhirStore.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']] notification_config: (Optional, Deprecated)
               A nested object resource.
               Structure is documented below.
               
               > **Warning:** `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']]]] notification_configs: A list of notifcation configs that configure the notification for every resource mutation in this FHIR store.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreStreamConfigArgs', 'FhirStoreStreamConfigArgsDict']]]] stream_configs: A list of streaming configs that configure the destinations of streaming export for every resource mutation in
               this FHIR store. Each store is allowed to have up to 10 streaming configs. After a new config is added, the next
               resource mutation is streamed to the new location in addition to the existing ones. When a location is removed
               from the list, the server stops streaming to that location. Before adding a new config, you must add the required
               bigquery.dataEditor role to your project's Cloud Healthcare Service Agent service account. Some lag (typically on
               the order of dozens of seconds) is expected before the results show up in the streaming destination.
               Structure is documented below.
        :param pulumi.Input[Union['FhirStoreValidationConfigArgs', 'FhirStoreValidationConfigArgsDict']] validation_config: Configuration for how to validate incoming FHIR resources against configured profiles.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] version: The FHIR specification version.
               Default value is `STU3`.
               Possible values are: `DSTU2`, `STU3`, `R4`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FhirStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A FhirStore is a datastore inside a Healthcare dataset that conforms to the FHIR (https://www.hl7.org/fhir/STU3/)
        standard for Healthcare information exchange

        To get more information about FhirStore, see:

        * [API documentation](https://cloud.google.com/healthcare/docs/reference/rest/v1/projects.locations.datasets.fhirStores)
        * How-to Guides
            * [Creating a FHIR store](https://cloud.google.com/healthcare/docs/how-tos/fhir)

        ## Example Usage

        ### Healthcare Fhir Store Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            complex_data_type_reference_parsing="DISABLED",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            default_search_handling_strict=False,
            notification_configs=[{
                "pubsub_topic": topic.id,
            }],
            labels={
                "label1": "labelvalue1",
            })
        ```
        ### Healthcare Fhir Store Streaming Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        bq_dataset = gcp.bigquery.Dataset("bq_dataset",
            dataset_id="bq_example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            delete_contents_on_destroy=True)
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            labels={
                "label1": "labelvalue1",
            },
            stream_configs=[{
                "resource_types": ["Observation"],
                "bigquery_destination": {
                    "dataset_uri": pulumi.Output.all(
                        project=bq_dataset.project,
                        dataset_id=bq_dataset.dataset_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}")
        ,
                    "schema_config": {
                        "recursive_structure_depth": 3,
                        "last_updated_partition_config": {
                            "type": "HOUR",
                            "expiration_ms": "1000000",
                        },
                    },
                },
            }])
        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        ```
        ### Healthcare Fhir Store Notification Configs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            labels={
                "label1": "labelvalue1",
            },
            notification_configs=[{
                "pubsub_topic": topic.id,
                "send_full_resource": True,
                "send_previous_resource_on_delete": True,
            }])
        ```
        ### Healthcare Fhir Store Consent Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            complex_data_type_reference_parsing="DISABLED",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            default_search_handling_strict=False,
            notification_configs=[{
                "pubsub_topic": topic.id,
            }],
            labels={
                "label1": "labelvalue1",
            },
            consent_config={
                "version": "V1",
                "access_enforced": True,
                "consent_header_handling": {
                    "profile": "REQUIRED_ON_READ",
                },
                "access_determination_log_config": {
                    "log_level": "VERBOSE",
                },
            })
        ```
        ### Healthcare Fhir Store Validation Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="fhir-notifications")
        dataset = gcp.healthcare.Dataset("dataset",
            name="example-dataset",
            location="us-central1")
        default = gcp.healthcare.FhirStore("default",
            name="example-fhir-store",
            dataset=dataset.id,
            version="R4",
            complex_data_type_reference_parsing="DISABLED",
            enable_update_create=False,
            disable_referential_integrity=False,
            disable_resource_versioning=False,
            enable_history_import=False,
            default_search_handling_strict=False,
            notification_configs=[{
                "pubsub_topic": topic.id,
            }],
            labels={
                "label1": "labelvalue1",
            },
            validation_config={
                "disable_profile_validation": True,
                "enabled_implementation_guides": [],
                "disable_required_field_validation": True,
                "disable_reference_type_validation": True,
                "disable_fhirpath_validation": True,
            })
        ```

        ## Import

        FhirStore can be imported using any of these accepted formats:

        * `{{dataset}}/fhirStores/{{name}}`

        * `{{dataset}}/{{name}}`

        When using the `pulumi import` command, FhirStore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:healthcare/fhirStore:FhirStore default {{dataset}}/fhirStores/{{name}}
        ```

        ```sh
        $ pulumi import gcp:healthcare/fhirStore:FhirStore default {{dataset}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FhirStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FhirStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 complex_data_type_reference_parsing: Optional[pulumi.Input[_builtins.str]] = None,
                 consent_config: Optional[pulumi.Input[Union['FhirStoreConsentConfigArgs', 'FhirStoreConsentConfigArgsDict']]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 default_search_handling_strict: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_referential_integrity: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_resource_versioning: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_history_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_history_modifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_update_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_config: Optional[pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']]] = None,
                 notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']]]]] = None,
                 stream_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreStreamConfigArgs', 'FhirStoreStreamConfigArgsDict']]]]] = None,
                 validation_config: Optional[pulumi.Input[Union['FhirStoreValidationConfigArgs', 'FhirStoreValidationConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FhirStoreArgs.__new__(FhirStoreArgs)

            __props__.__dict__["complex_data_type_reference_parsing"] = complex_data_type_reference_parsing
            __props__.__dict__["consent_config"] = consent_config
            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["default_search_handling_strict"] = default_search_handling_strict
            __props__.__dict__["disable_referential_integrity"] = disable_referential_integrity
            __props__.__dict__["disable_resource_versioning"] = disable_resource_versioning
            __props__.__dict__["enable_history_import"] = enable_history_import
            __props__.__dict__["enable_history_modifications"] = enable_history_modifications
            __props__.__dict__["enable_update_create"] = enable_update_create
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_config"] = notification_config
            __props__.__dict__["notification_configs"] = notification_configs
            __props__.__dict__["stream_configs"] = stream_configs
            __props__.__dict__["validation_config"] = validation_config
            __props__.__dict__["version"] = version
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FhirStore, __self__).__init__(
            'gcp:healthcare/fhirStore:FhirStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            complex_data_type_reference_parsing: Optional[pulumi.Input[_builtins.str]] = None,
            consent_config: Optional[pulumi.Input[Union['FhirStoreConsentConfigArgs', 'FhirStoreConsentConfigArgsDict']]] = None,
            dataset: Optional[pulumi.Input[_builtins.str]] = None,
            default_search_handling_strict: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_referential_integrity: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_resource_versioning: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            enable_history_import: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_history_modifications: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_update_create: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_config: Optional[pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']]] = None,
            notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']]]]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            stream_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreStreamConfigArgs', 'FhirStoreStreamConfigArgsDict']]]]] = None,
            validation_config: Optional[pulumi.Input[Union['FhirStoreValidationConfigArgs', 'FhirStoreValidationConfigArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'FhirStore':
        """
        Get an existing FhirStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] complex_data_type_reference_parsing: Enable parsing of references within complex FHIR data types such as Extensions. If this value is set to ENABLED, then features like referential integrity and Bundle reference rewriting apply to all references. If this flag has not been specified the behavior of the FHIR store will not change, references in complex data types will not be parsed. New stores will have this value set to ENABLED by default after a notification period. Warning: turning on this flag causes processing existing resources to fail if they contain references to non-existent resources.
               Possible values are: `COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED`, `DISABLED`, `ENABLED`.
        :param pulumi.Input[Union['FhirStoreConsentConfigArgs', 'FhirStoreConsentConfigArgsDict']] consent_config: Specifies whether this store has consent enforcement. Not available for DSTU2 FHIR version due to absence of Consent resources. Not supported for R5 FHIR version.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset: Identifies the dataset addressed by this request. Must be in the format
               'projects/{project}/locations/{location}/datasets/{dataset}'
        :param pulumi.Input[_builtins.bool] default_search_handling_strict: If true, overrides the default search behavior for this FHIR store to handling=strict which returns an error for unrecognized search parameters.
               If false, uses the FHIR specification default handling=lenient which ignores unrecognized search parameters.
               The handling can always be changed from the default on an individual API call by setting the HTTP header Prefer: handling=strict or Prefer: handling=lenient.
        :param pulumi.Input[_builtins.bool] disable_referential_integrity: Whether to disable referential integrity in this FHIR store. This field is immutable after FHIR store
               creation. The default value is false, meaning that the API will enforce referential integrity and fail the
               requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
               will skip referential integrity check. Consequently, operations that rely on references, such as
               Patient.get$everything, will not return all the results if broken references exist.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[_builtins.bool] disable_resource_versioning: Whether to disable resource versioning for this FHIR store. This field can not be changed after the creation
               of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
               versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
               cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
               attempts to read the historical versions.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] enable_history_import: Whether to allow the bulk import API to accept history bundles and directly insert historical resource
               versions into the FHIR store. Importing resource histories creates resource interactions that appear to have
               occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
               will fail with an error.
               ** Changing this property may recreate the FHIR store (removing all data) **
               ** This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
        :param pulumi.Input[_builtins.bool] enable_history_modifications: Whether to allow the ExecuteBundle API to accept history bundles, and directly insert and overwrite historical
               resource versions into the FHIR store. If set to false, using history bundles fails with an error.
        :param pulumi.Input[_builtins.bool] enable_update_create: Whether this FHIR store has the updateCreate capability. This determines if the client can use an Update
               operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
               the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
               logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
               identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
               notifications.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-supplied key-value pairs used to organize FHIR stores.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
               conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
               bytes, and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given store.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name for the FhirStore.
               ** Changing this property may recreate the FHIR store (removing all data) **
        :param pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']] notification_config: (Optional, Deprecated)
               A nested object resource.
               Structure is documented below.
               
               > **Warning:** `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreNotificationConfigArgs', 'FhirStoreNotificationConfigArgsDict']]]] notification_configs: A list of notifcation configs that configure the notification for every resource mutation in this FHIR store.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] self_link: The fully qualified name of this dataset
        :param pulumi.Input[Sequence[pulumi.Input[Union['FhirStoreStreamConfigArgs', 'FhirStoreStreamConfigArgsDict']]]] stream_configs: A list of streaming configs that configure the destinations of streaming export for every resource mutation in
               this FHIR store. Each store is allowed to have up to 10 streaming configs. After a new config is added, the next
               resource mutation is streamed to the new location in addition to the existing ones. When a location is removed
               from the list, the server stops streaming to that location. Before adding a new config, you must add the required
               bigquery.dataEditor role to your project's Cloud Healthcare Service Agent service account. Some lag (typically on
               the order of dozens of seconds) is expected before the results show up in the streaming destination.
               Structure is documented below.
        :param pulumi.Input[Union['FhirStoreValidationConfigArgs', 'FhirStoreValidationConfigArgsDict']] validation_config: Configuration for how to validate incoming FHIR resources against configured profiles.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] version: The FHIR specification version.
               Default value is `STU3`.
               Possible values are: `DSTU2`, `STU3`, `R4`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FhirStoreState.__new__(_FhirStoreState)

        __props__.__dict__["complex_data_type_reference_parsing"] = complex_data_type_reference_parsing
        __props__.__dict__["consent_config"] = consent_config
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["default_search_handling_strict"] = default_search_handling_strict
        __props__.__dict__["disable_referential_integrity"] = disable_referential_integrity
        __props__.__dict__["disable_resource_versioning"] = disable_resource_versioning
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_history_import"] = enable_history_import
        __props__.__dict__["enable_history_modifications"] = enable_history_modifications
        __props__.__dict__["enable_update_create"] = enable_update_create
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_config"] = notification_config
        __props__.__dict__["notification_configs"] = notification_configs
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["stream_configs"] = stream_configs
        __props__.__dict__["validation_config"] = validation_config
        __props__.__dict__["version"] = version
        return FhirStore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="complexDataTypeReferenceParsing")
    def complex_data_type_reference_parsing(self) -> pulumi.Output[_builtins.str]:
        """
        Enable parsing of references within complex FHIR data types such as Extensions. If this value is set to ENABLED, then features like referential integrity and Bundle reference rewriting apply to all references. If this flag has not been specified the behavior of the FHIR store will not change, references in complex data types will not be parsed. New stores will have this value set to ENABLED by default after a notification period. Warning: turning on this flag causes processing existing resources to fail if they contain references to non-existent resources.
        Possible values are: `COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED`, `DISABLED`, `ENABLED`.
        """
        return pulumi.get(self, "complex_data_type_reference_parsing")

    @_builtins.property
    @pulumi.getter(name="consentConfig")
    def consent_config(self) -> pulumi.Output[Optional['outputs.FhirStoreConsentConfig']]:
        """
        Specifies whether this store has consent enforcement. Not available for DSTU2 FHIR version due to absence of Consent resources. Not supported for R5 FHIR version.
        Structure is documented below.
        """
        return pulumi.get(self, "consent_config")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the dataset addressed by this request. Must be in the format
        'projects/{project}/locations/{location}/datasets/{dataset}'
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="defaultSearchHandlingStrict")
    def default_search_handling_strict(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, overrides the default search behavior for this FHIR store to handling=strict which returns an error for unrecognized search parameters.
        If false, uses the FHIR specification default handling=lenient which ignores unrecognized search parameters.
        The handling can always be changed from the default on an individual API call by setting the HTTP header Prefer: handling=strict or Prefer: handling=lenient.
        """
        return pulumi.get(self, "default_search_handling_strict")

    @_builtins.property
    @pulumi.getter(name="disableReferentialIntegrity")
    def disable_referential_integrity(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to disable referential integrity in this FHIR store. This field is immutable after FHIR store
        creation. The default value is false, meaning that the API will enforce referential integrity and fail the
        requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
        will skip referential integrity check. Consequently, operations that rely on references, such as
        Patient.get$everything, will not return all the results if broken references exist.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "disable_referential_integrity")

    @_builtins.property
    @pulumi.getter(name="disableResourceVersioning")
    def disable_resource_versioning(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to disable resource versioning for this FHIR store. This field can not be changed after the creation
        of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
        versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
        cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
        attempts to read the historical versions.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "disable_resource_versioning")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="enableHistoryImport")
    def enable_history_import(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow the bulk import API to accept history bundles and directly insert historical resource
        versions into the FHIR store. Importing resource histories creates resource interactions that appear to have
        occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
        will fail with an error.
        ** Changing this property may recreate the FHIR store (removing all data) **
        ** This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
        """
        return pulumi.get(self, "enable_history_import")

    @_builtins.property
    @pulumi.getter(name="enableHistoryModifications")
    def enable_history_modifications(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow the ExecuteBundle API to accept history bundles, and directly insert and overwrite historical
        resource versions into the FHIR store. If set to false, using history bundles fails with an error.
        """
        return pulumi.get(self, "enable_history_modifications")

    @_builtins.property
    @pulumi.getter(name="enableUpdateCreate")
    def enable_update_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this FHIR store has the updateCreate capability. This determines if the client can use an Update
        operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
        the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
        logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
        identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
        notifications.
        """
        return pulumi.get(self, "enable_update_create")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-supplied key-value pairs used to organize FHIR stores.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
        conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
        bytes, and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be associated with a given store.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name for the FhirStore.
        ** Changing this property may recreate the FHIR store (removing all data) **
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    @_utilities.deprecated("""`notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.""")
    def notification_config(self) -> pulumi.Output[Optional['outputs.FhirStoreNotificationConfig']]:
        """
        (Optional, Deprecated)
        A nested object resource.
        Structure is documented below.

        > **Warning:** `notification_config` is deprecated and will be removed in a future major release. Use `notification_configs` instead.
        """
        return pulumi.get(self, "notification_config")

    @_builtins.property
    @pulumi.getter(name="notificationConfigs")
    def notification_configs(self) -> pulumi.Output[Optional[Sequence['outputs.FhirStoreNotificationConfig']]]:
        """
        A list of notifcation configs that configure the notification for every resource mutation in this FHIR store.
        Structure is documented below.
        """
        return pulumi.get(self, "notification_configs")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of this dataset
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="streamConfigs")
    def stream_configs(self) -> pulumi.Output[Optional[Sequence['outputs.FhirStoreStreamConfig']]]:
        """
        A list of streaming configs that configure the destinations of streaming export for every resource mutation in
        this FHIR store. Each store is allowed to have up to 10 streaming configs. After a new config is added, the next
        resource mutation is streamed to the new location in addition to the existing ones. When a location is removed
        from the list, the server stops streaming to that location. Before adding a new config, you must add the required
        bigquery.dataEditor role to your project's Cloud Healthcare Service Agent service account. Some lag (typically on
        the order of dozens of seconds) is expected before the results show up in the streaming destination.
        Structure is documented below.
        """
        return pulumi.get(self, "stream_configs")

    @_builtins.property
    @pulumi.getter(name="validationConfig")
    def validation_config(self) -> pulumi.Output[Optional['outputs.FhirStoreValidationConfig']]:
        """
        Configuration for how to validate incoming FHIR resources against configured profiles.
        Structure is documented below.
        """
        return pulumi.get(self, "validation_config")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The FHIR specification version.
        Default value is `STU3`.
        Possible values are: `DSTU2`, `STU3`, `R4`.
        """
        return pulumi.get(self, "version")

