# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkforcePoolProviderScimTenantArgs', 'WorkforcePoolProviderScimTenant']

@pulumi.input_type
class WorkforcePoolProviderScimTenantArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 provider_id: pulumi.Input[_builtins.str],
                 scim_tenant_id: pulumi.Input[_builtins.str],
                 workforce_pool_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkforcePoolProviderScimTenant resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] provider_id: The ID of the provider.
        :param pulumi.Input[_builtins.str] scim_tenant_id: The ID to use for the SCIM tenant, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID of the workforce pool.
        :param pulumi.Input[_builtins.str] description: A user-specified description of the provider. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name for the scim tenant. Cannot exceed 32 characters.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "provider_id", provider_id)
        pulumi.set(__self__, "scim_tenant_id", scim_tenant_id)
        pulumi.set(__self__, "workforce_pool_id", workforce_pool_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the provider.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_id", value)

    @_builtins.property
    @pulumi.getter(name="scimTenantId")
    def scim_tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the SCIM tenant, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        """
        return pulumi.get(self, "scim_tenant_id")

    @scim_tenant_id.setter
    def scim_tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scim_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workforce pool.
        """
        return pulumi.get(self, "workforce_pool_id")

    @workforce_pool_id.setter
    def workforce_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workforce_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified description of the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified display name for the scim tenant. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _WorkforcePoolProviderScimTenantState:
    def __init__(__self__, *,
                 base_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scim_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkforcePoolProviderScimTenant resources.
        :param pulumi.Input[_builtins.str] base_uri: Represents the base URI as defined in [RFC 7644, Section
               1.3](https://datatracker.ietf.org/doc/html/rfc7644#section-1.3). Clients
               must use this as the root address for managing resources under the tenant.
               Format:
               https://iamscim.googleapis.com/{version}/{tenant_id}/
        :param pulumi.Input[_builtins.str] description: A user-specified description of the provider. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name for the scim tenant. Cannot exceed 32 characters.
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the scim tenant.
               Format: `locations/{location}/workforcePools/{workforce_pool}/providers/{workforce_pool_provider}/scimTenants/{scim_tenant_id}
        :param pulumi.Input[_builtins.str] provider_id: The ID of the provider.
        :param pulumi.Input[_builtins.str] scim_tenant_id: The ID to use for the SCIM tenant, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        :param pulumi.Input[_builtins.str] state: The current state of the scim tenant.
               * STATE_UNSPECIFIED: State unspecified.
               * ACTIVE: The scim tenant is active and may be used to validate authentication credentials.
               * DELETED: The scim tenant is soft-deleted. Soft-deleted scim tenants are permanently
               deleted after approximately 30 days.
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID of the workforce pool.
        """
        if base_uri is not None:
            pulumi.set(__self__, "base_uri", base_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)
        if scim_tenant_id is not None:
            pulumi.set(__self__, "scim_tenant_id", scim_tenant_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if workforce_pool_id is not None:
            pulumi.set(__self__, "workforce_pool_id", workforce_pool_id)

    @_builtins.property
    @pulumi.getter(name="baseUri")
    def base_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents the base URI as defined in [RFC 7644, Section
        1.3](https://datatracker.ietf.org/doc/html/rfc7644#section-1.3). Clients
        must use this as the root address for managing resources under the tenant.
        Format:
        https://iamscim.googleapis.com/{version}/{tenant_id}/
        """
        return pulumi.get(self, "base_uri")

    @base_uri.setter
    def base_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_uri", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified description of the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified display name for the scim tenant. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name of the scim tenant.
        Format: `locations/{location}/workforcePools/{workforce_pool}/providers/{workforce_pool_provider}/scimTenants/{scim_tenant_id}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the provider.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_id", value)

    @_builtins.property
    @pulumi.getter(name="scimTenantId")
    def scim_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the SCIM tenant, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        """
        return pulumi.get(self, "scim_tenant_id")

    @scim_tenant_id.setter
    def scim_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scim_tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the scim tenant.
        * STATE_UNSPECIFIED: State unspecified.
        * ACTIVE: The scim tenant is active and may be used to validate authentication credentials.
        * DELETED: The scim tenant is soft-deleted. Soft-deleted scim tenants are permanently
        deleted after approximately 30 days.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workforce pool.
        """
        return pulumi.get(self, "workforce_pool_id")

    @workforce_pool_id.setter
    def workforce_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workforce_pool_id", value)


@pulumi.type_token("gcp:iam/workforcePoolProviderScimTenant:WorkforcePoolProviderScimTenant")
class WorkforcePoolProviderScimTenant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scim_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a SCIM tenant configuration for a Workforce Pool Provider.
        The SCIM tenant configuration allows for the synchronization of user/group identities from external identity provider into Google Cloud using the System for Cross-domain Identity Management (SCIM) protocol.

        To get more information about WorkforcePoolProviderScimTenant, see:

        * [API documentation](https://cloud.google.com/sdk/gcloud/reference/iam/workforce-pools/providers/scim-tenants)
        * How-to Guides
            * [QUICKSTART_TITLE](https://cloud.google.com/iam/docs/workforce-sign-in-microsoft-entra-id-scalable-groups?group_type=extended#extended-attributes)

        ## Example Usage

        ### Iam Workforce Pool Provider Scim Tenant Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        provider = gcp.iam.WorkforcePoolProvider("provider",
            location="global",
            workforce_pool_id=pool.workforce_pool_id,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://accounts.thirdparty.com",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                    "additional_scopes": [
                        "groups",
                        "roles",
                    ],
                },
            },
            display_name="Display name",
            description="A sample OIDC workforce pool provider.",
            disabled=False,
            attribute_condition="true")
        example = gcp.iam.WorkforcePoolProviderScimTenant("example",
            location="global",
            workforce_pool_id=pool.workforce_pool_id,
            provider_id=provider.provider_id,
            scim_tenant_id="example-scim-tenant",
            display_name="Example SCIM Tenant",
            description="A basic SCIM tenant for IAM Workforce Pool Provider")
        ```

        ## Import

        WorkforcePoolProviderScimTenant can be imported using any of these accepted formats:

        * `locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}/scimTenants/{{scim_tenant_id}}`

        * `{{location}}/{{workforce_pool_id}}/{{provider_id}}/{{scim_tenant_id}}`

        When using the `pulumi import` command, WorkforcePoolProviderScimTenant can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workforcePoolProviderScimTenant:WorkforcePoolProviderScimTenant default locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}/scimTenants/{{scim_tenant_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workforcePoolProviderScimTenant:WorkforcePoolProviderScimTenant default {{location}}/{{workforce_pool_id}}/{{provider_id}}/{{scim_tenant_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A user-specified description of the provider. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name for the scim tenant. Cannot exceed 32 characters.
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] provider_id: The ID of the provider.
        :param pulumi.Input[_builtins.str] scim_tenant_id: The ID to use for the SCIM tenant, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID of the workforce pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkforcePoolProviderScimTenantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a SCIM tenant configuration for a Workforce Pool Provider.
        The SCIM tenant configuration allows for the synchronization of user/group identities from external identity provider into Google Cloud using the System for Cross-domain Identity Management (SCIM) protocol.

        To get more information about WorkforcePoolProviderScimTenant, see:

        * [API documentation](https://cloud.google.com/sdk/gcloud/reference/iam/workforce-pools/providers/scim-tenants)
        * How-to Guides
            * [QUICKSTART_TITLE](https://cloud.google.com/iam/docs/workforce-sign-in-microsoft-entra-id-scalable-groups?group_type=extended#extended-attributes)

        ## Example Usage

        ### Iam Workforce Pool Provider Scim Tenant Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        provider = gcp.iam.WorkforcePoolProvider("provider",
            location="global",
            workforce_pool_id=pool.workforce_pool_id,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://accounts.thirdparty.com",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                    "additional_scopes": [
                        "groups",
                        "roles",
                    ],
                },
            },
            display_name="Display name",
            description="A sample OIDC workforce pool provider.",
            disabled=False,
            attribute_condition="true")
        example = gcp.iam.WorkforcePoolProviderScimTenant("example",
            location="global",
            workforce_pool_id=pool.workforce_pool_id,
            provider_id=provider.provider_id,
            scim_tenant_id="example-scim-tenant",
            display_name="Example SCIM Tenant",
            description="A basic SCIM tenant for IAM Workforce Pool Provider")
        ```

        ## Import

        WorkforcePoolProviderScimTenant can be imported using any of these accepted formats:

        * `locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}/scimTenants/{{scim_tenant_id}}`

        * `{{location}}/{{workforce_pool_id}}/{{provider_id}}/{{scim_tenant_id}}`

        When using the `pulumi import` command, WorkforcePoolProviderScimTenant can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workforcePoolProviderScimTenant:WorkforcePoolProviderScimTenant default locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}/scimTenants/{{scim_tenant_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workforcePoolProviderScimTenant:WorkforcePoolProviderScimTenant default {{location}}/{{workforce_pool_id}}/{{provider_id}}/{{scim_tenant_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkforcePoolProviderScimTenantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkforcePoolProviderScimTenantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scim_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkforcePoolProviderScimTenantArgs.__new__(WorkforcePoolProviderScimTenantArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if provider_id is None and not opts.urn:
                raise TypeError("Missing required property 'provider_id'")
            __props__.__dict__["provider_id"] = provider_id
            if scim_tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'scim_tenant_id'")
            __props__.__dict__["scim_tenant_id"] = scim_tenant_id
            if workforce_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'workforce_pool_id'")
            __props__.__dict__["workforce_pool_id"] = workforce_pool_id
            __props__.__dict__["base_uri"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(WorkforcePoolProviderScimTenant, __self__).__init__(
            'gcp:iam/workforcePoolProviderScimTenant:WorkforcePoolProviderScimTenant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_uri: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            provider_id: Optional[pulumi.Input[_builtins.str]] = None,
            scim_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkforcePoolProviderScimTenant':
        """
        Get an existing WorkforcePoolProviderScimTenant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_uri: Represents the base URI as defined in [RFC 7644, Section
               1.3](https://datatracker.ietf.org/doc/html/rfc7644#section-1.3). Clients
               must use this as the root address for managing resources under the tenant.
               Format:
               https://iamscim.googleapis.com/{version}/{tenant_id}/
        :param pulumi.Input[_builtins.str] description: A user-specified description of the provider. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name for the scim tenant. Cannot exceed 32 characters.
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the scim tenant.
               Format: `locations/{location}/workforcePools/{workforce_pool}/providers/{workforce_pool_provider}/scimTenants/{scim_tenant_id}
        :param pulumi.Input[_builtins.str] provider_id: The ID of the provider.
        :param pulumi.Input[_builtins.str] scim_tenant_id: The ID to use for the SCIM tenant, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        :param pulumi.Input[_builtins.str] state: The current state of the scim tenant.
               * STATE_UNSPECIFIED: State unspecified.
               * ACTIVE: The scim tenant is active and may be used to validate authentication credentials.
               * DELETED: The scim tenant is soft-deleted. Soft-deleted scim tenants are permanently
               deleted after approximately 30 days.
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID of the workforce pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkforcePoolProviderScimTenantState.__new__(_WorkforcePoolProviderScimTenantState)

        __props__.__dict__["base_uri"] = base_uri
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["provider_id"] = provider_id
        __props__.__dict__["scim_tenant_id"] = scim_tenant_id
        __props__.__dict__["state"] = state
        __props__.__dict__["workforce_pool_id"] = workforce_pool_id
        return WorkforcePoolProviderScimTenant(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="baseUri")
    def base_uri(self) -> pulumi.Output[_builtins.str]:
        """
        Represents the base URI as defined in [RFC 7644, Section
        1.3](https://datatracker.ietf.org/doc/html/rfc7644#section-1.3). Clients
        must use this as the root address for managing resources under the tenant.
        Format:
        https://iamscim.googleapis.com/{version}/{tenant_id}/
        """
        return pulumi.get(self, "base_uri")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user-specified description of the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user-specified display name for the scim tenant. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name of the scim tenant.
        Format: `locations/{location}/workforcePools/{workforce_pool}/providers/{workforce_pool_provider}/scimTenants/{scim_tenant_id}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the provider.
        """
        return pulumi.get(self, "provider_id")

    @_builtins.property
    @pulumi.getter(name="scimTenantId")
    def scim_tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the SCIM tenant, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        """
        return pulumi.get(self, "scim_tenant_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the scim tenant.
        * STATE_UNSPECIFIED: State unspecified.
        * ACTIVE: The scim tenant is active and may be used to validate authentication credentials.
        * DELETED: The scim tenant is soft-deleted. Soft-deleted scim tenants are permanently
        deleted after approximately 30 days.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workforce pool.
        """
        return pulumi.get(self, "workforce_pool_id")

