# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TenantOauthIdpConfigArgs', 'TenantOauthIdpConfig']

@pulumi.input_type
class TenantOauthIdpConfigArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 issuer: pulumi.Input[_builtins.str],
                 tenant: pulumi.Input[_builtins.str],
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TenantOauthIdpConfig resource.
        :param pulumi.Input[_builtins.str] client_id: The client id of an OAuth client.
        :param pulumi.Input[_builtins.str] display_name: Human friendly display name.
        :param pulumi.Input[_builtins.str] issuer: For OIDC Idps, the issuer identifier.
        :param pulumi.Input[_builtins.str] tenant: The name of the tenant where this OIDC IDP configuration resource exists
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the OAuth client, to enable OIDC code flow.
        :param pulumi.Input[_builtins.bool] enabled: If this config allows users to sign in with the provider.
        :param pulumi.Input[_builtins.str] name: The name of the OauthIdpConfig. Must start with `oidc.`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "tenant", tenant)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client id of an OAuth client.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Human friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[_builtins.str]:
        """
        For OIDC Idps, the issuer identifier.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the tenant where this OIDC IDP configuration resource exists
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of the OAuth client, to enable OIDC code flow.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this config allows users to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OauthIdpConfig. Must start with `oidc.`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _TenantOauthIdpConfigState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TenantOauthIdpConfig resources.
        :param pulumi.Input[_builtins.str] client_id: The client id of an OAuth client.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the OAuth client, to enable OIDC code flow.
        :param pulumi.Input[_builtins.str] display_name: Human friendly display name.
        :param pulumi.Input[_builtins.bool] enabled: If this config allows users to sign in with the provider.
        :param pulumi.Input[_builtins.str] issuer: For OIDC Idps, the issuer identifier.
        :param pulumi.Input[_builtins.str] name: The name of the OauthIdpConfig. Must start with `oidc.`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] tenant: The name of the tenant where this OIDC IDP configuration resource exists
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client id of an OAuth client.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of the OAuth client, to enable OIDC code flow.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this config allows users to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For OIDC Idps, the issuer identifier.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OauthIdpConfig. Must start with `oidc.`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the tenant where this OIDC IDP configuration resource exists
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)


@pulumi.type_token("gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig")
class TenantOauthIdpConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        OIDC IdP configuration for a Identity Toolkit project within a tenant.

        You must enable the
        [Google Identity Platform](https://console.cloud.google.com/marketplace/details/google-cloud-platform/customer-identity) in
        the marketplace prior to using this resource.

        ## Example Usage

        ### Identity Platform Tenant Oauth Idp Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tenant = gcp.identityplatform.Tenant("tenant", display_name="tenant")
        tenant_oauth_idp_config = gcp.identityplatform.TenantOauthIdpConfig("tenant_oauth_idp_config",
            name="oidc.oauth-idp-config",
            tenant=tenant.name,
            display_name="Display Name",
            client_id="client-id",
            issuer="issuer",
            enabled=True,
            client_secret="secret")
        ```

        ## Import

        TenantOauthIdpConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/tenants/{{tenant}}/oauthIdpConfigs/{{name}}`

        * `{{project}}/{{tenant}}/{{name}}`

        * `{{tenant}}/{{name}}`

        When using the `pulumi import` command, TenantOauthIdpConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig default projects/{{project}}/tenants/{{tenant}}/oauthIdpConfigs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig default {{project}}/{{tenant}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig default {{tenant}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_id: The client id of an OAuth client.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the OAuth client, to enable OIDC code flow.
        :param pulumi.Input[_builtins.str] display_name: Human friendly display name.
        :param pulumi.Input[_builtins.bool] enabled: If this config allows users to sign in with the provider.
        :param pulumi.Input[_builtins.str] issuer: For OIDC Idps, the issuer identifier.
        :param pulumi.Input[_builtins.str] name: The name of the OauthIdpConfig. Must start with `oidc.`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] tenant: The name of the tenant where this OIDC IDP configuration resource exists
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TenantOauthIdpConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        OIDC IdP configuration for a Identity Toolkit project within a tenant.

        You must enable the
        [Google Identity Platform](https://console.cloud.google.com/marketplace/details/google-cloud-platform/customer-identity) in
        the marketplace prior to using this resource.

        ## Example Usage

        ### Identity Platform Tenant Oauth Idp Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tenant = gcp.identityplatform.Tenant("tenant", display_name="tenant")
        tenant_oauth_idp_config = gcp.identityplatform.TenantOauthIdpConfig("tenant_oauth_idp_config",
            name="oidc.oauth-idp-config",
            tenant=tenant.name,
            display_name="Display Name",
            client_id="client-id",
            issuer="issuer",
            enabled=True,
            client_secret="secret")
        ```

        ## Import

        TenantOauthIdpConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/tenants/{{tenant}}/oauthIdpConfigs/{{name}}`

        * `{{project}}/{{tenant}}/{{name}}`

        * `{{tenant}}/{{name}}`

        When using the `pulumi import` command, TenantOauthIdpConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig default projects/{{project}}/tenants/{{tenant}}/oauthIdpConfigs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig default {{project}}/{{tenant}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig default {{tenant}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TenantOauthIdpConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantOauthIdpConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantOauthIdpConfigArgs.__new__(TenantOauthIdpConfigArgs)

            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            if issuer is None and not opts.urn:
                raise TypeError("Missing required property 'issuer'")
            __props__.__dict__["issuer"] = issuer
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if tenant is None and not opts.urn:
                raise TypeError("Missing required property 'tenant'")
            __props__.__dict__["tenant"] = tenant
        super(TenantOauthIdpConfig, __self__).__init__(
            'gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            issuer: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            tenant: Optional[pulumi.Input[_builtins.str]] = None) -> 'TenantOauthIdpConfig':
        """
        Get an existing TenantOauthIdpConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_id: The client id of an OAuth client.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the OAuth client, to enable OIDC code flow.
        :param pulumi.Input[_builtins.str] display_name: Human friendly display name.
        :param pulumi.Input[_builtins.bool] enabled: If this config allows users to sign in with the provider.
        :param pulumi.Input[_builtins.str] issuer: For OIDC Idps, the issuer identifier.
        :param pulumi.Input[_builtins.str] name: The name of the OauthIdpConfig. Must start with `oidc.`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] tenant: The name of the tenant where this OIDC IDP configuration resource exists
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantOauthIdpConfigState.__new__(_TenantOauthIdpConfigState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["tenant"] = tenant
        return TenantOauthIdpConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The client id of an OAuth client.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The client secret of the OAuth client, to enable OIDC code flow.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Human friendly display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If this config allows users to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[_builtins.str]:
        """
        For OIDC Idps, the issuer identifier.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OauthIdpConfig. Must start with `oidc.`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the tenant where this OIDC IDP configuration resource exists
        """
        return pulumi.get(self, "tenant")

