# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FolderKajPolicyConfigArgs', 'FolderKajPolicyConfig']

@pulumi.input_type
class FolderKajPolicyConfigArgs:
    def __init__(__self__, *,
                 folder: pulumi.Input[_builtins.str],
                 default_key_access_justification_policy: Optional[pulumi.Input['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']] = None):
        """
        The set of arguments for constructing a FolderKajPolicyConfig resource.
        :param pulumi.Input[_builtins.str] folder: The numeric folder number for which to retrieve config.
        :param pulumi.Input['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs'] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this folder. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        """
        pulumi.set(__self__, "folder", folder)
        if default_key_access_justification_policy is not None:
            pulumi.set(__self__, "default_key_access_justification_policy", default_key_access_justification_policy)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Input[_builtins.str]:
        """
        The numeric folder number for which to retrieve config.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> Optional[pulumi.Input['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this folder. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @default_key_access_justification_policy.setter
    def default_key_access_justification_policy(self, value: Optional[pulumi.Input['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]):
        pulumi.set(self, "default_key_access_justification_policy", value)


@pulumi.input_type
class _FolderKajPolicyConfigState:
    def __init__(__self__, *,
                 default_key_access_justification_policy: Optional[pulumi.Input['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FolderKajPolicyConfig resources.
        :param pulumi.Input['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs'] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this folder. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] folder: The numeric folder number for which to retrieve config.
        """
        if default_key_access_justification_policy is not None:
            pulumi.set(__self__, "default_key_access_justification_policy", default_key_access_justification_policy)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> Optional[pulumi.Input['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this folder. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @default_key_access_justification_policy.setter
    def default_key_access_justification_policy(self, value: Optional[pulumi.Input['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]):
        pulumi.set(self, "default_key_access_justification_policy", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The numeric folder number for which to retrieve config.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)


@pulumi.type_token("gcp:kms/folderKajPolicyConfig:FolderKajPolicyConfig")
class FolderKajPolicyConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_key_access_justification_policy: Optional[pulumi.Input[Union['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Kms Folder Kaj Policy Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random
        import pulumiverse_time as time

        # Create Folder in GCP Organization.
        kaj_folder = gcp.organizations.Folder("kaj_folder",
            display_name="my-folder",
            parent="organizations/123456789",
            deletion_protection=False)
        project_suffix = random.RandomId("project_suffix", byte_length=4)
        # Create a project for enabling KMS API.
        kms_project = gcp.organizations.Project("kms_project",
            project_id=project_suffix.hex.apply(lambda hex: f"kms-api-project{hex}"),
            name=project_suffix.hex.apply(lambda hex: f"kms-api-project{hex}"),
            folder_id=kaj_folder.folder_id,
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            opts = pulumi.ResourceOptions(depends_on=[kaj_folder]))
        # Enable the Cloud KMS API.
        kms_api_service = gcp.projects.Service("kms_api_service",
            service="cloudkms.googleapis.com",
            project=kms_project.project_id,
            disable_dependent_services=True,
            opts = pulumi.ResourceOptions(depends_on=[kms_project]))
        wait_enable_service_api = time.Sleep("wait_enable_service_api", create_duration="30s",
        opts = pulumi.ResourceOptions(depends_on=[kms_api_service]))
        # Update folder level KAJ default policy
        example = gcp.kms.FolderKajPolicyConfig("example",
            folder=kaj_folder.folder_id,
            default_key_access_justification_policy={
                "allowed_access_reasons": [
                    "CUSTOMER_INITIATED_ACCESS",
                    "GOOGLE_INITIATED_SYSTEM_OPERATION",
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        ```

        ## Import

        FolderKajPolicyConfig can be imported using any of these accepted formats:

        * `folders/{{folder}}/kajPolicyConfig`

        * `{{folder}}`

        When using the `pulumi import` command, FolderKajPolicyConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/folderKajPolicyConfig:FolderKajPolicyConfig default folders/{{folder}}/kajPolicyConfig
        ```

        ```sh
        $ pulumi import gcp:kms/folderKajPolicyConfig:FolderKajPolicyConfig default {{folder}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this folder. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] folder: The numeric folder number for which to retrieve config.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FolderKajPolicyConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Kms Folder Kaj Policy Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random
        import pulumiverse_time as time

        # Create Folder in GCP Organization.
        kaj_folder = gcp.organizations.Folder("kaj_folder",
            display_name="my-folder",
            parent="organizations/123456789",
            deletion_protection=False)
        project_suffix = random.RandomId("project_suffix", byte_length=4)
        # Create a project for enabling KMS API.
        kms_project = gcp.organizations.Project("kms_project",
            project_id=project_suffix.hex.apply(lambda hex: f"kms-api-project{hex}"),
            name=project_suffix.hex.apply(lambda hex: f"kms-api-project{hex}"),
            folder_id=kaj_folder.folder_id,
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            opts = pulumi.ResourceOptions(depends_on=[kaj_folder]))
        # Enable the Cloud KMS API.
        kms_api_service = gcp.projects.Service("kms_api_service",
            service="cloudkms.googleapis.com",
            project=kms_project.project_id,
            disable_dependent_services=True,
            opts = pulumi.ResourceOptions(depends_on=[kms_project]))
        wait_enable_service_api = time.Sleep("wait_enable_service_api", create_duration="30s",
        opts = pulumi.ResourceOptions(depends_on=[kms_api_service]))
        # Update folder level KAJ default policy
        example = gcp.kms.FolderKajPolicyConfig("example",
            folder=kaj_folder.folder_id,
            default_key_access_justification_policy={
                "allowed_access_reasons": [
                    "CUSTOMER_INITIATED_ACCESS",
                    "GOOGLE_INITIATED_SYSTEM_OPERATION",
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        ```

        ## Import

        FolderKajPolicyConfig can be imported using any of these accepted formats:

        * `folders/{{folder}}/kajPolicyConfig`

        * `{{folder}}`

        When using the `pulumi import` command, FolderKajPolicyConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/folderKajPolicyConfig:FolderKajPolicyConfig default folders/{{folder}}/kajPolicyConfig
        ```

        ```sh
        $ pulumi import gcp:kms/folderKajPolicyConfig:FolderKajPolicyConfig default {{folder}}
        ```

        :param str resource_name: The name of the resource.
        :param FolderKajPolicyConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FolderKajPolicyConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_key_access_justification_policy: Optional[pulumi.Input[Union['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FolderKajPolicyConfigArgs.__new__(FolderKajPolicyConfigArgs)

            __props__.__dict__["default_key_access_justification_policy"] = default_key_access_justification_policy
            if folder is None and not opts.urn:
                raise TypeError("Missing required property 'folder'")
            __props__.__dict__["folder"] = folder
        super(FolderKajPolicyConfig, __self__).__init__(
            'gcp:kms/folderKajPolicyConfig:FolderKajPolicyConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_key_access_justification_policy: Optional[pulumi.Input[Union['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None) -> 'FolderKajPolicyConfig':
        """
        Get an existing FolderKajPolicyConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'FolderKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this folder. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] folder: The numeric folder number for which to retrieve config.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FolderKajPolicyConfigState.__new__(_FolderKajPolicyConfigState)

        __props__.__dict__["default_key_access_justification_policy"] = default_key_access_justification_policy
        __props__.__dict__["folder"] = folder
        return FolderKajPolicyConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> pulumi.Output[Optional['outputs.FolderKajPolicyConfigDefaultKeyAccessJustificationPolicy']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this folder. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[_builtins.str]:
        """
        The numeric folder number for which to retrieve config.
        """
        return pulumi.get(self, "folder")

