# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationKajPolicyConfigArgs', 'OrganizationKajPolicyConfig']

@pulumi.input_type
class OrganizationKajPolicyConfigArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[_builtins.str],
                 default_key_access_justification_policy: Optional[pulumi.Input['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']] = None):
        """
        The set of arguments for constructing a OrganizationKajPolicyConfig resource.
        :param pulumi.Input[_builtins.str] organization: The organization number for which to retrieve config.
        :param pulumi.Input['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs'] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this organization. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        """
        pulumi.set(__self__, "organization", organization)
        if default_key_access_justification_policy is not None:
            pulumi.set(__self__, "default_key_access_justification_policy", default_key_access_justification_policy)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        The organization number for which to retrieve config.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> Optional[pulumi.Input['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this organization. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @default_key_access_justification_policy.setter
    def default_key_access_justification_policy(self, value: Optional[pulumi.Input['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]):
        pulumi.set(self, "default_key_access_justification_policy", value)


@pulumi.input_type
class _OrganizationKajPolicyConfigState:
    def __init__(__self__, *,
                 default_key_access_justification_policy: Optional[pulumi.Input['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationKajPolicyConfig resources.
        :param pulumi.Input['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs'] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this organization. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] organization: The organization number for which to retrieve config.
        """
        if default_key_access_justification_policy is not None:
            pulumi.set(__self__, "default_key_access_justification_policy", default_key_access_justification_policy)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> Optional[pulumi.Input['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this organization. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @default_key_access_justification_policy.setter
    def default_key_access_justification_policy(self, value: Optional[pulumi.Input['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]):
        pulumi.set(self, "default_key_access_justification_policy", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization number for which to retrieve config.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)


@pulumi.type_token("gcp:kms/organizationKajPolicyConfig:OrganizationKajPolicyConfig")
class OrganizationKajPolicyConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_key_access_justification_policy: Optional[pulumi.Input[Union['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Kms Organization Kaj Policy Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.kms.OrganizationKajPolicyConfig("example",
            organization="123456789",
            default_key_access_justification_policy={
                "allowed_access_reasons": [
                    "CUSTOMER_INITIATED_ACCESS",
                    "GOOGLE_INITIATED_SYSTEM_OPERATION",
                ],
            })
        ```

        ## Import

        OrganizationKajPolicyConfig can be imported using any of these accepted formats:

        * `organizations/{{organization}}/kajPolicyConfig`

        * `{{organization}}`

        When using the `pulumi import` command, OrganizationKajPolicyConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/organizationKajPolicyConfig:OrganizationKajPolicyConfig default organizations/{{organization}}/kajPolicyConfig
        ```

        ```sh
        $ pulumi import gcp:kms/organizationKajPolicyConfig:OrganizationKajPolicyConfig default {{organization}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this organization. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] organization: The organization number for which to retrieve config.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationKajPolicyConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Kms Organization Kaj Policy Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.kms.OrganizationKajPolicyConfig("example",
            organization="123456789",
            default_key_access_justification_policy={
                "allowed_access_reasons": [
                    "CUSTOMER_INITIATED_ACCESS",
                    "GOOGLE_INITIATED_SYSTEM_OPERATION",
                ],
            })
        ```

        ## Import

        OrganizationKajPolicyConfig can be imported using any of these accepted formats:

        * `organizations/{{organization}}/kajPolicyConfig`

        * `{{organization}}`

        When using the `pulumi import` command, OrganizationKajPolicyConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/organizationKajPolicyConfig:OrganizationKajPolicyConfig default organizations/{{organization}}/kajPolicyConfig
        ```

        ```sh
        $ pulumi import gcp:kms/organizationKajPolicyConfig:OrganizationKajPolicyConfig default {{organization}}
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationKajPolicyConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationKajPolicyConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_key_access_justification_policy: Optional[pulumi.Input[Union['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationKajPolicyConfigArgs.__new__(OrganizationKajPolicyConfigArgs)

            __props__.__dict__["default_key_access_justification_policy"] = default_key_access_justification_policy
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
        super(OrganizationKajPolicyConfig, __self__).__init__(
            'gcp:kms/organizationKajPolicyConfig:OrganizationKajPolicyConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_key_access_justification_policy: Optional[pulumi.Input[Union['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationKajPolicyConfig':
        """
        Get an existing OrganizationKajPolicyConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this organization. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] organization: The organization number for which to retrieve config.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationKajPolicyConfigState.__new__(_OrganizationKajPolicyConfigState)

        __props__.__dict__["default_key_access_justification_policy"] = default_key_access_justification_policy
        __props__.__dict__["organization"] = organization
        return OrganizationKajPolicyConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> pulumi.Output[Optional['outputs.OrganizationKajPolicyConfigDefaultKeyAccessJustificationPolicy']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this organization. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        The organization number for which to retrieve config.
        """
        return pulumi.get(self, "organization")

