# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectKajPolicyConfigArgs', 'ProjectKajPolicyConfig']

@pulumi.input_type
class ProjectKajPolicyConfigArgs:
    def __init__(__self__, *,
                 default_key_access_justification_policy: Optional[pulumi.Input['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProjectKajPolicyConfig resource.
        :param pulumi.Input['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs'] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this project. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if default_key_access_justification_policy is not None:
            pulumi.set(__self__, "default_key_access_justification_policy", default_key_access_justification_policy)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> Optional[pulumi.Input['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this project. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @default_key_access_justification_policy.setter
    def default_key_access_justification_policy(self, value: Optional[pulumi.Input['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]):
        pulumi.set(self, "default_key_access_justification_policy", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ProjectKajPolicyConfigState:
    def __init__(__self__, *,
                 default_key_access_justification_policy: Optional[pulumi.Input['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectKajPolicyConfig resources.
        :param pulumi.Input['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs'] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this project. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if default_key_access_justification_policy is not None:
            pulumi.set(__self__, "default_key_access_justification_policy", default_key_access_justification_policy)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> Optional[pulumi.Input['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this project. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @default_key_access_justification_policy.setter
    def default_key_access_justification_policy(self, value: Optional[pulumi.Input['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs']]):
        pulumi.set(self, "default_key_access_justification_policy", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:kms/projectKajPolicyConfig:ProjectKajPolicyConfig")
class ProjectKajPolicyConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_key_access_justification_policy: Optional[pulumi.Input[Union['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Kms Project Kaj Policy Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumiverse_time as time

        # Create a project
        kms_project = gcp.organizations.Project("kms_project",
            project_id="my-project",
            name="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        # Enable the Cloud KMS API.
        kms_api_service = gcp.projects.Service("kms_api_service",
            service="cloudkms.googleapis.com",
            project=kms_project.project_id,
            disable_dependent_services=True,
            opts = pulumi.ResourceOptions(depends_on=[kms_project]))
        wait_enable_service_api = time.Sleep("wait_enable_service_api", create_duration="30s",
        opts = pulumi.ResourceOptions(depends_on=[kms_api_service]))
        example = gcp.kms.ProjectKajPolicyConfig("example",
            project=kms_project.project_id,
            default_key_access_justification_policy={
                "allowed_access_reasons": [
                    "CUSTOMER_INITIATED_ACCESS",
                    "GOOGLE_INITIATED_SYSTEM_OPERATION",
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        ```

        ## Import

        ProjectKajPolicyConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/kajPolicyConfig`

        * `{{project}}`

        When using the `pulumi import` command, ProjectKajPolicyConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/projectKajPolicyConfig:ProjectKajPolicyConfig default projects/{{project}}/kajPolicyConfig
        ```

        ```sh
        $ pulumi import gcp:kms/projectKajPolicyConfig:ProjectKajPolicyConfig default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this project. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectKajPolicyConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Kms Project Kaj Policy Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumiverse_time as time

        # Create a project
        kms_project = gcp.organizations.Project("kms_project",
            project_id="my-project",
            name="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        # Enable the Cloud KMS API.
        kms_api_service = gcp.projects.Service("kms_api_service",
            service="cloudkms.googleapis.com",
            project=kms_project.project_id,
            disable_dependent_services=True,
            opts = pulumi.ResourceOptions(depends_on=[kms_project]))
        wait_enable_service_api = time.Sleep("wait_enable_service_api", create_duration="30s",
        opts = pulumi.ResourceOptions(depends_on=[kms_api_service]))
        example = gcp.kms.ProjectKajPolicyConfig("example",
            project=kms_project.project_id,
            default_key_access_justification_policy={
                "allowed_access_reasons": [
                    "CUSTOMER_INITIATED_ACCESS",
                    "GOOGLE_INITIATED_SYSTEM_OPERATION",
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        ```

        ## Import

        ProjectKajPolicyConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/kajPolicyConfig`

        * `{{project}}`

        When using the `pulumi import` command, ProjectKajPolicyConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/projectKajPolicyConfig:ProjectKajPolicyConfig default projects/{{project}}/kajPolicyConfig
        ```

        ```sh
        $ pulumi import gcp:kms/projectKajPolicyConfig:ProjectKajPolicyConfig default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param ProjectKajPolicyConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectKajPolicyConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_key_access_justification_policy: Optional[pulumi.Input[Union['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectKajPolicyConfigArgs.__new__(ProjectKajPolicyConfigArgs)

            __props__.__dict__["default_key_access_justification_policy"] = default_key_access_justification_policy
            __props__.__dict__["project"] = project
        super(ProjectKajPolicyConfig, __self__).__init__(
            'gcp:kms/projectKajPolicyConfig:ProjectKajPolicyConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_key_access_justification_policy: Optional[pulumi.Input[Union['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProjectKajPolicyConfig':
        """
        Get an existing ProjectKajPolicyConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgs', 'ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicyArgsDict']] default_key_access_justification_policy: The default key access justification policy used when a CryptoKey is
               created in this project. This is only used when a Key Access Justifications
               policy is not provided in the CreateCryptoKeyRequest.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectKajPolicyConfigState.__new__(_ProjectKajPolicyConfigState)

        __props__.__dict__["default_key_access_justification_policy"] = default_key_access_justification_policy
        __props__.__dict__["project"] = project
        return ProjectKajPolicyConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultKeyAccessJustificationPolicy")
    def default_key_access_justification_policy(self) -> pulumi.Output[Optional['outputs.ProjectKajPolicyConfigDefaultKeyAccessJustificationPolicy']]:
        """
        The default key access justification policy used when a CryptoKey is
        created in this project. This is only used when a Key Access Justifications
        policy is not provided in the CreateCryptoKeyRequest.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_access_justification_policy")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

