# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 capacity_config: pulumi.Input['ClusterCapacityConfigArgs'],
                 cluster_id: pulumi.Input[_builtins.str],
                 gcp_config: pulumi.Input['ClusterGcpConfigArgs'],
                 location: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rebalance_config: Optional[pulumi.Input['ClusterRebalanceConfigArgs']] = None,
                 tls_config: Optional[pulumi.Input['ClusterTlsConfigArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['ClusterCapacityConfigArgs'] capacity_config: A capacity configuration of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cluster_id: The ID to use for the cluster, which will become the final component of the cluster's name. The ID must be 1-63 characters long, and match the regular expression `a-z?` to comply with RFC 1035. This value is structured like: `my-cluster-id`.
        :param pulumi.Input['ClusterGcpConfigArgs'] gcp_config: Configuration properties for a Kafka cluster deployed to Google Cloud Platform.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-), underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase characters, and numbers.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ClusterRebalanceConfigArgs'] rebalance_config: Defines rebalancing behavior of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input['ClusterTlsConfigArgs'] tls_config: TLS configuration for the Kafka cluster. This is used to configure mTLS authentication. To clear our a TLS configuration that has been previously set, please explicitly add an empty `tls_config` block.
               Structure is documented below.
        """
        pulumi.set(__self__, "capacity_config", capacity_config)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "gcp_config", gcp_config)
        pulumi.set(__self__, "location", location)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rebalance_config is not None:
            pulumi.set(__self__, "rebalance_config", rebalance_config)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @_builtins.property
    @pulumi.getter(name="capacityConfig")
    def capacity_config(self) -> pulumi.Input['ClusterCapacityConfigArgs']:
        """
        A capacity configuration of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "capacity_config")

    @capacity_config.setter
    def capacity_config(self, value: pulumi.Input['ClusterCapacityConfigArgs']):
        pulumi.set(self, "capacity_config", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the cluster, which will become the final component of the cluster's name. The ID must be 1-63 characters long, and match the regular expression `a-z?` to comply with RFC 1035. This value is structured like: `my-cluster-id`.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="gcpConfig")
    def gcp_config(self) -> pulumi.Input['ClusterGcpConfigArgs']:
        """
        Configuration properties for a Kafka cluster deployed to Google Cloud Platform.
        Structure is documented below.
        """
        return pulumi.get(self, "gcp_config")

    @gcp_config.setter
    def gcp_config(self, value: pulumi.Input['ClusterGcpConfigArgs']):
        pulumi.set(self, "gcp_config", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-), underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase characters, and numbers.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rebalanceConfig")
    def rebalance_config(self) -> Optional[pulumi.Input['ClusterRebalanceConfigArgs']]:
        """
        Defines rebalancing behavior of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "rebalance_config")

    @rebalance_config.setter
    def rebalance_config(self, value: Optional[pulumi.Input['ClusterRebalanceConfigArgs']]):
        pulumi.set(self, "rebalance_config", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['ClusterTlsConfigArgs']]:
        """
        TLS configuration for the Kafka cluster. This is used to configure mTLS authentication. To clear our a TLS configuration that has been previously set, please explicitly add an empty `tls_config` block.
        Structure is documented below.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['ClusterTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 capacity_config: Optional[pulumi.Input['ClusterCapacityConfigArgs']] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gcp_config: Optional[pulumi.Input['ClusterGcpConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rebalance_config: Optional[pulumi.Input['ClusterRebalanceConfigArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_config: Optional[pulumi.Input['ClusterTlsConfigArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input['ClusterCapacityConfigArgs'] capacity_config: A capacity configuration of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cluster_id: The ID to use for the cluster, which will become the final component of the cluster's name. The ID must be 1-63 characters long, and match the regular expression `a-z?` to comply with RFC 1035. This value is structured like: `my-cluster-id`.
        :param pulumi.Input[_builtins.str] create_time: The time when the cluster was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['ClusterGcpConfigArgs'] gcp_config: Configuration properties for a Kafka cluster deployed to Google Cloud Platform.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-), underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase characters, and numbers.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[_builtins.str] name: The name of the cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['ClusterRebalanceConfigArgs'] rebalance_config: Defines rebalancing behavior of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The current state of the cluster. Possible values: `STATE_UNSPECIFIED`, `CREATING`, `ACTIVE`, `DELETING`.
        :param pulumi.Input['ClusterTlsConfigArgs'] tls_config: TLS configuration for the Kafka cluster. This is used to configure mTLS authentication. To clear our a TLS configuration that has been previously set, please explicitly add an empty `tls_config` block.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The time when the cluster was last updated.
        """
        if capacity_config is not None:
            pulumi.set(__self__, "capacity_config", capacity_config)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if gcp_config is not None:
            pulumi.set(__self__, "gcp_config", gcp_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if rebalance_config is not None:
            pulumi.set(__self__, "rebalance_config", rebalance_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="capacityConfig")
    def capacity_config(self) -> Optional[pulumi.Input['ClusterCapacityConfigArgs']]:
        """
        A capacity configuration of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "capacity_config")

    @capacity_config.setter
    def capacity_config(self, value: Optional[pulumi.Input['ClusterCapacityConfigArgs']]):
        pulumi.set(self, "capacity_config", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the cluster, which will become the final component of the cluster's name. The ID must be 1-63 characters long, and match the regular expression `a-z?` to comply with RFC 1035. This value is structured like: `my-cluster-id`.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the cluster was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="gcpConfig")
    def gcp_config(self) -> Optional[pulumi.Input['ClusterGcpConfigArgs']]:
        """
        Configuration properties for a Kafka cluster deployed to Google Cloud Platform.
        Structure is documented below.
        """
        return pulumi.get(self, "gcp_config")

    @gcp_config.setter
    def gcp_config(self, value: Optional[pulumi.Input['ClusterGcpConfigArgs']]):
        pulumi.set(self, "gcp_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-), underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase characters, and numbers.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="rebalanceConfig")
    def rebalance_config(self) -> Optional[pulumi.Input['ClusterRebalanceConfigArgs']]:
        """
        Defines rebalancing behavior of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "rebalance_config")

    @rebalance_config.setter
    def rebalance_config(self, value: Optional[pulumi.Input['ClusterRebalanceConfigArgs']]):
        pulumi.set(self, "rebalance_config", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the cluster. Possible values: `STATE_UNSPECIFIED`, `CREATING`, `ACTIVE`, `DELETING`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['ClusterTlsConfigArgs']]:
        """
        TLS configuration for the Kafka cluster. This is used to configure mTLS authentication. To clear our a TLS configuration that has been previously set, please explicitly add an empty `tls_config` block.
        Structure is documented below.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['ClusterTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:managedkafka/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_config: Optional[pulumi.Input[Union['ClusterCapacityConfigArgs', 'ClusterCapacityConfigArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_config: Optional[pulumi.Input[Union['ClusterGcpConfigArgs', 'ClusterGcpConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rebalance_config: Optional[pulumi.Input[Union['ClusterRebalanceConfigArgs', 'ClusterRebalanceConfigArgsDict']]] = None,
                 tls_config: Optional[pulumi.Input[Union['ClusterTlsConfigArgs', 'ClusterTlsConfigArgsDict']]] = None,
                 __props__=None):
        """
        A Managed Service for Apache Kafka cluster. Apache Kafka is a trademark owned by the Apache Software Foundation.

        ## Example Usage

        ### Managedkafka Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example = gcp.managedkafka.Cluster("example",
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": f"projects/{project.number}/regions/us-central1/subnetworks/default",
                    }],
                },
            },
            rebalance_config={
                "mode": "AUTO_REBALANCE_ON_SCALE_UP",
            },
            labels={
                "key": "value",
            })
        ```
        ### Managedkafka Cluster Mtls

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ca_pool = gcp.certificateauthority.CaPool("ca_pool",
            name="my-ca-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            })
        project = gcp.organizations.get_project()
        example = gcp.managedkafka.Cluster("example",
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": f"projects/{project.number}/regions/us-central1/subnetworks/default",
                    }],
                },
            },
            tls_config={
                "trust_config": {
                    "cas_configs": [{
                        "ca_pool": ca_pool.id,
                    }],
                },
                "ssl_principal_mapping_rules": "RULE:pattern/replacement/L,DEFAULT",
            })
        ```
        ### Managedkafka Cluster Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example = gcp.managedkafka.Cluster("example",
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": f"projects/{project.number}/regions/us-central1/subnetworks/default",
                    }],
                },
                "kms_key": "example-key",
            })
        kafka_service_identity = gcp.projects.ServiceIdentity("kafka_service_identity",
            project=project.project_id,
            service="managedkafka.googleapis.com")
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}`

        * `{{project}}/{{location}}/{{cluster_id}}`

        * `{{location}}/{{cluster_id}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:managedkafka/cluster:Cluster default projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/cluster:Cluster default {{project}}/{{location}}/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/cluster:Cluster default {{location}}/{{cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterCapacityConfigArgs', 'ClusterCapacityConfigArgsDict']] capacity_config: A capacity configuration of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cluster_id: The ID to use for the cluster, which will become the final component of the cluster's name. The ID must be 1-63 characters long, and match the regular expression `a-z?` to comply with RFC 1035. This value is structured like: `my-cluster-id`.
        :param pulumi.Input[Union['ClusterGcpConfigArgs', 'ClusterGcpConfigArgsDict']] gcp_config: Configuration properties for a Kafka cluster deployed to Google Cloud Platform.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-), underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase characters, and numbers.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ClusterRebalanceConfigArgs', 'ClusterRebalanceConfigArgsDict']] rebalance_config: Defines rebalancing behavior of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterTlsConfigArgs', 'ClusterTlsConfigArgsDict']] tls_config: TLS configuration for the Kafka cluster. This is used to configure mTLS authentication. To clear our a TLS configuration that has been previously set, please explicitly add an empty `tls_config` block.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Managed Service for Apache Kafka cluster. Apache Kafka is a trademark owned by the Apache Software Foundation.

        ## Example Usage

        ### Managedkafka Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example = gcp.managedkafka.Cluster("example",
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": f"projects/{project.number}/regions/us-central1/subnetworks/default",
                    }],
                },
            },
            rebalance_config={
                "mode": "AUTO_REBALANCE_ON_SCALE_UP",
            },
            labels={
                "key": "value",
            })
        ```
        ### Managedkafka Cluster Mtls

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ca_pool = gcp.certificateauthority.CaPool("ca_pool",
            name="my-ca-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            })
        project = gcp.organizations.get_project()
        example = gcp.managedkafka.Cluster("example",
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": f"projects/{project.number}/regions/us-central1/subnetworks/default",
                    }],
                },
            },
            tls_config={
                "trust_config": {
                    "cas_configs": [{
                        "ca_pool": ca_pool.id,
                    }],
                },
                "ssl_principal_mapping_rules": "RULE:pattern/replacement/L,DEFAULT",
            })
        ```
        ### Managedkafka Cluster Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example = gcp.managedkafka.Cluster("example",
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": f"projects/{project.number}/regions/us-central1/subnetworks/default",
                    }],
                },
                "kms_key": "example-key",
            })
        kafka_service_identity = gcp.projects.ServiceIdentity("kafka_service_identity",
            project=project.project_id,
            service="managedkafka.googleapis.com")
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}`

        * `{{project}}/{{location}}/{{cluster_id}}`

        * `{{location}}/{{cluster_id}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:managedkafka/cluster:Cluster default projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/cluster:Cluster default {{project}}/{{location}}/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/cluster:Cluster default {{location}}/{{cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_config: Optional[pulumi.Input[Union['ClusterCapacityConfigArgs', 'ClusterCapacityConfigArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_config: Optional[pulumi.Input[Union['ClusterGcpConfigArgs', 'ClusterGcpConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rebalance_config: Optional[pulumi.Input[Union['ClusterRebalanceConfigArgs', 'ClusterRebalanceConfigArgsDict']]] = None,
                 tls_config: Optional[pulumi.Input[Union['ClusterTlsConfigArgs', 'ClusterTlsConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if capacity_config is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_config'")
            __props__.__dict__["capacity_config"] = capacity_config
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if gcp_config is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_config'")
            __props__.__dict__["gcp_config"] = gcp_config
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["rebalance_config"] = rebalance_config
            __props__.__dict__["tls_config"] = tls_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'gcp:managedkafka/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity_config: Optional[pulumi.Input[Union['ClusterCapacityConfigArgs', 'ClusterCapacityConfigArgsDict']]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gcp_config: Optional[pulumi.Input[Union['ClusterGcpConfigArgs', 'ClusterGcpConfigArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            rebalance_config: Optional[pulumi.Input[Union['ClusterRebalanceConfigArgs', 'ClusterRebalanceConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            tls_config: Optional[pulumi.Input[Union['ClusterTlsConfigArgs', 'ClusterTlsConfigArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterCapacityConfigArgs', 'ClusterCapacityConfigArgsDict']] capacity_config: A capacity configuration of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cluster_id: The ID to use for the cluster, which will become the final component of the cluster's name. The ID must be 1-63 characters long, and match the regular expression `a-z?` to comply with RFC 1035. This value is structured like: `my-cluster-id`.
        :param pulumi.Input[_builtins.str] create_time: The time when the cluster was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['ClusterGcpConfigArgs', 'ClusterGcpConfigArgsDict']] gcp_config: Configuration properties for a Kafka cluster deployed to Google Cloud Platform.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-), underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase characters, and numbers.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[_builtins.str] name: The name of the cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['ClusterRebalanceConfigArgs', 'ClusterRebalanceConfigArgsDict']] rebalance_config: Defines rebalancing behavior of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The current state of the cluster. Possible values: `STATE_UNSPECIFIED`, `CREATING`, `ACTIVE`, `DELETING`.
        :param pulumi.Input[Union['ClusterTlsConfigArgs', 'ClusterTlsConfigArgsDict']] tls_config: TLS configuration for the Kafka cluster. This is used to configure mTLS authentication. To clear our a TLS configuration that has been previously set, please explicitly add an empty `tls_config` block.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The time when the cluster was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["capacity_config"] = capacity_config
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["gcp_config"] = gcp_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["rebalance_config"] = rebalance_config
        __props__.__dict__["state"] = state
        __props__.__dict__["tls_config"] = tls_config
        __props__.__dict__["update_time"] = update_time
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="capacityConfig")
    def capacity_config(self) -> pulumi.Output['outputs.ClusterCapacityConfig']:
        """
        A capacity configuration of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "capacity_config")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the cluster, which will become the final component of the cluster's name. The ID must be 1-63 characters long, and match the regular expression `a-z?` to comply with RFC 1035. This value is structured like: `my-cluster-id`.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the cluster was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="gcpConfig")
    def gcp_config(self) -> pulumi.Output['outputs.ClusterGcpConfig']:
        """
        Configuration properties for a Kafka cluster deployed to Google Cloud Platform.
        Structure is documented below.
        """
        return pulumi.get(self, "gcp_config")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-), underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase characters, and numbers.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="rebalanceConfig")
    def rebalance_config(self) -> pulumi.Output[Optional['outputs.ClusterRebalanceConfig']]:
        """
        Defines rebalancing behavior of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "rebalance_config")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the cluster. Possible values: `STATE_UNSPECIFIED`, `CREATING`, `ACTIVE`, `DELETING`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> pulumi.Output['outputs.ClusterTlsConfig']:
        """
        TLS configuration for the Kafka cluster. This is used to configure mTLS authentication. To clear our a TLS configuration that has been previously set, please explicitly add an empty `tls_config` block.
        Structure is documented below.
        """
        return pulumi.get(self, "tls_config")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the cluster was last updated.
        """
        return pulumi.get(self, "update_time")

