# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AclAclEntry',
    'ClusterCapacityConfig',
    'ClusterGcpConfig',
    'ClusterGcpConfigAccessConfig',
    'ClusterGcpConfigAccessConfigNetworkConfig',
    'ClusterRebalanceConfig',
    'ClusterTlsConfig',
    'ClusterTlsConfigTrustConfig',
    'ClusterTlsConfigTrustConfigCasConfig',
    'ConnectClusterCapacityConfig',
    'ConnectClusterGcpConfig',
    'ConnectClusterGcpConfigAccessConfig',
    'ConnectClusterGcpConfigAccessConfigNetworkConfig',
    'ConnectorTaskRestartPolicy',
]

@pulumi.output_type
class AclAclEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionType":
            suggest = "permission_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclAclEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclAclEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclAclEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation: _builtins.str,
                 principal: _builtins.str,
                 host: Optional[_builtins.str] = None,
                 permission_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str operation: The operation type. Allowed values are (case insensitive): ALL, READ,
               WRITE, CREATE, DELETE, ALTER, DESCRIBE, CLUSTER_ACTION, DESCRIBE_CONFIGS,
               ALTER_CONFIGS, and IDEMPOTENT_WRITE. See https://kafka.apache.org/documentation/#operations_resources_and_protocols
               for valid combinations of resource_type and operation for different Kafka API requests.
        :param _builtins.str principal: The principal. Specified as Google Cloud account, with the Kafka StandardAuthorizer prefix User:". For example: "User:test-kafka-client@test-project.iam.gserviceaccount.com". Can be the wildcard "User:*" to refer to all users.
        :param _builtins.str host: The host. Must be set to "*" for Managed Service for Apache Kafka.
        :param _builtins.str permission_type: The permission type. Accepted values are (case insensitive): ALLOW, DENY.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "principal", principal)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if permission_type is not None:
            pulumi.set(__self__, "permission_type", permission_type)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        The operation type. Allowed values are (case insensitive): ALL, READ,
        WRITE, CREATE, DELETE, ALTER, DESCRIBE, CLUSTER_ACTION, DESCRIBE_CONFIGS,
        ALTER_CONFIGS, and IDEMPOTENT_WRITE. See https://kafka.apache.org/documentation/#operations_resources_and_protocols
        for valid combinations of resource_type and operation for different Kafka API requests.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> _builtins.str:
        """
        The principal. Specified as Google Cloud account, with the Kafka StandardAuthorizer prefix User:". For example: "User:test-kafka-client@test-project.iam.gserviceaccount.com". Can be the wildcard "User:*" to refer to all users.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The host. Must be set to "*" for Managed Service for Apache Kafka.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> Optional[_builtins.str]:
        """
        The permission type. Accepted values are (case insensitive): ALLOW, DENY.
        """
        return pulumi.get(self, "permission_type")


@pulumi.output_type
class ClusterCapacityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryBytes":
            suggest = "memory_bytes"
        elif key == "vcpuCount":
            suggest = "vcpu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCapacityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCapacityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCapacityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_bytes: _builtins.str,
                 vcpu_count: _builtins.str):
        """
        :param _builtins.str memory_bytes: The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.
        :param _builtins.str vcpu_count: The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        pulumi.set(__self__, "memory_bytes", memory_bytes)
        pulumi.set(__self__, "vcpu_count", vcpu_count)

    @_builtins.property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> _builtins.str:
        """
        The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.
        """
        return pulumi.get(self, "memory_bytes")

    @_builtins.property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> _builtins.str:
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        return pulumi.get(self, "vcpu_count")


@pulumi.output_type
class ClusterGcpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfig":
            suggest = "access_config"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterGcpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterGcpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterGcpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_config: 'outputs.ClusterGcpConfigAccessConfig',
                 kms_key: Optional[_builtins.str] = None):
        """
        :param 'ClusterGcpConfigAccessConfigArgs' access_config: The configuration of access to the Kafka cluster.
               Structure is documented below.
        :param _builtins.str kms_key: The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
        pulumi.set(__self__, "access_config", access_config)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> 'outputs.ClusterGcpConfigAccessConfig':
        """
        The configuration of access to the Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[_builtins.str]:
        """
        The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class ClusterGcpConfigAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkConfigs":
            suggest = "network_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterGcpConfigAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterGcpConfigAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterGcpConfigAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_configs: Sequence['outputs.ClusterGcpConfigAccessConfigNetworkConfig']):
        """
        :param Sequence['ClusterGcpConfigAccessConfigNetworkConfigArgs'] network_configs: Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one `network_configs` block. Max of 10 subnets per cluster. Additional subnets may be specified with additional `network_configs` blocks.
               Structure is documented below.
        """
        pulumi.set(__self__, "network_configs", network_configs)

    @_builtins.property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> Sequence['outputs.ClusterGcpConfigAccessConfigNetworkConfig']:
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one `network_configs` block. Max of 10 subnets per cluster. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")


@pulumi.output_type
class ClusterGcpConfigAccessConfigNetworkConfig(dict):
    def __init__(__self__, *,
                 subnet: _builtins.str):
        """
        :param _builtins.str subnet: Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. There can only be one subnet per network, and the subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
        pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. There can only be one subnet per network, and the subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ClusterRebalanceConfig(dict):
    def __init__(__self__, *,
                 mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str mode: The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class ClusterTlsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslPrincipalMappingRules":
            suggest = "ssl_principal_mapping_rules"
        elif key == "trustConfig":
            suggest = "trust_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTlsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTlsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTlsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssl_principal_mapping_rules: Optional[_builtins.str] = None,
                 trust_config: Optional['outputs.ClusterTlsConfigTrustConfig'] = None):
        """
        :param _builtins.str ssl_principal_mapping_rules: The rules for mapping mTLS certificate Distinguished Names (DNs) to shortened principal names for Kafka ACLs. This field corresponds exactly to the ssl.principal.mapping.rules broker config and matches the format and syntax defined in the Apache Kafka documentation. Setting or modifying this field will trigger a rolling restart of the Kafka brokers to apply the change. An empty string means that the default Kafka behavior is used. Example: `RULE:^CN=(.?),OU=ServiceUsers.$/$1@example.com/,DEFAULT`
        :param 'ClusterTlsConfigTrustConfigArgs' trust_config: The configuration of the broker truststore. If specified, clients can use mTLS for authentication.
               Structure is documented below.
        """
        if ssl_principal_mapping_rules is not None:
            pulumi.set(__self__, "ssl_principal_mapping_rules", ssl_principal_mapping_rules)
        if trust_config is not None:
            pulumi.set(__self__, "trust_config", trust_config)

    @_builtins.property
    @pulumi.getter(name="sslPrincipalMappingRules")
    def ssl_principal_mapping_rules(self) -> Optional[_builtins.str]:
        """
        The rules for mapping mTLS certificate Distinguished Names (DNs) to shortened principal names for Kafka ACLs. This field corresponds exactly to the ssl.principal.mapping.rules broker config and matches the format and syntax defined in the Apache Kafka documentation. Setting or modifying this field will trigger a rolling restart of the Kafka brokers to apply the change. An empty string means that the default Kafka behavior is used. Example: `RULE:^CN=(.?),OU=ServiceUsers.$/$1@example.com/,DEFAULT`
        """
        return pulumi.get(self, "ssl_principal_mapping_rules")

    @_builtins.property
    @pulumi.getter(name="trustConfig")
    def trust_config(self) -> Optional['outputs.ClusterTlsConfigTrustConfig']:
        """
        The configuration of the broker truststore. If specified, clients can use mTLS for authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "trust_config")


@pulumi.output_type
class ClusterTlsConfigTrustConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "casConfigs":
            suggest = "cas_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTlsConfigTrustConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTlsConfigTrustConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTlsConfigTrustConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cas_configs: Optional[Sequence['outputs.ClusterTlsConfigTrustConfigCasConfig']] = None):
        """
        :param Sequence['ClusterTlsConfigTrustConfigCasConfigArgs'] cas_configs: Configuration for the Google Certificate Authority Service. To support mTLS, you must specify at least one `cas_configs` block. A maximum of 10 CA pools can be specified. Additional CA pools may be specified with additional `cas_configs` blocks.
               Structure is documented below.
        """
        if cas_configs is not None:
            pulumi.set(__self__, "cas_configs", cas_configs)

    @_builtins.property
    @pulumi.getter(name="casConfigs")
    def cas_configs(self) -> Optional[Sequence['outputs.ClusterTlsConfigTrustConfigCasConfig']]:
        """
        Configuration for the Google Certificate Authority Service. To support mTLS, you must specify at least one `cas_configs` block. A maximum of 10 CA pools can be specified. Additional CA pools may be specified with additional `cas_configs` blocks.
        Structure is documented below.
        """
        return pulumi.get(self, "cas_configs")


@pulumi.output_type
class ClusterTlsConfigTrustConfigCasConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caPool":
            suggest = "ca_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTlsConfigTrustConfigCasConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTlsConfigTrustConfigCasConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTlsConfigTrustConfigCasConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_pool: _builtins.str):
        """
        :param _builtins.str ca_pool: The name of the CA pool to pull CA certificates from. The CA pool does not need to be in the same project or location as the Kafka cluster. Must be in the format `projects/PROJECT_ID/locations/LOCATION/caPools/CA_POOL_ID.
        """
        pulumi.set(__self__, "ca_pool", ca_pool)

    @_builtins.property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> _builtins.str:
        """
        The name of the CA pool to pull CA certificates from. The CA pool does not need to be in the same project or location as the Kafka cluster. Must be in the format `projects/PROJECT_ID/locations/LOCATION/caPools/CA_POOL_ID.
        """
        return pulumi.get(self, "ca_pool")


@pulumi.output_type
class ConnectClusterCapacityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryBytes":
            suggest = "memory_bytes"
        elif key == "vcpuCount":
            suggest = "vcpu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectClusterCapacityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectClusterCapacityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectClusterCapacityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_bytes: _builtins.str,
                 vcpu_count: _builtins.str):
        """
        :param _builtins.str memory_bytes: The memory to provision for the cluster in bytes. The CPU:memory ratio (vCPU:GiB) must be between 1:1 and 1:8. Minimum: 3221225472 (3 GiB).
        :param _builtins.str vcpu_count: The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        pulumi.set(__self__, "memory_bytes", memory_bytes)
        pulumi.set(__self__, "vcpu_count", vcpu_count)

    @_builtins.property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> _builtins.str:
        """
        The memory to provision for the cluster in bytes. The CPU:memory ratio (vCPU:GiB) must be between 1:1 and 1:8. Minimum: 3221225472 (3 GiB).
        """
        return pulumi.get(self, "memory_bytes")

    @_builtins.property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> _builtins.str:
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        return pulumi.get(self, "vcpu_count")


@pulumi.output_type
class ConnectClusterGcpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfig":
            suggest = "access_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectClusterGcpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectClusterGcpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectClusterGcpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_config: 'outputs.ConnectClusterGcpConfigAccessConfig'):
        """
        :param 'ConnectClusterGcpConfigAccessConfigArgs' access_config: The configuration of access to the Kafka Connect cluster.
               Structure is documented below.
        """
        pulumi.set(__self__, "access_config", access_config)

    @_builtins.property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> 'outputs.ConnectClusterGcpConfigAccessConfig':
        """
        The configuration of access to the Kafka Connect cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")


@pulumi.output_type
class ConnectClusterGcpConfigAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkConfigs":
            suggest = "network_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectClusterGcpConfigAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectClusterGcpConfigAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectClusterGcpConfigAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_configs: Sequence['outputs.ConnectClusterGcpConfigAccessConfigNetworkConfig']):
        """
        :param Sequence['ConnectClusterGcpConfigAccessConfigNetworkConfigArgs'] network_configs: Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka Connect cluster are allocated. To make the connect cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
               Structure is documented below.
        """
        pulumi.set(__self__, "network_configs", network_configs)

    @_builtins.property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> Sequence['outputs.ConnectClusterGcpConfigAccessConfigNetworkConfig']:
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka Connect cluster are allocated. To make the connect cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")


@pulumi.output_type
class ConnectClusterGcpConfigAccessConfigNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primarySubnet":
            suggest = "primary_subnet"
        elif key == "additionalSubnets":
            suggest = "additional_subnets"
        elif key == "dnsDomainNames":
            suggest = "dns_domain_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectClusterGcpConfigAccessConfigNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectClusterGcpConfigAccessConfigNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectClusterGcpConfigAccessConfigNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_subnet: _builtins.str,
                 additional_subnets: Optional[Sequence[_builtins.str]] = None,
                 dns_domain_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str primary_subnet: VPC subnet to make available to the Kafka Connect cluster. Structured like: projects/{project}/regions/{region}/subnetworks/{subnet_id}. It is used to create a Private Service Connect (PSC) interface for the Kafka Connect workers. It must be located in the same region as the Kafka Connect cluster. The CIDR range of the subnet must be within the IPv4 address ranges for private networks, as specified in RFC 1918. The primary subnet CIDR range must have a minimum size of /22 (1024 addresses).
        :param Sequence[_builtins.str] additional_subnets: Additional subnets may be specified. They may be in another region, but must be in the same VPC network. The Connect workers can communicate with network endpoints in either the primary or additional subnets.
        :param Sequence[_builtins.str] dns_domain_names: Additional DNS domain names from the subnet's network to be made visible to the Connect Cluster. When using MirrorMaker2, it's necessary to add the bootstrap address's dns domain name of the target cluster to make it visible to the connector. For example: my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
        """
        pulumi.set(__self__, "primary_subnet", primary_subnet)
        if additional_subnets is not None:
            pulumi.set(__self__, "additional_subnets", additional_subnets)
        if dns_domain_names is not None:
            pulumi.set(__self__, "dns_domain_names", dns_domain_names)

    @_builtins.property
    @pulumi.getter(name="primarySubnet")
    def primary_subnet(self) -> _builtins.str:
        """
        VPC subnet to make available to the Kafka Connect cluster. Structured like: projects/{project}/regions/{region}/subnetworks/{subnet_id}. It is used to create a Private Service Connect (PSC) interface for the Kafka Connect workers. It must be located in the same region as the Kafka Connect cluster. The CIDR range of the subnet must be within the IPv4 address ranges for private networks, as specified in RFC 1918. The primary subnet CIDR range must have a minimum size of /22 (1024 addresses).
        """
        return pulumi.get(self, "primary_subnet")

    @_builtins.property
    @pulumi.getter(name="additionalSubnets")
    def additional_subnets(self) -> Optional[Sequence[_builtins.str]]:
        """
        Additional subnets may be specified. They may be in another region, but must be in the same VPC network. The Connect workers can communicate with network endpoints in either the primary or additional subnets.
        """
        return pulumi.get(self, "additional_subnets")

    @_builtins.property
    @pulumi.getter(name="dnsDomainNames")
    def dns_domain_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Additional DNS domain names from the subnet's network to be made visible to the Connect Cluster. When using MirrorMaker2, it's necessary to add the bootstrap address's dns domain name of the target cluster to make it visible to the connector. For example: my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
        """
        return pulumi.get(self, "dns_domain_names")


@pulumi.output_type
class ConnectorTaskRestartPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumBackoff":
            suggest = "maximum_backoff"
        elif key == "minimumBackoff":
            suggest = "minimum_backoff"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorTaskRestartPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorTaskRestartPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorTaskRestartPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_backoff: Optional[_builtins.str] = None,
                 minimum_backoff: Optional[_builtins.str] = None):
        """
        :param _builtins.str maximum_backoff: The maximum amount of time to wait before retrying a failed task. This sets an upper bound for the backoff delay.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param _builtins.str minimum_backoff: The minimum amount of time to wait before retrying a failed task. This sets a lower bound for the backoff delay.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if maximum_backoff is not None:
            pulumi.set(__self__, "maximum_backoff", maximum_backoff)
        if minimum_backoff is not None:
            pulumi.set(__self__, "minimum_backoff", minimum_backoff)

    @_builtins.property
    @pulumi.getter(name="maximumBackoff")
    def maximum_backoff(self) -> Optional[_builtins.str]:
        """
        The maximum amount of time to wait before retrying a failed task. This sets an upper bound for the backoff delay.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "maximum_backoff")

    @_builtins.property
    @pulumi.getter(name="minimumBackoff")
    def minimum_backoff(self) -> Optional[_builtins.str]:
        """
        The minimum amount of time to wait before retrying a failed task. This sets a lower bound for the backoff delay.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "minimum_backoff")


