# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 shard_count: pulumi.Input[_builtins.int],
                 authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 automated_backup_config: Optional[pulumi.Input['InstanceAutomatedBackupConfigArgs']] = None,
                 cross_instance_replication_config: Optional[pulumi.Input['InstanceCrossInstanceReplicationConfigArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_auto_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredAutoCreatedEndpointArgs']]]] = None,
                 desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]] = None,
                 engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gcs_source: Optional[pulumi.Input['InstanceGcsSourceArgs']] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_backup_source: Optional[pulumi.Input['InstanceManagedBackupSourceArgs']] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input['InstancePersistenceConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_distribution_config: Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] instance_id: Required. The ID to use for the instance, which will become the final component of
               the instance's resource name.
               This value is subject to the following restrictions:
               * Must be 4-63 characters in length
               * Must begin with a letter or digit
               * Must contain only lowercase letters, digits, and hyphens
               * Must not end with a hyphen
               * Must be unique within a location
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        :param pulumi.Input[_builtins.int] shard_count: Required. Number of shards for the instance.
        :param pulumi.Input[_builtins.str] authorization_mode: Optional. Immutable. Authorization mode of the instance. Possible values:
               AUTH_DISABLED
               IAM_AUTH
        :param pulumi.Input['InstanceAutomatedBackupConfigArgs'] automated_backup_config: The automated backup config for a instance.
               Structure is documented below.
        :param pulumi.Input['InstanceCrossInstanceReplicationConfigArgs'] cross_instance_replication_config: Cross instance replication config
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Optional. If set to true deletion of the instance will fail.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDesiredAutoCreatedEndpointArgs']]] desired_auto_created_endpoints: Immutable. User inputs for the auto-created endpoints connections.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]] desired_psc_auto_connections: `desired_psc_auto_connections` is deprecated  Use `desired_auto_created_endpoints` instead `pulumi import` will only work with desired_auto_created_endpoints`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] engine_configs: Optional. User-provided engine configurations for the instance.
        :param pulumi.Input[_builtins.str] engine_version: Optional. Engine version of the instance.
        :param pulumi.Input['InstanceGcsSourceArgs'] gcs_source: GCS source for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kms_key: The KMS key used to encrypt the at-rest data of the cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['InstanceMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for a cluster
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
               *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        :param pulumi.Input['InstanceManagedBackupSourceArgs'] managed_backup_source: Managed backup source for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mode: Optional. cluster or cluster-disabled.
               Possible values:
               CLUSTER
               CLUSTER_DISABLED
               Possible values are: `CLUSTER`, `CLUSTER_DISABLED`.
        :param pulumi.Input[_builtins.str] node_type: Optional. Machine type for individual nodes of the instance.
               Possible values:
               SHARED_CORE_NANO
               HIGHMEM_MEDIUM
               HIGHMEM_XLARGE
               STANDARD_SMALL
        :param pulumi.Input['InstancePersistenceConfigArgs'] persistence_config: Represents persistence configuration for a instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.int] replica_count: Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: Optional. Immutable. In-transit encryption mode of the instance.
               Possible values:
               TRANSIT_ENCRYPTION_DISABLED
               SERVER_AUTHENTICATION
        :param pulumi.Input['InstanceZoneDistributionConfigArgs'] zone_distribution_config: Zone distribution configuration for allocation of instance resources.
               Structure is documented below.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "shard_count", shard_count)
        if authorization_mode is not None:
            pulumi.set(__self__, "authorization_mode", authorization_mode)
        if automated_backup_config is not None:
            pulumi.set(__self__, "automated_backup_config", automated_backup_config)
        if cross_instance_replication_config is not None:
            pulumi.set(__self__, "cross_instance_replication_config", cross_instance_replication_config)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if desired_auto_created_endpoints is not None:
            pulumi.set(__self__, "desired_auto_created_endpoints", desired_auto_created_endpoints)
        if desired_psc_auto_connections is not None:
            warnings.warn("""`desired_psc_auto_connections` is deprecated. Use `desired_auto_created_endpoints` instead. `terraform import` will only work with desired_auto_created_endpoints`.""", DeprecationWarning)
            pulumi.log.warn("""desired_psc_auto_connections is deprecated: `desired_psc_auto_connections` is deprecated. Use `desired_auto_created_endpoints` instead. `terraform import` will only work with desired_auto_created_endpoints`.""")
        if desired_psc_auto_connections is not None:
            pulumi.set(__self__, "desired_psc_auto_connections", desired_psc_auto_connections)
        if engine_configs is not None:
            pulumi.set(__self__, "engine_configs", engine_configs)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if gcs_source is not None:
            pulumi.set(__self__, "gcs_source", gcs_source)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if managed_backup_source is not None:
            pulumi.set(__self__, "managed_backup_source", managed_backup_source)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if persistence_config is not None:
            pulumi.set(__self__, "persistence_config", persistence_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if zone_distribution_config is not None:
            pulumi.set(__self__, "zone_distribution_config", zone_distribution_config)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The ID to use for the instance, which will become the final component of
        the instance's resource name.
        This value is subject to the following restrictions:
        * Must be 4-63 characters in length
        * Must begin with a letter or digit
        * Must contain only lowercase letters, digits, and hyphens
        * Must not end with a hyphen
        * Must be unique within a location
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Input[_builtins.int]:
        """
        Required. Number of shards for the instance.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Immutable. Authorization mode of the instance. Possible values:
        AUTH_DISABLED
        IAM_AUTH
        """
        return pulumi.get(self, "authorization_mode")

    @authorization_mode.setter
    def authorization_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_mode", value)

    @_builtins.property
    @pulumi.getter(name="automatedBackupConfig")
    def automated_backup_config(self) -> Optional[pulumi.Input['InstanceAutomatedBackupConfigArgs']]:
        """
        The automated backup config for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_config")

    @automated_backup_config.setter
    def automated_backup_config(self, value: Optional[pulumi.Input['InstanceAutomatedBackupConfigArgs']]):
        pulumi.set(self, "automated_backup_config", value)

    @_builtins.property
    @pulumi.getter(name="crossInstanceReplicationConfig")
    def cross_instance_replication_config(self) -> Optional[pulumi.Input['InstanceCrossInstanceReplicationConfigArgs']]:
        """
        Cross instance replication config
        Structure is documented below.
        """
        return pulumi.get(self, "cross_instance_replication_config")

    @cross_instance_replication_config.setter
    def cross_instance_replication_config(self, value: Optional[pulumi.Input['InstanceCrossInstanceReplicationConfigArgs']]):
        pulumi.set(self, "cross_instance_replication_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. If set to true deletion of the instance will fail.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="desiredAutoCreatedEndpoints")
    def desired_auto_created_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredAutoCreatedEndpointArgs']]]]:
        """
        Immutable. User inputs for the auto-created endpoints connections.
        """
        return pulumi.get(self, "desired_auto_created_endpoints")

    @desired_auto_created_endpoints.setter
    def desired_auto_created_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredAutoCreatedEndpointArgs']]]]):
        pulumi.set(self, "desired_auto_created_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="desiredPscAutoConnections")
    @_utilities.deprecated("""`desired_psc_auto_connections` is deprecated. Use `desired_auto_created_endpoints` instead. `terraform import` will only work with desired_auto_created_endpoints`.""")
    def desired_psc_auto_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]]:
        """
        `desired_psc_auto_connections` is deprecated  Use `desired_auto_created_endpoints` instead `pulumi import` will only work with desired_auto_created_endpoints`.
        """
        return pulumi.get(self, "desired_psc_auto_connections")

    @desired_psc_auto_connections.setter
    def desired_psc_auto_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]]):
        pulumi.set(self, "desired_psc_auto_connections", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigs")
    def engine_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User-provided engine configurations for the instance.
        """
        return pulumi.get(self, "engine_configs")

    @engine_configs.setter
    def engine_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "engine_configs", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Engine version of the instance.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> Optional[pulumi.Input['InstanceGcsSourceArgs']]:
        """
        GCS source for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_source")

    @gcs_source.setter
    def gcs_source(self, value: Optional[pulumi.Input['InstanceGcsSourceArgs']]):
        pulumi.set(self, "gcs_source", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key used to encrypt the at-rest data of the cluster
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]:
        """
        Maintenance policy for a cluster
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
        *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_version", value)

    @_builtins.property
    @pulumi.getter(name="managedBackupSource")
    def managed_backup_source(self) -> Optional[pulumi.Input['InstanceManagedBackupSourceArgs']]:
        """
        Managed backup source for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "managed_backup_source")

    @managed_backup_source.setter
    def managed_backup_source(self, value: Optional[pulumi.Input['InstanceManagedBackupSourceArgs']]):
        pulumi.set(self, "managed_backup_source", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. cluster or cluster-disabled.
        Possible values:
        CLUSTER
        CLUSTER_DISABLED
        Possible values are: `CLUSTER`, `CLUSTER_DISABLED`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Machine type for individual nodes of the instance.
        Possible values:
        SHARED_CORE_NANO
        HIGHMEM_MEDIUM
        HIGHMEM_XLARGE
        STANDARD_SMALL
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> Optional[pulumi.Input['InstancePersistenceConfigArgs']]:
        """
        Represents persistence configuration for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @persistence_config.setter
    def persistence_config(self, value: Optional[pulumi.Input['InstancePersistenceConfigArgs']]):
        pulumi.set(self, "persistence_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Immutable. In-transit encryption mode of the instance.
        Possible values:
        TRANSIT_ENCRYPTION_DISABLED
        SERVER_AUTHENTICATION
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @_builtins.property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']]:
        """
        Zone distribution configuration for allocation of instance resources.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

    @zone_distribution_config.setter
    def zone_distribution_config(self, value: Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']]):
        pulumi.set(self, "zone_distribution_config", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 automated_backup_config: Optional[pulumi.Input['InstanceAutomatedBackupConfigArgs']] = None,
                 available_maintenance_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_collection: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_instance_replication_config: Optional[pulumi.Input['InstanceCrossInstanceReplicationConfigArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_auto_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredAutoCreatedEndpointArgs']]]] = None,
                 desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]] = None,
                 discovery_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiscoveryEndpointArgs']]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]] = None,
                 engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gcs_source: Optional[pulumi.Input['InstanceGcsSourceArgs']] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']] = None,
                 maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_backup_source: Optional[pulumi.Input['InstanceManagedBackupSourceArgs']] = None,
                 managed_server_cas: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceManagedServerCaArgs']]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeConfigArgs']]]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input['InstancePersistenceConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_attachment_details: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAttachmentDetailArgs']]]] = None,
                 psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAutoConnectionArgs']]]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoArgs']]]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_distribution_config: Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] authorization_mode: Optional. Immutable. Authorization mode of the instance. Possible values:
               AUTH_DISABLED
               IAM_AUTH
        :param pulumi.Input['InstanceAutomatedBackupConfigArgs'] automated_backup_config: The automated backup config for a instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_maintenance_versions: This field is used to determine the available maintenance versions for the self service update.
        :param pulumi.Input[_builtins.str] backup_collection: The backup collection full resource name.
               Example: projects/{project}/locations/{location}/backupCollections/{collection}
        :param pulumi.Input[_builtins.str] create_time: Output only. Creation timestamp of the instance.
        :param pulumi.Input['InstanceCrossInstanceReplicationConfigArgs'] cross_instance_replication_config: Cross instance replication config
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Optional. If set to true deletion of the instance will fail.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDesiredAutoCreatedEndpointArgs']]] desired_auto_created_endpoints: Immutable. User inputs for the auto-created endpoints connections.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]] desired_psc_auto_connections: `desired_psc_auto_connections` is deprecated  Use `desired_auto_created_endpoints` instead `pulumi import` will only work with desired_auto_created_endpoints`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDiscoveryEndpointArgs']]] discovery_endpoints: (Deprecated)
               Deprecated. Output only. Endpoints clients can connect to the instance through.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] effective_maintenance_version: This field represents the actual maintenance version of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]] endpoints: Endpoints for the instance.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] engine_configs: Optional. User-provided engine configurations for the instance.
        :param pulumi.Input[_builtins.str] engine_version: Optional. Engine version of the instance.
        :param pulumi.Input['InstanceGcsSourceArgs'] gcs_source: GCS source for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: Required. The ID to use for the instance, which will become the final component of
               the instance's resource name.
               This value is subject to the following restrictions:
               * Must be 4-63 characters in length
               * Must begin with a letter or digit
               * Must contain only lowercase letters, digits, and hyphens
               * Must not end with a hyphen
               * Must be unique within a location
        :param pulumi.Input[_builtins.str] kms_key: The KMS key used to encrypt the at-rest data of the cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        :param pulumi.Input['InstanceMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for a cluster
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]] maintenance_schedules: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
               *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        :param pulumi.Input['InstanceManagedBackupSourceArgs'] managed_backup_source: Managed backup source for the instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceManagedServerCaArgs']]] managed_server_cas: Instance's Certificate Authority. This field will only be populated if instance's transit_encryption_mode is SERVER_AUTHENTICATION
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mode: Optional. cluster or cluster-disabled.
               Possible values:
               CLUSTER
               CLUSTER_DISABLED
               Possible values are: `CLUSTER`, `CLUSTER_DISABLED`.
        :param pulumi.Input[_builtins.str] name: Identifier. Unique name of the instance.
               Format: projects/{project}/locations/{location}/instances/{instance}
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeConfigArgs']]] node_configs: Represents configuration for nodes of the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] node_type: Optional. Machine type for individual nodes of the instance.
               Possible values:
               SHARED_CORE_NANO
               HIGHMEM_MEDIUM
               HIGHMEM_XLARGE
               STANDARD_SMALL
        :param pulumi.Input['InstancePersistenceConfigArgs'] persistence_config: Represents persistence configuration for a instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePscAttachmentDetailArgs']]] psc_attachment_details: Configuration of a service attachment of the cluster, for creating PSC connections.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePscAutoConnectionArgs']]] psc_auto_connections: (Deprecated)
               Output only. User inputs and resource details of the auto-created PSC connections.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.int] replica_count: Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        :param pulumi.Input[_builtins.int] shard_count: Required. Number of shards for the instance.
        :param pulumi.Input[_builtins.str] state: Output only. Current state of the instance.
               Possible values:
               CREATING
               ACTIVE
               UPDATING
               DELETING
        :param pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoArgs']]] state_infos: Additional information about the state of the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: Optional. Immutable. In-transit encryption mode of the instance.
               Possible values:
               TRANSIT_ENCRYPTION_DISABLED
               SERVER_AUTHENTICATION
        :param pulumi.Input[_builtins.str] uid: Output only. System assigned, unique identifier for the instance.
        :param pulumi.Input[_builtins.str] update_time: Output only. Latest update timestamp of the instance.
        :param pulumi.Input['InstanceZoneDistributionConfigArgs'] zone_distribution_config: Zone distribution configuration for allocation of instance resources.
               Structure is documented below.
        """
        if authorization_mode is not None:
            pulumi.set(__self__, "authorization_mode", authorization_mode)
        if automated_backup_config is not None:
            pulumi.set(__self__, "automated_backup_config", automated_backup_config)
        if available_maintenance_versions is not None:
            pulumi.set(__self__, "available_maintenance_versions", available_maintenance_versions)
        if backup_collection is not None:
            pulumi.set(__self__, "backup_collection", backup_collection)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_instance_replication_config is not None:
            pulumi.set(__self__, "cross_instance_replication_config", cross_instance_replication_config)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if desired_auto_created_endpoints is not None:
            pulumi.set(__self__, "desired_auto_created_endpoints", desired_auto_created_endpoints)
        if desired_psc_auto_connections is not None:
            warnings.warn("""`desired_psc_auto_connections` is deprecated. Use `desired_auto_created_endpoints` instead. `terraform import` will only work with desired_auto_created_endpoints`.""", DeprecationWarning)
            pulumi.log.warn("""desired_psc_auto_connections is deprecated: `desired_psc_auto_connections` is deprecated. Use `desired_auto_created_endpoints` instead. `terraform import` will only work with desired_auto_created_endpoints`.""")
        if desired_psc_auto_connections is not None:
            pulumi.set(__self__, "desired_psc_auto_connections", desired_psc_auto_connections)
        if discovery_endpoints is not None:
            warnings.warn("""This field is deprecated. As a result it will not be populated if the connections are created using `desired_auto_created_endpoints` parameter or `memorystore.InstanceDesiredUserCreatedEndpoints` resource. Instead of this parameter, for discovery, use `endpoints.connections.pscConnection` and `endpoints.connections.pscAutoConnection` with `connectionType` CONNECTION_TYPE_DISCOVERY.""", DeprecationWarning)
            pulumi.log.warn("""discovery_endpoints is deprecated: This field is deprecated. As a result it will not be populated if the connections are created using `desired_auto_created_endpoints` parameter or `memorystore.InstanceDesiredUserCreatedEndpoints` resource. Instead of this parameter, for discovery, use `endpoints.connections.pscConnection` and `endpoints.connections.pscAutoConnection` with `connectionType` CONNECTION_TYPE_DISCOVERY.""")
        if discovery_endpoints is not None:
            pulumi.set(__self__, "discovery_endpoints", discovery_endpoints)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if effective_maintenance_version is not None:
            pulumi.set(__self__, "effective_maintenance_version", effective_maintenance_version)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if engine_configs is not None:
            pulumi.set(__self__, "engine_configs", engine_configs)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if gcs_source is not None:
            pulumi.set(__self__, "gcs_source", gcs_source)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if managed_backup_source is not None:
            pulumi.set(__self__, "managed_backup_source", managed_backup_source)
        if managed_server_cas is not None:
            pulumi.set(__self__, "managed_server_cas", managed_server_cas)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_configs is not None:
            pulumi.set(__self__, "node_configs", node_configs)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if persistence_config is not None:
            pulumi.set(__self__, "persistence_config", persistence_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_attachment_details is not None:
            pulumi.set(__self__, "psc_attachment_details", psc_attachment_details)
        if psc_auto_connections is not None:
            warnings.warn("""`psc_auto_connections` is deprecated  Use `endpoints.connections.pscAutoConnections` instead.""", DeprecationWarning)
            pulumi.log.warn("""psc_auto_connections is deprecated: `psc_auto_connections` is deprecated  Use `endpoints.connections.pscAutoConnections` instead.""")
        if psc_auto_connections is not None:
            pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_infos is not None:
            pulumi.set(__self__, "state_infos", state_infos)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if zone_distribution_config is not None:
            pulumi.set(__self__, "zone_distribution_config", zone_distribution_config)

    @_builtins.property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Immutable. Authorization mode of the instance. Possible values:
        AUTH_DISABLED
        IAM_AUTH
        """
        return pulumi.get(self, "authorization_mode")

    @authorization_mode.setter
    def authorization_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_mode", value)

    @_builtins.property
    @pulumi.getter(name="automatedBackupConfig")
    def automated_backup_config(self) -> Optional[pulumi.Input['InstanceAutomatedBackupConfigArgs']]:
        """
        The automated backup config for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_config")

    @automated_backup_config.setter
    def automated_backup_config(self, value: Optional[pulumi.Input['InstanceAutomatedBackupConfigArgs']]):
        pulumi.set(self, "automated_backup_config", value)

    @_builtins.property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        This field is used to determine the available maintenance versions for the self service update.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @available_maintenance_versions.setter
    def available_maintenance_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_maintenance_versions", value)

    @_builtins.property
    @pulumi.getter(name="backupCollection")
    def backup_collection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup collection full resource name.
        Example: projects/{project}/locations/{location}/backupCollections/{collection}
        """
        return pulumi.get(self, "backup_collection")

    @backup_collection.setter
    def backup_collection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_collection", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Creation timestamp of the instance.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossInstanceReplicationConfig")
    def cross_instance_replication_config(self) -> Optional[pulumi.Input['InstanceCrossInstanceReplicationConfigArgs']]:
        """
        Cross instance replication config
        Structure is documented below.
        """
        return pulumi.get(self, "cross_instance_replication_config")

    @cross_instance_replication_config.setter
    def cross_instance_replication_config(self, value: Optional[pulumi.Input['InstanceCrossInstanceReplicationConfigArgs']]):
        pulumi.set(self, "cross_instance_replication_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. If set to true deletion of the instance will fail.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="desiredAutoCreatedEndpoints")
    def desired_auto_created_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredAutoCreatedEndpointArgs']]]]:
        """
        Immutable. User inputs for the auto-created endpoints connections.
        """
        return pulumi.get(self, "desired_auto_created_endpoints")

    @desired_auto_created_endpoints.setter
    def desired_auto_created_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredAutoCreatedEndpointArgs']]]]):
        pulumi.set(self, "desired_auto_created_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="desiredPscAutoConnections")
    @_utilities.deprecated("""`desired_psc_auto_connections` is deprecated. Use `desired_auto_created_endpoints` instead. `terraform import` will only work with desired_auto_created_endpoints`.""")
    def desired_psc_auto_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]]:
        """
        `desired_psc_auto_connections` is deprecated  Use `desired_auto_created_endpoints` instead `pulumi import` will only work with desired_auto_created_endpoints`.
        """
        return pulumi.get(self, "desired_psc_auto_connections")

    @desired_psc_auto_connections.setter
    def desired_psc_auto_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]]):
        pulumi.set(self, "desired_psc_auto_connections", value)

    @_builtins.property
    @pulumi.getter(name="discoveryEndpoints")
    @_utilities.deprecated("""This field is deprecated. As a result it will not be populated if the connections are created using `desired_auto_created_endpoints` parameter or `memorystore.InstanceDesiredUserCreatedEndpoints` resource. Instead of this parameter, for discovery, use `endpoints.connections.pscConnection` and `endpoints.connections.pscAutoConnection` with `connectionType` CONNECTION_TYPE_DISCOVERY.""")
    def discovery_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiscoveryEndpointArgs']]]]:
        """
        (Deprecated)
        Deprecated. Output only. Endpoints clients can connect to the instance through.
        Structure is documented below.
        """
        return pulumi.get(self, "discovery_endpoints")

    @discovery_endpoints.setter
    def discovery_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiscoveryEndpointArgs']]]]):
        pulumi.set(self, "discovery_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="effectiveMaintenanceVersion")
    def effective_maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field represents the actual maintenance version of the cluster.
        """
        return pulumi.get(self, "effective_maintenance_version")

    @effective_maintenance_version.setter
    def effective_maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_maintenance_version", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]:
        """
        Endpoints for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigs")
    def engine_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User-provided engine configurations for the instance.
        """
        return pulumi.get(self, "engine_configs")

    @engine_configs.setter
    def engine_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "engine_configs", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Engine version of the instance.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> Optional[pulumi.Input['InstanceGcsSourceArgs']]:
        """
        GCS source for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_source")

    @gcs_source.setter
    def gcs_source(self, value: Optional[pulumi.Input['InstanceGcsSourceArgs']]):
        pulumi.set(self, "gcs_source", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The ID to use for the instance, which will become the final component of
        the instance's resource name.
        This value is subject to the following restrictions:
        * Must be 4-63 characters in length
        * Must begin with a letter or digit
        * Must contain only lowercase letters, digits, and hyphens
        * Must not end with a hyphen
        * Must be unique within a location
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key used to encrypt the at-rest data of the cluster
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]:
        """
        Maintenance policy for a cluster
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @maintenance_schedules.setter
    def maintenance_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]]):
        pulumi.set(self, "maintenance_schedules", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
        *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_version", value)

    @_builtins.property
    @pulumi.getter(name="managedBackupSource")
    def managed_backup_source(self) -> Optional[pulumi.Input['InstanceManagedBackupSourceArgs']]:
        """
        Managed backup source for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "managed_backup_source")

    @managed_backup_source.setter
    def managed_backup_source(self, value: Optional[pulumi.Input['InstanceManagedBackupSourceArgs']]):
        pulumi.set(self, "managed_backup_source", value)

    @_builtins.property
    @pulumi.getter(name="managedServerCas")
    def managed_server_cas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceManagedServerCaArgs']]]]:
        """
        Instance's Certificate Authority. This field will only be populated if instance's transit_encryption_mode is SERVER_AUTHENTICATION
        Structure is documented below.
        """
        return pulumi.get(self, "managed_server_cas")

    @managed_server_cas.setter
    def managed_server_cas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceManagedServerCaArgs']]]]):
        pulumi.set(self, "managed_server_cas", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. cluster or cluster-disabled.
        Possible values:
        CLUSTER
        CLUSTER_DISABLED
        Possible values are: `CLUSTER`, `CLUSTER_DISABLED`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Unique name of the instance.
        Format: projects/{project}/locations/{location}/instances/{instance}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeConfigArgs']]]]:
        """
        Represents configuration for nodes of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "node_configs")

    @node_configs.setter
    def node_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeConfigArgs']]]]):
        pulumi.set(self, "node_configs", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Machine type for individual nodes of the instance.
        Possible values:
        SHARED_CORE_NANO
        HIGHMEM_MEDIUM
        HIGHMEM_XLARGE
        STANDARD_SMALL
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> Optional[pulumi.Input['InstancePersistenceConfigArgs']]:
        """
        Represents persistence configuration for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @persistence_config.setter
    def persistence_config(self, value: Optional[pulumi.Input['InstancePersistenceConfigArgs']]):
        pulumi.set(self, "persistence_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pscAttachmentDetails")
    def psc_attachment_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAttachmentDetailArgs']]]]:
        """
        Configuration of a service attachment of the cluster, for creating PSC connections.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_attachment_details")

    @psc_attachment_details.setter
    def psc_attachment_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAttachmentDetailArgs']]]]):
        pulumi.set(self, "psc_attachment_details", value)

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    @_utilities.deprecated("""`psc_auto_connections` is deprecated  Use `endpoints.connections.pscAutoConnections` instead.""")
    def psc_auto_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAutoConnectionArgs']]]]:
        """
        (Deprecated)
        Output only. User inputs and resource details of the auto-created PSC connections.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_auto_connections")

    @psc_auto_connections.setter
    def psc_auto_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAutoConnectionArgs']]]]):
        pulumi.set(self, "psc_auto_connections", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Required. Number of shards for the instance.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Current state of the instance.
        Possible values:
        CREATING
        ACTIVE
        UPDATING
        DELETING
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateInfos")
    def state_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoArgs']]]]:
        """
        Additional information about the state of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "state_infos")

    @state_infos.setter
    def state_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoArgs']]]]):
        pulumi.set(self, "state_infos", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Immutable. In-transit encryption mode of the instance.
        Possible values:
        TRANSIT_ENCRYPTION_DISABLED
        SERVER_AUTHENTICATION
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. System assigned, unique identifier for the instance.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Latest update timestamp of the instance.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']]:
        """
        Zone distribution configuration for allocation of instance resources.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

    @zone_distribution_config.setter
    def zone_distribution_config(self, value: Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']]):
        pulumi.set(self, "zone_distribution_config", value)


@pulumi.type_token("gcp:memorystore/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 automated_backup_config: Optional[pulumi.Input[Union['InstanceAutomatedBackupConfigArgs', 'InstanceAutomatedBackupConfigArgsDict']]] = None,
                 cross_instance_replication_config: Optional[pulumi.Input[Union['InstanceCrossInstanceReplicationConfigArgs', 'InstanceCrossInstanceReplicationConfigArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_auto_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredAutoCreatedEndpointArgs', 'InstanceDesiredAutoCreatedEndpointArgsDict']]]]] = None,
                 desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]]] = None,
                 engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gcs_source: Optional[pulumi.Input[Union['InstanceGcsSourceArgs', 'InstanceGcsSourceArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_backup_source: Optional[pulumi.Input[Union['InstanceManagedBackupSourceArgs', 'InstanceManagedBackupSourceArgsDict']]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_distribution_config: Optional[pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']]] = None,
                 __props__=None):
        """
        A Google Cloud Memorystore instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/valkey/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memorystore/docs/valkey/create-instances)

        ## Example Usage

        ### Memorystore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_basic = gcp.memorystore.Instance("instance-basic",
            instance_id="basic-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            deletion_protection_enabled=False,
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_full = gcp.memorystore.Instance("instance-full",
            instance_id="full-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            replica_count=1,
            node_type="SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_DISABLED",
            authorization_mode="AUTH_DISABLED",
            kms_key="my-key",
            engine_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "us-central1-b",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            engine_version="VALKEY_7_2",
            deletion_protection_enabled=False,
            mode="CLUSTER",
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            labels={
                "abc": "xyz",
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Persistence Aof

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_persistence_aof = gcp.memorystore.Instance("instance-persistence-aof",
            instance_id="aof-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            persistence_config={
                "mode": "AOF",
                "aof_config": {
                    "append_fsync": "EVERY_SEC",
                },
            },
            deletion_protection_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Secondary Instance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary_producer_net = gcp.compute.Network("primary_producer_net",
            name="my-network-primary-instance",
            auto_create_subnetworks=False)
        primary_producer_subnet = gcp.compute.Subnetwork("primary_producer_subnet",
            name="my-subnet-primary-instance",
            ip_cidr_range="10.0.1.0/29",
            region="asia-east1",
            network=primary_producer_net.id)
        primary_policy = gcp.networkconnectivity.ServiceConnectionPolicy("primary_policy",
            name="my-policy-primary-instance",
            location="asia-east1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=primary_producer_net.id,
            psc_config={
                "subnetworks": [primary_producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        # Primary instance
        primary_instance = gcp.memorystore.Instance("primary_instance",
            instance_id="primary-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": primary_producer_net.id,
                "project_id": project.project_id,
            }],
            location="asia-east1",
            replica_count=1,
            node_type="SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_DISABLED",
            authorization_mode="AUTH_DISABLED",
            engine_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "asia-east1-c",
            },
            deletion_protection_enabled=True,
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            labels={
                "abc": "xyz",
            },
            opts = pulumi.ResourceOptions(depends_on=[primary_policy]))
        secondary_producer_net = gcp.compute.Network("secondary_producer_net",
            name="my-network-secondary-instance",
            auto_create_subnetworks=False)
        secondary_producer_subnet = gcp.compute.Subnetwork("secondary_producer_subnet",
            name="my-subnet-secondary-instance",
            ip_cidr_range="10.0.2.0/29",
            region="europe-north1",
            network=secondary_producer_net.id)
        secondary_policy = gcp.networkconnectivity.ServiceConnectionPolicy("secondary_policy",
            name="my-policy-secondary-instance",
            location="europe-north1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=secondary_producer_net.id,
            psc_config={
                "subnetworks": [secondary_producer_subnet.id],
            })
        # Secondary instance
        secondary_instance = gcp.memorystore.Instance("secondary_instance",
            instance_id="secondary-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": secondary_producer_net.id,
                "project_id": project.project_id,
            }],
            location="europe-north1",
            replica_count=1,
            node_type="SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_DISABLED",
            authorization_mode="AUTH_DISABLED",
            engine_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "europe-north1-c",
            },
            deletion_protection_enabled=True,
            cross_instance_replication_config={
                "instance_role": "SECONDARY",
                "primary_instance": {
                    "instance": primary_instance.id,
                },
            },
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            labels={
                "abc": "xyz",
            },
            opts = pulumi.ResourceOptions(depends_on=[secondary_policy]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default {{location}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_mode: Optional. Immutable. Authorization mode of the instance. Possible values:
               AUTH_DISABLED
               IAM_AUTH
        :param pulumi.Input[Union['InstanceAutomatedBackupConfigArgs', 'InstanceAutomatedBackupConfigArgsDict']] automated_backup_config: The automated backup config for a instance.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceCrossInstanceReplicationConfigArgs', 'InstanceCrossInstanceReplicationConfigArgsDict']] cross_instance_replication_config: Cross instance replication config
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Optional. If set to true deletion of the instance will fail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredAutoCreatedEndpointArgs', 'InstanceDesiredAutoCreatedEndpointArgsDict']]]] desired_auto_created_endpoints: Immutable. User inputs for the auto-created endpoints connections.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]] desired_psc_auto_connections: `desired_psc_auto_connections` is deprecated  Use `desired_auto_created_endpoints` instead `pulumi import` will only work with desired_auto_created_endpoints`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] engine_configs: Optional. User-provided engine configurations for the instance.
        :param pulumi.Input[_builtins.str] engine_version: Optional. Engine version of the instance.
        :param pulumi.Input[Union['InstanceGcsSourceArgs', 'InstanceGcsSourceArgsDict']] gcs_source: GCS source for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: Required. The ID to use for the instance, which will become the final component of
               the instance's resource name.
               This value is subject to the following restrictions:
               * Must be 4-63 characters in length
               * Must begin with a letter or digit
               * Must contain only lowercase letters, digits, and hyphens
               * Must not end with a hyphen
               * Must be unique within a location
        :param pulumi.Input[_builtins.str] kms_key: The KMS key used to encrypt the at-rest data of the cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        :param pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for a cluster
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
               *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        :param pulumi.Input[Union['InstanceManagedBackupSourceArgs', 'InstanceManagedBackupSourceArgsDict']] managed_backup_source: Managed backup source for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mode: Optional. cluster or cluster-disabled.
               Possible values:
               CLUSTER
               CLUSTER_DISABLED
               Possible values are: `CLUSTER`, `CLUSTER_DISABLED`.
        :param pulumi.Input[_builtins.str] node_type: Optional. Machine type for individual nodes of the instance.
               Possible values:
               SHARED_CORE_NANO
               HIGHMEM_MEDIUM
               HIGHMEM_XLARGE
               STANDARD_SMALL
        :param pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']] persistence_config: Represents persistence configuration for a instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.int] replica_count: Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        :param pulumi.Input[_builtins.int] shard_count: Required. Number of shards for the instance.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: Optional. Immutable. In-transit encryption mode of the instance.
               Possible values:
               TRANSIT_ENCRYPTION_DISABLED
               SERVER_AUTHENTICATION
        :param pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']] zone_distribution_config: Zone distribution configuration for allocation of instance resources.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Memorystore instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/valkey/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memorystore/docs/valkey/create-instances)

        ## Example Usage

        ### Memorystore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_basic = gcp.memorystore.Instance("instance-basic",
            instance_id="basic-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            deletion_protection_enabled=False,
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_full = gcp.memorystore.Instance("instance-full",
            instance_id="full-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            replica_count=1,
            node_type="SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_DISABLED",
            authorization_mode="AUTH_DISABLED",
            kms_key="my-key",
            engine_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "us-central1-b",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            engine_version="VALKEY_7_2",
            deletion_protection_enabled=False,
            mode="CLUSTER",
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            labels={
                "abc": "xyz",
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Persistence Aof

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_persistence_aof = gcp.memorystore.Instance("instance-persistence-aof",
            instance_id="aof-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            persistence_config={
                "mode": "AOF",
                "aof_config": {
                    "append_fsync": "EVERY_SEC",
                },
            },
            deletion_protection_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Secondary Instance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary_producer_net = gcp.compute.Network("primary_producer_net",
            name="my-network-primary-instance",
            auto_create_subnetworks=False)
        primary_producer_subnet = gcp.compute.Subnetwork("primary_producer_subnet",
            name="my-subnet-primary-instance",
            ip_cidr_range="10.0.1.0/29",
            region="asia-east1",
            network=primary_producer_net.id)
        primary_policy = gcp.networkconnectivity.ServiceConnectionPolicy("primary_policy",
            name="my-policy-primary-instance",
            location="asia-east1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=primary_producer_net.id,
            psc_config={
                "subnetworks": [primary_producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        # Primary instance
        primary_instance = gcp.memorystore.Instance("primary_instance",
            instance_id="primary-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": primary_producer_net.id,
                "project_id": project.project_id,
            }],
            location="asia-east1",
            replica_count=1,
            node_type="SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_DISABLED",
            authorization_mode="AUTH_DISABLED",
            engine_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "asia-east1-c",
            },
            deletion_protection_enabled=True,
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            labels={
                "abc": "xyz",
            },
            opts = pulumi.ResourceOptions(depends_on=[primary_policy]))
        secondary_producer_net = gcp.compute.Network("secondary_producer_net",
            name="my-network-secondary-instance",
            auto_create_subnetworks=False)
        secondary_producer_subnet = gcp.compute.Subnetwork("secondary_producer_subnet",
            name="my-subnet-secondary-instance",
            ip_cidr_range="10.0.2.0/29",
            region="europe-north1",
            network=secondary_producer_net.id)
        secondary_policy = gcp.networkconnectivity.ServiceConnectionPolicy("secondary_policy",
            name="my-policy-secondary-instance",
            location="europe-north1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=secondary_producer_net.id,
            psc_config={
                "subnetworks": [secondary_producer_subnet.id],
            })
        # Secondary instance
        secondary_instance = gcp.memorystore.Instance("secondary_instance",
            instance_id="secondary-instance",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": secondary_producer_net.id,
                "project_id": project.project_id,
            }],
            location="europe-north1",
            replica_count=1,
            node_type="SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_DISABLED",
            authorization_mode="AUTH_DISABLED",
            engine_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "europe-north1-c",
            },
            deletion_protection_enabled=True,
            cross_instance_replication_config={
                "instance_role": "SECONDARY",
                "primary_instance": {
                    "instance": primary_instance.id,
                },
            },
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            labels={
                "abc": "xyz",
            },
            opts = pulumi.ResourceOptions(depends_on=[secondary_policy]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default {{location}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 automated_backup_config: Optional[pulumi.Input[Union['InstanceAutomatedBackupConfigArgs', 'InstanceAutomatedBackupConfigArgsDict']]] = None,
                 cross_instance_replication_config: Optional[pulumi.Input[Union['InstanceCrossInstanceReplicationConfigArgs', 'InstanceCrossInstanceReplicationConfigArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_auto_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredAutoCreatedEndpointArgs', 'InstanceDesiredAutoCreatedEndpointArgsDict']]]]] = None,
                 desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]]] = None,
                 engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gcs_source: Optional[pulumi.Input[Union['InstanceGcsSourceArgs', 'InstanceGcsSourceArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_backup_source: Optional[pulumi.Input[Union['InstanceManagedBackupSourceArgs', 'InstanceManagedBackupSourceArgsDict']]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_distribution_config: Optional[pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["authorization_mode"] = authorization_mode
            __props__.__dict__["automated_backup_config"] = automated_backup_config
            __props__.__dict__["cross_instance_replication_config"] = cross_instance_replication_config
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["desired_auto_created_endpoints"] = desired_auto_created_endpoints
            __props__.__dict__["desired_psc_auto_connections"] = desired_psc_auto_connections
            __props__.__dict__["engine_configs"] = engine_configs
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["gcs_source"] = gcs_source
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["kms_key"] = kms_key
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["maintenance_version"] = maintenance_version
            __props__.__dict__["managed_backup_source"] = managed_backup_source
            __props__.__dict__["mode"] = mode
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["persistence_config"] = persistence_config
            __props__.__dict__["project"] = project
            __props__.__dict__["replica_count"] = replica_count
            if shard_count is None and not opts.urn:
                raise TypeError("Missing required property 'shard_count'")
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
            __props__.__dict__["zone_distribution_config"] = zone_distribution_config
            __props__.__dict__["available_maintenance_versions"] = None
            __props__.__dict__["backup_collection"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["discovery_endpoints"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["effective_maintenance_version"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["maintenance_schedules"] = None
            __props__.__dict__["managed_server_cas"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["node_configs"] = None
            __props__.__dict__["psc_attachment_details"] = None
            __props__.__dict__["psc_auto_connections"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_infos"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:memorystore/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
            automated_backup_config: Optional[pulumi.Input[Union['InstanceAutomatedBackupConfigArgs', 'InstanceAutomatedBackupConfigArgsDict']]] = None,
            available_maintenance_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_collection: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_instance_replication_config: Optional[pulumi.Input[Union['InstanceCrossInstanceReplicationConfigArgs', 'InstanceCrossInstanceReplicationConfigArgsDict']]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            desired_auto_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredAutoCreatedEndpointArgs', 'InstanceDesiredAutoCreatedEndpointArgsDict']]]]] = None,
            desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]]] = None,
            discovery_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDiscoveryEndpointArgs', 'InstanceDiscoveryEndpointArgsDict']]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEndpointArgs', 'InstanceEndpointArgsDict']]]]] = None,
            engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            gcs_source: Optional[pulumi.Input[Union['InstanceGcsSourceArgs', 'InstanceGcsSourceArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
            maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMaintenanceScheduleArgs', 'InstanceMaintenanceScheduleArgsDict']]]]] = None,
            maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
            managed_backup_source: Optional[pulumi.Input[Union['InstanceManagedBackupSourceArgs', 'InstanceManagedBackupSourceArgsDict']]] = None,
            managed_server_cas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceManagedServerCaArgs', 'InstanceManagedServerCaArgsDict']]]]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']]]]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            psc_attachment_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePscAttachmentDetailArgs', 'InstancePscAttachmentDetailArgsDict']]]]] = None,
            psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePscAutoConnectionArgs', 'InstancePscAutoConnectionArgsDict']]]]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            replica_count: Optional[pulumi.Input[_builtins.int]] = None,
            shard_count: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceStateInfoArgs', 'InstanceStateInfoArgsDict']]]]] = None,
            transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            zone_distribution_config: Optional[pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_mode: Optional. Immutable. Authorization mode of the instance. Possible values:
               AUTH_DISABLED
               IAM_AUTH
        :param pulumi.Input[Union['InstanceAutomatedBackupConfigArgs', 'InstanceAutomatedBackupConfigArgsDict']] automated_backup_config: The automated backup config for a instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_maintenance_versions: This field is used to determine the available maintenance versions for the self service update.
        :param pulumi.Input[_builtins.str] backup_collection: The backup collection full resource name.
               Example: projects/{project}/locations/{location}/backupCollections/{collection}
        :param pulumi.Input[_builtins.str] create_time: Output only. Creation timestamp of the instance.
        :param pulumi.Input[Union['InstanceCrossInstanceReplicationConfigArgs', 'InstanceCrossInstanceReplicationConfigArgsDict']] cross_instance_replication_config: Cross instance replication config
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Optional. If set to true deletion of the instance will fail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredAutoCreatedEndpointArgs', 'InstanceDesiredAutoCreatedEndpointArgsDict']]]] desired_auto_created_endpoints: Immutable. User inputs for the auto-created endpoints connections.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]] desired_psc_auto_connections: `desired_psc_auto_connections` is deprecated  Use `desired_auto_created_endpoints` instead `pulumi import` will only work with desired_auto_created_endpoints`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDiscoveryEndpointArgs', 'InstanceDiscoveryEndpointArgsDict']]]] discovery_endpoints: (Deprecated)
               Deprecated. Output only. Endpoints clients can connect to the instance through.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] effective_maintenance_version: This field represents the actual maintenance version of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEndpointArgs', 'InstanceEndpointArgsDict']]]] endpoints: Endpoints for the instance.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] engine_configs: Optional. User-provided engine configurations for the instance.
        :param pulumi.Input[_builtins.str] engine_version: Optional. Engine version of the instance.
        :param pulumi.Input[Union['InstanceGcsSourceArgs', 'InstanceGcsSourceArgsDict']] gcs_source: GCS source for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: Required. The ID to use for the instance, which will become the final component of
               the instance's resource name.
               This value is subject to the following restrictions:
               * Must be 4-63 characters in length
               * Must begin with a letter or digit
               * Must contain only lowercase letters, digits, and hyphens
               * Must not end with a hyphen
               * Must be unique within a location
        :param pulumi.Input[_builtins.str] kms_key: The KMS key used to encrypt the at-rest data of the cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        :param pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for a cluster
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMaintenanceScheduleArgs', 'InstanceMaintenanceScheduleArgsDict']]]] maintenance_schedules: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
               *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        :param pulumi.Input[Union['InstanceManagedBackupSourceArgs', 'InstanceManagedBackupSourceArgsDict']] managed_backup_source: Managed backup source for the instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceManagedServerCaArgs', 'InstanceManagedServerCaArgsDict']]]] managed_server_cas: Instance's Certificate Authority. This field will only be populated if instance's transit_encryption_mode is SERVER_AUTHENTICATION
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mode: Optional. cluster or cluster-disabled.
               Possible values:
               CLUSTER
               CLUSTER_DISABLED
               Possible values are: `CLUSTER`, `CLUSTER_DISABLED`.
        :param pulumi.Input[_builtins.str] name: Identifier. Unique name of the instance.
               Format: projects/{project}/locations/{location}/instances/{instance}
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']]]] node_configs: Represents configuration for nodes of the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] node_type: Optional. Machine type for individual nodes of the instance.
               Possible values:
               SHARED_CORE_NANO
               HIGHMEM_MEDIUM
               HIGHMEM_XLARGE
               STANDARD_SMALL
        :param pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']] persistence_config: Represents persistence configuration for a instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePscAttachmentDetailArgs', 'InstancePscAttachmentDetailArgsDict']]]] psc_attachment_details: Configuration of a service attachment of the cluster, for creating PSC connections.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePscAutoConnectionArgs', 'InstancePscAutoConnectionArgsDict']]]] psc_auto_connections: (Deprecated)
               Output only. User inputs and resource details of the auto-created PSC connections.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.int] replica_count: Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        :param pulumi.Input[_builtins.int] shard_count: Required. Number of shards for the instance.
        :param pulumi.Input[_builtins.str] state: Output only. Current state of the instance.
               Possible values:
               CREATING
               ACTIVE
               UPDATING
               DELETING
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceStateInfoArgs', 'InstanceStateInfoArgsDict']]]] state_infos: Additional information about the state of the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: Optional. Immutable. In-transit encryption mode of the instance.
               Possible values:
               TRANSIT_ENCRYPTION_DISABLED
               SERVER_AUTHENTICATION
        :param pulumi.Input[_builtins.str] uid: Output only. System assigned, unique identifier for the instance.
        :param pulumi.Input[_builtins.str] update_time: Output only. Latest update timestamp of the instance.
        :param pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']] zone_distribution_config: Zone distribution configuration for allocation of instance resources.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["authorization_mode"] = authorization_mode
        __props__.__dict__["automated_backup_config"] = automated_backup_config
        __props__.__dict__["available_maintenance_versions"] = available_maintenance_versions
        __props__.__dict__["backup_collection"] = backup_collection
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_instance_replication_config"] = cross_instance_replication_config
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["desired_auto_created_endpoints"] = desired_auto_created_endpoints
        __props__.__dict__["desired_psc_auto_connections"] = desired_psc_auto_connections
        __props__.__dict__["discovery_endpoints"] = discovery_endpoints
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["effective_maintenance_version"] = effective_maintenance_version
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["engine_configs"] = engine_configs
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["gcs_source"] = gcs_source
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["maintenance_schedules"] = maintenance_schedules
        __props__.__dict__["maintenance_version"] = maintenance_version
        __props__.__dict__["managed_backup_source"] = managed_backup_source
        __props__.__dict__["managed_server_cas"] = managed_server_cas
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["node_configs"] = node_configs
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["persistence_config"] = persistence_config
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_attachment_details"] = psc_attachment_details
        __props__.__dict__["psc_auto_connections"] = psc_auto_connections
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["state"] = state
        __props__.__dict__["state_infos"] = state_infos
        __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["zone_distribution_config"] = zone_distribution_config
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. Immutable. Authorization mode of the instance. Possible values:
        AUTH_DISABLED
        IAM_AUTH
        """
        return pulumi.get(self, "authorization_mode")

    @_builtins.property
    @pulumi.getter(name="automatedBackupConfig")
    def automated_backup_config(self) -> pulumi.Output[Optional['outputs.InstanceAutomatedBackupConfig']]:
        """
        The automated backup config for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_config")

    @_builtins.property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        This field is used to determine the available maintenance versions for the self service update.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @_builtins.property
    @pulumi.getter(name="backupCollection")
    def backup_collection(self) -> pulumi.Output[_builtins.str]:
        """
        The backup collection full resource name.
        Example: projects/{project}/locations/{location}/backupCollections/{collection}
        """
        return pulumi.get(self, "backup_collection")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Creation timestamp of the instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossInstanceReplicationConfig")
    def cross_instance_replication_config(self) -> pulumi.Output['outputs.InstanceCrossInstanceReplicationConfig']:
        """
        Cross instance replication config
        Structure is documented below.
        """
        return pulumi.get(self, "cross_instance_replication_config")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Optional. If set to true deletion of the instance will fail.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="desiredAutoCreatedEndpoints")
    def desired_auto_created_endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceDesiredAutoCreatedEndpoint']]]:
        """
        Immutable. User inputs for the auto-created endpoints connections.
        """
        return pulumi.get(self, "desired_auto_created_endpoints")

    @_builtins.property
    @pulumi.getter(name="desiredPscAutoConnections")
    @_utilities.deprecated("""`desired_psc_auto_connections` is deprecated. Use `desired_auto_created_endpoints` instead. `terraform import` will only work with desired_auto_created_endpoints`.""")
    def desired_psc_auto_connections(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceDesiredPscAutoConnection']]]:
        """
        `desired_psc_auto_connections` is deprecated  Use `desired_auto_created_endpoints` instead `pulumi import` will only work with desired_auto_created_endpoints`.
        """
        return pulumi.get(self, "desired_psc_auto_connections")

    @_builtins.property
    @pulumi.getter(name="discoveryEndpoints")
    @_utilities.deprecated("""This field is deprecated. As a result it will not be populated if the connections are created using `desired_auto_created_endpoints` parameter or `memorystore.InstanceDesiredUserCreatedEndpoints` resource. Instead of this parameter, for discovery, use `endpoints.connections.pscConnection` and `endpoints.connections.pscAutoConnection` with `connectionType` CONNECTION_TYPE_DISCOVERY.""")
    def discovery_endpoints(self) -> pulumi.Output[Sequence['outputs.InstanceDiscoveryEndpoint']]:
        """
        (Deprecated)
        Deprecated. Output only. Endpoints clients can connect to the instance through.
        Structure is documented below.
        """
        return pulumi.get(self, "discovery_endpoints")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="effectiveMaintenanceVersion")
    def effective_maintenance_version(self) -> pulumi.Output[_builtins.str]:
        """
        This field represents the actual maintenance version of the cluster.
        """
        return pulumi.get(self, "effective_maintenance_version")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.InstanceEndpoint']]:
        """
        Endpoints for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="engineConfigs")
    def engine_configs(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. User-provided engine configurations for the instance.
        """
        return pulumi.get(self, "engine_configs")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. Engine version of the instance.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> pulumi.Output[Optional['outputs.InstanceGcsSource']]:
        """
        GCS source for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_source")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The ID to use for the instance, which will become the final component of
        the instance's resource name.
        This value is subject to the following restrictions:
        * Must be 4-63 characters in length
        * Must begin with a letter or digit
        * Must contain only lowercase letters, digits, and hyphens
        * Must not end with a hyphen
        * Must be unique within a location
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The KMS key used to encrypt the at-rest data of the cluster
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output[Optional['outputs.InstanceMaintenancePolicy']]:
        """
        Maintenance policy for a cluster
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @_builtins.property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> pulumi.Output[Sequence['outputs.InstanceMaintenanceSchedule']]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
        *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        """
        return pulumi.get(self, "maintenance_version")

    @_builtins.property
    @pulumi.getter(name="managedBackupSource")
    def managed_backup_source(self) -> pulumi.Output[Optional['outputs.InstanceManagedBackupSource']]:
        """
        Managed backup source for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "managed_backup_source")

    @_builtins.property
    @pulumi.getter(name="managedServerCas")
    def managed_server_cas(self) -> pulumi.Output[Sequence['outputs.InstanceManagedServerCa']]:
        """
        Instance's Certificate Authority. This field will only be populated if instance's transit_encryption_mode is SERVER_AUTHENTICATION
        Structure is documented below.
        """
        return pulumi.get(self, "managed_server_cas")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. cluster or cluster-disabled.
        Possible values:
        CLUSTER
        CLUSTER_DISABLED
        Possible values are: `CLUSTER`, `CLUSTER_DISABLED`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Unique name of the instance.
        Format: projects/{project}/locations/{location}/instances/{instance}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> pulumi.Output[Sequence['outputs.InstanceNodeConfig']]:
        """
        Represents configuration for nodes of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "node_configs")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. Machine type for individual nodes of the instance.
        Possible values:
        SHARED_CORE_NANO
        HIGHMEM_MEDIUM
        HIGHMEM_XLARGE
        STANDARD_SMALL
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> pulumi.Output['outputs.InstancePersistenceConfig']:
        """
        Represents persistence configuration for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pscAttachmentDetails")
    def psc_attachment_details(self) -> pulumi.Output[Sequence['outputs.InstancePscAttachmentDetail']]:
        """
        Configuration of a service attachment of the cluster, for creating PSC connections.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_attachment_details")

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    @_utilities.deprecated("""`psc_auto_connections` is deprecated  Use `endpoints.connections.pscAutoConnections` instead.""")
    def psc_auto_connections(self) -> pulumi.Output[Sequence['outputs.InstancePscAutoConnection']]:
        """
        (Deprecated)
        Output only. User inputs and resource details of the auto-created PSC connections.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_auto_connections")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[_builtins.int]:
        """
        Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        """
        return pulumi.get(self, "replica_count")

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[_builtins.int]:
        """
        Required. Number of shards for the instance.
        """
        return pulumi.get(self, "shard_count")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Current state of the instance.
        Possible values:
        CREATING
        ACTIVE
        UPDATING
        DELETING
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateInfos")
    def state_infos(self) -> pulumi.Output[Sequence['outputs.InstanceStateInfo']]:
        """
        Additional information about the state of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "state_infos")

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. Immutable. In-transit encryption mode of the instance.
        Possible values:
        TRANSIT_ENCRYPTION_DISABLED
        SERVER_AUTHENTICATION
        """
        return pulumi.get(self, "transit_encryption_mode")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. System assigned, unique identifier for the instance.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Latest update timestamp of the instance.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> pulumi.Output['outputs.InstanceZoneDistributionConfig']:
        """
        Zone distribution configuration for allocation of instance resources.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

