# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FloorsettingArgs', 'Floorsetting']

@pulumi.input_type
class FloorsettingArgs:
    def __init__(__self__, *,
                 filter_config: pulumi.Input['FloorsettingFilterConfigArgs'],
                 location: pulumi.Input[_builtins.str],
                 parent: pulumi.Input[_builtins.str],
                 ai_platform_floor_setting: Optional[pulumi.Input['FloorsettingAiPlatformFloorSettingArgs']] = None,
                 enable_floor_setting_enforcement: Optional[pulumi.Input[_builtins.bool]] = None,
                 floor_setting_metadata: Optional[pulumi.Input['FloorsettingFloorSettingMetadataArgs']] = None,
                 integrated_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Floorsetting resource.
        :param pulumi.Input['FloorsettingFilterConfigArgs'] filter_config: Filters configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] parent: Will be any one of these:
               * `projects/{project}`
               * `folders/{folder}`
               * `organizations/{organizationId}`
        :param pulumi.Input['FloorsettingAiPlatformFloorSettingArgs'] ai_platform_floor_setting: AI Platform floor setting.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enable_floor_setting_enforcement: Floor Settings enforcement status.
        :param pulumi.Input['FloorsettingFloorSettingMetadataArgs'] floor_setting_metadata: Metadata to enable multi language detection via floor setting.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] integrated_services: List of integrated services for which the floor setting is applicable.
        """
        pulumi.set(__self__, "filter_config", filter_config)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "parent", parent)
        if ai_platform_floor_setting is not None:
            pulumi.set(__self__, "ai_platform_floor_setting", ai_platform_floor_setting)
        if enable_floor_setting_enforcement is not None:
            pulumi.set(__self__, "enable_floor_setting_enforcement", enable_floor_setting_enforcement)
        if floor_setting_metadata is not None:
            pulumi.set(__self__, "floor_setting_metadata", floor_setting_metadata)
        if integrated_services is not None:
            pulumi.set(__self__, "integrated_services", integrated_services)

    @_builtins.property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> pulumi.Input['FloorsettingFilterConfigArgs']:
        """
        Filters configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_config")

    @filter_config.setter
    def filter_config(self, value: pulumi.Input['FloorsettingFilterConfigArgs']):
        pulumi.set(self, "filter_config", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Input[_builtins.str]:
        """
        Will be any one of these:
        * `projects/{project}`
        * `folders/{folder}`
        * `organizations/{organizationId}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="aiPlatformFloorSetting")
    def ai_platform_floor_setting(self) -> Optional[pulumi.Input['FloorsettingAiPlatformFloorSettingArgs']]:
        """
        AI Platform floor setting.
        Structure is documented below.
        """
        return pulumi.get(self, "ai_platform_floor_setting")

    @ai_platform_floor_setting.setter
    def ai_platform_floor_setting(self, value: Optional[pulumi.Input['FloorsettingAiPlatformFloorSettingArgs']]):
        pulumi.set(self, "ai_platform_floor_setting", value)

    @_builtins.property
    @pulumi.getter(name="enableFloorSettingEnforcement")
    def enable_floor_setting_enforcement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Floor Settings enforcement status.
        """
        return pulumi.get(self, "enable_floor_setting_enforcement")

    @enable_floor_setting_enforcement.setter
    def enable_floor_setting_enforcement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_floor_setting_enforcement", value)

    @_builtins.property
    @pulumi.getter(name="floorSettingMetadata")
    def floor_setting_metadata(self) -> Optional[pulumi.Input['FloorsettingFloorSettingMetadataArgs']]:
        """
        Metadata to enable multi language detection via floor setting.
        Structure is documented below.
        """
        return pulumi.get(self, "floor_setting_metadata")

    @floor_setting_metadata.setter
    def floor_setting_metadata(self, value: Optional[pulumi.Input['FloorsettingFloorSettingMetadataArgs']]):
        pulumi.set(self, "floor_setting_metadata", value)

    @_builtins.property
    @pulumi.getter(name="integratedServices")
    def integrated_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of integrated services for which the floor setting is applicable.
        """
        return pulumi.get(self, "integrated_services")

    @integrated_services.setter
    def integrated_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "integrated_services", value)


@pulumi.input_type
class _FloorsettingState:
    def __init__(__self__, *,
                 ai_platform_floor_setting: Optional[pulumi.Input['FloorsettingAiPlatformFloorSettingArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_floor_setting_enforcement: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_config: Optional[pulumi.Input['FloorsettingFilterConfigArgs']] = None,
                 floor_setting_metadata: Optional[pulumi.Input['FloorsettingFloorSettingMetadataArgs']] = None,
                 integrated_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Floorsetting resources.
        :param pulumi.Input['FloorsettingAiPlatformFloorSettingArgs'] ai_platform_floor_setting: AI Platform floor setting.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: [Output only] Create timestamp
        :param pulumi.Input[_builtins.bool] enable_floor_setting_enforcement: Floor Settings enforcement status.
        :param pulumi.Input['FloorsettingFilterConfigArgs'] filter_config: Filters configuration.
               Structure is documented below.
        :param pulumi.Input['FloorsettingFloorSettingMetadataArgs'] floor_setting_metadata: Metadata to enable multi language detection via floor setting.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] integrated_services: List of integrated services for which the floor setting is applicable.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name.
        :param pulumi.Input[_builtins.str] parent: Will be any one of these:
               * `projects/{project}`
               * `folders/{folder}`
               * `organizations/{organizationId}`
        :param pulumi.Input[_builtins.str] update_time: [Output only] Update timestamp
        """
        if ai_platform_floor_setting is not None:
            pulumi.set(__self__, "ai_platform_floor_setting", ai_platform_floor_setting)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if enable_floor_setting_enforcement is not None:
            pulumi.set(__self__, "enable_floor_setting_enforcement", enable_floor_setting_enforcement)
        if filter_config is not None:
            pulumi.set(__self__, "filter_config", filter_config)
        if floor_setting_metadata is not None:
            pulumi.set(__self__, "floor_setting_metadata", floor_setting_metadata)
        if integrated_services is not None:
            pulumi.set(__self__, "integrated_services", integrated_services)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="aiPlatformFloorSetting")
    def ai_platform_floor_setting(self) -> Optional[pulumi.Input['FloorsettingAiPlatformFloorSettingArgs']]:
        """
        AI Platform floor setting.
        Structure is documented below.
        """
        return pulumi.get(self, "ai_platform_floor_setting")

    @ai_platform_floor_setting.setter
    def ai_platform_floor_setting(self, value: Optional[pulumi.Input['FloorsettingAiPlatformFloorSettingArgs']]):
        pulumi.set(self, "ai_platform_floor_setting", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Output only] Create timestamp
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="enableFloorSettingEnforcement")
    def enable_floor_setting_enforcement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Floor Settings enforcement status.
        """
        return pulumi.get(self, "enable_floor_setting_enforcement")

    @enable_floor_setting_enforcement.setter
    def enable_floor_setting_enforcement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_floor_setting_enforcement", value)

    @_builtins.property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> Optional[pulumi.Input['FloorsettingFilterConfigArgs']]:
        """
        Filters configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_config")

    @filter_config.setter
    def filter_config(self, value: Optional[pulumi.Input['FloorsettingFilterConfigArgs']]):
        pulumi.set(self, "filter_config", value)

    @_builtins.property
    @pulumi.getter(name="floorSettingMetadata")
    def floor_setting_metadata(self) -> Optional[pulumi.Input['FloorsettingFloorSettingMetadataArgs']]:
        """
        Metadata to enable multi language detection via floor setting.
        Structure is documented below.
        """
        return pulumi.get(self, "floor_setting_metadata")

    @floor_setting_metadata.setter
    def floor_setting_metadata(self, value: Optional[pulumi.Input['FloorsettingFloorSettingMetadataArgs']]):
        pulumi.set(self, "floor_setting_metadata", value)

    @_builtins.property
    @pulumi.getter(name="integratedServices")
    def integrated_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of integrated services for which the floor setting is applicable.
        """
        return pulumi.get(self, "integrated_services")

    @integrated_services.setter
    def integrated_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "integrated_services", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Will be any one of these:
        * `projects/{project}`
        * `folders/{folder}`
        * `organizations/{organizationId}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Output only] Update timestamp
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:modelarmor/floorsetting:Floorsetting")
class Floorsetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_platform_floor_setting: Optional[pulumi.Input[Union['FloorsettingAiPlatformFloorSettingArgs', 'FloorsettingAiPlatformFloorSettingArgsDict']]] = None,
                 enable_floor_setting_enforcement: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_config: Optional[pulumi.Input[Union['FloorsettingFilterConfigArgs', 'FloorsettingFilterConfigArgsDict']]] = None,
                 floor_setting_metadata: Optional[pulumi.Input[Union['FloorsettingFloorSettingMetadataArgs', 'FloorsettingFloorSettingMetadataArgsDict']]] = None,
                 integrated_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Model Armor floor settings define rules that dictate minimum requirements for all Model Armor templates created at a specific point in the Google Cloud resource hierarchy (that is, at an organization, folder, or project level). If there are
        multiple floor settings that conflict with each other, the settings lower in the resource hierarchy take precedence
        For more information, checkout https://cloud.google.com/security-command-center/docs/model_armor_floor_settings

        ## Example Usage

        ### Modelarmor Floorsetting Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        floorsetting_basic = gcp.modelarmor.Floorsetting("floorsetting-basic",
            parent="projects/my-project-name",
            location="global",
            filter_config={})
        ```
        ### Modelarmor Floorsetting Filter Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        floorsetting_filter_config = gcp.modelarmor.Floorsetting("floorsetting-filter-config",
            location="global",
            parent="project/my-project-name",
            filter_config={
                "rai_settings": {
                    "rai_filters": [{
                        "filter_type": "DANGEROUS",
                        "confidence_level": "MEDIUM_AND_ABOVE",
                    }],
                },
                "sdp_settings": {
                    "basic_config": {
                        "filter_enforcement": "ENABLED",
                    },
                },
                "pi_and_jailbreak_filter_settings": {
                    "filter_enforcement": "ENABLED",
                    "confidence_level": "HIGH",
                },
                "malicious_uri_filter_settings": {
                    "filter_enforcement": "ENABLED",
                },
            },
            enable_floor_setting_enforcement=True)
        ```
        ### Modelarmor Floorsetting Ai Platform Metadata

        ```python
        import pulumi
        import pulumi_gcp as gcp

        floorsetting_integrated_metadata = gcp.modelarmor.Floorsetting("floorsetting-integrated-metadata",
            location="global",
            parent="projects/my-project-name",
            filter_config={},
            enable_floor_setting_enforcement=False,
            ai_platform_floor_setting={
                "inspect_only": True,
                "enable_cloud_logging": True,
            },
            floor_setting_metadata={
                "multi_language_detection": {
                    "enable_multi_language_detection": False,
                },
            })
        ```

        ## Import

        Floorsetting can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/floorSetting`

        * `{{parent}}/{{location}}`

        When using the `pulumi import` command, Floorsetting can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:modelarmor/floorsetting:Floorsetting default {{parent}}/locations/{{location}}/floorSetting
        ```

        ```sh
        $ pulumi import gcp:modelarmor/floorsetting:Floorsetting default {{parent}}/{{location}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FloorsettingAiPlatformFloorSettingArgs', 'FloorsettingAiPlatformFloorSettingArgsDict']] ai_platform_floor_setting: AI Platform floor setting.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enable_floor_setting_enforcement: Floor Settings enforcement status.
        :param pulumi.Input[Union['FloorsettingFilterConfigArgs', 'FloorsettingFilterConfigArgsDict']] filter_config: Filters configuration.
               Structure is documented below.
        :param pulumi.Input[Union['FloorsettingFloorSettingMetadataArgs', 'FloorsettingFloorSettingMetadataArgsDict']] floor_setting_metadata: Metadata to enable multi language detection via floor setting.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] integrated_services: List of integrated services for which the floor setting is applicable.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] parent: Will be any one of these:
               * `projects/{project}`
               * `folders/{folder}`
               * `organizations/{organizationId}`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FloorsettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Model Armor floor settings define rules that dictate minimum requirements for all Model Armor templates created at a specific point in the Google Cloud resource hierarchy (that is, at an organization, folder, or project level). If there are
        multiple floor settings that conflict with each other, the settings lower in the resource hierarchy take precedence
        For more information, checkout https://cloud.google.com/security-command-center/docs/model_armor_floor_settings

        ## Example Usage

        ### Modelarmor Floorsetting Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        floorsetting_basic = gcp.modelarmor.Floorsetting("floorsetting-basic",
            parent="projects/my-project-name",
            location="global",
            filter_config={})
        ```
        ### Modelarmor Floorsetting Filter Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        floorsetting_filter_config = gcp.modelarmor.Floorsetting("floorsetting-filter-config",
            location="global",
            parent="project/my-project-name",
            filter_config={
                "rai_settings": {
                    "rai_filters": [{
                        "filter_type": "DANGEROUS",
                        "confidence_level": "MEDIUM_AND_ABOVE",
                    }],
                },
                "sdp_settings": {
                    "basic_config": {
                        "filter_enforcement": "ENABLED",
                    },
                },
                "pi_and_jailbreak_filter_settings": {
                    "filter_enforcement": "ENABLED",
                    "confidence_level": "HIGH",
                },
                "malicious_uri_filter_settings": {
                    "filter_enforcement": "ENABLED",
                },
            },
            enable_floor_setting_enforcement=True)
        ```
        ### Modelarmor Floorsetting Ai Platform Metadata

        ```python
        import pulumi
        import pulumi_gcp as gcp

        floorsetting_integrated_metadata = gcp.modelarmor.Floorsetting("floorsetting-integrated-metadata",
            location="global",
            parent="projects/my-project-name",
            filter_config={},
            enable_floor_setting_enforcement=False,
            ai_platform_floor_setting={
                "inspect_only": True,
                "enable_cloud_logging": True,
            },
            floor_setting_metadata={
                "multi_language_detection": {
                    "enable_multi_language_detection": False,
                },
            })
        ```

        ## Import

        Floorsetting can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/floorSetting`

        * `{{parent}}/{{location}}`

        When using the `pulumi import` command, Floorsetting can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:modelarmor/floorsetting:Floorsetting default {{parent}}/locations/{{location}}/floorSetting
        ```

        ```sh
        $ pulumi import gcp:modelarmor/floorsetting:Floorsetting default {{parent}}/{{location}}
        ```

        :param str resource_name: The name of the resource.
        :param FloorsettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FloorsettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_platform_floor_setting: Optional[pulumi.Input[Union['FloorsettingAiPlatformFloorSettingArgs', 'FloorsettingAiPlatformFloorSettingArgsDict']]] = None,
                 enable_floor_setting_enforcement: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_config: Optional[pulumi.Input[Union['FloorsettingFilterConfigArgs', 'FloorsettingFilterConfigArgsDict']]] = None,
                 floor_setting_metadata: Optional[pulumi.Input[Union['FloorsettingFloorSettingMetadataArgs', 'FloorsettingFloorSettingMetadataArgsDict']]] = None,
                 integrated_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FloorsettingArgs.__new__(FloorsettingArgs)

            __props__.__dict__["ai_platform_floor_setting"] = ai_platform_floor_setting
            __props__.__dict__["enable_floor_setting_enforcement"] = enable_floor_setting_enforcement
            if filter_config is None and not opts.urn:
                raise TypeError("Missing required property 'filter_config'")
            __props__.__dict__["filter_config"] = filter_config
            __props__.__dict__["floor_setting_metadata"] = floor_setting_metadata
            __props__.__dict__["integrated_services"] = integrated_services
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(Floorsetting, __self__).__init__(
            'gcp:modelarmor/floorsetting:Floorsetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ai_platform_floor_setting: Optional[pulumi.Input[Union['FloorsettingAiPlatformFloorSettingArgs', 'FloorsettingAiPlatformFloorSettingArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            enable_floor_setting_enforcement: Optional[pulumi.Input[_builtins.bool]] = None,
            filter_config: Optional[pulumi.Input[Union['FloorsettingFilterConfigArgs', 'FloorsettingFilterConfigArgsDict']]] = None,
            floor_setting_metadata: Optional[pulumi.Input[Union['FloorsettingFloorSettingMetadataArgs', 'FloorsettingFloorSettingMetadataArgsDict']]] = None,
            integrated_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Floorsetting':
        """
        Get an existing Floorsetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FloorsettingAiPlatformFloorSettingArgs', 'FloorsettingAiPlatformFloorSettingArgsDict']] ai_platform_floor_setting: AI Platform floor setting.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: [Output only] Create timestamp
        :param pulumi.Input[_builtins.bool] enable_floor_setting_enforcement: Floor Settings enforcement status.
        :param pulumi.Input[Union['FloorsettingFilterConfigArgs', 'FloorsettingFilterConfigArgsDict']] filter_config: Filters configuration.
               Structure is documented below.
        :param pulumi.Input[Union['FloorsettingFloorSettingMetadataArgs', 'FloorsettingFloorSettingMetadataArgsDict']] floor_setting_metadata: Metadata to enable multi language detection via floor setting.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] integrated_services: List of integrated services for which the floor setting is applicable.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name.
        :param pulumi.Input[_builtins.str] parent: Will be any one of these:
               * `projects/{project}`
               * `folders/{folder}`
               * `organizations/{organizationId}`
        :param pulumi.Input[_builtins.str] update_time: [Output only] Update timestamp
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FloorsettingState.__new__(_FloorsettingState)

        __props__.__dict__["ai_platform_floor_setting"] = ai_platform_floor_setting
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["enable_floor_setting_enforcement"] = enable_floor_setting_enforcement
        __props__.__dict__["filter_config"] = filter_config
        __props__.__dict__["floor_setting_metadata"] = floor_setting_metadata
        __props__.__dict__["integrated_services"] = integrated_services
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["update_time"] = update_time
        return Floorsetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aiPlatformFloorSetting")
    def ai_platform_floor_setting(self) -> pulumi.Output[Optional['outputs.FloorsettingAiPlatformFloorSetting']]:
        """
        AI Platform floor setting.
        Structure is documented below.
        """
        return pulumi.get(self, "ai_platform_floor_setting")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        [Output only] Create timestamp
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="enableFloorSettingEnforcement")
    def enable_floor_setting_enforcement(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Floor Settings enforcement status.
        """
        return pulumi.get(self, "enable_floor_setting_enforcement")

    @_builtins.property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> pulumi.Output['outputs.FloorsettingFilterConfig']:
        """
        Filters configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_config")

    @_builtins.property
    @pulumi.getter(name="floorSettingMetadata")
    def floor_setting_metadata(self) -> pulumi.Output[Optional['outputs.FloorsettingFloorSettingMetadata']]:
        """
        Metadata to enable multi language detection via floor setting.
        Structure is documented below.
        """
        return pulumi.get(self, "floor_setting_metadata")

    @_builtins.property
    @pulumi.getter(name="integratedServices")
    def integrated_services(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of integrated services for which the floor setting is applicable.
        """
        return pulumi.get(self, "integrated_services")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        Will be any one of these:
        * `projects/{project}`
        * `folders/{folder}`
        * `organizations/{organizationId}`
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        [Output only] Update timestamp
        """
        return pulumi.get(self, "update_time")

