# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BackupVaultBackupRetentionPolicyArgs',
    'BackupVaultBackupRetentionPolicyArgsDict',
    'VolumeBackupConfigArgs',
    'VolumeBackupConfigArgsDict',
    'VolumeBlockDeviceArgs',
    'VolumeBlockDeviceArgsDict',
    'VolumeCacheParametersArgs',
    'VolumeCacheParametersArgsDict',
    'VolumeCacheParametersCacheConfigArgs',
    'VolumeCacheParametersCacheConfigArgsDict',
    'VolumeExportPolicyArgs',
    'VolumeExportPolicyArgsDict',
    'VolumeExportPolicyRuleArgs',
    'VolumeExportPolicyRuleArgsDict',
    'VolumeHybridReplicationParametersArgs',
    'VolumeHybridReplicationParametersArgsDict',
    'VolumeMountOptionArgs',
    'VolumeMountOptionArgsDict',
    'VolumeReplicationDestinationVolumeParametersArgs',
    'VolumeReplicationDestinationVolumeParametersArgsDict',
    'VolumeReplicationDestinationVolumeParametersTieringPolicyArgs',
    'VolumeReplicationDestinationVolumeParametersTieringPolicyArgsDict',
    'VolumeReplicationHybridPeeringDetailArgs',
    'VolumeReplicationHybridPeeringDetailArgsDict',
    'VolumeReplicationHybridReplicationUserCommandArgs',
    'VolumeReplicationHybridReplicationUserCommandArgsDict',
    'VolumeReplicationTransferStatArgs',
    'VolumeReplicationTransferStatArgsDict',
    'VolumeRestoreParametersArgs',
    'VolumeRestoreParametersArgsDict',
    'VolumeSnapshotPolicyArgs',
    'VolumeSnapshotPolicyArgsDict',
    'VolumeSnapshotPolicyDailyScheduleArgs',
    'VolumeSnapshotPolicyDailyScheduleArgsDict',
    'VolumeSnapshotPolicyHourlyScheduleArgs',
    'VolumeSnapshotPolicyHourlyScheduleArgsDict',
    'VolumeSnapshotPolicyMonthlyScheduleArgs',
    'VolumeSnapshotPolicyMonthlyScheduleArgsDict',
    'VolumeSnapshotPolicyWeeklyScheduleArgs',
    'VolumeSnapshotPolicyWeeklyScheduleArgsDict',
    'VolumeTieringPolicyArgs',
    'VolumeTieringPolicyArgsDict',
]

MYPY = False

if not MYPY:
    class BackupVaultBackupRetentionPolicyArgsDict(TypedDict):
        backup_minimum_enforced_retention_days: pulumi.Input[_builtins.int]
        """
        Minimum retention duration in days for backups in the backup vault.
        """
        daily_backup_immutable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates if the daily backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        manual_backup_immutable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates if the manual backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        monthly_backup_immutable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates if the monthly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        weekly_backup_immutable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates if the weekly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
elif False:
    BackupVaultBackupRetentionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupVaultBackupRetentionPolicyArgs:
    def __init__(__self__, *,
                 backup_minimum_enforced_retention_days: pulumi.Input[_builtins.int],
                 daily_backup_immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 manual_backup_immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 monthly_backup_immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 weekly_backup_immutable: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.int] backup_minimum_enforced_retention_days: Minimum retention duration in days for backups in the backup vault.
        :param pulumi.Input[_builtins.bool] daily_backup_immutable: Indicates if the daily backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param pulumi.Input[_builtins.bool] manual_backup_immutable: Indicates if the manual backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param pulumi.Input[_builtins.bool] monthly_backup_immutable: Indicates if the monthly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param pulumi.Input[_builtins.bool] weekly_backup_immutable: Indicates if the weekly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        pulumi.set(__self__, "backup_minimum_enforced_retention_days", backup_minimum_enforced_retention_days)
        if daily_backup_immutable is not None:
            pulumi.set(__self__, "daily_backup_immutable", daily_backup_immutable)
        if manual_backup_immutable is not None:
            pulumi.set(__self__, "manual_backup_immutable", manual_backup_immutable)
        if monthly_backup_immutable is not None:
            pulumi.set(__self__, "monthly_backup_immutable", monthly_backup_immutable)
        if weekly_backup_immutable is not None:
            pulumi.set(__self__, "weekly_backup_immutable", weekly_backup_immutable)

    @_builtins.property
    @pulumi.getter(name="backupMinimumEnforcedRetentionDays")
    def backup_minimum_enforced_retention_days(self) -> pulumi.Input[_builtins.int]:
        """
        Minimum retention duration in days for backups in the backup vault.
        """
        return pulumi.get(self, "backup_minimum_enforced_retention_days")

    @backup_minimum_enforced_retention_days.setter
    def backup_minimum_enforced_retention_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "backup_minimum_enforced_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="dailyBackupImmutable")
    def daily_backup_immutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the daily backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "daily_backup_immutable")

    @daily_backup_immutable.setter
    def daily_backup_immutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "daily_backup_immutable", value)

    @_builtins.property
    @pulumi.getter(name="manualBackupImmutable")
    def manual_backup_immutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the manual backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "manual_backup_immutable")

    @manual_backup_immutable.setter
    def manual_backup_immutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manual_backup_immutable", value)

    @_builtins.property
    @pulumi.getter(name="monthlyBackupImmutable")
    def monthly_backup_immutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the monthly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "monthly_backup_immutable")

    @monthly_backup_immutable.setter
    def monthly_backup_immutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monthly_backup_immutable", value)

    @_builtins.property
    @pulumi.getter(name="weeklyBackupImmutable")
    def weekly_backup_immutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the weekly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "weekly_backup_immutable")

    @weekly_backup_immutable.setter
    def weekly_backup_immutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "weekly_backup_immutable", value)


if not MYPY:
    class VolumeBackupConfigArgsDict(TypedDict):
        backup_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        """
        backup_vault: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
        Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        """
        scheduled_backup_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
elif False:
    VolumeBackupConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeBackupConfigArgs:
    def __init__(__self__, *,
                 backup_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_vault: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_policies: Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        :param pulumi.Input[_builtins.str] backup_vault: ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
               Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        :param pulumi.Input[_builtins.bool] scheduled_backup_enabled: When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        if backup_policies is not None:
            pulumi.set(__self__, "backup_policies", backup_policies)
        if backup_vault is not None:
            pulumi.set(__self__, "backup_vault", backup_vault)
        if scheduled_backup_enabled is not None:
            pulumi.set(__self__, "scheduled_backup_enabled", scheduled_backup_enabled)

    @_builtins.property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        """
        return pulumi.get(self, "backup_policies")

    @backup_policies.setter
    def backup_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backup_policies", value)

    @_builtins.property
    @pulumi.getter(name="backupVault")
    def backup_vault(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
        Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        """
        return pulumi.get(self, "backup_vault")

    @backup_vault.setter
    def backup_vault(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_vault", value)

    @_builtins.property
    @pulumi.getter(name="scheduledBackupEnabled")
    def scheduled_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        return pulumi.get(self, "scheduled_backup_enabled")

    @scheduled_backup_enabled.setter
    def scheduled_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scheduled_backup_enabled", value)


if not MYPY:
    class VolumeBlockDeviceArgsDict(TypedDict):
        os_type: pulumi.Input[_builtins.str]
        """
        The OS type of the volume.
        This field can't be changed after the block device is created.
        Possible values are: `LINUX`, `WINDOWS`, `ESXI`.
        """
        host_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of host groups that identify hosts that can mount the block volume.
        Format:
        `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
        This field can be updated after the block device is created.
        """
        identifier: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Device identifier of the Block volume. This represents lun_serial_number
        for ISCSI volumes
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        User-defined name for the block device, unique within the Volume. In case
        no user input is provided, name will be autogenerated in the backend.
        The name must meet the following requirements:
        *   Be between 1 and 255 characters long.
        *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
        and the following special characters: "-", "_", "}", "{", ".".
        *   Spaces are not allowed.
        """
        size_gib: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Output)
        The size of the block device in GiB.
        Any value provided in this field during Volume creation is IGNORED.
        The block device's size is system-managed and will be set to match
        the parent Volume's `capacity_gib`.
        """
elif False:
    VolumeBlockDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeBlockDeviceArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input[_builtins.str],
                 host_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size_gib: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] os_type: The OS type of the volume.
               This field can't be changed after the block device is created.
               Possible values are: `LINUX`, `WINDOWS`, `ESXI`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_groups: A list of host groups that identify hosts that can mount the block volume.
               Format:
               `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
               This field can be updated after the block device is created.
        :param pulumi.Input[_builtins.str] identifier: (Output)
               Device identifier of the Block volume. This represents lun_serial_number
               for ISCSI volumes
        :param pulumi.Input[_builtins.str] name: User-defined name for the block device, unique within the Volume. In case
               no user input is provided, name will be autogenerated in the backend.
               The name must meet the following requirements:
               *   Be between 1 and 255 characters long.
               *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
               and the following special characters: "-", "_", "}", "{", ".".
               *   Spaces are not allowed.
        :param pulumi.Input[_builtins.int] size_gib: (Output)
               The size of the block device in GiB.
               Any value provided in this field during Volume creation is IGNORED.
               The block device's size is system-managed and will be set to match
               the parent Volume's `capacity_gib`.
        """
        pulumi.set(__self__, "os_type", os_type)
        if host_groups is not None:
            pulumi.set(__self__, "host_groups", host_groups)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size_gib is not None:
            pulumi.set(__self__, "size_gib", size_gib)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[_builtins.str]:
        """
        The OS type of the volume.
        This field can't be changed after the block device is created.
        Possible values are: `LINUX`, `WINDOWS`, `ESXI`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="hostGroups")
    def host_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of host groups that identify hosts that can mount the block volume.
        Format:
        `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
        This field can be updated after the block device is created.
        """
        return pulumi.get(self, "host_groups")

    @host_groups.setter
    def host_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_groups", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Device identifier of the Block volume. This represents lun_serial_number
        for ISCSI volumes
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined name for the block device, unique within the Volume. In case
        no user input is provided, name will be autogenerated in the backend.
        The name must meet the following requirements:
        *   Be between 1 and 255 characters long.
        *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
        and the following special characters: "-", "_", "}", "{", ".".
        *   Spaces are not allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sizeGib")
    def size_gib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Output)
        The size of the block device in GiB.
        Any value provided in this field during Volume creation is IGNORED.
        The block device's size is system-managed and will be set to match
        the parent Volume's `capacity_gib`.
        """
        return pulumi.get(self, "size_gib")

    @size_gib.setter
    def size_gib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_gib", value)


if not MYPY:
    class VolumeCacheParametersArgsDict(TypedDict):
        cache_config: NotRequired[pulumi.Input['VolumeCacheParametersCacheConfigArgsDict']]
        """
        Optional. Configuration of the cache volume.
        Structure is documented below.
        """
        cache_state: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        State of the cache volume indicating the peering status.
        """
        command: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        """
        enable_global_file_lock: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. Field indicating whether cache volume as global file lock enabled.
        """
        passphrase: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Temporary passphrase generated to accept cluster peering command.
        """
        peer_cluster_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Required. Name of the origin volume's ONTAP cluster.
        """
        peer_ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Required. List of IC LIF addresses of the origin volume's ONTAP cluster.
        """
        peer_svm_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Required. Name of the origin volume's SVM.
        """
        peer_volume_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Required. Name of the origin volume for the cache volume.
        """
        peering_command_expiry_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Expiration time for the peering command to be executed on user's ONTAP. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        state_details: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Detailed description of the current cache state.
        """
elif False:
    VolumeCacheParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeCacheParametersArgs:
    def __init__(__self__, *,
                 cache_config: Optional[pulumi.Input['VolumeCacheParametersCacheConfigArgs']] = None,
                 cache_state: Optional[pulumi.Input[_builtins.str]] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_global_file_lock: Optional[pulumi.Input[_builtins.bool]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peer_svm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_command_expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
                 state_details: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input['VolumeCacheParametersCacheConfigArgs'] cache_config: Optional. Configuration of the cache volume.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cache_state: (Output)
               State of the cache volume indicating the peering status.
        :param pulumi.Input[_builtins.str] command: (Output)
               Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        :param pulumi.Input[_builtins.bool] enable_global_file_lock: Optional. Field indicating whether cache volume as global file lock enabled.
        :param pulumi.Input[_builtins.str] passphrase: (Output)
               Temporary passphrase generated to accept cluster peering command.
        :param pulumi.Input[_builtins.str] peer_cluster_name: Required. Name of the origin volume's ONTAP cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peer_ip_addresses: Required. List of IC LIF addresses of the origin volume's ONTAP cluster.
        :param pulumi.Input[_builtins.str] peer_svm_name: Required. Name of the origin volume's SVM.
        :param pulumi.Input[_builtins.str] peer_volume_name: Required. Name of the origin volume for the cache volume.
        :param pulumi.Input[_builtins.str] peering_command_expiry_time: Optional. Expiration time for the peering command to be executed on user's ONTAP. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[_builtins.str] state_details: (Output)
               Detailed description of the current cache state.
        """
        if cache_config is not None:
            pulumi.set(__self__, "cache_config", cache_config)
        if cache_state is not None:
            pulumi.set(__self__, "cache_state", cache_state)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if enable_global_file_lock is not None:
            pulumi.set(__self__, "enable_global_file_lock", enable_global_file_lock)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if peer_cluster_name is not None:
            pulumi.set(__self__, "peer_cluster_name", peer_cluster_name)
        if peer_ip_addresses is not None:
            pulumi.set(__self__, "peer_ip_addresses", peer_ip_addresses)
        if peer_svm_name is not None:
            pulumi.set(__self__, "peer_svm_name", peer_svm_name)
        if peer_volume_name is not None:
            pulumi.set(__self__, "peer_volume_name", peer_volume_name)
        if peering_command_expiry_time is not None:
            pulumi.set(__self__, "peering_command_expiry_time", peering_command_expiry_time)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)

    @_builtins.property
    @pulumi.getter(name="cacheConfig")
    def cache_config(self) -> Optional[pulumi.Input['VolumeCacheParametersCacheConfigArgs']]:
        """
        Optional. Configuration of the cache volume.
        Structure is documented below.
        """
        return pulumi.get(self, "cache_config")

    @cache_config.setter
    def cache_config(self, value: Optional[pulumi.Input['VolumeCacheParametersCacheConfigArgs']]):
        pulumi.set(self, "cache_config", value)

    @_builtins.property
    @pulumi.getter(name="cacheState")
    def cache_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        State of the cache volume indicating the peering status.
        """
        return pulumi.get(self, "cache_state")

    @cache_state.setter
    def cache_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_state", value)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter(name="enableGlobalFileLock")
    def enable_global_file_lock(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Field indicating whether cache volume as global file lock enabled.
        """
        return pulumi.get(self, "enable_global_file_lock")

    @enable_global_file_lock.setter
    def enable_global_file_lock(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_global_file_lock", value)

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Temporary passphrase generated to accept cluster peering command.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @_builtins.property
    @pulumi.getter(name="peerClusterName")
    def peer_cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Name of the origin volume's ONTAP cluster.
        """
        return pulumi.get(self, "peer_cluster_name")

    @peer_cluster_name.setter
    def peer_cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="peerIpAddresses")
    def peer_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required. List of IC LIF addresses of the origin volume's ONTAP cluster.
        """
        return pulumi.get(self, "peer_ip_addresses")

    @peer_ip_addresses.setter
    def peer_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "peer_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="peerSvmName")
    def peer_svm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Name of the origin volume's SVM.
        """
        return pulumi.get(self, "peer_svm_name")

    @peer_svm_name.setter
    def peer_svm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_svm_name", value)

    @_builtins.property
    @pulumi.getter(name="peerVolumeName")
    def peer_volume_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Name of the origin volume for the cache volume.
        """
        return pulumi.get(self, "peer_volume_name")

    @peer_volume_name.setter
    def peer_volume_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_volume_name", value)

    @_builtins.property
    @pulumi.getter(name="peeringCommandExpiryTime")
    def peering_command_expiry_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Expiration time for the peering command to be executed on user's ONTAP. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "peering_command_expiry_time")

    @peering_command_expiry_time.setter
    def peering_command_expiry_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_command_expiry_time", value)

    @_builtins.property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Detailed description of the current cache state.
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_details", value)


if not MYPY:
    class VolumeCacheParametersCacheConfigArgsDict(TypedDict):
        cifs_change_notify_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. Flag indicating whether a CIFS change notification is enabled for the FlexCache volume.
        """
elif False:
    VolumeCacheParametersCacheConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeCacheParametersCacheConfigArgs:
    def __init__(__self__, *,
                 cifs_change_notify_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] cifs_change_notify_enabled: Optional. Flag indicating whether a CIFS change notification is enabled for the FlexCache volume.
        """
        if cifs_change_notify_enabled is not None:
            pulumi.set(__self__, "cifs_change_notify_enabled", cifs_change_notify_enabled)

    @_builtins.property
    @pulumi.getter(name="cifsChangeNotifyEnabled")
    def cifs_change_notify_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Flag indicating whether a CIFS change notification is enabled for the FlexCache volume.
        """
        return pulumi.get(self, "cifs_change_notify_enabled")

    @cifs_change_notify_enabled.setter
    def cifs_change_notify_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cifs_change_notify_enabled", value)


if not MYPY:
    class VolumeExportPolicyArgsDict(TypedDict):
        rules: pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgsDict']]]
        """
        Export rules (up to 5) control NFS volume access.
        Structure is documented below.
        """
elif False:
    VolumeExportPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeExportPolicyArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]] rules: Export rules (up to 5) control NFS volume access.
               Structure is documented below.
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]:
        """
        Export rules (up to 5) control NFS volume access.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class VolumeExportPolicyRuleArgsDict(TypedDict):
        access_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Defines the access type for clients matching the `allowedClients` specification.
        Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        """
        allowed_clients: NotRequired[pulumi.Input[_builtins.str]]
        """
        Defines the client ingress specification (allowed clients) as a comma separated list with IPv4 CIDRs or IPv4 host addresses.
        """
        anon_uid: NotRequired[pulumi.Input[_builtins.int]]
        """
        An integer representing the anonymous user ID. Range is 0 to 4294967295. Required when `squash_mode` is `ALL_SQUASH`.
        """
        has_root_access: NotRequired[pulumi.Input[_builtins.str]]
        """
        If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        It's overwritten by the squash_mode parameter. Use either squash_mode or has_root_access.
        """
        kerberos5_read_only: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        """
        kerberos5_read_write: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        """
        kerberos5i_read_only: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        """
        kerberos5i_read_write: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        """
        kerberos5p_read_only: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        """
        kerberos5p_read_write: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        """
        nfsv3: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable to apply the export rule to NFSV3 clients.
        """
        nfsv4: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable to apply the export rule to NFSV4.1 clients.
        """
        squash_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        SquashMode defines how remote user privileges are restricted when accessing an NFS export. It controls how the user identities (like root) are mapped to anonymous users to limit access and enforce security.
        It overwrites the has_root_access parameter. Use either squash_mode or has_root_access. For ALL_SQUASH, access_type needs to be set to READ_WRITE.
        Possible values are: `SQUASH_MODE_UNSPECIFIED`, `NO_ROOT_SQUASH`, `ROOT_SQUASH`, `ALL_SQUASH`.
        """
elif False:
    VolumeExportPolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeExportPolicyRuleArgs:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_clients: Optional[pulumi.Input[_builtins.str]] = None,
                 anon_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 has_root_access: Optional[pulumi.Input[_builtins.str]] = None,
                 kerberos5_read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos5_read_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos5i_read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos5i_read_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos5p_read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos5p_read_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 nfsv3: Optional[pulumi.Input[_builtins.bool]] = None,
                 nfsv4: Optional[pulumi.Input[_builtins.bool]] = None,
                 squash_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] access_type: Defines the access type for clients matching the `allowedClients` specification.
               Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        :param pulumi.Input[_builtins.str] allowed_clients: Defines the client ingress specification (allowed clients) as a comma separated list with IPv4 CIDRs or IPv4 host addresses.
        :param pulumi.Input[_builtins.int] anon_uid: An integer representing the anonymous user ID. Range is 0 to 4294967295. Required when `squash_mode` is `ALL_SQUASH`.
        :param pulumi.Input[_builtins.str] has_root_access: If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
               It's overwritten by the squash_mode parameter. Use either squash_mode or has_root_access.
        :param pulumi.Input[_builtins.bool] kerberos5_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        :param pulumi.Input[_builtins.bool] kerberos5_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        :param pulumi.Input[_builtins.bool] kerberos5i_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        :param pulumi.Input[_builtins.bool] kerberos5i_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        :param pulumi.Input[_builtins.bool] kerberos5p_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        :param pulumi.Input[_builtins.bool] kerberos5p_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        :param pulumi.Input[_builtins.bool] nfsv3: Enable to apply the export rule to NFSV3 clients.
        :param pulumi.Input[_builtins.bool] nfsv4: Enable to apply the export rule to NFSV4.1 clients.
        :param pulumi.Input[_builtins.str] squash_mode: SquashMode defines how remote user privileges are restricted when accessing an NFS export. It controls how the user identities (like root) are mapped to anonymous users to limit access and enforce security.
               It overwrites the has_root_access parameter. Use either squash_mode or has_root_access. For ALL_SQUASH, access_type needs to be set to READ_WRITE.
               Possible values are: `SQUASH_MODE_UNSPECIFIED`, `NO_ROOT_SQUASH`, `ROOT_SQUASH`, `ALL_SQUASH`.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if anon_uid is not None:
            pulumi.set(__self__, "anon_uid", anon_uid)
        if has_root_access is not None:
            pulumi.set(__self__, "has_root_access", has_root_access)
        if kerberos5_read_only is not None:
            pulumi.set(__self__, "kerberos5_read_only", kerberos5_read_only)
        if kerberos5_read_write is not None:
            pulumi.set(__self__, "kerberos5_read_write", kerberos5_read_write)
        if kerberos5i_read_only is not None:
            pulumi.set(__self__, "kerberos5i_read_only", kerberos5i_read_only)
        if kerberos5i_read_write is not None:
            pulumi.set(__self__, "kerberos5i_read_write", kerberos5i_read_write)
        if kerberos5p_read_only is not None:
            pulumi.set(__self__, "kerberos5p_read_only", kerberos5p_read_only)
        if kerberos5p_read_write is not None:
            pulumi.set(__self__, "kerberos5p_read_write", kerberos5p_read_write)
        if nfsv3 is not None:
            pulumi.set(__self__, "nfsv3", nfsv3)
        if nfsv4 is not None:
            pulumi.set(__self__, "nfsv4", nfsv4)
        if squash_mode is not None:
            pulumi.set(__self__, "squash_mode", squash_mode)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the access type for clients matching the `allowedClients` specification.
        Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the client ingress specification (allowed clients) as a comma separated list with IPv4 CIDRs or IPv4 host addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_clients", value)

    @_builtins.property
    @pulumi.getter(name="anonUid")
    def anon_uid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer representing the anonymous user ID. Range is 0 to 4294967295. Required when `squash_mode` is `ALL_SQUASH`.
        """
        return pulumi.get(self, "anon_uid")

    @anon_uid.setter
    def anon_uid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "anon_uid", value)

    @_builtins.property
    @pulumi.getter(name="hasRootAccess")
    def has_root_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        It's overwritten by the squash_mode parameter. Use either squash_mode or has_root_access.
        """
        return pulumi.get(self, "has_root_access")

    @has_root_access.setter
    def has_root_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "has_root_access", value)

    @_builtins.property
    @pulumi.getter(name="kerberos5ReadOnly")
    def kerberos5_read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5_read_only")

    @kerberos5_read_only.setter
    def kerberos5_read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos5_read_only", value)

    @_builtins.property
    @pulumi.getter(name="kerberos5ReadWrite")
    def kerberos5_read_write(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5_read_write")

    @kerberos5_read_write.setter
    def kerberos5_read_write(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos5_read_write", value)

    @_builtins.property
    @pulumi.getter(name="kerberos5iReadOnly")
    def kerberos5i_read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5i_read_only")

    @kerberos5i_read_only.setter
    def kerberos5i_read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos5i_read_only", value)

    @_builtins.property
    @pulumi.getter(name="kerberos5iReadWrite")
    def kerberos5i_read_write(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5i_read_write")

    @kerberos5i_read_write.setter
    def kerberos5i_read_write(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos5i_read_write", value)

    @_builtins.property
    @pulumi.getter(name="kerberos5pReadOnly")
    def kerberos5p_read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5p_read_only")

    @kerberos5p_read_only.setter
    def kerberos5p_read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos5p_read_only", value)

    @_builtins.property
    @pulumi.getter(name="kerberos5pReadWrite")
    def kerberos5p_read_write(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5p_read_write")

    @kerberos5p_read_write.setter
    def kerberos5p_read_write(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos5p_read_write", value)

    @_builtins.property
    @pulumi.getter
    def nfsv3(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to apply the export rule to NFSV3 clients.
        """
        return pulumi.get(self, "nfsv3")

    @nfsv3.setter
    def nfsv3(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "nfsv3", value)

    @_builtins.property
    @pulumi.getter
    def nfsv4(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to apply the export rule to NFSV4.1 clients.
        """
        return pulumi.get(self, "nfsv4")

    @nfsv4.setter
    def nfsv4(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "nfsv4", value)

    @_builtins.property
    @pulumi.getter(name="squashMode")
    def squash_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SquashMode defines how remote user privileges are restricted when accessing an NFS export. It controls how the user identities (like root) are mapped to anonymous users to limit access and enforce security.
        It overwrites the has_root_access parameter. Use either squash_mode or has_root_access. For ALL_SQUASH, access_type needs to be set to READ_WRITE.
        Possible values are: `SQUASH_MODE_UNSPECIFIED`, `NO_ROOT_SQUASH`, `ROOT_SQUASH`, `ALL_SQUASH`.
        """
        return pulumi.get(self, "squash_mode")

    @squash_mode.setter
    def squash_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "squash_mode", value)


if not MYPY:
    class VolumeHybridReplicationParametersArgsDict(TypedDict):
        cluster_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Name of source cluster location associated with the Hybrid replication. This is a free-form field for the display purpose only.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Description of the replication.
        """
        hybrid_replication_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Type of the volume's hybrid replication.
        Possible values are: `MIGRATION`, `CONTINUOUS_REPLICATION`, `ONPREM_REPLICATION`, `REVERSE_ONPREM_REPLICATION`.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Optional. Labels to be added to the replication as the key value pairs.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        large_volume_constituent_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optional. Constituent volume count for large volume.
        """
        peer_cluster_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Required. Name of the user's local source cluster to be peered with the destination cluster.
        """
        peer_ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Required. List of node ip addresses to be peered with.
        """
        peer_svm_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Required. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        """
        peer_volume_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Required. Name of the user's local source volume to be peered with the destination volume.
        """
        replication: NotRequired[pulumi.Input[_builtins.str]]
        """
        Required. Desired name for the replication of this volume.
        """
        replication_schedule: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Replication Schedule for the replication created.
        Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        """
elif False:
    VolumeHybridReplicationParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeHybridReplicationParametersArgs:
    def __init__(__self__, *,
                 cluster_location: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_replication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 large_volume_constituent_count: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peer_svm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_schedule: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] cluster_location: Optional. Name of source cluster location associated with the Hybrid replication. This is a free-form field for the display purpose only.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the replication.
        :param pulumi.Input[_builtins.str] hybrid_replication_type: Optional. Type of the volume's hybrid replication.
               Possible values are: `MIGRATION`, `CONTINUOUS_REPLICATION`, `ONPREM_REPLICATION`, `REVERSE_ONPREM_REPLICATION`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to be added to the replication as the key value pairs.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[_builtins.int] large_volume_constituent_count: Optional. Constituent volume count for large volume.
        :param pulumi.Input[_builtins.str] peer_cluster_name: Required. Name of the user's local source cluster to be peered with the destination cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peer_ip_addresses: Required. List of node ip addresses to be peered with.
        :param pulumi.Input[_builtins.str] peer_svm_name: Required. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        :param pulumi.Input[_builtins.str] peer_volume_name: Required. Name of the user's local source volume to be peered with the destination volume.
        :param pulumi.Input[_builtins.str] replication: Required. Desired name for the replication of this volume.
        :param pulumi.Input[_builtins.str] replication_schedule: Optional. Replication Schedule for the replication created.
               Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        """
        if cluster_location is not None:
            pulumi.set(__self__, "cluster_location", cluster_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hybrid_replication_type is not None:
            pulumi.set(__self__, "hybrid_replication_type", hybrid_replication_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if large_volume_constituent_count is not None:
            pulumi.set(__self__, "large_volume_constituent_count", large_volume_constituent_count)
        if peer_cluster_name is not None:
            pulumi.set(__self__, "peer_cluster_name", peer_cluster_name)
        if peer_ip_addresses is not None:
            pulumi.set(__self__, "peer_ip_addresses", peer_ip_addresses)
        if peer_svm_name is not None:
            pulumi.set(__self__, "peer_svm_name", peer_svm_name)
        if peer_volume_name is not None:
            pulumi.set(__self__, "peer_volume_name", peer_volume_name)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if replication_schedule is not None:
            pulumi.set(__self__, "replication_schedule", replication_schedule)

    @_builtins.property
    @pulumi.getter(name="clusterLocation")
    def cluster_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Name of source cluster location associated with the Hybrid replication. This is a free-form field for the display purpose only.
        """
        return pulumi.get(self, "cluster_location")

    @cluster_location.setter
    def cluster_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_location", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Description of the replication.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hybridReplicationType")
    def hybrid_replication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Type of the volume's hybrid replication.
        Possible values are: `MIGRATION`, `CONTINUOUS_REPLICATION`, `ONPREM_REPLICATION`, `REVERSE_ONPREM_REPLICATION`.
        """
        return pulumi.get(self, "hybrid_replication_type")

    @hybrid_replication_type.setter
    def hybrid_replication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_replication_type", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels to be added to the replication as the key value pairs.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="largeVolumeConstituentCount")
    def large_volume_constituent_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. Constituent volume count for large volume.
        """
        return pulumi.get(self, "large_volume_constituent_count")

    @large_volume_constituent_count.setter
    def large_volume_constituent_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "large_volume_constituent_count", value)

    @_builtins.property
    @pulumi.getter(name="peerClusterName")
    def peer_cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Name of the user's local source cluster to be peered with the destination cluster.
        """
        return pulumi.get(self, "peer_cluster_name")

    @peer_cluster_name.setter
    def peer_cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="peerIpAddresses")
    def peer_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required. List of node ip addresses to be peered with.
        """
        return pulumi.get(self, "peer_ip_addresses")

    @peer_ip_addresses.setter
    def peer_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "peer_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="peerSvmName")
    def peer_svm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        """
        return pulumi.get(self, "peer_svm_name")

    @peer_svm_name.setter
    def peer_svm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_svm_name", value)

    @_builtins.property
    @pulumi.getter(name="peerVolumeName")
    def peer_volume_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Name of the user's local source volume to be peered with the destination volume.
        """
        return pulumi.get(self, "peer_volume_name")

    @peer_volume_name.setter
    def peer_volume_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_volume_name", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Desired name for the replication of this volume.
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Replication Schedule for the replication created.
        Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        """
        return pulumi.get(self, "replication_schedule")

    @replication_schedule.setter
    def replication_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_schedule", value)


if not MYPY:
    class VolumeMountOptionArgsDict(TypedDict):
        export: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Export path of the volume.
        """
        export_full: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Full export path of the volume.
        Format for NFS volumes: `<export_ip>:/<shareName>`
        Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        """
        instructions: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Human-readable mount instructions.
        """
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        IP Address.
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Protocol to mount with.
        """
elif False:
    VolumeMountOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeMountOptionArgs:
    def __init__(__self__, *,
                 export: Optional[pulumi.Input[_builtins.str]] = None,
                 export_full: Optional[pulumi.Input[_builtins.str]] = None,
                 instructions: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] export: (Output)
               Export path of the volume.
        :param pulumi.Input[_builtins.str] export_full: (Output)
               Full export path of the volume.
               Format for NFS volumes: `<export_ip>:/<shareName>`
               Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        :param pulumi.Input[_builtins.str] instructions: (Output)
               Human-readable mount instructions.
        :param pulumi.Input[_builtins.str] ip_address: (Output)
               IP Address.
        :param pulumi.Input[_builtins.str] protocol: (Output)
               Protocol to mount with.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if export_full is not None:
            pulumi.set(__self__, "export_full", export_full)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Export path of the volume.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export", value)

    @_builtins.property
    @pulumi.getter(name="exportFull")
    def export_full(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Full export path of the volume.
        Format for NFS volumes: `<export_ip>:/<shareName>`
        Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        """
        return pulumi.get(self, "export_full")

    @export_full.setter
    def export_full(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_full", value)

    @_builtins.property
    @pulumi.getter
    def instructions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Human-readable mount instructions.
        """
        return pulumi.get(self, "instructions")

    @instructions.setter
    def instructions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instructions", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Protocol to mount with.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class VolumeReplicationDestinationVolumeParametersArgsDict(TypedDict):
        storage_pool: pulumi.Input[_builtins.str]
        """
        Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description for the destination volume.
        """
        share_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Share name for destination volume. If not specified, name of source volume's share name will be used.
        """
        tiering_policy: NotRequired[pulumi.Input['VolumeReplicationDestinationVolumeParametersTieringPolicyArgsDict']]
        """
        Tiering policy for the volume.
        Structure is documented below.
        """
        volume_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
elif False:
    VolumeReplicationDestinationVolumeParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeReplicationDestinationVolumeParametersArgs:
    def __init__(__self__, *,
                 storage_pool: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tiering_policy: Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersTieringPolicyArgs']] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] storage_pool: Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        :param pulumi.Input[_builtins.str] description: Description for the destination volume.
        :param pulumi.Input[_builtins.str] share_name: Share name for destination volume. If not specified, name of source volume's share name will be used.
        :param pulumi.Input['VolumeReplicationDestinationVolumeParametersTieringPolicyArgs'] tiering_policy: Tiering policy for the volume.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] volume_id: Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        pulumi.set(__self__, "storage_pool", storage_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> pulumi.Input[_builtins.str]:
        """
        Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        """
        return pulumi.get(self, "storage_pool")

    @storage_pool.setter
    def storage_pool(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_pool", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the destination volume.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share name for destination volume. If not specified, name of source volume's share name will be used.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_name", value)

    @_builtins.property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersTieringPolicyArgs']]:
        """
        Tiering policy for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


if not MYPY:
    class VolumeReplicationDestinationVolumeParametersTieringPolicyArgsDict(TypedDict):
        cooling_threshold_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
        Default is 31.
        """
        tier_action: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
elif False:
    VolumeReplicationDestinationVolumeParametersTieringPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeReplicationDestinationVolumeParametersTieringPolicyArgs:
    def __init__(__self__, *,
                 cooling_threshold_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tier_action: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] cooling_threshold_days: Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
               Default is 31.
        :param pulumi.Input[_builtins.str] tier_action: Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
               Default value is `PAUSED`.
               Possible values are: `ENABLED`, `PAUSED`.
        """
        if cooling_threshold_days is not None:
            pulumi.set(__self__, "cooling_threshold_days", cooling_threshold_days)
        if tier_action is not None:
            pulumi.set(__self__, "tier_action", tier_action)

    @_builtins.property
    @pulumi.getter(name="coolingThresholdDays")
    def cooling_threshold_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
        Default is 31.
        """
        return pulumi.get(self, "cooling_threshold_days")

    @cooling_threshold_days.setter
    def cooling_threshold_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cooling_threshold_days", value)

    @_builtins.property
    @pulumi.getter(name="tierAction")
    def tier_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
        return pulumi.get(self, "tier_action")

    @tier_action.setter
    def tier_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier_action", value)


if not MYPY:
    class VolumeReplicationHybridPeeringDetailArgsDict(TypedDict):
        command: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Optional. Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        """
        command_expiry_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Optional. Expiration time for the peering command to be executed on user's ONTAP.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        """
        passphrase: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Optional. Temporary passphrase generated to accept cluster peering command.
        """
        peer_cluster_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Optional. Name of the user's local source cluster to be peered with the destination cluster.
        """
        peer_svm_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Optional. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        """
        peer_volume_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Optional. Name of the user's local source volume to be peered with the destination volume.
        """
        subnet_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Optional. IP address of the subnet.
        """
elif False:
    VolumeReplicationHybridPeeringDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeReplicationHybridPeeringDetailArgs:
    def __init__(__self__, *,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 command_expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_svm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] command: (Output)
               Optional. Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        :param pulumi.Input[_builtins.str] command_expiry_time: (Output)
               Optional. Expiration time for the peering command to be executed on user's ONTAP.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        :param pulumi.Input[_builtins.str] passphrase: (Output)
               Optional. Temporary passphrase generated to accept cluster peering command.
        :param pulumi.Input[_builtins.str] peer_cluster_name: (Output)
               Optional. Name of the user's local source cluster to be peered with the destination cluster.
        :param pulumi.Input[_builtins.str] peer_svm_name: (Output)
               Optional. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        :param pulumi.Input[_builtins.str] peer_volume_name: (Output)
               Optional. Name of the user's local source volume to be peered with the destination volume.
        :param pulumi.Input[_builtins.str] subnet_ip: (Output)
               Optional. IP address of the subnet.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if command_expiry_time is not None:
            pulumi.set(__self__, "command_expiry_time", command_expiry_time)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if peer_cluster_name is not None:
            pulumi.set(__self__, "peer_cluster_name", peer_cluster_name)
        if peer_svm_name is not None:
            pulumi.set(__self__, "peer_svm_name", peer_svm_name)
        if peer_volume_name is not None:
            pulumi.set(__self__, "peer_volume_name", peer_volume_name)
        if subnet_ip is not None:
            pulumi.set(__self__, "subnet_ip", subnet_ip)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Optional. Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter(name="commandExpiryTime")
    def command_expiry_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Optional. Expiration time for the peering command to be executed on user's ONTAP.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        """
        return pulumi.get(self, "command_expiry_time")

    @command_expiry_time.setter
    def command_expiry_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command_expiry_time", value)

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Optional. Temporary passphrase generated to accept cluster peering command.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @_builtins.property
    @pulumi.getter(name="peerClusterName")
    def peer_cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Optional. Name of the user's local source cluster to be peered with the destination cluster.
        """
        return pulumi.get(self, "peer_cluster_name")

    @peer_cluster_name.setter
    def peer_cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="peerSvmName")
    def peer_svm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Optional. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        """
        return pulumi.get(self, "peer_svm_name")

    @peer_svm_name.setter
    def peer_svm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_svm_name", value)

    @_builtins.property
    @pulumi.getter(name="peerVolumeName")
    def peer_volume_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Optional. Name of the user's local source volume to be peered with the destination volume.
        """
        return pulumi.get(self, "peer_volume_name")

    @peer_volume_name.setter
    def peer_volume_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_volume_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetIp")
    def subnet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Optional. IP address of the subnet.
        """
        return pulumi.get(self, "subnet_ip")

    @subnet_ip.setter
    def subnet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_ip", value)


if not MYPY:
    class VolumeReplicationHybridReplicationUserCommandArgsDict(TypedDict):
        commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        (Output)
        List of commands to be executed by the customer.
        """
elif False:
    VolumeReplicationHybridReplicationUserCommandArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeReplicationHybridReplicationUserCommandArgs:
    def __init__(__self__, *,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: (Output)
               List of commands to be executed by the customer.
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Output)
        List of commands to be executed by the customer.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "commands", value)


if not MYPY:
    class VolumeReplicationTransferStatArgsDict(TypedDict):
        lag_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        The elapsed time since the creation of the snapshot on the source volume that was last replicated
        to the destination volume. Lag time represents the difference in age of the destination volume
        data in relation to the source volume data.
        """
        last_transfer_bytes: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Size of last completed transfer in bytes.
        """
        last_transfer_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Time taken during last completed transfer.
        """
        last_transfer_end_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        last_transfer_error: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        A message describing the cause of the last transfer failure.
        """
        total_transfer_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Cumulative time taken across all transfers for the replication relationship.
        """
        transfer_bytes: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Cumulative bytes transferred so far for the replication relationship.
        """
        update_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
elif False:
    VolumeReplicationTransferStatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeReplicationTransferStatArgs:
    def __init__(__self__, *,
                 lag_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 last_transfer_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 last_transfer_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 last_transfer_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_transfer_error: Optional[pulumi.Input[_builtins.str]] = None,
                 total_transfer_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 transfer_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] lag_duration: (Output)
               The elapsed time since the creation of the snapshot on the source volume that was last replicated
               to the destination volume. Lag time represents the difference in age of the destination volume
               data in relation to the source volume data.
        :param pulumi.Input[_builtins.str] last_transfer_bytes: (Output)
               Size of last completed transfer in bytes.
        :param pulumi.Input[_builtins.str] last_transfer_duration: (Output)
               Time taken during last completed transfer.
        :param pulumi.Input[_builtins.str] last_transfer_end_time: (Output)
               Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[_builtins.str] last_transfer_error: (Output)
               A message describing the cause of the last transfer failure.
        :param pulumi.Input[_builtins.str] total_transfer_duration: (Output)
               Cumulative time taken across all transfers for the replication relationship.
        :param pulumi.Input[_builtins.str] transfer_bytes: (Output)
               Cumulative bytes transferred so far for the replication relationship.
        :param pulumi.Input[_builtins.str] update_time: (Output)
               Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        if lag_duration is not None:
            pulumi.set(__self__, "lag_duration", lag_duration)
        if last_transfer_bytes is not None:
            pulumi.set(__self__, "last_transfer_bytes", last_transfer_bytes)
        if last_transfer_duration is not None:
            pulumi.set(__self__, "last_transfer_duration", last_transfer_duration)
        if last_transfer_end_time is not None:
            pulumi.set(__self__, "last_transfer_end_time", last_transfer_end_time)
        if last_transfer_error is not None:
            pulumi.set(__self__, "last_transfer_error", last_transfer_error)
        if total_transfer_duration is not None:
            pulumi.set(__self__, "total_transfer_duration", total_transfer_duration)
        if transfer_bytes is not None:
            pulumi.set(__self__, "transfer_bytes", transfer_bytes)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="lagDuration")
    def lag_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The elapsed time since the creation of the snapshot on the source volume that was last replicated
        to the destination volume. Lag time represents the difference in age of the destination volume
        data in relation to the source volume data.
        """
        return pulumi.get(self, "lag_duration")

    @lag_duration.setter
    def lag_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lag_duration", value)

    @_builtins.property
    @pulumi.getter(name="lastTransferBytes")
    def last_transfer_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Size of last completed transfer in bytes.
        """
        return pulumi.get(self, "last_transfer_bytes")

    @last_transfer_bytes.setter
    def last_transfer_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_transfer_bytes", value)

    @_builtins.property
    @pulumi.getter(name="lastTransferDuration")
    def last_transfer_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Time taken during last completed transfer.
        """
        return pulumi.get(self, "last_transfer_duration")

    @last_transfer_duration.setter
    def last_transfer_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_transfer_duration", value)

    @_builtins.property
    @pulumi.getter(name="lastTransferEndTime")
    def last_transfer_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "last_transfer_end_time")

    @last_transfer_end_time.setter
    def last_transfer_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_transfer_end_time", value)

    @_builtins.property
    @pulumi.getter(name="lastTransferError")
    def last_transfer_error(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        A message describing the cause of the last transfer failure.
        """
        return pulumi.get(self, "last_transfer_error")

    @last_transfer_error.setter
    def last_transfer_error(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_transfer_error", value)

    @_builtins.property
    @pulumi.getter(name="totalTransferDuration")
    def total_transfer_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Cumulative time taken across all transfers for the replication relationship.
        """
        return pulumi.get(self, "total_transfer_duration")

    @total_transfer_duration.setter
    def total_transfer_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "total_transfer_duration", value)

    @_builtins.property
    @pulumi.getter(name="transferBytes")
    def transfer_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Cumulative bytes transferred so far for the replication relationship.
        """
        return pulumi.get(self, "transfer_bytes")

    @transfer_bytes.setter
    def transfer_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transfer_bytes", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


if not MYPY:
    class VolumeRestoreParametersArgsDict(TypedDict):
        source_backup: NotRequired[pulumi.Input[_builtins.str]]
        """
        Full name of the backup to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        """
        source_snapshot: NotRequired[pulumi.Input[_builtins.str]]
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
elif False:
    VolumeRestoreParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeRestoreParametersArgs:
    def __init__(__self__, *,
                 source_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] source_backup: Full name of the backup to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        :param pulumi.Input[_builtins.str] source_snapshot: Full name of the snapshot to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        if source_backup is not None:
            pulumi.set(__self__, "source_backup", source_backup)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)

    @_builtins.property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full name of the backup to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        """
        return pulumi.get(self, "source_backup")

    @source_backup.setter
    def source_backup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_backup", value)

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_snapshot", value)


if not MYPY:
    class VolumeSnapshotPolicyArgsDict(TypedDict):
        daily_schedule: NotRequired[pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgsDict']]
        """
        Daily schedule policy.
        Structure is documented below.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables automated snapshot creation according to defined schedule. Default is false.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        """
        hourly_schedule: NotRequired[pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgsDict']]
        """
        Hourly schedule policy.
        Structure is documented below.
        """
        monthly_schedule: NotRequired[pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgsDict']]
        """
        Monthly schedule policy.
        Structure is documented below.
        """
        weekly_schedule: NotRequired[pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgsDict']]
        """
        Weekly schedule policy.
        Structure is documented below.
        """
elif False:
    VolumeSnapshotPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyArgs:
    def __init__(__self__, *,
                 daily_schedule: Optional[pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hourly_schedule: Optional[pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgs']] = None,
                 monthly_schedule: Optional[pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgs']] = None,
                 weekly_schedule: Optional[pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgs']] = None):
        """
        :param pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgs'] daily_schedule: Daily schedule policy.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enabled: Enables automated snapshot creation according to defined schedule. Default is false.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        :param pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgs'] hourly_schedule: Hourly schedule policy.
               Structure is documented below.
        :param pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgs'] monthly_schedule: Monthly schedule policy.
               Structure is documented below.
        :param pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgs'] weekly_schedule: Weekly schedule policy.
               Structure is documented below.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @_builtins.property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgs']]:
        """
        Daily schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "daily_schedule")

    @daily_schedule.setter
    def daily_schedule(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgs']]):
        pulumi.set(self, "daily_schedule", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables automated snapshot creation according to defined schedule. Default is false.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgs']]:
        """
        Hourly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "hourly_schedule")

    @hourly_schedule.setter
    def hourly_schedule(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgs']]):
        pulumi.set(self, "hourly_schedule", value)

    @_builtins.property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgs']]:
        """
        Monthly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "monthly_schedule")

    @monthly_schedule.setter
    def monthly_schedule(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgs']]):
        pulumi.set(self, "monthly_schedule", value)

    @_builtins.property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgs']]:
        """
        Weekly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")

    @weekly_schedule.setter
    def weekly_schedule(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgs']]):
        pulumi.set(self, "weekly_schedule", value)


if not MYPY:
    class VolumeSnapshotPolicyDailyScheduleArgsDict(TypedDict):
        snapshots_to_keep: pulumi.Input[_builtins.int]
        """
        The maximum number of snapshots to keep for the daily schedule.
        """
        hour: NotRequired[pulumi.Input[_builtins.int]]
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        minute: NotRequired[pulumi.Input[_builtins.int]]
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
elif False:
    VolumeSnapshotPolicyDailyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyDailyScheduleArgs:
    def __init__(__self__, *,
                 snapshots_to_keep: pulumi.Input[_builtins.int],
                 hour: Optional[pulumi.Input[_builtins.int]] = None,
                 minute: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] snapshots_to_keep: The maximum number of snapshots to keep for the daily schedule.
        :param pulumi.Input[_builtins.int] hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param pulumi.Input[_builtins.int] minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @_builtins.property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum number of snapshots to keep for the daily schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "snapshots_to_keep", value)

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour", value)

    @_builtins.property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minute", value)


if not MYPY:
    class VolumeSnapshotPolicyHourlyScheduleArgsDict(TypedDict):
        snapshots_to_keep: pulumi.Input[_builtins.int]
        """
        The maximum number of snapshots to keep for the hourly schedule.
        """
        minute: NotRequired[pulumi.Input[_builtins.int]]
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
elif False:
    VolumeSnapshotPolicyHourlyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyHourlyScheduleArgs:
    def __init__(__self__, *,
                 snapshots_to_keep: pulumi.Input[_builtins.int],
                 minute: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] snapshots_to_keep: The maximum number of snapshots to keep for the hourly schedule.
        :param pulumi.Input[_builtins.int] minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @_builtins.property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum number of snapshots to keep for the hourly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "snapshots_to_keep", value)

    @_builtins.property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minute", value)


if not MYPY:
    class VolumeSnapshotPolicyMonthlyScheduleArgsDict(TypedDict):
        snapshots_to_keep: pulumi.Input[_builtins.int]
        """
        The maximum number of snapshots to keep for the monthly schedule
        """
        days_of_month: NotRequired[pulumi.Input[_builtins.str]]
        """
        Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        """
        hour: NotRequired[pulumi.Input[_builtins.int]]
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        minute: NotRequired[pulumi.Input[_builtins.int]]
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
elif False:
    VolumeSnapshotPolicyMonthlyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyMonthlyScheduleArgs:
    def __init__(__self__, *,
                 snapshots_to_keep: pulumi.Input[_builtins.int],
                 days_of_month: Optional[pulumi.Input[_builtins.str]] = None,
                 hour: Optional[pulumi.Input[_builtins.int]] = None,
                 minute: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] snapshots_to_keep: The maximum number of snapshots to keep for the monthly schedule
        :param pulumi.Input[_builtins.str] days_of_month: Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        :param pulumi.Input[_builtins.int] hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param pulumi.Input[_builtins.int] minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if days_of_month is not None:
            pulumi.set(__self__, "days_of_month", days_of_month)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @_builtins.property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum number of snapshots to keep for the monthly schedule
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "snapshots_to_keep", value)

    @_builtins.property
    @pulumi.getter(name="daysOfMonth")
    def days_of_month(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        """
        return pulumi.get(self, "days_of_month")

    @days_of_month.setter
    def days_of_month(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "days_of_month", value)

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour", value)

    @_builtins.property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minute", value)


if not MYPY:
    class VolumeSnapshotPolicyWeeklyScheduleArgsDict(TypedDict):
        snapshots_to_keep: pulumi.Input[_builtins.int]
        """
        The maximum number of snapshots to keep for the weekly schedule.
        """
        day: NotRequired[pulumi.Input[_builtins.str]]
        """
        Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        """
        hour: NotRequired[pulumi.Input[_builtins.int]]
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        minute: NotRequired[pulumi.Input[_builtins.int]]
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
elif False:
    VolumeSnapshotPolicyWeeklyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyWeeklyScheduleArgs:
    def __init__(__self__, *,
                 snapshots_to_keep: pulumi.Input[_builtins.int],
                 day: Optional[pulumi.Input[_builtins.str]] = None,
                 hour: Optional[pulumi.Input[_builtins.int]] = None,
                 minute: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] snapshots_to_keep: The maximum number of snapshots to keep for the weekly schedule.
        :param pulumi.Input[_builtins.str] day: Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        :param pulumi.Input[_builtins.int] hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param pulumi.Input[_builtins.int] minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @_builtins.property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum number of snapshots to keep for the weekly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "snapshots_to_keep", value)

    @_builtins.property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "day", value)

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour", value)

    @_builtins.property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minute", value)


if not MYPY:
    class VolumeTieringPolicyArgsDict(TypedDict):
        cooling_threshold_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
        Default is 31.
        """
        hot_tier_bypass_mode_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. Flag indicating that the hot tier bypass mode is enabled. Default is false.
        Only applicable to Flex service level.
        """
        tier_action: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
elif False:
    VolumeTieringPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeTieringPolicyArgs:
    def __init__(__self__, *,
                 cooling_threshold_days: Optional[pulumi.Input[_builtins.int]] = None,
                 hot_tier_bypass_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tier_action: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] cooling_threshold_days: Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
               Default is 31.
        :param pulumi.Input[_builtins.bool] hot_tier_bypass_mode_enabled: Optional. Flag indicating that the hot tier bypass mode is enabled. Default is false.
               Only applicable to Flex service level.
        :param pulumi.Input[_builtins.str] tier_action: Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
               Default value is `PAUSED`.
               Possible values are: `ENABLED`, `PAUSED`.
        """
        if cooling_threshold_days is not None:
            pulumi.set(__self__, "cooling_threshold_days", cooling_threshold_days)
        if hot_tier_bypass_mode_enabled is not None:
            pulumi.set(__self__, "hot_tier_bypass_mode_enabled", hot_tier_bypass_mode_enabled)
        if tier_action is not None:
            pulumi.set(__self__, "tier_action", tier_action)

    @_builtins.property
    @pulumi.getter(name="coolingThresholdDays")
    def cooling_threshold_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
        Default is 31.
        """
        return pulumi.get(self, "cooling_threshold_days")

    @cooling_threshold_days.setter
    def cooling_threshold_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cooling_threshold_days", value)

    @_builtins.property
    @pulumi.getter(name="hotTierBypassModeEnabled")
    def hot_tier_bypass_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Flag indicating that the hot tier bypass mode is enabled. Default is false.
        Only applicable to Flex service level.
        """
        return pulumi.get(self, "hot_tier_bypass_mode_enabled")

    @hot_tier_bypass_mode_enabled.setter
    def hot_tier_bypass_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hot_tier_bypass_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tierAction")
    def tier_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
        return pulumi.get(self, "tier_action")

    @tier_action.setter
    def tier_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier_action", value)


