# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupVaultBackupRetentionPolicy',
    'VolumeBackupConfig',
    'VolumeBlockDevice',
    'VolumeCacheParameters',
    'VolumeCacheParametersCacheConfig',
    'VolumeExportPolicy',
    'VolumeExportPolicyRule',
    'VolumeHybridReplicationParameters',
    'VolumeMountOption',
    'VolumeReplicationDestinationVolumeParameters',
    'VolumeReplicationDestinationVolumeParametersTieringPolicy',
    'VolumeReplicationHybridPeeringDetail',
    'VolumeReplicationHybridReplicationUserCommand',
    'VolumeReplicationTransferStat',
    'VolumeRestoreParameters',
    'VolumeSnapshotPolicy',
    'VolumeSnapshotPolicyDailySchedule',
    'VolumeSnapshotPolicyHourlySchedule',
    'VolumeSnapshotPolicyMonthlySchedule',
    'VolumeSnapshotPolicyWeeklySchedule',
    'VolumeTieringPolicy',
]

@pulumi.output_type
class BackupVaultBackupRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupMinimumEnforcedRetentionDays":
            suggest = "backup_minimum_enforced_retention_days"
        elif key == "dailyBackupImmutable":
            suggest = "daily_backup_immutable"
        elif key == "manualBackupImmutable":
            suggest = "manual_backup_immutable"
        elif key == "monthlyBackupImmutable":
            suggest = "monthly_backup_immutable"
        elif key == "weeklyBackupImmutable":
            suggest = "weekly_backup_immutable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupVaultBackupRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupVaultBackupRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupVaultBackupRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_minimum_enforced_retention_days: _builtins.int,
                 daily_backup_immutable: Optional[_builtins.bool] = None,
                 manual_backup_immutable: Optional[_builtins.bool] = None,
                 monthly_backup_immutable: Optional[_builtins.bool] = None,
                 weekly_backup_immutable: Optional[_builtins.bool] = None):
        """
        :param _builtins.int backup_minimum_enforced_retention_days: Minimum retention duration in days for backups in the backup vault.
        :param _builtins.bool daily_backup_immutable: Indicates if the daily backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param _builtins.bool manual_backup_immutable: Indicates if the manual backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param _builtins.bool monthly_backup_immutable: Indicates if the monthly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param _builtins.bool weekly_backup_immutable: Indicates if the weekly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        pulumi.set(__self__, "backup_minimum_enforced_retention_days", backup_minimum_enforced_retention_days)
        if daily_backup_immutable is not None:
            pulumi.set(__self__, "daily_backup_immutable", daily_backup_immutable)
        if manual_backup_immutable is not None:
            pulumi.set(__self__, "manual_backup_immutable", manual_backup_immutable)
        if monthly_backup_immutable is not None:
            pulumi.set(__self__, "monthly_backup_immutable", monthly_backup_immutable)
        if weekly_backup_immutable is not None:
            pulumi.set(__self__, "weekly_backup_immutable", weekly_backup_immutable)

    @_builtins.property
    @pulumi.getter(name="backupMinimumEnforcedRetentionDays")
    def backup_minimum_enforced_retention_days(self) -> _builtins.int:
        """
        Minimum retention duration in days for backups in the backup vault.
        """
        return pulumi.get(self, "backup_minimum_enforced_retention_days")

    @_builtins.property
    @pulumi.getter(name="dailyBackupImmutable")
    def daily_backup_immutable(self) -> Optional[_builtins.bool]:
        """
        Indicates if the daily backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "daily_backup_immutable")

    @_builtins.property
    @pulumi.getter(name="manualBackupImmutable")
    def manual_backup_immutable(self) -> Optional[_builtins.bool]:
        """
        Indicates if the manual backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "manual_backup_immutable")

    @_builtins.property
    @pulumi.getter(name="monthlyBackupImmutable")
    def monthly_backup_immutable(self) -> Optional[_builtins.bool]:
        """
        Indicates if the monthly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "monthly_backup_immutable")

    @_builtins.property
    @pulumi.getter(name="weeklyBackupImmutable")
    def weekly_backup_immutable(self) -> Optional[_builtins.bool]:
        """
        Indicates if the weekly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "weekly_backup_immutable")


@pulumi.output_type
class VolumeBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupPolicies":
            suggest = "backup_policies"
        elif key == "backupVault":
            suggest = "backup_vault"
        elif key == "scheduledBackupEnabled":
            suggest = "scheduled_backup_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_policies: Optional[Sequence[_builtins.str]] = None,
                 backup_vault: Optional[_builtins.str] = None,
                 scheduled_backup_enabled: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] backup_policies: Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        :param _builtins.str backup_vault: ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
               Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        :param _builtins.bool scheduled_backup_enabled: When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        if backup_policies is not None:
            pulumi.set(__self__, "backup_policies", backup_policies)
        if backup_vault is not None:
            pulumi.set(__self__, "backup_vault", backup_vault)
        if scheduled_backup_enabled is not None:
            pulumi.set(__self__, "scheduled_backup_enabled", scheduled_backup_enabled)

    @_builtins.property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        """
        return pulumi.get(self, "backup_policies")

    @_builtins.property
    @pulumi.getter(name="backupVault")
    def backup_vault(self) -> Optional[_builtins.str]:
        """
        ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
        Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        """
        return pulumi.get(self, "backup_vault")

    @_builtins.property
    @pulumi.getter(name="scheduledBackupEnabled")
    def scheduled_backup_enabled(self) -> Optional[_builtins.bool]:
        """
        When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        return pulumi.get(self, "scheduled_backup_enabled")


@pulumi.output_type
class VolumeBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "hostGroups":
            suggest = "host_groups"
        elif key == "sizeGib":
            suggest = "size_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: _builtins.str,
                 host_groups: Optional[Sequence[_builtins.str]] = None,
                 identifier: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 size_gib: Optional[_builtins.int] = None):
        """
        :param _builtins.str os_type: The OS type of the volume.
               This field can't be changed after the block device is created.
               Possible values are: `LINUX`, `WINDOWS`, `ESXI`.
        :param Sequence[_builtins.str] host_groups: A list of host groups that identify hosts that can mount the block volume.
               Format:
               `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
               This field can be updated after the block device is created.
        :param _builtins.str identifier: (Output)
               Device identifier of the Block volume. This represents lun_serial_number
               for ISCSI volumes
        :param _builtins.str name: User-defined name for the block device, unique within the Volume. In case
               no user input is provided, name will be autogenerated in the backend.
               The name must meet the following requirements:
               *   Be between 1 and 255 characters long.
               *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
               and the following special characters: "-", "_", "}", "{", ".".
               *   Spaces are not allowed.
        :param _builtins.int size_gib: (Output)
               The size of the block device in GiB.
               Any value provided in this field during Volume creation is IGNORED.
               The block device's size is system-managed and will be set to match
               the parent Volume's `capacity_gib`.
        """
        pulumi.set(__self__, "os_type", os_type)
        if host_groups is not None:
            pulumi.set(__self__, "host_groups", host_groups)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size_gib is not None:
            pulumi.set(__self__, "size_gib", size_gib)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        The OS type of the volume.
        This field can't be changed after the block device is created.
        Possible values are: `LINUX`, `WINDOWS`, `ESXI`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="hostGroups")
    def host_groups(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of host groups that identify hosts that can mount the block volume.
        Format:
        `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
        This field can be updated after the block device is created.
        """
        return pulumi.get(self, "host_groups")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[_builtins.str]:
        """
        (Output)
        Device identifier of the Block volume. This represents lun_serial_number
        for ISCSI volumes
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        User-defined name for the block device, unique within the Volume. In case
        no user input is provided, name will be autogenerated in the backend.
        The name must meet the following requirements:
        *   Be between 1 and 255 characters long.
        *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
        and the following special characters: "-", "_", "}", "{", ".".
        *   Spaces are not allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sizeGib")
    def size_gib(self) -> Optional[_builtins.int]:
        """
        (Output)
        The size of the block device in GiB.
        Any value provided in this field during Volume creation is IGNORED.
        The block device's size is system-managed and will be set to match
        the parent Volume's `capacity_gib`.
        """
        return pulumi.get(self, "size_gib")


@pulumi.output_type
class VolumeCacheParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheConfig":
            suggest = "cache_config"
        elif key == "cacheState":
            suggest = "cache_state"
        elif key == "enableGlobalFileLock":
            suggest = "enable_global_file_lock"
        elif key == "peerClusterName":
            suggest = "peer_cluster_name"
        elif key == "peerIpAddresses":
            suggest = "peer_ip_addresses"
        elif key == "peerSvmName":
            suggest = "peer_svm_name"
        elif key == "peerVolumeName":
            suggest = "peer_volume_name"
        elif key == "peeringCommandExpiryTime":
            suggest = "peering_command_expiry_time"
        elif key == "stateDetails":
            suggest = "state_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeCacheParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeCacheParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeCacheParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_config: Optional['outputs.VolumeCacheParametersCacheConfig'] = None,
                 cache_state: Optional[_builtins.str] = None,
                 command: Optional[_builtins.str] = None,
                 enable_global_file_lock: Optional[_builtins.bool] = None,
                 passphrase: Optional[_builtins.str] = None,
                 peer_cluster_name: Optional[_builtins.str] = None,
                 peer_ip_addresses: Optional[Sequence[_builtins.str]] = None,
                 peer_svm_name: Optional[_builtins.str] = None,
                 peer_volume_name: Optional[_builtins.str] = None,
                 peering_command_expiry_time: Optional[_builtins.str] = None,
                 state_details: Optional[_builtins.str] = None):
        """
        :param 'VolumeCacheParametersCacheConfigArgs' cache_config: Optional. Configuration of the cache volume.
               Structure is documented below.
        :param _builtins.str cache_state: (Output)
               State of the cache volume indicating the peering status.
        :param _builtins.str command: (Output)
               Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        :param _builtins.bool enable_global_file_lock: Optional. Field indicating whether cache volume as global file lock enabled.
        :param _builtins.str passphrase: (Output)
               Temporary passphrase generated to accept cluster peering command.
        :param _builtins.str peer_cluster_name: Required. Name of the origin volume's ONTAP cluster.
        :param Sequence[_builtins.str] peer_ip_addresses: Required. List of IC LIF addresses of the origin volume's ONTAP cluster.
        :param _builtins.str peer_svm_name: Required. Name of the origin volume's SVM.
        :param _builtins.str peer_volume_name: Required. Name of the origin volume for the cache volume.
        :param _builtins.str peering_command_expiry_time: Optional. Expiration time for the peering command to be executed on user's ONTAP. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param _builtins.str state_details: (Output)
               Detailed description of the current cache state.
        """
        if cache_config is not None:
            pulumi.set(__self__, "cache_config", cache_config)
        if cache_state is not None:
            pulumi.set(__self__, "cache_state", cache_state)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if enable_global_file_lock is not None:
            pulumi.set(__self__, "enable_global_file_lock", enable_global_file_lock)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if peer_cluster_name is not None:
            pulumi.set(__self__, "peer_cluster_name", peer_cluster_name)
        if peer_ip_addresses is not None:
            pulumi.set(__self__, "peer_ip_addresses", peer_ip_addresses)
        if peer_svm_name is not None:
            pulumi.set(__self__, "peer_svm_name", peer_svm_name)
        if peer_volume_name is not None:
            pulumi.set(__self__, "peer_volume_name", peer_volume_name)
        if peering_command_expiry_time is not None:
            pulumi.set(__self__, "peering_command_expiry_time", peering_command_expiry_time)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)

    @_builtins.property
    @pulumi.getter(name="cacheConfig")
    def cache_config(self) -> Optional['outputs.VolumeCacheParametersCacheConfig']:
        """
        Optional. Configuration of the cache volume.
        Structure is documented below.
        """
        return pulumi.get(self, "cache_config")

    @_builtins.property
    @pulumi.getter(name="cacheState")
    def cache_state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the cache volume indicating the peering status.
        """
        return pulumi.get(self, "cache_state")

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[_builtins.str]:
        """
        (Output)
        Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter(name="enableGlobalFileLock")
    def enable_global_file_lock(self) -> Optional[_builtins.bool]:
        """
        Optional. Field indicating whether cache volume as global file lock enabled.
        """
        return pulumi.get(self, "enable_global_file_lock")

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[_builtins.str]:
        """
        (Output)
        Temporary passphrase generated to accept cluster peering command.
        """
        return pulumi.get(self, "passphrase")

    @_builtins.property
    @pulumi.getter(name="peerClusterName")
    def peer_cluster_name(self) -> Optional[_builtins.str]:
        """
        Required. Name of the origin volume's ONTAP cluster.
        """
        return pulumi.get(self, "peer_cluster_name")

    @_builtins.property
    @pulumi.getter(name="peerIpAddresses")
    def peer_ip_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Required. List of IC LIF addresses of the origin volume's ONTAP cluster.
        """
        return pulumi.get(self, "peer_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="peerSvmName")
    def peer_svm_name(self) -> Optional[_builtins.str]:
        """
        Required. Name of the origin volume's SVM.
        """
        return pulumi.get(self, "peer_svm_name")

    @_builtins.property
    @pulumi.getter(name="peerVolumeName")
    def peer_volume_name(self) -> Optional[_builtins.str]:
        """
        Required. Name of the origin volume for the cache volume.
        """
        return pulumi.get(self, "peer_volume_name")

    @_builtins.property
    @pulumi.getter(name="peeringCommandExpiryTime")
    def peering_command_expiry_time(self) -> Optional[_builtins.str]:
        """
        Optional. Expiration time for the peering command to be executed on user's ONTAP. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "peering_command_expiry_time")

    @_builtins.property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[_builtins.str]:
        """
        (Output)
        Detailed description of the current cache state.
        """
        return pulumi.get(self, "state_details")


@pulumi.output_type
class VolumeCacheParametersCacheConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cifsChangeNotifyEnabled":
            suggest = "cifs_change_notify_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeCacheParametersCacheConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeCacheParametersCacheConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeCacheParametersCacheConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cifs_change_notify_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cifs_change_notify_enabled: Optional. Flag indicating whether a CIFS change notification is enabled for the FlexCache volume.
        """
        if cifs_change_notify_enabled is not None:
            pulumi.set(__self__, "cifs_change_notify_enabled", cifs_change_notify_enabled)

    @_builtins.property
    @pulumi.getter(name="cifsChangeNotifyEnabled")
    def cifs_change_notify_enabled(self) -> Optional[_builtins.bool]:
        """
        Optional. Flag indicating whether a CIFS change notification is enabled for the FlexCache volume.
        """
        return pulumi.get(self, "cifs_change_notify_enabled")


@pulumi.output_type
class VolumeExportPolicy(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.VolumeExportPolicyRule']):
        """
        :param Sequence['VolumeExportPolicyRuleArgs'] rules: Export rules (up to 5) control NFS volume access.
               Structure is documented below.
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.VolumeExportPolicyRule']:
        """
        Export rules (up to 5) control NFS volume access.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class VolumeExportPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "allowedClients":
            suggest = "allowed_clients"
        elif key == "anonUid":
            suggest = "anon_uid"
        elif key == "hasRootAccess":
            suggest = "has_root_access"
        elif key == "kerberos5ReadOnly":
            suggest = "kerberos5_read_only"
        elif key == "kerberos5ReadWrite":
            suggest = "kerberos5_read_write"
        elif key == "kerberos5iReadOnly":
            suggest = "kerberos5i_read_only"
        elif key == "kerberos5iReadWrite":
            suggest = "kerberos5i_read_write"
        elif key == "kerberos5pReadOnly":
            suggest = "kerberos5p_read_only"
        elif key == "kerberos5pReadWrite":
            suggest = "kerberos5p_read_write"
        elif key == "squashMode":
            suggest = "squash_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeExportPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeExportPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeExportPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: Optional[_builtins.str] = None,
                 allowed_clients: Optional[_builtins.str] = None,
                 anon_uid: Optional[_builtins.int] = None,
                 has_root_access: Optional[_builtins.str] = None,
                 kerberos5_read_only: Optional[_builtins.bool] = None,
                 kerberos5_read_write: Optional[_builtins.bool] = None,
                 kerberos5i_read_only: Optional[_builtins.bool] = None,
                 kerberos5i_read_write: Optional[_builtins.bool] = None,
                 kerberos5p_read_only: Optional[_builtins.bool] = None,
                 kerberos5p_read_write: Optional[_builtins.bool] = None,
                 nfsv3: Optional[_builtins.bool] = None,
                 nfsv4: Optional[_builtins.bool] = None,
                 squash_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_type: Defines the access type for clients matching the `allowedClients` specification.
               Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        :param _builtins.str allowed_clients: Defines the client ingress specification (allowed clients) as a comma separated list with IPv4 CIDRs or IPv4 host addresses.
        :param _builtins.int anon_uid: An integer representing the anonymous user ID. Range is 0 to 4294967295. Required when `squash_mode` is `ALL_SQUASH`.
        :param _builtins.str has_root_access: If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
               It's overwritten by the squash_mode parameter. Use either squash_mode or has_root_access.
        :param _builtins.bool kerberos5_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        :param _builtins.bool kerberos5_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        :param _builtins.bool kerberos5i_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        :param _builtins.bool kerberos5i_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        :param _builtins.bool kerberos5p_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        :param _builtins.bool kerberos5p_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        :param _builtins.bool nfsv3: Enable to apply the export rule to NFSV3 clients.
        :param _builtins.bool nfsv4: Enable to apply the export rule to NFSV4.1 clients.
        :param _builtins.str squash_mode: SquashMode defines how remote user privileges are restricted when accessing an NFS export. It controls how the user identities (like root) are mapped to anonymous users to limit access and enforce security.
               It overwrites the has_root_access parameter. Use either squash_mode or has_root_access. For ALL_SQUASH, access_type needs to be set to READ_WRITE.
               Possible values are: `SQUASH_MODE_UNSPECIFIED`, `NO_ROOT_SQUASH`, `ROOT_SQUASH`, `ALL_SQUASH`.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if anon_uid is not None:
            pulumi.set(__self__, "anon_uid", anon_uid)
        if has_root_access is not None:
            pulumi.set(__self__, "has_root_access", has_root_access)
        if kerberos5_read_only is not None:
            pulumi.set(__self__, "kerberos5_read_only", kerberos5_read_only)
        if kerberos5_read_write is not None:
            pulumi.set(__self__, "kerberos5_read_write", kerberos5_read_write)
        if kerberos5i_read_only is not None:
            pulumi.set(__self__, "kerberos5i_read_only", kerberos5i_read_only)
        if kerberos5i_read_write is not None:
            pulumi.set(__self__, "kerberos5i_read_write", kerberos5i_read_write)
        if kerberos5p_read_only is not None:
            pulumi.set(__self__, "kerberos5p_read_only", kerberos5p_read_only)
        if kerberos5p_read_write is not None:
            pulumi.set(__self__, "kerberos5p_read_write", kerberos5p_read_write)
        if nfsv3 is not None:
            pulumi.set(__self__, "nfsv3", nfsv3)
        if nfsv4 is not None:
            pulumi.set(__self__, "nfsv4", nfsv4)
        if squash_mode is not None:
            pulumi.set(__self__, "squash_mode", squash_mode)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[_builtins.str]:
        """
        Defines the access type for clients matching the `allowedClients` specification.
        Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[_builtins.str]:
        """
        Defines the client ingress specification (allowed clients) as a comma separated list with IPv4 CIDRs or IPv4 host addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @_builtins.property
    @pulumi.getter(name="anonUid")
    def anon_uid(self) -> Optional[_builtins.int]:
        """
        An integer representing the anonymous user ID. Range is 0 to 4294967295. Required when `squash_mode` is `ALL_SQUASH`.
        """
        return pulumi.get(self, "anon_uid")

    @_builtins.property
    @pulumi.getter(name="hasRootAccess")
    def has_root_access(self) -> Optional[_builtins.str]:
        """
        If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        It's overwritten by the squash_mode parameter. Use either squash_mode or has_root_access.
        """
        return pulumi.get(self, "has_root_access")

    @_builtins.property
    @pulumi.getter(name="kerberos5ReadOnly")
    def kerberos5_read_only(self) -> Optional[_builtins.bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5_read_only")

    @_builtins.property
    @pulumi.getter(name="kerberos5ReadWrite")
    def kerberos5_read_write(self) -> Optional[_builtins.bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5_read_write")

    @_builtins.property
    @pulumi.getter(name="kerberos5iReadOnly")
    def kerberos5i_read_only(self) -> Optional[_builtins.bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5i_read_only")

    @_builtins.property
    @pulumi.getter(name="kerberos5iReadWrite")
    def kerberos5i_read_write(self) -> Optional[_builtins.bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5i_read_write")

    @_builtins.property
    @pulumi.getter(name="kerberos5pReadOnly")
    def kerberos5p_read_only(self) -> Optional[_builtins.bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5p_read_only")

    @_builtins.property
    @pulumi.getter(name="kerberos5pReadWrite")
    def kerberos5p_read_write(self) -> Optional[_builtins.bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5p_read_write")

    @_builtins.property
    @pulumi.getter
    def nfsv3(self) -> Optional[_builtins.bool]:
        """
        Enable to apply the export rule to NFSV3 clients.
        """
        return pulumi.get(self, "nfsv3")

    @_builtins.property
    @pulumi.getter
    def nfsv4(self) -> Optional[_builtins.bool]:
        """
        Enable to apply the export rule to NFSV4.1 clients.
        """
        return pulumi.get(self, "nfsv4")

    @_builtins.property
    @pulumi.getter(name="squashMode")
    def squash_mode(self) -> Optional[_builtins.str]:
        """
        SquashMode defines how remote user privileges are restricted when accessing an NFS export. It controls how the user identities (like root) are mapped to anonymous users to limit access and enforce security.
        It overwrites the has_root_access parameter. Use either squash_mode or has_root_access. For ALL_SQUASH, access_type needs to be set to READ_WRITE.
        Possible values are: `SQUASH_MODE_UNSPECIFIED`, `NO_ROOT_SQUASH`, `ROOT_SQUASH`, `ALL_SQUASH`.
        """
        return pulumi.get(self, "squash_mode")


@pulumi.output_type
class VolumeHybridReplicationParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterLocation":
            suggest = "cluster_location"
        elif key == "hybridReplicationType":
            suggest = "hybrid_replication_type"
        elif key == "largeVolumeConstituentCount":
            suggest = "large_volume_constituent_count"
        elif key == "peerClusterName":
            suggest = "peer_cluster_name"
        elif key == "peerIpAddresses":
            suggest = "peer_ip_addresses"
        elif key == "peerSvmName":
            suggest = "peer_svm_name"
        elif key == "peerVolumeName":
            suggest = "peer_volume_name"
        elif key == "replicationSchedule":
            suggest = "replication_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeHybridReplicationParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeHybridReplicationParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeHybridReplicationParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_location: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 hybrid_replication_type: Optional[_builtins.str] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 large_volume_constituent_count: Optional[_builtins.int] = None,
                 peer_cluster_name: Optional[_builtins.str] = None,
                 peer_ip_addresses: Optional[Sequence[_builtins.str]] = None,
                 peer_svm_name: Optional[_builtins.str] = None,
                 peer_volume_name: Optional[_builtins.str] = None,
                 replication: Optional[_builtins.str] = None,
                 replication_schedule: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_location: Optional. Name of source cluster location associated with the Hybrid replication. This is a free-form field for the display purpose only.
        :param _builtins.str description: Optional. Description of the replication.
        :param _builtins.str hybrid_replication_type: Optional. Type of the volume's hybrid replication.
               Possible values are: `MIGRATION`, `CONTINUOUS_REPLICATION`, `ONPREM_REPLICATION`, `REVERSE_ONPREM_REPLICATION`.
        :param Mapping[str, _builtins.str] labels: Optional. Labels to be added to the replication as the key value pairs.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param _builtins.int large_volume_constituent_count: Optional. Constituent volume count for large volume.
        :param _builtins.str peer_cluster_name: Required. Name of the user's local source cluster to be peered with the destination cluster.
        :param Sequence[_builtins.str] peer_ip_addresses: Required. List of node ip addresses to be peered with.
        :param _builtins.str peer_svm_name: Required. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        :param _builtins.str peer_volume_name: Required. Name of the user's local source volume to be peered with the destination volume.
        :param _builtins.str replication: Required. Desired name for the replication of this volume.
        :param _builtins.str replication_schedule: Optional. Replication Schedule for the replication created.
               Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        """
        if cluster_location is not None:
            pulumi.set(__self__, "cluster_location", cluster_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hybrid_replication_type is not None:
            pulumi.set(__self__, "hybrid_replication_type", hybrid_replication_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if large_volume_constituent_count is not None:
            pulumi.set(__self__, "large_volume_constituent_count", large_volume_constituent_count)
        if peer_cluster_name is not None:
            pulumi.set(__self__, "peer_cluster_name", peer_cluster_name)
        if peer_ip_addresses is not None:
            pulumi.set(__self__, "peer_ip_addresses", peer_ip_addresses)
        if peer_svm_name is not None:
            pulumi.set(__self__, "peer_svm_name", peer_svm_name)
        if peer_volume_name is not None:
            pulumi.set(__self__, "peer_volume_name", peer_volume_name)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if replication_schedule is not None:
            pulumi.set(__self__, "replication_schedule", replication_schedule)

    @_builtins.property
    @pulumi.getter(name="clusterLocation")
    def cluster_location(self) -> Optional[_builtins.str]:
        """
        Optional. Name of source cluster location associated with the Hybrid replication. This is a free-form field for the display purpose only.
        """
        return pulumi.get(self, "cluster_location")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Optional. Description of the replication.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hybridReplicationType")
    def hybrid_replication_type(self) -> Optional[_builtins.str]:
        """
        Optional. Type of the volume's hybrid replication.
        Possible values are: `MIGRATION`, `CONTINUOUS_REPLICATION`, `ONPREM_REPLICATION`, `REVERSE_ONPREM_REPLICATION`.
        """
        return pulumi.get(self, "hybrid_replication_type")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Optional. Labels to be added to the replication as the key value pairs.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="largeVolumeConstituentCount")
    def large_volume_constituent_count(self) -> Optional[_builtins.int]:
        """
        Optional. Constituent volume count for large volume.
        """
        return pulumi.get(self, "large_volume_constituent_count")

    @_builtins.property
    @pulumi.getter(name="peerClusterName")
    def peer_cluster_name(self) -> Optional[_builtins.str]:
        """
        Required. Name of the user's local source cluster to be peered with the destination cluster.
        """
        return pulumi.get(self, "peer_cluster_name")

    @_builtins.property
    @pulumi.getter(name="peerIpAddresses")
    def peer_ip_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Required. List of node ip addresses to be peered with.
        """
        return pulumi.get(self, "peer_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="peerSvmName")
    def peer_svm_name(self) -> Optional[_builtins.str]:
        """
        Required. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        """
        return pulumi.get(self, "peer_svm_name")

    @_builtins.property
    @pulumi.getter(name="peerVolumeName")
    def peer_volume_name(self) -> Optional[_builtins.str]:
        """
        Required. Name of the user's local source volume to be peered with the destination volume.
        """
        return pulumi.get(self, "peer_volume_name")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[_builtins.str]:
        """
        Required. Desired name for the replication of this volume.
        """
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> Optional[_builtins.str]:
        """
        Optional. Replication Schedule for the replication created.
        Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        """
        return pulumi.get(self, "replication_schedule")


@pulumi.output_type
class VolumeMountOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportFull":
            suggest = "export_full"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 export: Optional[_builtins.str] = None,
                 export_full: Optional[_builtins.str] = None,
                 instructions: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str export: (Output)
               Export path of the volume.
        :param _builtins.str export_full: (Output)
               Full export path of the volume.
               Format for NFS volumes: `<export_ip>:/<shareName>`
               Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        :param _builtins.str instructions: (Output)
               Human-readable mount instructions.
        :param _builtins.str ip_address: (Output)
               IP Address.
        :param _builtins.str protocol: (Output)
               Protocol to mount with.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if export_full is not None:
            pulumi.set(__self__, "export_full", export_full)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[_builtins.str]:
        """
        (Output)
        Export path of the volume.
        """
        return pulumi.get(self, "export")

    @_builtins.property
    @pulumi.getter(name="exportFull")
    def export_full(self) -> Optional[_builtins.str]:
        """
        (Output)
        Full export path of the volume.
        Format for NFS volumes: `<export_ip>:/<shareName>`
        Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        """
        return pulumi.get(self, "export_full")

    @_builtins.property
    @pulumi.getter
    def instructions(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human-readable mount instructions.
        """
        return pulumi.get(self, "instructions")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        (Output)
        IP Address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        (Output)
        Protocol to mount with.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class VolumeReplicationDestinationVolumeParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storagePool":
            suggest = "storage_pool"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "tieringPolicy":
            suggest = "tiering_policy"
        elif key == "volumeId":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationDestinationVolumeParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationDestinationVolumeParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationDestinationVolumeParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_pool: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 share_name: Optional[_builtins.str] = None,
                 tiering_policy: Optional['outputs.VolumeReplicationDestinationVolumeParametersTieringPolicy'] = None,
                 volume_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str storage_pool: Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        :param _builtins.str description: Description for the destination volume.
        :param _builtins.str share_name: Share name for destination volume. If not specified, name of source volume's share name will be used.
        :param 'VolumeReplicationDestinationVolumeParametersTieringPolicyArgs' tiering_policy: Tiering policy for the volume.
               Structure is documented below.
        :param _builtins.str volume_id: Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        pulumi.set(__self__, "storage_pool", storage_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> _builtins.str:
        """
        Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        """
        return pulumi.get(self, "storage_pool")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description for the destination volume.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[_builtins.str]:
        """
        Share name for destination volume. If not specified, name of source volume's share name will be used.
        """
        return pulumi.get(self, "share_name")

    @_builtins.property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional['outputs.VolumeReplicationDestinationVolumeParametersTieringPolicy']:
        """
        Tiering policy for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "tiering_policy")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class VolumeReplicationDestinationVolumeParametersTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolingThresholdDays":
            suggest = "cooling_threshold_days"
        elif key == "tierAction":
            suggest = "tier_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationDestinationVolumeParametersTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationDestinationVolumeParametersTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationDestinationVolumeParametersTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooling_threshold_days: Optional[_builtins.int] = None,
                 tier_action: Optional[_builtins.str] = None):
        """
        :param _builtins.int cooling_threshold_days: Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
               Default is 31.
        :param _builtins.str tier_action: Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
               Default value is `PAUSED`.
               Possible values are: `ENABLED`, `PAUSED`.
        """
        if cooling_threshold_days is not None:
            pulumi.set(__self__, "cooling_threshold_days", cooling_threshold_days)
        if tier_action is not None:
            pulumi.set(__self__, "tier_action", tier_action)

    @_builtins.property
    @pulumi.getter(name="coolingThresholdDays")
    def cooling_threshold_days(self) -> Optional[_builtins.int]:
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
        Default is 31.
        """
        return pulumi.get(self, "cooling_threshold_days")

    @_builtins.property
    @pulumi.getter(name="tierAction")
    def tier_action(self) -> Optional[_builtins.str]:
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
        return pulumi.get(self, "tier_action")


@pulumi.output_type
class VolumeReplicationHybridPeeringDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandExpiryTime":
            suggest = "command_expiry_time"
        elif key == "peerClusterName":
            suggest = "peer_cluster_name"
        elif key == "peerSvmName":
            suggest = "peer_svm_name"
        elif key == "peerVolumeName":
            suggest = "peer_volume_name"
        elif key == "subnetIp":
            suggest = "subnet_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationHybridPeeringDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationHybridPeeringDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationHybridPeeringDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[_builtins.str] = None,
                 command_expiry_time: Optional[_builtins.str] = None,
                 passphrase: Optional[_builtins.str] = None,
                 peer_cluster_name: Optional[_builtins.str] = None,
                 peer_svm_name: Optional[_builtins.str] = None,
                 peer_volume_name: Optional[_builtins.str] = None,
                 subnet_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str command: (Output)
               Optional. Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        :param _builtins.str command_expiry_time: (Output)
               Optional. Expiration time for the peering command to be executed on user's ONTAP.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        :param _builtins.str passphrase: (Output)
               Optional. Temporary passphrase generated to accept cluster peering command.
        :param _builtins.str peer_cluster_name: (Output)
               Optional. Name of the user's local source cluster to be peered with the destination cluster.
        :param _builtins.str peer_svm_name: (Output)
               Optional. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        :param _builtins.str peer_volume_name: (Output)
               Optional. Name of the user's local source volume to be peered with the destination volume.
        :param _builtins.str subnet_ip: (Output)
               Optional. IP address of the subnet.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if command_expiry_time is not None:
            pulumi.set(__self__, "command_expiry_time", command_expiry_time)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if peer_cluster_name is not None:
            pulumi.set(__self__, "peer_cluster_name", peer_cluster_name)
        if peer_svm_name is not None:
            pulumi.set(__self__, "peer_svm_name", peer_svm_name)
        if peer_volume_name is not None:
            pulumi.set(__self__, "peer_volume_name", peer_volume_name)
        if subnet_ip is not None:
            pulumi.set(__self__, "subnet_ip", subnet_ip)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[_builtins.str]:
        """
        (Output)
        Optional. Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter(name="commandExpiryTime")
    def command_expiry_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Optional. Expiration time for the peering command to be executed on user's ONTAP.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        """
        return pulumi.get(self, "command_expiry_time")

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[_builtins.str]:
        """
        (Output)
        Optional. Temporary passphrase generated to accept cluster peering command.
        """
        return pulumi.get(self, "passphrase")

    @_builtins.property
    @pulumi.getter(name="peerClusterName")
    def peer_cluster_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        Optional. Name of the user's local source cluster to be peered with the destination cluster.
        """
        return pulumi.get(self, "peer_cluster_name")

    @_builtins.property
    @pulumi.getter(name="peerSvmName")
    def peer_svm_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        Optional. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        """
        return pulumi.get(self, "peer_svm_name")

    @_builtins.property
    @pulumi.getter(name="peerVolumeName")
    def peer_volume_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        Optional. Name of the user's local source volume to be peered with the destination volume.
        """
        return pulumi.get(self, "peer_volume_name")

    @_builtins.property
    @pulumi.getter(name="subnetIp")
    def subnet_ip(self) -> Optional[_builtins.str]:
        """
        (Output)
        Optional. IP address of the subnet.
        """
        return pulumi.get(self, "subnet_ip")


@pulumi.output_type
class VolumeReplicationHybridReplicationUserCommand(dict):
    def __init__(__self__, *,
                 commands: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] commands: (Output)
               List of commands to be executed by the customer.
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        List of commands to be executed by the customer.
        """
        return pulumi.get(self, "commands")


@pulumi.output_type
class VolumeReplicationTransferStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lagDuration":
            suggest = "lag_duration"
        elif key == "lastTransferBytes":
            suggest = "last_transfer_bytes"
        elif key == "lastTransferDuration":
            suggest = "last_transfer_duration"
        elif key == "lastTransferEndTime":
            suggest = "last_transfer_end_time"
        elif key == "lastTransferError":
            suggest = "last_transfer_error"
        elif key == "totalTransferDuration":
            suggest = "total_transfer_duration"
        elif key == "transferBytes":
            suggest = "transfer_bytes"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationTransferStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationTransferStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationTransferStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lag_duration: Optional[_builtins.str] = None,
                 last_transfer_bytes: Optional[_builtins.str] = None,
                 last_transfer_duration: Optional[_builtins.str] = None,
                 last_transfer_end_time: Optional[_builtins.str] = None,
                 last_transfer_error: Optional[_builtins.str] = None,
                 total_transfer_duration: Optional[_builtins.str] = None,
                 transfer_bytes: Optional[_builtins.str] = None,
                 update_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str lag_duration: (Output)
               The elapsed time since the creation of the snapshot on the source volume that was last replicated
               to the destination volume. Lag time represents the difference in age of the destination volume
               data in relation to the source volume data.
        :param _builtins.str last_transfer_bytes: (Output)
               Size of last completed transfer in bytes.
        :param _builtins.str last_transfer_duration: (Output)
               Time taken during last completed transfer.
        :param _builtins.str last_transfer_end_time: (Output)
               Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param _builtins.str last_transfer_error: (Output)
               A message describing the cause of the last transfer failure.
        :param _builtins.str total_transfer_duration: (Output)
               Cumulative time taken across all transfers for the replication relationship.
        :param _builtins.str transfer_bytes: (Output)
               Cumulative bytes transferred so far for the replication relationship.
        :param _builtins.str update_time: (Output)
               Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        if lag_duration is not None:
            pulumi.set(__self__, "lag_duration", lag_duration)
        if last_transfer_bytes is not None:
            pulumi.set(__self__, "last_transfer_bytes", last_transfer_bytes)
        if last_transfer_duration is not None:
            pulumi.set(__self__, "last_transfer_duration", last_transfer_duration)
        if last_transfer_end_time is not None:
            pulumi.set(__self__, "last_transfer_end_time", last_transfer_end_time)
        if last_transfer_error is not None:
            pulumi.set(__self__, "last_transfer_error", last_transfer_error)
        if total_transfer_duration is not None:
            pulumi.set(__self__, "total_transfer_duration", total_transfer_duration)
        if transfer_bytes is not None:
            pulumi.set(__self__, "transfer_bytes", transfer_bytes)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="lagDuration")
    def lag_duration(self) -> Optional[_builtins.str]:
        """
        (Output)
        The elapsed time since the creation of the snapshot on the source volume that was last replicated
        to the destination volume. Lag time represents the difference in age of the destination volume
        data in relation to the source volume data.
        """
        return pulumi.get(self, "lag_duration")

    @_builtins.property
    @pulumi.getter(name="lastTransferBytes")
    def last_transfer_bytes(self) -> Optional[_builtins.str]:
        """
        (Output)
        Size of last completed transfer in bytes.
        """
        return pulumi.get(self, "last_transfer_bytes")

    @_builtins.property
    @pulumi.getter(name="lastTransferDuration")
    def last_transfer_duration(self) -> Optional[_builtins.str]:
        """
        (Output)
        Time taken during last completed transfer.
        """
        return pulumi.get(self, "last_transfer_duration")

    @_builtins.property
    @pulumi.getter(name="lastTransferEndTime")
    def last_transfer_end_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "last_transfer_end_time")

    @_builtins.property
    @pulumi.getter(name="lastTransferError")
    def last_transfer_error(self) -> Optional[_builtins.str]:
        """
        (Output)
        A message describing the cause of the last transfer failure.
        """
        return pulumi.get(self, "last_transfer_error")

    @_builtins.property
    @pulumi.getter(name="totalTransferDuration")
    def total_transfer_duration(self) -> Optional[_builtins.str]:
        """
        (Output)
        Cumulative time taken across all transfers for the replication relationship.
        """
        return pulumi.get(self, "total_transfer_duration")

    @_builtins.property
    @pulumi.getter(name="transferBytes")
    def transfer_bytes(self) -> Optional[_builtins.str]:
        """
        (Output)
        Cumulative bytes transferred so far for the replication relationship.
        """
        return pulumi.get(self, "transfer_bytes")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class VolumeRestoreParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceBackup":
            suggest = "source_backup"
        elif key == "sourceSnapshot":
            suggest = "source_snapshot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeRestoreParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeRestoreParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeRestoreParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_backup: Optional[_builtins.str] = None,
                 source_snapshot: Optional[_builtins.str] = None):
        """
        :param _builtins.str source_backup: Full name of the backup to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        :param _builtins.str source_snapshot: Full name of the snapshot to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        if source_backup is not None:
            pulumi.set(__self__, "source_backup", source_backup)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)

    @_builtins.property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> Optional[_builtins.str]:
        """
        Full name of the backup to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        """
        return pulumi.get(self, "source_backup")

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[_builtins.str]:
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        return pulumi.get(self, "source_snapshot")


@pulumi.output_type
class VolumeSnapshotPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailySchedule":
            suggest = "daily_schedule"
        elif key == "hourlySchedule":
            suggest = "hourly_schedule"
        elif key == "monthlySchedule":
            suggest = "monthly_schedule"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_schedule: Optional['outputs.VolumeSnapshotPolicyDailySchedule'] = None,
                 enabled: Optional[_builtins.bool] = None,
                 hourly_schedule: Optional['outputs.VolumeSnapshotPolicyHourlySchedule'] = None,
                 monthly_schedule: Optional['outputs.VolumeSnapshotPolicyMonthlySchedule'] = None,
                 weekly_schedule: Optional['outputs.VolumeSnapshotPolicyWeeklySchedule'] = None):
        """
        :param 'VolumeSnapshotPolicyDailyScheduleArgs' daily_schedule: Daily schedule policy.
               Structure is documented below.
        :param _builtins.bool enabled: Enables automated snapshot creation according to defined schedule. Default is false.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        :param 'VolumeSnapshotPolicyHourlyScheduleArgs' hourly_schedule: Hourly schedule policy.
               Structure is documented below.
        :param 'VolumeSnapshotPolicyMonthlyScheduleArgs' monthly_schedule: Monthly schedule policy.
               Structure is documented below.
        :param 'VolumeSnapshotPolicyWeeklyScheduleArgs' weekly_schedule: Weekly schedule policy.
               Structure is documented below.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @_builtins.property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyDailySchedule']:
        """
        Daily schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "daily_schedule")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enables automated snapshot creation according to defined schedule. Default is false.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyHourlySchedule']:
        """
        Hourly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "hourly_schedule")

    @_builtins.property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyMonthlySchedule']:
        """
        Monthly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "monthly_schedule")

    @_builtins.property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyWeeklySchedule']:
        """
        Weekly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class VolumeSnapshotPolicyDailySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyDailySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyDailySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyDailySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: _builtins.int,
                 hour: Optional[_builtins.int] = None,
                 minute: Optional[_builtins.int] = None):
        """
        :param _builtins.int snapshots_to_keep: The maximum number of snapshots to keep for the daily schedule.
        :param _builtins.int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param _builtins.int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @_builtins.property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> _builtins.int:
        """
        The maximum number of snapshots to keep for the daily schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[_builtins.int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @_builtins.property
    @pulumi.getter
    def minute(self) -> Optional[_builtins.int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyHourlySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyHourlySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyHourlySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyHourlySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: _builtins.int,
                 minute: Optional[_builtins.int] = None):
        """
        :param _builtins.int snapshots_to_keep: The maximum number of snapshots to keep for the hourly schedule.
        :param _builtins.int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @_builtins.property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> _builtins.int:
        """
        The maximum number of snapshots to keep for the hourly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @_builtins.property
    @pulumi.getter
    def minute(self) -> Optional[_builtins.int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyMonthlySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"
        elif key == "daysOfMonth":
            suggest = "days_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyMonthlySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyMonthlySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyMonthlySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: _builtins.int,
                 days_of_month: Optional[_builtins.str] = None,
                 hour: Optional[_builtins.int] = None,
                 minute: Optional[_builtins.int] = None):
        """
        :param _builtins.int snapshots_to_keep: The maximum number of snapshots to keep for the monthly schedule
        :param _builtins.str days_of_month: Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        :param _builtins.int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param _builtins.int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if days_of_month is not None:
            pulumi.set(__self__, "days_of_month", days_of_month)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @_builtins.property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> _builtins.int:
        """
        The maximum number of snapshots to keep for the monthly schedule
        """
        return pulumi.get(self, "snapshots_to_keep")

    @_builtins.property
    @pulumi.getter(name="daysOfMonth")
    def days_of_month(self) -> Optional[_builtins.str]:
        """
        Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        """
        return pulumi.get(self, "days_of_month")

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[_builtins.int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @_builtins.property
    @pulumi.getter
    def minute(self) -> Optional[_builtins.int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyWeeklySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyWeeklySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyWeeklySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyWeeklySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: _builtins.int,
                 day: Optional[_builtins.str] = None,
                 hour: Optional[_builtins.int] = None,
                 minute: Optional[_builtins.int] = None):
        """
        :param _builtins.int snapshots_to_keep: The maximum number of snapshots to keep for the weekly schedule.
        :param _builtins.str day: Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        :param _builtins.int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param _builtins.int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @_builtins.property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> _builtins.int:
        """
        The maximum number of snapshots to keep for the weekly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @_builtins.property
    @pulumi.getter
    def day(self) -> Optional[_builtins.str]:
        """
        Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[_builtins.int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @_builtins.property
    @pulumi.getter
    def minute(self) -> Optional[_builtins.int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolingThresholdDays":
            suggest = "cooling_threshold_days"
        elif key == "hotTierBypassModeEnabled":
            suggest = "hot_tier_bypass_mode_enabled"
        elif key == "tierAction":
            suggest = "tier_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooling_threshold_days: Optional[_builtins.int] = None,
                 hot_tier_bypass_mode_enabled: Optional[_builtins.bool] = None,
                 tier_action: Optional[_builtins.str] = None):
        """
        :param _builtins.int cooling_threshold_days: Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
               Default is 31.
        :param _builtins.bool hot_tier_bypass_mode_enabled: Optional. Flag indicating that the hot tier bypass mode is enabled. Default is false.
               Only applicable to Flex service level.
        :param _builtins.str tier_action: Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
               Default value is `PAUSED`.
               Possible values are: `ENABLED`, `PAUSED`.
        """
        if cooling_threshold_days is not None:
            pulumi.set(__self__, "cooling_threshold_days", cooling_threshold_days)
        if hot_tier_bypass_mode_enabled is not None:
            pulumi.set(__self__, "hot_tier_bypass_mode_enabled", hot_tier_bypass_mode_enabled)
        if tier_action is not None:
            pulumi.set(__self__, "tier_action", tier_action)

    @_builtins.property
    @pulumi.getter(name="coolingThresholdDays")
    def cooling_threshold_days(self) -> Optional[_builtins.int]:
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
        Default is 31.
        """
        return pulumi.get(self, "cooling_threshold_days")

    @_builtins.property
    @pulumi.getter(name="hotTierBypassModeEnabled")
    def hot_tier_bypass_mode_enabled(self) -> Optional[_builtins.bool]:
        """
        Optional. Flag indicating that the hot tier bypass mode is enabled. Default is false.
        Only applicable to Flex service level.
        """
        return pulumi.get(self, "hot_tier_bypass_mode_enabled")

    @_builtins.property
    @pulumi.getter(name="tierAction")
    def tier_action(self) -> Optional[_builtins.str]:
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
        return pulumi.get(self, "tier_action")


