# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VolumeQuotaRuleArgs', 'VolumeQuotaRule']

@pulumi.input_type
class VolumeQuotaRuleArgs:
    def __init__(__self__, *,
                 disk_limit_mib: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 volume_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VolumeQuotaRule resource.
        :param pulumi.Input[_builtins.int] disk_limit_mib: The maximum allowed capacity in MiB.
        :param pulumi.Input[_builtins.str] type: Types of Quota Rule.
               Possible values are: `INDIVIDUAL_USER_QUOTA`, `INDIVIDUAL_GROUP_QUOTA`, `DEFAULT_USER_QUOTA`, `DEFAULT_GROUP_QUOTA`.
        :param pulumi.Input[_builtins.str] volume_name: Name of the volume to create the quotaRule in.
        :param pulumi.Input[_builtins.str] description: Description for the quota rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs of the quota rule. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Loction of the quotaRule. QuotaRules are child resources of volumes and live in the same location.
        :param pulumi.Input[_builtins.str] name: The resource name of the quotaRule.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] target: The quota rule applies to the specified user or group.
               Valid targets for volumes with NFS protocol enabled:
               - UNIX UID for individual user quota
               - UNIX GID for individual group quota
               Valid targets for volumes with SMB protocol enabled:
               - Windows SID for individual user quota
               Leave empty for default quotas
        """
        pulumi.set(__self__, "disk_limit_mib", disk_limit_mib)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "volume_name", volume_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter(name="diskLimitMib")
    def disk_limit_mib(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum allowed capacity in MiB.
        """
        return pulumi.get(self, "disk_limit_mib")

    @disk_limit_mib.setter
    def disk_limit_mib(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "disk_limit_mib", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Types of Quota Rule.
        Possible values are: `INDIVIDUAL_USER_QUOTA`, `INDIVIDUAL_GROUP_QUOTA`, `DEFAULT_USER_QUOTA`, `DEFAULT_GROUP_QUOTA`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the volume to create the quotaRule in.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the quota rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs of the quota rule. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Loction of the quotaRule. QuotaRules are child resources of volumes and live in the same location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the quotaRule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The quota rule applies to the specified user or group.
        Valid targets for volumes with NFS protocol enabled:
        - UNIX UID for individual user quota
        - UNIX GID for individual group quota
        Valid targets for volumes with SMB protocol enabled:
        - Windows SID for individual user quota
        Leave empty for default quotas
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class _VolumeQuotaRuleState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_limit_mib: Optional[pulumi.Input[_builtins.int]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_details: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeQuotaRule resources.
        :param pulumi.Input[_builtins.str] create_time: Create time of the quota rule. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[_builtins.str] description: Description for the quota rule.
        :param pulumi.Input[_builtins.int] disk_limit_mib: The maximum allowed capacity in MiB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs of the quota rule. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Loction of the quotaRule. QuotaRules are child resources of volumes and live in the same location.
        :param pulumi.Input[_builtins.str] name: The resource name of the quotaRule.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: The state of the quota rule. Possible Values : [STATE_UNSPECIFIED, CREATING, UPDATING, READY, DELETING, ERROR]
        :param pulumi.Input[_builtins.str] state_details: State details of the quota rule
        :param pulumi.Input[_builtins.str] target: The quota rule applies to the specified user or group.
               Valid targets for volumes with NFS protocol enabled:
               - UNIX UID for individual user quota
               - UNIX GID for individual group quota
               Valid targets for volumes with SMB protocol enabled:
               - Windows SID for individual user quota
               Leave empty for default quotas
        :param pulumi.Input[_builtins.str] type: Types of Quota Rule.
               Possible values are: `INDIVIDUAL_USER_QUOTA`, `INDIVIDUAL_GROUP_QUOTA`, `DEFAULT_USER_QUOTA`, `DEFAULT_GROUP_QUOTA`.
        :param pulumi.Input[_builtins.str] volume_name: Name of the volume to create the quotaRule in.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_limit_mib is not None:
            pulumi.set(__self__, "disk_limit_mib", disk_limit_mib)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create time of the quota rule. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the quota rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskLimitMib")
    def disk_limit_mib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum allowed capacity in MiB.
        """
        return pulumi.get(self, "disk_limit_mib")

    @disk_limit_mib.setter
    def disk_limit_mib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_limit_mib", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs of the quota rule. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Loction of the quotaRule. QuotaRules are child resources of volumes and live in the same location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the quotaRule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the quota rule. Possible Values : [STATE_UNSPECIFIED, CREATING, UPDATING, READY, DELETING, ERROR]
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State details of the quota rule
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_details", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The quota rule applies to the specified user or group.
        Valid targets for volumes with NFS protocol enabled:
        - UNIX UID for individual user quota
        - UNIX GID for individual group quota
        Valid targets for volumes with SMB protocol enabled:
        - Windows SID for individual user quota
        Leave empty for default quotas
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Types of Quota Rule.
        Possible values are: `INDIVIDUAL_USER_QUOTA`, `INDIVIDUAL_GROUP_QUOTA`, `DEFAULT_USER_QUOTA`, `DEFAULT_GROUP_QUOTA`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the volume to create the quotaRule in.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_name", value)


@pulumi.type_token("gcp:netapp/volumeQuotaRule:VolumeQuotaRule")
class VolumeQuotaRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_limit_mib: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        QuotaRule specifies the maximum capacity a user or group can use within a volume. They can be used for creating default and individual quota rules.

        To get more information about VolumeQuotaRule, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.volumes.quotaRules)
        * How-to Guides
            * [Documentation](https://cloud.google.com/netapp/volumes/docs/configure-and-use/volumes/overview#volume_user_and_group_quotas)

        ## Example Usage

        ### Netapp Volume Quota Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="test-network")
        default_storage_pool = gcp.netapp.StoragePool("default",
            name="test-pool",
            location="us-west2",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        default_volume = gcp.netapp.Volume("default",
            location=default_storage_pool.location,
            name="test-volume",
            capacity_gib="100",
            share_name="test-volume",
            storage_pool=default_storage_pool.name,
            protocols=["NFSV3"])
        test_quota_rule = gcp.netapp.VolumeQuotaRule("test_quota_rule",
            location=default_volume.location,
            volume_name=default_volume.name,
            type="DEFAULT_USER_QUOTA",
            disk_limit_mib=50,
            name="test-volume-quota-rule",
            opts = pulumi.ResourceOptions(depends_on=[default_volume]))
        ```

        ## Import

        VolumeQuotaRule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/volumes/{{volume_name}}/quotaRules/{{name}}`

        * `{{project}}/{{location}}/{{volume_name}}/{{name}}`

        * `{{location}}/{{volume_name}}/{{name}}`

        When using the `pulumi import` command, VolumeQuotaRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/volumeQuotaRule:VolumeQuotaRule default projects/{{project}}/locations/{{location}}/volumes/{{volume_name}}/quotaRules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volumeQuotaRule:VolumeQuotaRule default {{project}}/{{location}}/{{volume_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volumeQuotaRule:VolumeQuotaRule default {{location}}/{{volume_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description for the quota rule.
        :param pulumi.Input[_builtins.int] disk_limit_mib: The maximum allowed capacity in MiB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs of the quota rule. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Loction of the quotaRule. QuotaRules are child resources of volumes and live in the same location.
        :param pulumi.Input[_builtins.str] name: The resource name of the quotaRule.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] target: The quota rule applies to the specified user or group.
               Valid targets for volumes with NFS protocol enabled:
               - UNIX UID for individual user quota
               - UNIX GID for individual group quota
               Valid targets for volumes with SMB protocol enabled:
               - Windows SID for individual user quota
               Leave empty for default quotas
        :param pulumi.Input[_builtins.str] type: Types of Quota Rule.
               Possible values are: `INDIVIDUAL_USER_QUOTA`, `INDIVIDUAL_GROUP_QUOTA`, `DEFAULT_USER_QUOTA`, `DEFAULT_GROUP_QUOTA`.
        :param pulumi.Input[_builtins.str] volume_name: Name of the volume to create the quotaRule in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeQuotaRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        QuotaRule specifies the maximum capacity a user or group can use within a volume. They can be used for creating default and individual quota rules.

        To get more information about VolumeQuotaRule, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.volumes.quotaRules)
        * How-to Guides
            * [Documentation](https://cloud.google.com/netapp/volumes/docs/configure-and-use/volumes/overview#volume_user_and_group_quotas)

        ## Example Usage

        ### Netapp Volume Quota Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="test-network")
        default_storage_pool = gcp.netapp.StoragePool("default",
            name="test-pool",
            location="us-west2",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        default_volume = gcp.netapp.Volume("default",
            location=default_storage_pool.location,
            name="test-volume",
            capacity_gib="100",
            share_name="test-volume",
            storage_pool=default_storage_pool.name,
            protocols=["NFSV3"])
        test_quota_rule = gcp.netapp.VolumeQuotaRule("test_quota_rule",
            location=default_volume.location,
            volume_name=default_volume.name,
            type="DEFAULT_USER_QUOTA",
            disk_limit_mib=50,
            name="test-volume-quota-rule",
            opts = pulumi.ResourceOptions(depends_on=[default_volume]))
        ```

        ## Import

        VolumeQuotaRule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/volumes/{{volume_name}}/quotaRules/{{name}}`

        * `{{project}}/{{location}}/{{volume_name}}/{{name}}`

        * `{{location}}/{{volume_name}}/{{name}}`

        When using the `pulumi import` command, VolumeQuotaRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/volumeQuotaRule:VolumeQuotaRule default projects/{{project}}/locations/{{location}}/volumes/{{volume_name}}/quotaRules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volumeQuotaRule:VolumeQuotaRule default {{project}}/{{location}}/{{volume_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volumeQuotaRule:VolumeQuotaRule default {{location}}/{{volume_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param VolumeQuotaRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeQuotaRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_limit_mib: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeQuotaRuleArgs.__new__(VolumeQuotaRuleArgs)

            __props__.__dict__["description"] = description
            if disk_limit_mib is None and not opts.urn:
                raise TypeError("Missing required property 'disk_limit_mib'")
            __props__.__dict__["disk_limit_mib"] = disk_limit_mib
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["target"] = target
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if volume_name is None and not opts.urn:
                raise TypeError("Missing required property 'volume_name'")
            __props__.__dict__["volume_name"] = volume_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_details"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VolumeQuotaRule, __self__).__init__(
            'gcp:netapp/volumeQuotaRule:VolumeQuotaRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_limit_mib: Optional[pulumi.Input[_builtins.int]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_details: Optional[pulumi.Input[_builtins.str]] = None,
            target: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            volume_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeQuotaRule':
        """
        Get an existing VolumeQuotaRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Create time of the quota rule. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[_builtins.str] description: Description for the quota rule.
        :param pulumi.Input[_builtins.int] disk_limit_mib: The maximum allowed capacity in MiB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs of the quota rule. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Loction of the quotaRule. QuotaRules are child resources of volumes and live in the same location.
        :param pulumi.Input[_builtins.str] name: The resource name of the quotaRule.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: The state of the quota rule. Possible Values : [STATE_UNSPECIFIED, CREATING, UPDATING, READY, DELETING, ERROR]
        :param pulumi.Input[_builtins.str] state_details: State details of the quota rule
        :param pulumi.Input[_builtins.str] target: The quota rule applies to the specified user or group.
               Valid targets for volumes with NFS protocol enabled:
               - UNIX UID for individual user quota
               - UNIX GID for individual group quota
               Valid targets for volumes with SMB protocol enabled:
               - Windows SID for individual user quota
               Leave empty for default quotas
        :param pulumi.Input[_builtins.str] type: Types of Quota Rule.
               Possible values are: `INDIVIDUAL_USER_QUOTA`, `INDIVIDUAL_GROUP_QUOTA`, `DEFAULT_USER_QUOTA`, `DEFAULT_GROUP_QUOTA`.
        :param pulumi.Input[_builtins.str] volume_name: Name of the volume to create the quotaRule in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeQuotaRuleState.__new__(_VolumeQuotaRuleState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_limit_mib"] = disk_limit_mib
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["state_details"] = state_details
        __props__.__dict__["target"] = target
        __props__.__dict__["type"] = type
        __props__.__dict__["volume_name"] = volume_name
        return VolumeQuotaRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create time of the quota rule. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for the quota rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskLimitMib")
    def disk_limit_mib(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum allowed capacity in MiB.
        """
        return pulumi.get(self, "disk_limit_mib")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels as key value pairs of the quota rule. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Loction of the quotaRule. QuotaRules are child resources of volumes and live in the same location.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the quotaRule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the quota rule. Possible Values : [STATE_UNSPECIFIED, CREATING, UPDATING, READY, DELETING, ERROR]
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> pulumi.Output[_builtins.str]:
        """
        State details of the quota rule
        """
        return pulumi.get(self, "state_details")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The quota rule applies to the specified user or group.
        Valid targets for volumes with NFS protocol enabled:
        - UNIX UID for individual user quota
        - UNIX GID for individual group quota
        Valid targets for volumes with SMB protocol enabled:
        - Windows SID for individual user quota
        Leave empty for default quotas
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Types of Quota Rule.
        Possible values are: `INDIVIDUAL_USER_QUOTA`, `INDIVIDUAL_GROUP_QUOTA`, `DEFAULT_USER_QUOTA`, `DEFAULT_GROUP_QUOTA`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the volume to create the quotaRule in.
        """
        return pulumi.get(self, "volume_name")

