# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectivityTestsResult',
    'AwaitableGetConnectivityTestsResult',
    'get_connectivity_tests',
    'get_connectivity_tests_output',
]

@pulumi.output_type
class GetConnectivityTestsResult:
    """
    A collection of values returned by getConnectivityTests.
    """
    def __init__(__self__, connectivity_tests=None, filter=None, id=None, project=None):
        if connectivity_tests and not isinstance(connectivity_tests, list):
            raise TypeError("Expected argument 'connectivity_tests' to be a list")
        pulumi.set(__self__, "connectivity_tests", connectivity_tests)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="connectivityTests")
    def connectivity_tests(self) -> Sequence['outputs.GetConnectivityTestsConnectivityTestResult']:
        """
        A list of connectivity tests in the selected project matching the filter. Structure is defined below.
        """
        return pulumi.get(self, "connectivity_tests")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project in which the resource belongs.
        """
        return pulumi.get(self, "project")


class AwaitableGetConnectivityTestsResult(GetConnectivityTestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectivityTestsResult(
            connectivity_tests=self.connectivity_tests,
            filter=self.filter,
            id=self.id,
            project=self.project)


def get_connectivity_tests(filter: Optional[_builtins.str] = None,
                           project: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectivityTestsResult:
    """
    A connectivity test is a static analysis of your resource configurations
    that enables you to evaluate connectivity to and from Google Cloud
    resources in your Virtual Private Cloud (VPC) network. This data source allows
    you to list connectivity tests in a project.

    To get more information about connectivity tests, see:

    * [API documentation](https://cloud.google.com/network-intelligence-center/docs/reference/networkmanagement/rest/v1/projects.locations.global.connectivityTests/rerun)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/network-intelligence-center/docs)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    tests = gcp.networkmanagement.get_connectivity_tests(filter="name:projects/project-id/locations/global/connectivityTests/my-tests")
    ```


    :param _builtins.str filter: Lists the ConnectivityTests that match the [filter expression](https://cloud.google.com/network-intelligence-center/docs/reference/networkmanagement/rest/v1/projects.locations.global.connectivityTests/list#query-parameters). A filter expression filters the resources listed in the response.
    :param _builtins.str project: The ID of the project.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:networkmanagement/getConnectivityTests:getConnectivityTests', __args__, opts=opts, typ=GetConnectivityTestsResult).value

    return AwaitableGetConnectivityTestsResult(
        connectivity_tests=pulumi.get(__ret__, 'connectivity_tests'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'))
def get_connectivity_tests_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectivityTestsResult]:
    """
    A connectivity test is a static analysis of your resource configurations
    that enables you to evaluate connectivity to and from Google Cloud
    resources in your Virtual Private Cloud (VPC) network. This data source allows
    you to list connectivity tests in a project.

    To get more information about connectivity tests, see:

    * [API documentation](https://cloud.google.com/network-intelligence-center/docs/reference/networkmanagement/rest/v1/projects.locations.global.connectivityTests/rerun)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/network-intelligence-center/docs)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    tests = gcp.networkmanagement.get_connectivity_tests(filter="name:projects/project-id/locations/global/connectivityTests/my-tests")
    ```


    :param _builtins.str filter: Lists the ConnectivityTests that match the [filter expression](https://cloud.google.com/network-intelligence-center/docs/reference/networkmanagement/rest/v1/projects.locations.global.connectivityTests/list#query-parameters). A filter expression filters the resources listed in the response.
    :param _builtins.str project: The ID of the project.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:networkmanagement/getConnectivityTests:getConnectivityTests', __args__, opts=opts, typ=GetConnectivityTestsResult)
    return __ret__.apply(lambda __response__: GetConnectivityTestsResult(
        connectivity_tests=pulumi.get(__response__, 'connectivity_tests'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project')))
