# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OrganizationVpcFlowLogsConfigArgs', 'OrganizationVpcFlowLogsConfig']

@pulumi.input_type
class OrganizationVpcFlowLogsConfigArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 organization: pulumi.Input[_builtins.str],
                 vpc_flow_logs_config_id: pulumi.Input[_builtins.str],
                 aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_project_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_expr: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_sampling: Optional[pulumi.Input[_builtins.float]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationVpcFlowLogsConfig resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource
               within its parent collection as described in https://google.aip.dev/122. See documentation
               for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        :param pulumi.Input[_builtins.str] organization: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] vpc_flow_logs_config_id: Required. ID of the `VpcFlowLogsConfig`.
        :param pulumi.Input[_builtins.str] aggregation_interval: Optional. The aggregation interval for the logs. Default value is
               INTERVAL_5_SEC.   Possible values: INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN
        :param pulumi.Input[_builtins.str] cross_project_metadata: Determines whether to include cross project annotations in the logs.
               This field is available only for organization configurations. If not
               specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
               Possible values:
               CROSS_PROJECT_METADATA_ENABLED
               CROSS_PROJECT_METADATA_DISABLED
               Possible values are: `CROSS_PROJECT_METADATA_ENABLED`, `CROSS_PROJECT_METADATA_DISABLED`.
        :param pulumi.Input[_builtins.str] description: Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
               of 512 characters.
        :param pulumi.Input[_builtins.str] filter_expr: Optional. Export filter used to define which VPC Flow Logs should be logged.
        :param pulumi.Input[_builtins.float] flow_sampling: Optional. The value of the field must be in (0, 1]. The sampling rate
               of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
               sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
               the state field instead. Default value is 1.0
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels to represent the user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] metadata: Optional. Configures whether all, none or a subset of metadata fields
               should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
               Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metadata_fields: Optional. Custom metadata fields to include in the reported VPC flow
               logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        :param pulumi.Input[_builtins.str] state: Optional. The state of the VPC Flow Log configuration. Default value
               is ENABLED. When creating a new configuration, it must be enabled.
               Possible values: ENABLED DISABLED
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "vpc_flow_logs_config_id", vpc_flow_logs_config_id)
        if aggregation_interval is not None:
            pulumi.set(__self__, "aggregation_interval", aggregation_interval)
        if cross_project_metadata is not None:
            pulumi.set(__self__, "cross_project_metadata", cross_project_metadata)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter_expr is not None:
            pulumi.set(__self__, "filter_expr", filter_expr)
        if flow_sampling is not None:
            pulumi.set(__self__, "flow_sampling", flow_sampling)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fields is not None:
            pulumi.set(__self__, "metadata_fields", metadata_fields)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource
        within its parent collection as described in https://google.aip.dev/122. See documentation
        for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="vpcFlowLogsConfigId")
    def vpc_flow_logs_config_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required. ID of the `VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "vpc_flow_logs_config_id")

    @vpc_flow_logs_config_id.setter
    def vpc_flow_logs_config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_flow_logs_config_id", value)

    @_builtins.property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The aggregation interval for the logs. Default value is
        INTERVAL_5_SEC.   Possible values: INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN
        """
        return pulumi.get(self, "aggregation_interval")

    @aggregation_interval.setter
    def aggregation_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_interval", value)

    @_builtins.property
    @pulumi.getter(name="crossProjectMetadata")
    def cross_project_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines whether to include cross project annotations in the logs.
        This field is available only for organization configurations. If not
        specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
        Possible values:
        CROSS_PROJECT_METADATA_ENABLED
        CROSS_PROJECT_METADATA_DISABLED
        Possible values are: `CROSS_PROJECT_METADATA_ENABLED`, `CROSS_PROJECT_METADATA_DISABLED`.
        """
        return pulumi.get(self, "cross_project_metadata")

    @cross_project_metadata.setter
    def cross_project_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_project_metadata", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
        of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="filterExpr")
    def filter_expr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Export filter used to define which VPC Flow Logs should be logged.
        """
        return pulumi.get(self, "filter_expr")

    @filter_expr.setter
    def filter_expr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_expr", value)

    @_builtins.property
    @pulumi.getter(name="flowSampling")
    def flow_sampling(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Optional. The value of the field must be in (0, 1]. The sampling rate
        of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
        sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
        the state field instead. Default value is 1.0
        """
        return pulumi.get(self, "flow_sampling")

    @flow_sampling.setter
    def flow_sampling(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "flow_sampling", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Resource labels to represent the user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Configures whether all, none or a subset of metadata fields
        should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
        Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. Custom metadata fields to include in the reported VPC flow
        logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        """
        return pulumi.get(self, "metadata_fields")

    @metadata_fields.setter
    def metadata_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata_fields", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The state of the VPC Flow Log configuration. Default value
        is ENABLED. When creating a new configuration, it must be enabled.
        Possible values: ENABLED DISABLED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _OrganizationVpcFlowLogsConfigState:
    def __init__(__self__, *,
                 aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_project_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 filter_expr: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_sampling: Optional[pulumi.Input[_builtins.float]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_flow_logs_config_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationVpcFlowLogsConfig resources.
        :param pulumi.Input[_builtins.str] aggregation_interval: Optional. The aggregation interval for the logs. Default value is
               INTERVAL_5_SEC.   Possible values: INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN
        :param pulumi.Input[_builtins.str] create_time: Output only. The time the config was created.
        :param pulumi.Input[_builtins.str] cross_project_metadata: Determines whether to include cross project annotations in the logs.
               This field is available only for organization configurations. If not
               specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
               Possible values:
               CROSS_PROJECT_METADATA_ENABLED
               CROSS_PROJECT_METADATA_DISABLED
               Possible values are: `CROSS_PROJECT_METADATA_ENABLED`, `CROSS_PROJECT_METADATA_DISABLED`.
        :param pulumi.Input[_builtins.str] description: Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
               of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] filter_expr: Optional. Export filter used to define which VPC Flow Logs should be logged.
        :param pulumi.Input[_builtins.float] flow_sampling: Optional. The value of the field must be in (0, 1]. The sampling rate
               of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
               sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
               the state field instead. Default value is 1.0
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels to represent the user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource
               within its parent collection as described in https://google.aip.dev/122. See documentation
               for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        :param pulumi.Input[_builtins.str] metadata: Optional. Configures whether all, none or a subset of metadata fields
               should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
               Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metadata_fields: Optional. Custom metadata fields to include in the reported VPC flow
               logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        :param pulumi.Input[_builtins.str] name: Identifier. Unique name of the configuration using the form:     `organizations/{org_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
        :param pulumi.Input[_builtins.str] organization: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: Optional. The state of the VPC Flow Log configuration. Default value
               is ENABLED. When creating a new configuration, it must be enabled.
               Possible values: ENABLED DISABLED
        :param pulumi.Input[_builtins.str] update_time: Output only. The time the config was updated.
        :param pulumi.Input[_builtins.str] vpc_flow_logs_config_id: Required. ID of the `VpcFlowLogsConfig`.
        """
        if aggregation_interval is not None:
            pulumi.set(__self__, "aggregation_interval", aggregation_interval)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_project_metadata is not None:
            pulumi.set(__self__, "cross_project_metadata", cross_project_metadata)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if filter_expr is not None:
            pulumi.set(__self__, "filter_expr", filter_expr)
        if flow_sampling is not None:
            pulumi.set(__self__, "flow_sampling", flow_sampling)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fields is not None:
            pulumi.set(__self__, "metadata_fields", metadata_fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpc_flow_logs_config_id is not None:
            pulumi.set(__self__, "vpc_flow_logs_config_id", vpc_flow_logs_config_id)

    @_builtins.property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The aggregation interval for the logs. Default value is
        INTERVAL_5_SEC.   Possible values: INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN
        """
        return pulumi.get(self, "aggregation_interval")

    @aggregation_interval.setter
    def aggregation_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_interval", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The time the config was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossProjectMetadata")
    def cross_project_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines whether to include cross project annotations in the logs.
        This field is available only for organization configurations. If not
        specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
        Possible values:
        CROSS_PROJECT_METADATA_ENABLED
        CROSS_PROJECT_METADATA_DISABLED
        Possible values are: `CROSS_PROJECT_METADATA_ENABLED`, `CROSS_PROJECT_METADATA_DISABLED`.
        """
        return pulumi.get(self, "cross_project_metadata")

    @cross_project_metadata.setter
    def cross_project_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_project_metadata", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
        of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="filterExpr")
    def filter_expr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Export filter used to define which VPC Flow Logs should be logged.
        """
        return pulumi.get(self, "filter_expr")

    @filter_expr.setter
    def filter_expr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_expr", value)

    @_builtins.property
    @pulumi.getter(name="flowSampling")
    def flow_sampling(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Optional. The value of the field must be in (0, 1]. The sampling rate
        of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
        sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
        the state field instead. Default value is 1.0
        """
        return pulumi.get(self, "flow_sampling")

    @flow_sampling.setter
    def flow_sampling(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "flow_sampling", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Resource labels to represent the user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource
        within its parent collection as described in https://google.aip.dev/122. See documentation
        for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Configures whether all, none or a subset of metadata fields
        should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
        Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. Custom metadata fields to include in the reported VPC flow
        logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        """
        return pulumi.get(self, "metadata_fields")

    @metadata_fields.setter
    def metadata_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata_fields", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Unique name of the configuration using the form:     `organizations/{org_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The state of the VPC Flow Log configuration. Default value
        is ENABLED. When creating a new configuration, it must be enabled.
        Possible values: ENABLED DISABLED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The time the config was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcFlowLogsConfigId")
    def vpc_flow_logs_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. ID of the `VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "vpc_flow_logs_config_id")

    @vpc_flow_logs_config_id.setter
    def vpc_flow_logs_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_flow_logs_config_id", value)


@pulumi.type_token("gcp:networkmanagement/organizationVpcFlowLogsConfig:OrganizationVpcFlowLogsConfig")
class OrganizationVpcFlowLogsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_project_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_expr: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_sampling: Optional[pulumi.Input[_builtins.float]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_flow_logs_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        VPC Flow Logs Config is a resource that lets you configure Flow Logs for Organization.

        ## Example Usage

        ### Network Management Org Vpc Flow Logs Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        org_test = gcp.networkmanagement.OrganizationVpcFlowLogsConfig("org-test",
            vpc_flow_logs_config_id="basic-org-test-id",
            location="global",
            organization="123456789")
        ```

        ## Import

        OrganizationVpcFlowLogsConfig can be imported using any of these accepted formats:

        * `organizations/{{organization}}/locations/{{location}}/vpcFlowLogsConfigs/{{vpc_flow_logs_config_id}}`

        * `{{organization}}/{{location}}/{{vpc_flow_logs_config_id}}`

        When using the `pulumi import` command, OrganizationVpcFlowLogsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkmanagement/organizationVpcFlowLogsConfig:OrganizationVpcFlowLogsConfig default organizations/{{organization}}/locations/{{location}}/vpcFlowLogsConfigs/{{vpc_flow_logs_config_id}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/organizationVpcFlowLogsConfig:OrganizationVpcFlowLogsConfig default {{organization}}/{{location}}/{{vpc_flow_logs_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregation_interval: Optional. The aggregation interval for the logs. Default value is
               INTERVAL_5_SEC.   Possible values: INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN
        :param pulumi.Input[_builtins.str] cross_project_metadata: Determines whether to include cross project annotations in the logs.
               This field is available only for organization configurations. If not
               specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
               Possible values:
               CROSS_PROJECT_METADATA_ENABLED
               CROSS_PROJECT_METADATA_DISABLED
               Possible values are: `CROSS_PROJECT_METADATA_ENABLED`, `CROSS_PROJECT_METADATA_DISABLED`.
        :param pulumi.Input[_builtins.str] description: Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
               of 512 characters.
        :param pulumi.Input[_builtins.str] filter_expr: Optional. Export filter used to define which VPC Flow Logs should be logged.
        :param pulumi.Input[_builtins.float] flow_sampling: Optional. The value of the field must be in (0, 1]. The sampling rate
               of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
               sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
               the state field instead. Default value is 1.0
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels to represent the user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource
               within its parent collection as described in https://google.aip.dev/122. See documentation
               for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        :param pulumi.Input[_builtins.str] metadata: Optional. Configures whether all, none or a subset of metadata fields
               should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
               Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metadata_fields: Optional. Custom metadata fields to include in the reported VPC flow
               logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        :param pulumi.Input[_builtins.str] organization: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] state: Optional. The state of the VPC Flow Log configuration. Default value
               is ENABLED. When creating a new configuration, it must be enabled.
               Possible values: ENABLED DISABLED
        :param pulumi.Input[_builtins.str] vpc_flow_logs_config_id: Required. ID of the `VpcFlowLogsConfig`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationVpcFlowLogsConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        VPC Flow Logs Config is a resource that lets you configure Flow Logs for Organization.

        ## Example Usage

        ### Network Management Org Vpc Flow Logs Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        org_test = gcp.networkmanagement.OrganizationVpcFlowLogsConfig("org-test",
            vpc_flow_logs_config_id="basic-org-test-id",
            location="global",
            organization="123456789")
        ```

        ## Import

        OrganizationVpcFlowLogsConfig can be imported using any of these accepted formats:

        * `organizations/{{organization}}/locations/{{location}}/vpcFlowLogsConfigs/{{vpc_flow_logs_config_id}}`

        * `{{organization}}/{{location}}/{{vpc_flow_logs_config_id}}`

        When using the `pulumi import` command, OrganizationVpcFlowLogsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkmanagement/organizationVpcFlowLogsConfig:OrganizationVpcFlowLogsConfig default organizations/{{organization}}/locations/{{location}}/vpcFlowLogsConfigs/{{vpc_flow_logs_config_id}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/organizationVpcFlowLogsConfig:OrganizationVpcFlowLogsConfig default {{organization}}/{{location}}/{{vpc_flow_logs_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationVpcFlowLogsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationVpcFlowLogsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_project_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_expr: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_sampling: Optional[pulumi.Input[_builtins.float]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_flow_logs_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationVpcFlowLogsConfigArgs.__new__(OrganizationVpcFlowLogsConfigArgs)

            __props__.__dict__["aggregation_interval"] = aggregation_interval
            __props__.__dict__["cross_project_metadata"] = cross_project_metadata
            __props__.__dict__["description"] = description
            __props__.__dict__["filter_expr"] = filter_expr
            __props__.__dict__["flow_sampling"] = flow_sampling
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metadata_fields"] = metadata_fields
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["state"] = state
            if vpc_flow_logs_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_flow_logs_config_id'")
            __props__.__dict__["vpc_flow_logs_config_id"] = vpc_flow_logs_config_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OrganizationVpcFlowLogsConfig, __self__).__init__(
            'gcp:networkmanagement/organizationVpcFlowLogsConfig:OrganizationVpcFlowLogsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_project_metadata: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            filter_expr: Optional[pulumi.Input[_builtins.str]] = None,
            flow_sampling: Optional[pulumi.Input[_builtins.float]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[_builtins.str]] = None,
            metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_flow_logs_config_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationVpcFlowLogsConfig':
        """
        Get an existing OrganizationVpcFlowLogsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregation_interval: Optional. The aggregation interval for the logs. Default value is
               INTERVAL_5_SEC.   Possible values: INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN
        :param pulumi.Input[_builtins.str] create_time: Output only. The time the config was created.
        :param pulumi.Input[_builtins.str] cross_project_metadata: Determines whether to include cross project annotations in the logs.
               This field is available only for organization configurations. If not
               specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
               Possible values:
               CROSS_PROJECT_METADATA_ENABLED
               CROSS_PROJECT_METADATA_DISABLED
               Possible values are: `CROSS_PROJECT_METADATA_ENABLED`, `CROSS_PROJECT_METADATA_DISABLED`.
        :param pulumi.Input[_builtins.str] description: Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
               of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] filter_expr: Optional. Export filter used to define which VPC Flow Logs should be logged.
        :param pulumi.Input[_builtins.float] flow_sampling: Optional. The value of the field must be in (0, 1]. The sampling rate
               of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
               sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
               the state field instead. Default value is 1.0
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels to represent the user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource
               within its parent collection as described in https://google.aip.dev/122. See documentation
               for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        :param pulumi.Input[_builtins.str] metadata: Optional. Configures whether all, none or a subset of metadata fields
               should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
               Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metadata_fields: Optional. Custom metadata fields to include in the reported VPC flow
               logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        :param pulumi.Input[_builtins.str] name: Identifier. Unique name of the configuration using the form:     `organizations/{org_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
        :param pulumi.Input[_builtins.str] organization: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: Optional. The state of the VPC Flow Log configuration. Default value
               is ENABLED. When creating a new configuration, it must be enabled.
               Possible values: ENABLED DISABLED
        :param pulumi.Input[_builtins.str] update_time: Output only. The time the config was updated.
        :param pulumi.Input[_builtins.str] vpc_flow_logs_config_id: Required. ID of the `VpcFlowLogsConfig`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationVpcFlowLogsConfigState.__new__(_OrganizationVpcFlowLogsConfigState)

        __props__.__dict__["aggregation_interval"] = aggregation_interval
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_project_metadata"] = cross_project_metadata
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["filter_expr"] = filter_expr
        __props__.__dict__["flow_sampling"] = flow_sampling
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_fields"] = metadata_fields
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpc_flow_logs_config_id"] = vpc_flow_logs_config_id
        return OrganizationVpcFlowLogsConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. The aggregation interval for the logs. Default value is
        INTERVAL_5_SEC.   Possible values: INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN
        """
        return pulumi.get(self, "aggregation_interval")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The time the config was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossProjectMetadata")
    def cross_project_metadata(self) -> pulumi.Output[_builtins.str]:
        """
        Determines whether to include cross project annotations in the logs.
        This field is available only for organization configurations. If not
        specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
        Possible values:
        CROSS_PROJECT_METADATA_ENABLED
        CROSS_PROJECT_METADATA_DISABLED
        Possible values are: `CROSS_PROJECT_METADATA_ENABLED`, `CROSS_PROJECT_METADATA_DISABLED`.
        """
        return pulumi.get(self, "cross_project_metadata")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
        of 512 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="filterExpr")
    def filter_expr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Export filter used to define which VPC Flow Logs should be logged.
        """
        return pulumi.get(self, "filter_expr")

    @_builtins.property
    @pulumi.getter(name="flowSampling")
    def flow_sampling(self) -> pulumi.Output[_builtins.float]:
        """
        Optional. The value of the field must be in (0, 1]. The sampling rate
        of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
        sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
        the state field instead. Default value is 1.0
        """
        return pulumi.get(self, "flow_sampling")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Resource labels to represent the user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource
        within its parent collection as described in https://google.aip.dev/122. See documentation
        for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. Configures whether all, none or a subset of metadata fields
        should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
        Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Optional. Custom metadata fields to include in the reported VPC flow
        logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        """
        return pulumi.get(self, "metadata_fields")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Unique name of the configuration using the form:     `organizations/{org_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. The state of the VPC Flow Log configuration. Default value
        is ENABLED. When creating a new configuration, it must be enabled.
        Possible values: ENABLED DISABLED
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The time the config was updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="vpcFlowLogsConfigId")
    def vpc_flow_logs_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required. ID of the `VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "vpc_flow_logs_config_id")

