# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectivityTestDestination',
    'ConnectivityTestSource',
    'ConnectivityTestSourceAppEngineVersion',
    'ConnectivityTestSourceCloudFunction',
    'ConnectivityTestSourceCloudRunRevision',
    'GetConnectivityTestRunReachabilityDetailResult',
    'GetConnectivityTestRunReachabilityDetailTraceResult',
    'GetConnectivityTestRunReachabilityDetailTraceEndpointInfoResult',
    'GetConnectivityTestRunReachabilityDetailTraceStepResult',
    'GetConnectivityTestsConnectivityTestResult',
    'GetConnectivityTestsConnectivityTestDestinationResult',
    'GetConnectivityTestsConnectivityTestSourceResult',
    'GetConnectivityTestsConnectivityTestSourceAppEngineVersionResult',
    'GetConnectivityTestsConnectivityTestSourceCloudFunctionResult',
    'GetConnectivityTestsConnectivityTestSourceCloudRunRevisionResult',
]

@pulumi.output_type
class ConnectivityTestDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "forwardingRule":
            suggest = "forwarding_rule"
        elif key == "gkeMasterCluster":
            suggest = "gke_master_cluster"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "redisCluster":
            suggest = "redis_cluster"
        elif key == "redisInstance":
            suggest = "redis_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectivityTestDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectivityTestDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectivityTestDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_sql_instance: Optional[_builtins.str] = None,
                 forwarding_rule: Optional[_builtins.str] = None,
                 fqdn: Optional[_builtins.str] = None,
                 gke_master_cluster: Optional[_builtins.str] = None,
                 instance: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 project_id: Optional[_builtins.str] = None,
                 redis_cluster: Optional[_builtins.str] = None,
                 redis_instance: Optional[_builtins.str] = None):
        """
        :param _builtins.str cloud_sql_instance: A Cloud SQL instance URI.
        :param _builtins.str forwarding_rule: Forwarding rule URI. Forwarding rules are frontends for load balancers,
               PSC endpoints, and Protocol Forwarding.
        :param _builtins.str fqdn: A DNS endpoint of Google Kubernetes Engine cluster control plane.
               Requires gke_master_cluster to be set, can't be used simultaneoulsly with
               ip_address or network. Applicable only to destination endpoint.
        :param _builtins.str gke_master_cluster: A cluster URI for Google Kubernetes Engine cluster control plane.
        :param _builtins.str instance: A Compute Engine instance URI.
        :param _builtins.str ip_address: The IP address of the endpoint, which can be an external or internal IP.
        :param _builtins.str network: A VPC network URI.
        :param _builtins.int port: The IP protocol port of the endpoint. Only applicable when protocol is
               TCP or UDP.
        :param _builtins.str project_id: Project ID where the endpoint is located.
               The project ID can be derived from the URI if you provide a endpoint or
               network URI.
               The following are two cases where you may need to provide the project ID:
               1. Only the IP address is specified, and the IP address is within a Google
               Cloud project.
               2. When you are using Shared VPC and the IP address that you provide is
               from the service project. In this case, the network that the IP address
               resides in is defined in the host project.
        :param _builtins.str redis_cluster: A Redis Cluster URI.
        :param _builtins.str redis_instance: A Redis Instance URI.
        """
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if forwarding_rule is not None:
            pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if gke_master_cluster is not None:
            pulumi.set(__self__, "gke_master_cluster", gke_master_cluster)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if redis_cluster is not None:
            pulumi.set(__self__, "redis_cluster", redis_cluster)
        if redis_instance is not None:
            pulumi.set(__self__, "redis_instance", redis_instance)

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional[_builtins.str]:
        """
        A Cloud SQL instance URI.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @_builtins.property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> Optional[_builtins.str]:
        """
        Forwarding rule URI. Forwarding rules are frontends for load balancers,
        PSC endpoints, and Protocol Forwarding.
        """
        return pulumi.get(self, "forwarding_rule")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[_builtins.str]:
        """
        A DNS endpoint of Google Kubernetes Engine cluster control plane.
        Requires gke_master_cluster to be set, can't be used simultaneoulsly with
        ip_address or network. Applicable only to destination endpoint.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="gkeMasterCluster")
    def gke_master_cluster(self) -> Optional[_builtins.str]:
        """
        A cluster URI for Google Kubernetes Engine cluster control plane.
        """
        return pulumi.get(self, "gke_master_cluster")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[_builtins.str]:
        """
        A Compute Engine instance URI.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address of the endpoint, which can be an external or internal IP.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        A VPC network URI.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The IP protocol port of the endpoint. Only applicable when protocol is
        TCP or UDP.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Project ID where the endpoint is located.
        The project ID can be derived from the URI if you provide a endpoint or
        network URI.
        The following are two cases where you may need to provide the project ID:
        1. Only the IP address is specified, and the IP address is within a Google
        Cloud project.
        2. When you are using Shared VPC and the IP address that you provide is
        from the service project. In this case, the network that the IP address
        resides in is defined in the host project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="redisCluster")
    def redis_cluster(self) -> Optional[_builtins.str]:
        """
        A Redis Cluster URI.
        """
        return pulumi.get(self, "redis_cluster")

    @_builtins.property
    @pulumi.getter(name="redisInstance")
    def redis_instance(self) -> Optional[_builtins.str]:
        """
        A Redis Instance URI.
        """
        return pulumi.get(self, "redis_instance")


@pulumi.output_type
class ConnectivityTestSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appEngineVersion":
            suggest = "app_engine_version"
        elif key == "cloudFunction":
            suggest = "cloud_function"
        elif key == "cloudRunRevision":
            suggest = "cloud_run_revision"
        elif key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "gkeMasterCluster":
            suggest = "gke_master_cluster"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectivityTestSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectivityTestSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectivityTestSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_engine_version: Optional['outputs.ConnectivityTestSourceAppEngineVersion'] = None,
                 cloud_function: Optional['outputs.ConnectivityTestSourceCloudFunction'] = None,
                 cloud_run_revision: Optional['outputs.ConnectivityTestSourceCloudRunRevision'] = None,
                 cloud_sql_instance: Optional[_builtins.str] = None,
                 gke_master_cluster: Optional[_builtins.str] = None,
                 instance: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None,
                 network_type: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 project_id: Optional[_builtins.str] = None):
        """
        :param 'ConnectivityTestSourceAppEngineVersionArgs' app_engine_version: An App Engine service version.
               Structure is documented below.
        :param 'ConnectivityTestSourceCloudFunctionArgs' cloud_function: A Cloud Function.
               Structure is documented below.
        :param 'ConnectivityTestSourceCloudRunRevisionArgs' cloud_run_revision: A Cloud Run revision.
               Structure is documented below.
        :param _builtins.str cloud_sql_instance: A Cloud SQL instance URI.
        :param _builtins.str gke_master_cluster: A cluster URI for Google Kubernetes Engine cluster control plane.
        :param _builtins.str instance: A Compute Engine instance URI.
        :param _builtins.str ip_address: The IP address of the endpoint, which can be an external or internal IP.
        :param _builtins.str network: A VPC network URI.
        :param _builtins.str network_type: Type of the network where the endpoint is located.
               Possible values are: `GCP_NETWORK`, `NON_GCP_NETWORK`.
        :param _builtins.int port: The IP protocol port of the endpoint. Only applicable when protocol is
               TCP or UDP.
        :param _builtins.str project_id: Project ID where the endpoint is located.
               The project ID can be derived from the URI if you provide a endpoint or
               network URI.
               The following are two cases where you may need to provide the project ID:
               1. Only the IP address is specified, and the IP address is within a Google
               Cloud project.
               2. When you are using Shared VPC and the IP address that you provide is
               from the service project. In this case, the network that the IP address
               resides in is defined in the host project.
        """
        if app_engine_version is not None:
            pulumi.set(__self__, "app_engine_version", app_engine_version)
        if cloud_function is not None:
            pulumi.set(__self__, "cloud_function", cloud_function)
        if cloud_run_revision is not None:
            pulumi.set(__self__, "cloud_run_revision", cloud_run_revision)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if gke_master_cluster is not None:
            pulumi.set(__self__, "gke_master_cluster", gke_master_cluster)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="appEngineVersion")
    def app_engine_version(self) -> Optional['outputs.ConnectivityTestSourceAppEngineVersion']:
        """
        An App Engine service version.
        Structure is documented below.
        """
        return pulumi.get(self, "app_engine_version")

    @_builtins.property
    @pulumi.getter(name="cloudFunction")
    def cloud_function(self) -> Optional['outputs.ConnectivityTestSourceCloudFunction']:
        """
        A Cloud Function.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_function")

    @_builtins.property
    @pulumi.getter(name="cloudRunRevision")
    def cloud_run_revision(self) -> Optional['outputs.ConnectivityTestSourceCloudRunRevision']:
        """
        A Cloud Run revision.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_run_revision")

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional[_builtins.str]:
        """
        A Cloud SQL instance URI.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @_builtins.property
    @pulumi.getter(name="gkeMasterCluster")
    def gke_master_cluster(self) -> Optional[_builtins.str]:
        """
        A cluster URI for Google Kubernetes Engine cluster control plane.
        """
        return pulumi.get(self, "gke_master_cluster")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[_builtins.str]:
        """
        A Compute Engine instance URI.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address of the endpoint, which can be an external or internal IP.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        A VPC network URI.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[_builtins.str]:
        """
        Type of the network where the endpoint is located.
        Possible values are: `GCP_NETWORK`, `NON_GCP_NETWORK`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The IP protocol port of the endpoint. Only applicable when protocol is
        TCP or UDP.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Project ID where the endpoint is located.
        The project ID can be derived from the URI if you provide a endpoint or
        network URI.
        The following are two cases where you may need to provide the project ID:
        1. Only the IP address is specified, and the IP address is within a Google
        Cloud project.
        2. When you are using Shared VPC and the IP address that you provide is
        from the service project. In this case, the network that the IP address
        resides in is defined in the host project.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class ConnectivityTestSourceAppEngineVersion(dict):
    def __init__(__self__, *,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: An App Engine service version name.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        An App Engine service version name.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class ConnectivityTestSourceCloudFunction(dict):
    def __init__(__self__, *,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: A Cloud Function name.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        A Cloud Function name.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class ConnectivityTestSourceCloudRunRevision(dict):
    def __init__(__self__, *,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: A Cloud Run revision URI.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        A Cloud Run revision URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetConnectivityTestRunReachabilityDetailResult(dict):
    def __init__(__self__, *,
                 result: _builtins.str,
                 traces: Sequence['outputs.GetConnectivityTestRunReachabilityDetailTraceResult'],
                 verify_time: _builtins.str):
        """
        :param _builtins.str result: (Output)
               Status of the connectivity test: RESULT_UNSPECIFIED, REACHABLE, UNREACHABLE, AMBIGUOUS or UNDETERMINED.
        :param Sequence['GetConnectivityTestRunReachabilityDetailTraceArgs'] traces: (Output)
               List of connectivity test traces.
               Structure is documented below.
        :param _builtins.str verify_time: (Output)
               Time when reachability details were determined. An RFC3339 timestamp in UTC time.
               This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        """
        pulumi.set(__self__, "result", result)
        pulumi.set(__self__, "traces", traces)
        pulumi.set(__self__, "verify_time", verify_time)

    @_builtins.property
    @pulumi.getter
    def result(self) -> _builtins.str:
        """
        (Output)
        Status of the connectivity test: RESULT_UNSPECIFIED, REACHABLE, UNREACHABLE, AMBIGUOUS or UNDETERMINED.
        """
        return pulumi.get(self, "result")

    @_builtins.property
    @pulumi.getter
    def traces(self) -> Sequence['outputs.GetConnectivityTestRunReachabilityDetailTraceResult']:
        """
        (Output)
        List of connectivity test traces.
        Structure is documented below.
        """
        return pulumi.get(self, "traces")

    @_builtins.property
    @pulumi.getter(name="verifyTime")
    def verify_time(self) -> _builtins.str:
        """
        (Output)
        Time when reachability details were determined. An RFC3339 timestamp in UTC time.
        This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        """
        return pulumi.get(self, "verify_time")


@pulumi.output_type
class GetConnectivityTestRunReachabilityDetailTraceResult(dict):
    def __init__(__self__, *,
                 endpoint_infos: Sequence['outputs.GetConnectivityTestRunReachabilityDetailTraceEndpointInfoResult'],
                 forward_trace_id: _builtins.int,
                 steps: Sequence['outputs.GetConnectivityTestRunReachabilityDetailTraceStepResult']):
        """
        :param Sequence['GetConnectivityTestRunReachabilityDetailTraceEndpointInfoArgs'] endpoint_infos: (Output)
               Derived from the source and destination endpoints definition specified by user request, and validated by the data plane model.
               Structure is documented below.
        :param _builtins.int forward_trace_id: (Output)
               ID of the trace.
        :param Sequence['GetConnectivityTestRunReachabilityDetailTraceStepArgs'] steps: (Output)
               A trace of a test contains multiple steps from the initial state to the final state (delivered, dropped, forwarded, or aborted).
               Structure is documented below.
        """
        pulumi.set(__self__, "endpoint_infos", endpoint_infos)
        pulumi.set(__self__, "forward_trace_id", forward_trace_id)
        pulumi.set(__self__, "steps", steps)

    @_builtins.property
    @pulumi.getter(name="endpointInfos")
    def endpoint_infos(self) -> Sequence['outputs.GetConnectivityTestRunReachabilityDetailTraceEndpointInfoResult']:
        """
        (Output)
        Derived from the source and destination endpoints definition specified by user request, and validated by the data plane model.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_infos")

    @_builtins.property
    @pulumi.getter(name="forwardTraceId")
    def forward_trace_id(self) -> _builtins.int:
        """
        (Output)
        ID of the trace.
        """
        return pulumi.get(self, "forward_trace_id")

    @_builtins.property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.GetConnectivityTestRunReachabilityDetailTraceStepResult']:
        """
        (Output)
        A trace of a test contains multiple steps from the initial state to the final state (delivered, dropped, forwarded, or aborted).
        Structure is documented below.
        """
        return pulumi.get(self, "steps")


@pulumi.output_type
class GetConnectivityTestRunReachabilityDetailTraceEndpointInfoResult(dict):
    def __init__(__self__, *,
                 destination_ip: _builtins.str,
                 destination_network_uri: _builtins.str,
                 destination_port: _builtins.int,
                 protocol: _builtins.str,
                 source_agent_uri: _builtins.str,
                 source_ip: _builtins.str,
                 source_network_uri: _builtins.str,
                 source_port: _builtins.int):
        """
        :param _builtins.str destination_ip: (Output)
               Destination IP address.
        :param _builtins.str destination_network_uri: (Output)
               URI of the network where this packet is sent to.
        :param _builtins.int destination_port: (Output)
               Destination port. Only valid when protocol is TCP or UDP.
        :param _builtins.str protocol: (Output)
               IP protocol in string format, for example: "TCP", "UDP", "ICMP".
        :param _builtins.str source_agent_uri: (Output)
               URI of the source telemetry agent this packet originates from.
        :param _builtins.str source_ip: (Output)
               Source IP address.
        :param _builtins.str source_network_uri: (Output)
               URI of the network where this packet originates from.
        :param _builtins.int source_port: (Output)
               Source port. Only valid when protocol is TCP or UDP.
        """
        pulumi.set(__self__, "destination_ip", destination_ip)
        pulumi.set(__self__, "destination_network_uri", destination_network_uri)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_agent_uri", source_agent_uri)
        pulumi.set(__self__, "source_ip", source_ip)
        pulumi.set(__self__, "source_network_uri", source_network_uri)
        pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> _builtins.str:
        """
        (Output)
        Destination IP address.
        """
        return pulumi.get(self, "destination_ip")

    @_builtins.property
    @pulumi.getter(name="destinationNetworkUri")
    def destination_network_uri(self) -> _builtins.str:
        """
        (Output)
        URI of the network where this packet is sent to.
        """
        return pulumi.get(self, "destination_network_uri")

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> _builtins.int:
        """
        (Output)
        Destination port. Only valid when protocol is TCP or UDP.
        """
        return pulumi.get(self, "destination_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        (Output)
        IP protocol in string format, for example: "TCP", "UDP", "ICMP".
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourceAgentUri")
    def source_agent_uri(self) -> _builtins.str:
        """
        (Output)
        URI of the source telemetry agent this packet originates from.
        """
        return pulumi.get(self, "source_agent_uri")

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> _builtins.str:
        """
        (Output)
        Source IP address.
        """
        return pulumi.get(self, "source_ip")

    @_builtins.property
    @pulumi.getter(name="sourceNetworkUri")
    def source_network_uri(self) -> _builtins.str:
        """
        (Output)
        URI of the network where this packet originates from.
        """
        return pulumi.get(self, "source_network_uri")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> _builtins.int:
        """
        (Output)
        Source port. Only valid when protocol is TCP or UDP.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class GetConnectivityTestRunReachabilityDetailTraceStepResult(dict):
    def __init__(__self__, *,
                 causes_drop: _builtins.bool,
                 description: _builtins.str,
                 project_id: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.bool causes_drop: (Output)
               If this step leads to the final state Drop.
        :param _builtins.str description: (Output)
               Description of the connectivity test step.
        :param _builtins.str project_id: (Output)
               Project ID of the connectivity test step.
        :param _builtins.str state: (Output)
               State of the connectivity test step.
        """
        pulumi.set(__self__, "causes_drop", causes_drop)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="causesDrop")
    def causes_drop(self) -> _builtins.bool:
        """
        (Output)
        If this step leads to the final state Drop.
        """
        return pulumi.get(self, "causes_drop")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (Output)
        Description of the connectivity test step.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        (Output)
        Project ID of the connectivity test step.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        (Output)
        State of the connectivity test step.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetConnectivityTestsConnectivityTestResult(dict):
    def __init__(__self__, *,
                 bypass_firewall_checks: _builtins.bool,
                 description: _builtins.str,
                 destinations: Sequence['outputs.GetConnectivityTestsConnectivityTestDestinationResult'],
                 effective_labels: Mapping[str, _builtins.str],
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 project: _builtins.str,
                 protocol: _builtins.str,
                 pulumi_labels: Mapping[str, _builtins.str],
                 related_projects: Sequence[_builtins.str],
                 round_trip: _builtins.bool,
                 sources: Sequence['outputs.GetConnectivityTestsConnectivityTestSourceResult']):
        """
        :param _builtins.bool bypass_firewall_checks: Whether the analysis should skip firewall checking.
        :param _builtins.str description: The user-supplied description of the Connectivity Test.
        :param Sequence['GetConnectivityTestsConnectivityTestDestinationArgs'] destinations: Destination specification of the Connectivity Test.
               Structure is documented below.
        :param Mapping[str, _builtins.str] labels: Resource labels to represent user-provided metadata.
        :param _builtins.str name: Unique name for the connectivity test.
        :param _builtins.str project: The ID of the project.
        :param _builtins.str protocol: IP Protocol of the test.
        :param Mapping[str, _builtins.str] pulumi_labels: The combination of labels configured directly on the resource
                and default labels configured on the provider.
        :param Sequence[_builtins.str] related_projects: Other projects that may be relevant for reachability analysis.
        :param _builtins.bool round_trip: Whether run analysis for the return path from destination to source.
        :param Sequence['GetConnectivityTestsConnectivityTestSourceArgs'] sources: Source specification of the Connectivity Test.
               Structure is documented below.
        """
        pulumi.set(__self__, "bypass_firewall_checks", bypass_firewall_checks)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "effective_labels", effective_labels)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        pulumi.set(__self__, "related_projects", related_projects)
        pulumi.set(__self__, "round_trip", round_trip)
        pulumi.set(__self__, "sources", sources)

    @_builtins.property
    @pulumi.getter(name="bypassFirewallChecks")
    def bypass_firewall_checks(self) -> _builtins.bool:
        """
        Whether the analysis should skip firewall checking.
        """
        return pulumi.get(self, "bypass_firewall_checks")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The user-supplied description of the Connectivity Test.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetConnectivityTestsConnectivityTestDestinationResult']:
        """
        Destination specification of the Connectivity Test.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Resource labels to represent user-provided metadata.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name for the connectivity test.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        IP Protocol of the test.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        """
        The combination of labels configured directly on the resource
         and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="relatedProjects")
    def related_projects(self) -> Sequence[_builtins.str]:
        """
        Other projects that may be relevant for reachability analysis.
        """
        return pulumi.get(self, "related_projects")

    @_builtins.property
    @pulumi.getter(name="roundTrip")
    def round_trip(self) -> _builtins.bool:
        """
        Whether run analysis for the return path from destination to source.
        """
        return pulumi.get(self, "round_trip")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetConnectivityTestsConnectivityTestSourceResult']:
        """
        Source specification of the Connectivity Test.
        Structure is documented below.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetConnectivityTestsConnectivityTestDestinationResult(dict):
    def __init__(__self__, *,
                 cloud_sql_instance: _builtins.str,
                 forwarding_rule: _builtins.str,
                 fqdn: _builtins.str,
                 gke_master_cluster: _builtins.str,
                 instance: _builtins.str,
                 ip_address: _builtins.str,
                 network: _builtins.str,
                 port: _builtins.int,
                 project_id: _builtins.str,
                 redis_cluster: _builtins.str,
                 redis_instance: _builtins.str):
        """
        :param _builtins.str cloud_sql_instance: A Cloud SQL instance URI.
        :param _builtins.str forwarding_rule: Forwarding rule URI. Forwarding rules are frontends for load balancers,
               PSC endpoints, and Protocol Forwarding.
        :param _builtins.str fqdn: A DNS endpoint of Google Kubernetes Engine cluster control plane.
        :param _builtins.str gke_master_cluster: A cluster URI for Google Kubernetes Engine cluster control plane.
        :param _builtins.str instance: A Compute Engine instance URI.
        :param _builtins.str ip_address: The IP address of the endpoint.
        :param _builtins.str network: A VPC network URI.
        :param _builtins.int port: The IP protocol port of the endpoint.
        :param _builtins.str project_id: Project ID where the endpoint is located.
        :param _builtins.str redis_cluster: A Redis Cluster URI.
        :param _builtins.str redis_instance: A Redis Instance URI.
        """
        pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "gke_master_cluster", gke_master_cluster)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "redis_cluster", redis_cluster)
        pulumi.set(__self__, "redis_instance", redis_instance)

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> _builtins.str:
        """
        A Cloud SQL instance URI.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @_builtins.property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> _builtins.str:
        """
        Forwarding rule URI. Forwarding rules are frontends for load balancers,
        PSC endpoints, and Protocol Forwarding.
        """
        return pulumi.get(self, "forwarding_rule")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        A DNS endpoint of Google Kubernetes Engine cluster control plane.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="gkeMasterCluster")
    def gke_master_cluster(self) -> _builtins.str:
        """
        A cluster URI for Google Kubernetes Engine cluster control plane.
        """
        return pulumi.get(self, "gke_master_cluster")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        """
        A Compute Engine instance URI.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the endpoint.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        A VPC network URI.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The IP protocol port of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project ID where the endpoint is located.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="redisCluster")
    def redis_cluster(self) -> _builtins.str:
        """
        A Redis Cluster URI.
        """
        return pulumi.get(self, "redis_cluster")

    @_builtins.property
    @pulumi.getter(name="redisInstance")
    def redis_instance(self) -> _builtins.str:
        """
        A Redis Instance URI.
        """
        return pulumi.get(self, "redis_instance")


@pulumi.output_type
class GetConnectivityTestsConnectivityTestSourceResult(dict):
    def __init__(__self__, *,
                 app_engine_versions: Sequence['outputs.GetConnectivityTestsConnectivityTestSourceAppEngineVersionResult'],
                 cloud_functions: Sequence['outputs.GetConnectivityTestsConnectivityTestSourceCloudFunctionResult'],
                 cloud_run_revisions: Sequence['outputs.GetConnectivityTestsConnectivityTestSourceCloudRunRevisionResult'],
                 cloud_sql_instance: _builtins.str,
                 gke_master_cluster: _builtins.str,
                 instance: _builtins.str,
                 ip_address: _builtins.str,
                 network: _builtins.str,
                 network_type: _builtins.str,
                 port: _builtins.int,
                 project_id: _builtins.str):
        """
        :param Sequence['GetConnectivityTestsConnectivityTestSourceAppEngineVersionArgs'] app_engine_versions: An App Engine service version.
               Structure is documented below.
        :param Sequence['GetConnectivityTestsConnectivityTestSourceCloudFunctionArgs'] cloud_functions: A Cloud Function.
               Structure is documented below.
        :param Sequence['GetConnectivityTestsConnectivityTestSourceCloudRunRevisionArgs'] cloud_run_revisions: A Cloud Run revision.
               Structure is documented below.
        :param _builtins.str cloud_sql_instance: A Cloud SQL instance URI.
        :param _builtins.str gke_master_cluster: A cluster URI for Google Kubernetes Engine cluster control plane.
        :param _builtins.str instance: A Compute Engine instance URI.
        :param _builtins.str ip_address: The IP address of the endpoint.
        :param _builtins.str network: A VPC network URI.
        :param _builtins.str network_type: Type of the network where the endpoint is located.
        :param _builtins.int port: The IP protocol port of the endpoint.
        :param _builtins.str project_id: Project ID where the endpoint is located.
        """
        pulumi.set(__self__, "app_engine_versions", app_engine_versions)
        pulumi.set(__self__, "cloud_functions", cloud_functions)
        pulumi.set(__self__, "cloud_run_revisions", cloud_run_revisions)
        pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        pulumi.set(__self__, "gke_master_cluster", gke_master_cluster)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="appEngineVersions")
    def app_engine_versions(self) -> Sequence['outputs.GetConnectivityTestsConnectivityTestSourceAppEngineVersionResult']:
        """
        An App Engine service version.
        Structure is documented below.
        """
        return pulumi.get(self, "app_engine_versions")

    @_builtins.property
    @pulumi.getter(name="cloudFunctions")
    def cloud_functions(self) -> Sequence['outputs.GetConnectivityTestsConnectivityTestSourceCloudFunctionResult']:
        """
        A Cloud Function.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_functions")

    @_builtins.property
    @pulumi.getter(name="cloudRunRevisions")
    def cloud_run_revisions(self) -> Sequence['outputs.GetConnectivityTestsConnectivityTestSourceCloudRunRevisionResult']:
        """
        A Cloud Run revision.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_run_revisions")

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> _builtins.str:
        """
        A Cloud SQL instance URI.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @_builtins.property
    @pulumi.getter(name="gkeMasterCluster")
    def gke_master_cluster(self) -> _builtins.str:
        """
        A cluster URI for Google Kubernetes Engine cluster control plane.
        """
        return pulumi.get(self, "gke_master_cluster")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        """
        A Compute Engine instance URI.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the endpoint.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        A VPC network URI.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        Type of the network where the endpoint is located.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The IP protocol port of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project ID where the endpoint is located.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetConnectivityTestsConnectivityTestSourceAppEngineVersionResult(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: A Cloud Run revision URI.
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        A Cloud Run revision URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetConnectivityTestsConnectivityTestSourceCloudFunctionResult(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: A Cloud Run revision URI.
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        A Cloud Run revision URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetConnectivityTestsConnectivityTestSourceCloudRunRevisionResult(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: A Cloud Run revision URI.
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        A Cloud Run revision URI.
        """
        return pulumi.get(self, "uri")


