# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityProfileArgs', 'SecurityProfile']

@pulumi.input_type
class SecurityProfileArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 custom_intercept_profile: Optional[pulumi.Input['SecurityProfileCustomInterceptProfileArgs']] = None,
                 custom_mirroring_profile: Optional[pulumi.Input['SecurityProfileCustomMirroringProfileArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_prevention_profile: Optional[pulumi.Input['SecurityProfileThreatPreventionProfileArgs']] = None,
                 url_filtering_profile: Optional[pulumi.Input['SecurityProfileUrlFilteringProfileArgs']] = None):
        """
        The set of arguments for constructing a SecurityProfile resource.
        :param pulumi.Input[_builtins.str] type: The type of security profile.
               Possible values are: `THREAT_PREVENTION`, `URL_FILTERING`, `CUSTOM_MIRRORING`, `CUSTOM_INTERCEPT`.
        :param pulumi.Input['SecurityProfileCustomInterceptProfileArgs'] custom_intercept_profile: The configuration for defining the Intercept Endpoint Group used to
               intercept traffic to third-party firewall appliances.
               Structure is documented below.
        :param pulumi.Input['SecurityProfileCustomMirroringProfileArgs'] custom_mirroring_profile: The configuration for defining the Mirroring Endpoint Group used to
               mirror traffic to third-party collectors.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of the security profile. The Max length is 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the security profile.
               The default value is `global`.
        :param pulumi.Input[_builtins.str] name: The name of the security profile resource.
        :param pulumi.Input[_builtins.str] parent: The name of the parent this security profile belongs to.
               Format: organizations/{organization_id}.
        :param pulumi.Input['SecurityProfileThreatPreventionProfileArgs'] threat_prevention_profile: The threat prevention configuration for the security profile.
               Structure is documented below.
        :param pulumi.Input['SecurityProfileUrlFilteringProfileArgs'] url_filtering_profile: The url filtering configuration for the security profile.
               Structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if custom_intercept_profile is not None:
            pulumi.set(__self__, "custom_intercept_profile", custom_intercept_profile)
        if custom_mirroring_profile is not None:
            pulumi.set(__self__, "custom_mirroring_profile", custom_mirroring_profile)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if threat_prevention_profile is not None:
            pulumi.set(__self__, "threat_prevention_profile", threat_prevention_profile)
        if url_filtering_profile is not None:
            pulumi.set(__self__, "url_filtering_profile", url_filtering_profile)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of security profile.
        Possible values are: `THREAT_PREVENTION`, `URL_FILTERING`, `CUSTOM_MIRRORING`, `CUSTOM_INTERCEPT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="customInterceptProfile")
    def custom_intercept_profile(self) -> Optional[pulumi.Input['SecurityProfileCustomInterceptProfileArgs']]:
        """
        The configuration for defining the Intercept Endpoint Group used to
        intercept traffic to third-party firewall appliances.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_intercept_profile")

    @custom_intercept_profile.setter
    def custom_intercept_profile(self, value: Optional[pulumi.Input['SecurityProfileCustomInterceptProfileArgs']]):
        pulumi.set(self, "custom_intercept_profile", value)

    @_builtins.property
    @pulumi.getter(name="customMirroringProfile")
    def custom_mirroring_profile(self) -> Optional[pulumi.Input['SecurityProfileCustomMirroringProfileArgs']]:
        """
        The configuration for defining the Mirroring Endpoint Group used to
        mirror traffic to third-party collectors.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_mirroring_profile")

    @custom_mirroring_profile.setter
    def custom_mirroring_profile(self, value: Optional[pulumi.Input['SecurityProfileCustomMirroringProfileArgs']]):
        pulumi.set(self, "custom_mirroring_profile", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of the security profile. The Max length is 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the security profile.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security profile resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the parent this security profile belongs to.
        Format: organizations/{organization_id}.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="threatPreventionProfile")
    def threat_prevention_profile(self) -> Optional[pulumi.Input['SecurityProfileThreatPreventionProfileArgs']]:
        """
        The threat prevention configuration for the security profile.
        Structure is documented below.
        """
        return pulumi.get(self, "threat_prevention_profile")

    @threat_prevention_profile.setter
    def threat_prevention_profile(self, value: Optional[pulumi.Input['SecurityProfileThreatPreventionProfileArgs']]):
        pulumi.set(self, "threat_prevention_profile", value)

    @_builtins.property
    @pulumi.getter(name="urlFilteringProfile")
    def url_filtering_profile(self) -> Optional[pulumi.Input['SecurityProfileUrlFilteringProfileArgs']]:
        """
        The url filtering configuration for the security profile.
        Structure is documented below.
        """
        return pulumi.get(self, "url_filtering_profile")

    @url_filtering_profile.setter
    def url_filtering_profile(self, value: Optional[pulumi.Input['SecurityProfileUrlFilteringProfileArgs']]):
        pulumi.set(self, "url_filtering_profile", value)


@pulumi.input_type
class _SecurityProfileState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_intercept_profile: Optional[pulumi.Input['SecurityProfileCustomInterceptProfileArgs']] = None,
                 custom_mirroring_profile: Optional[pulumi.Input['SecurityProfileCustomMirroringProfileArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_prevention_profile: Optional[pulumi.Input['SecurityProfileThreatPreventionProfileArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 url_filtering_profile: Optional[pulumi.Input['SecurityProfileUrlFilteringProfileArgs']] = None):
        """
        Input properties used for looking up and filtering SecurityProfile resources.
        :param pulumi.Input[_builtins.str] create_time: Time the security profile was created in UTC.
        :param pulumi.Input['SecurityProfileCustomInterceptProfileArgs'] custom_intercept_profile: The configuration for defining the Intercept Endpoint Group used to
               intercept traffic to third-party firewall appliances.
               Structure is documented below.
        :param pulumi.Input['SecurityProfileCustomMirroringProfileArgs'] custom_mirroring_profile: The configuration for defining the Mirroring Endpoint Group used to
               mirror traffic to third-party collectors.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of the security profile. The Max length is 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of other fields,
               and may be sent on update and delete requests to ensure the client has an up-to-date
               value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the security profile.
               The default value is `global`.
        :param pulumi.Input[_builtins.str] name: The name of the security profile resource.
        :param pulumi.Input[_builtins.str] parent: The name of the parent this security profile belongs to.
               Format: organizations/{organization_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input['SecurityProfileThreatPreventionProfileArgs'] threat_prevention_profile: The threat prevention configuration for the security profile.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The type of security profile.
               Possible values are: `THREAT_PREVENTION`, `URL_FILTERING`, `CUSTOM_MIRRORING`, `CUSTOM_INTERCEPT`.
        :param pulumi.Input[_builtins.str] update_time: Time the security profile was updated in UTC.
        :param pulumi.Input['SecurityProfileUrlFilteringProfileArgs'] url_filtering_profile: The url filtering configuration for the security profile.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_intercept_profile is not None:
            pulumi.set(__self__, "custom_intercept_profile", custom_intercept_profile)
        if custom_mirroring_profile is not None:
            pulumi.set(__self__, "custom_mirroring_profile", custom_mirroring_profile)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if threat_prevention_profile is not None:
            pulumi.set(__self__, "threat_prevention_profile", threat_prevention_profile)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if url_filtering_profile is not None:
            pulumi.set(__self__, "url_filtering_profile", url_filtering_profile)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the security profile was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customInterceptProfile")
    def custom_intercept_profile(self) -> Optional[pulumi.Input['SecurityProfileCustomInterceptProfileArgs']]:
        """
        The configuration for defining the Intercept Endpoint Group used to
        intercept traffic to third-party firewall appliances.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_intercept_profile")

    @custom_intercept_profile.setter
    def custom_intercept_profile(self, value: Optional[pulumi.Input['SecurityProfileCustomInterceptProfileArgs']]):
        pulumi.set(self, "custom_intercept_profile", value)

    @_builtins.property
    @pulumi.getter(name="customMirroringProfile")
    def custom_mirroring_profile(self) -> Optional[pulumi.Input['SecurityProfileCustomMirroringProfileArgs']]:
        """
        The configuration for defining the Mirroring Endpoint Group used to
        mirror traffic to third-party collectors.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_mirroring_profile")

    @custom_mirroring_profile.setter
    def custom_mirroring_profile(self, value: Optional[pulumi.Input['SecurityProfileCustomMirroringProfileArgs']]):
        pulumi.set(self, "custom_mirroring_profile", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of the security profile. The Max length is 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This checksum is computed by the server based on the value of other fields,
        and may be sent on update and delete requests to ensure the client has an up-to-date
        value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the security profile.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security profile resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the parent this security profile belongs to.
        Format: organizations/{organization_id}.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="threatPreventionProfile")
    def threat_prevention_profile(self) -> Optional[pulumi.Input['SecurityProfileThreatPreventionProfileArgs']]:
        """
        The threat prevention configuration for the security profile.
        Structure is documented below.
        """
        return pulumi.get(self, "threat_prevention_profile")

    @threat_prevention_profile.setter
    def threat_prevention_profile(self, value: Optional[pulumi.Input['SecurityProfileThreatPreventionProfileArgs']]):
        pulumi.set(self, "threat_prevention_profile", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of security profile.
        Possible values are: `THREAT_PREVENTION`, `URL_FILTERING`, `CUSTOM_MIRRORING`, `CUSTOM_INTERCEPT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the security profile was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="urlFilteringProfile")
    def url_filtering_profile(self) -> Optional[pulumi.Input['SecurityProfileUrlFilteringProfileArgs']]:
        """
        The url filtering configuration for the security profile.
        Structure is documented below.
        """
        return pulumi.get(self, "url_filtering_profile")

    @url_filtering_profile.setter
    def url_filtering_profile(self, value: Optional[pulumi.Input['SecurityProfileUrlFilteringProfileArgs']]):
        pulumi.set(self, "url_filtering_profile", value)


@pulumi.type_token("gcp:networksecurity/securityProfile:SecurityProfile")
class SecurityProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_intercept_profile: Optional[pulumi.Input[Union['SecurityProfileCustomInterceptProfileArgs', 'SecurityProfileCustomInterceptProfileArgsDict']]] = None,
                 custom_mirroring_profile: Optional[pulumi.Input[Union['SecurityProfileCustomMirroringProfileArgs', 'SecurityProfileCustomMirroringProfileArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_prevention_profile: Optional[pulumi.Input[Union['SecurityProfileThreatPreventionProfileArgs', 'SecurityProfileThreatPreventionProfileArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url_filtering_profile: Optional[pulumi.Input[Union['SecurityProfileUrlFilteringProfileArgs', 'SecurityProfileUrlFilteringProfileArgsDict']]] = None,
                 __props__=None):
        """
        A security profile defines the behavior associated to a profile type.

        To get more information about SecurityProfile, see:

        * [API documentation](https://cloud.google.com/firewall/docs/reference/network-security/rest/v1/organizations.locations.securityProfiles)
        * How-to Guides
            * [Create and manage security profiles](https://cloud.google.com/firewall/docs/configure-security-profiles)

        ## Example Usage

        ### Network Security Security Profile Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="THREAT_PREVENTION",
            labels={
                "foo": "bar",
            })
        ```
        ### Network Security Security Profile Overrides

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="THREAT_PREVENTION",
            threat_prevention_profile={
                "severity_overrides": [
                    {
                        "action": "ALLOW",
                        "severity": "INFORMATIONAL",
                    },
                    {
                        "action": "DENY",
                        "severity": "HIGH",
                    },
                ],
                "threat_overrides": [{
                    "action": "ALLOW",
                    "threat_id": "280647",
                }],
                "antivirus_overrides": [{
                    "protocol": "SMTP",
                    "action": "ALLOW",
                }],
            })
        ```
        ### Network Security Security Profile Mirroring

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="my-network",
            auto_create_subnetworks=False)
        default_mirroring_deployment_group = gcp.networksecurity.MirroringDeploymentGroup("default",
            mirroring_deployment_group_id="my-dg",
            location="global",
            network=default.id)
        default_mirroring_endpoint_group = gcp.networksecurity.MirroringEndpointGroup("default",
            mirroring_endpoint_group_id="my-eg",
            location="global",
            mirroring_deployment_group=default_mirroring_deployment_group.id)
        default_security_profile = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="CUSTOM_MIRRORING",
            custom_mirroring_profile={
                "mirroring_endpoint_group": default_mirroring_endpoint_group.id,
            })
        ```
        ### Network Security Security Profile Intercept

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="my-network",
            auto_create_subnetworks=False)
        default_intercept_deployment_group = gcp.networksecurity.InterceptDeploymentGroup("default",
            intercept_deployment_group_id="my-dg",
            location="global",
            network=default.id)
        default_intercept_endpoint_group = gcp.networksecurity.InterceptEndpointGroup("default",
            intercept_endpoint_group_id="my-eg",
            location="global",
            intercept_deployment_group=default_intercept_deployment_group.id)
        default_security_profile = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="CUSTOM_INTERCEPT",
            custom_intercept_profile={
                "intercept_endpoint_group": default_intercept_endpoint_group.id,
            })
        ```
        ### Network Security Security Profile Url Filtering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="URL_FILTERING",
            url_filtering_profile={
                "url_filters": [
                    {
                        "priority": 1,
                        "filtering_action": "ALLOW",
                        "urls": [
                            "*example.com",
                            "*about.example.com",
                            "*help.example.com",
                        ],
                    },
                    {
                        "priority": 2,
                        "filtering_action": "DENY",
                        "urls": ["*restricted.example.com"],
                    },
                ],
            },
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        SecurityProfile can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/securityProfiles/{{name}}`

        When using the `pulumi import` command, SecurityProfile can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/securityProfile:SecurityProfile default {{parent}}/locations/{{location}}/securityProfiles/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecurityProfileCustomInterceptProfileArgs', 'SecurityProfileCustomInterceptProfileArgsDict']] custom_intercept_profile: The configuration for defining the Intercept Endpoint Group used to
               intercept traffic to third-party firewall appliances.
               Structure is documented below.
        :param pulumi.Input[Union['SecurityProfileCustomMirroringProfileArgs', 'SecurityProfileCustomMirroringProfileArgsDict']] custom_mirroring_profile: The configuration for defining the Mirroring Endpoint Group used to
               mirror traffic to third-party collectors.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of the security profile. The Max length is 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the security profile.
               The default value is `global`.
        :param pulumi.Input[_builtins.str] name: The name of the security profile resource.
        :param pulumi.Input[_builtins.str] parent: The name of the parent this security profile belongs to.
               Format: organizations/{organization_id}.
        :param pulumi.Input[Union['SecurityProfileThreatPreventionProfileArgs', 'SecurityProfileThreatPreventionProfileArgsDict']] threat_prevention_profile: The threat prevention configuration for the security profile.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The type of security profile.
               Possible values are: `THREAT_PREVENTION`, `URL_FILTERING`, `CUSTOM_MIRRORING`, `CUSTOM_INTERCEPT`.
        :param pulumi.Input[Union['SecurityProfileUrlFilteringProfileArgs', 'SecurityProfileUrlFilteringProfileArgsDict']] url_filtering_profile: The url filtering configuration for the security profile.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A security profile defines the behavior associated to a profile type.

        To get more information about SecurityProfile, see:

        * [API documentation](https://cloud.google.com/firewall/docs/reference/network-security/rest/v1/organizations.locations.securityProfiles)
        * How-to Guides
            * [Create and manage security profiles](https://cloud.google.com/firewall/docs/configure-security-profiles)

        ## Example Usage

        ### Network Security Security Profile Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="THREAT_PREVENTION",
            labels={
                "foo": "bar",
            })
        ```
        ### Network Security Security Profile Overrides

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="THREAT_PREVENTION",
            threat_prevention_profile={
                "severity_overrides": [
                    {
                        "action": "ALLOW",
                        "severity": "INFORMATIONAL",
                    },
                    {
                        "action": "DENY",
                        "severity": "HIGH",
                    },
                ],
                "threat_overrides": [{
                    "action": "ALLOW",
                    "threat_id": "280647",
                }],
                "antivirus_overrides": [{
                    "protocol": "SMTP",
                    "action": "ALLOW",
                }],
            })
        ```
        ### Network Security Security Profile Mirroring

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="my-network",
            auto_create_subnetworks=False)
        default_mirroring_deployment_group = gcp.networksecurity.MirroringDeploymentGroup("default",
            mirroring_deployment_group_id="my-dg",
            location="global",
            network=default.id)
        default_mirroring_endpoint_group = gcp.networksecurity.MirroringEndpointGroup("default",
            mirroring_endpoint_group_id="my-eg",
            location="global",
            mirroring_deployment_group=default_mirroring_deployment_group.id)
        default_security_profile = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="CUSTOM_MIRRORING",
            custom_mirroring_profile={
                "mirroring_endpoint_group": default_mirroring_endpoint_group.id,
            })
        ```
        ### Network Security Security Profile Intercept

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="my-network",
            auto_create_subnetworks=False)
        default_intercept_deployment_group = gcp.networksecurity.InterceptDeploymentGroup("default",
            intercept_deployment_group_id="my-dg",
            location="global",
            network=default.id)
        default_intercept_endpoint_group = gcp.networksecurity.InterceptEndpointGroup("default",
            intercept_endpoint_group_id="my-eg",
            location="global",
            intercept_deployment_group=default_intercept_deployment_group.id)
        default_security_profile = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="CUSTOM_INTERCEPT",
            custom_intercept_profile={
                "intercept_endpoint_group": default_intercept_endpoint_group.id,
            })
        ```
        ### Network Security Security Profile Url Filtering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.SecurityProfile("default",
            name="my-security-profile",
            parent="organizations/123456789",
            description="my description",
            type="URL_FILTERING",
            url_filtering_profile={
                "url_filters": [
                    {
                        "priority": 1,
                        "filtering_action": "ALLOW",
                        "urls": [
                            "*example.com",
                            "*about.example.com",
                            "*help.example.com",
                        ],
                    },
                    {
                        "priority": 2,
                        "filtering_action": "DENY",
                        "urls": ["*restricted.example.com"],
                    },
                ],
            },
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        SecurityProfile can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/securityProfiles/{{name}}`

        When using the `pulumi import` command, SecurityProfile can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/securityProfile:SecurityProfile default {{parent}}/locations/{{location}}/securityProfiles/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SecurityProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_intercept_profile: Optional[pulumi.Input[Union['SecurityProfileCustomInterceptProfileArgs', 'SecurityProfileCustomInterceptProfileArgsDict']]] = None,
                 custom_mirroring_profile: Optional[pulumi.Input[Union['SecurityProfileCustomMirroringProfileArgs', 'SecurityProfileCustomMirroringProfileArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_prevention_profile: Optional[pulumi.Input[Union['SecurityProfileThreatPreventionProfileArgs', 'SecurityProfileThreatPreventionProfileArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url_filtering_profile: Optional[pulumi.Input[Union['SecurityProfileUrlFilteringProfileArgs', 'SecurityProfileUrlFilteringProfileArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityProfileArgs.__new__(SecurityProfileArgs)

            __props__.__dict__["custom_intercept_profile"] = custom_intercept_profile
            __props__.__dict__["custom_mirroring_profile"] = custom_mirroring_profile
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["parent"] = parent
            __props__.__dict__["threat_prevention_profile"] = threat_prevention_profile
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["url_filtering_profile"] = url_filtering_profile
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecurityProfile, __self__).__init__(
            'gcp:networksecurity/securityProfile:SecurityProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_intercept_profile: Optional[pulumi.Input[Union['SecurityProfileCustomInterceptProfileArgs', 'SecurityProfileCustomInterceptProfileArgsDict']]] = None,
            custom_mirroring_profile: Optional[pulumi.Input[Union['SecurityProfileCustomMirroringProfileArgs', 'SecurityProfileCustomMirroringProfileArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            threat_prevention_profile: Optional[pulumi.Input[Union['SecurityProfileThreatPreventionProfileArgs', 'SecurityProfileThreatPreventionProfileArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            url_filtering_profile: Optional[pulumi.Input[Union['SecurityProfileUrlFilteringProfileArgs', 'SecurityProfileUrlFilteringProfileArgsDict']]] = None) -> 'SecurityProfile':
        """
        Get an existing SecurityProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Time the security profile was created in UTC.
        :param pulumi.Input[Union['SecurityProfileCustomInterceptProfileArgs', 'SecurityProfileCustomInterceptProfileArgsDict']] custom_intercept_profile: The configuration for defining the Intercept Endpoint Group used to
               intercept traffic to third-party firewall appliances.
               Structure is documented below.
        :param pulumi.Input[Union['SecurityProfileCustomMirroringProfileArgs', 'SecurityProfileCustomMirroringProfileArgsDict']] custom_mirroring_profile: The configuration for defining the Mirroring Endpoint Group used to
               mirror traffic to third-party collectors.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of the security profile. The Max length is 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of other fields,
               and may be sent on update and delete requests to ensure the client has an up-to-date
               value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the security profile.
               The default value is `global`.
        :param pulumi.Input[_builtins.str] name: The name of the security profile resource.
        :param pulumi.Input[_builtins.str] parent: The name of the parent this security profile belongs to.
               Format: organizations/{organization_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[Union['SecurityProfileThreatPreventionProfileArgs', 'SecurityProfileThreatPreventionProfileArgsDict']] threat_prevention_profile: The threat prevention configuration for the security profile.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The type of security profile.
               Possible values are: `THREAT_PREVENTION`, `URL_FILTERING`, `CUSTOM_MIRRORING`, `CUSTOM_INTERCEPT`.
        :param pulumi.Input[_builtins.str] update_time: Time the security profile was updated in UTC.
        :param pulumi.Input[Union['SecurityProfileUrlFilteringProfileArgs', 'SecurityProfileUrlFilteringProfileArgsDict']] url_filtering_profile: The url filtering configuration for the security profile.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityProfileState.__new__(_SecurityProfileState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_intercept_profile"] = custom_intercept_profile
        __props__.__dict__["custom_mirroring_profile"] = custom_mirroring_profile
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["threat_prevention_profile"] = threat_prevention_profile
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["url_filtering_profile"] = url_filtering_profile
        return SecurityProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the security profile was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customInterceptProfile")
    def custom_intercept_profile(self) -> pulumi.Output[Optional['outputs.SecurityProfileCustomInterceptProfile']]:
        """
        The configuration for defining the Intercept Endpoint Group used to
        intercept traffic to third-party firewall appliances.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_intercept_profile")

    @_builtins.property
    @pulumi.getter(name="customMirroringProfile")
    def custom_mirroring_profile(self) -> pulumi.Output[Optional['outputs.SecurityProfileCustomMirroringProfile']]:
        """
        The configuration for defining the Mirroring Endpoint Group used to
        mirror traffic to third-party collectors.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_mirroring_profile")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of the security profile. The Max length is 512 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        This checksum is computed by the server based on the value of other fields,
        and may be sent on update and delete requests to ensure the client has an up-to-date
        value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The location of the security profile.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the security profile resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the parent this security profile belongs to.
        Format: organizations/{organization_id}.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="threatPreventionProfile")
    def threat_prevention_profile(self) -> pulumi.Output[Optional['outputs.SecurityProfileThreatPreventionProfile']]:
        """
        The threat prevention configuration for the security profile.
        Structure is documented below.
        """
        return pulumi.get(self, "threat_prevention_profile")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of security profile.
        Possible values are: `THREAT_PREVENTION`, `URL_FILTERING`, `CUSTOM_MIRRORING`, `CUSTOM_INTERCEPT`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the security profile was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="urlFilteringProfile")
    def url_filtering_profile(self) -> pulumi.Output[Optional['outputs.SecurityProfileUrlFilteringProfile']]:
        """
        The url filtering configuration for the security profile.
        Structure is documented below.
        """
        return pulumi.get(self, "url_filtering_profile")

