# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GrpcRouteArgs', 'GrpcRoute']

@pulumi.input_type
class GrpcRouteArgs:
    def __init__(__self__, *,
                 hostnames: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 rules: pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GrpcRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: Required. Service hostnames with an optional port for which this route describes traffic.
        :param pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] gateways: List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the GrpcRoute resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location (region) of the GRPCRoute resource to be created. Only the value 'global' is currently allowed; defaults to 'global' if omitted.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] meshes: List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        :param pulumi.Input[_builtins.str] name: Name of the GrpcRoute resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "hostnames", hostnames)
        pulumi.set(__self__, "rules", rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if meshes is not None:
            pulumi.set(__self__, "meshes", meshes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Required. Service hostnames with an optional port for which this route describes traffic.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "gateways", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the GrpcRoute resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location (region) of the GRPCRoute resource to be created. Only the value 'global' is currently allowed; defaults to 'global' if omitted.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def meshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        """
        return pulumi.get(self, "meshes")

    @meshes.setter
    def meshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meshes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the GrpcRoute resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _GrpcRouteState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrpcRoute resources.
        :param pulumi.Input[_builtins.str] create_time: Time the GrpcRoute was created in UTC.
        :param pulumi.Input[_builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] gateways: List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: Required. Service hostnames with an optional port for which this route describes traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the GrpcRoute resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location (region) of the GRPCRoute resource to be created. Only the value 'global' is currently allowed; defaults to 'global' if omitted.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] meshes: List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        :param pulumi.Input[_builtins.str] name: Name of the GrpcRoute resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[_builtins.str] update_time: Time the GrpcRoute was updated in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if meshes is not None:
            pulumi.set(__self__, "meshes", meshes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the GrpcRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "gateways", value)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required. Service hostnames with an optional port for which this route describes traffic.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the GrpcRoute resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location (region) of the GRPCRoute resource to be created. Only the value 'global' is currently allowed; defaults to 'global' if omitted.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def meshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        """
        return pulumi.get(self, "meshes")

    @meshes.setter
    def meshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meshes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the GrpcRoute resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the GrpcRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networkservices/grpcRoute:GrpcRoute")
class GrpcRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GrpcRouteRuleArgs', 'GrpcRouteRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        GrpcRoute is the resource defining how gRPC traffic routed by a Mesh or Gateway resource is routed.

        To get more information about GrpcRoute, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-services/rest/v1beta1/projects.locations.grpcRoutes)

        ## Example Usage

        ### Network Services Grpc Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            name="my-grpc-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[{
                "matches": [{
                    "headers": [{
                        "key": "key",
                        "value": "value",
                    }],
                }],
                "action": {
                    "retry_policy": {
                        "retry_conditions": ["cancelled"],
                        "num_retries": 1,
                    },
                },
            }])
        ```
        ### Network Services Grpc Route Matches And Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            name="my-grpc-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[{
                "matches": [
                    {
                        "headers": [{
                            "key": "key",
                            "value": "value",
                        }],
                    },
                    {
                        "headers": [{
                            "key": "key",
                            "value": "value",
                        }],
                        "method": {
                            "grpc_service": "foo",
                            "grpc_method": "bar",
                            "case_sensitive": True,
                        },
                    },
                ],
                "action": {
                    "fault_injection_policy": {
                        "delay": {
                            "fixed_delay": "1s",
                            "percentage": 1,
                        },
                        "abort": {
                            "http_status": 500,
                            "percentage": 1,
                        },
                    },
                    "retry_policy": {
                        "retry_conditions": ["cancelled"],
                        "num_retries": 1,
                    },
                },
            }])
        ```
        ### Network Services Grpc Route Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            name="my-grpc-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[{
                "action": {
                    "fault_injection_policy": {
                        "delay": {
                            "fixed_delay": "1s",
                            "percentage": 1,
                        },
                        "abort": {
                            "http_status": 500,
                            "percentage": 1,
                        },
                    },
                    "retry_policy": {
                        "retry_conditions": ["cancelled"],
                        "num_retries": 1,
                    },
                },
            }])
        ```
        ### Network Services Grpc Route Location

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            name="my-grpc-route",
            location="global",
            hostnames=["example"],
            rules=[{
                "matches": [{
                    "headers": [{
                        "key": "key",
                        "value": "value",
                    }],
                }],
                "action": {
                    "retry_policy": {
                        "retry_conditions": ["cancelled"],
                        "num_retries": 1,
                    },
                },
            }])
        ```

        ## Import

        GrpcRoute can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/grpcRoutes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, GrpcRoute can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default projects/{{project}}/locations/{{location}}/grpcRoutes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] gateways: List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: Required. Service hostnames with an optional port for which this route describes traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the GrpcRoute resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location (region) of the GRPCRoute resource to be created. Only the value 'global' is currently allowed; defaults to 'global' if omitted.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] meshes: List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        :param pulumi.Input[_builtins.str] name: Name of the GrpcRoute resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GrpcRouteRuleArgs', 'GrpcRouteRuleArgsDict']]]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrpcRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        GrpcRoute is the resource defining how gRPC traffic routed by a Mesh or Gateway resource is routed.

        To get more information about GrpcRoute, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-services/rest/v1beta1/projects.locations.grpcRoutes)

        ## Example Usage

        ### Network Services Grpc Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            name="my-grpc-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[{
                "matches": [{
                    "headers": [{
                        "key": "key",
                        "value": "value",
                    }],
                }],
                "action": {
                    "retry_policy": {
                        "retry_conditions": ["cancelled"],
                        "num_retries": 1,
                    },
                },
            }])
        ```
        ### Network Services Grpc Route Matches And Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            name="my-grpc-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[{
                "matches": [
                    {
                        "headers": [{
                            "key": "key",
                            "value": "value",
                        }],
                    },
                    {
                        "headers": [{
                            "key": "key",
                            "value": "value",
                        }],
                        "method": {
                            "grpc_service": "foo",
                            "grpc_method": "bar",
                            "case_sensitive": True,
                        },
                    },
                ],
                "action": {
                    "fault_injection_policy": {
                        "delay": {
                            "fixed_delay": "1s",
                            "percentage": 1,
                        },
                        "abort": {
                            "http_status": 500,
                            "percentage": 1,
                        },
                    },
                    "retry_policy": {
                        "retry_conditions": ["cancelled"],
                        "num_retries": 1,
                    },
                },
            }])
        ```
        ### Network Services Grpc Route Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            name="my-grpc-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[{
                "action": {
                    "fault_injection_policy": {
                        "delay": {
                            "fixed_delay": "1s",
                            "percentage": 1,
                        },
                        "abort": {
                            "http_status": 500,
                            "percentage": 1,
                        },
                    },
                    "retry_policy": {
                        "retry_conditions": ["cancelled"],
                        "num_retries": 1,
                    },
                },
            }])
        ```
        ### Network Services Grpc Route Location

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            name="my-grpc-route",
            location="global",
            hostnames=["example"],
            rules=[{
                "matches": [{
                    "headers": [{
                        "key": "key",
                        "value": "value",
                    }],
                }],
                "action": {
                    "retry_policy": {
                        "retry_conditions": ["cancelled"],
                        "num_retries": 1,
                    },
                },
            }])
        ```

        ## Import

        GrpcRoute can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/grpcRoutes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, GrpcRoute can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default projects/{{project}}/locations/{{location}}/grpcRoutes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param GrpcRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrpcRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GrpcRouteRuleArgs', 'GrpcRouteRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrpcRouteArgs.__new__(GrpcRouteArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["gateways"] = gateways
            if hostnames is None and not opts.urn:
                raise TypeError("Missing required property 'hostnames'")
            __props__.__dict__["hostnames"] = hostnames
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["meshes"] = meshes
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GrpcRoute, __self__).__init__(
            'gcp:networkservices/grpcRoute:GrpcRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gateways: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            meshes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GrpcRouteRuleArgs', 'GrpcRouteRuleArgsDict']]]]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'GrpcRoute':
        """
        Get an existing GrpcRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Time the GrpcRoute was created in UTC.
        :param pulumi.Input[_builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] gateways: List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: Required. Service hostnames with an optional port for which this route describes traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the GrpcRoute resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location (region) of the GRPCRoute resource to be created. Only the value 'global' is currently allowed; defaults to 'global' if omitted.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] meshes: List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        :param pulumi.Input[_builtins.str] name: Name of the GrpcRoute resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GrpcRouteRuleArgs', 'GrpcRouteRuleArgsDict']]]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[_builtins.str] update_time: Time the GrpcRoute was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrpcRouteState.__new__(_GrpcRouteState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["gateways"] = gateways
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["meshes"] = meshes
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["rules"] = rules
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["update_time"] = update_time
        return GrpcRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the GrpcRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        """
        return pulumi.get(self, "gateways")

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Required. Service hostnames with an optional port for which this route describes traffic.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of label tags associated with the GrpcRoute resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Location (region) of the GRPCRoute resource to be created. Only the value 'global' is currently allowed; defaults to 'global' if omitted.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def meshes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        """
        return pulumi.get(self, "meshes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the GrpcRoute resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.GrpcRouteRule']]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the GrpcRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

