# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LbTrafficExtensionArgs', 'LbTrafficExtension']

@pulumi.input_type
class LbTrafficExtensionArgs:
    def __init__(__self__, *,
                 extension_chains: pulumi.Input[Sequence[pulumi.Input['LbTrafficExtensionExtensionChainArgs']]],
                 forwarding_rules: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 load_balancing_scheme: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LbTrafficExtension resource.
        :param pulumi.Input[Sequence[pulumi.Input['LbTrafficExtensionExtensionChainArgs']]] extension_chains: A set of ordered extension chains that contain the match conditions and extensions to execute.
               Match conditions for each extension chain are evaluated in sequence for a given request.
               The first extension chain that has a condition that matches the request is executed.
               Any subsequent extension chains do not execute. Limited to 5 extension chains per resource.
               Further information can be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] forwarding_rules: A list of references to the forwarding rules to which this service extension is attached to.
               At least one forwarding rule is required. There can be only one LBTrafficExtension resource per forwarding rule.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
               For more information, refer to [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service) and
               [Supported application load balancers](https://cloud.google.com/service-extensions/docs/callouts-overview#supported-lbs).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[_builtins.str] location: The location of the traffic extension
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with the LbTrafficExtension resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the LbTrafficExtension resource in the following format: projects/{project}/locations/{location}/lbTrafficExtensions/{lbTrafficExtension}.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "extension_chains", extension_chains)
        pulumi.set(__self__, "forwarding_rules", forwarding_rules)
        pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="extensionChains")
    def extension_chains(self) -> pulumi.Input[Sequence[pulumi.Input['LbTrafficExtensionExtensionChainArgs']]]:
        """
        A set of ordered extension chains that contain the match conditions and extensions to execute.
        Match conditions for each extension chain are evaluated in sequence for a given request.
        The first extension chain that has a condition that matches the request is executed.
        Any subsequent extension chains do not execute. Limited to 5 extension chains per resource.
        Further information can be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain
        Structure is documented below.
        """
        return pulumi.get(self, "extension_chains")

    @extension_chains.setter
    def extension_chains(self, value: pulumi.Input[Sequence[pulumi.Input['LbTrafficExtensionExtensionChainArgs']]]):
        pulumi.set(self, "extension_chains", value)

    @_builtins.property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of references to the forwarding rules to which this service extension is attached to.
        At least one forwarding rule is required. There can be only one LBTrafficExtension resource per forwarding rule.
        """
        return pulumi.get(self, "forwarding_rules")

    @forwarding_rules.setter
    def forwarding_rules(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "forwarding_rules", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Input[_builtins.str]:
        """
        All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
        For more information, refer to [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service) and
        [Supported application load balancers](https://cloud.google.com/service-extensions/docs/callouts-overview#supported-lbs).
        Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancing_scheme", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the traffic extension
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of labels associated with the LbTrafficExtension resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the LbTrafficExtension resource in the following format: projects/{project}/locations/{location}/lbTrafficExtensions/{lbTrafficExtension}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _LbTrafficExtensionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extension_chains: Optional[pulumi.Input[Sequence[pulumi.Input['LbTrafficExtensionExtensionChainArgs']]]] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LbTrafficExtension resources.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['LbTrafficExtensionExtensionChainArgs']]] extension_chains: A set of ordered extension chains that contain the match conditions and extensions to execute.
               Match conditions for each extension chain are evaluated in sequence for a given request.
               The first extension chain that has a condition that matches the request is executed.
               Any subsequent extension chains do not execute. Limited to 5 extension chains per resource.
               Further information can be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] forwarding_rules: A list of references to the forwarding rules to which this service extension is attached to.
               At least one forwarding rule is required. There can be only one LBTrafficExtension resource per forwarding rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with the LbTrafficExtension resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
               For more information, refer to [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service) and
               [Supported application load balancers](https://cloud.google.com/service-extensions/docs/callouts-overview#supported-lbs).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[_builtins.str] location: The location of the traffic extension
        :param pulumi.Input[_builtins.str] name: Name of the LbTrafficExtension resource in the following format: projects/{project}/locations/{location}/lbTrafficExtensions/{lbTrafficExtension}.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if extension_chains is not None:
            pulumi.set(__self__, "extension_chains", extension_chains)
        if forwarding_rules is not None:
            pulumi.set(__self__, "forwarding_rules", forwarding_rules)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="extensionChains")
    def extension_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LbTrafficExtensionExtensionChainArgs']]]]:
        """
        A set of ordered extension chains that contain the match conditions and extensions to execute.
        Match conditions for each extension chain are evaluated in sequence for a given request.
        The first extension chain that has a condition that matches the request is executed.
        Any subsequent extension chains do not execute. Limited to 5 extension chains per resource.
        Further information can be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain
        Structure is documented below.
        """
        return pulumi.get(self, "extension_chains")

    @extension_chains.setter
    def extension_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LbTrafficExtensionExtensionChainArgs']]]]):
        pulumi.set(self, "extension_chains", value)

    @_builtins.property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of references to the forwarding rules to which this service extension is attached to.
        At least one forwarding rule is required. There can be only one LBTrafficExtension resource per forwarding rule.
        """
        return pulumi.get(self, "forwarding_rules")

    @forwarding_rules.setter
    def forwarding_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "forwarding_rules", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of labels associated with the LbTrafficExtension resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
        For more information, refer to [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service) and
        [Supported application load balancers](https://cloud.google.com/service-extensions/docs/callouts-overview#supported-lbs).
        Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the traffic extension
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the LbTrafficExtension resource in the following format: projects/{project}/locations/{location}/lbTrafficExtensions/{lbTrafficExtension}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)


@pulumi.type_token("gcp:networkservices/lbTrafficExtension:LbTrafficExtension")
class LbTrafficExtension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_chains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbTrafficExtensionExtensionChainArgs', 'LbTrafficExtensionExtensionChainArgsDict']]]]] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        LbTrafficExtension is a resource that lets the extension service modify the headers and payloads of both requests and responses without impacting the choice of backend services or any other security policies associated with the backend service.

        To get more information about LbTrafficExtension, see:

        * [API documentation](https://cloud.google.com/service-extensions/docs/reference/rest/v1beta1/projects.locations.lbTrafficExtensions)
        * How-to Guides
            * [Configure a traffic extension](https://cloud.google.com/service-extensions/docs/configure-callout#configure_a_traffic_extension)

        ## Example Usage

        ## Import

        LbTrafficExtension can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/lbTrafficExtensions/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, LbTrafficExtension can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/lbTrafficExtension:LbTrafficExtension default projects/{{project}}/locations/{{location}}/lbTrafficExtensions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/lbTrafficExtension:LbTrafficExtension default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/lbTrafficExtension:LbTrafficExtension default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LbTrafficExtensionExtensionChainArgs', 'LbTrafficExtensionExtensionChainArgsDict']]]] extension_chains: A set of ordered extension chains that contain the match conditions and extensions to execute.
               Match conditions for each extension chain are evaluated in sequence for a given request.
               The first extension chain that has a condition that matches the request is executed.
               Any subsequent extension chains do not execute. Limited to 5 extension chains per resource.
               Further information can be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] forwarding_rules: A list of references to the forwarding rules to which this service extension is attached to.
               At least one forwarding rule is required. There can be only one LBTrafficExtension resource per forwarding rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with the LbTrafficExtension resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
               For more information, refer to [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service) and
               [Supported application load balancers](https://cloud.google.com/service-extensions/docs/callouts-overview#supported-lbs).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[_builtins.str] location: The location of the traffic extension
        :param pulumi.Input[_builtins.str] name: Name of the LbTrafficExtension resource in the following format: projects/{project}/locations/{location}/lbTrafficExtensions/{lbTrafficExtension}.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LbTrafficExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        LbTrafficExtension is a resource that lets the extension service modify the headers and payloads of both requests and responses without impacting the choice of backend services or any other security policies associated with the backend service.

        To get more information about LbTrafficExtension, see:

        * [API documentation](https://cloud.google.com/service-extensions/docs/reference/rest/v1beta1/projects.locations.lbTrafficExtensions)
        * How-to Guides
            * [Configure a traffic extension](https://cloud.google.com/service-extensions/docs/configure-callout#configure_a_traffic_extension)

        ## Example Usage

        ## Import

        LbTrafficExtension can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/lbTrafficExtensions/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, LbTrafficExtension can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/lbTrafficExtension:LbTrafficExtension default projects/{{project}}/locations/{{location}}/lbTrafficExtensions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/lbTrafficExtension:LbTrafficExtension default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/lbTrafficExtension:LbTrafficExtension default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param LbTrafficExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LbTrafficExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_chains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbTrafficExtensionExtensionChainArgs', 'LbTrafficExtensionExtensionChainArgsDict']]]]] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LbTrafficExtensionArgs.__new__(LbTrafficExtensionArgs)

            __props__.__dict__["description"] = description
            if extension_chains is None and not opts.urn:
                raise TypeError("Missing required property 'extension_chains'")
            __props__.__dict__["extension_chains"] = extension_chains
            if forwarding_rules is None and not opts.urn:
                raise TypeError("Missing required property 'forwarding_rules'")
            __props__.__dict__["forwarding_rules"] = forwarding_rules
            __props__.__dict__["labels"] = labels
            if load_balancing_scheme is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancing_scheme'")
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LbTrafficExtension, __self__).__init__(
            'gcp:networkservices/lbTrafficExtension:LbTrafficExtension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            extension_chains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbTrafficExtensionExtensionChainArgs', 'LbTrafficExtensionExtensionChainArgsDict']]]]] = None,
            forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'LbTrafficExtension':
        """
        Get an existing LbTrafficExtension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LbTrafficExtensionExtensionChainArgs', 'LbTrafficExtensionExtensionChainArgsDict']]]] extension_chains: A set of ordered extension chains that contain the match conditions and extensions to execute.
               Match conditions for each extension chain are evaluated in sequence for a given request.
               The first extension chain that has a condition that matches the request is executed.
               Any subsequent extension chains do not execute. Limited to 5 extension chains per resource.
               Further information can be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] forwarding_rules: A list of references to the forwarding rules to which this service extension is attached to.
               At least one forwarding rule is required. There can be only one LBTrafficExtension resource per forwarding rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with the LbTrafficExtension resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
               For more information, refer to [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service) and
               [Supported application load balancers](https://cloud.google.com/service-extensions/docs/callouts-overview#supported-lbs).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[_builtins.str] location: The location of the traffic extension
        :param pulumi.Input[_builtins.str] name: Name of the LbTrafficExtension resource in the following format: projects/{project}/locations/{location}/lbTrafficExtensions/{lbTrafficExtension}.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LbTrafficExtensionState.__new__(_LbTrafficExtensionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["extension_chains"] = extension_chains
        __props__.__dict__["forwarding_rules"] = forwarding_rules
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        return LbTrafficExtension(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="extensionChains")
    def extension_chains(self) -> pulumi.Output[Sequence['outputs.LbTrafficExtensionExtensionChain']]:
        """
        A set of ordered extension chains that contain the match conditions and extensions to execute.
        Match conditions for each extension chain are evaluated in sequence for a given request.
        The first extension chain that has a condition that matches the request is executed.
        Any subsequent extension chains do not execute. Limited to 5 extension chains per resource.
        Further information can be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain
        Structure is documented below.
        """
        return pulumi.get(self, "extension_chains")

    @_builtins.property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of references to the forwarding rules to which this service extension is attached to.
        At least one forwarding rule is required. There can be only one LBTrafficExtension resource per forwarding rule.
        """
        return pulumi.get(self, "forwarding_rules")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of labels associated with the LbTrafficExtension resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[_builtins.str]:
        """
        All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
        For more information, refer to [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service) and
        [Supported application load balancers](https://cloud.google.com/service-extensions/docs/callouts-overview#supported-lbs).
        Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the traffic extension
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the LbTrafficExtension resource in the following format: projects/{project}/locations/{location}/lbTrafficExtensions/{lbTrafficExtension}.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

