# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MulticastDomainArgs', 'MulticastDomain']

@pulumi.input_type
class MulticastDomainArgs:
    def __init__(__self__, *,
                 admin_network: pulumi.Input[_builtins.str],
                 connection_config: pulumi.Input['MulticastDomainConnectionConfigArgs'],
                 location: pulumi.Input[_builtins.str],
                 multicast_domain_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 multicast_domain_group: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MulticastDomain resource.
        :param pulumi.Input[_builtins.str] admin_network: The resource name of the multicast admin VPC network.
               Use the following format:
               `projects/{project}/locations/global/networks/{network}`.
        :param pulumi.Input['MulticastDomainConnectionConfigArgs'] connection_config: VPC connectivity information.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] multicast_domain_id: A unique name for the multicast domain.
               The name is restricted to letters, numbers, and hyphen, with the first
               character a letter, and the last a letter or a number. The name must not
               exceed 48 characters.
        :param pulumi.Input[_builtins.str] description: An optional text description of the multicast domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key-value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] multicast_domain_group: The multicast domain group this domain should be associated with.
               Use the following format:
               `projects/{project}/locations/global/multicastDomainGroups/{multicast_domain_group}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "admin_network", admin_network)
        pulumi.set(__self__, "connection_config", connection_config)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "multicast_domain_id", multicast_domain_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if multicast_domain_group is not None:
            pulumi.set(__self__, "multicast_domain_group", multicast_domain_group)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="adminNetwork")
    def admin_network(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name of the multicast admin VPC network.
        Use the following format:
        `projects/{project}/locations/global/networks/{network}`.
        """
        return pulumi.get(self, "admin_network")

    @admin_network.setter
    def admin_network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "admin_network", value)

    @_builtins.property
    @pulumi.getter(name="connectionConfig")
    def connection_config(self) -> pulumi.Input['MulticastDomainConnectionConfigArgs']:
        """
        VPC connectivity information.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_config")

    @connection_config.setter
    def connection_config(self, value: pulumi.Input['MulticastDomainConnectionConfigArgs']):
        pulumi.set(self, "connection_config", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="multicastDomainId")
    def multicast_domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        A unique name for the multicast domain.
        The name is restricted to letters, numbers, and hyphen, with the first
        character a letter, and the last a letter or a number. The name must not
        exceed 48 characters.
        """
        return pulumi.get(self, "multicast_domain_id")

    @multicast_domain_id.setter
    def multicast_domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "multicast_domain_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional text description of the multicast domain.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key-value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="multicastDomainGroup")
    def multicast_domain_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The multicast domain group this domain should be associated with.
        Use the following format:
        `projects/{project}/locations/global/multicastDomainGroups/{multicast_domain_group}`.
        """
        return pulumi.get(self, "multicast_domain_group")

    @multicast_domain_group.setter
    def multicast_domain_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multicast_domain_group", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _MulticastDomainState:
    def __init__(__self__, *,
                 admin_network: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_config: Optional[pulumi.Input['MulticastDomainConnectionConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_domain_group: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unique_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MulticastDomain resources.
        :param pulumi.Input[_builtins.str] admin_network: The resource name of the multicast admin VPC network.
               Use the following format:
               `projects/{project}/locations/global/networks/{network}`.
        :param pulumi.Input['MulticastDomainConnectionConfigArgs'] connection_config: VPC connectivity information.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: [Output only] The timestamp when the multicast domain was created.
        :param pulumi.Input[_builtins.str] description: An optional text description of the multicast domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key-value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] multicast_domain_group: The multicast domain group this domain should be associated with.
               Use the following format:
               `projects/{project}/locations/global/multicastDomainGroups/{multicast_domain_group}`.
        :param pulumi.Input[_builtins.str] multicast_domain_id: A unique name for the multicast domain.
               The name is restricted to letters, numbers, and hyphen, with the first
               character a letter, and the last a letter or a number. The name must not
               exceed 48 characters.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the multicast domain.
               Use the following format:
               `projects/*/locations/global/multicastDomains/*`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] unique_id: [Output only] The Google-generated UUID for the resource. This value is
               unique across all multicast domain resources. If a domain is deleted and
               another with the same name is created, the new domain is assigned a
               different unique_id.
        :param pulumi.Input[_builtins.str] update_time: [Output only] The timestamp when the multicast domain was most recently
               updated.
        """
        if admin_network is not None:
            pulumi.set(__self__, "admin_network", admin_network)
        if connection_config is not None:
            pulumi.set(__self__, "connection_config", connection_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if multicast_domain_group is not None:
            pulumi.set(__self__, "multicast_domain_group", multicast_domain_group)
        if multicast_domain_id is not None:
            pulumi.set(__self__, "multicast_domain_id", multicast_domain_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if unique_id is not None:
            pulumi.set(__self__, "unique_id", unique_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="adminNetwork")
    def admin_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the multicast admin VPC network.
        Use the following format:
        `projects/{project}/locations/global/networks/{network}`.
        """
        return pulumi.get(self, "admin_network")

    @admin_network.setter
    def admin_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_network", value)

    @_builtins.property
    @pulumi.getter(name="connectionConfig")
    def connection_config(self) -> Optional[pulumi.Input['MulticastDomainConnectionConfigArgs']]:
        """
        VPC connectivity information.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_config")

    @connection_config.setter
    def connection_config(self, value: Optional[pulumi.Input['MulticastDomainConnectionConfigArgs']]):
        pulumi.set(self, "connection_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Output only] The timestamp when the multicast domain was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional text description of the multicast domain.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key-value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="multicastDomainGroup")
    def multicast_domain_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The multicast domain group this domain should be associated with.
        Use the following format:
        `projects/{project}/locations/global/multicastDomainGroups/{multicast_domain_group}`.
        """
        return pulumi.get(self, "multicast_domain_group")

    @multicast_domain_group.setter
    def multicast_domain_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multicast_domain_group", value)

    @_builtins.property
    @pulumi.getter(name="multicastDomainId")
    def multicast_domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name for the multicast domain.
        The name is restricted to letters, numbers, and hyphen, with the first
        character a letter, and the last a letter or a number. The name must not
        exceed 48 characters.
        """
        return pulumi.get(self, "multicast_domain_id")

    @multicast_domain_id.setter
    def multicast_domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multicast_domain_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name of the multicast domain.
        Use the following format:
        `projects/*/locations/global/multicastDomains/*`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Output only] The Google-generated UUID for the resource. This value is
        unique across all multicast domain resources. If a domain is deleted and
        another with the same name is created, the new domain is assigned a
        different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @unique_id.setter
    def unique_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unique_id", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Output only] The timestamp when the multicast domain was most recently
        updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networkservices/multicastDomain:MulticastDomain")
class MulticastDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_network: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_config: Optional[pulumi.Input[Union['MulticastDomainConnectionConfigArgs', 'MulticastDomainConnectionConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_domain_group: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a multicast domain in the current project.

        ## Example Usage

        ### Network Services Multicast Domain Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="test-md-network",
            auto_create_subnetworks=False)
        md_test = gcp.networkservices.MulticastDomain("md_test",
            multicast_domain_id="test-md-domain",
            location="global",
            description="A sample domain",
            labels={
                "label-one": "value-one",
            },
            admin_network=network.id,
            connection_config={
                "connection_type": "SAME_VPC",
                "ncc_hub": "",
            },
            multicast_domain_group="",
            opts = pulumi.ResourceOptions(depends_on=[network]))
        ```

        ## Import

        MulticastDomain can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/multicastDomains/{{multicast_domain_id}}`

        * `{{project}}/{{location}}/{{multicast_domain_id}}`

        * `{{location}}/{{multicast_domain_id}}`

        When using the `pulumi import` command, MulticastDomain can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/multicastDomain:MulticastDomain default projects/{{project}}/locations/{{location}}/multicastDomains/{{multicast_domain_id}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/multicastDomain:MulticastDomain default {{project}}/{{location}}/{{multicast_domain_id}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/multicastDomain:MulticastDomain default {{location}}/{{multicast_domain_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_network: The resource name of the multicast admin VPC network.
               Use the following format:
               `projects/{project}/locations/global/networks/{network}`.
        :param pulumi.Input[Union['MulticastDomainConnectionConfigArgs', 'MulticastDomainConnectionConfigArgsDict']] connection_config: VPC connectivity information.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional text description of the multicast domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key-value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] multicast_domain_group: The multicast domain group this domain should be associated with.
               Use the following format:
               `projects/{project}/locations/global/multicastDomainGroups/{multicast_domain_group}`.
        :param pulumi.Input[_builtins.str] multicast_domain_id: A unique name for the multicast domain.
               The name is restricted to letters, numbers, and hyphen, with the first
               character a letter, and the last a letter or a number. The name must not
               exceed 48 characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MulticastDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a multicast domain in the current project.

        ## Example Usage

        ### Network Services Multicast Domain Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="test-md-network",
            auto_create_subnetworks=False)
        md_test = gcp.networkservices.MulticastDomain("md_test",
            multicast_domain_id="test-md-domain",
            location="global",
            description="A sample domain",
            labels={
                "label-one": "value-one",
            },
            admin_network=network.id,
            connection_config={
                "connection_type": "SAME_VPC",
                "ncc_hub": "",
            },
            multicast_domain_group="",
            opts = pulumi.ResourceOptions(depends_on=[network]))
        ```

        ## Import

        MulticastDomain can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/multicastDomains/{{multicast_domain_id}}`

        * `{{project}}/{{location}}/{{multicast_domain_id}}`

        * `{{location}}/{{multicast_domain_id}}`

        When using the `pulumi import` command, MulticastDomain can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/multicastDomain:MulticastDomain default projects/{{project}}/locations/{{location}}/multicastDomains/{{multicast_domain_id}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/multicastDomain:MulticastDomain default {{project}}/{{location}}/{{multicast_domain_id}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/multicastDomain:MulticastDomain default {{location}}/{{multicast_domain_id}}
        ```

        :param str resource_name: The name of the resource.
        :param MulticastDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MulticastDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_network: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_config: Optional[pulumi.Input[Union['MulticastDomainConnectionConfigArgs', 'MulticastDomainConnectionConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_domain_group: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MulticastDomainArgs.__new__(MulticastDomainArgs)

            if admin_network is None and not opts.urn:
                raise TypeError("Missing required property 'admin_network'")
            __props__.__dict__["admin_network"] = admin_network
            if connection_config is None and not opts.urn:
                raise TypeError("Missing required property 'connection_config'")
            __props__.__dict__["connection_config"] = connection_config
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["multicast_domain_group"] = multicast_domain_group
            if multicast_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'multicast_domain_id'")
            __props__.__dict__["multicast_domain_id"] = multicast_domain_id
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["unique_id"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MulticastDomain, __self__).__init__(
            'gcp:networkservices/multicastDomain:MulticastDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_network: Optional[pulumi.Input[_builtins.str]] = None,
            connection_config: Optional[pulumi.Input[Union['MulticastDomainConnectionConfigArgs', 'MulticastDomainConnectionConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            multicast_domain_group: Optional[pulumi.Input[_builtins.str]] = None,
            multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            unique_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'MulticastDomain':
        """
        Get an existing MulticastDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_network: The resource name of the multicast admin VPC network.
               Use the following format:
               `projects/{project}/locations/global/networks/{network}`.
        :param pulumi.Input[Union['MulticastDomainConnectionConfigArgs', 'MulticastDomainConnectionConfigArgsDict']] connection_config: VPC connectivity information.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: [Output only] The timestamp when the multicast domain was created.
        :param pulumi.Input[_builtins.str] description: An optional text description of the multicast domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key-value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] multicast_domain_group: The multicast domain group this domain should be associated with.
               Use the following format:
               `projects/{project}/locations/global/multicastDomainGroups/{multicast_domain_group}`.
        :param pulumi.Input[_builtins.str] multicast_domain_id: A unique name for the multicast domain.
               The name is restricted to letters, numbers, and hyphen, with the first
               character a letter, and the last a letter or a number. The name must not
               exceed 48 characters.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the multicast domain.
               Use the following format:
               `projects/*/locations/global/multicastDomains/*`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] unique_id: [Output only] The Google-generated UUID for the resource. This value is
               unique across all multicast domain resources. If a domain is deleted and
               another with the same name is created, the new domain is assigned a
               different unique_id.
        :param pulumi.Input[_builtins.str] update_time: [Output only] The timestamp when the multicast domain was most recently
               updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MulticastDomainState.__new__(_MulticastDomainState)

        __props__.__dict__["admin_network"] = admin_network
        __props__.__dict__["connection_config"] = connection_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["multicast_domain_group"] = multicast_domain_group
        __props__.__dict__["multicast_domain_id"] = multicast_domain_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["unique_id"] = unique_id
        __props__.__dict__["update_time"] = update_time
        return MulticastDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminNetwork")
    def admin_network(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the multicast admin VPC network.
        Use the following format:
        `projects/{project}/locations/global/networks/{network}`.
        """
        return pulumi.get(self, "admin_network")

    @_builtins.property
    @pulumi.getter(name="connectionConfig")
    def connection_config(self) -> pulumi.Output['outputs.MulticastDomainConnectionConfig']:
        """
        VPC connectivity information.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        [Output only] The timestamp when the multicast domain was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional text description of the multicast domain.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels as key-value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="multicastDomainGroup")
    def multicast_domain_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The multicast domain group this domain should be associated with.
        Use the following format:
        `projects/{project}/locations/global/multicastDomainGroups/{multicast_domain_group}`.
        """
        return pulumi.get(self, "multicast_domain_group")

    @_builtins.property
    @pulumi.getter(name="multicastDomainId")
    def multicast_domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique name for the multicast domain.
        The name is restricted to letters, numbers, and hyphen, with the first
        character a letter, and the last a letter or a number. The name must not
        exceed 48 characters.
        """
        return pulumi.get(self, "multicast_domain_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name of the multicast domain.
        Use the following format:
        `projects/*/locations/global/multicastDomains/*`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> pulumi.Output[_builtins.str]:
        """
        [Output only] The Google-generated UUID for the resource. This value is
        unique across all multicast domain resources. If a domain is deleted and
        another with the same name is created, the new domain is assigned a
        different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        [Output only] The timestamp when the multicast domain was most recently
        updated.
        """
        return pulumi.get(self, "update_time")

