# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceLbPoliciesArgs', 'ServiceLbPolicies']

@pulumi.input_type
class ServiceLbPoliciesArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 auto_capacity_drain: Optional[pulumi.Input['ServiceLbPoliciesAutoCapacityDrainArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 failover_config: Optional[pulumi.Input['ServiceLbPoliciesFailoverConfigArgs']] = None,
                 isolation_config: Optional[pulumi.Input['ServiceLbPoliciesIsolationConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceLbPolicies resource.
        :param pulumi.Input[_builtins.str] location: The location of the service lb policy.
        :param pulumi.Input['ServiceLbPoliciesAutoCapacityDrainArgs'] auto_capacity_drain: Option to specify if an unhealthy MIG/NEG should be considered for global load balancing and traffic routing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input['ServiceLbPoliciesFailoverConfigArgs'] failover_config: Option to specify health based failover behavior. This is not related to Network load balancer FailoverPolicy.
               Structure is documented below.
        :param pulumi.Input['ServiceLbPoliciesIsolationConfigArgs'] isolation_config: Configuration to provide isolation support for the associated Backend Service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the ServiceLbPolicy resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_algorithm: The type of load balancing algorithm to be used. The default behavior is WATERFALL_BY_REGION.
               Possible values are: `SPRAY_TO_REGION`, `SPRAY_TO_WORLD`, `WATERFALL_BY_REGION`, `WATERFALL_BY_ZONE`.
        :param pulumi.Input[_builtins.str] name: Name of the ServiceLbPolicy resource. It matches pattern `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        if auto_capacity_drain is not None:
            pulumi.set(__self__, "auto_capacity_drain", auto_capacity_drain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failover_config is not None:
            pulumi.set(__self__, "failover_config", failover_config)
        if isolation_config is not None:
            pulumi.set(__self__, "isolation_config", isolation_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_algorithm is not None:
            pulumi.set(__self__, "load_balancing_algorithm", load_balancing_algorithm)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the service lb policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="autoCapacityDrain")
    def auto_capacity_drain(self) -> Optional[pulumi.Input['ServiceLbPoliciesAutoCapacityDrainArgs']]:
        """
        Option to specify if an unhealthy MIG/NEG should be considered for global load balancing and traffic routing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_capacity_drain")

    @auto_capacity_drain.setter
    def auto_capacity_drain(self, value: Optional[pulumi.Input['ServiceLbPoliciesAutoCapacityDrainArgs']]):
        pulumi.set(self, "auto_capacity_drain", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="failoverConfig")
    def failover_config(self) -> Optional[pulumi.Input['ServiceLbPoliciesFailoverConfigArgs']]:
        """
        Option to specify health based failover behavior. This is not related to Network load balancer FailoverPolicy.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_config")

    @failover_config.setter
    def failover_config(self, value: Optional[pulumi.Input['ServiceLbPoliciesFailoverConfigArgs']]):
        pulumi.set(self, "failover_config", value)

    @_builtins.property
    @pulumi.getter(name="isolationConfig")
    def isolation_config(self) -> Optional[pulumi.Input['ServiceLbPoliciesIsolationConfigArgs']]:
        """
        Configuration to provide isolation support for the associated Backend Service.
        Structure is documented below.
        """
        return pulumi.get(self, "isolation_config")

    @isolation_config.setter
    def isolation_config(self, value: Optional[pulumi.Input['ServiceLbPoliciesIsolationConfigArgs']]):
        pulumi.set(self, "isolation_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the ServiceLbPolicy resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingAlgorithm")
    def load_balancing_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of load balancing algorithm to be used. The default behavior is WATERFALL_BY_REGION.
        Possible values are: `SPRAY_TO_REGION`, `SPRAY_TO_WORLD`, `WATERFALL_BY_REGION`, `WATERFALL_BY_ZONE`.
        """
        return pulumi.get(self, "load_balancing_algorithm")

    @load_balancing_algorithm.setter
    def load_balancing_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the ServiceLbPolicy resource. It matches pattern `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ServiceLbPoliciesState:
    def __init__(__self__, *,
                 auto_capacity_drain: Optional[pulumi.Input['ServiceLbPoliciesAutoCapacityDrainArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 failover_config: Optional[pulumi.Input['ServiceLbPoliciesFailoverConfigArgs']] = None,
                 isolation_config: Optional[pulumi.Input['ServiceLbPoliciesIsolationConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceLbPolicies resources.
        :param pulumi.Input['ServiceLbPoliciesAutoCapacityDrainArgs'] auto_capacity_drain: Option to specify if an unhealthy MIG/NEG should be considered for global load balancing and traffic routing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Time the ServiceLbPolicy was created in UTC.
        :param pulumi.Input[_builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['ServiceLbPoliciesFailoverConfigArgs'] failover_config: Option to specify health based failover behavior. This is not related to Network load balancer FailoverPolicy.
               Structure is documented below.
        :param pulumi.Input['ServiceLbPoliciesIsolationConfigArgs'] isolation_config: Configuration to provide isolation support for the associated Backend Service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the ServiceLbPolicy resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_algorithm: The type of load balancing algorithm to be used. The default behavior is WATERFALL_BY_REGION.
               Possible values are: `SPRAY_TO_REGION`, `SPRAY_TO_WORLD`, `WATERFALL_BY_REGION`, `WATERFALL_BY_ZONE`.
        :param pulumi.Input[_builtins.str] location: The location of the service lb policy.
        :param pulumi.Input[_builtins.str] name: Name of the ServiceLbPolicy resource. It matches pattern `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] update_time: Time the ServiceLbPolicy was updated in UTC.
        """
        if auto_capacity_drain is not None:
            pulumi.set(__self__, "auto_capacity_drain", auto_capacity_drain)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if failover_config is not None:
            pulumi.set(__self__, "failover_config", failover_config)
        if isolation_config is not None:
            pulumi.set(__self__, "isolation_config", isolation_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_algorithm is not None:
            pulumi.set(__self__, "load_balancing_algorithm", load_balancing_algorithm)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="autoCapacityDrain")
    def auto_capacity_drain(self) -> Optional[pulumi.Input['ServiceLbPoliciesAutoCapacityDrainArgs']]:
        """
        Option to specify if an unhealthy MIG/NEG should be considered for global load balancing and traffic routing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_capacity_drain")

    @auto_capacity_drain.setter
    def auto_capacity_drain(self, value: Optional[pulumi.Input['ServiceLbPoliciesAutoCapacityDrainArgs']]):
        pulumi.set(self, "auto_capacity_drain", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the ServiceLbPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="failoverConfig")
    def failover_config(self) -> Optional[pulumi.Input['ServiceLbPoliciesFailoverConfigArgs']]:
        """
        Option to specify health based failover behavior. This is not related to Network load balancer FailoverPolicy.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_config")

    @failover_config.setter
    def failover_config(self, value: Optional[pulumi.Input['ServiceLbPoliciesFailoverConfigArgs']]):
        pulumi.set(self, "failover_config", value)

    @_builtins.property
    @pulumi.getter(name="isolationConfig")
    def isolation_config(self) -> Optional[pulumi.Input['ServiceLbPoliciesIsolationConfigArgs']]:
        """
        Configuration to provide isolation support for the associated Backend Service.
        Structure is documented below.
        """
        return pulumi.get(self, "isolation_config")

    @isolation_config.setter
    def isolation_config(self, value: Optional[pulumi.Input['ServiceLbPoliciesIsolationConfigArgs']]):
        pulumi.set(self, "isolation_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the ServiceLbPolicy resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingAlgorithm")
    def load_balancing_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of load balancing algorithm to be used. The default behavior is WATERFALL_BY_REGION.
        Possible values are: `SPRAY_TO_REGION`, `SPRAY_TO_WORLD`, `WATERFALL_BY_REGION`, `WATERFALL_BY_ZONE`.
        """
        return pulumi.get(self, "load_balancing_algorithm")

    @load_balancing_algorithm.setter
    def load_balancing_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the service lb policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the ServiceLbPolicy resource. It matches pattern `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the ServiceLbPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networkservices/serviceLbPolicies:ServiceLbPolicies")
class ServiceLbPolicies(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_capacity_drain: Optional[pulumi.Input[Union['ServiceLbPoliciesAutoCapacityDrainArgs', 'ServiceLbPoliciesAutoCapacityDrainArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 failover_config: Optional[pulumi.Input[Union['ServiceLbPoliciesFailoverConfigArgs', 'ServiceLbPoliciesFailoverConfigArgsDict']]] = None,
                 isolation_config: Optional[pulumi.Input[Union['ServiceLbPoliciesIsolationConfigArgs', 'ServiceLbPoliciesIsolationConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ServiceLbPolicy holds global load balancing and traffic distribution configuration that can be applied to a BackendService.

        To get more information about ServiceLbPolicies, see:

        * [API documentation](https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.serviceLbPolicies)

        ## Example Usage

        ### Network Services Service Lb Policies Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.ServiceLbPolicies("default",
            name="my-lb-policy",
            location="global")
        ```
        ### Network Services Service Lb Policies Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.ServiceLbPolicies("default",
            name="my-lb-policy",
            location="global",
            description="my description",
            load_balancing_algorithm="SPRAY_TO_REGION",
            auto_capacity_drain={
                "enable": True,
            },
            failover_config={
                "failover_health_threshold": 70,
            },
            labels={
                "foo": "bar",
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="my-lb-backend",
            description="my description",
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            protocol="HTTP",
            service_lb_policy=default.id.apply(lambda id: f"//networkservices.googleapis.com/{id}"))
        ```
        ### Network Services Service Lb Policies Beta

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.ServiceLbPolicies("default",
            name="my-lb-policy",
            location="global",
            description="my description",
            load_balancing_algorithm="SPRAY_TO_REGION",
            auto_capacity_drain={
                "enable": True,
            },
            failover_config={
                "failover_health_threshold": 70,
            },
            isolation_config={
                "isolation_granularity": "REGION",
                "isolation_mode": "NEAREST",
            },
            labels={
                "foo": "bar",
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="my-lb-backend",
            description="my description",
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            protocol="HTTP",
            service_lb_policy=default.id.apply(lambda id: f"//networkservices.googleapis.com/{id}"))
        ```

        ## Import

        ServiceLbPolicies can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceLbPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ServiceLbPolicies can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/serviceLbPolicies:ServiceLbPolicies default projects/{{project}}/locations/{{location}}/serviceLbPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/serviceLbPolicies:ServiceLbPolicies default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/serviceLbPolicies:ServiceLbPolicies default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceLbPoliciesAutoCapacityDrainArgs', 'ServiceLbPoliciesAutoCapacityDrainArgsDict']] auto_capacity_drain: Option to specify if an unhealthy MIG/NEG should be considered for global load balancing and traffic routing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Union['ServiceLbPoliciesFailoverConfigArgs', 'ServiceLbPoliciesFailoverConfigArgsDict']] failover_config: Option to specify health based failover behavior. This is not related to Network load balancer FailoverPolicy.
               Structure is documented below.
        :param pulumi.Input[Union['ServiceLbPoliciesIsolationConfigArgs', 'ServiceLbPoliciesIsolationConfigArgsDict']] isolation_config: Configuration to provide isolation support for the associated Backend Service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the ServiceLbPolicy resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_algorithm: The type of load balancing algorithm to be used. The default behavior is WATERFALL_BY_REGION.
               Possible values are: `SPRAY_TO_REGION`, `SPRAY_TO_WORLD`, `WATERFALL_BY_REGION`, `WATERFALL_BY_ZONE`.
        :param pulumi.Input[_builtins.str] location: The location of the service lb policy.
        :param pulumi.Input[_builtins.str] name: Name of the ServiceLbPolicy resource. It matches pattern `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceLbPoliciesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ServiceLbPolicy holds global load balancing and traffic distribution configuration that can be applied to a BackendService.

        To get more information about ServiceLbPolicies, see:

        * [API documentation](https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.serviceLbPolicies)

        ## Example Usage

        ### Network Services Service Lb Policies Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.ServiceLbPolicies("default",
            name="my-lb-policy",
            location="global")
        ```
        ### Network Services Service Lb Policies Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.ServiceLbPolicies("default",
            name="my-lb-policy",
            location="global",
            description="my description",
            load_balancing_algorithm="SPRAY_TO_REGION",
            auto_capacity_drain={
                "enable": True,
            },
            failover_config={
                "failover_health_threshold": 70,
            },
            labels={
                "foo": "bar",
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="my-lb-backend",
            description="my description",
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            protocol="HTTP",
            service_lb_policy=default.id.apply(lambda id: f"//networkservices.googleapis.com/{id}"))
        ```
        ### Network Services Service Lb Policies Beta

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.ServiceLbPolicies("default",
            name="my-lb-policy",
            location="global",
            description="my description",
            load_balancing_algorithm="SPRAY_TO_REGION",
            auto_capacity_drain={
                "enable": True,
            },
            failover_config={
                "failover_health_threshold": 70,
            },
            isolation_config={
                "isolation_granularity": "REGION",
                "isolation_mode": "NEAREST",
            },
            labels={
                "foo": "bar",
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="my-lb-backend",
            description="my description",
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            protocol="HTTP",
            service_lb_policy=default.id.apply(lambda id: f"//networkservices.googleapis.com/{id}"))
        ```

        ## Import

        ServiceLbPolicies can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceLbPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ServiceLbPolicies can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/serviceLbPolicies:ServiceLbPolicies default projects/{{project}}/locations/{{location}}/serviceLbPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/serviceLbPolicies:ServiceLbPolicies default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/serviceLbPolicies:ServiceLbPolicies default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceLbPoliciesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceLbPoliciesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_capacity_drain: Optional[pulumi.Input[Union['ServiceLbPoliciesAutoCapacityDrainArgs', 'ServiceLbPoliciesAutoCapacityDrainArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 failover_config: Optional[pulumi.Input[Union['ServiceLbPoliciesFailoverConfigArgs', 'ServiceLbPoliciesFailoverConfigArgsDict']]] = None,
                 isolation_config: Optional[pulumi.Input[Union['ServiceLbPoliciesIsolationConfigArgs', 'ServiceLbPoliciesIsolationConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceLbPoliciesArgs.__new__(ServiceLbPoliciesArgs)

            __props__.__dict__["auto_capacity_drain"] = auto_capacity_drain
            __props__.__dict__["description"] = description
            __props__.__dict__["failover_config"] = failover_config
            __props__.__dict__["isolation_config"] = isolation_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["load_balancing_algorithm"] = load_balancing_algorithm
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceLbPolicies, __self__).__init__(
            'gcp:networkservices/serviceLbPolicies:ServiceLbPolicies',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_capacity_drain: Optional[pulumi.Input[Union['ServiceLbPoliciesAutoCapacityDrainArgs', 'ServiceLbPoliciesAutoCapacityDrainArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            failover_config: Optional[pulumi.Input[Union['ServiceLbPoliciesFailoverConfigArgs', 'ServiceLbPoliciesFailoverConfigArgsDict']]] = None,
            isolation_config: Optional[pulumi.Input[Union['ServiceLbPoliciesIsolationConfigArgs', 'ServiceLbPoliciesIsolationConfigArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            load_balancing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceLbPolicies':
        """
        Get an existing ServiceLbPolicies resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceLbPoliciesAutoCapacityDrainArgs', 'ServiceLbPoliciesAutoCapacityDrainArgsDict']] auto_capacity_drain: Option to specify if an unhealthy MIG/NEG should be considered for global load balancing and traffic routing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Time the ServiceLbPolicy was created in UTC.
        :param pulumi.Input[_builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['ServiceLbPoliciesFailoverConfigArgs', 'ServiceLbPoliciesFailoverConfigArgsDict']] failover_config: Option to specify health based failover behavior. This is not related to Network load balancer FailoverPolicy.
               Structure is documented below.
        :param pulumi.Input[Union['ServiceLbPoliciesIsolationConfigArgs', 'ServiceLbPoliciesIsolationConfigArgsDict']] isolation_config: Configuration to provide isolation support for the associated Backend Service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the ServiceLbPolicy resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_algorithm: The type of load balancing algorithm to be used. The default behavior is WATERFALL_BY_REGION.
               Possible values are: `SPRAY_TO_REGION`, `SPRAY_TO_WORLD`, `WATERFALL_BY_REGION`, `WATERFALL_BY_ZONE`.
        :param pulumi.Input[_builtins.str] location: The location of the service lb policy.
        :param pulumi.Input[_builtins.str] name: Name of the ServiceLbPolicy resource. It matches pattern `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] update_time: Time the ServiceLbPolicy was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceLbPoliciesState.__new__(_ServiceLbPoliciesState)

        __props__.__dict__["auto_capacity_drain"] = auto_capacity_drain
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["failover_config"] = failover_config
        __props__.__dict__["isolation_config"] = isolation_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load_balancing_algorithm"] = load_balancing_algorithm
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        return ServiceLbPolicies(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoCapacityDrain")
    def auto_capacity_drain(self) -> pulumi.Output[Optional['outputs.ServiceLbPoliciesAutoCapacityDrain']]:
        """
        Option to specify if an unhealthy MIG/NEG should be considered for global load balancing and traffic routing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_capacity_drain")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the ServiceLbPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="failoverConfig")
    def failover_config(self) -> pulumi.Output[Optional['outputs.ServiceLbPoliciesFailoverConfig']]:
        """
        Option to specify health based failover behavior. This is not related to Network load balancer FailoverPolicy.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_config")

    @_builtins.property
    @pulumi.getter(name="isolationConfig")
    def isolation_config(self) -> pulumi.Output[Optional['outputs.ServiceLbPoliciesIsolationConfig']]:
        """
        Configuration to provide isolation support for the associated Backend Service.
        Structure is documented below.
        """
        return pulumi.get(self, "isolation_config")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of label tags associated with the ServiceLbPolicy resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loadBalancingAlgorithm")
    def load_balancing_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of load balancing algorithm to be used. The default behavior is WATERFALL_BY_REGION.
        Possible values are: `SPRAY_TO_REGION`, `SPRAY_TO_WORLD`, `WATERFALL_BY_REGION`, `WATERFALL_BY_ZONE`.
        """
        return pulumi.get(self, "load_balancing_algorithm")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the service lb policy.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the ServiceLbPolicy resource. It matches pattern `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the ServiceLbPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

